functor X86RegAlloc
    (structure I : INSTRUCTIONS where C = X86Cells
     structure P : INSN_PROPERTIES where I = I
     structure F : FLOWGRAPH where I = I
     structure Asm : INSTRUCTION_EMITTER where I = I and P = F.P
    ) : 
  sig

    functor IntRa (structure RaUser : RA_USER_PARAMS 
		     where I = I
		     and B = F.B) : RA

    functor FloatRa (structure RaUser : RA_USER_PARAMS 
		     where I = I
		     and B = F.B) : RA
  end =
struct
  structure C = I.C

    (* liveness analysis for general purpose registers *)
  structure RegLiveness =
    Liveness(structure Flowgraph=F
	     structure Instruction=I
	     val defUse = P.defUse C.GP
	     val regSet = C.getCell C.GP
	     val cellset = C.updateCell C.GP)


  (* integer register allocator *)
  functor IntRa = 
      RegAllocator
	 (structure RaArch = struct

	     structure InsnProps = P
	     structure AsmEmitter = Asm
	     structure I = I
	     structure Liveness=RegLiveness
	     val defUse = P.defUse C.GP
	     val firstPseudoR = 32
	     val maxPseudoR = X86Cells.maxCell
	     val numRegs = X86Cells.numCell C.GP
	     val regSet = C.getCell C.GP
	  end)



  (* liveness analysis for floating point registers *)
  structure FregLiveness = 
    Liveness(structure Flowgraph=F
	     structure Instruction=I
	     val defUse = P.defUse C.FP
	     val regSet = C.getCell C.FP
	     val cellset = C.updateCell C.FP)

  (* floating register allocator *)
  functor FloatRa = 
    RegAllocator
       (structure RaArch = struct

          structure InsnProps = P
	  structure AsmEmitter = Asm
	  structure Liveness=FregLiveness
	  structure I = I

	  val defUse = P.defUse C.FP
	  val firstPseudoR = 64
	  val maxPseudoR = X86Cells.maxCell
	  val numRegs = X86Cells.numCell C.FP
	  val regSet = C.getCell C.FP
	end)
end
