<?php
/**
 * Internationalisation file for the TreeAndMenu extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/** English */
$messages['en'] = array(
	'treeandmenu-desc' => "Adds <code><nowiki>#tree</nowiki></code> and <code><nowiki>#menu</nowiki></code> parser functions which contain bullet-lists to be rendered as collapsible treeviews or dropdown menus.
The treeviews use the [http://www.destroydrop.com/javascripts/tree dTree] JavaScript tree menu, and the dropdown menus use [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]",
);

/** Message documentation (Message documentation)
 * @author Purodha
 */
$messages['qqq'] = array(
	'treeandmenu-desc' => '{{desc}}',
);

/** Asturian (asturianu)
 * @author Xuacu
 */
$messages['ast'] = array(
	'treeandmenu-desc' => "Amiesta les funciones d'analís <code><nowiki>#tree</nowiki></code> y <code><nowiki>#menu</nowiki></code>, que contienen llistes con asteriscos qu'apaecerán como vistes d'árbol contraíbles o menús estenderexables.
Les vistes d'árbol usen el menú d'árbol JavaScript [http://www.destroydrop.com/javascripts/tree dTree], y los menús estenderexables usen [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]",
);

/** Belarusian (Taraškievica orthography) (‪беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Renessaince
 */
$messages['be-tarask'] = array(
	'treeandmenu-desc' => 'Дадае функцыі парсэру <code><nowiki>#tree</nowiki></code> і <code><nowiki>#menu</nowiki></code>, якія зьмяшчаюць маркіраваныя сьпісы, што могуць выводзіцца як разгортваемыя дрэвы або выпадаючыя мэню.
Разгортваемыя дрэвы выкарыстоўваюць JavaScript [http://www.destroydrop.com/javascripts/tree dTree], а выпадаючыя мэню — [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'treeandmenu-desc' => 'Fügt die Parserfunktionen <code><nowiki>#tree</nowiki></code> und <code><nowiki>#menu</nowiki></code> hinzu, die Aufzählungslisten in Form einer Baumansicht ein- und ausklappbar machen oder als Aufklappmenü darstellen können.
Die Baumansicht nutzt hierzu [http://www.destroydrop.com/javascripts/tree dTree] sowie das Aufklappmenü [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Lower Sorbian (dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'treeandmenu-desc' => 'Pśidawa parserowe funkcije <code><nowiki>#tree</nowiki></code> a <code><nowiki>#menu</nowiki></code>, kótarež zwobraznjaju nalicenja ako złožujobne bomowe naglědy abo padajuce menije.
Bomowe naglědy wužywaju JavaScriptowy bomowy meni [http://www.destroydrop.com/javascripts/tree dTree] a padajuce menije wužywaju [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Spanish (español)
 * @author Armando-Martin
 */
$messages['es'] = array(
	'treeandmenu-desc' => 'Añade las funciones del analizador (parser) <code><nowiki>#tree</nowiki></code> y <code><nowiki>#menu</nowiki></code>, que contienen listas con viñetass que se renderizarán como árboles contraíbles o menús desplegables.
Los árboles emplean un menú de [http://www.destroydrop.com/javascripts/árbol dTree] de JavaScript y los menús desplegables utilizan [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** French (français)
 * @author Gomoko
 */
$messages['fr'] = array(
	'treeandmenu-desc' => "Ajoute les fonctions d'analyse <code><nowiki>#tree</nowiki></code> et <code><nowiki>#menu</nowiki></code> qui permettent aux listes à puces d'être rendues comme des arbres pliables ou des menus déroulants.
Les arbres pliables utilisent le menu par arbre JavaScript [http://www.destroydrop.com/javascripts/tree dTree], et les menus déroulants utilisent [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]",
);

/** Galician (galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'treeandmenu-desc' => 'Endade as funcións analíticas <code><nowiki>#tree</nowiki></code> e <code><nowiki>#menu</nowiki></code>, que conteñen listas con asteriscos que se renderizarán como árbores contraíbles ou menús despregables.
As árbores empregan o menú de árbore [http://www.destroydrop.com/javascripts/tree dTree] do JavaScript e os menús despregables usan [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'treeandmenu-desc' => 'הוספת פונקציות המפענח <code dir="ltr"><nowiki>#tree</nowiki></code> ו־<code dir="ltr"><nowiki>#menu</nowiki></code> שמכילות רשימות תבליטים שיוצגו כעצים שאפשר לקפל או תפריטים נפתחים.
תצוגת העץ משתמשת בתפריט [http://www.destroydrop.com/javascripts/tree dTree] והפתריטים המפתחים משתמשים ב־[http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Upper Sorbian (hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'treeandmenu-desc' => 'Přidawa parserowe funkcije <code><nowiki>#tree</nowiki></code> a <code><nowiki>#menu</nowiki></code>, kotrež naličenja jako fałdujomne štomowe napohlady abo padace menije zwobraznjeja.
Štomowe napohlady wužiwaja JavaScriptowy štomowy meni [http://www.destroydrop.com/javascripts/tree dTree] a padace menije wužiwaja [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Interlingua (interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'treeandmenu-desc' => 'Adde le functiones analysator <code><nowiki>#tree</nowiki></code> e <code><nowiki>#menu</nowiki></code> le quales contine listas a punctos a presentar como vistas arborescente plicabile o menus disrolante.
Le vistas arborescente usa le menu JavaScript arborescente [http://www.destroydrop.com/javascripts/tree dTree], e le menus disrolante usa [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Italian (italiano)
 * @author Beta16
 * @author Ximo17
 */
$messages['it'] = array(
	'treeandmenu-desc' => 'Aggiunge le funzioni parser <code><nowiki>#tree</nowiki></code> e <code><nowiki>#menu</nowiki></code> che permettono di visualizzare gli elenchi puntati come menù ad albero o a discesa.
Per i menù ad albero utilizza il menù [http://www.destroydrop.com/javascripts/tree dTree] di JavaScript, mentre per i menù a tendina utilizza [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Korean (한국어)
 * @author 아라
 */
$messages['ko'] = array(
	'treeandmenu-desc' => '축소 가능한 트리보기 또는 드롭 다운 메뉴로 표시하는 순서 없는 목록을 포함하는 <code><nowiki>#tree</nowiki></code>와 <code><nowiki>#menu</nowiki></code> 파서 함수를 추가.
트리 보기는 [http://www.destroydrop.com/javascripts/tree dTree] 자바 스크립트 메뉴를 사용하고 드롭 다운 메뉴는 [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]를 사용합니다.',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 */
$messages['ksh'] = array(
	'treeandmenu-desc' => 'Deiht de Paaserfunkßjuhne <code lang="en">#tree</code> un <code lang="en">#menu</code> en et Wiki, woh mer Leste met Punkte als op- un zohklappbaa Bäum udder als Ußwahlleste zom erongerträcke aanzeije lohße kann.
De Bäum bruche et <i lang="en">[http://www.destroydrop.com/javascripts/tree dTree]</i>-JavaSkrepp, un de Ußwahlleste zom erongerträcke bruche dä <i lang="en">[http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]</i>.',
);

/** Macedonian (македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'treeandmenu-desc' => 'Додава парсерски функции <code><nowiki>#tree</nowiki></code> и <code><nowiki>#menu</nowiki></code> што содржат списоци со потточки што ќе се прикажат како расклопни разгранети претстави или паѓачки менија or dropdown menus.
Разгранетите претстави го користат стеблото [http://www.destroydrop.com/javascripts/tree dTree] од JavaScript, а паѓачките менија користат [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 */
$messages['ms'] = array(
	'treeandmenu-desc' => 'Membubuh fungsi penghurai <code><nowiki>#tree</nowiki></code> dan <code><nowiki>#menu</nowiki></code> yang mengandungi senarai berbulet untuk dipaparkan dalam bentuk paparan pepohon boleh lipat atau juntai bawah.
Paparan pepohon menggunakan menu pepohon JavaScript [http://www.destroydrop.com/javascripts/tree dTree], sementara menu juntai bawah menggunakan [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Norwegian Bokmål (‪norsk (bokmål)‬)
 * @author Event
 */
$messages['nb'] = array(
	'treeandmenu-desc' => 'Legger til <code><nowiki>#tree-</nowiki></code> og <code><nowiki>#menu-</nowiki></code>parser-funksjoner som inneholder punktlister som fremstilles som sammenleggbare trevisninger eller nedtrekksmenyer.
Trevisningene bruker [http://www.destroydrop.com/javascripts/tree dTree] JavaScript-tremenyen, mens nedtrekksmenyen bruker [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Dutch (Nederlands)
 * @author Siebrand
 */
$messages['nl'] = array(
	'treeandmenu-desc' => "Voegt de parserfuncties <code><nowiki>#tree</nowiki></code> en <code><nowiki>#menu</nowiki></code> toe die ervoor zorgen dat ongenummerde lijsten worden weergegeven als inklapbare boomstructuren of dropdownmenu's.
Hiervoor worden de componenten [http://www.destroydrop.com/javascripts/tree dTree] en [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish] gebruikt",
);

/** Polish (polski)
 * @author BeginaFelicysym
 */
$messages['pl'] = array(
	'treeandmenu-desc' => 'Dodaje funkcje analizator składni <code><nowiki>#tree</nowiki></code> i <code><nowiki>#menu</nowiki></code>, które zawierają listy punktowane do wyświetlenia jako zwijanej drzewidoki lub menu rozwijane.
Drzewidoki używają generowanych przez JavaScript menu drzewiastych [http://www.destroydrop.com/javascripts/tree dTree], a menu rozwijane wykorzystują [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'treeandmenu-desc' => "A gionta le funsion d'anàlisi <code><nowiki>#tree</nowiki></code> e <code><nowiki>#menu</nowiki></code> ch'a conten-o liste ëd boton da visualisé com erbo strenzìbij o liste a ridò.
J'erbo a deuvro ël la lista për erbo JavaScript [http://www.destroydrop.com/javascripts/tree dTree], e le liste a ridò a deuvro [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]",
);

/** Portuguese (português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'treeandmenu-desc' => 'Adiciona as funções do analisador sintáctico <code><nowiki>#tree</nowiki></code> e <code><nowiki>#menu</nowiki></code>, que contêm listas com marcadores, para serem apresentadas na forma de árvore recolhível ou menus descendentes.
As árvores usam o menu árvore [http://www.destroydrop.com/javascripts/tree dTree] do JavaScript e os menus descendentes usam [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Russian (русский)
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'treeandmenu-desc' => 'Добавляет функции парсера <code><nowiki>#tree</nowiki></code> и <code><nowiki>#menu</nowiki></code>, позволяющие выводить списки как раскрываемые деревья или выпадающие меню.
Для раскрывающихся деревьев используется JavaScript-скрипт [http://www.destroydrop.com/javascripts/tree dTree], для выпадающих меню — [http://www.htmldog.com/articles/suckerfish/dropdowns/ Son of Suckerfish]',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'treeandmenu-desc' => 'Nagdaragdag ng mga tungkuling pambanghay na <code><nowiki>#tree</nowiki></code> at <code><nowiki>#menu</nowiki></code> na naglalaman ng mga listahang napupungluan na ihaharap bilang isang nababaklas na mga tanawin ng puno o mga menu naibabagsak na paibaba.
Ang mga tanawin ng puno ay gumagamit ng [http://www.destroydrop.com/javascripts/tree dTree] ng menu ng puno ng JavaScript, at ang mga menung naibabagsak paibaba ay gumagamit ng [http://www.htmldog.com/articles/suckerfish/dropdowns/ Anak na Lalaki ng Suckerfish]',
);

