# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_renderer import OpenGLRenderer


class VRRenderer(OpenGLRenderer):
    r"""
    VRRenderer - VR renderer
    
    Superclass: OpenGLRenderer
    
    VRRenderer is an abstract Renderer class that is meant to be
    used in VR context. It defines a floor actor with a grid fading with
    the distance.
    
    Subclasses must define make_camera()
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVRRenderer, obj, update, **traits)
    
    def _get_show_floor(self):
        return self._vtk_obj.GetShowFloor()
    def _set_show_floor(self, arg):
        old_val = self._get_show_floor()
        self._wrap_call(self._vtk_obj.SetShowFloor,
                        arg)
        self.trait_property_changed('show_floor', old_val, arg)
    show_floor = traits.Property(_get_show_floor, _set_show_floor, desc=\
        r"""
        
        """
    )

    def get_floor_transform(self, *args):
        """
        get_floor_transform(self, transform:Transform) -> None
        C++: virtual void get_floor_transform(Transform *transform)
        Store in transform the floor transform.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetFloorTransform, *my_args)
        return ret

    _updateable_traits_ = \
    (('use_spherical_harmonics', 'GetUseSphericalHarmonics'),
    ('automatic_light_creation', 'GetAutomaticLightCreation'),
    ('backing_store', 'GetBackingStore'), ('draw', 'GetDraw'), ('erase',
    'GetErase'), ('interactive', 'GetInteractive'),
    ('light_follow_camera', 'GetLightFollowCamera'),
    ('preserve_color_buffer', 'GetPreserveColorBuffer'),
    ('preserve_depth_buffer', 'GetPreserveDepthBuffer'), ('ssao_blur',
    'GetSSAOBlur'), ('textured_background', 'GetTexturedBackground'),
    ('two_sided_lighting', 'GetTwoSidedLighting'),
    ('use_depth_peeling_for_volumes', 'GetUseDepthPeelingForVolumes'),
    ('use_depth_peeling', 'GetUseDepthPeeling'), ('use_fxaa',
    'GetUseFXAA'), ('use_hidden_line_removal', 'GetUseHiddenLineRemoval'),
    ('use_image_based_lighting', 'GetUseImageBasedLighting'), ('use_ssao',
    'GetUseSSAO'), ('use_shadows', 'GetUseShadows'),
    ('gradient_background', 'GetGradientBackground'),
    ('gradient_environmental_bg', 'GetGradientEnvironmentalBG'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('allocated_render_time', 'GetAllocatedRenderTime'), ('ambient',
    'GetAmbient'), ('clipping_range_expansion',
    'GetClippingRangeExpansion'), ('environment_right',
    'GetEnvironmentRight'), ('environment_up', 'GetEnvironmentUp'),
    ('layer', 'GetLayer'), ('maximum_number_of_peels',
    'GetMaximumNumberOfPeels'), ('near_clipping_plane_tolerance',
    'GetNearClippingPlaneTolerance'), ('occlusion_ratio',
    'GetOcclusionRatio'), ('ssao_bias', 'GetSSAOBias'),
    ('ssao_kernel_size', 'GetSSAOKernelSize'), ('ssao_radius',
    'GetSSAORadius'), ('aspect', 'GetAspect'), ('background',
    'GetBackground'), ('background2', 'GetBackground2'),
    ('background_alpha', 'GetBackgroundAlpha'), ('display_point',
    'GetDisplayPoint'), ('environmental_bg', 'GetEnvironmentalBG'),
    ('environmental_bg2', 'GetEnvironmentalBG2'), ('pixel_aspect',
    'GetPixelAspect'), ('view_point', 'GetViewPoint'), ('viewport',
    'GetViewport'), ('world_point', 'GetWorldPoint'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic_light_creation', 'backing_store', 'debug', 'draw',
    'erase', 'global_warning_display', 'gradient_background',
    'gradient_environmental_bg', 'interactive', 'light_follow_camera',
    'preserve_color_buffer', 'preserve_depth_buffer', 'ssao_blur',
    'textured_background', 'two_sided_lighting', 'use_depth_peeling',
    'use_depth_peeling_for_volumes', 'use_fxaa',
    'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
    'use_spherical_harmonics', 'use_ssao', 'allocated_render_time',
    'ambient', 'aspect', 'background', 'background2', 'background_alpha',
    'clipping_range_expansion', 'display_point', 'environment_right',
    'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
    'maximum_number_of_peels', 'near_clipping_plane_tolerance',
    'object_name', 'occlusion_ratio', 'pixel_aspect', 'ssao_bias',
    'ssao_kernel_size', 'ssao_radius', 'view_point', 'viewport',
    'world_point'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(VRRenderer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit VRRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic_light_creation', 'backing_store', 'draw', 'erase',
            'gradient_background', 'gradient_environmental_bg', 'interactive',
            'light_follow_camera', 'preserve_color_buffer',
            'preserve_depth_buffer', 'ssao_blur', 'textured_background',
            'two_sided_lighting', 'use_depth_peeling',
            'use_depth_peeling_for_volumes', 'use_fxaa',
            'use_hidden_line_removal', 'use_image_based_lighting', 'use_shadows',
            'use_spherical_harmonics', 'use_ssao'], [], ['allocated_render_time',
            'ambient', 'aspect', 'background', 'background2', 'background_alpha',
            'clipping_range_expansion', 'display_point', 'environment_right',
            'environment_up', 'environmental_bg', 'environmental_bg2', 'layer',
            'maximum_number_of_peels', 'near_clipping_plane_tolerance',
            'object_name', 'occlusion_ratio', 'pixel_aspect', 'ssao_bias',
            'ssao_kernel_size', 'ssao_radius', 'view_point', 'viewport',
            'world_point']),
            title='Edit VRRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit VRRenderer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

