# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.linear_transform import LinearTransform


class Transform(LinearTransform):
    r"""
    Transform - describes linear transformations via a 4x4 matrix
    
    Superclass: LinearTransform
    
    A Transform can be used to describe the full range of linear (also
    known as affine) coordinate transformations in three dimensions,
    which are internally represented as a 4x4 homogeneous transformation
    matrix.  When you create a new Transform, it is always initialized
    to the identity transformation.
    
    The set_input() method allows you to set another transform, instead of
    the identity transform, to be the base transformation. There is a
    pipeline mechanism to ensure that when the input is modified, the
    current transformation will be updated accordingly. This pipeline
    mechanism is also supported by the Concatenate() method.
    
    Most of the methods for manipulating this transformation, e.g.
    Translate, Rotate, and Concatenate, can operate in either pre_multiply
    (the default) or post_multiply mode.  In pre_multiply mode, the
    translation, concatenation, etc. will occur before any
    transformations which are represented by the current matrix.  In
    post_multiply mode, the additional transformation will occur after any
    transformations represented by the current matrix.
    
    This class performs all of its operations in a right handed
    coordinate system with right handed rotations. Some other graphics
    libraries use left handed coordinate systems and rotations.
    @sa
    PerspectiveTransform GeneralTransform Matrix4x4
    TransformCollection TransformFilter TransformPolyDataFilter
    ImageReslice
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTransform, obj, update, **traits)
    
    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    def _set_input(self, arg):
        old_val = self._get_input()
        self._wrap_call(self._vtk_obj.SetInput,
                        deref_vtk(arg))
        self.trait_property_changed('input', old_val, arg)
    input = traits.Property(_get_input, _set_input, desc=\
        r"""
        
        """
    )

    def get_inverse(self, *args):
        """
        get_inverse(self, inverse:Matrix4x4) -> None
        C++: void get_inverse(Matrix4x4 *inverse)
        get_inverse(self) -> AbstractTransform
        C++: AbstractTransform *get_inverse()
        Return a matrix which is the inverse of the current
        transformation matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetInverse, *my_args)
        return wrap_vtk(ret)

    def set_inverse(self, *args):
        """
        set_inverse(self, transform:AbstractTransform) -> None
        C++: void set_inverse(AbstractTransform *transform)
        Set a transformation that this transform will be the inverse of.
        This transform will automatically update to agree with the
        inverse transform that you set.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInverse, *my_args)
        return ret

    def get_matrix(self, *args):
        """
        get_matrix(self, m:Matrix4x4) -> None
        C++: void get_matrix(Matrix4x4 *m)
        get_matrix(self) -> Matrix4x4
        C++: Matrix4x4 *get_matrix()
        Get a copy of the internal transformation matrix.  The transform
        is Updated first, to guarantee that the matrix is valid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMatrix, *my_args)
        return wrap_vtk(ret)

    def set_matrix(self, *args):
        """
        set_matrix(self, matrix:Matrix4x4) -> None
        C++: void set_matrix(Matrix4x4 *matrix)
        set_matrix(self, elements:(float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float)) -> None
        C++: void set_matrix(const double elements[16])
        Set the current matrix directly. Note: First, the current matrix
        is set to the identity, then the input matrix is concatenated.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMatrix, *my_args)
        return ret

    def get_concatenated_transform(self, *args):
        """
        get_concatenated_transform(self, i:int) -> LinearTransform
        C++: LinearTransform *get_concatenated_transform(int i)
        Get one of the concatenated transformations as a
        AbstractTransform. These transformations are applied, in
        series, every time the transformation of a coordinate occurs. 
        This method is provided to make it possible to decompose a
        transformation into its constituents, for example to save a
        transformation to a file.
        """
        ret = self._wrap_call(self._vtk_obj.GetConcatenatedTransform, *args)
        return wrap_vtk(ret)

    def _get_inverse_flag(self):
        return self._vtk_obj.GetInverseFlag()
    inverse_flag = traits.Property(_get_inverse_flag, desc=\
        r"""
        Get the inverse flag of the transformation.  This controls
        whether it is the Input or the inverse of the Input that is used
        as the base transformation.  The inverse_flag is flipped every
        time Inverse() is called.  The inverse_flag is off when a
        transform is first created.
        """
    )

    def _get_number_of_concatenated_transforms(self):
        return self._vtk_obj.GetNumberOfConcatenatedTransforms()
    number_of_concatenated_transforms = traits.Property(_get_number_of_concatenated_transforms, desc=\
        r"""
        Get the total number of transformations that are linked into this
        one via Concatenate() operations or via set_input().
        """
    )

    def _get_orientation(self):
        return self._vtk_obj.GetOrientation()
    orientation = traits.Property(_get_orientation, desc=\
        r"""
        Get the x, y, z orientation angles from the transformation matrix
        as an array of three floating point values.
        """
    )

    def get_orientation(self, *args):
        """
        get_orientation(self, orient:[float, float, float]) -> None
        C++: void get_orientation(double orient[3])
        get_orientation(self) -> (float, float, float)
        C++: double *get_orientation()
        get_orientation(orient:[float, float, float], matrix:Matrix4x4)
            -> None
        C++: static void get_orientation(double orient[3],
            Matrix4x4 *matrix)
        Get the x, y, z orientation angles from the transformation matrix
        as an array of three floating point values.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetOrientation, *my_args)
        return ret

    def _get_orientation_wxyz(self):
        return self._vtk_obj.GetOrientationWXYZ()
    orientation_wxyz = traits.Property(_get_orientation_wxyz, desc=\
        r"""
        Return the wxyz angle+axis representing the current orientation.
        The angle is in degrees and the axis is a unit vector.
        """
    )

    def get_orientation_wxyz(self, *args):
        """
        get_orientation_wxyz(self, wxyz:[float, float, float, float])
            -> None
        C++: void get_orientation_wxyz(double wxyz[4])
        get_orientation_wxyz(self) -> (float, float, float, float)
        C++: double *get_orientation_wxyz()
        Return the wxyz angle+axis representing the current orientation.
        The angle is in degrees and the axis is a unit vector.
        """
        ret = self._wrap_call(self._vtk_obj.GetOrientationWXYZ, *args)
        return ret

    def _get_position(self):
        return self._vtk_obj.GetPosition()
    position = traits.Property(_get_position, desc=\
        r"""
        Return the position from the current transformation matrix as an
        array of three floating point numbers. This is simply returning
        the translation component of the 4x4 matrix.
        """
    )

    def get_position(self, *args):
        """
        get_position(self, pos:[float, float, float]) -> None
        C++: void get_position(double pos[3])
        get_position(self) -> (float, float, float)
        C++: double *get_position()
        Return the position from the current transformation matrix as an
        array of three floating point numbers. This is simply returning
        the translation component of the 4x4 matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetPosition, *args)
        return ret

    def _get_scale(self):
        return self._vtk_obj.GetScale()
    scale = traits.Property(_get_scale, desc=\
        r"""
        Return the scale factors of the current transformation matrix as
        an array of three float numbers.  These scale factors are not
        necessarily about the x, y, and z axes unless unless the scale
        transformation was applied before any rotations.
        """
    )

    def get_scale(self, *args):
        """
        get_scale(self, scale:[float, float, float]) -> None
        C++: void get_scale(double scale[3])
        get_scale(self) -> (float, float, float)
        C++: double *get_scale()
        Return the scale factors of the current transformation matrix as
        an array of three float numbers.  These scale factors are not
        necessarily about the x, y, and z axes unless unless the scale
        transformation was applied before any rotations.
        """
        ret = self._wrap_call(self._vtk_obj.GetScale, *args)
        return ret

    def get_transpose(self, *args):
        """
        get_transpose(self, transpose:Matrix4x4) -> None
        C++: void get_transpose(Matrix4x4 *transpose)
        Return a matrix which is the transpose of the current
        transformation matrix.  This is equivalent to the inverse if and
        only if the transformation is a pure rotation with no translation
        or scale.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTranspose, *my_args)
        return ret

    def concatenate(self, *args):
        """
        concatenate(self, matrix:Matrix4x4) -> None
        C++: void concatenate(Matrix4x4 *matrix)
        concatenate(self, elements:(float, float, float, float, float,
            float, float, float, float, float, float, float, float, float,
             float, float)) -> None
        C++: void concatenate(const double elements[16])
        concatenate(self, transform:LinearTransform) -> None
        C++: void concatenate(LinearTransform *transform)
        Concatenates the matrix with the current transformation according
        to pre_multiply or post_multiply semantics.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Concatenate, *my_args)
        return ret

    def identity(self):
        """
        identity(self) -> None
        C++: void identity()
        Set the transformation to the identity transformation.  If the
        transform has an Input, then the transformation will be reset so
        that it is the same as the Input.
        """
        ret = self._vtk_obj.Identity()
        return ret
        

    def multiply_point(self, *args):
        """
        multiply_point(self, in_:(float, float, float, float), out:[float,
            float, float, float]) -> None
        C++: void multiply_point(const double in[4], double out[4])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyPoint, *args)
        return ret

    def pop(self):
        """
        pop(self) -> None
        C++: void pop()
        Deletes the transformation on the top of the stack and sets the
        top to the next transformation on the stack.
        """
        ret = self._vtk_obj.Pop()
        return ret
        

    def post_multiply(self):
        """
        post_multiply(self) -> None
        C++: void post_multiply()
        Sets the internal state of the transform to post_multiply. All
        subsequent operations will occur after those already represented
        in the current transformation.  In homogeneous matrix notation, M
        = A*M where M is the current transformation matrix and A is the
        applied matrix. The default is pre_multiply.
        """
        ret = self._vtk_obj.PostMultiply()
        return ret
        

    def pre_multiply(self):
        """
        pre_multiply(self) -> None
        C++: void pre_multiply()
        Sets the internal state of the transform to pre_multiply. All
        subsequent operations will occur before those already represented
        in the current transformation.  In homogeneous matrix notation, M
        = M*A where M is the current transformation matrix and A is the
        applied matrix. The default is pre_multiply.
        """
        ret = self._vtk_obj.PreMultiply()
        return ret
        

    def push(self):
        """
        push(self) -> None
        C++: void push()
        Pushes the current transformation onto the transformation stack.
        """
        ret = self._vtk_obj.Push()
        return ret
        

    def rotate_wxyz(self, *args):
        """
        rotate_wxyz(self, angle:float, x:float, y:float, z:float) -> None
        C++: void rotate_wxyz(double angle, double x, double y, double z)
        rotate_wxyz(self, angle:float, axis:(float, float, float)) -> None
        C++: void rotate_wxyz(double angle, const double axis[3])
        Create a rotation matrix and concatenate it with the current
        transformation according to pre_multiply or post_multiply
        semantics. The angle is in degrees, and (x,y,z) specifies the
        axis that the rotation will be performed around.
        """
        ret = self._wrap_call(self._vtk_obj.RotateWXYZ, *args)
        return ret

    def rotate_x(self, *args):
        """
        rotate_x(self, angle:float) -> None
        C++: void rotate_x(double angle)
        Create a rotation matrix about the X, Y, or Z axis and
        concatenate it with the current transformation according to
        pre_multiply or post_multiply semantics.  The angle is expressed in
        degrees.
        """
        ret = self._wrap_call(self._vtk_obj.RotateX, *args)
        return ret

    def rotate_y(self, *args):
        """
        rotate_y(self, angle:float) -> None
        C++: void rotate_y(double angle)"""
        ret = self._wrap_call(self._vtk_obj.RotateY, *args)
        return ret

    def rotate_z(self, *args):
        """
        rotate_z(self, angle:float) -> None
        C++: void rotate_z(double angle)"""
        ret = self._wrap_call(self._vtk_obj.RotateZ, *args)
        return ret

    def scale(self, *args):
        """
        scale(self, x:float, y:float, z:float) -> None
        C++: void scale(double x, double y, double z)
        scale(self, s:(float, float, float)) -> None
        C++: void scale(const double s[3])
        Create a scale matrix (i.e. set the diagonal elements to x, y, z)
        and concatenate it with the current transformation according to
        pre_multiply or post_multiply semantics.
        """
        ret = self._wrap_call(self._vtk_obj.Scale, *args)
        return ret

    def translate(self, *args):
        """
        translate(self, x:float, y:float, z:float) -> None
        C++: void translate(double x, double y, double z)
        translate(self, x:(float, float, float)) -> None
        C++: void translate(const double x[3])
        Create a translation matrix and concatenate it with the current
        transformation according to pre_multiply or post_multiply
        semantics.
        """
        ret = self._wrap_call(self._vtk_obj.Translate, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Transform, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Transform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit Transform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Transform properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

