# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class RedistributeDataSetFilter(DataObjectAlgorithm):
    r"""
    RedistributeDataSetFilter - redistributes input dataset into
    requested number of partitions
    
    Superclass: DataObjectAlgorithm
    
    RedistributeDataSetFilter is intended for redistributing data in a
    load balanced fashion. The load balancing attempts to balance the
    number of cells per target partition approximately. It uses a
    DIY-based kdtree implementation that builds balances the cell centers
    among requested number of partitions. Current implementation only
    supports power-of-2 target partition. If a non-power of two value is
    specified for `number_of_partitions`, then the load balancing simply
    uses the power-of-two greater than the requested value. The bounding
    boxes for the kdtree leaf nodes are then used to redistribute the
    data.
    
    Alternatively a collection of bounding boxes may be provided that can
    be used to distribute the data instead of computing them (see
    `use_explicit_cuts` and `set_explicit_cuts`). When explicit cuts are
    specified, it is possible use those cuts strictly or to expand boxes
    on the edge to fit the domain of the input dataset. This can be
    controlled by `expand_explicit_cuts_for_input_domain`.
    
    The filter allows users to pick how cells along the boundary of the
    cuts either automatically generated or explicitly specified are to be
    distributed using `boundary_mode`. One can choose to assign those
    cells uniquely to one of those regions or duplicate then on all
    regions or split the cells (using TableBasedClipDataSet filter).
    When cells are duplicated along the boundary,  the filter will mark
    the duplicated cells as `vtkdata_set_attributes::DUPLICATECELL`
    correctly on all but one of the partitions using the ghost cell array
    (@sa `vtkdata_set_attributes::ghost_array_name`).
    
    Besides redistributing the data, the filter can optionally generate
    global cell ids. This is provided since it relative easy to generate
    these on when it is known that the data is spatially partitioned as
    is the case after this filter has executed.
    
    @section RedistributeDataSetFilter-SupportedDataTypes  Supported
    Data Types
    
    RedistributeDataSetFilter is primarily intended for unstructured
    datasets i.e. UnstructuredGrid, PolyData and composite datasets
    comprising of the same. It will work when applied to structured
    datasets as well, however, it results in conversion of the dataset to
    an unstructured grid -- which is often not suitable. Also, other
    redistribution and load balancing strategies can be applied to
    structured data which may be more efficient and hence should be
    preferred over using this filter.
    
    For composite datasets, the filter supports `vtkpartitioned_data_set`
    and `vtkpartitioned_data_set_collection`. When input is a
    `vtkpartitioned_data_set_collection`, you can set
    `load_balance_across_all_blocks` to true to build the load balancing
    kd_tree using all PartitionedDataSets in the collection. Default is
    load balance each `vtkpartitioned_data_set` separately.
    
    For `vtkmulti_block_data_set`, the filter internally uses
    `vtkdata_assembly_utilities` to convert the MultiBlockDataSet to a
    PartitionedDataSetCollection and back.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRedistributeDataSetFilter, obj, update, **traits)
    
    enable_debugging = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/disable debugging mode. In this mode internal arrays are
        preserved and ghost cells are not explicitly marked as such so
        that they can be inspected without risk of being dropped or
        removed by the pipeline.
        
        Default is false.
        """
    )

    def _enable_debugging_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableDebugging,
                        self.enable_debugging_)

    expand_explicit_cuts = tvtk_base.true_bool_trait(desc=\
        r"""
        When using explicit cuts, it possible that the bounding box
        defined by all the cuts is smaller than the input's bounds. In
        that case, the filter can automatically expand the edge boxes to
        include the input bounds to avoid clipping of the input dataset
        on the external faces of the combined bounding box.
        
        Default is true, that is explicit cuts will automatically be
        expanded.
        """
    )

    def _expand_explicit_cuts_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExpandExplicitCuts,
                        self.expand_explicit_cuts_)

    generate_global_cell_ids = tvtk_base.true_bool_trait(desc=\
        r"""
        Generate global cell ids if none present in the input. If global
        cell ids are present in the input then this flag is ignored.
        Default is true.
        """
    )

    def _generate_global_cell_ids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateGlobalCellIds,
                        self.generate_global_cell_ids_)

    load_balance_across_all_blocks = tvtk_base.true_bool_trait(desc=\
        r"""
        When use_explicit_cuts is false, and input is a
        `vtkpartitioned_data_set_collection`, set this to true to generate
        cuts for load balancing using all the datasets in the
        PartitionedDataSetCollection.
        
        Default is true.
        """
    )

    def _load_balance_across_all_blocks_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLoadBalanceAcrossAllBlocks,
                        self.load_balance_across_all_blocks_)

    preserve_partitions_in_output = tvtk_base.false_bool_trait(desc=\
        r"""
        When set to true (default is false), this filter will generate a
        PartitionedDataSet as the output. The advantage of doing that
        is each partition that the input dataset was split into can be
        individually accessed. Otherwise, when the number of partitions
        generated is greater than the number of ranks, a rank with more
        than one partition will use `vtkappend_filter` to merge the
        multiple partitions into a single unstructured grid.
        
        The output dataset type is always UnstructuredGrid when
        preserve_partitions_in_output is false and always a
        PartitionedDataSet when preserve_partitions_in_output is true.
        
        Default is false i.e. the filter will generate a single
        UnstructuredGrid.
        """
    )

    def _preserve_partitions_in_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreservePartitionsInOutput,
                        self.preserve_partitions_in_output_)

    use_explicit_cuts = tvtk_base.false_bool_trait(desc=\
        r"""
        Specify whether to compute the load balancing automatically or
        use explicitly provided cuts. Set to false (default) to
        automatically compute the cuts to use for redistributing the
        dataset.
        """
    )

    def _use_explicit_cuts_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseExplicitCuts,
                        self.use_explicit_cuts_)

    boundary_mode = tvtk_base.RevPrefixMap({'assign_to_one_region': 0, 'assign_to_all_intersecting_regions': 1, 'split_boundary_cells': 2}, default_value='assign_to_one_region', desc=\
        r"""
        Specify how cells on the boundaries are handled.
        
        \li `ASSIGN_TO_ONE_REGION` results in a cell on the boundary
            uniquely added
             to one of the ranks containing the region intersecting the
        cell.
        \li `ASSIGN_TO_ALL_INTERSECTING_REGIONS` results in a cell on the
        boundary
             added to all ranks containing the region intersecting the
        cell.
        \li `SPLIT_BOUNDARY_CELLS` results in cells along the boundary
            being
             clipped along the region boundaries.
        
        Default is `ASSIGN_TO_ONE_REGION`.
        """
    )

    def _boundary_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryMode,
                        self.boundary_mode_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        r"""
        
        """
    )

    number_of_partitions = traits.Trait(0, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the number of partitions to split the input dataset into.
        Set to 0 to indicate that the partitions should match the number
        of ranks (processes) determined using MultiProcessController
        provided. Setting to a non-zero positive number will result in
        the filter generating at least as many partitions.
        
        This is simply a hint and not an exact number of partitions the
        data will be split into. Current implementation results in number
        of partitions equal to the power of 2 greater than or equal to
        the chosen value.
        
        Default is 0.
        
        This has no effect when `use_explicit_cuts` is set to true. In that
        case, the number of partitions is dictated by the number of cuts
        provided.
        
        @sa preserve_partitions_in_output, use_explicit_cuts
        """
    )

    def _number_of_partitions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfPartitions,
                        self.number_of_partitions)

    def get_explicit_cut(self, *args):
        """
        get_explicit_cut(self, index:int) -> BoundingBox
        C++: const BoundingBox &get_explicit_cut(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetExplicitCut, *args)
        return wrap_vtk(ret)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_explicit_cuts(self):
        return self._vtk_obj.GetNumberOfExplicitCuts()
    number_of_explicit_cuts = traits.Property(_get_number_of_explicit_cuts, desc=\
        r"""
        
        """
    )

    def add_explicit_cut(self, *args):
        """
        add_explicit_cut(self, bbox:BoundingBox) -> None
        C++: void add_explicit_cut(const BoundingBox &bbox)
        add_explicit_cut(self, bbox:(float, float, float, float, float,
            float)) -> None
        C++: void add_explicit_cut(const double bbox[6])"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddExplicitCut, *my_args)
        return ret

    def remove_all_explicit_cuts(self):
        """
        remove_all_explicit_cuts(self) -> None
        C++: void remove_all_explicit_cuts()"""
        ret = self._vtk_obj.RemoveAllExplicitCuts()
        return ret
        

    _updateable_traits_ = \
    (('enable_debugging', 'GetEnableDebugging'), ('expand_explicit_cuts',
    'GetExpandExplicitCuts'), ('generate_global_cell_ids',
    'GetGenerateGlobalCellIds'), ('load_balance_across_all_blocks',
    'GetLoadBalanceAcrossAllBlocks'), ('preserve_partitions_in_output',
    'GetPreservePartitionsInOutput'), ('use_explicit_cuts',
    'GetUseExplicitCuts'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('boundary_mode', 'GetBoundaryMode'), ('number_of_partitions',
    'GetNumberOfPartitions'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'enable_debugging',
    'expand_explicit_cuts', 'generate_global_cell_ids',
    'global_warning_display', 'load_balance_across_all_blocks',
    'preserve_partitions_in_output', 'release_data_flag',
    'use_explicit_cuts', 'boundary_mode', 'number_of_partitions',
    'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RedistributeDataSetFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RedistributeDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enable_debugging', 'expand_explicit_cuts',
            'generate_global_cell_ids', 'load_balance_across_all_blocks',
            'preserve_partitions_in_output', 'use_explicit_cuts'],
            ['boundary_mode'], ['number_of_partitions', 'object_name']),
            title='Edit RedistributeDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RedistributeDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

