# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set_algorithm import PointSetAlgorithm


class ProjectPointsToPlane(PointSetAlgorithm):
    r"""
    ProjectPointsToPlane - project all input points to a plane
    
    Superclass: PointSetAlgorithm
    
    ProjectPointsToPlane is a filter that operates on a PointSet
    (and its subclasses), projecting all input points to a plane. There
    are multiple options as to what plane to project to: The user may
    specify one of the x-y-z planes, the best coordinate plane, a
    user-defined plane, or the closest fitting plane (using a
    least-squares method). On output, the points will lie on the
    specified plane, and any cells connected to the points (if any) will
    be deformed accordingly. On output, the filter will not modify
    dataset topology, nor modify point or cell attributes. Only the point
    coordinates (geometry) will be modified. (Note that the filter will
    operate on input point sets with or without cells.)
    
    @warning
    It is possible that cells connected to the projected points will
    become invalid after the projection operation.
    
    @sa
    Plane
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkProjectPointsToPlane, obj, update, **traits)
    
    projection_type = tvtk_base.RevPrefixMap({'z_plane': 3, 'best_coordinate_plane': 5, 'best_fit_plane': 6, 'specified_plane': 4, 'x_plane': 1, 'y_plane': 2}, default_value='z_plane', desc=\
        r"""
        Specify the type of projection to perform. Points may be
        projected to the 1) x-plane; 2) y-plane; 3) z-plane; 4)
        user-specified plane; 5) the plane most orthogonal to one of the
        coordinate axes x, y, or z; or 6) best fitting plane. For option
        #4, the user must also specify a plane Origin and Normal. For all
        options, after filter execution, the plane onto which the points
        are projected is returned in the Origin and Normal data members.
        Note that the BEST_COORDINATE_PLANE first performs a plane
        fitting, and then selects the x, y, or z coordinate plane most
        orthogonal to the fitted plane normal.
        """
    )

    def _projection_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProjectionType,
                        self.projection_type_)

    normal = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 1.0), cols=3, desc=\
        r"""
        
        """
    )

    def _normal_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormal,
                        self.normal)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Set/Get the plane normal and origin. On input, these methods are
        used to specify the plane to use for projection (if the
        projection_type==specified_plane); and on output the methods return
        the plane on which the points were projected.
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    output_points_precision = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points. See the
        documentation for the Algorithm::Precision enum for an
        explanation of the available precision settings. By default, the
        output precision is DEFAULT_PRECISION (i.e., the input and output
        types are the same) - this can cause issues if projecting
        integral point types.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('projection_type', 'GetProjectionType'), ('normal', 'GetNormal'),
    ('origin', 'GetOrigin'), ('output_points_precision',
    'GetOutputPointsPrecision'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'projection_type', 'normal', 'object_name',
    'origin', 'output_points_precision', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ProjectPointsToPlane, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ProjectPointsToPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['projection_type'], ['normal', 'object_name', 'origin',
            'output_points_precision']),
            title='Edit ProjectPointsToPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ProjectPointsToPlane properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

