# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Matrix3x3(Object):
    r"""
    Matrix3x3 - represent and manipulate 3x3 transformation matrices
    
    Superclass: Object
    
    Matrix3x3 is a class to represent and manipulate 3x3 matrices.
    Specifically, it is designed to work on 3x3 transformation matrices
    found in 2D rendering using homogeneous coordinates [x y w].
    
    @sa
    Transform2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMatrix3x3, obj, update, **traits)
    
    def get_element(self, *args):
        """
        get_element(self, i:int, j:int) -> float
        C++: double get_element(int i, int j)
        Returns the element i,j from the matrix.
        """
        ret = self._wrap_call(self._vtk_obj.GetElement, *args)
        return ret

    def set_element(self, *args):
        """
        set_element(self, i:int, j:int, value:float) -> None
        C++: void set_element(int i, int j, double value)
        Sets the element i,j in the matrix.
        """
        ret = self._wrap_call(self._vtk_obj.SetElement, *args)
        return ret

    def _get_data(self):
        return self._vtk_obj.GetData()
    data = traits.Property(_get_data, desc=\
        r"""
        Return a pointer to the first element of the matrix (double[9]).
        """
    )

    def adjoint(self, *args):
        """
        adjoint(self, in_:Matrix3x3, out:Matrix3x3) -> None
        C++: void adjoint(Matrix3x3 *in, Matrix3x3 *out)
        adjoint(inElements:(float, float, float, float, float, float,
            float, float, float), outElements:[float, float, float, float,
             float, float, float, float, float]) -> None
        C++: static void adjoint(const double inElements[9],
            double outElements[9])
        Compute adjoint of the matrix and put it into out.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Adjoint, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, source:Matrix3x3) -> None
        C++: void deep_copy(Matrix3x3 *source)
        deep_copy(elements:[float, float, float, float, float, float,
            float, float, float], source:Matrix3x3) -> None
        C++: static void deep_copy(double elements[9],
            Matrix3x3 *source)
        deep_copy(elements:[float, float, float, float, float, float,
            float, float, float], newElements:(float, float, float, float,
             float, float, float, float, float)) -> None
        C++: static void deep_copy(double elements[9],
            const double newElements[9])
        deep_copy(self, elements:(float, float, float, float, float, float,
             float, float, float)) -> None
        C++: void deep_copy(const double elements[9])
        Set the elements of the matrix to the same values as the elements
        of the source Matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def determinant(self, *args):
        """
        determinant(self) -> float
        C++: double determinant()
        determinant(elements:(float, float, float, float, float, float,
            float, float, float)) -> float
        C++: static double determinant(const double elements[9])
        Compute the determinant of the matrix and return it.
        """
        ret = self._wrap_call(self._vtk_obj.Determinant, *args)
        return ret

    def identity(self, *args):
        """
        identity(self) -> None
        C++: void identity()
        identity(elements:[float, float, float, float, float, float,
            float, float, float]) -> None
        C++: static void identity(double elements[9])
        Set equal to Identity matrix
        """
        ret = self._wrap_call(self._vtk_obj.Identity, *args)
        return ret

    def invert(self, *args):
        """
        invert(in_:Matrix3x3, out:Matrix3x3) -> None
        C++: static void invert(Matrix3x3 *in, Matrix3x3 *out)
        invert(self) -> None
        C++: void invert()
        invert(inElements:(float, float, float, float, float, float,
            float, float, float), outElements:[float, float, float, float,
             float, float, float, float, float]) -> None
        C++: static void invert(const double inElements[9],
            double outElements[9])
        Matrix Inversion (adapted from Richard Carling in "Graphics
        Gems," Academic Press, 1990).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Invert, *my_args)
        return ret

    def is_identity(self):
        """
        is_identity(self) -> bool
        C++: bool is_identity()"""
        ret = self._vtk_obj.IsIdentity()
        return ret
        

    def multiply3x3(self, *args):
        """
        multiply3x3(a:Matrix3x3, b:Matrix3x3, c:Matrix3x3)
            -> None
        C++: static void multiply3x3(Matrix3x3 *a, Matrix3x3 *b,
            Matrix3x3 *c)
        multiply3x3(a:(float, float, float, float, float, float, float,
            float, float), b:(float, float, float, float, float, float,
            float, float, float), c:[float, float, float, float, float,
            float, float, float, float]) -> None
        C++: static void multiply3x3(const double a[9], const double b[9],
             double c[9])
        Multiplies matrices a and b and stores the result in c (c=a*b).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Multiply3x3, *my_args)
        return ret

    def multiply_point(self, *args):
        """
        multiply_point(self, in_:(float, float, float), out:[float, float,
            float]) -> None
        C++: void multiply_point(const double in[3], double out[3])
        multiply_point(elements:(float, float, float, float, float, float,
            float, float, float), in_:(float, float, float), out:[float,
            float, float]) -> None
        C++: static void multiply_point(const double elements[9],
            const double in[3], double out[3])"""
        ret = self._wrap_call(self._vtk_obj.MultiplyPoint, *args)
        return ret

    def transpose(self, *args):
        """
        transpose(in_:Matrix3x3, out:Matrix3x3) -> None
        C++: static void transpose(Matrix3x3 *in, Matrix3x3 *out)
        transpose(self) -> None
        C++: void transpose()
        transpose(inElements:(float, float, float, float, float, float,
            float, float, float), outElements:[float, float, float, float,
             float, float, float, float, float]) -> None
        C++: static void transpose(const double inElements[9],
            double outElements[9])
        Transpose the matrix and put it into out.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Transpose, *my_args)
        return ret

    def zero(self, *args):
        """
        zero(self) -> None
        C++: void zero()
        zero(elements:[float, float, float, float, float, float, float,
            float, float]) -> None
        C++: static void zero(double elements[9])
        Set all of the elements to zero.
        """
        ret = self._wrap_call(self._vtk_obj.Zero, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Matrix3x3, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Matrix3x3 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit Matrix3x3 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Matrix3x3 properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

