# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridEvaluateCoarse(HyperTreeGridAlgorithm):
    r"""
    HyperTreeGridEvaluateCoarse - The value of the parent cell is
    determined from an operation defined on the values of the child cells.
    
    Superclass: HyperTreeGridAlgorithm
    
    HyperTreeGridEvaluateCoarse is a filter that takes as input an
    hypertree grid. The value of the parent cell (coarse) is determined
    from an operation defined on the values of the child cells (refined
    cell).
    
    The predefined operators are :
    - OPERATOR_DON_T_CHANGE_FAST: Operator does not change coarse value
      (default), just shallow copy
    - OPERATOR_DON_T_CHANGE: Operator does not change coarse value but
      iterate over all cells, just shallow copy
    - OPERATOR_MIN: The littlest value of the unmasked child cells
    - OPERATOR_MAX: The biggest value of the unmasked child cells
    - OPERATOR_SUM: The sum of the values of the unmasked child cells
    - OPERATOR_AVERAGE: The average of the values of the child cells. If
      the cell is masked a value is put at "default value" (default value
    = 0 if not set by set_default).
    - OPERATOR_UNMASKED_AVERAGE: The average of the values of the
      unmasked child cells
    - OPERATOR_ELDER_CHILD: Operator puts the value of the first child
      (elder child)
    - OPERATOR_SPLATTING_AVERAGE: The splatting average of the values of
      the child cells. If the cell is masked a value is put at "default
      value" (default value = 0 if not set by set_default). The
      calculation of the average should normally be done by dividing by
      the number of children (get_number_of_children) which is worth f^d
      where f, refinement factor and d, number of spatial dimension. In
      the calculation of the mean for splatting, the division involves
      f^(d-1). In 3D, if a mesh is refined into 8 child cells each having
    a value set to 0.5, all these children produce 4 splats of value 1.
      In fact, the value of the expected splat at the coarse cell
      (parent) is 1. But a standard average will give 0.5 (value / f^d).
      This is why the calculation of the average for splatting is
      different (value / f^(d-1)).
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien, 2016-18 This class was modified to take in
    account the field values with components different of one, by Florent
    Denef, 2019 This work was supported by Commissariat a l'Energie
    Atomique CEA, DAM, DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridEvaluateCoarse, obj, update, **traits)
    
    operator = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get operator
        """
    )

    def _operator_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOperator,
                        self.operator)

    def set_default(self, *args):
        """
        set_default(self, _arg:float) -> None
        C++: virtual void set_default(double _arg)
        Set/Get operator
        """
        ret = self._wrap_call(self._vtk_obj.SetDefault, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('operator',
    'GetOperator'), ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'operator', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridEvaluateCoarse, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridEvaluateCoarse properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'operator']),
            title='Edit HyperTreeGridEvaluateCoarse properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridEvaluateCoarse properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

