# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class DataAssembly(Object):
    r"""
    DataAssembly - hierarchical representation to use with
    PartitionedDataSetCollection
    
    Superclass: Object
    
    DataAssembly is a mechanism to represent hierarchical organization
    of items (or PartitionedDataSet instances) in a
    PartitionedDataSetCollection. PartitionedDataSetCollection is
    similar to a MultiBlockDataSet since it provides a means for
    putting together multiple non-composite datasets. However,
    PartitionedDataSetCollection itself doesn't provide any mechanism
    to define relationships between items in the collections. That is
    done using DataAssembly.
    
    @section Overview Overview
    
    At its core, DataAssembly is simply a tree of nodes starting with
    the root node. Each node has a unique id and a string name (names
    need not be unique). On initialization with
    `vtkdata_assembly::Initialize`, an empty tree with a root node is
    created. The root node's id and name can be obtained using
    `vtkdata_assembly::get_root_node` and
    `vtkdata_assembly::get_root_node_name`. The root node's id is fixed
    (vtkdata_assembly::get_root_node), however the name can be changed using
    `vtkdata_assembly::set_root_node_name`.
    
    Child nodes can be added using `vtkdata_assembly::add_node` or
    `vtkdata_assembly::add_nodes`, each of which returns the ids for every
    child node added. A non-root node can be removed using
    `vtkdata_assembly::remove_node`.
    
    Each node in the tree (including the root node) can have associated
    dataset indices. For a DataAssembly associated with a
    PartitionedDataSetCollection, these indices refer to the item
    index, or partitioned-dataset-index for items in the collection.
    Dataset indices can be specified using
    `vtkdata_assembly::add_data_set_index`,
    `vtkdata_assembly::add_data_set_indices` and removed using
    `vtkdata_assembly::remove_data_set_index`,
    `vtkdata_assembly::remove_all_data_set_indices`.
    `vtkdata_assembly::get_data_set_indices` provides a mechanism to get the
    database indices associated with a node, and optionally, the entire
    subtree rooted at the chosen node.
    
    @section Searching Searching
    
    Each node in the DataAssembly is assigned a unique id.
    `vtkdata_assembly::find_first_node_with_name` and
    `vtkdata_assembly::find_nodes_with_name` can be used to get the id(s) for
    node(s) with given name.
    
    `vtkdata_assembly::select_nodes` provides a more flexible mechanism to
    find nodes using name-based queries. Section@ref
    data_assembly_path_queries covers supported queries.
    
    @section Traversal Traversal
    
    `vtkdata_assembly_visitor` defines a visitor API. An instance of a
    concretized `vtkdata_assembly_visitor` subclass can be passed to
    `vtkdata_assembly::Visit` to traverse the data-assembly hierarchy
    either in depth-first or breadth-first order.
    
    @section data_assembly_path_queries Supported Path Queries
    
    `vtkdata_assembly::select_nodes` can be used find nodes that match the
    specified query (or queries) using XPath 1.0 syntax.
    
    For example:
    
    * '/' is used as the path separator. If a node name has a `/` it must
    be escaped using `\` in the query. Note, escaping is not necessary
      when using `set_node_name`/`get_node_name`.
    
    * '/' selects the root node.
    
    * '/nodename' selects all child nodes of the root with the name
      'nodename'.
    
    * '//nodename' selects all nodes with 'nodename' that are descendants
    of the root; thus, this this will traverse the entire tree.
    
    * '/nodename/' selects all child nodes of all nodes named 'nodename'
      under the root; thus, ending a query with '/' selects the children
      of the found nodes rather than the nodes themselves.
    
    * '/nodename1/nodename2' selects all nodes named 'nodename2' which
      are children of nodes with name 'nodename1' that are themselves
      children of the root node.
    
    * '//nodename1/nodename2' finds all nodes in the tree named
      'nodename1' and then selects all children of these found nodes that
    are named 'nodename2'.
    
    @section Applications Applications
    
    The separation of dataset storage (vtkpartitioned_data_set_collection)
    and organization (vtkdata_assembly) enables development of algorithms
    that can expose APIs that are not tightly coupled to dataset storage.
    Together, PartitionedDataSetCollection and DataAssembly can be
    thought of as a different way of organizing data that was previously
    organized as a MultiBlockDataSet. The advantage of the this newer
    approach is that filters can support specifying parameters using
    paths or path queries rather than composite indices. The composite
    indices suffered from the fact that they made no sense except for the
    specific MultiBlockDataSet they were applied too. Thus, if the
    filters input was changed, the composite ids rarely made any sense
    and needed to be updated. Paths and path queries, however, do not
    suffer from this issue.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataAssembly, obj, update, **traits)
    
    def get_attribute(self, *args):
        """
        get_attribute(self, id:int, name:str, value:int) -> bool
        C++: bool get_attribute(int id, const char *name, int &value)
        get_attribute(self, id:int, name:str, value:int) -> bool
        C++: bool get_attribute(int id, const char *name, IdType &value)"""
        ret = self._wrap_call(self._vtk_obj.GetAttribute, *args)
        return ret

    def set_attribute(self, *args):
        """
        set_attribute(self, id:int, name:str, value:str) -> None
        C++: void set_attribute(int id, const char *name,
            const char *value)
        set_attribute(self, id:int, name:str, value:int) -> None
        C++: void set_attribute(int id, const char *name, int value)
        set_attribute(self, id:int, name:str, value:int) -> None
        C++: void set_attribute(int id, const char *name, IdType value)
        Set an attribute. Will replace an existing attribute with the
        same name if present.
        """
        ret = self._wrap_call(self._vtk_obj.SetAttribute, *args)
        return ret

    def get_node_name(self, *args):
        """
        get_node_name(self, id:int) -> str
        C++: const char *get_node_name(int id)"""
        ret = self._wrap_call(self._vtk_obj.GetNodeName, *args)
        return ret

    def set_node_name(self, *args):
        """
        set_node_name(self, id:int, name:str) -> None
        C++: void set_node_name(int id, const char *name)
        Get/Set a node's name. If node id is invalid, `set_node_name` will
        raise an error; `get_node_name` will also raise an error and return
        nullptr.
        
        `set_node_name` will raise an error if the name is not valid. Name
        cannot be empty or nullptr.
        """
        ret = self._wrap_call(self._vtk_obj.SetNodeName, *args)
        return ret

    root_node_name = traits.String('assembly', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set root node name. Defaults to data_assembly.
        """
    )

    def _root_node_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRootNodeName,
                        self.root_node_name)

    def get_attribute_or_default(self, *args):
        """
        get_attribute_or_default(self, id:int, name:str, default_value:str)
            -> str
        C++: const char *get_attribute_or_default(int id, const char *name,
            const char *default_value)
        get_attribute_or_default(self, id:int, name:str, default_value:int)
            -> int
        C++: int get_attribute_or_default(int id, const char *name,
            int default_value)
        get_attribute_or_default(self, id:int, name:str, default_value:int)
            -> int
        C++: IdType get_attribute_or_default(int id, const char *name,
            IdType default_value)
        Get an attribute value. Returns the value associated with the
        node or the provided default value.
        """
        ret = self._wrap_call(self._vtk_obj.GetAttributeOrDefault, *args)
        return ret

    def get_child(self, *args):
        """
        get_child(self, parent:int, index:int) -> int
        C++: int get_child(int parent, int index)
        Returns the id for a child not at the given index, if valid,
        otherwise -1.
        """
        ret = self._wrap_call(self._vtk_obj.GetChild, *args)
        return ret

    def get_child_index(self, *args):
        """
        get_child_index(self, parent:int, child:int) -> int
        C++: int get_child_index(int parent, int child)
        Returns the index for a child under a given. -1 if invalid.
        """
        ret = self._wrap_call(self._vtk_obj.GetChildIndex, *args)
        return ret

    def get_child_nodes(self, *args):
        """
        get_child_nodes(self, parent:int, traverse_subtree:bool=True,
            traversal_order:int=...) -> (int, ...)
        C++: std::vector<int> get_child_nodes(int parent,
            bool traverse_subtree=true,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        Returns ids for all child nodes.
        
        If `traverse_subtree` is true (default), recursively builds the
        child node list. The traversal order can be specified using
        `traversal_order` flag; defaults to depth-first.
        
        @sa DataAssembly::Visit, DataAssemblyVisitor
        """
        ret = self._wrap_call(self._vtk_obj.GetChildNodes, *args)
        return ret

    def get_data_set_indices(self, *args):
        """
        get_data_set_indices(self, id:int, traverse_subtree:bool=True,
            traversal_order:int=...) -> (int, ...)
        C++: std::vector<unsigned int> get_data_set_indices(int id,
            bool traverse_subtree=true,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        get_data_set_indices(self, ids:(int, ...),
            traverse_subtree:bool=True, traversal_order:int=...) -> (int,
            ...)
        C++: std::vector<unsigned int> get_data_set_indices(
            const std::vector<int> &ids, bool traverse_subtree=true,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        Returns the dataset indices associated with the node.
        
        If `traverse_subtree` is true (default), recursively builds the
        dataset indices list for the node and all its child nodes. Note,
        a dataset index will only appear once in the output even if it is
        encountered on multiple nodes in the subtree.
        
        When `traverse_subtree` is true, the traversal order can be
        specified using `traversal_order`. Defaults to depth-first.
        """
        ret = self._wrap_call(self._vtk_obj.GetDataSetIndices, *args)
        return ret

    def get_first_node_by_path(self, *args):
        """
        get_first_node_by_path(self, path:str) -> int
        C++: int get_first_node_by_path(const char *path)
        Return a node id given the path. Returns `-1` if path is not
        valid.
        """
        ret = self._wrap_call(self._vtk_obj.GetFirstNodeByPath, *args)
        return ret

    def get_node_path(self, *args):
        """
        get_node_path(self, id:int) -> str
        C++: std::string get_node_path(int id)
        Returns the path for a node.
        """
        ret = self._wrap_call(self._vtk_obj.GetNodePath, *args)
        return ret

    def get_number_of_children(self, *args):
        """
        get_number_of_children(self, parent:int) -> int
        C++: int get_number_of_children(int parent)
        Returns the number of child nodes.
        
        @returns the number of child nodes for the parent node or 0 if
            the parent
        is invalid.
        """
        ret = self._wrap_call(self._vtk_obj.GetNumberOfChildren, *args)
        return ret

    def get_parent(self, *args):
        """
        get_parent(self, id:int) -> int
        C++: int get_parent(int id)
        Returns the id for the parent node, if any. Returns -1 if the
        node is invalid or has no parent (i.e. is the root node).
        """
        ret = self._wrap_call(self._vtk_obj.GetParent, *args)
        return ret

    def _get_root_node(self):
        return self._vtk_obj.GetRootNode()
    root_node = traits.Property(_get_root_node, desc=\
        r"""
        Returns the ID for the root node. This always returns 0.
        """
    )

    def add_data_set_index(self, *args):
        """
        add_data_set_index(self, id:int, dataset_index:int) -> bool
        C++: bool add_data_set_index(int id, unsigned int dataset_index)
        Add a dataset index to a node. The node id can refer to any valid
        node in the assembly, including the root.
        
        While the same dataset can be added multiple times in the
        assembly, it cannot be added multiple times to the same node.
        Additional adds will fail.
        
        @returns true if addition succeeded else false.
        """
        ret = self._wrap_call(self._vtk_obj.AddDataSetIndex, *args)
        return ret

    def add_data_set_index_range(self, *args):
        """
        add_data_set_index_range(self, id:int, index_start:int, count:int)
            -> bool
        C++: bool add_data_set_index_range(int id, unsigned int index_start,
            int count)
        Same as `add_data_set_indices` except this supports adding a
        contiguous range of dataset indices in one go.
        
        @ returns true if any dataset index was successfully added.
        """
        ret = self._wrap_call(self._vtk_obj.AddDataSetIndexRange, *args)
        return ret

    def add_data_set_indices(self, *args):
        """
        add_data_set_indices(self, id:int, dataset_indices:(int, ...))
            -> bool
        C++: bool add_data_set_indices(int id,
            const std::vector<unsigned int> &dataset_indices)
        Same as `add_data_set_index` except supports adding multiple dataset
        indices in one go. Note, a dataset index only gets added once.
        
        @returns true if any dataset index was successfully added.
        """
        ret = self._wrap_call(self._vtk_obj.AddDataSetIndices, *args)
        return ret

    def add_node(self, *args):
        """
        add_node(self, name:str, parent:int=0) -> int
        C++: int add_node(const char *name, int parent=0)
        Adds a node to the assembly with the given name and returns its
        id. `parent` is the id for the parent node which defaults to the
        root node id (i.e. `get_root_node`).
        
        If `parent` is invalid, the add will fail.
        
        @returns id of the newly added node on success, else -1.
        """
        ret = self._wrap_call(self._vtk_obj.AddNode, *args)
        return ret

    def add_nodes(self, *args):
        """
        add_nodes(self, names:(str, ...), parent:int=0) -> (int, ...)
        C++: std::vector<int> add_nodes(
            const std::vector<std::string> &names, int parent=0)
        Same as `add_node` except allows adding multiple nodes in one go.
        
        If `parent` is invalid, the add will fail.
        
        @returns vectors of corresponding indices for each of the `names`
        added.
        """
        ret = self._wrap_call(self._vtk_obj.AddNodes, *args)
        return ret

    def add_subtree(self, *args):
        """
        add_subtree(self, parent:int, other:DataAssembly,
            otherParent:int=0) -> int
        C++: int add_subtree(int parent, DataAssembly *other,
            int otherParent=0)
        Add a subtree by copy the nodes from another tree starting with
        the specified parent index.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddSubtree, *my_args)
        return ret

    def deep_copy(self, *args):
        """
        deep_copy(self, other:DataAssembly) -> None
        C++: void deep_copy(DataAssembly *other)
        Deep copy the `other`.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DeepCopy, *my_args)
        return ret

    def find_first_node_with_name(self, *args):
        """
        find_first_node_with_name(self, name:str, traversal_order:int=...)
            -> int
        C++: int find_first_node_with_name(const char *name,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        Finds first node that is encountered in a breadth first traversal
        of the assembly with the given name.
        
        @returns the if of the node if found, else -1.
        """
        ret = self._wrap_call(self._vtk_obj.FindFirstNodeWithName, *args)
        return ret

    def find_nodes_with_name(self, *args):
        """
        find_nodes_with_name(self, name:str, sort_order:int=...) -> (int,
            ...)
        C++: std::vector<int> find_nodes_with_name(const char *name,
            int sort_order=DataAssembly::TraversalOrder::DepthFirst)
        Finds all nodes with the given name. The nodes can be ordered
        depth first or breadth first, based on the `sort_order` flag.
        """
        ret = self._wrap_call(self._vtk_obj.FindNodesWithName, *args)
        return ret

    def has_attribute(self, *args):
        """
        has_attribute(self, id:int, name:str) -> bool
        C++: bool has_attribute(int id, const char *name)
        Returns true if attribute with the given name is present on the
        chosen node.
        """
        ret = self._wrap_call(self._vtk_obj.HasAttribute, *args)
        return ret

    def initialize(self):
        """
        initialize(self) -> None
        C++: void initialize()
        Initializes the data-assembly. When a new DataAssembly
        instance is created, it is in initialized form and it is not
        required to call this method to initialize it.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def initialize_from_xml(self, *args):
        """
        initialize_from_xml(self, xmlcontents:str) -> bool
        C++: bool initialize_from_xml(const char *xmlcontents)
        Initializes a data-assembly using an XML representation of the
        assembly. Returns true if the initialization was successful,
        otherwise the assembly is set a clean state and returns false.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeFromXML, *args)
        return ret

    def is_node_name_reserved(self, *args):
        """
        is_node_name_reserved(name:str) -> bool
        C++: static bool is_node_name_reserved(const char *name)
        Returns true for node names that are reserved.
        """
        ret = self._wrap_call(self._vtk_obj.IsNodeNameReserved, *args)
        return ret

    def is_node_name_valid(self, *args):
        """
        is_node_name_valid(name:str) -> bool
        C++: static bool is_node_name_valid(const char *name)
        Validates a node name.
        """
        ret = self._wrap_call(self._vtk_obj.IsNodeNameValid, *args)
        return ret

    def make_valid_node_name(self, *args):
        """
        make_valid_node_name(name:str) -> str
        C++: static std::string make_valid_node_name(const char *name)
        Converts any string to a string that is a valid node name. This
        is done by simply discarding any non-supported character.
        Additionally, if the first character is not a "_" or an alphabet,
        then the "_" is prepended.
        """
        ret = self._wrap_call(self._vtk_obj.MakeValidNodeName, *args)
        return ret

    def remove_all_data_set_indices(self, *args):
        """
        remove_all_data_set_indices(self, id:int, traverse_subtree:bool=True)
            -> bool
        C++: bool remove_all_data_set_indices(int id,
            bool traverse_subtree=true)
        Clears all dataset indices from the node.
        
        If `traverse_subtree` is true (default), recursively removes all
        dataset indices from all the child nodes.
        
        @returns true on success, else returns false.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveAllDataSetIndices, *args)
        return ret

    def remove_data_set_index(self, *args):
        """
        remove_data_set_index(self, id:int, dataset_index:int) -> bool
        C++: bool remove_data_set_index(int id, unsigned int dataset_index)
        Removes a dataset index from a node.
        
        @returns true if the removal was successful, else returns false.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveDataSetIndex, *args)
        return ret

    def remove_node(self, *args):
        """
        remove_node(self, id:int) -> bool
        C++: bool remove_node(int id)
        Removes a node from the assembly. The node identified by the id
        and all its children are removed.
        
        Root node cannot be removed.
        
        @returns true if removal was successful, false if the id is
            invalid or root
        node id.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveNode, *args)
        return ret

    def select_nodes(self, *args):
        """
        select_nodes(self, path_queries:(str, ...),
            traversal_order:int=...) -> (int, ...)
        C++: std::vector<int> select_nodes(
            const std::vector<std::string> &path_queries,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        Returns ids for nodes matching the path_queries. See Section@ref
        data_assembly_path_queries for supported query expressions.
        
        Will return an empty vector is no nodes match the requested
        query.
        
        @returns node ids matching the query in traversal order chosen
            using
                 `traversal_order`.
        """
        ret = self._wrap_call(self._vtk_obj.SelectNodes, *args)
        return ret

    def serialize_to_xml(self, *args):
        """
        serialize_to_xml(self, indent:Indent) -> str
        C++: std::string serialize_to_xml(Indent indent)
        Saves the data-assembly as a XML.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SerializeToXML, *my_args)
        return ret

    def subset_copy(self, *args):
        """
        subset_copy(self, other:DataAssembly, selected_branches:(int,
            ...)) -> None
        C++: void subset_copy(DataAssembly *other,
            const std::vector<int> &selected_branches)
        Create a deep-copy of other by only passing the chosen branches.
        All other branches of the tree will be pruned. Note this method
        never affects the depth of the selected branches or dataset
        indices attached to any of the nodes in pruned output.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SubsetCopy, *my_args)
        return ret

    def visit(self, *args):
        """
        visit(self, visitor:DataAssemblyVisitor,
            traversal_order:int=...) -> None
        C++: void visit(DataAssemblyVisitor *visitor,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        visit(self, id:int, visitor:DataAssemblyVisitor,
            traversal_order:int=...) -> None
        C++: void visit(int id, DataAssemblyVisitor *visitor,
            int traversal_order=DataAssembly::TraversalOrder::DepthFirst)
        Visit each node in the assembly for processing. The traversal
        order can be specified using `traversal_order` which defaults to
        depth-first.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Visit, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('root_node_name', 'GetRootNodeName'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name', 'root_node_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataAssembly, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'root_node_name']),
            title='Edit DataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataAssembly properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

