// license:BSD-3-Clause
// copyright-holders:Vas Crabb
/***************************************************************************

    strformat.h

    type-safe printf substitutes

***************************************************************************/

#include "strformat.h"

#include <iostream>
#include <sstream>


namespace util {

namespace detail {

template class format_chars<char>;
template class format_chars<wchar_t>;

template void format_flags::apply(std::ostream &) const;
template void format_flags::apply(std::wostream &) const;
template void format_flags::apply(std::iostream &) const;
template void format_flags::apply(std::wiostream &) const;
template void format_flags::apply(std::ostringstream &) const;
template void format_flags::apply(std::wostringstream &) const;
template void format_flags::apply(std::stringstream &) const;
template void format_flags::apply(std::wstringstream &) const;
template void format_flags::apply(ovectorstream &) const;
template void format_flags::apply(wovectorstream &) const;
template void format_flags::apply(vectorstream &) const;
template void format_flags::apply(wvectorstream &) const;

template class format_argument<std::ostream>;
template void format_argument<std::ostream>::static_output<char>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<signed char>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<unsigned char>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<short>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<unsigned short>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<int>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<unsigned int>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<long>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<unsigned long>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<long long>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<unsigned long long>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<char *>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<char const *>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<std::string>(std::ostream &, format_flags const &, void const *);
template void format_argument<std::ostream>::static_output<std::string_view>(std::ostream &, format_flags const &, void const *);
template bool format_argument<std::ostream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<std::ostream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<std::ostream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<std::ostream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<std::wostream>;
template void format_argument<std::wostream>::static_output<char>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<signed char>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<unsigned char>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<wchar_t>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<short>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<unsigned short>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<int>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<unsigned int>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<long>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<unsigned long>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<long long>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<unsigned long long>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<wchar_t *>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<wchar_t const *>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<std::wstring>(std::wostream &, format_flags const &, void const *);
template void format_argument<std::wostream>::static_output<std::wstring_view>(std::wostream &, format_flags const &, void const *);
template bool format_argument<std::wostream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<std::wostream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<std::wostream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<std::wostream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument<std::iostream>;
template void format_argument<std::iostream>::static_output<char>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<signed char>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<unsigned char>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<short>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<unsigned short>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<int>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<unsigned int>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<long>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<unsigned long>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<long long>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<unsigned long long>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<char *>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<char const *>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<std::string>(std::iostream &, format_flags const &, void const *);
template void format_argument<std::iostream>::static_output<std::string_view>(std::iostream &, format_flags const &, void const *);
template bool format_argument<std::iostream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<std::iostream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<std::iostream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<std::iostream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<std::wiostream>;
template void format_argument<std::wiostream>::static_output<char>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<signed char>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<unsigned char>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<wchar_t>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<short>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<unsigned short>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<int>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<unsigned int>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<long>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<unsigned long>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<long long>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<unsigned long long>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<wchar_t *>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<wchar_t const *>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<std::wstring>(std::wiostream &, format_flags const &, void const *);
template void format_argument<std::wiostream>::static_output<std::wstring_view>(std::wiostream &, format_flags const &, void const *);
template bool format_argument<std::wiostream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<std::wiostream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<std::wiostream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<std::wiostream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument<std::ostringstream>;
template void format_argument<std::ostringstream>::static_output<char>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<signed char>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<unsigned char>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<short>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<unsigned short>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<int>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<unsigned int>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<long>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<unsigned long>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<long long>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<unsigned long long>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<char *>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<char const *>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<std::string>(std::ostringstream &, format_flags const &, void const *);
template void format_argument<std::ostringstream>::static_output<std::string_view>(std::ostringstream &, format_flags const &, void const *);
template bool format_argument<std::ostringstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<std::ostringstream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<std::ostringstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<std::ostringstream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<std::wostringstream>;
template void format_argument<std::wostringstream>::static_output<char>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<signed char>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<unsigned char>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<wchar_t>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<short>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<unsigned short>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<int>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<unsigned int>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<long>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<unsigned long>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<long long>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<unsigned long long>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<wchar_t *>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<wchar_t const *>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<std::wstring>(std::wostringstream &, format_flags const &, void const *);
template void format_argument<std::wostringstream>::static_output<std::wstring_view>(std::wostringstream &, format_flags const &, void const *);
template bool format_argument<std::wostringstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<std::wostringstream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<std::wostringstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<std::wostringstream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument<std::stringstream>;
template void format_argument<std::stringstream>::static_output<char>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<signed char>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<unsigned char>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<short>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<unsigned short>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<int>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<unsigned int>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<long>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<unsigned long>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<long long>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<unsigned long long>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<char *>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<char const *>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<std::string>(std::stringstream &, format_flags const &, void const *);
template void format_argument<std::stringstream>::static_output<std::string_view>(std::stringstream &, format_flags const &, void const *);
template bool format_argument<std::stringstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<std::stringstream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<std::stringstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<std::stringstream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<std::wstringstream>;
template void format_argument<std::wstringstream>::static_output<char>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<signed char>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<unsigned char>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<wchar_t>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<short>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<unsigned short>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<int>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<unsigned int>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<long>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<unsigned long>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<long long>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<unsigned long long>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<wchar_t *>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<wchar_t const *>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<std::wstring>(std::wstringstream &, format_flags const &, void const *);
template void format_argument<std::wstringstream>::static_output<std::wstring_view>(std::wstringstream &, format_flags const &, void const *);
template bool format_argument<std::wstringstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<std::wstringstream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<std::wstringstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<std::wstringstream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument<ovectorstream>;
template void format_argument<ovectorstream>::static_output<char>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<signed char>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<unsigned char>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<short>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<unsigned short>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<int>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<unsigned int>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<long>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<unsigned long>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<long long>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<unsigned long long>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<char *>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<char const *>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<std::string>(ovectorstream &, format_flags const &, void const *);
template void format_argument<ovectorstream>::static_output<std::string_view>(ovectorstream &, format_flags const &, void const *);
template bool format_argument<ovectorstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<ovectorstream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<ovectorstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<ovectorstream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<wovectorstream>;
template void format_argument<wovectorstream>::static_output<char>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<signed char>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<unsigned char>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<wchar_t>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<short>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<unsigned short>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<int>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<unsigned int>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<long>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<unsigned long>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<long long>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<unsigned long long>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<wchar_t *>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<wchar_t const *>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<std::wstring>(wovectorstream &, format_flags const &, void const *);
template void format_argument<wovectorstream>::static_output<std::wstring_view>(wovectorstream &, format_flags const &, void const *);
template bool format_argument<wovectorstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<wovectorstream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<wovectorstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<wovectorstream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument<vectorstream>;
template void format_argument<vectorstream>::static_output<char>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<signed char>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<unsigned char>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<short>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<unsigned short>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<int>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<unsigned int>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<long>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<unsigned long>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<long long>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<unsigned long long>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<char *>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<char const *>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<std::string>(vectorstream &, format_flags const &, void const *);
template void format_argument<vectorstream>::static_output<std::string_view>(vectorstream &, format_flags const &, void const *);
template bool format_argument<vectorstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<char *>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<char const *>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<std::string>(void const *, int &);
template bool format_argument<vectorstream>::static_make_integer<std::string_view>(void const *, int &);
template void format_argument<vectorstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<char *>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<char const *>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<std::string>(void const *, std::streamoff);
template void format_argument<vectorstream>::static_store_integer<std::string_view>(void const *, std::streamoff);

template class format_argument<wvectorstream>;
template void format_argument<wvectorstream>::static_output<char>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<signed char>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<unsigned char>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<wchar_t>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<short>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<unsigned short>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<int>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<unsigned int>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<long>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<unsigned long>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<long long>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<unsigned long long>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<wchar_t *>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<wchar_t const *>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<std::wstring>(wvectorstream &, format_flags const &, void const *);
template void format_argument<wvectorstream>::static_output<std::wstring_view>(wvectorstream &, format_flags const &, void const *);
template bool format_argument<wvectorstream>::static_make_integer<char>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<signed char>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<unsigned char>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<wchar_t>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<short>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<unsigned short>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<int>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<unsigned int>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<long>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<unsigned long>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<long long>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<unsigned long long>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<wchar_t *>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<wchar_t const *>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<std::wstring>(void const *, int &);
template bool format_argument<wvectorstream>::static_make_integer<std::wstring_view>(void const *, int &);
template void format_argument<wvectorstream>::static_store_integer<char>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<signed char>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<unsigned char>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<wchar_t>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<short>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<unsigned short>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<int>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<unsigned int>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<long>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<unsigned long>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<long long>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<unsigned long long>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<wchar_t *>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<wchar_t const *>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<std::wstring>(void const *, std::streamoff);
template void format_argument<wvectorstream>::static_store_integer<std::wstring_view>(void const *, std::streamoff);

template class format_argument_pack<std::ostream>;
template class format_argument_pack<std::wostream>;
template class format_argument_pack<std::iostream>;
template class format_argument_pack<std::wiostream>;
template class format_argument_pack<std::ostringstream>;
template class format_argument_pack<std::wostringstream>;
template class format_argument_pack<std::stringstream>;
template class format_argument_pack<std::wstringstream>;
template class format_argument_pack<ovectorstream>;
template class format_argument_pack<wovectorstream>;
template class format_argument_pack<vectorstream>;
template class format_argument_pack<wvectorstream>;

template std::ostream::off_type stream_format(std::ostream &, format_argument_pack<std::ostream> const &);
template std::wostream::off_type stream_format(std::wostream &, format_argument_pack<std::wostream> const &);
template std::iostream::off_type stream_format(std::iostream &, format_argument_pack<std::ostream> const &);
template std::iostream::off_type stream_format(std::iostream &, format_argument_pack<std::iostream> const &);
template std::wiostream::off_type stream_format(std::wiostream &, format_argument_pack<std::wostream> const &);
template std::wiostream::off_type stream_format(std::wiostream &, format_argument_pack<std::wiostream> const &);
template std::ostringstream::off_type stream_format(std::ostringstream &, format_argument_pack<std::ostream> const &);
template std::ostringstream::off_type stream_format(std::ostringstream &, format_argument_pack<std::ostringstream> const &);
template std::wostringstream::off_type stream_format(std::wostringstream &, format_argument_pack<std::wostream> const &);
template std::wostringstream::off_type stream_format(std::wostringstream &, format_argument_pack<std::wostringstream> const &);
template std::stringstream::off_type stream_format(std::stringstream &, format_argument_pack<std::ostream> const &);
template std::stringstream::off_type stream_format(std::stringstream &, format_argument_pack<std::iostream> const &);
template std::stringstream::off_type stream_format(std::stringstream &, format_argument_pack<std::stringstream> const &);
template std::wstringstream::off_type stream_format(std::wstringstream &, format_argument_pack<std::wostream> const &);
template std::wstringstream::off_type stream_format(std::wstringstream &, format_argument_pack<std::wiostream> const &);
template std::wstringstream::off_type stream_format(std::wstringstream &, format_argument_pack<std::wstringstream> const &);
template ovectorstream::off_type stream_format(ovectorstream &, format_argument_pack<std::ostream> const &);
template ovectorstream::off_type stream_format(ovectorstream &, format_argument_pack<ovectorstream> const &);
template wovectorstream::off_type stream_format(wovectorstream &, format_argument_pack<std::wostream> const &);
template wovectorstream::off_type stream_format(wovectorstream &, format_argument_pack<wovectorstream> const &);
template vectorstream::off_type stream_format(vectorstream &, format_argument_pack<std::ostream> const &);
template vectorstream::off_type stream_format(vectorstream &, format_argument_pack<std::iostream> const &);
template vectorstream::off_type stream_format(vectorstream &, format_argument_pack<vectorstream> const &);
template wvectorstream::off_type stream_format(wvectorstream &, format_argument_pack<std::wostream> const &);
template wvectorstream::off_type stream_format(wvectorstream &, format_argument_pack<std::wiostream> const &);
template wvectorstream::off_type stream_format(wvectorstream &, format_argument_pack<wvectorstream> const &);

} // namespace detail

} // namespace util
