/***************************************************************************
                         cbase32.cpp  -  description
                             -------------------
    begin                : Sat Apr 24 2004
    copyright            : (C) 2004-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cbase32.h"

#include <stdio.h>
#include <stdlib.h>

#include "cbytearray.h"
#include "cstring.h"

const signed char CBase32::Index_32[256] = {
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,26,27,28,29,30,31,-1,-1,-1,-1,-1,-1,-1,-1,
	-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
	15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,
	-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,
	15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
};

const char CBase32::B32Chars[33] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";

#define base32val(c) Index_32[(unsigned int)(c)]
#define base32chars(c) B32Chars[(unsigned int)(c&0x3F)]

/** */
CBase32::CBase32()
{
}

/** */
CBase32::~CBase32()
{
}

/* raw bytes to null-terminated base 64 string */
void CBase32::Encode( CString * dst, CByteArray * src )
{
	if ( !dst || !src )
	{
		return;
	}	
	
	unsigned char word;
	size_t index = 0, i = 0;
	const size_t len = src->Size();

	dst->Empty();

	while ( i < len )
	{
		/* Is the current word going to span a byte boundary? */
		if ( index > 3 )
		{
			word = (src->Data()[i] & (0xFF >> index));
			index = (index + 5) % 8;
			word <<= index;
			
			if ( (i + 1) < len )
			{
				word |= src->Data()[i + 1] >> (8 - index);
			}

			i++;
		}
		else
		{
			word = (src->Data()[i] >> (8 - (index + 5))) & 0x1F;
			index = (index + 5) % 8;
			
			if ( index == 0 )
			{
				i++;
			}
		}

		dst->Append( B32Chars[word] );
	}
}

/* Convert '\0'-terminated base 64 string to raw bytes.
 * Returns length of returned buffer, or -1 on error */
unsigned long CBase32::Decode( CByteArray * dst, CString * src )
{
	unsigned char c = 0;
	size_t index = 0, offset = 0;
	signed char tmp;
	
	if ( !dst || !src )
	{
		return -1;
	}

	dst->SetSize(0);

	for ( long i = 0; i < src->Length(); ++i )
	{
		// Skip what we don't recognise
		tmp = Index_32[(const unsigned char) (src->Data()[i])];

		if ( tmp == -1 )
		{
			continue;
		}

		if ( index <= 3 )
		{
			index = (index + 5) % 8;
			if ( index == 0 )
			{
				if ( dst->Size() <= offset )
				{
					c = 0;
					dst->Append(&c,1);
				}
				dst->Data()[offset] |= tmp;
				offset++;
			}
			else
			{
				if ( i < src->Length()-1 )
				{
					if ( dst->Size() <= offset )
					{
						c = 0;
						dst->Append(&c,1);
					}
					dst->Data()[offset] |= tmp << (8 - index);
				}
			}
		}
		else
		{
			index = (index + 5) % 8;
			if ( dst->Size() <= offset )
			{
				c = 0;
				dst->Append(&c,1);
			}
			dst->Data()[offset] |= (tmp >> index);
			offset++;
			if ( i < src->Length()-1 )
			{
				if ( dst->Size() <= offset )
				{
					c = 0;
					dst->Append(&c,1);
				}
				dst->Data()[offset] |= tmp << (8 - index);
			}
		}
	}

	return dst->Size();
}
