/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.lisaac.ldt.model.AbstractLisaacParser;
import org.lisaac.ldt.model.ILisaacContext;
import org.lisaac.ldt.model.ILisaacModel;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.SectionContext;
import org.lisaac.ldt.model.SlotContext;
import org.lisaac.ldt.model.items.IArgument;
import org.lisaac.ldt.model.items.ICode;
import org.lisaac.ldt.model.items.IConstant;
import org.lisaac.ldt.model.items.ITMArgs;
import org.lisaac.ldt.model.items.ITMArgument;
import org.lisaac.ldt.model.items.ITMBlock;
import org.lisaac.ldt.model.items.ITMCharacter;
import org.lisaac.ldt.model.items.ITMExpression;
import org.lisaac.ldt.model.items.ITMExternal;
import org.lisaac.ldt.model.items.ITMExternalType;
import org.lisaac.ldt.model.items.ITMLDots;
import org.lisaac.ldt.model.items.ITMList;
import org.lisaac.ldt.model.items.ITMListIdf;
import org.lisaac.ldt.model.items.ITMLocal;
import org.lisaac.ldt.model.items.ITMNumber;
import org.lisaac.ldt.model.items.ITMOld;
import org.lisaac.ldt.model.items.ITMOperator;
import org.lisaac.ldt.model.items.ITMPrototype;
import org.lisaac.ldt.model.items.ITMRead;
import org.lisaac.ldt.model.items.ITMReadArg1;
import org.lisaac.ldt.model.items.ITMReadArg2;
import org.lisaac.ldt.model.items.ITMReadArgs;
import org.lisaac.ldt.model.items.ITMReal;
import org.lisaac.ldt.model.items.ITMResult;
import org.lisaac.ldt.model.items.ITMString;
import org.lisaac.ldt.model.items.ITMWrite;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Section;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.model.types.IType;
import org.lisaac.ldt.model.types.ITypeMono;
import org.lisaac.ldt.model.types.TypeBlock;
import org.lisaac.ldt.model.types.TypeGeneric;
import org.lisaac.ldt.model.types.TypeMulti;
import org.lisaac.ldt.model.types.TypeParameter;
import org.lisaac.ldt.model.types.TypeSelf;
import org.lisaac.ldt.model.types.TypeSimple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LisaacParser
extends AbstractLisaacParser {
    private String selfType;
    private ILisaacContext sectionContext;
    private ILisaacContext slotContext;
    private Slot lastSlot;
    private ITMList lastGroup;
    private Section lastSection;

    public LisaacParser(String selfType, InputStream contents, ILisaacModel model) {
        super(contents, model);
        this.model = model;
        this.selfType = selfType;
        this.sectionContext = new SectionContext(this);
        this.slotContext = new SlotContext(this);
        this.initialize();
    }

    public LisaacParser(String selfType, String contents) {
        super(contents);
        this.selfType = selfType;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        TypeSimple.init();
    }

    public void enableErrorReport(boolean enable) {
        this.reporter.enableErrorReport(enable);
    }

    public ILisaacContext getSectionContext() {
        return this.sectionContext;
    }

    public Slot getLastSlot() {
        return this.lastSlot;
    }

    public void setLastSection(Section section) {
        if (this.lastSection != null) {
            Position pos = this.lastSection.getPosition();
            pos.setLength(this.position - pos.offset);
            this.lastSection.setNext(section);
        }
        this.lastSection = section;
    }

    public ITypeMono[] readTypeList(boolean isSection) {
        ArrayList<ITypeMono> lst = null;
        ITypeMono t = this.readType(false);
        if (t != null) {
            if (isSection && !(t instanceof TypeSimple) && !(t instanceof TypeSelf)) {
                this.reporter.syntaxError("For a section, the prototype name only (without '('...')').", this.getLine());
                return null;
            }
            lst = new ArrayList<ITypeMono>();
            lst.add(t);
            while (this.readCharacter(',')) {
                t = this.readType(false);
                if (t == null) {
                    this.reporter.syntaxError("Incorrect type list.", this.getLine());
                    return null;
                }
                if (isSection && !(t instanceof TypeSimple) && !(t instanceof TypeSelf)) {
                    this.reporter.syntaxError("For a section, the prototype name only (without '('...')').", this.getLine());
                    return null;
                }
                lst.add(t);
            }
        }
        if (lst != null) {
            return lst.toArray(new ITypeMono[lst.size()]);
        }
        return null;
    }

    public ITypeMono readType(boolean isLocal) {
        ITypeMono result = null;
        ITypeMono[] lst = null;
        IType typ_arg = null;
        IType typ_res = null;
        String style = null;
        if (this.readCharacter('{')) {
            if (this.readCharacter('(')) {
                lst = this.readTypeList(false);
                if (lst == null) {
                    this.reporter.syntaxError("Incorrect type list.", this.getLine());
                    return null;
                }
                typ_arg = lst.length == 1 ? lst[0] : TypeMulti.get(lst);
                if (!this.readCharacter(')')) {
                    this.reporter.syntaxError("Added ')'.", this.getLine());
                    return null;
                }
                if (!this.readCharacter(';')) {
                    this.reporter.syntaxError("Added ';'.", this.getLine());
                }
                lst = this.readTypeList(false);
            } else {
                lst = this.readTypeList(false);
                if (lst != null && this.readCharacter(';')) {
                    typ_arg = lst.length == 1 ? lst[0] : TypeMulti.get(lst);
                    lst = this.readTypeList(false);
                }
            }
            if (lst != null) {
                typ_res = lst.length == 1 ? lst[0] : TypeMulti.get(lst);
            }
            if (!this.readCharacter('}')) {
                this.reporter.syntaxError("Added '}'.", this.getLine());
                return null;
            }
            result = TypeBlock.get(typ_arg, typ_res);
        } else {
            if (this.readThisKeyword("Expanded") || this.readThisKeyword("Strict")) {
                style = this.getLastString();
                if (isLocal && style.equals("Expanded")) {
                    int len = "Expanded".length();
                    this.reporter.syntaxError("`Expanded' is not possible.", this.getPosition(len));
                }
            }
            result = this.readPrototype(style);
        }
        return result;
    }

    public ITypeMono readPrototype(String style) {
        ITypeMono result = null;
        String name = null;
        if (this.readCapIdentifier()) {
            name = this.getString(this.lastString);
            if (this.readCharacter('(')) {
                ArrayList<ITypeMono> genericity = new ArrayList<ITypeMono>();
                do {
                    ITypeMono t;
                    if ((t = this.readParamType()) == null) {
                        this.reporter.syntaxError("Type needed.", this.getLine());
                        return null;
                    }
                    genericity.add(t);
                } while (this.readCharacter(','));
                result = new TypeGeneric(name, style, genericity.toArray(new ITypeMono[genericity.size()]));
                if (!this.readCharacter(')')) {
                    this.reporter.syntaxError("Added ')'.", this.getLine());
                    return result;
                }
            } else if (this.isParameterType) {
                if (style != null) {
                    this.reporter.warning("Style `" + style + "' for parameter type is ignored.", this.getPosition(name.length()));
                }
                result = TypeParameter.get(name);
            } else if (style == null) {
                result = name.equals("SELF") ? TypeSelf.get(this.selfType) : TypeSimple.get(name);
            } else if (name.equals("SELF")) {
                this.reporter.warning("Style `" + style + "' ignored.", this.getPosition(name.length()));
                result = TypeSelf.get(this.selfType);
            } else {
                result = name.equals("SELF") ? TypeSelf.get(this.selfType) : TypeSimple.get(name);
            }
        }
        return result;
    }

    private ITypeMono readParamType() {
        IConstant cst;
        ITypeMono result = this.readType(false);
        if (result == null && (cst = this.readConstant()) == null) {
            this.readIdentifier();
        }
        return result;
    }

    public boolean readSlot(Prototype prototype) {
        boolean result = false;
        char style = this.readStyle();
        if (style != ' ') {
            IType t;
            result = true;
            this.lastSlot = this.readTypeSlot();
            if (this.lastSlot == null) {
                this.reporter.syntaxError("Incorrect slot declaration.", this.getLine());
                return false;
            }
            this.lastSlot.setStyle(style);
            char affect = this.readAffect() ? (char)this.lastString.charAt(0) : (char)' ';
            if (affect == ' ' && this.readCharacter(':')) {
                if (this.readCharacter('(')) {
                    ITypeMono[] lt = this.readTypeList(false);
                    if (lt == null) {
                        this.reporter.syntaxError("Incorrect result type.", this.getLine());
                        return false;
                    }
                    if (!this.readCharacter(')')) {
                        this.reporter.warning("Added ')' is needed.", this.getLine());
                    }
                    t = TypeMulti.get(lt);
                } else {
                    t = this.readType(false);
                    if (t == null) {
                        this.reporter.syntaxError("Incorrect result type.", this.getLine());
                        return false;
                    }
                }
                if (this.readAffect()) {
                    affect = this.lastString.charAt(0);
                }
            } else {
                t = TypeSimple.getTypeVoid();
            }
            this.lastSlot.setResultType(t);
            this.lastSlot.setAffect(affect);
            this.setCatchComment();
            if (affect != ' ') {
                this.readSpace();
                this.setCatchCommentOff();
                this.readDefSlot();
            }
            if (!this.readCharacter(';')) {
                this.reporter.syntaxError("Added ';'.", this.getLine());
                return false;
            }
            this.updateLine();
            Position body = this.lastSlot.getPositionBody();
            if (body.line != this.pos_line) {
                body.setLength(this.position - body.offset);
            } else {
                this.lastSlot.setBody(null);
            }
            if (lastComment != null && lastComment.length() > 0) {
                this.lastSlot.setComment(lastComment);
            }
            if (lastComment != null && this.lastSection.isInheritOrInsert()) {
                Slot s = prototype.getParentSlot(this.lastSlot.getName());
                if (s != null) {
                    this.reporter.semanticError("Double slot declaration.", this.getPosition());
                } else {
                    prototype.addParentSlot(this.lastSlot);
                }
            } else {
                Slot s = prototype.getSlot(this.lastSlot.getName());
                if (s != null) {
                    this.reporter.semanticError("Double slot declaration.", this.getPosition());
                } else {
                    prototype.addSlot(this.lastSlot);
                    this.lastSection.addSlot(this.lastSlot);
                }
            }
        }
        return result;
    }

    private void readDefSlot() {
        this.readRequire();
        ICode expr = this.readExpr();
        if (expr == null) {
            this.reporter.syntaxError("Incorrect expression.", this.getLine());
        }
        this.lastSlot.setValue(expr);
        this.readEnsure();
    }

    public Slot readTypeSlot() {
        Slot result = null;
        IArgument arg = null;
        ArrayList<IArgument> list_arg = new ArrayList<IArgument>();
        arg = this.readLocArg(false, true);
        if (arg == null) {
            result = this.readCharacter('\'') ? this.readSlotOperator(list_arg) : this.readSlotKeyword(list_arg);
        } else {
            list_arg.add(arg);
            if (this.readCharacter('.')) {
                result = this.readSlotKeyword(list_arg);
            } else if (this.readCharacter('\'')) {
                result = this.readSlotOperator(list_arg);
            }
        }
        if (result != null) {
            result.setArgumentList(list_arg.toArray(new IArgument[list_arg.size()]));
        }
        return result;
    }

    private Slot readSlotKeyword(ArrayList<IArgument> list_arg) {
        Slot result = null;
        Position slotPosition = this.getPosition();
        Position slotBody = this.getPosition();
        int start_pos = this.position;
        if (this.readIdentifier()) {
            String n = new String(this.lastString);
            ArrayList<String> keywords = new ArrayList<String>();
            keywords.add(n);
            IArgument arg = this.readLocArg(false, false);
            if (arg != null) {
                list_arg.add(arg);
                if (this.readIdentifier()) {
                    do {
                        n = String.valueOf(n) + "__" + this.lastString;
                        keywords.add(new String(this.lastString));
                        arg = this.readLocArg(false, false);
                        if (arg == null) {
                            this.reporter.syntaxError("Incorrect symbol.", this.getLine());
                            return null;
                        }
                        list_arg.add(arg);
                    } while (this.readIdentifier());
                }
            }
            slotPosition.setLength(this.position - start_pos);
            result = new Slot(slotPosition, this.getString(n), this.lastSection);
            result.setKeywordList(keywords.toArray(new String[keywords.size()]));
            result.setBody(slotBody);
        }
        return result;
    }

    public IArgument readLocArg(boolean mute, boolean selfFirst) {
        IArgument result = null;
        if (selfFirst && this.readThisKeyword("Self") || !selfFirst && this.readIdentifier()) {
            int startPos = this.position;
            String n = new String(this.lastString);
            if (this.readCharacter(':') && this.lastCharacter() != '=') {
                ITypeMono t = this.readType(true);
                if (t == null) {
                    this.reporter.syntaxError("Incorrect type.", this.getLine());
                    return null;
                }
                Position p = this.getPosition();
                p.offset = startPos;
                result = new ITMArgument(n, t, p);
            } else if (!mute) {
                this.reporter.warning("Added ':' is needed.", this.getLine());
            }
        } else if (this.readCharacter('(')) {
            result = this.readLocalArg(mute, selfFirst);
            if (result == null) {
                if (!mute) {
                    this.reporter.syntaxError("Incorrect argument definition.", this.getLine());
                    return null;
                }
            } else if (!this.readCharacter(')')) {
                this.reporter.warning("Added ')'.", this.getPosition());
            }
        }
        return result;
    }

    private IArgument readLocalArg(boolean m, boolean s) {
        IArgument result = null;
        boolean mute = m;
        int firstPos = this.position;
        if (s && this.readThisKeyword("Self") || this.readIdentifier()) {
            int startPos;
            ArrayList<String> name = new ArrayList<String>();
            ArrayList<ITypeMono> type = new ArrayList<ITypeMono>();
            int beg = 0;
            do {
                if (name.size() != 0 && !this.readIdentifier() && !mute) {
                    this.reporter.syntaxError("Incorrect argument identifier.", this.getLine());
                    return null;
                }
                startPos = this.position;
                name.add(this.lastString);
                if (!this.readCharacter(':') || this.lastCharacter() == '=') continue;
                mute = false;
                ITypeMono t = this.readType(true);
                if (t == null) {
                    this.reporter.syntaxError("Incorrect argument type.", this.getLine());
                    return null;
                }
                int i = beg;
                while (i < name.size()) {
                    type.add(t);
                    ++i;
                }
                beg = name.size();
            } while (this.readCharacter(','));
            if (beg != name.size()) {
                if (!mute) {
                    this.reporter.syntaxError("Incorrect argument type.", this.getLine());
                    return null;
                }
            } else if (name.size() == 1) {
                Position p = new Position(0, 0, startPos, 0);
                result = new ITMArgument((String)name.get(0), (ITypeMono)type.get(0), p);
            } else {
                TypeMulti tm = new TypeMulti(type.toArray(new ITypeMono[type.size()]));
                result = new ITMArgs(name.toArray(new String[name.size()]), tm, this.getPosition(this.position - firstPos));
            }
        }
        return result;
    }

    private Slot readSlotOperator(ArrayList<IArgument> list_arg) {
        Slot result = null;
        String associativity = null;
        int priority = 0;
        Position slotPosition = this.getPosition();
        Position slotBody = this.getPosition();
        if (!this.readOperator()) {
            this.reporter.syntaxError("Operator is needed.", this.getLine());
            return null;
        }
        if (this.lastString.equals("=") || this.lastString.equals("!=")) {
            this.reporter.syntaxError("Incorrect operator.", this.getLine());
            return null;
        }
        String name = new String(this.lastString);
        slotPosition.setLength(name.length());
        if (!this.readCharacter('\'')) {
            this.reporter.warning("Added `''.", this.getLine());
        }
        if (this.readThisKeyword("Left") || this.readThisKeyword("Right")) {
            associativity = new String(this.lastString);
            if (this.readInteger()) {
                priority = (int)this.lastInteger;
            }
        }
        if (list_arg.isEmpty()) {
            IArgument arg = this.readLocArg(false, true);
            if (arg == null) {
                this.reporter.syntaxError("Operator declaration invalid.", this.getLine());
                return null;
            }
            if (arg != null) {
                list_arg.add(arg);
            }
            name = this.getOperator("__prefix", name);
            if (associativity != null) {
                this.reporter.syntaxError("No associativity for postfix operator.", this.getLine());
            }
        } else {
            IArgument arg = this.readLocArg(false, false);
            if (arg != null) {
                list_arg.add(arg);
                name = this.getOperator("__infix", name);
                if (associativity == null) {
                    associativity = "Left";
                }
            } else {
                name = this.getOperator("__postfix", name);
                if (associativity != null) {
                    this.reporter.syntaxError("No associativity for prefix operator.", this.getLine());
                }
            }
        }
        result = new Slot(slotPosition, name, this.lastSection);
        result.setAssociativity(associativity, priority);
        result.setBody(slotBody);
        return result;
    }

    private String getOperator(String typ, String op) {
        StringBuffer s = new StringBuffer(typ);
        int i = 0;
        while (i < op.length()) {
            char c = op.charAt(i);
            switch (c) {
                case '+': {
                    s.append("_add");
                    break;
                }
                case '-': {
                    s.append("_sub");
                    break;
                }
                case '~': {
                    s.append("_logicnot");
                    break;
                }
                case '!': {
                    s.append("_not");
                    break;
                }
                case '/': {
                    s.append("_div");
                    break;
                }
                case '*': {
                    s.append("_mul");
                    break;
                }
                case '^': {
                    s.append("_xor");
                    break;
                }
                case '%': {
                    s.append("_mod");
                    break;
                }
                case '>': {
                    s.append("_greater");
                    break;
                }
                case '<': {
                    s.append("_less");
                    break;
                }
                case '=': {
                    s.append("_equal");
                    break;
                }
                case '\\': {
                    s.append("_notdiv");
                    break;
                }
                case '|': {
                    s.append("_or");
                    break;
                }
                case '&': {
                    s.append("_and");
                    break;
                }
                case '$': {
                    s.append("_dollar");
                    break;
                }
                case '#': {
                    s.append("_diese");
                    break;
                }
                case '@': {
                    s.append("_at");
                    break;
                }
                case '?': {
                    s.append("_ask");
                }
            }
            ++i;
        }
        return this.getString(s.toString());
    }

    public ICode readExpr() {
        ICode result = null;
        String string_tmp2 = "";
        this.saveContext();
        if (this.readCharacter('(')) {
            boolean again;
            ArrayList<String> l_assignment = new ArrayList<String>();
            do {
                again = false;
                if (!this.readIdentifier()) continue;
                string_tmp2 = new String(this.lastString);
                while (this.readIdentifier()) {
                    string_tmp2 = String.valueOf(string_tmp2) + "__" + this.lastString;
                }
                String name = this.getString(string_tmp2);
                l_assignment.add(name);
                if (!this.readCharacter(',')) continue;
                again = true;
            } while (again);
            if (!l_assignment.isEmpty() && this.readCharacter(')') && this.readAffect()) {
                result = new ITMListIdf(l_assignment);
                char affect = this.lastString.charAt(0);
                ICode value = this.readExpr();
                if (value == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                if (affect == '<') {
                    this.reporter.syntaxError("Impossible '<-' style assignment with vector.", this.getPosition(this.lastString.length()));
                    return null;
                }
                result = new ITMWrite(result, value, affect);
            }
        } else if (this.readIdentifier()) {
            string_tmp2 = new String(this.lastString);
            while (this.readIdentifier()) {
                string_tmp2 = String.valueOf(string_tmp2) + "__" + this.lastString;
            }
            String name = this.getString(string_tmp2);
            if (this.readAffect()) {
                result = new ITMRead(name);
                char affect = this.lastString.charAt(0);
                ICode value = this.readExpr();
                if (value == null) {
                    this.reporter.syntaxError("Incorrect expression.", this.getLine());
                    return null;
                }
                result = new ITMWrite(result, value, affect);
            }
        }
        if (result == null) {
            this.restoreContext();
            result = this.readExprOperator();
        }
        return result;
    }

    private ICode readExprOperator() {
        ICode expr;
        ICode result = null;
        ArrayList<ICode> l_expr = new ArrayList<ICode>();
        while (this.readOperator()) {
            expr = new ITMOperator(new String(this.lastString));
            l_expr.add(expr);
        }
        expr = this.readExprMessage();
        if (expr == null) {
            if (l_expr.size() > 0) {
                this.reporter.syntaxError("Incorrect expression.", this.getLine());
            }
        } else {
            ITMOperator itm_op;
            int last_msg;
            int first_msg = l_expr.size();
            do {
                last_msg = l_expr.size();
                l_expr.add(expr);
                if (this.readOperator()) {
                    do {
                        expr = new ITMOperator(new String(this.lastString));
                        l_expr.add(expr);
                    } while (this.readOperator());
                    expr = this.readExprMessage();
                    continue;
                }
                expr = null;
            } while (expr != null);
            while (last_msg < l_expr.size() - 1) {
                itm_op = (ITMOperator)l_expr.get(last_msg + 1);
                expr = new ITMReadArg1(this.getOperator("__postfix", itm_op.getName()), (ICode)l_expr.get(last_msg));
                l_expr.set(last_msg, expr);
                l_expr.remove(last_msg + 1);
            }
            if (last_msg - first_msg < 3) {
                while (first_msg != 0) {
                    itm_op = (ITMOperator)l_expr.get(first_msg - 1);
                    expr = new ITMReadArg1(this.getOperator("__prefix", itm_op.getName()), (ICode)l_expr.get(first_msg));
                    l_expr.add(first_msg, expr);
                    l_expr.remove(--first_msg);
                }
            }
            if (l_expr.size() == 1) {
                result = (ICode)l_expr.get(0);
            } else if (l_expr.size() == 3) {
                itm_op = (ITMOperator)l_expr.get(1);
                result = new ITMReadArg2(this.getOperator("__infix", itm_op.getName()), (ICode)l_expr.get(0), (ICode)l_expr.get(2));
            } else {
                result = new ITMExpression(l_expr.toArray(new ICode[l_expr.size()]));
            }
        }
        return result;
    }

    protected ICode readExprMessage() {
        ICode result = this.readExprBase();
        if (result != null) {
            while (this.readCharacter('.')) {
                if ((result = this.readSendMsg(result)) != null) continue;
                this.reporter.syntaxError("Incorrect message.", this.getLine());
                return null;
            }
        }
        return result;
    }

    public ICode readExprBase() {
        ICode result = null;
        if (this.readThisKeyword("Old")) {
            ICode old_value = this.readExpr();
            if (old_value == null) {
                this.reporter.syntaxError("Incorrect `Old' expression.", this.getLine());
                return null;
            }
            result = new ITMOld(old_value);
        } else {
            result = this.readExprPrimary();
            if (result == null) {
                result = this.readSendMsg(null);
            }
        }
        return result;
    }

    public ICode readExprPrimary() {
        ICode result = null;
        String result_id = null;
        ITypeMono type = null;
        ITMList group_sav = null;
        this.readSpace();
        Position pos = this.getPosition();
        if (this.readThisKeyword("Self")) {
            result = new ITMRead(new String(this.lastString));
        } else if (this.readThisKeyword("Result")) {
            if (this.lastCharacter() == '_') {
                ++this.position;
                this.string_tmp = "Result_";
                while (Character.isDigit(this.lastCharacter())) {
                    this.string_tmp = String.valueOf(this.string_tmp) + this.lastCharacter();
                    ++this.position;
                }
                if (this.string_tmp.length() <= 0) {
                    this.reporter.syntaxError("Incorrect Result number.", this.getLine());
                }
                result_id = this.getString(this.string_tmp);
            } else {
                result_id = "Result";
            }
            result = new ITMRead(result_id);
        } else {
            type = this.readPrototype(null);
            if (type != null) {
                result = new ITMPrototype(type, pos);
            } else {
                result = this.readConstant();
                if (result == null) {
                    if (this.readCharacter('(')) {
                        group_sav = this.lastGroup;
                        this.lastGroup = new ITMList(this.lastSlot, this.position);
                        result = this.lastGroup;
                        this.lastGroup.setCode(this.readGroup());
                        if (!this.readCharacter(')')) {
                            this.reporter.syntaxError("Added ')'.", this.getLine());
                            return null;
                        }
                        this.lastGroup.setEndOffset(this.position);
                        this.lastGroup = group_sav;
                    } else if (this.readCharacter('{')) {
                        group_sav = this.lastGroup;
                        this.lastGroup = new ITMList(this.lastSlot, this.position);
                        this.saveContext();
                        IArgument arg = this.readLocArg(true, false);
                        if (arg != null) {
                            if (!this.readCharacter(';')) {
                                this.reporter.syntaxError("Added ';'.", this.getLine());
                                return null;
                            }
                        } else {
                            this.restoreContext();
                        }
                        result = new ITMBlock(this.lastGroup, arg, this.lastSlot);
                        this.lastGroup.setCode(this.readGroup());
                        if (!this.readCharacter('}')) {
                            this.reporter.syntaxError("Added '}'.", this.getLine());
                            return null;
                        }
                        this.lastGroup.setEndOffset(this.position);
                        this.lastGroup = group_sav;
                    } else if (this.readExternal()) {
                        if (!this.readCharacter(':')) {
                            result = new ITMExternal(new String(this.lastString));
                        } else {
                            boolean persistant = this.readCharacter('(');
                            ITMExternalType ext = new ITMExternalType(new String(this.lastString), persistant);
                            type = this.readType(false);
                            if (type == null) {
                                this.reporter.syntaxError("Incorrect type.", this.getLine());
                                return null;
                            }
                            ext.setType(type);
                            if (this.readCharacter('{')) {
                                ITypeMono[] ltype = this.readTypeList(false);
                                if (ltype == null) {
                                    this.reporter.syntaxError("Incorrect live type list.", this.getLine());
                                    return null;
                                }
                                if (!this.readCharacter('}')) {
                                    this.reporter.syntaxError("Added '}'.", this.getLine());
                                    return null;
                                }
                                ext.setTypeList(ltype);
                            }
                            if (ext.isPersistant() && !this.readCharacter(')')) {
                                this.reporter.syntaxError("Added '}'.", this.getLine());
                                return null;
                            }
                            result = ext;
                        }
                    }
                }
            }
        }
        return result;
    }

    private IConstant readConstant() {
        IConstant result = null;
        if (this.readReal()) {
            result = new ITMReal(new String(this.lastReal));
        } else if (this.readInteger()) {
            result = new ITMNumber(this.lastInteger);
        } else if (this.readCharacters()) {
            result = new ITMCharacter(new String(this.lastString));
        } else if (this.readString()) {
            result = new ITMString(new String(this.lastString));
        }
        return result;
    }

    private ICode[] readGroup() {
        this.readDefLocal();
        ArrayList<ICode> result = new ArrayList<ICode>();
        ICode e = this.readExpr();
        while (e != null && this.readCharacter(';')) {
            result.add(e);
            e = this.readExpr();
        }
        if (e != null) {
            if (this.readCharacter(',')) {
                do {
                    e = new ITMResult(e);
                    result.add(e);
                    e = this.readExpr();
                    while (e != null && this.readCharacter(';')) {
                        result.add(e);
                        e = this.readExpr();
                    }
                    if (e != null) continue;
                    this.reporter.syntaxError("Incorrect multiple result expression.", this.getLine());
                    return null;
                } while (this.readCharacter(','));
            }
            e = new ITMResult(e);
            result.add(e);
        }
        return result.toArray(new ICode[result.size()]);
    }

    private void readDefLocal() {
        this.saveContext();
        int style = this.readStyle();
        ArrayList<ITMLocal> local_list = new ArrayList<ITMLocal>();
        ArrayList<ITMLocal> static_list = new ArrayList<ITMLocal>();
        while (style != 32) {
            List<ITMLocal> loc_lst = this.readLocal(true);
            if (loc_lst != null) {
                if (style == 43) {
                    local_list.addAll(loc_lst);
                } else {
                    static_list.addAll(loc_lst);
                }
                if (!this.readCharacter(';')) {
                    this.reporter.syntaxError("Added ';'.", this.getLine());
                }
                this.saveContext();
                style = this.readStyle();
                continue;
            }
            this.restoreContext();
            style = 32;
        }
        if (!local_list.isEmpty()) {
            this.lastGroup.setLocalList(local_list.toArray(new ITMLocal[local_list.size()]));
        }
        if (!static_list.isEmpty()) {
            this.lastGroup.setStaticList(static_list.toArray(new ITMLocal[static_list.size()]));
        }
    }

    public ICode readSendMsg(ICode firstArg) {
        ITMRead result = null;
        if (this.readIdentifier()) {
            String n = this.getString(this.lastString);
            LinkedList<ICode> l_arg = new LinkedList<ICode>();
            ICode arg = this.readArgument();
            if (arg != null) {
                l_arg.addLast(arg);
                while (this.readIdentifier()) {
                    n = String.valueOf(n) + "__" + this.lastString;
                    arg = this.readArgument();
                    if (arg == null) {
                        this.reporter.syntaxError("Incorrect argument.", this.getLine());
                        return null;
                    }
                    l_arg.addLast(arg);
                }
            }
            String name = this.getString(n);
            if (l_arg.isEmpty()) {
                result = firstArg == null ? new ITMRead(name) : new ITMReadArg1(name, firstArg);
            } else if (l_arg.size() == 1) {
                result = new ITMReadArg2(name, firstArg, (ICode)l_arg.get(0));
            } else {
                l_arg.addFirst(firstArg);
                result = new ITMReadArgs(name, l_arg.toArray(new ICode[l_arg.size()]));
            }
        }
        return result;
    }

    private ICode readArgument() {
        ICode result = this.readExprPrimary();
        if (result == null && this.readIdentifier()) {
            result = new ITMRead(new String(this.lastString));
        }
        return result;
    }

    private List<ITMLocal> readLocal(boolean m) {
        LinkedList<ITMLocal> result = null;
        int beg = 0;
        boolean mute = m;
        if (this.readIdentifier()) {
            result = new LinkedList<ITMLocal>();
            do {
                if (result.size() != 0 && !this.readIdentifier() && !mute) {
                    this.reporter.syntaxError("Incorrect identifier.", this.getLine());
                    return null;
                }
                ITMLocal loc = new ITMLocal(new String(this.lastString), this.getPosition());
                result.add(loc);
                if (!this.readCharacter(':') || this.lastCharacter() == '=') continue;
                mute = false;
                ITypeMono t = this.readType(false);
                if (t == null) {
                    this.reporter.syntaxError("Incorrect local type.", this.getLine());
                    return null;
                }
                int j = beg;
                while (j < result.size()) {
                    ((ITMLocal)result.get(j)).setType(t);
                    ++j;
                }
                beg = result.size();
            } while (this.readCharacter(','));
            if (beg != result.size()) {
                if (mute) {
                    result = null;
                } else {
                    this.reporter.syntaxError("Incorrect local type.", this.getLine());
                    return null;
                }
            }
        }
        return result;
    }

    public boolean readRequire() {
        boolean result = false;
        ITMList lst = this.readContract();
        if (lst != null) {
            result = true;
        }
        return result;
    }

    public boolean readEnsure() {
        boolean result = false;
        ITMList lst = this.readContract();
        if (lst != null) {
            result = true;
        }
        return result;
    }

    private ITMList readContract() {
        ITMList result = null;
        if (this.readCharacter('[')) {
            this.lastGroup = result = new ITMList(this.lastSlot, this.position);
            this.readDefLocal();
            ArrayList<ICode> lst = new ArrayList<ICode>();
            boolean doContinue = false;
            do {
                ICode e;
                if ((e = this.readExpr()) == null) {
                    doContinue = this.readWord("...");
                    if (!doContinue) continue;
                    lst.add(new ITMLDots());
                    continue;
                }
                lst.add(e);
                if (!this.readCharacter(';')) {
                    this.reporter.syntaxError("Added ';'.", this.getLine());
                    return null;
                }
                doContinue = true;
            } while (doContinue);
            if (!this.readCharacter(']')) {
                this.reporter.syntaxError("Added ']'.", this.getLine());
                return null;
            }
            result.setCode(lst.toArray(new ICode[lst.size()]));
            result.setEndOffset(this.position);
        }
        return result;
    }

    public boolean skipUntilThisKeyword(String st) {
        boolean result = false;
        while (!this.isEOF() && !result) {
            int idx = 0;
            while ((this.readSpace() || this.lastCharacter() == '\n') && this.lastCharacter() != st.charAt(idx)) {
                ++this.position;
            }
            int posold = this.position++;
            ++idx;
            if (this.isEOF()) continue;
            while (idx <= st.length() - 1 && this.lastCharacter() == st.charAt(idx)) {
                ++this.position;
                ++idx;
            }
            if (idx <= st.length() - 1) continue;
            this.lastString = st;
            this.position = posold;
            result = true;
        }
        return result;
    }

    public String readSlotNameFromOffset(int offset, boolean modifyCurrentOffset) {
        String result = null;
        int oldPosition = this.position;
        this.position = offset;
        if (!this.skipLocalArg(true)) {
            result = this.readCharacter('\'') ? this.readSlotNameOperator() : this.readSlotNameKeyword();
        } else if (this.readCharacter('.')) {
            result = this.readSlotNameKeyword();
        } else if (this.readCharacter('\'')) {
            result = this.readSlotNameOperator();
        }
        if (!modifyCurrentOffset) {
            this.position = oldPosition;
        }
        return result;
    }

    public boolean skipLocalArg(boolean selfFirst) {
        boolean result = false;
        if (selfFirst && this.readThisKeyword("Self") || !selfFirst && this.readIdentifier()) {
            if (this.readCharacter(':') && this.lastCharacter() != '=') {
                return this.skipType();
            }
        } else if (this.readCharacter('(')) {
            result = this.skipLocal(selfFirst);
            if (!result) {
                return false;
            }
            if (!this.readCharacter(')')) {
                return false;
            }
            result = true;
        }
        return result;
    }

    private boolean skipLocal(boolean s) {
        boolean result = false;
        if (s && this.readThisKeyword("Self") || this.readIdentifier()) {
            int size = 0;
            do {
                if (size != 0 && !this.readIdentifier()) {
                    return false;
                }
                ++size;
                if (!this.readCharacter(':') || this.lastCharacter() == '=') continue;
                if (!this.skipType()) {
                    return false;
                }
                result = true;
            } while (this.readCharacter(','));
        }
        return result;
    }

    private String readSlotNameKeyword() {
        String result = null;
        if (this.readIdentifier()) {
            result = new String(this.lastString);
            if (this.skipLocalArg(false) && this.readIdentifier()) {
                do {
                    result = String.valueOf(result) + "__" + this.lastString;
                    if (this.skipLocalArg(false)) continue;
                    return null;
                } while (this.readIdentifier());
            }
        }
        return result;
    }

    private String readSlotNameOperator() {
        String result = null;
        if (!this.readOperator()) {
            return null;
        }
        result = new String(this.lastString);
        result = this.getOperator("__infix", result);
        return result;
    }

    public boolean skipType() {
        boolean result = false;
        if (this.readCharacter('{')) {
            if (this.readCharacter('(')) {
                result = this.skipTypeList();
                if (!result) {
                    return false;
                }
                if (!this.readCharacter(')')) {
                    return false;
                }
                if (!this.readCharacter(';')) {
                    return false;
                }
                result = this.skipTypeList();
            } else {
                result = this.skipTypeList();
                if (result && this.readCharacter(';')) {
                    result = this.skipTypeList();
                }
            }
            if (!this.readCharacter('}')) {
                return false;
            }
            result = true;
        } else {
            if (!this.readThisKeyword("Expanded")) {
                this.readThisKeyword("Strict");
            }
            result = this.skipPrototype();
        }
        return result;
    }

    public boolean skipTypeList() {
        boolean result = false;
        result = this.skipType();
        if (result) {
            while (this.readCharacter(',')) {
                result = this.skipType();
                if (result) continue;
                return false;
            }
        }
        return result;
    }

    public boolean skipPrototype() {
        boolean result = false;
        if (this.readCapIdentifier()) {
            if (this.readCharacter('(')) {
                do {
                    if (this.skipParamType()) continue;
                    return false;
                } while (this.readCharacter(','));
                if (!this.readCharacter(')')) {
                    return false;
                }
                result = true;
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean skipParamType() {
        return this.skipType();
    }

    public String readKeywordInSendMsg(String keyword, int keywordOffset) {
        String result = null;
        boolean keywordFound = false;
        if (this.readIdentifier()) {
            ICode arg;
            String n = this.getString(this.lastString);
            if (n.compareTo(keyword) == 0 && this.position == keywordOffset + keyword.length()) {
                keywordFound = true;
            }
            if ((arg = this.readArgument()) != null) {
                while (this.readIdentifier()) {
                    if (this.lastString.compareTo(keyword) == 0 && this.position == keywordOffset + keyword.length()) {
                        keywordFound = true;
                    }
                    n = String.valueOf(n) + "__" + this.lastString;
                    arg = this.readArgument();
                    if (arg != null) continue;
                    this.reporter.syntaxError("Incorrect argument.", this.getPosition());
                    return null;
                }
            }
            result = this.getString(n);
        }
        if (!keywordFound) {
            result = null;
        }
        return result;
    }

    public ILisaacContext readContext() {
        this.readSpace();
        int old_pos = this.position;
        if (this.readThisKeyword("Section")) {
            this.position = old_pos;
            return this.sectionContext;
        }
        if (this.readCharacter('-') || this.readCharacter('+')) {
            this.position = old_pos;
            return this.slotContext;
        }
        this.position = old_pos;
        if (this.position >= this.source.length() - 1) {
            return null;
        }
        this.reporter.syntaxError("Syntax error", this.getLine());
        return this.sectionContext.getNextContext();
    }
}

