/***********************************************************************************

    Copyright (C) 2007-2018 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETCHART_HEADER
#define LIFEOGRAPH_WIDGETCHART_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "helpers.hpp"
#include "chart.hpp"


namespace LIFEO
{

using namespace HELPERS;


class WidgetChart : public Gtk::DrawingArea, public Chart
{
    public:
                                    WidgetChart( BaseObjectType*,
                                                 const Glib::RefPtr< Gtk::Builder >& );

        void                        update() override
        {
            if( Glib::RefPtr< Gdk::Window > window = get_window() )
                window->invalidate( false );
        }

    protected:
        void                        on_size_allocate( Gtk::Allocation& );
        bool                        on_scroll_event( GdkEventScroll* );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_button_release_event( GdkEventButton* );
        bool                        on_motion_notify_event( GdkEventMotion* );
        bool                        on_leave_notify_event( GdkEventCrossing* );
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& );

//        bool                        handle_query_tooltip( int, int, bool,
//                                                          const Glib::RefPtr< Gtk::Tooltip >& );
};

} // end of namespace LIFEO

#endif
