import typing as ty

if ty.TYPE_CHECKING:
    from gettext import gettext as _


ACCELERATOR_NAMES: ty.Final = {
    # TRANS: Names of accelerators in the interface
    "activate": _("Alternate Activate"),
    # TRANS: The "Comma Trick"/"Put Selection on Stack" allows the
    # TRANS: user to select many objects to be used for one action
    "comma_trick": _("Comma Trick"),
    # TRANS: "Compose Command" makes one object out of the selected
    # TRANS: object + action (+iobject)
    "compose_action": _("Compose Command"),
    "mark_as_default": _("Mark Default Action"),
    "erase_affinity_for_first_pane": _("Forget Object"),
    "reset_all": _("Reset All"),
    "select_quit": _("Select Quit"),
    "select_selected_file": _("Select Selected File"),
    "select_selected_text": _("Select Selected Text"),
    "select_clipboard_file": _("Select Clipboard File"),
    "select_clipboard_text": _("Select Clipboard Text"),
    "show_help": _("Show Help"),
    "show_preferences": _("Show Preferences"),
    "switch_to_source": _("Switch to 1st Pane"),
    "switch_to_2": _("Switch to 2nd Pane"),
    "switch_to_3": _("Switch to 3rd Pane"),
    "toggle_text_mode_quick": _("Toggle Text Mode"),
}
