/*
    msnchallengehandler.h - Computes a msn challenge response hash key.

    Copyright (c) 2005 by Gregg Edghill       <gregg.edghill@gmail.com>
    Kopete    (c) 2003-2005 by The Kopete developers <kopete-devel@kde.org>

    Portions taken from
    	http://msnpiki.msnfanatic.com/index.php/MSNP11:Challenges

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef MSNCHALLENGEHANDLER_H
#define MSNCHALLENGEHANDLER_H

#include <QString>
#include <QVector>



/**
 * Provides a simple way to compute a msn challenge response hash key.
 *
 * @author Gregg Edghill
 * @ingroup NetworkCore
 */
class MSNChallengeHandler
{
  public:
                    MSNChallengeHandler();
                    ~MSNChallengeHandler();

    /**
    * Computes the response hash string for the specified challenge string.
    */

    const QString   computeHash( const QString& challengeString );

    /**
    * Returns the product id used by the challenge handler.
    */
    const QString&  getProductId() const;

  private: // Private method

    /**
    * Creates a 64-bit hash key.
    */
    qint64          createHashKey( const QVector<qint32>& md5Integers, const QVector<qint32>& challengeIntegers );

    /**
    * Swaps the bytes in a hex string.
    */
    const QString   hexSwap( const QString& in );

  private: // Private attributes

    QString         productKey_;
    QString         productId_;
};

#endif
