
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTreeView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTreeView>
#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHeaderView>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QItemSelection>
#include <QItemSelectionModel>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QModelIndex>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QStyleOptionViewItem>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTreeView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTreeView::staticMetaObject);
}


// bool QTreeView::allColumnsShowFocus()


static void _init_f_allColumnsShowFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_allColumnsShowFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->allColumnsShowFocus ());
}


// int QTreeView::autoExpandDelay()


static void _init_f_autoExpandDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_autoExpandDelay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView *)cls)->autoExpandDelay ());
}


// void QTreeView::collapse(const QModelIndex &index)


static void _init_f_collapse_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_collapse_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->collapse (arg1);
}


// void QTreeView::collapseAll()


static void _init_f_collapseAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_collapseAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->collapseAll ();
}


// int QTreeView::columnAt(int x)


static void _init_f_columnAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTreeView *)cls)->columnAt (arg1));
}


// int QTreeView::columnViewportPosition(int column)


static void _init_f_columnViewportPosition_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnViewportPosition_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTreeView *)cls)->columnViewportPosition (arg1));
}


// int QTreeView::columnWidth(int column)


static void _init_f_columnWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_columnWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTreeView *)cls)->columnWidth (arg1));
}


// void QTreeView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)


static void _init_f_dataChanged_6833 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles", true, "QList<int>()");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_dataChanged_6833 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QList<int> &arg3 = args ? gsi::arg_reader<const QList<int> & >() (args, heap) : gsi::arg_maker<const QList<int> & >() (QList<int>(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->dataChanged (arg1, arg2, arg3);
}


// void QTreeView::doItemsLayout()


static void _init_f_doItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_doItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->doItemsLayout ();
}


// void QTreeView::expand(const QModelIndex &index)


static void _init_f_expand_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_expand_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->expand (arg1);
}


// void QTreeView::expandAll()


static void _init_f_expandAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_expandAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->expandAll ();
}


// void QTreeView::expandRecursively(const QModelIndex &index, int depth)


static void _init_f_expandRecursively_3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("depth", true, "-1");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_expandRecursively_3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->expandRecursively (arg1, arg2);
}


// void QTreeView::expandToDepth(int depth)


static void _init_f_expandToDepth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("depth");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_expandToDepth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->expandToDepth (arg1);
}


// bool QTreeView::expandsOnDoubleClick()


static void _init_f_expandsOnDoubleClick_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_expandsOnDoubleClick_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->expandsOnDoubleClick ());
}


// QHeaderView *QTreeView::header()


static void _init_f_header_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHeaderView * > ();
}

static void _call_f_header_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHeaderView * > ((QHeaderView *)((QTreeView *)cls)->header ());
}


// void QTreeView::hideColumn(int column)


static void _init_f_hideColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_hideColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->hideColumn (arg1);
}


// int QTreeView::indentation()


static void _init_f_indentation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_indentation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView *)cls)->indentation ());
}


// QModelIndex QTreeView::indexAbove(const QModelIndex &index)


static void _init_f_indexAbove_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexAbove_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTreeView *)cls)->indexAbove (arg1));
}


// QModelIndex QTreeView::indexAt(const QPoint &p)


static void _init_f_indexAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTreeView *)cls)->indexAt (arg1));
}


// QModelIndex QTreeView::indexBelow(const QModelIndex &index)


static void _init_f_indexBelow_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexBelow_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QModelIndex > ((QModelIndex)((QTreeView *)cls)->indexBelow (arg1));
}


// bool QTreeView::isAnimated()


static void _init_f_isAnimated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAnimated_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->isAnimated ());
}


// bool QTreeView::isColumnHidden(int column)


static void _init_f_isColumnHidden_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isColumnHidden_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTreeView *)cls)->isColumnHidden (arg1));
}


// bool QTreeView::isExpanded(const QModelIndex &index)


static void _init_f_isExpanded_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isExpanded_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QTreeView *)cls)->isExpanded (arg1));
}


// bool QTreeView::isFirstColumnSpanned(int row, const QModelIndex &parent)


static void _init_f_isFirstColumnSpanned_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isFirstColumnSpanned_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QTreeView *)cls)->isFirstColumnSpanned (arg1, arg2));
}


// bool QTreeView::isHeaderHidden()


static void _init_f_isHeaderHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHeaderHidden_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->isHeaderHidden ());
}


// bool QTreeView::isRowHidden(int row, const QModelIndex &parent)


static void _init_f_isRowHidden_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isRowHidden_c3054 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<bool > ((bool)((QTreeView *)cls)->isRowHidden (arg1, arg2));
}


// bool QTreeView::isSortingEnabled()


static void _init_f_isSortingEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortingEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->isSortingEnabled ());
}


// bool QTreeView::itemsExpandable()


static void _init_f_itemsExpandable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_itemsExpandable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->itemsExpandable ());
}


// void QTreeView::keyboardSearch(const QString &search)


static void _init_f_keyboardSearch_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_keyboardSearch_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->keyboardSearch (arg1);
}


// void QTreeView::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->reset ();
}


// void QTreeView::resetIndentation()


static void _init_f_resetIndentation_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetIndentation_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->resetIndentation ();
}


// void QTreeView::resizeColumnToContents(int column)


static void _init_f_resizeColumnToContents_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resizeColumnToContents_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->resizeColumnToContents (arg1);
}


// bool QTreeView::rootIsDecorated()


static void _init_f_rootIsDecorated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_rootIsDecorated_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->rootIsDecorated ());
}


// void QTreeView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)


static void _init_f_scrollTo_5576 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollTo_5576 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->scrollTo (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}


// void QTreeView::selectAll()


static void _init_f_selectAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_selectAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->selectAll ();
}


// void QTreeView::setAllColumnsShowFocus(bool enable)


static void _init_f_setAllColumnsShowFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAllColumnsShowFocus_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setAllColumnsShowFocus (arg1);
}


// void QTreeView::setAnimated(bool enable)


static void _init_f_setAnimated_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnimated_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setAnimated (arg1);
}


// void QTreeView::setAutoExpandDelay(int delay)


static void _init_f_setAutoExpandDelay_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delay");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoExpandDelay_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setAutoExpandDelay (arg1);
}


// void QTreeView::setColumnHidden(int column, bool hide)


static void _init_f_setColumnHidden_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hide");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnHidden_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setColumnHidden (arg1, arg2);
}


// void QTreeView::setColumnWidth(int column, int width)


static void _init_f_setColumnWidth_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("width");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setColumnWidth_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setColumnWidth (arg1, arg2);
}


// void QTreeView::setExpanded(const QModelIndex &index, bool expand)


static void _init_f_setExpanded_3151 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("expand");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setExpanded_3151 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setExpanded (arg1, arg2);
}


// void QTreeView::setExpandsOnDoubleClick(bool enable)


static void _init_f_setExpandsOnDoubleClick_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExpandsOnDoubleClick_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setExpandsOnDoubleClick (arg1);
}


// void QTreeView::setFirstColumnSpanned(int row, const QModelIndex &parent, bool span)


static void _init_f_setFirstColumnSpanned_3810 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("span");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setFirstColumnSpanned_3810 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  bool arg3 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setFirstColumnSpanned (arg1, arg2, arg3);
}


// void QTreeView::setHeader(QHeaderView *header)


static void _init_f_setHeader_1699 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("header");
  decl->add_arg<QHeaderView * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeader_1699 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHeaderView *arg1 = gsi::arg_reader<QHeaderView * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setHeader (arg1);
}


// void QTreeView::setHeaderHidden(bool hide)


static void _init_f_setHeaderHidden_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hide");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderHidden_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setHeaderHidden (arg1);
}


// void QTreeView::setIndentation(int i)


static void _init_f_setIndentation_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIndentation_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setIndentation (arg1);
}


// void QTreeView::setItemsExpandable(bool enable)


static void _init_f_setItemsExpandable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemsExpandable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setItemsExpandable (arg1);
}


// void QTreeView::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setModel (arg1);
}


// void QTreeView::setRootIndex(const QModelIndex &index)


static void _init_f_setRootIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIndex_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setRootIndex (arg1);
}


// void QTreeView::setRootIsDecorated(bool show)


static void _init_f_setRootIsDecorated_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("show");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIsDecorated_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setRootIsDecorated (arg1);
}


// void QTreeView::setRowHidden(int row, const QModelIndex &parent, bool hide)


static void _init_f_setRowHidden_3810 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("hide");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setRowHidden_3810 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  bool arg3 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setRowHidden (arg1, arg2, arg3);
}


// void QTreeView::setSelectionModel(QItemSelectionModel *selectionModel)


static void _init_f_setSelectionModel_2533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionModel_2533 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemSelectionModel *arg1 = gsi::arg_reader<QItemSelectionModel * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setSelectionModel (arg1);
}


// void QTreeView::setSortingEnabled(bool enable)


static void _init_f_setSortingEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortingEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setSortingEnabled (arg1);
}


// void QTreeView::setTreePosition(int logicalIndex)


static void _init_f_setTreePosition_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTreePosition_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setTreePosition (arg1);
}


// void QTreeView::setUniformRowHeights(bool uniform)


static void _init_f_setUniformRowHeights_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uniform");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUniformRowHeights_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setUniformRowHeights (arg1);
}


// void QTreeView::setWordWrap(bool on)


static void _init_f_setWordWrap_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWordWrap_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->setWordWrap (arg1);
}


// void QTreeView::showColumn(int column)


static void _init_f_showColumn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_showColumn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->showColumn (arg1);
}


// void QTreeView::sortByColumn(int column, Qt::SortOrder order)


static void _init_f_sortByColumn_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sortByColumn_2340 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<Qt::SortOrder>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView *)cls)->sortByColumn (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}


// int QTreeView::treePosition()


static void _init_f_treePosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_treePosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView *)cls)->treePosition ());
}


// bool QTreeView::uniformRowHeights()


static void _init_f_uniformRowHeights_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_uniformRowHeights_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->uniformRowHeights ());
}


// QRect QTreeView::visualRect(const QModelIndex &index)


static void _init_f_visualRect_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualRect_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QRect > ((QRect)((QTreeView *)cls)->visualRect (arg1));
}


// bool QTreeView::wordWrap()


static void _init_f_wordWrap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_wordWrap_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView *)cls)->wordWrap ());
}


// static QString QTreeView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTreeView::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTreeView () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":allColumnsShowFocus", "@brief Method bool QTreeView::allColumnsShowFocus()\n", true, &_init_f_allColumnsShowFocus_c0, &_call_f_allColumnsShowFocus_c0);
  methods += new qt_gsi::GenericMethod (":autoExpandDelay", "@brief Method int QTreeView::autoExpandDelay()\n", true, &_init_f_autoExpandDelay_c0, &_call_f_autoExpandDelay_c0);
  methods += new qt_gsi::GenericMethod ("collapse", "@brief Method void QTreeView::collapse(const QModelIndex &index)\n", false, &_init_f_collapse_2395, &_call_f_collapse_2395);
  methods += new qt_gsi::GenericMethod ("collapseAll", "@brief Method void QTreeView::collapseAll()\n", false, &_init_f_collapseAll_0, &_call_f_collapseAll_0);
  methods += new qt_gsi::GenericMethod ("columnAt", "@brief Method int QTreeView::columnAt(int x)\n", true, &_init_f_columnAt_c767, &_call_f_columnAt_c767);
  methods += new qt_gsi::GenericMethod ("columnViewportPosition", "@brief Method int QTreeView::columnViewportPosition(int column)\n", true, &_init_f_columnViewportPosition_c767, &_call_f_columnViewportPosition_c767);
  methods += new qt_gsi::GenericMethod ("columnWidth", "@brief Method int QTreeView::columnWidth(int column)\n", true, &_init_f_columnWidth_c767, &_call_f_columnWidth_c767);
  methods += new qt_gsi::GenericMethod ("dataChanged", "@brief Method void QTreeView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nThis is a reimplementation of QAbstractItemView::dataChanged", false, &_init_f_dataChanged_6833, &_call_f_dataChanged_6833);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@brief Method void QTreeView::doItemsLayout()\nThis is a reimplementation of QAbstractItemView::doItemsLayout", false, &_init_f_doItemsLayout_0, &_call_f_doItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("expand", "@brief Method void QTreeView::expand(const QModelIndex &index)\n", false, &_init_f_expand_2395, &_call_f_expand_2395);
  methods += new qt_gsi::GenericMethod ("expandAll", "@brief Method void QTreeView::expandAll()\n", false, &_init_f_expandAll_0, &_call_f_expandAll_0);
  methods += new qt_gsi::GenericMethod ("expandRecursively", "@brief Method void QTreeView::expandRecursively(const QModelIndex &index, int depth)\n", false, &_init_f_expandRecursively_3054, &_call_f_expandRecursively_3054);
  methods += new qt_gsi::GenericMethod ("expandToDepth", "@brief Method void QTreeView::expandToDepth(int depth)\n", false, &_init_f_expandToDepth_767, &_call_f_expandToDepth_767);
  methods += new qt_gsi::GenericMethod (":expandsOnDoubleClick", "@brief Method bool QTreeView::expandsOnDoubleClick()\n", true, &_init_f_expandsOnDoubleClick_c0, &_call_f_expandsOnDoubleClick_c0);
  methods += new qt_gsi::GenericMethod (":header", "@brief Method QHeaderView *QTreeView::header()\n", true, &_init_f_header_c0, &_call_f_header_c0);
  methods += new qt_gsi::GenericMethod ("hideColumn", "@brief Method void QTreeView::hideColumn(int column)\n", false, &_init_f_hideColumn_767, &_call_f_hideColumn_767);
  methods += new qt_gsi::GenericMethod (":indentation", "@brief Method int QTreeView::indentation()\n", true, &_init_f_indentation_c0, &_call_f_indentation_c0);
  methods += new qt_gsi::GenericMethod ("indexAbove", "@brief Method QModelIndex QTreeView::indexAbove(const QModelIndex &index)\n", true, &_init_f_indexAbove_c2395, &_call_f_indexAbove_c2395);
  methods += new qt_gsi::GenericMethod ("indexAt", "@brief Method QModelIndex QTreeView::indexAt(const QPoint &p)\nThis is a reimplementation of QAbstractItemView::indexAt", true, &_init_f_indexAt_c1916, &_call_f_indexAt_c1916);
  methods += new qt_gsi::GenericMethod ("indexBelow", "@brief Method QModelIndex QTreeView::indexBelow(const QModelIndex &index)\n", true, &_init_f_indexBelow_c2395, &_call_f_indexBelow_c2395);
  methods += new qt_gsi::GenericMethod ("isAnimated?|:animated", "@brief Method bool QTreeView::isAnimated()\n", true, &_init_f_isAnimated_c0, &_call_f_isAnimated_c0);
  methods += new qt_gsi::GenericMethod ("isColumnHidden?", "@brief Method bool QTreeView::isColumnHidden(int column)\n", true, &_init_f_isColumnHidden_c767, &_call_f_isColumnHidden_c767);
  methods += new qt_gsi::GenericMethod ("isExpanded?", "@brief Method bool QTreeView::isExpanded(const QModelIndex &index)\n", true, &_init_f_isExpanded_c2395, &_call_f_isExpanded_c2395);
  methods += new qt_gsi::GenericMethod ("isFirstColumnSpanned?", "@brief Method bool QTreeView::isFirstColumnSpanned(int row, const QModelIndex &parent)\n", true, &_init_f_isFirstColumnSpanned_c3054, &_call_f_isFirstColumnSpanned_c3054);
  methods += new qt_gsi::GenericMethod ("isHeaderHidden?|:headerHidden", "@brief Method bool QTreeView::isHeaderHidden()\n", true, &_init_f_isHeaderHidden_c0, &_call_f_isHeaderHidden_c0);
  methods += new qt_gsi::GenericMethod ("isRowHidden?", "@brief Method bool QTreeView::isRowHidden(int row, const QModelIndex &parent)\n", true, &_init_f_isRowHidden_c3054, &_call_f_isRowHidden_c3054);
  methods += new qt_gsi::GenericMethod ("isSortingEnabled?|:sortingEnabled", "@brief Method bool QTreeView::isSortingEnabled()\n", true, &_init_f_isSortingEnabled_c0, &_call_f_isSortingEnabled_c0);
  methods += new qt_gsi::GenericMethod (":itemsExpandable", "@brief Method bool QTreeView::itemsExpandable()\n", true, &_init_f_itemsExpandable_c0, &_call_f_itemsExpandable_c0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@brief Method void QTreeView::keyboardSearch(const QString &search)\nThis is a reimplementation of QAbstractItemView::keyboardSearch", false, &_init_f_keyboardSearch_2025, &_call_f_keyboardSearch_2025);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QTreeView::reset()\nThis is a reimplementation of QAbstractItemView::reset", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("resetIndentation", "@brief Method void QTreeView::resetIndentation()\n", false, &_init_f_resetIndentation_0, &_call_f_resetIndentation_0);
  methods += new qt_gsi::GenericMethod ("resizeColumnToContents", "@brief Method void QTreeView::resizeColumnToContents(int column)\n", false, &_init_f_resizeColumnToContents_767, &_call_f_resizeColumnToContents_767);
  methods += new qt_gsi::GenericMethod (":rootIsDecorated", "@brief Method bool QTreeView::rootIsDecorated()\n", true, &_init_f_rootIsDecorated_c0, &_call_f_rootIsDecorated_c0);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Method void QTreeView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis is a reimplementation of QAbstractItemView::scrollTo", false, &_init_f_scrollTo_5576, &_call_f_scrollTo_5576);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Method void QTreeView::selectAll()\nThis is a reimplementation of QAbstractItemView::selectAll", false, &_init_f_selectAll_0, &_call_f_selectAll_0);
  methods += new qt_gsi::GenericMethod ("setAllColumnsShowFocus|allColumnsShowFocus=", "@brief Method void QTreeView::setAllColumnsShowFocus(bool enable)\n", false, &_init_f_setAllColumnsShowFocus_864, &_call_f_setAllColumnsShowFocus_864);
  methods += new qt_gsi::GenericMethod ("setAnimated|animated=", "@brief Method void QTreeView::setAnimated(bool enable)\n", false, &_init_f_setAnimated_864, &_call_f_setAnimated_864);
  methods += new qt_gsi::GenericMethod ("setAutoExpandDelay|autoExpandDelay=", "@brief Method void QTreeView::setAutoExpandDelay(int delay)\n", false, &_init_f_setAutoExpandDelay_767, &_call_f_setAutoExpandDelay_767);
  methods += new qt_gsi::GenericMethod ("setColumnHidden", "@brief Method void QTreeView::setColumnHidden(int column, bool hide)\n", false, &_init_f_setColumnHidden_1523, &_call_f_setColumnHidden_1523);
  methods += new qt_gsi::GenericMethod ("setColumnWidth", "@brief Method void QTreeView::setColumnWidth(int column, int width)\n", false, &_init_f_setColumnWidth_1426, &_call_f_setColumnWidth_1426);
  methods += new qt_gsi::GenericMethod ("setExpanded", "@brief Method void QTreeView::setExpanded(const QModelIndex &index, bool expand)\n", false, &_init_f_setExpanded_3151, &_call_f_setExpanded_3151);
  methods += new qt_gsi::GenericMethod ("setExpandsOnDoubleClick|expandsOnDoubleClick=", "@brief Method void QTreeView::setExpandsOnDoubleClick(bool enable)\n", false, &_init_f_setExpandsOnDoubleClick_864, &_call_f_setExpandsOnDoubleClick_864);
  methods += new qt_gsi::GenericMethod ("setFirstColumnSpanned", "@brief Method void QTreeView::setFirstColumnSpanned(int row, const QModelIndex &parent, bool span)\n", false, &_init_f_setFirstColumnSpanned_3810, &_call_f_setFirstColumnSpanned_3810);
  methods += new qt_gsi::GenericMethod ("setHeader|header=", "@brief Method void QTreeView::setHeader(QHeaderView *header)\n", false, &_init_f_setHeader_1699, &_call_f_setHeader_1699);
  methods += new qt_gsi::GenericMethod ("setHeaderHidden|headerHidden=", "@brief Method void QTreeView::setHeaderHidden(bool hide)\n", false, &_init_f_setHeaderHidden_864, &_call_f_setHeaderHidden_864);
  methods += new qt_gsi::GenericMethod ("setIndentation|indentation=", "@brief Method void QTreeView::setIndentation(int i)\n", false, &_init_f_setIndentation_767, &_call_f_setIndentation_767);
  methods += new qt_gsi::GenericMethod ("setItemsExpandable|itemsExpandable=", "@brief Method void QTreeView::setItemsExpandable(bool enable)\n", false, &_init_f_setItemsExpandable_864, &_call_f_setItemsExpandable_864);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QTreeView::setModel(QAbstractItemModel *model)\nThis is a reimplementation of QAbstractItemView::setModel", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += new qt_gsi::GenericMethod ("setRootIndex|rootIndex=", "@brief Method void QTreeView::setRootIndex(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemView::setRootIndex", false, &_init_f_setRootIndex_2395, &_call_f_setRootIndex_2395);
  methods += new qt_gsi::GenericMethod ("setRootIsDecorated|rootIsDecorated=", "@brief Method void QTreeView::setRootIsDecorated(bool show)\n", false, &_init_f_setRootIsDecorated_864, &_call_f_setRootIsDecorated_864);
  methods += new qt_gsi::GenericMethod ("setRowHidden", "@brief Method void QTreeView::setRowHidden(int row, const QModelIndex &parent, bool hide)\n", false, &_init_f_setRowHidden_3810, &_call_f_setRowHidden_3810);
  methods += new qt_gsi::GenericMethod ("setSelectionModel|selectionModel=", "@brief Method void QTreeView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis is a reimplementation of QAbstractItemView::setSelectionModel", false, &_init_f_setSelectionModel_2533, &_call_f_setSelectionModel_2533);
  methods += new qt_gsi::GenericMethod ("setSortingEnabled|sortingEnabled=", "@brief Method void QTreeView::setSortingEnabled(bool enable)\n", false, &_init_f_setSortingEnabled_864, &_call_f_setSortingEnabled_864);
  methods += new qt_gsi::GenericMethod ("setTreePosition|treePosition=", "@brief Method void QTreeView::setTreePosition(int logicalIndex)\n", false, &_init_f_setTreePosition_767, &_call_f_setTreePosition_767);
  methods += new qt_gsi::GenericMethod ("setUniformRowHeights|uniformRowHeights=", "@brief Method void QTreeView::setUniformRowHeights(bool uniform)\n", false, &_init_f_setUniformRowHeights_864, &_call_f_setUniformRowHeights_864);
  methods += new qt_gsi::GenericMethod ("setWordWrap|wordWrap=", "@brief Method void QTreeView::setWordWrap(bool on)\n", false, &_init_f_setWordWrap_864, &_call_f_setWordWrap_864);
  methods += new qt_gsi::GenericMethod ("showColumn", "@brief Method void QTreeView::showColumn(int column)\n", false, &_init_f_showColumn_767, &_call_f_showColumn_767);
  methods += new qt_gsi::GenericMethod ("sortByColumn", "@brief Method void QTreeView::sortByColumn(int column, Qt::SortOrder order)\n", false, &_init_f_sortByColumn_2340, &_call_f_sortByColumn_2340);
  methods += new qt_gsi::GenericMethod (":treePosition", "@brief Method int QTreeView::treePosition()\n", true, &_init_f_treePosition_c0, &_call_f_treePosition_c0);
  methods += new qt_gsi::GenericMethod (":uniformRowHeights", "@brief Method bool QTreeView::uniformRowHeights()\n", true, &_init_f_uniformRowHeights_c0, &_call_f_uniformRowHeights_c0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@brief Method QRect QTreeView::visualRect(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemView::visualRect", true, &_init_f_visualRect_c2395, &_call_f_visualRect_c2395);
  methods += new qt_gsi::GenericMethod (":wordWrap", "@brief Method bool QTreeView::wordWrap()\n", true, &_init_f_wordWrap_c0, &_call_f_wordWrap_c0);
  methods += gsi::qt_signal<const QModelIndex & > ("activated(const QModelIndex &)", "activated", gsi::arg("index"), "@brief Signal declaration for QTreeView::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("clicked(const QModelIndex &)", "clicked", gsi::arg("index"), "@brief Signal declaration for QTreeView::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("collapsed(const QModelIndex &)", "collapsed", gsi::arg("index"), "@brief Signal declaration for QTreeView::collapsed(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTreeView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTreeView::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("doubleClicked(const QModelIndex &)", "doubleClicked", gsi::arg("index"), "@brief Signal declaration for QTreeView::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("entered(const QModelIndex &)", "entered", gsi::arg("index"), "@brief Signal declaration for QTreeView::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("expanded(const QModelIndex &)", "expanded", gsi::arg("index"), "@brief Signal declaration for QTreeView::expanded(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSize & > ("iconSizeChanged(const QSize &)", "iconSizeChanged", gsi::arg("size"), "@brief Signal declaration for QTreeView::iconSizeChanged(const QSize &size)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QTreeView::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("pressed(const QModelIndex &)", "pressed", gsi::arg("index"), "@brief Signal declaration for QTreeView::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("viewportEntered()", "viewportEntered", "@brief Signal declaration for QTreeView::viewportEntered()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QTreeView::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QTreeView::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QTreeView::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTreeView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractItemView> &qtdecl_QAbstractItemView ();

qt_gsi::QtNativeClass<QTreeView> decl_QTreeView (qtdecl_QAbstractItemView (), "QtWidgets", "QTreeView_Native",
  methods_QTreeView (),
  "@hide\n@alias QTreeView");

GSI_QTWIDGETS_PUBLIC gsi::Class<QTreeView> &qtdecl_QTreeView () { return decl_QTreeView; }

}


class QTreeView_Adaptor : public QTreeView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTreeView_Adaptor();

  //  [adaptor ctor] QTreeView::QTreeView(QWidget *parent)
  QTreeView_Adaptor() : QTreeView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTreeView::QTreeView(QWidget *parent)
  QTreeView_Adaptor(QWidget *parent) : QTreeView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTreeView::columnCountChanged(int oldCount, int newCount)
  void fp_QTreeView_columnCountChanged_1426 (int oldCount, int newCount) {
    QTreeView::columnCountChanged(oldCount, newCount);
  }

  //  [expose] void QTreeView::columnMoved()
  void fp_QTreeView_columnMoved_0 () {
    QTreeView::columnMoved();
  }

  //  [expose] void QTreeView::columnResized(int column, int oldSize, int newSize)
  void fp_QTreeView_columnResized_2085 (int column, int oldSize, int newSize) {
    QTreeView::columnResized(column, oldSize, newSize);
  }

  //  [expose] void QTreeView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTreeView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTreeView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTreeView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTreeView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTreeView::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] QPoint QTreeView::dirtyRegionOffset()
  QPoint fp_QTreeView_dirtyRegionOffset_c0 () const {
    return QTreeView::dirtyRegionOffset();
  }

  //  [expose] void QTreeView::doAutoScroll()
  void fp_QTreeView_doAutoScroll_0 () {
    QTreeView::doAutoScroll();
  }

  //  [expose] void QTreeView::drawFrame(QPainter *)
  void fp_QTreeView_drawFrame_1426 (QPainter *arg1) {
    QTreeView::drawFrame(arg1);
  }

  //  [expose] void QTreeView::drawTree(QPainter *painter, const QRegion &region)
  void fp_QTreeView_drawTree_c3324 (QPainter *painter, const QRegion &region) const {
    QTreeView::drawTree(painter, region);
  }

  //  [expose] QAbstractItemView::DropIndicatorPosition QTreeView::dropIndicatorPosition()
  unsigned int fp_QTreeView_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QTreeView::dropIndicatorPosition());
  }

  //  [expose] void QTreeView::executeDelayedItemsLayout()
  void fp_QTreeView_executeDelayedItemsLayout_0 () {
    QTreeView::executeDelayedItemsLayout();
  }

  //  [expose] bool QTreeView::focusNextChild()
  bool fp_QTreeView_focusNextChild_0 () {
    return QTreeView::focusNextChild();
  }

  //  [expose] bool QTreeView::focusPreviousChild()
  bool fp_QTreeView_focusPreviousChild_0 () {
    return QTreeView::focusPreviousChild();
  }

  //  [expose] int QTreeView::indexRowSizeHint(const QModelIndex &index)
  int fp_QTreeView_indexRowSizeHint_c2395 (const QModelIndex &index) const {
    return QTreeView::indexRowSizeHint(index);
  }

  //  [expose] bool QTreeView::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTreeView_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTreeView::isSignalConnected(signal);
  }

  //  [expose] int QTreeView::receivers(const char *signal)
  int fp_QTreeView_receivers_c1731 (const char *signal) const {
    return QTreeView::receivers(signal);
  }

  //  [expose] void QTreeView::reexpand()
  void fp_QTreeView_reexpand_0 () {
    QTreeView::reexpand();
  }

  //  [expose] int QTreeView::rowHeight(const QModelIndex &index)
  int fp_QTreeView_rowHeight_c2395 (const QModelIndex &index) const {
    return QTreeView::rowHeight(index);
  }

  //  [expose] void QTreeView::rowsRemoved(const QModelIndex &parent, int first, int last)
  void fp_QTreeView_rowsRemoved_3713 (const QModelIndex &parent, int first, int last) {
    QTreeView::rowsRemoved(parent, first, last);
  }

  //  [expose] void QTreeView::scheduleDelayedItemsLayout()
  void fp_QTreeView_scheduleDelayedItemsLayout_0 () {
    QTreeView::scheduleDelayedItemsLayout();
  }

  //  [expose] void QTreeView::scrollDirtyRegion(int dx, int dy)
  void fp_QTreeView_scrollDirtyRegion_1426 (int dx, int dy) {
    QTreeView::scrollDirtyRegion(dx, dy);
  }

  //  [expose] QObject *QTreeView::sender()
  QObject * fp_QTreeView_sender_c0 () const {
    return QTreeView::sender();
  }

  //  [expose] int QTreeView::senderSignalIndex()
  int fp_QTreeView_senderSignalIndex_c0 () const {
    return QTreeView::senderSignalIndex();
  }

  //  [expose] void QTreeView::setDirtyRegion(const QRegion &region)
  void fp_QTreeView_setDirtyRegion_2006 (const QRegion &region) {
    QTreeView::setDirtyRegion(region);
  }

  //  [expose] void QTreeView::setState(QAbstractItemView::State state)
  void fp_QTreeView_setState_2776 (unsigned int state) {
    QTreeView::setState(QAbstractItemView::State(state));
  }

  //  [expose] void QTreeView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QTreeView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QTreeView::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QTreeView::setViewportMargins(const QMargins &margins)
  void fp_QTreeView_setViewportMargins_2115 (const QMargins &margins) {
    QTreeView::setViewportMargins(margins);
  }

  //  [expose] void QTreeView::startAutoScroll()
  void fp_QTreeView_startAutoScroll_0 () {
    QTreeView::startAutoScroll();
  }

  //  [expose] QAbstractItemView::State QTreeView::state()
  unsigned int fp_QTreeView_state_c0 () const {
    return (unsigned int)(QTreeView::state());
  }

  //  [expose] void QTreeView::stopAutoScroll()
  void fp_QTreeView_stopAutoScroll_0 () {
    QTreeView::stopAutoScroll();
  }

  //  [expose] void QTreeView::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QTreeView_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QTreeView::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [expose] QMargins QTreeView::viewportMargins()
  QMargins fp_QTreeView_viewportMargins_c0 () const {
    return QTreeView::viewportMargins();
  }

  //  [emitter impl] void QTreeView::activated(const QModelIndex &index)
  void emitter_QTreeView_activated_2395(const QModelIndex &index)
  {
    emit QTreeView::activated(index);
  }

  //  [emitter impl] void QTreeView::clicked(const QModelIndex &index)
  void emitter_QTreeView_clicked_2395(const QModelIndex &index)
  {
    emit QTreeView::clicked(index);
  }

  //  [emitter impl] void QTreeView::collapsed(const QModelIndex &index)
  void emitter_QTreeView_collapsed_2395(const QModelIndex &index)
  {
    emit QTreeView::collapsed(index);
  }

  //  [emitter impl] void QTreeView::customContextMenuRequested(const QPoint &pos)
  void emitter_QTreeView_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTreeView::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QTreeView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  void cbs_dataChanged_6833_1(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    QTreeView::dataChanged(topLeft, bottomRight, roles);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)
  {
    if (cb_dataChanged_6833_1.can_issue()) {
      cb_dataChanged_6833_1.issue<QTreeView_Adaptor, const QModelIndex &, const QModelIndex &, const QList<int> &>(&QTreeView_Adaptor::cbs_dataChanged_6833_1, topLeft, bottomRight, roles);
    } else {
      QTreeView::dataChanged(topLeft, bottomRight, roles);
    }
  }

  //  [emitter impl] void QTreeView::destroyed(QObject *)
  void emitter_QTreeView_destroyed_1302(QObject *arg1)
  {
    emit QTreeView::destroyed(arg1);
  }

  //  [adaptor impl] void QTreeView::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QTreeView::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QTreeView::doItemsLayout();
    }
  }

  //  [emitter impl] void QTreeView::doubleClicked(const QModelIndex &index)
  void emitter_QTreeView_doubleClicked_2395(const QModelIndex &index)
  {
    emit QTreeView::doubleClicked(index);
  }

  //  [emitter impl] void QTreeView::entered(const QModelIndex &index)
  void emitter_QTreeView_entered_2395(const QModelIndex &index)
  {
    emit QTreeView::entered(index);
  }

  //  [emitter impl] void QTreeView::expanded(const QModelIndex &index)
  void emitter_QTreeView_expanded_2395(const QModelIndex &index)
  {
    emit QTreeView::expanded(index);
  }

  //  [adaptor impl] bool QTreeView::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QTreeView::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QTreeView_Adaptor, bool>(&QTreeView_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QTreeView::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QTreeView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTreeView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTreeView_Adaptor, int, int>(&QTreeView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTreeView::heightForWidth(arg1);
    }
  }

  //  [emitter impl] void QTreeView::iconSizeChanged(const QSize &size)
  void emitter_QTreeView_iconSizeChanged_1805(const QSize &size)
  {
    emit QTreeView::iconSizeChanged(size);
  }

  //  [adaptor impl] QModelIndex QTreeView::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QTreeView::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QTreeView_Adaptor, QModelIndex, const QPoint &>(&QTreeView_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QTreeView::indexAt(p);
    }
  }

  //  [adaptor impl] QVariant QTreeView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QTreeView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTreeView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTreeView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QTreeView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QAbstractItemDelegate *QTreeView::itemDelegateForIndex(const QModelIndex &index)
  QAbstractItemDelegate * cbs_itemDelegateForIndex_c2395_0(const QModelIndex &index) const
  {
    return QTreeView::itemDelegateForIndex(index);
  }

  virtual QAbstractItemDelegate * itemDelegateForIndex(const QModelIndex &index) const
  {
    if (cb_itemDelegateForIndex_c2395_0.can_issue()) {
      return cb_itemDelegateForIndex_c2395_0.issue<QTreeView_Adaptor, QAbstractItemDelegate *, const QModelIndex &>(&QTreeView_Adaptor::cbs_itemDelegateForIndex_c2395_0, index);
    } else {
      return QTreeView::itemDelegateForIndex(index);
    }
  }

  //  [adaptor impl] void QTreeView::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QTreeView::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QTreeView_Adaptor, const QString &>(&QTreeView_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QTreeView::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QTreeView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTreeView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTreeView_Adaptor, QSize>(&QTreeView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTreeView::minimumSizeHint();
    }
  }

  //  [emitter impl] void QTreeView::objectNameChanged(const QString &objectName)
  void emitter_QTreeView_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QTreeView::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QTreeView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTreeView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTreeView_Adaptor, QPaintEngine *>(&QTreeView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTreeView::paintEngine();
    }
  }

  //  [emitter impl] void QTreeView::pressed(const QModelIndex &index)
  void emitter_QTreeView_pressed_2395(const QModelIndex &index)
  {
    emit QTreeView::pressed(index);
  }

  //  [adaptor impl] void QTreeView::reset()
  void cbs_reset_0_0()
  {
    QTreeView::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_reset_0_0);
    } else {
      QTreeView::reset();
    }
  }

  //  [adaptor impl] void QTreeView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QTreeView::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QTreeView_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QTreeView_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QTreeView::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QTreeView::selectAll()
  void cbs_selectAll_0_0()
  {
    QTreeView::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_selectAll_0_0);
    } else {
      QTreeView::selectAll();
    }
  }

  //  [adaptor impl] void QTreeView::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QTreeView::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QTreeView_Adaptor, QAbstractItemModel *>(&QTreeView_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QTreeView::setModel(model);
    }
  }

  //  [adaptor impl] void QTreeView::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QTreeView::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QTreeView_Adaptor, const QModelIndex &>(&QTreeView_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QTreeView::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QTreeView::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QTreeView::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QTreeView_Adaptor, QItemSelectionModel *>(&QTreeView_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QTreeView::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QTreeView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTreeView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTreeView_Adaptor, bool>(&QTreeView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTreeView::setVisible(visible);
    }
  }

  //  [adaptor impl] void QTreeView::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QTreeView::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QTreeView_Adaptor, QWidget *>(&QTreeView_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QTreeView::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QTreeView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTreeView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTreeView_Adaptor, QSize>(&QTreeView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTreeView::sizeHint();
    }
  }

  //  [adaptor impl] int QTreeView::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QTreeView::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QTreeView_Adaptor, int, int>(&QTreeView_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QTreeView::sizeHintForRow(row);
    }
  }

  //  [emitter impl] void QTreeView::viewportEntered()
  void emitter_QTreeView_viewportEntered_0()
  {
    emit QTreeView::viewportEntered();
  }

  //  [adaptor impl] QRect QTreeView::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QTreeView::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QTreeView_Adaptor, QRect, const QModelIndex &>(&QTreeView_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QTreeView::visualRect(index);
    }
  }

  //  [emitter impl] void QTreeView::windowIconChanged(const QIcon &icon)
  void emitter_QTreeView_windowIconChanged_1787(const QIcon &icon)
  {
    emit QTreeView::windowIconChanged(icon);
  }

  //  [emitter impl] void QTreeView::windowIconTextChanged(const QString &iconText)
  void emitter_QTreeView_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QTreeView::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QTreeView::windowTitleChanged(const QString &title)
  void emitter_QTreeView_windowTitleChanged_2025(const QString &title)
  {
    emit QTreeView::windowTitleChanged(title);
  }

  //  [adaptor impl] void QTreeView::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QTreeView::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTreeView_Adaptor, QActionEvent *>(&QTreeView_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QTreeView::actionEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QTreeView::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTreeView_Adaptor, QEvent *>(&QTreeView_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QTreeView::changeEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QTreeView::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTreeView_Adaptor, QChildEvent *>(&QTreeView_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QTreeView::childEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QTreeView::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QTreeView_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QTreeView_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QTreeView::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QTreeView::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QTreeView::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTreeView_Adaptor, QCloseEvent *>(&QTreeView_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QTreeView::closeEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QTreeView::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QTreeView_Adaptor, QWidget *>(&QTreeView_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QTreeView::commitData(editor);
    }
  }

  //  [adaptor impl] void QTreeView::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QTreeView::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTreeView_Adaptor, QContextMenuEvent *>(&QTreeView_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QTreeView::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QTreeView::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QTreeView::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QTreeView_Adaptor, const QModelIndex &, const QModelIndex &>(&QTreeView_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QTreeView::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QTreeView::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QTreeView::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTreeView_Adaptor, QEvent *>(&QTreeView_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QTreeView::customEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTreeView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTreeView_Adaptor, const QMetaMethod &>(&QTreeView_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTreeView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTreeView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QTreeView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTreeView_Adaptor, QDragEnterEvent *>(&QTreeView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QTreeView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QTreeView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTreeView_Adaptor, QDragLeaveEvent *>(&QTreeView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QTreeView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QTreeView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTreeView_Adaptor, QDragMoveEvent *>(&QTreeView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QTreeView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)
  void cbs_drawBranches_c5397_0(QPainter *painter, const QRect &rect, const QModelIndex &index) const
  {
    QTreeView::drawBranches(painter, rect, index);
  }

  virtual void drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index) const
  {
    if (cb_drawBranches_c5397_0.can_issue()) {
      cb_drawBranches_c5397_0.issue<QTreeView_Adaptor, QPainter *, const QRect &, const QModelIndex &>(&QTreeView_Adaptor::cbs_drawBranches_c5397_0, painter, rect, index);
    } else {
      QTreeView::drawBranches(painter, rect, index);
    }
  }

  //  [adaptor impl] void QTreeView::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)
  void cbs_drawRow_c6971_0(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index) const
  {
    QTreeView::drawRow(painter, options, index);
  }

  virtual void drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index) const
  {
    if (cb_drawRow_c6971_0.can_issue()) {
      cb_drawRow_c6971_0.issue<QTreeView_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QTreeView_Adaptor::cbs_drawRow_c6971_0, painter, options, index);
    } else {
      QTreeView::drawRow(painter, options, index);
    }
  }

  //  [adaptor impl] void QTreeView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QTreeView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTreeView_Adaptor, QDropEvent *>(&QTreeView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QTreeView::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QTreeView::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QTreeView_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QTreeView_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QTreeView::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QTreeView::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QTreeView::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QTreeView_Adaptor, QObject *>(&QTreeView_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QTreeView::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QTreeView::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QTreeView::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QTreeView_Adaptor, QEnterEvent *>(&QTreeView_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QTreeView::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeView::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QTreeView::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTreeView_Adaptor, bool, QEvent *>(&QTreeView_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QTreeView::event(_event);
    }
  }

  //  [adaptor impl] bool QTreeView::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QTreeView::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTreeView_Adaptor, bool, QObject *, QEvent *>(&QTreeView_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QTreeView::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QTreeView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QTreeView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTreeView_Adaptor, QFocusEvent *>(&QTreeView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QTreeView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTreeView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTreeView_Adaptor, bool, bool>(&QTreeView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTreeView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTreeView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QTreeView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTreeView_Adaptor, QFocusEvent *>(&QTreeView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QTreeView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QTreeView::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTreeView_Adaptor, QHideEvent *>(&QTreeView_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QTreeView::hideEvent(event);
    }
  }

  //  [adaptor impl] int QTreeView::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QTreeView::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QTreeView::horizontalOffset();
    }
  }

  //  [adaptor impl] void QTreeView::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QTreeView::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QTreeView::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTreeView::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QTreeView::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QTreeView::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QTreeView::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QTreeView::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QTreeView_Adaptor, QPainter *>(&QTreeView_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QTreeView::initPainter(painter);
    }
  }

  //  [adaptor impl] void QTreeView::initStyleOption(QStyleOptionFrame *option)
  void cbs_initStyleOption_c2356_0(QStyleOptionFrame *option) const
  {
    QTreeView::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionFrame *option) const
  {
    if (cb_initStyleOption_c2356_0.can_issue()) {
      cb_initStyleOption_c2356_0.issue<QTreeView_Adaptor, QStyleOptionFrame *>(&QTreeView_Adaptor::cbs_initStyleOption_c2356_0, option);
    } else {
      QTreeView::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QTreeView::initViewItemOption(QStyleOptionViewItem *option)
  void cbs_initViewItemOption_c2675_0(QStyleOptionViewItem *option) const
  {
    QTreeView::initViewItemOption(option);
  }

  virtual void initViewItemOption(QStyleOptionViewItem *option) const
  {
    if (cb_initViewItemOption_c2675_0.can_issue()) {
      cb_initViewItemOption_c2675_0.issue<QTreeView_Adaptor, QStyleOptionViewItem *>(&QTreeView_Adaptor::cbs_initViewItemOption_c2675_0, option);
    } else {
      QTreeView::initViewItemOption(option);
    }
  }

  //  [adaptor impl] void QTreeView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QTreeView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTreeView_Adaptor, QInputMethodEvent *>(&QTreeView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QTreeView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeView::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QTreeView::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QTreeView_Adaptor, bool, const QModelIndex &>(&QTreeView_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QTreeView::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QTreeView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QTreeView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTreeView_Adaptor, QKeyEvent *>(&QTreeView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QTreeView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QTreeView::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTreeView_Adaptor, QKeyEvent *>(&QTreeView_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QTreeView::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QTreeView::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTreeView_Adaptor, QEvent *>(&QTreeView_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QTreeView::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QTreeView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTreeView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTreeView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTreeView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTreeView::metric(arg1);
    }
  }

  //  [adaptor impl] void QTreeView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QTreeView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTreeView_Adaptor, QMouseEvent *>(&QTreeView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QTreeView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QTreeView::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTreeView_Adaptor, QMouseEvent *>(&QTreeView_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QTreeView::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QTreeView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTreeView_Adaptor, QMouseEvent *>(&QTreeView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QTreeView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QTreeView::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTreeView_Adaptor, QMouseEvent *>(&QTreeView_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QTreeView::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] QModelIndex QTreeView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    return QTreeView::moveCursor(QAbstractItemView::CursorAction(cursorAction), modifiers);
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QTreeView_Adaptor, QModelIndex, unsigned int, QFlags<Qt::KeyboardModifier> >(&QTreeView_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), modifiers);
    } else {
      return QTreeView::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QTreeView::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QTreeView::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTreeView_Adaptor, QMoveEvent *>(&QTreeView_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QTreeView::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QTreeView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QTreeView::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QTreeView_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QTreeView_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QTreeView::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QTreeView::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QTreeView::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTreeView_Adaptor, QPaintEvent *>(&QTreeView_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QTreeView::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QTreeView::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QTreeView::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QTreeView_Adaptor, QPaintDevice *, QPoint *>(&QTreeView_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QTreeView::redirected(offset);
    }
  }

  //  [adaptor impl] void QTreeView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QTreeView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTreeView_Adaptor, QResizeEvent *>(&QTreeView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QTreeView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTreeView::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QTreeView_Adaptor, const QModelIndex &, int, int>(&QTreeView_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QTreeView::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QTreeView::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QTreeView::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QTreeView_Adaptor, const QModelIndex &, int, int>(&QTreeView_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QTreeView::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QTreeView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QTreeView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QTreeView_Adaptor, int, int>(&QTreeView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QTreeView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QTreeView::selectedIndexes()
  QList<QModelIndex> cbs_selectedIndexes_c0_0() const
  {
    return QTreeView::selectedIndexes();
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return cb_selectedIndexes_c0_0.issue<QTreeView_Adaptor, QList<QModelIndex> >(&QTreeView_Adaptor::cbs_selectedIndexes_c0_0);
    } else {
      return QTreeView::selectedIndexes();
    }
  }

  //  [adaptor impl] void QTreeView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QTreeView::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QTreeView_Adaptor, const QItemSelection &, const QItemSelection &>(&QTreeView_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QTreeView::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QTreeView::selectionCommand(const QModelIndex &index, const QEvent *event)
  QFlags<QItemSelectionModel::SelectionFlag> cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return QTreeView::selectionCommand(index, event);
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return cb_selectionCommand_c4199_1.issue<QTreeView_Adaptor, QFlags<QItemSelectionModel::SelectionFlag>, const QModelIndex &, const QEvent *>(&QTreeView_Adaptor::cbs_selectionCommand_c4199_1, index, event);
    } else {
      return QTreeView::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QTreeView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QTreeView::setSelection(rect, command);
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QTreeView_Adaptor, const QRect &, QFlags<QItemSelectionModel::SelectionFlag> >(&QTreeView_Adaptor::cbs_setSelection_6155_0, rect, command);
    } else {
      QTreeView::setSelection(rect, command);
    }
  }

  //  [adaptor impl] QPainter *QTreeView::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QTreeView::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QTreeView_Adaptor, QPainter *>(&QTreeView_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QTreeView::sharedPainter();
    }
  }

  //  [adaptor impl] void QTreeView::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QTreeView::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTreeView_Adaptor, QShowEvent *>(&QTreeView_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QTreeView::showEvent(event);
    }
  }

  //  [adaptor impl] int QTreeView::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QTreeView::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QTreeView_Adaptor, int, int>(&QTreeView_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QTreeView::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] void QTreeView::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(QFlags<Qt::DropAction> supportedActions)
  {
    QTreeView::startDrag(supportedActions);
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QTreeView_Adaptor, QFlags<Qt::DropAction> >(&QTreeView_Adaptor::cbs_startDrag_2456_0, supportedActions);
    } else {
      QTreeView::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QTreeView::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QTreeView::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTreeView_Adaptor, QTabletEvent *>(&QTreeView_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QTreeView::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTreeView::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTreeView_Adaptor, QTimerEvent *>(&QTreeView_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTreeView::timerEvent(event);
    }
  }

  //  [adaptor impl] void QTreeView::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QTreeView::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QTreeView::updateEditorData();
    }
  }

  //  [adaptor impl] void QTreeView::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QTreeView::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QTreeView::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QTreeView::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QTreeView::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QTreeView_Adaptor>(&QTreeView_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QTreeView::updateGeometries();
    }
  }

  //  [adaptor impl] int QTreeView::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QTreeView::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QTreeView::verticalOffset();
    }
  }

  //  [adaptor impl] void QTreeView::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QTreeView::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QTreeView::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QTreeView::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QTreeView::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QTreeView_Adaptor, int>(&QTreeView_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QTreeView::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] bool QTreeView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QTreeView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QTreeView_Adaptor, bool, QEvent *>(&QTreeView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QTreeView::viewportEvent(event);
    }
  }

  //  [adaptor impl] QSize QTreeView::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QTreeView::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QTreeView_Adaptor, QSize>(&QTreeView_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QTreeView::viewportSizeHint();
    }
  }

  //  [adaptor impl] QRegion QTreeView::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QTreeView::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QTreeView_Adaptor, QRegion, const QItemSelection &>(&QTreeView_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QTreeView::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QTreeView::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QTreeView::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTreeView_Adaptor, QWheelEvent *>(&QTreeView_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QTreeView::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_dataChanged_6833_1;
  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemDelegateForIndex_c2395_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_drawBranches_c5397_0;
  gsi::Callback cb_drawRow_c6971_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c2356_0;
  gsi::Callback cb_initViewItemOption_c2675_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QTreeView_Adaptor::~QTreeView_Adaptor() { }

//  Constructor QTreeView::QTreeView(QWidget *parent) (adaptor class)

static void _init_ctor_QTreeView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTreeView_Adaptor> ();
}

static void _call_ctor_QTreeView_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QTreeView_Adaptor *> (new QTreeView_Adaptor (arg1));
}


// void QTreeView::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QTreeView::activated(const QModelIndex &index)

static void _init_emitter_activated_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_activated_2395 (arg1);
}


// void QTreeView::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTreeView::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QTreeView::clicked(const QModelIndex &index)

static void _init_emitter_clicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_clicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_clicked_2395 (arg1);
}


// void QTreeView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}


// void QTreeView::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// emitter void QTreeView::collapsed(const QModelIndex &index)

static void _init_emitter_collapsed_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_collapsed_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_collapsed_2395 (arg1);
}


// exposed void QTreeView::columnCountChanged(int oldCount, int newCount)

static void _init_fp_columnCountChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldCount");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newCount");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_columnCountChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_columnCountChanged_1426 (arg1, arg2);
}


// exposed void QTreeView::columnMoved()

static void _init_fp_columnMoved_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_columnMoved_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_columnMoved_0 ();
}


// exposed void QTreeView::columnResized(int column, int oldSize, int newSize)

static void _init_fp_columnResized_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldSize");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("newSize");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_columnResized_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_columnResized_2085 (arg1, arg2, arg3);
}


// void QTreeView::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}


// void QTreeView::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QTreeView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_create_2208 (arg1, arg2, arg3);
}


// void QTreeView::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}


// emitter void QTreeView::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_customContextMenuRequested_1916 (arg1);
}


// void QTreeView::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QTreeView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)

static void _init_cbs_dataChanged_6833_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles");
  decl->add_arg<const QList<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_6833_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  const QList<int> &arg3 = args.read<const QList<int> & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_dataChanged_6833_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_dataChanged_6833_1 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_dataChanged_6833_1 = cb;
}


// exposed void QTreeView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_destroy_1620 (arg1, arg2);
}


// emitter void QTreeView::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_destroyed_1302 (arg1);
}


// exposed QPoint QTreeView::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QTreeView_Adaptor *)cls)->fp_QTreeView_dirtyRegionOffset_c0 ());
}


// void QTreeView::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// exposed void QTreeView::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_doAutoScroll_0 ();
}


// void QTreeView::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}


// emitter void QTreeView::doubleClicked(const QModelIndex &index)

static void _init_emitter_doubleClicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_doubleClicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_doubleClicked_2395 (arg1);
}


// void QTreeView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTreeView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTreeView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QTreeView::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)

static void _init_cbs_drawBranches_c5397_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawBranches_c5397_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_drawBranches_c5397_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawBranches_c5397_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_drawBranches_c5397_0 = cb;
}


// exposed void QTreeView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_drawFrame_1426 (arg1);
}


// void QTreeView::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)

static void _init_cbs_drawRow_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawRow_c6971_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_drawRow_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawRow_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_drawRow_c6971_0 = cb;
}


// exposed void QTreeView::drawTree(QPainter *painter, const QRegion &region)

static void _init_fp_drawTree_c3324 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("region");
  decl->add_arg<const QRegion & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_drawTree_c3324 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRegion &arg2 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_drawTree_c3324 (arg1, arg2);
}


// void QTreeView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// exposed QAbstractItemView::DropIndicatorPosition QTreeView::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QTreeView_Adaptor *)cls)->fp_QTreeView_dropIndicatorPosition_c0 ());
}


// bool QTreeView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (heap);
  QEvent *arg3 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_edit_6773_0 = cb;
}


// void QTreeView::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}


// void QTreeView::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// emitter void QTreeView::entered(const QModelIndex &index)

static void _init_emitter_entered_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_entered_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_entered_2395 (arg1);
}


// bool QTreeView::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTreeView::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed void QTreeView::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_executeDelayedItemsLayout_0 ();
}


// emitter void QTreeView::expanded(const QModelIndex &index)

static void _init_emitter_expanded_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_expanded_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_expanded_2395 (arg1);
}


// void QTreeView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTreeView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->fp_QTreeView_focusNextChild_0 ());
}


// bool QTreeView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTreeView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTreeView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->fp_QTreeView_focusPreviousChild_0 ());
}


// bool QTreeView::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QTreeView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTreeView::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// int QTreeView::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}


// void QTreeView::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}


// void QTreeView::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}


// emitter void QTreeView::iconSizeChanged(const QSize &size)

static void _init_emitter_iconSizeChanged_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_iconSizeChanged_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_iconSizeChanged_1805 (arg1);
}


// QModelIndex QTreeView::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTreeView_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}


// exposed int QTreeView::indexRowSizeHint(const QModelIndex &index)

static void _init_fp_indexRowSizeHint_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_indexRowSizeHint_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->fp_QTreeView_indexRowSizeHint_c2395 (arg1));
}


// void QTreeView::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QTreeView::initStyleOption(QStyleOptionFrame *option)

static void _init_cbs_initStyleOption_c2356_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c2356_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = args.read<QStyleOptionFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_initStyleOption_c2356_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c2356_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_initStyleOption_c2356_0 = cb;
}


// void QTreeView::initViewItemOption(QStyleOptionViewItem *option)

static void _init_cbs_initViewItemOption_c2675_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionViewItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initViewItemOption_c2675_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionViewItem *arg1 = args.read<QStyleOptionViewItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_initViewItemOption_c2675_0 (arg1);
}

static void _set_callback_cbs_initViewItemOption_c2675_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_initViewItemOption_c2675_0 = cb;
}


// void QTreeView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTreeView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTreeView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QTreeView::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}


// exposed bool QTreeView::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->fp_QTreeView_isSignalConnected_c2394 (arg1));
}


// QAbstractItemDelegate *QTreeView::itemDelegateForIndex(const QModelIndex &index)

static void _init_cbs_itemDelegateForIndex_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QAbstractItemDelegate * > ();
}

static void _call_cbs_itemDelegateForIndex_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QAbstractItemDelegate * > ((QAbstractItemDelegate *)((QTreeView_Adaptor *)cls)->cbs_itemDelegateForIndex_c2395_0 (arg1));
}

static void _set_callback_cbs_itemDelegateForIndex_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_itemDelegateForIndex_c2395_0 = cb;
}


// void QTreeView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTreeView::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTreeView::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}


// void QTreeView::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QTreeView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QTreeView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTreeView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTreeView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTreeView::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTreeView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTreeView::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// QModelIndex QTreeView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<QFlags<Qt::KeyboardModifier> > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  QFlags<Qt::KeyboardModifier> arg2 = args.read<QFlags<Qt::KeyboardModifier> > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QTreeView_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}


// void QTreeView::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QTreeView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QTreeView::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QTreeView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTreeView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTreeView::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// emitter void QTreeView::pressed(const QModelIndex &index)

static void _init_emitter_pressed_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pressed_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_pressed_2395 (arg1);
}


// exposed int QTreeView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->fp_QTreeView_receivers_c1731 (arg1));
}


// QPaintDevice *QTreeView::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QTreeView_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// exposed void QTreeView::reexpand()

static void _init_fp_reexpand_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reexpand_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_reexpand_0 ();
}


// void QTreeView::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// void QTreeView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed int QTreeView::rowHeight(const QModelIndex &index)

static void _init_fp_rowHeight_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_rowHeight_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->fp_QTreeView_rowHeight_c2395 (arg1));
}


// void QTreeView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}


// void QTreeView::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}


// exposed void QTreeView::rowsRemoved(const QModelIndex &parent, int first, int last)

static void _init_fp_rowsRemoved_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_rowsRemoved_3713 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_rowsRemoved_3713 (arg1, arg2, arg3);
}


// exposed void QTreeView::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_scheduleDelayedItemsLayout_0 ();
}


// void QTreeView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed void QTreeView::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_scrollDirtyRegion_1426 (arg1, arg2);
}


// void QTreeView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}


// void QTreeView::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}


// QList<QModelIndex> QTreeView::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QTreeView_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}


// void QTreeView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  const QItemSelection &arg2 = args.read<const QItemSelection & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}


// QFlags<QItemSelectionModel::SelectionFlag> QTreeView::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<QFlags<QItemSelectionModel::SelectionFlag> > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QEvent *arg2 = args.read<const QEvent * > (heap);
  ret.write<QFlags<QItemSelectionModel::SelectionFlag> > ((QFlags<QItemSelectionModel::SelectionFlag>)((QTreeView_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}


// exposed QObject *QTreeView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTreeView_Adaptor *)cls)->fp_QTreeView_sender_c0 ());
}


// exposed int QTreeView::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->fp_QTreeView_senderSignalIndex_c0 ());
}


// exposed void QTreeView::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = gsi::arg_reader<const QRegion & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_setDirtyRegion_2006 (arg1);
}


// void QTreeView::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}


// void QTreeView::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}


// void QTreeView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}


// void QTreeView::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}


// exposed void QTreeView::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = gsi::arg_reader<unsigned int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_setState_2776 (arg1);
}


// exposed void QTreeView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QTreeView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_setViewportMargins_2115 (arg1);
}


// void QTreeView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QTreeView::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QTreeView::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QTreeView_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QTreeView::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTreeView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTreeView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// int QTreeView::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}


// int QTreeView::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}


// exposed void QTreeView::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_startAutoScroll_0 ();
}


// void QTreeView::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<QFlags<Qt::DropAction> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::DropAction> arg1 = args.read<QFlags<Qt::DropAction> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}


// exposed QAbstractItemView::State QTreeView::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QTreeView_Adaptor *)cls)->fp_QTreeView_state_c0 ());
}


// exposed void QTreeView::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_stopAutoScroll_0 ();
}


// void QTreeView::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QTreeView::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QTreeView::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}


// void QTreeView::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}


// void QTreeView::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}


// exposed void QTreeView::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->fp_QTreeView_updateMicroFocus_2420 (arg1);
}


// int QTreeView::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTreeView_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}


// void QTreeView::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}


// void QTreeView::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}


// emitter void QTreeView::viewportEntered()

static void _init_emitter_viewportEntered_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_viewportEntered_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_viewportEntered_0 ();
}


// bool QTreeView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTreeView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QTreeView::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QTreeView_Adaptor *)cls)->fp_QTreeView_viewportMargins_c0 ());
}


// QSize QTreeView::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTreeView_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// QRect QTreeView::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QRect > ((QRect)((QTreeView_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}


// QRegion QTreeView::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QRegion > ((QRegion)((QTreeView_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}


// void QTreeView::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTreeView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTreeView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QTreeView::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_windowIconChanged_1787 (arg1);
}


// emitter void QTreeView::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_windowIconTextChanged_2025 (arg1);
}


// emitter void QTreeView::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTreeView_Adaptor *)cls)->emitter_QTreeView_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QTreeView> &qtdecl_QTreeView ();

static gsi::Methods methods_QTreeView_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTreeView::QTreeView(QWidget *parent)\nThis method creates an object of class QTreeView.", &_init_ctor_QTreeView_Adaptor_1315, &_call_ctor_QTreeView_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTreeView::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QTreeView::activated(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_activated_2395, &_call_emitter_activated_2395);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTreeView::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTreeView::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_clicked", "@brief Emitter for signal void QTreeView::clicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_clicked_2395, &_call_emitter_clicked_2395);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QTreeView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTreeView::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("emit_collapsed", "@brief Emitter for signal void QTreeView::collapsed(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_collapsed_2395, &_call_emitter_collapsed_2395);
  methods += new qt_gsi::GenericMethod ("*columnCountChanged", "@brief Method void QTreeView::columnCountChanged(int oldCount, int newCount)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnCountChanged_1426, &_call_fp_columnCountChanged_1426);
  methods += new qt_gsi::GenericMethod ("*columnMoved", "@brief Method void QTreeView::columnMoved()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnMoved_0, &_call_fp_columnMoved_0);
  methods += new qt_gsi::GenericMethod ("*columnResized", "@brief Method void QTreeView::columnResized(int column, int oldSize, int newSize)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_columnResized_2085, &_call_fp_columnResized_2085);
  methods += new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QTreeView::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTreeView::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QTreeView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QTreeView::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTreeView::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTreeView::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("dataChanged", "@brief Virtual method void QTreeView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QList<int> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_6833_1, &_call_cbs_dataChanged_6833_1);
  methods += new qt_gsi::GenericMethod ("dataChanged", "@hide", false, &_init_cbs_dataChanged_6833_1, &_call_cbs_dataChanged_6833_1, &_set_callback_cbs_dataChanged_6833_1);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QTreeView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTreeView::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*dirtyRegionOffset", "@brief Method QPoint QTreeView::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTreeView::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doAutoScroll", "@brief Method void QTreeView::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QTreeView::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("emit_doubleClicked", "@brief Emitter for signal void QTreeView::doubleClicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_doubleClicked_2395, &_call_emitter_doubleClicked_2395);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTreeView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTreeView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTreeView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawBranches", "@brief Virtual method void QTreeView::drawBranches(QPainter *painter, const QRect &rect, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawBranches_c5397_0, &_call_cbs_drawBranches_c5397_0);
  methods += new qt_gsi::GenericMethod ("*drawBranches", "@hide", true, &_init_cbs_drawBranches_c5397_0, &_call_cbs_drawBranches_c5397_0, &_set_callback_cbs_drawBranches_c5397_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QTreeView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*drawRow", "@brief Virtual method void QTreeView::drawRow(QPainter *painter, const QStyleOptionViewItem &options, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawRow_c6971_0, &_call_cbs_drawRow_c6971_0);
  methods += new qt_gsi::GenericMethod ("*drawRow", "@hide", true, &_init_cbs_drawRow_c6971_0, &_call_cbs_drawRow_c6971_0, &_set_callback_cbs_drawRow_c6971_0);
  methods += new qt_gsi::GenericMethod ("*drawTree", "@brief Method void QTreeView::drawTree(QPainter *painter, const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_drawTree_c3324, &_call_fp_drawTree_c3324);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTreeView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QTreeView::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
  methods += new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QTreeView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QTreeView::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTreeView::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("emit_entered", "@brief Emitter for signal void QTreeView::entered(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_entered_2395, &_call_emitter_entered_2395);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTreeView::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QTreeView::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*executeDelayedItemsLayout", "@brief Method void QTreeView::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("emit_expanded", "@brief Emitter for signal void QTreeView::expanded(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_expanded_2395, &_call_emitter_expanded_2395);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTreeView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTreeView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTreeView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTreeView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTreeView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QTreeView::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTreeView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTreeView::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QTreeView::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QTreeView::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QTreeView::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("emit_iconSizeChanged", "@brief Emitter for signal void QTreeView::iconSizeChanged(const QSize &size)\nCall this method to emit this signal.", false, &_init_emitter_iconSizeChanged_1805, &_call_emitter_iconSizeChanged_1805);
  methods += new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QTreeView::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("*indexRowSizeHint", "@brief Method int QTreeView::indexRowSizeHint(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_indexRowSizeHint_c2395, &_call_fp_indexRowSizeHint_c2395);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QTreeView::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QTreeView::initStyleOption(QStyleOptionFrame *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c2356_0, &_call_cbs_initStyleOption_c2356_0, &_set_callback_cbs_initStyleOption_c2356_0);
  methods += new qt_gsi::GenericMethod ("*initViewItemOption", "@brief Virtual method void QTreeView::initViewItemOption(QStyleOptionViewItem *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initViewItemOption_c2675_0, &_call_cbs_initViewItemOption_c2675_0);
  methods += new qt_gsi::GenericMethod ("*initViewItemOption", "@hide", true, &_init_cbs_initViewItemOption_c2675_0, &_call_cbs_initViewItemOption_c2675_0, &_set_callback_cbs_initViewItemOption_c2675_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTreeView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTreeView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QTreeView::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTreeView::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemDelegateForIndex", "@brief Virtual method QAbstractItemDelegate *QTreeView::itemDelegateForIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemDelegateForIndex_c2395_0, &_call_cbs_itemDelegateForIndex_c2395_0);
  methods += new qt_gsi::GenericMethod ("itemDelegateForIndex", "@hide", true, &_init_cbs_itemDelegateForIndex_c2395_0, &_call_cbs_itemDelegateForIndex_c2395_0, &_set_callback_cbs_itemDelegateForIndex_c2395_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTreeView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTreeView::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QTreeView::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTreeView::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTreeView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTreeView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTreeView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTreeView::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTreeView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTreeView::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QTreeView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTreeView::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QTreeView::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QTreeView::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTreeView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTreeView::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("emit_pressed", "@brief Emitter for signal void QTreeView::pressed(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_pressed_2395, &_call_emitter_pressed_2395);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTreeView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QTreeView::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*reexpand", "@brief Method void QTreeView::reexpand()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reexpand_0, &_call_fp_reexpand_0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QTreeView::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTreeView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*rowHeight", "@brief Method int QTreeView::rowHeight(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rowHeight_c2395, &_call_fp_rowHeight_c2395);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QTreeView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QTreeView::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsRemoved", "@brief Method void QTreeView::rowsRemoved(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_rowsRemoved_3713, &_call_fp_rowsRemoved_3713);
  methods += new qt_gsi::GenericMethod ("*scheduleDelayedItemsLayout", "@brief Method void QTreeView::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QTreeView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollDirtyRegion", "@brief Method void QTreeView::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QTreeView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QTreeView::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QTreeView::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QTreeView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QTreeView::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTreeView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTreeView::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setDirtyRegion", "@brief Method void QTreeView::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
  methods += new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QTreeView::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QTreeView::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QTreeView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QTreeView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("*setState", "@brief Method void QTreeView::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTreeView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTreeView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTreeView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QTreeView::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QTreeView::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTreeView::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTreeView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForColumn", "@brief Virtual method int QTreeView::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("*sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QTreeView::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("*startAutoScroll", "@brief Method void QTreeView::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QTreeView::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*state", "@brief Method QAbstractItemView::State QTreeView::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
  methods += new qt_gsi::GenericMethod ("*stopAutoScroll", "@brief Method void QTreeView::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTreeView::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTreeView::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QTreeView::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QTreeView::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QTreeView::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTreeView::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QTreeView::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QTreeView::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QTreeView::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("emit_viewportEntered", "@brief Emitter for signal void QTreeView::viewportEntered()\nCall this method to emit this signal.", false, &_init_emitter_viewportEntered_0, &_call_emitter_viewportEntered_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QTreeView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QTreeView::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QTreeView::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QTreeView::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QTreeView::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTreeView::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QTreeView::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QTreeView::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QTreeView::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QTreeView_Adaptor> decl_QTreeView_Adaptor (qtdecl_QTreeView (), "QtWidgets", "QTreeView",
  methods_QTreeView_Adaptor (),
  "@qt\n@brief Binding of QTreeView");

}

