
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPdfWriter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPdfWriter>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMarginsF>
#include <QMetaMethod>
#include <QObject>
#include <QPageLayout>
#include <QPageRanges>
#include <QPageSize>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainter>
#include <QPoint>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPdfWriter

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPdfWriter::staticMetaObject);
}


// void QPdfWriter::addFileAttachment(const QString &fileName, const QByteArray &data, const QString &mimeType)


static void _init_f_addFileAttachment_6143 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mimeType", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addFileAttachment_6143 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QByteArray &arg2 = gsi::arg_reader<const QByteArray & >() (args, heap);
  const QString &arg3 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->addFileAttachment (arg1, arg2, arg3);
}


// QString QPdfWriter::creator()


static void _init_f_creator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_creator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPdfWriter *)cls)->creator ());
}


// QByteArray QPdfWriter::documentXmpMetadata()


static void _init_f_documentXmpMetadata_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_documentXmpMetadata_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QPdfWriter *)cls)->documentXmpMetadata ());
}


// bool QPdfWriter::newPage()


static void _init_f_newPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_newPage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPdfWriter *)cls)->newPage ());
}


// QPagedPaintDevice::PdfVersion QPdfWriter::pdfVersion()


static void _init_f_pdfVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type > ();
}

static void _call_f_pdfVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type > ((qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type)qt_gsi::CppToQtAdaptor<QPagedPaintDevice::PdfVersion>(((QPdfWriter *)cls)->pdfVersion ()));
}


// int QPdfWriter::resolution()


static void _init_f_resolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_resolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPdfWriter *)cls)->resolution ());
}


// void QPdfWriter::setCreator(const QString &creator)


static void _init_f_setCreator_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("creator");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCreator_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setCreator (arg1);
}


// void QPdfWriter::setDocumentXmpMetadata(const QByteArray &xmpMetadata)


static void _init_f_setDocumentXmpMetadata_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("xmpMetadata");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentXmpMetadata_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = gsi::arg_reader<const QByteArray & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setDocumentXmpMetadata (arg1);
}


// void QPdfWriter::setPdfVersion(QPagedPaintDevice::PdfVersion version)


static void _init_f_setPdfVersion_3238 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("version");
  decl->add_arg<const qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPdfVersion_3238 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPagedPaintDevice::PdfVersion>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setPdfVersion (qt_gsi::QtToCppAdaptor<QPagedPaintDevice::PdfVersion>(arg1).cref());
}


// void QPdfWriter::setResolution(int resolution)


static void _init_f_setResolution_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolution_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setResolution (arg1);
}


// void QPdfWriter::setTitle(const QString &title)


static void _init_f_setTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setTitle (arg1);
}


// QString QPdfWriter::title()


static void _init_f_title_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_title_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPdfWriter *)cls)->title ());
}


// static QString QPdfWriter::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPdfWriter::tr (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QPdfWriter_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QPdfWriter_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QPdfWriter *)cls);
}

static void _init_f_QPdfWriter_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QPdfWriter_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QPdfWriter *)cls);
}

//  base class cast for QPagedPaintDevice

static void _init_f_QPdfWriter_as_QPagedPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPagedPaintDevice *> ();
}

static void _call_f_QPdfWriter_as_QPagedPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QPagedPaintDevice *> ((QPagedPaintDevice *)(QPdfWriter *)cls);
}

static void _init_f_QPdfWriter_as_const_QPagedPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPagedPaintDevice *> ();
}

static void _call_f_QPdfWriter_as_const_QPagedPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QPagedPaintDevice *> ((const QPagedPaintDevice *)(const QPdfWriter *)cls);
}


namespace gsi
{

static gsi::Methods methods_QPdfWriter () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addFileAttachment", "@brief Method void QPdfWriter::addFileAttachment(const QString &fileName, const QByteArray &data, const QString &mimeType)\n", false, &_init_f_addFileAttachment_6143, &_call_f_addFileAttachment_6143);
  methods += new qt_gsi::GenericMethod (":creator", "@brief Method QString QPdfWriter::creator()\n", true, &_init_f_creator_c0, &_call_f_creator_c0);
  methods += new qt_gsi::GenericMethod (":documentXmpMetadata", "@brief Method QByteArray QPdfWriter::documentXmpMetadata()\n", true, &_init_f_documentXmpMetadata_c0, &_call_f_documentXmpMetadata_c0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Method bool QPdfWriter::newPage()\nThis is a reimplementation of QPagedPaintDevice::newPage", false, &_init_f_newPage_0, &_call_f_newPage_0);
  methods += new qt_gsi::GenericMethod (":pdfVersion", "@brief Method QPagedPaintDevice::PdfVersion QPdfWriter::pdfVersion()\n", true, &_init_f_pdfVersion_c0, &_call_f_pdfVersion_c0);
  methods += new qt_gsi::GenericMethod (":resolution", "@brief Method int QPdfWriter::resolution()\n", true, &_init_f_resolution_c0, &_call_f_resolution_c0);
  methods += new qt_gsi::GenericMethod ("setCreator|creator=", "@brief Method void QPdfWriter::setCreator(const QString &creator)\n", false, &_init_f_setCreator_2025, &_call_f_setCreator_2025);
  methods += new qt_gsi::GenericMethod ("setDocumentXmpMetadata|documentXmpMetadata=", "@brief Method void QPdfWriter::setDocumentXmpMetadata(const QByteArray &xmpMetadata)\n", false, &_init_f_setDocumentXmpMetadata_2309, &_call_f_setDocumentXmpMetadata_2309);
  methods += new qt_gsi::GenericMethod ("setPdfVersion|pdfVersion=", "@brief Method void QPdfWriter::setPdfVersion(QPagedPaintDevice::PdfVersion version)\n", false, &_init_f_setPdfVersion_3238, &_call_f_setPdfVersion_3238);
  methods += new qt_gsi::GenericMethod ("setResolution|resolution=", "@brief Method void QPdfWriter::setResolution(int resolution)\n", false, &_init_f_setResolution_767, &_call_f_setResolution_767);
  methods += new qt_gsi::GenericMethod ("setTitle|title=", "@brief Method void QPdfWriter::setTitle(const QString &title)\n", false, &_init_f_setTitle_2025, &_call_f_setTitle_2025);
  methods += new qt_gsi::GenericMethod (":title", "@brief Method QString QPdfWriter::title()\n", true, &_init_f_title_c0, &_call_f_title_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPdfWriter::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPdfWriter::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPdfWriter::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QPdfWriter_as_QObject, &_call_f_QPdfWriter_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPdfWriter_as_const_QObject, &_call_f_QPdfWriter_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQPagedPaintDevice", "@brief Delivers the base class interface QPagedPaintDevice of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QPagedPaintDevice base class aspect.", false, &_init_f_QPdfWriter_as_QPagedPaintDevice, &_call_f_QPdfWriter_as_QPagedPaintDevice);
  methods += new qt_gsi::GenericMethod ("asConstQPagedPaintDevice", "@brief Delivers the base class interface QPagedPaintDevice of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QPagedPaintDevice base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPdfWriter_as_const_QPagedPaintDevice, &_call_f_QPdfWriter_as_const_QPagedPaintDevice);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QPdfWriter> decl_QPdfWriter (qtdecl_QObject (), "QtGui", "QPdfWriter_Native",
  methods_QPdfWriter (),
  "@hide\n@alias QPdfWriter");

//  Additional base classes

gsi::Class<QPagedPaintDevice> &qtdecl_QPagedPaintDevice ();

gsi::ClassExt<QPdfWriter> base_class_QPagedPaintDevice_in_QPdfWriter (qtdecl_QPagedPaintDevice ());

GSI_QTGUI_PUBLIC gsi::Class<QPdfWriter> &qtdecl_QPdfWriter () { return decl_QPdfWriter; }

}


class QPdfWriter_Adaptor : public QPdfWriter, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPdfWriter_Adaptor();

  //  [adaptor ctor] QPdfWriter::QPdfWriter(const QString &filename)
  QPdfWriter_Adaptor(const QString &filename) : QPdfWriter(filename)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPdfWriter::QPdfWriter(QIODevice *device)
  QPdfWriter_Adaptor(QIODevice *device) : QPdfWriter(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPdfWriter_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPdfWriter::isSignalConnected(signal);
  }

  //  [expose] int QPdfWriter::receivers(const char *signal)
  int fp_QPdfWriter_receivers_c1731 (const char *signal) const {
    return QPdfWriter::receivers(signal);
  }

  //  [expose] QObject *QPdfWriter::sender()
  QObject * fp_QPdfWriter_sender_c0 () const {
    return QPdfWriter::sender();
  }

  //  [expose] int QPdfWriter::senderSignalIndex()
  int fp_QPdfWriter_senderSignalIndex_c0 () const {
    return QPdfWriter::senderSignalIndex();
  }

  //  [emitter impl] void QPdfWriter::destroyed(QObject *)
  void emitter_QPdfWriter_destroyed_1302(QObject *arg1)
  {
    emit QPdfWriter::destroyed(arg1);
  }

  //  [adaptor impl] bool QPdfWriter::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QPdfWriter::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPdfWriter_Adaptor, bool, QEvent *>(&QPdfWriter_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QPdfWriter::event(_event);
    }
  }

  //  [adaptor impl] bool QPdfWriter::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QPdfWriter::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPdfWriter_Adaptor, bool, QObject *, QEvent *>(&QPdfWriter_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QPdfWriter::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QPdfWriter::newPage()
  bool cbs_newPage_0_0()
  {
    return QPdfWriter::newPage();
  }

  virtual bool newPage()
  {
    if (cb_newPage_0_0.can_issue()) {
      return cb_newPage_0_0.issue<QPdfWriter_Adaptor, bool>(&QPdfWriter_Adaptor::cbs_newPage_0_0);
    } else {
      return QPdfWriter::newPage();
    }
  }

  //  [emitter impl] void QPdfWriter::objectNameChanged(const QString &objectName)
  void emitter_QPdfWriter_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPdfWriter::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] bool QPdfWriter::setPageLayout(const QPageLayout &pageLayout)
  bool cbs_setPageLayout_2413_0(const QPageLayout &pageLayout)
  {
    return QPdfWriter::setPageLayout(pageLayout);
  }

  virtual bool setPageLayout(const QPageLayout &pageLayout)
  {
    if (cb_setPageLayout_2413_0.can_issue()) {
      return cb_setPageLayout_2413_0.issue<QPdfWriter_Adaptor, bool, const QPageLayout &>(&QPdfWriter_Adaptor::cbs_setPageLayout_2413_0, pageLayout);
    } else {
      return QPdfWriter::setPageLayout(pageLayout);
    }
  }

  //  [adaptor impl] bool QPdfWriter::setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)
  bool cbs_setPageMargins_4145_1(const QMarginsF &margins, const qt_gsi::Converter<QPageLayout::Unit>::target_type & units)
  {
    return QPdfWriter::setPageMargins(margins, qt_gsi::QtToCppAdaptor<QPageLayout::Unit>(units).cref());
  }

  virtual bool setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)
  {
    if (cb_setPageMargins_4145_1.can_issue()) {
      return cb_setPageMargins_4145_1.issue<QPdfWriter_Adaptor, bool, const QMarginsF &, const qt_gsi::Converter<QPageLayout::Unit>::target_type &>(&QPdfWriter_Adaptor::cbs_setPageMargins_4145_1, margins, qt_gsi::CppToQtAdaptor<QPageLayout::Unit>(units));
    } else {
      return QPdfWriter::setPageMargins(margins, units);
    }
  }

  //  [adaptor impl] bool QPdfWriter::setPageOrientation(QPageLayout::Orientation orientation)
  bool cbs_setPageOrientation_2816_0(const qt_gsi::Converter<QPageLayout::Orientation>::target_type & orientation)
  {
    return QPdfWriter::setPageOrientation(qt_gsi::QtToCppAdaptor<QPageLayout::Orientation>(orientation).cref());
  }

  virtual bool setPageOrientation(QPageLayout::Orientation orientation)
  {
    if (cb_setPageOrientation_2816_0.can_issue()) {
      return cb_setPageOrientation_2816_0.issue<QPdfWriter_Adaptor, bool, const qt_gsi::Converter<QPageLayout::Orientation>::target_type &>(&QPdfWriter_Adaptor::cbs_setPageOrientation_2816_0, qt_gsi::CppToQtAdaptor<QPageLayout::Orientation>(orientation));
    } else {
      return QPdfWriter::setPageOrientation(orientation);
    }
  }

  //  [adaptor impl] void QPdfWriter::setPageRanges(const QPageRanges &ranges)
  void cbs_setPageRanges_2383_0(const QPageRanges &ranges)
  {
    QPdfWriter::setPageRanges(ranges);
  }

  virtual void setPageRanges(const QPageRanges &ranges)
  {
    if (cb_setPageRanges_2383_0.can_issue()) {
      cb_setPageRanges_2383_0.issue<QPdfWriter_Adaptor, const QPageRanges &>(&QPdfWriter_Adaptor::cbs_setPageRanges_2383_0, ranges);
    } else {
      QPdfWriter::setPageRanges(ranges);
    }
  }

  //  [adaptor impl] bool QPdfWriter::setPageSize(const QPageSize &pageSize)
  bool cbs_setPageSize_2186_0(const QPageSize &pageSize)
  {
    return QPdfWriter::setPageSize(pageSize);
  }

  virtual bool setPageSize(const QPageSize &pageSize)
  {
    if (cb_setPageSize_2186_0.can_issue()) {
      return cb_setPageSize_2186_0.issue<QPdfWriter_Adaptor, bool, const QPageSize &>(&QPdfWriter_Adaptor::cbs_setPageSize_2186_0, pageSize);
    } else {
      return QPdfWriter::setPageSize(pageSize);
    }
  }

  //  [adaptor impl] void QPdfWriter::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QPdfWriter::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPdfWriter_Adaptor, QChildEvent *>(&QPdfWriter_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QPdfWriter::childEvent(event);
    }
  }

  //  [adaptor impl] void QPdfWriter::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QPdfWriter::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPdfWriter_Adaptor, QEvent *>(&QPdfWriter_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QPdfWriter::customEvent(event);
    }
  }

  //  [adaptor impl] void QPdfWriter::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPdfWriter::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPdfWriter_Adaptor, const QMetaMethod &>(&QPdfWriter_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPdfWriter::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPdfWriter::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPdfWriter::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPdfWriter_Adaptor, QPainter *>(&QPdfWriter_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPdfWriter::initPainter(painter);
    }
  }

  //  [adaptor impl] int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & id) const
  {
    return QPdfWriter::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(id).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric id) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPdfWriter_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPdfWriter_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(id));
    } else {
      return QPdfWriter::metric(id);
    }
  }

  //  [adaptor impl] QPaintEngine *QPdfWriter::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPdfWriter::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPdfWriter_Adaptor, QPaintEngine *>(&QPdfWriter_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPdfWriter::paintEngine();
    }
  }

  //  [adaptor impl] QPaintDevice *QPdfWriter::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPdfWriter::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPdfWriter_Adaptor, QPaintDevice *, QPoint *>(&QPdfWriter_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPdfWriter::redirected(offset);
    }
  }

  //  [adaptor impl] QPainter *QPdfWriter::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPdfWriter::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPdfWriter_Adaptor, QPainter *>(&QPdfWriter_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPdfWriter::sharedPainter();
    }
  }

  //  [adaptor impl] void QPdfWriter::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QPdfWriter::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPdfWriter_Adaptor, QTimerEvent *>(&QPdfWriter_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QPdfWriter::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_newPage_0_0;
  gsi::Callback cb_setPageLayout_2413_0;
  gsi::Callback cb_setPageMargins_4145_1;
  gsi::Callback cb_setPageOrientation_2816_0;
  gsi::Callback cb_setPageRanges_2383_0;
  gsi::Callback cb_setPageSize_2186_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPdfWriter_Adaptor::~QPdfWriter_Adaptor() { }

//  Constructor QPdfWriter::QPdfWriter(const QString &filename) (adaptor class)

static void _init_ctor_QPdfWriter_Adaptor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QPdfWriter_Adaptor> ();
}

static void _call_ctor_QPdfWriter_Adaptor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QPdfWriter_Adaptor *> (new QPdfWriter_Adaptor (arg1));
}


//  Constructor QPdfWriter::QPdfWriter(QIODevice *device) (adaptor class)

static void _init_ctor_QPdfWriter_Adaptor_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QPdfWriter_Adaptor> ();
}

static void _call_ctor_QPdfWriter_Adaptor_1447 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<QPdfWriter_Adaptor *> (new QPdfWriter_Adaptor (arg1));
}


// void QPdfWriter::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPdfWriter::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPdfWriter::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QPdfWriter_Adaptor *)cls)->emitter_QPdfWriter_destroyed_1302 (arg1);
}


// void QPdfWriter::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QPdfWriter::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPdfWriter::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QPdfWriter::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_isSignalConnected_c2394 (arg1));
}


// int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// bool QPdfWriter::newPage()

static void _init_cbs_newPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_newPage_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_newPage_0_0 ());
}

static void _set_callback_cbs_newPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_newPage_0_0 = cb;
}


// emitter void QPdfWriter::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPdfWriter_Adaptor *)cls)->emitter_QPdfWriter_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QPdfWriter::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPdfWriter_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// exposed int QPdfWriter::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_receivers_c1731 (arg1));
}


// QPaintDevice *QPdfWriter::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPdfWriter_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// exposed QObject *QPdfWriter::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_sender_c0 ());
}


// exposed int QPdfWriter::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_senderSignalIndex_c0 ());
}


// bool QPdfWriter::setPageLayout(const QPageLayout &pageLayout)

static void _init_cbs_setPageLayout_2413_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageLayout");
  decl->add_arg<const QPageLayout & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setPageLayout_2413_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageLayout &arg1 = args.read<const QPageLayout & > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_setPageLayout_2413_0 (arg1));
}

static void _set_callback_cbs_setPageLayout_2413_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageLayout_2413_0 = cb;
}


// bool QPdfWriter::setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)

static void _init_cbs_setPageMargins_4145_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageLayout::Unit>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setPageMargins_4145_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = args.read<const QMarginsF & > (heap);
  const qt_gsi::Converter<QPageLayout::Unit>::target_type & arg2 = args.read<const qt_gsi::Converter<QPageLayout::Unit>::target_type & > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_setPageMargins_4145_1 (arg1, arg2));
}

static void _set_callback_cbs_setPageMargins_4145_1 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageMargins_4145_1 = cb;
}


// bool QPdfWriter::setPageOrientation(QPageLayout::Orientation orientation)

static void _init_cbs_setPageOrientation_2816_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<QPageLayout::Orientation>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setPageOrientation_2816_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageLayout::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<QPageLayout::Orientation>::target_type & > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_setPageOrientation_2816_0 (arg1));
}

static void _set_callback_cbs_setPageOrientation_2816_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageOrientation_2816_0 = cb;
}


// void QPdfWriter::setPageRanges(const QPageRanges &ranges)

static void _init_cbs_setPageRanges_2383_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ranges");
  decl->add_arg<const QPageRanges & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPageRanges_2383_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageRanges &arg1 = args.read<const QPageRanges & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_setPageRanges_2383_0 (arg1);
}

static void _set_callback_cbs_setPageRanges_2383_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageRanges_2383_0 = cb;
}


// bool QPdfWriter::setPageSize(const QPageSize &pageSize)

static void _init_cbs_setPageSize_2186_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSize");
  decl->add_arg<const QPageSize & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_setPageSize_2186_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageSize &arg1 = args.read<const QPageSize & > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_setPageSize_2186_0 (arg1));
}

static void _set_callback_cbs_setPageSize_2186_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageSize_2186_0 = cb;
}


// QPainter *QPdfWriter::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPdfWriter_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QPdfWriter::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QPdfWriter> &qtdecl_QPdfWriter ();

static gsi::Methods methods_QPdfWriter_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPdfWriter::QPdfWriter(const QString &filename)\nThis method creates an object of class QPdfWriter.", &_init_ctor_QPdfWriter_Adaptor_2025, &_call_ctor_QPdfWriter_Adaptor_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPdfWriter::QPdfWriter(QIODevice *device)\nThis method creates an object of class QPdfWriter.", &_init_ctor_QPdfWriter_Adaptor_1447, &_call_ctor_QPdfWriter_Adaptor_1447);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPdfWriter::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPdfWriter::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPdfWriter::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPdfWriter::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPdfWriter::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPdfWriter::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPdfWriter::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Virtual method bool QPdfWriter::newPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@hide", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0, &_set_callback_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPdfWriter::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*paintEngine", "@brief Virtual method QPaintEngine *QPdfWriter::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPdfWriter::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPdfWriter::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPdfWriter::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPdfWriter::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setPageLayout", "@brief Virtual method bool QPdfWriter::setPageLayout(const QPageLayout &pageLayout)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageLayout_2413_0, &_call_cbs_setPageLayout_2413_0);
  methods += new qt_gsi::GenericMethod ("setPageLayout", "@hide", false, &_init_cbs_setPageLayout_2413_0, &_call_cbs_setPageLayout_2413_0, &_set_callback_cbs_setPageLayout_2413_0);
  methods += new qt_gsi::GenericMethod ("setPageMargins", "@brief Virtual method bool QPdfWriter::setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageMargins_4145_1, &_call_cbs_setPageMargins_4145_1);
  methods += new qt_gsi::GenericMethod ("setPageMargins", "@hide", false, &_init_cbs_setPageMargins_4145_1, &_call_cbs_setPageMargins_4145_1, &_set_callback_cbs_setPageMargins_4145_1);
  methods += new qt_gsi::GenericMethod ("setPageOrientation", "@brief Virtual method bool QPdfWriter::setPageOrientation(QPageLayout::Orientation orientation)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageOrientation_2816_0, &_call_cbs_setPageOrientation_2816_0);
  methods += new qt_gsi::GenericMethod ("setPageOrientation", "@hide", false, &_init_cbs_setPageOrientation_2816_0, &_call_cbs_setPageOrientation_2816_0, &_set_callback_cbs_setPageOrientation_2816_0);
  methods += new qt_gsi::GenericMethod ("setPageRanges", "@brief Virtual method void QPdfWriter::setPageRanges(const QPageRanges &ranges)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageRanges_2383_0, &_call_cbs_setPageRanges_2383_0);
  methods += new qt_gsi::GenericMethod ("setPageRanges", "@hide", false, &_init_cbs_setPageRanges_2383_0, &_call_cbs_setPageRanges_2383_0, &_set_callback_cbs_setPageRanges_2383_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@brief Virtual method bool QPdfWriter::setPageSize(const QPageSize &pageSize)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageSize_2186_0, &_call_cbs_setPageSize_2186_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@hide", false, &_init_cbs_setPageSize_2186_0, &_call_cbs_setPageSize_2186_0, &_set_callback_cbs_setPageSize_2186_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPdfWriter::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPdfWriter::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QPdfWriter_Adaptor> decl_QPdfWriter_Adaptor (qtdecl_QPdfWriter (), "QtGui", "QPdfWriter",
  methods_QPdfWriter_Adaptor (),
  "@qt\n@brief Binding of QPdfWriter");

}

