
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextEdit.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextEdit>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QColor>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMenu>
#include <QMetaMethod>
#include <QMimeData>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPagedPaintDevice>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegExp>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QTabletEvent>
#include <QTextCharFormat>
#include <QTextCursor>
#include <QTextDocument>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include "gsiDeclQtWidgetsTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextEdit

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextEdit::staticMetaObject);
}


// bool QTextEdit::acceptRichText()


static void _init_f_acceptRichText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_acceptRichText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->acceptRichText ());
}


// QFlags<Qt::AlignmentFlag> QTextEdit::alignment()


static void _init_f_alignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QTextEdit *)cls)->alignment ());
}


// QString QTextEdit::anchorAt(const QPoint &pos)


static void _init_f_anchorAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_anchorAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QString > ((QString)((QTextEdit *)cls)->anchorAt (arg1));
}


// void QTextEdit::append(const QString &text)


static void _init_f_append_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_append_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->append (arg1);
}


// QFlags<QTextEdit::AutoFormattingFlag> QTextEdit::autoFormatting()


static void _init_f_autoFormatting_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QTextEdit::AutoFormattingFlag> > ();
}

static void _call_f_autoFormatting_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QTextEdit::AutoFormattingFlag> > ((QFlags<QTextEdit::AutoFormattingFlag>)((QTextEdit *)cls)->autoFormatting ());
}


// bool QTextEdit::canPaste()


static void _init_f_canPaste_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canPaste_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->canPaste ());
}


// void QTextEdit::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->clear ();
}


// void QTextEdit::copy()


static void _init_f_copy_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_copy_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->copy ();
}


// QMenu *QTextEdit::createStandardContextMenu()


static void _init_f_createStandardContextMenu_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_createStandardContextMenu_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMenu * > ((QMenu *)((QTextEdit *)cls)->createStandardContextMenu ());
}


// QMenu *QTextEdit::createStandardContextMenu(const QPoint &position)


static void _init_f_createStandardContextMenu_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QMenu * > ();
}

static void _call_f_createStandardContextMenu_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QMenu * > ((QMenu *)((QTextEdit *)cls)->createStandardContextMenu (arg1));
}


// QTextCharFormat QTextEdit::currentCharFormat()


static void _init_f_currentCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_currentCharFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextEdit *)cls)->currentCharFormat ());
}


// QFont QTextEdit::currentFont()


static void _init_f_currentFont_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_currentFont_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QTextEdit *)cls)->currentFont ());
}


// QTextCursor QTextEdit::cursorForPosition(const QPoint &pos)


static void _init_f_cursorForPosition_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QTextCursor > ();
}

static void _call_f_cursorForPosition_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ret.write<QTextCursor > ((QTextCursor)((QTextEdit *)cls)->cursorForPosition (arg1));
}


// QRect QTextEdit::cursorRect(const QTextCursor &cursor)


static void _init_f_cursorRect_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_cursorRect_c2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  ret.write<QRect > ((QRect)((QTextEdit *)cls)->cursorRect (arg1));
}


// QRect QTextEdit::cursorRect()


static void _init_f_cursorRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_cursorRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QTextEdit *)cls)->cursorRect ());
}


// int QTextEdit::cursorWidth()


static void _init_f_cursorWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextEdit *)cls)->cursorWidth ());
}


// void QTextEdit::cut()


static void _init_f_cut_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cut_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->cut ();
}


// QTextDocument *QTextEdit::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextDocument * > ((QTextDocument *)((QTextEdit *)cls)->document ());
}


// QString QTextEdit::documentTitle()


static void _init_f_documentTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_documentTitle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextEdit *)cls)->documentTitle ());
}


// void QTextEdit::ensureCursorVisible()


static void _init_f_ensureCursorVisible_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ensureCursorVisible_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->ensureCursorVisible ();
}


// QList<QTextEdit::ExtraSelection> QTextEdit::extraSelections()


static void _init_f_extraSelections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QTextEdit::ExtraSelection> > ();
}

static void _call_f_extraSelections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QTextEdit::ExtraSelection> > ((QList<QTextEdit::ExtraSelection>)((QTextEdit *)cls)->extraSelections ());
}


// bool QTextEdit::find(const QString &exp, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_5261 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("exp");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_find_5261 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QFlags<QTextDocument::FindFlag> arg2 = args ? gsi::arg_reader<QFlags<QTextDocument::FindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QTextDocument::FindFlag> >() (0, heap);
  ret.write<bool > ((bool)((QTextEdit *)cls)->find (arg1, arg2));
}


// bool QTextEdit::find(const QRegExp &exp, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_5217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("exp");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_find_5217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = gsi::arg_reader<const QRegExp & >() (args, heap);
  QFlags<QTextDocument::FindFlag> arg2 = args ? gsi::arg_reader<QFlags<QTextDocument::FindFlag> >() (args, heap) : gsi::arg_maker<QFlags<QTextDocument::FindFlag> >() (0, heap);
  ret.write<bool > ((bool)((QTextEdit *)cls)->find (arg1, arg2));
}


// QString QTextEdit::fontFamily()


static void _init_f_fontFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fontFamily_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextEdit *)cls)->fontFamily ());
}


// bool QTextEdit::fontItalic()


static void _init_f_fontItalic_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontItalic_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->fontItalic ());
}


// double QTextEdit::fontPointSize()


static void _init_f_fontPointSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_fontPointSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextEdit *)cls)->fontPointSize ());
}


// bool QTextEdit::fontUnderline()


static void _init_f_fontUnderline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontUnderline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->fontUnderline ());
}


// int QTextEdit::fontWeight()


static void _init_f_fontWeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fontWeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextEdit *)cls)->fontWeight ());
}


// QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery property)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("property");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QTextEdit *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}


// QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery query, QVariant argument)


static void _init_f_inputMethodQuery_c3554 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("argument");
  decl->add_arg<QVariant > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c3554 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap);
  QVariant arg2 = gsi::arg_reader<QVariant >() (args, heap);
  ret.write<QVariant > ((QVariant)((QTextEdit *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref(), arg2));
}


// void QTextEdit::insertHtml(const QString &text)


static void _init_f_insertHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->insertHtml (arg1);
}


// void QTextEdit::insertPlainText(const QString &text)


static void _init_f_insertPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->insertPlainText (arg1);
}


// bool QTextEdit::isReadOnly()


static void _init_f_isReadOnly_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadOnly_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->isReadOnly ());
}


// bool QTextEdit::isUndoRedoEnabled()


static void _init_f_isUndoRedoEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoRedoEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->isUndoRedoEnabled ());
}


// int QTextEdit::lineWrapColumnOrWidth()


static void _init_f_lineWrapColumnOrWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineWrapColumnOrWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextEdit *)cls)->lineWrapColumnOrWidth ());
}


// QTextEdit::LineWrapMode QTextEdit::lineWrapMode()


static void _init_f_lineWrapMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type > ();
}

static void _call_f_lineWrapMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type > ((qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type)qt_gsi::CppToQtAdaptor<QTextEdit::LineWrapMode>(((QTextEdit *)cls)->lineWrapMode ()));
}


// QVariant QTextEdit::loadResource(int type, const QUrl &name)


static void _init_f_loadResource_2360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_loadResource_2360 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QUrl &arg2 = gsi::arg_reader<const QUrl & >() (args, heap);
  ret.write<QVariant > ((QVariant)((QTextEdit *)cls)->loadResource (arg1, arg2));
}


// void QTextEdit::mergeCurrentCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeCurrentCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeCurrentCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->mergeCurrentCharFormat (arg1);
}


// void QTextEdit::moveCursor(QTextCursor::MoveOperation operation, QTextCursor::MoveMode mode)


static void _init_f_moveCursor_5424 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("operation");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveCursor_5424 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & >() (args, heap);
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->moveCursor (qt_gsi::QtToCppAdaptor<QTextCursor::MoveOperation>(arg1).cref(), qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref());
}


// bool QTextEdit::overwriteMode()


static void _init_f_overwriteMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_overwriteMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->overwriteMode ());
}


// void QTextEdit::paste()


static void _init_f_paste_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_paste_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->paste ();
}


// QString QTextEdit::placeholderText()


static void _init_f_placeholderText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_placeholderText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextEdit *)cls)->placeholderText ());
}


// void QTextEdit::print(QPagedPaintDevice *printer)


static void _init_f_print_c2284 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPagedPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_print_c2284 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPagedPaintDevice *arg1 = gsi::arg_reader<QPagedPaintDevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->print (arg1);
}


// void QTextEdit::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->redo ();
}


// void QTextEdit::scrollToAnchor(const QString &name)


static void _init_f_scrollToAnchor_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_scrollToAnchor_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->scrollToAnchor (arg1);
}


// void QTextEdit::selectAll()


static void _init_f_selectAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_selectAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->selectAll ();
}


// void QTextEdit::setAcceptRichText(bool accept)


static void _init_f_setAcceptRichText_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accept");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAcceptRichText_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setAcceptRichText (arg1);
}


// void QTextEdit::setAlignment(QFlags<Qt::AlignmentFlag> a)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setAlignment (arg1);
}


// void QTextEdit::setAutoFormatting(QFlags<QTextEdit::AutoFormattingFlag> features)


static void _init_f_setAutoFormatting_3978 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("features");
  decl->add_arg<QFlags<QTextEdit::AutoFormattingFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoFormatting_3978 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QTextEdit::AutoFormattingFlag> arg1 = gsi::arg_reader<QFlags<QTextEdit::AutoFormattingFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setAutoFormatting (arg1);
}


// void QTextEdit::setCurrentCharFormat(const QTextCharFormat &format)


static void _init_f_setCurrentCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentCharFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setCurrentCharFormat (arg1);
}


// void QTextEdit::setCurrentFont(const QFont &f)


static void _init_f_setCurrentFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = gsi::arg_reader<const QFont & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setCurrentFont (arg1);
}


// void QTextEdit::setCursorWidth(int width)


static void _init_f_setCursorWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setCursorWidth (arg1);
}


// void QTextEdit::setDocument(QTextDocument *document)


static void _init_f_setDocument_1955 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocument_1955 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextDocument *arg1 = gsi::arg_reader<QTextDocument * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setDocument (arg1);
}


// void QTextEdit::setDocumentTitle(const QString &title)


static void _init_f_setDocumentTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setDocumentTitle (arg1);
}


// void QTextEdit::setExtraSelections(const QList<QTextEdit::ExtraSelection> &selections)


static void _init_f_setExtraSelections_4386 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selections");
  decl->add_arg<const QList<QTextEdit::ExtraSelection> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setExtraSelections_4386 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QTextEdit::ExtraSelection> &arg1 = gsi::arg_reader<const QList<QTextEdit::ExtraSelection> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setExtraSelections (arg1);
}


// void QTextEdit::setFontFamily(const QString &fontFamily)


static void _init_f_setFontFamily_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontFamily");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontFamily_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setFontFamily (arg1);
}


// void QTextEdit::setFontItalic(bool b)


static void _init_f_setFontItalic_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontItalic_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setFontItalic (arg1);
}


// void QTextEdit::setFontPointSize(double s)


static void _init_f_setFontPointSize_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontPointSize_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setFontPointSize (arg1);
}


// void QTextEdit::setFontUnderline(bool b)


static void _init_f_setFontUnderline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontUnderline_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setFontUnderline (arg1);
}


// void QTextEdit::setFontWeight(int w)


static void _init_f_setFontWeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontWeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setFontWeight (arg1);
}


// void QTextEdit::setHtml(const QString &text)


static void _init_f_setHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setHtml (arg1);
}


// void QTextEdit::setLineWrapColumnOrWidth(int w)


static void _init_f_setLineWrapColumnOrWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineWrapColumnOrWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setLineWrapColumnOrWidth (arg1);
}


// void QTextEdit::setLineWrapMode(QTextEdit::LineWrapMode mode)


static void _init_f_setLineWrapMode_2635 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineWrapMode_2635 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextEdit::LineWrapMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setLineWrapMode (qt_gsi::QtToCppAdaptor<QTextEdit::LineWrapMode>(arg1).cref());
}


// void QTextEdit::setOverwriteMode(bool overwrite)


static void _init_f_setOverwriteMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overwrite");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverwriteMode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setOverwriteMode (arg1);
}


// void QTextEdit::setPlaceholderText(const QString &placeholderText)


static void _init_f_setPlaceholderText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("placeholderText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlaceholderText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setPlaceholderText (arg1);
}


// void QTextEdit::setPlainText(const QString &text)


static void _init_f_setPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setPlainText (arg1);
}


// void QTextEdit::setReadOnly(bool ro)


static void _init_f_setReadOnly_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ro");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadOnly_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setReadOnly (arg1);
}


// void QTextEdit::setTabChangesFocus(bool b)


static void _init_f_setTabChangesFocus_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabChangesFocus_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTabChangesFocus (arg1);
}


// void QTextEdit::setTabStopWidth(int width)


static void _init_f_setTabStopWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabStopWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTabStopWidth (arg1);
}


// void QTextEdit::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setText (arg1);
}


// void QTextEdit::setTextBackgroundColor(const QColor &c)


static void _init_f_setTextBackgroundColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextBackgroundColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTextBackgroundColor (arg1);
}


// void QTextEdit::setTextColor(const QColor &c)


static void _init_f_setTextColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = gsi::arg_reader<const QColor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTextColor (arg1);
}


// void QTextEdit::setTextCursor(const QTextCursor &cursor)


static void _init_f_setTextCursor_2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextCursor_2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = gsi::arg_reader<const QTextCursor & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTextCursor (arg1);
}


// void QTextEdit::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)


static void _init_f_setTextInteractionFlags_3396 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<Qt::TextInteractionFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextInteractionFlags_3396 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::TextInteractionFlag> arg1 = gsi::arg_reader<QFlags<Qt::TextInteractionFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setTextInteractionFlags (arg1);
}


// void QTextEdit::setUndoRedoEnabled(bool enable)


static void _init_f_setUndoRedoEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoRedoEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setUndoRedoEnabled (arg1);
}


// void QTextEdit::setWordWrapMode(QTextOption::WrapMode policy)


static void _init_f_setWordWrapMode_2486 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QTextOption::WrapMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWordWrapMode_2486 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextOption::WrapMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTextOption::WrapMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->setWordWrapMode (qt_gsi::QtToCppAdaptor<QTextOption::WrapMode>(arg1).cref());
}


// bool QTextEdit::tabChangesFocus()


static void _init_f_tabChangesFocus_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabChangesFocus_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit *)cls)->tabChangesFocus ());
}


// int QTextEdit::tabStopWidth()


static void _init_f_tabStopWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_tabStopWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextEdit *)cls)->tabStopWidth ());
}


// QColor QTextEdit::textBackgroundColor()


static void _init_f_textBackgroundColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_textBackgroundColor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QTextEdit *)cls)->textBackgroundColor ());
}


// QColor QTextEdit::textColor()


static void _init_f_textColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_textColor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QTextEdit *)cls)->textColor ());
}


// QTextCursor QTextEdit::textCursor()


static void _init_f_textCursor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCursor > ();
}

static void _call_f_textCursor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCursor > ((QTextCursor)((QTextEdit *)cls)->textCursor ());
}


// QFlags<Qt::TextInteractionFlag> QTextEdit::textInteractionFlags()


static void _init_f_textInteractionFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::TextInteractionFlag> > ();
}

static void _call_f_textInteractionFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::TextInteractionFlag> > ((QFlags<Qt::TextInteractionFlag>)((QTextEdit *)cls)->textInteractionFlags ());
}


// QString QTextEdit::toHtml()


static void _init_f_toHtml_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toHtml_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextEdit *)cls)->toHtml ());
}


// QString QTextEdit::toPlainText()


static void _init_f_toPlainText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toPlainText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextEdit *)cls)->toPlainText ());
}


// void QTextEdit::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->undo ();
}


// QTextOption::WrapMode QTextEdit::wordWrapMode()


static void _init_f_wordWrapMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextOption::WrapMode>::target_type > ();
}

static void _call_f_wordWrapMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextOption::WrapMode>::target_type > ((qt_gsi::Converter<QTextOption::WrapMode>::target_type)qt_gsi::CppToQtAdaptor<QTextOption::WrapMode>(((QTextEdit *)cls)->wordWrapMode ()));
}


// void QTextEdit::zoomIn(int range)


static void _init_f_zoomIn_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomIn_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->zoomIn (arg1);
}


// void QTextEdit::zoomOut(int range)


static void _init_f_zoomOut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_zoomOut_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (1, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit *)cls)->zoomOut (arg1);
}


// static QString QTextEdit::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTextEdit::tr (arg1, arg2, arg3));
}


// static QString QTextEdit::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTextEdit::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTextEdit () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":acceptRichText", "@brief Method bool QTextEdit::acceptRichText()\n", true, &_init_f_acceptRichText_c0, &_call_f_acceptRichText_c0);
  methods += new qt_gsi::GenericMethod (":alignment", "@brief Method QFlags<Qt::AlignmentFlag> QTextEdit::alignment()\n", true, &_init_f_alignment_c0, &_call_f_alignment_c0);
  methods += new qt_gsi::GenericMethod ("anchorAt", "@brief Method QString QTextEdit::anchorAt(const QPoint &pos)\n", true, &_init_f_anchorAt_c1916, &_call_f_anchorAt_c1916);
  methods += new qt_gsi::GenericMethod ("append", "@brief Method void QTextEdit::append(const QString &text)\n", false, &_init_f_append_2025, &_call_f_append_2025);
  methods += new qt_gsi::GenericMethod (":autoFormatting", "@brief Method QFlags<QTextEdit::AutoFormattingFlag> QTextEdit::autoFormatting()\n", true, &_init_f_autoFormatting_c0, &_call_f_autoFormatting_c0);
  methods += new qt_gsi::GenericMethod ("canPaste", "@brief Method bool QTextEdit::canPaste()\n", true, &_init_f_canPaste_c0, &_call_f_canPaste_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QTextEdit::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("copy", "@brief Method void QTextEdit::copy()\n", false, &_init_f_copy_0, &_call_f_copy_0);
  methods += new qt_gsi::GenericMethod ("createStandardContextMenu", "@brief Method QMenu *QTextEdit::createStandardContextMenu()\n", false, &_init_f_createStandardContextMenu_0, &_call_f_createStandardContextMenu_0);
  methods += new qt_gsi::GenericMethod ("createStandardContextMenu", "@brief Method QMenu *QTextEdit::createStandardContextMenu(const QPoint &position)\n", false, &_init_f_createStandardContextMenu_1916, &_call_f_createStandardContextMenu_1916);
  methods += new qt_gsi::GenericMethod (":currentCharFormat", "@brief Method QTextCharFormat QTextEdit::currentCharFormat()\n", true, &_init_f_currentCharFormat_c0, &_call_f_currentCharFormat_c0);
  methods += new qt_gsi::GenericMethod (":currentFont", "@brief Method QFont QTextEdit::currentFont()\n", true, &_init_f_currentFont_c0, &_call_f_currentFont_c0);
  methods += new qt_gsi::GenericMethod ("cursorForPosition", "@brief Method QTextCursor QTextEdit::cursorForPosition(const QPoint &pos)\n", true, &_init_f_cursorForPosition_c1916, &_call_f_cursorForPosition_c1916);
  methods += new qt_gsi::GenericMethod ("cursorRect", "@brief Method QRect QTextEdit::cursorRect(const QTextCursor &cursor)\n", true, &_init_f_cursorRect_c2453, &_call_f_cursorRect_c2453);
  methods += new qt_gsi::GenericMethod ("cursorRect", "@brief Method QRect QTextEdit::cursorRect()\n", true, &_init_f_cursorRect_c0, &_call_f_cursorRect_c0);
  methods += new qt_gsi::GenericMethod (":cursorWidth", "@brief Method int QTextEdit::cursorWidth()\n", true, &_init_f_cursorWidth_c0, &_call_f_cursorWidth_c0);
  methods += new qt_gsi::GenericMethod ("cut", "@brief Method void QTextEdit::cut()\n", false, &_init_f_cut_0, &_call_f_cut_0);
  methods += new qt_gsi::GenericMethod (":document", "@brief Method QTextDocument *QTextEdit::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
  methods += new qt_gsi::GenericMethod (":documentTitle", "@brief Method QString QTextEdit::documentTitle()\n", true, &_init_f_documentTitle_c0, &_call_f_documentTitle_c0);
  methods += new qt_gsi::GenericMethod ("ensureCursorVisible", "@brief Method void QTextEdit::ensureCursorVisible()\n", false, &_init_f_ensureCursorVisible_0, &_call_f_ensureCursorVisible_0);
  methods += new qt_gsi::GenericMethod (":extraSelections", "@brief Method QList<QTextEdit::ExtraSelection> QTextEdit::extraSelections()\n", true, &_init_f_extraSelections_c0, &_call_f_extraSelections_c0);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method bool QTextEdit::find(const QString &exp, QFlags<QTextDocument::FindFlag> options)\n", false, &_init_f_find_5261, &_call_f_find_5261);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method bool QTextEdit::find(const QRegExp &exp, QFlags<QTextDocument::FindFlag> options)\n", false, &_init_f_find_5217, &_call_f_find_5217);
  methods += new qt_gsi::GenericMethod (":fontFamily", "@brief Method QString QTextEdit::fontFamily()\n", true, &_init_f_fontFamily_c0, &_call_f_fontFamily_c0);
  methods += new qt_gsi::GenericMethod (":fontItalic", "@brief Method bool QTextEdit::fontItalic()\n", true, &_init_f_fontItalic_c0, &_call_f_fontItalic_c0);
  methods += new qt_gsi::GenericMethod (":fontPointSize", "@brief Method double QTextEdit::fontPointSize()\n", true, &_init_f_fontPointSize_c0, &_call_f_fontPointSize_c0);
  methods += new qt_gsi::GenericMethod (":fontUnderline", "@brief Method bool QTextEdit::fontUnderline()\n", true, &_init_f_fontUnderline_c0, &_call_f_fontUnderline_c0);
  methods += new qt_gsi::GenericMethod (":fontWeight", "@brief Method int QTextEdit::fontWeight()\n", true, &_init_f_fontWeight_c0, &_call_f_fontWeight_c0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery property)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery query, QVariant argument)\n", true, &_init_f_inputMethodQuery_c3554, &_call_f_inputMethodQuery_c3554);
  methods += new qt_gsi::GenericMethod ("insertHtml", "@brief Method void QTextEdit::insertHtml(const QString &text)\n", false, &_init_f_insertHtml_2025, &_call_f_insertHtml_2025);
  methods += new qt_gsi::GenericMethod ("insertPlainText", "@brief Method void QTextEdit::insertPlainText(const QString &text)\n", false, &_init_f_insertPlainText_2025, &_call_f_insertPlainText_2025);
  methods += new qt_gsi::GenericMethod ("isReadOnly?|:readOnly", "@brief Method bool QTextEdit::isReadOnly()\n", true, &_init_f_isReadOnly_c0, &_call_f_isReadOnly_c0);
  methods += new qt_gsi::GenericMethod ("isUndoRedoEnabled?|:undoRedoEnabled", "@brief Method bool QTextEdit::isUndoRedoEnabled()\n", true, &_init_f_isUndoRedoEnabled_c0, &_call_f_isUndoRedoEnabled_c0);
  methods += new qt_gsi::GenericMethod (":lineWrapColumnOrWidth", "@brief Method int QTextEdit::lineWrapColumnOrWidth()\n", true, &_init_f_lineWrapColumnOrWidth_c0, &_call_f_lineWrapColumnOrWidth_c0);
  methods += new qt_gsi::GenericMethod (":lineWrapMode", "@brief Method QTextEdit::LineWrapMode QTextEdit::lineWrapMode()\n", true, &_init_f_lineWrapMode_c0, &_call_f_lineWrapMode_c0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Method QVariant QTextEdit::loadResource(int type, const QUrl &name)\n", false, &_init_f_loadResource_2360, &_call_f_loadResource_2360);
  methods += new qt_gsi::GenericMethod ("mergeCurrentCharFormat", "@brief Method void QTextEdit::mergeCurrentCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeCurrentCharFormat_2814, &_call_f_mergeCurrentCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("moveCursor", "@brief Method void QTextEdit::moveCursor(QTextCursor::MoveOperation operation, QTextCursor::MoveMode mode)\n", false, &_init_f_moveCursor_5424, &_call_f_moveCursor_5424);
  methods += new qt_gsi::GenericMethod (":overwriteMode", "@brief Method bool QTextEdit::overwriteMode()\n", true, &_init_f_overwriteMode_c0, &_call_f_overwriteMode_c0);
  methods += new qt_gsi::GenericMethod ("paste", "@brief Method void QTextEdit::paste()\n", false, &_init_f_paste_0, &_call_f_paste_0);
  methods += new qt_gsi::GenericMethod (":placeholderText", "@brief Method QString QTextEdit::placeholderText()\n", true, &_init_f_placeholderText_c0, &_call_f_placeholderText_c0);
  methods += new qt_gsi::GenericMethod ("print", "@brief Method void QTextEdit::print(QPagedPaintDevice *printer)\n", true, &_init_f_print_c2284, &_call_f_print_c2284);
  methods += new qt_gsi::GenericMethod ("redo", "@brief Method void QTextEdit::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
  methods += new qt_gsi::GenericMethod ("scrollToAnchor", "@brief Method void QTextEdit::scrollToAnchor(const QString &name)\n", false, &_init_f_scrollToAnchor_2025, &_call_f_scrollToAnchor_2025);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Method void QTextEdit::selectAll()\n", false, &_init_f_selectAll_0, &_call_f_selectAll_0);
  methods += new qt_gsi::GenericMethod ("setAcceptRichText|acceptRichText=", "@brief Method void QTextEdit::setAcceptRichText(bool accept)\n", false, &_init_f_setAcceptRichText_864, &_call_f_setAcceptRichText_864);
  methods += new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QTextEdit::setAlignment(QFlags<Qt::AlignmentFlag> a)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setAutoFormatting|autoFormatting=", "@brief Method void QTextEdit::setAutoFormatting(QFlags<QTextEdit::AutoFormattingFlag> features)\n", false, &_init_f_setAutoFormatting_3978, &_call_f_setAutoFormatting_3978);
  methods += new qt_gsi::GenericMethod ("setCurrentCharFormat|currentCharFormat=", "@brief Method void QTextEdit::setCurrentCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setCurrentCharFormat_2814, &_call_f_setCurrentCharFormat_2814);
  methods += new qt_gsi::GenericMethod ("setCurrentFont|currentFont=", "@brief Method void QTextEdit::setCurrentFont(const QFont &f)\n", false, &_init_f_setCurrentFont_1801, &_call_f_setCurrentFont_1801);
  methods += new qt_gsi::GenericMethod ("setCursorWidth|cursorWidth=", "@brief Method void QTextEdit::setCursorWidth(int width)\n", false, &_init_f_setCursorWidth_767, &_call_f_setCursorWidth_767);
  methods += new qt_gsi::GenericMethod ("setDocument|document=", "@brief Method void QTextEdit::setDocument(QTextDocument *document)\n", false, &_init_f_setDocument_1955, &_call_f_setDocument_1955);
  methods += new qt_gsi::GenericMethod ("setDocumentTitle|documentTitle=", "@brief Method void QTextEdit::setDocumentTitle(const QString &title)\n", false, &_init_f_setDocumentTitle_2025, &_call_f_setDocumentTitle_2025);
  methods += new qt_gsi::GenericMethod ("setExtraSelections|extraSelections=", "@brief Method void QTextEdit::setExtraSelections(const QList<QTextEdit::ExtraSelection> &selections)\n", false, &_init_f_setExtraSelections_4386, &_call_f_setExtraSelections_4386);
  methods += new qt_gsi::GenericMethod ("setFontFamily|fontFamily=", "@brief Method void QTextEdit::setFontFamily(const QString &fontFamily)\n", false, &_init_f_setFontFamily_2025, &_call_f_setFontFamily_2025);
  methods += new qt_gsi::GenericMethod ("setFontItalic|fontItalic=", "@brief Method void QTextEdit::setFontItalic(bool b)\n", false, &_init_f_setFontItalic_864, &_call_f_setFontItalic_864);
  methods += new qt_gsi::GenericMethod ("setFontPointSize|fontPointSize=", "@brief Method void QTextEdit::setFontPointSize(double s)\n", false, &_init_f_setFontPointSize_1071, &_call_f_setFontPointSize_1071);
  methods += new qt_gsi::GenericMethod ("setFontUnderline|fontUnderline=", "@brief Method void QTextEdit::setFontUnderline(bool b)\n", false, &_init_f_setFontUnderline_864, &_call_f_setFontUnderline_864);
  methods += new qt_gsi::GenericMethod ("setFontWeight|fontWeight=", "@brief Method void QTextEdit::setFontWeight(int w)\n", false, &_init_f_setFontWeight_767, &_call_f_setFontWeight_767);
  methods += new qt_gsi::GenericMethod ("setHtml|html=", "@brief Method void QTextEdit::setHtml(const QString &text)\n", false, &_init_f_setHtml_2025, &_call_f_setHtml_2025);
  methods += new qt_gsi::GenericMethod ("setLineWrapColumnOrWidth|lineWrapColumnOrWidth=", "@brief Method void QTextEdit::setLineWrapColumnOrWidth(int w)\n", false, &_init_f_setLineWrapColumnOrWidth_767, &_call_f_setLineWrapColumnOrWidth_767);
  methods += new qt_gsi::GenericMethod ("setLineWrapMode|lineWrapMode=", "@brief Method void QTextEdit::setLineWrapMode(QTextEdit::LineWrapMode mode)\n", false, &_init_f_setLineWrapMode_2635, &_call_f_setLineWrapMode_2635);
  methods += new qt_gsi::GenericMethod ("setOverwriteMode|overwriteMode=", "@brief Method void QTextEdit::setOverwriteMode(bool overwrite)\n", false, &_init_f_setOverwriteMode_864, &_call_f_setOverwriteMode_864);
  methods += new qt_gsi::GenericMethod ("setPlaceholderText|placeholderText=", "@brief Method void QTextEdit::setPlaceholderText(const QString &placeholderText)\n", false, &_init_f_setPlaceholderText_2025, &_call_f_setPlaceholderText_2025);
  methods += new qt_gsi::GenericMethod ("setPlainText|plainText=", "@brief Method void QTextEdit::setPlainText(const QString &text)\n", false, &_init_f_setPlainText_2025, &_call_f_setPlainText_2025);
  methods += new qt_gsi::GenericMethod ("setReadOnly|readOnly=", "@brief Method void QTextEdit::setReadOnly(bool ro)\n", false, &_init_f_setReadOnly_864, &_call_f_setReadOnly_864);
  methods += new qt_gsi::GenericMethod ("setTabChangesFocus|tabChangesFocus=", "@brief Method void QTextEdit::setTabChangesFocus(bool b)\n", false, &_init_f_setTabChangesFocus_864, &_call_f_setTabChangesFocus_864);
  methods += new qt_gsi::GenericMethod ("setTabStopWidth|tabStopWidth=", "@brief Method void QTextEdit::setTabStopWidth(int width)\n", false, &_init_f_setTabStopWidth_767, &_call_f_setTabStopWidth_767);
  methods += new qt_gsi::GenericMethod ("setText", "@brief Method void QTextEdit::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
  methods += new qt_gsi::GenericMethod ("setTextBackgroundColor|textBackgroundColor=", "@brief Method void QTextEdit::setTextBackgroundColor(const QColor &c)\n", false, &_init_f_setTextBackgroundColor_1905, &_call_f_setTextBackgroundColor_1905);
  methods += new qt_gsi::GenericMethod ("setTextColor|textColor=", "@brief Method void QTextEdit::setTextColor(const QColor &c)\n", false, &_init_f_setTextColor_1905, &_call_f_setTextColor_1905);
  methods += new qt_gsi::GenericMethod ("setTextCursor|textCursor=", "@brief Method void QTextEdit::setTextCursor(const QTextCursor &cursor)\n", false, &_init_f_setTextCursor_2453, &_call_f_setTextCursor_2453);
  methods += new qt_gsi::GenericMethod ("setTextInteractionFlags|textInteractionFlags=", "@brief Method void QTextEdit::setTextInteractionFlags(QFlags<Qt::TextInteractionFlag> flags)\n", false, &_init_f_setTextInteractionFlags_3396, &_call_f_setTextInteractionFlags_3396);
  methods += new qt_gsi::GenericMethod ("setUndoRedoEnabled|undoRedoEnabled=", "@brief Method void QTextEdit::setUndoRedoEnabled(bool enable)\n", false, &_init_f_setUndoRedoEnabled_864, &_call_f_setUndoRedoEnabled_864);
  methods += new qt_gsi::GenericMethod ("setWordWrapMode|wordWrapMode=", "@brief Method void QTextEdit::setWordWrapMode(QTextOption::WrapMode policy)\n", false, &_init_f_setWordWrapMode_2486, &_call_f_setWordWrapMode_2486);
  methods += new qt_gsi::GenericMethod (":tabChangesFocus", "@brief Method bool QTextEdit::tabChangesFocus()\n", true, &_init_f_tabChangesFocus_c0, &_call_f_tabChangesFocus_c0);
  methods += new qt_gsi::GenericMethod (":tabStopWidth", "@brief Method int QTextEdit::tabStopWidth()\n", true, &_init_f_tabStopWidth_c0, &_call_f_tabStopWidth_c0);
  methods += new qt_gsi::GenericMethod (":textBackgroundColor", "@brief Method QColor QTextEdit::textBackgroundColor()\n", true, &_init_f_textBackgroundColor_c0, &_call_f_textBackgroundColor_c0);
  methods += new qt_gsi::GenericMethod (":textColor", "@brief Method QColor QTextEdit::textColor()\n", true, &_init_f_textColor_c0, &_call_f_textColor_c0);
  methods += new qt_gsi::GenericMethod (":textCursor", "@brief Method QTextCursor QTextEdit::textCursor()\n", true, &_init_f_textCursor_c0, &_call_f_textCursor_c0);
  methods += new qt_gsi::GenericMethod (":textInteractionFlags", "@brief Method QFlags<Qt::TextInteractionFlag> QTextEdit::textInteractionFlags()\n", true, &_init_f_textInteractionFlags_c0, &_call_f_textInteractionFlags_c0);
  methods += new qt_gsi::GenericMethod ("toHtml", "@brief Method QString QTextEdit::toHtml()\n", true, &_init_f_toHtml_c0, &_call_f_toHtml_c0);
  methods += new qt_gsi::GenericMethod ("toPlainText", "@brief Method QString QTextEdit::toPlainText()\n", true, &_init_f_toPlainText_c0, &_call_f_toPlainText_c0);
  methods += new qt_gsi::GenericMethod ("undo", "@brief Method void QTextEdit::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
  methods += new qt_gsi::GenericMethod (":wordWrapMode", "@brief Method QTextOption::WrapMode QTextEdit::wordWrapMode()\n", true, &_init_f_wordWrapMode_c0, &_call_f_wordWrapMode_c0);
  methods += new qt_gsi::GenericMethod ("zoomIn", "@brief Method void QTextEdit::zoomIn(int range)\n", false, &_init_f_zoomIn_767, &_call_f_zoomIn_767);
  methods += new qt_gsi::GenericMethod ("zoomOut", "@brief Method void QTextEdit::zoomOut(int range)\n", false, &_init_f_zoomOut_767, &_call_f_zoomOut_767);
  methods += gsi::qt_signal<bool > ("copyAvailable(bool)", "copyAvailable", gsi::arg("b"), "@brief Signal declaration for QTextEdit::copyAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QTextCharFormat & > ("currentCharFormatChanged(const QTextCharFormat &)", "currentCharFormatChanged", gsi::arg("format"), "@brief Signal declaration for QTextEdit::currentCharFormatChanged(const QTextCharFormat &format)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("cursorPositionChanged()", "cursorPositionChanged", "@brief Signal declaration for QTextEdit::cursorPositionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTextEdit::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTextEdit::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("redoAvailable(bool)", "redoAvailable", gsi::arg("b"), "@brief Signal declaration for QTextEdit::redoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("selectionChanged()", "selectionChanged", "@brief Signal declaration for QTextEdit::selectionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("textChanged()", "textChanged", "@brief Signal declaration for QTextEdit::textChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("undoAvailable(bool)", "undoAvailable", gsi::arg("b"), "@brief Signal declaration for QTextEdit::undoAvailable(bool b)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QTextEdit::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QTextEdit::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QTextEdit::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextEdit::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextEdit::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractScrollArea> &qtdecl_QAbstractScrollArea ();

qt_gsi::QtNativeClass<QTextEdit> decl_QTextEdit (qtdecl_QAbstractScrollArea (), "QtWidgets", "QTextEdit_Native",
  methods_QTextEdit (),
  "@hide\n@alias QTextEdit");

GSI_QTWIDGETS_PUBLIC gsi::Class<QTextEdit> &qtdecl_QTextEdit () { return decl_QTextEdit; }

}


class QTextEdit_Adaptor : public QTextEdit, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextEdit_Adaptor();

  //  [adaptor ctor] QTextEdit::QTextEdit(QWidget *parent)
  QTextEdit_Adaptor() : QTextEdit()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextEdit::QTextEdit(QWidget *parent)
  QTextEdit_Adaptor(QWidget *parent) : QTextEdit(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextEdit::QTextEdit(const QString &text, QWidget *parent)
  QTextEdit_Adaptor(const QString &text) : QTextEdit(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextEdit::QTextEdit(const QString &text, QWidget *parent)
  QTextEdit_Adaptor(const QString &text, QWidget *parent) : QTextEdit(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTextEdit_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTextEdit::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTextEdit::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTextEdit_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTextEdit::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] void QTextEdit::drawFrame(QPainter *)
  void fp_QTextEdit_drawFrame_1426 (QPainter *arg1) {
    QTextEdit::drawFrame(arg1);
  }

  //  [expose] bool QTextEdit::focusNextChild()
  bool fp_QTextEdit_focusNextChild_0 () {
    return QTextEdit::focusNextChild();
  }

  //  [expose] bool QTextEdit::focusPreviousChild()
  bool fp_QTextEdit_focusPreviousChild_0 () {
    return QTextEdit::focusPreviousChild();
  }

  //  [expose] void QTextEdit::initStyleOption(QStyleOptionFrame *option)
  void fp_QTextEdit_initStyleOption_c2356 (QStyleOptionFrame *option) const {
    QTextEdit::initStyleOption(option);
  }

  //  [expose] bool QTextEdit::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTextEdit_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTextEdit::isSignalConnected(signal);
  }

  //  [expose] int QTextEdit::receivers(const char *signal)
  int fp_QTextEdit_receivers_c1731 (const char *signal) const {
    return QTextEdit::receivers(signal);
  }

  //  [expose] QObject *QTextEdit::sender()
  QObject * fp_QTextEdit_sender_c0 () const {
    return QTextEdit::sender();
  }

  //  [expose] int QTextEdit::senderSignalIndex()
  int fp_QTextEdit_senderSignalIndex_c0 () const {
    return QTextEdit::senderSignalIndex();
  }

  //  [expose] void QTextEdit::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QTextEdit_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QTextEdit::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QTextEdit::setViewportMargins(const QMargins &margins)
  void fp_QTextEdit_setViewportMargins_2115 (const QMargins &margins) {
    QTextEdit::setViewportMargins(margins);
  }

  //  [expose] void QTextEdit::updateMicroFocus()
  void fp_QTextEdit_updateMicroFocus_0 () {
    QTextEdit::updateMicroFocus();
  }

  //  [expose] QMargins QTextEdit::viewportMargins()
  QMargins fp_QTextEdit_viewportMargins_c0 () const {
    return QTextEdit::viewportMargins();
  }

  //  [expose] void QTextEdit::zoomInF(float range)
  void fp_QTextEdit_zoomInF_970 (float range) {
    QTextEdit::zoomInF(range);
  }

  //  [emitter impl] void QTextEdit::copyAvailable(bool b)
  void emitter_QTextEdit_copyAvailable_864(bool b)
  {
    emit QTextEdit::copyAvailable(b);
  }

  //  [emitter impl] void QTextEdit::currentCharFormatChanged(const QTextCharFormat &format)
  void emitter_QTextEdit_currentCharFormatChanged_2814(const QTextCharFormat &format)
  {
    emit QTextEdit::currentCharFormatChanged(format);
  }

  //  [emitter impl] void QTextEdit::cursorPositionChanged()
  void emitter_QTextEdit_cursorPositionChanged_0()
  {
    emit QTextEdit::cursorPositionChanged();
  }

  //  [emitter impl] void QTextEdit::customContextMenuRequested(const QPoint &pos)
  void emitter_QTextEdit_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTextEdit::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QTextEdit::destroyed(QObject *)
  void emitter_QTextEdit_destroyed_1302(QObject *arg1)
  {
    emit QTextEdit::destroyed(arg1);
  }

  //  [adaptor impl] bool QTextEdit::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QTextEdit::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QTextEdit_Adaptor, bool>(&QTextEdit_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QTextEdit::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QTextEdit::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QTextEdit::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTextEdit_Adaptor, int, int>(&QTextEdit_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QTextEdit::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery property)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & property) const
  {
    return QTextEdit::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(property).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery property) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTextEdit_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTextEdit_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(property));
    } else {
      return QTextEdit::inputMethodQuery(property);
    }
  }

  //  [adaptor impl] QVariant QTextEdit::loadResource(int type, const QUrl &name)
  QVariant cbs_loadResource_2360_0(int type, const QUrl &name)
  {
    return QTextEdit::loadResource(type, name);
  }

  virtual QVariant loadResource(int type, const QUrl &name)
  {
    if (cb_loadResource_2360_0.can_issue()) {
      return cb_loadResource_2360_0.issue<QTextEdit_Adaptor, QVariant, int, const QUrl &>(&QTextEdit_Adaptor::cbs_loadResource_2360_0, type, name);
    } else {
      return QTextEdit::loadResource(type, name);
    }
  }

  //  [adaptor impl] QSize QTextEdit::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTextEdit::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTextEdit_Adaptor, QSize>(&QTextEdit_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTextEdit::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QTextEdit::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTextEdit::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTextEdit_Adaptor, QPaintEngine *>(&QTextEdit_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTextEdit::paintEngine();
    }
  }

  //  [emitter impl] void QTextEdit::redoAvailable(bool b)
  void emitter_QTextEdit_redoAvailable_864(bool b)
  {
    emit QTextEdit::redoAvailable(b);
  }

  //  [emitter impl] void QTextEdit::selectionChanged()
  void emitter_QTextEdit_selectionChanged_0()
  {
    emit QTextEdit::selectionChanged();
  }

  //  [adaptor impl] void QTextEdit::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTextEdit::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTextEdit_Adaptor, bool>(&QTextEdit_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTextEdit::setVisible(visible);
    }
  }

  //  [adaptor impl] void QTextEdit::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QTextEdit::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QTextEdit_Adaptor, QWidget *>(&QTextEdit_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QTextEdit::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QTextEdit::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTextEdit::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTextEdit_Adaptor, QSize>(&QTextEdit_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTextEdit::sizeHint();
    }
  }

  //  [emitter impl] void QTextEdit::textChanged()
  void emitter_QTextEdit_textChanged_0()
  {
    emit QTextEdit::textChanged();
  }

  //  [emitter impl] void QTextEdit::undoAvailable(bool b)
  void emitter_QTextEdit_undoAvailable_864(bool b)
  {
    emit QTextEdit::undoAvailable(b);
  }

  //  [emitter impl] void QTextEdit::windowIconChanged(const QIcon &icon)
  void emitter_QTextEdit_windowIconChanged_1787(const QIcon &icon)
  {
    emit QTextEdit::windowIconChanged(icon);
  }

  //  [emitter impl] void QTextEdit::windowIconTextChanged(const QString &iconText)
  void emitter_QTextEdit_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QTextEdit::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QTextEdit::windowTitleChanged(const QString &title)
  void emitter_QTextEdit_windowTitleChanged_2025(const QString &title)
  {
    emit QTextEdit::windowTitleChanged(title);
  }

  //  [adaptor impl] void QTextEdit::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QTextEdit::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTextEdit_Adaptor, QActionEvent *>(&QTextEdit_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QTextEdit::actionEvent(arg1);
    }
  }

  //  [adaptor impl] bool QTextEdit::canInsertFromMimeData(const QMimeData *source)
  bool cbs_canInsertFromMimeData_c2168_0(const QMimeData *source) const
  {
    return QTextEdit::canInsertFromMimeData(source);
  }

  virtual bool canInsertFromMimeData(const QMimeData *source) const
  {
    if (cb_canInsertFromMimeData_c2168_0.can_issue()) {
      return cb_canInsertFromMimeData_c2168_0.issue<QTextEdit_Adaptor, bool, const QMimeData *>(&QTextEdit_Adaptor::cbs_canInsertFromMimeData_c2168_0, source);
    } else {
      return QTextEdit::canInsertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QTextEdit::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QTextEdit::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTextEdit_Adaptor, QEvent *>(&QTextEdit_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QTextEdit::changeEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTextEdit::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextEdit_Adaptor, QChildEvent *>(&QTextEdit_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTextEdit::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QTextEdit::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTextEdit_Adaptor, QCloseEvent *>(&QTextEdit_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QTextEdit::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::contextMenuEvent(QContextMenuEvent *e)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *e)
  {
    QTextEdit::contextMenuEvent(e);
  }

  virtual void contextMenuEvent(QContextMenuEvent *e)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTextEdit_Adaptor, QContextMenuEvent *>(&QTextEdit_Adaptor::cbs_contextMenuEvent_2363_0, e);
    } else {
      QTextEdit::contextMenuEvent(e);
    }
  }

  //  [adaptor impl] QMimeData *QTextEdit::createMimeDataFromSelection()
  QMimeData * cbs_createMimeDataFromSelection_c0_0() const
  {
    return QTextEdit::createMimeDataFromSelection();
  }

  virtual QMimeData * createMimeDataFromSelection() const
  {
    if (cb_createMimeDataFromSelection_c0_0.can_issue()) {
      return cb_createMimeDataFromSelection_c0_0.issue<QTextEdit_Adaptor, QMimeData *>(&QTextEdit_Adaptor::cbs_createMimeDataFromSelection_c0_0);
    } else {
      return QTextEdit::createMimeDataFromSelection();
    }
  }

  //  [adaptor impl] void QTextEdit::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTextEdit::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextEdit_Adaptor, QEvent *>(&QTextEdit_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTextEdit::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTextEdit::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTextEdit_Adaptor, const QMetaMethod &>(&QTextEdit_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTextEdit::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTextEdit::doSetTextCursor(const QTextCursor &cursor)
  void cbs_doSetTextCursor_2453_0(const QTextCursor &cursor)
  {
    QTextEdit::doSetTextCursor(cursor);
  }

  virtual void doSetTextCursor(const QTextCursor &cursor)
  {
    if (cb_doSetTextCursor_2453_0.can_issue()) {
      cb_doSetTextCursor_2453_0.issue<QTextEdit_Adaptor, const QTextCursor &>(&QTextEdit_Adaptor::cbs_doSetTextCursor_2453_0, cursor);
    } else {
      QTextEdit::doSetTextCursor(cursor);
    }
  }

  //  [adaptor impl] void QTextEdit::dragEnterEvent(QDragEnterEvent *e)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *e)
  {
    QTextEdit::dragEnterEvent(e);
  }

  virtual void dragEnterEvent(QDragEnterEvent *e)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTextEdit_Adaptor, QDragEnterEvent *>(&QTextEdit_Adaptor::cbs_dragEnterEvent_2109_0, e);
    } else {
      QTextEdit::dragEnterEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::dragLeaveEvent(QDragLeaveEvent *e)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *e)
  {
    QTextEdit::dragLeaveEvent(e);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *e)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTextEdit_Adaptor, QDragLeaveEvent *>(&QTextEdit_Adaptor::cbs_dragLeaveEvent_2092_0, e);
    } else {
      QTextEdit::dragLeaveEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::dragMoveEvent(QDragMoveEvent *e)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *e)
  {
    QTextEdit::dragMoveEvent(e);
  }

  virtual void dragMoveEvent(QDragMoveEvent *e)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTextEdit_Adaptor, QDragMoveEvent *>(&QTextEdit_Adaptor::cbs_dragMoveEvent_2006_0, e);
    } else {
      QTextEdit::dragMoveEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::dropEvent(QDropEvent *e)
  void cbs_dropEvent_1622_0(QDropEvent *e)
  {
    QTextEdit::dropEvent(e);
  }

  virtual void dropEvent(QDropEvent *e)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTextEdit_Adaptor, QDropEvent *>(&QTextEdit_Adaptor::cbs_dropEvent_1622_0, e);
    } else {
      QTextEdit::dropEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QTextEdit::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QTextEdit_Adaptor, QEvent *>(&QTextEdit_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QTextEdit::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QTextEdit::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QTextEdit::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextEdit_Adaptor, bool, QEvent *>(&QTextEdit_Adaptor::cbs_event_1217_0, e);
    } else {
      return QTextEdit::event(e);
    }
  }

  //  [adaptor impl] bool QTextEdit::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextEdit::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextEdit_Adaptor, bool, QObject *, QEvent *>(&QTextEdit_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextEdit::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QTextEdit::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QTextEdit::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTextEdit_Adaptor, QFocusEvent *>(&QTextEdit_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QTextEdit::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QTextEdit::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTextEdit::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTextEdit_Adaptor, bool, bool>(&QTextEdit_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTextEdit::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTextEdit::focusOutEvent(QFocusEvent *e)
  void cbs_focusOutEvent_1729_0(QFocusEvent *e)
  {
    QTextEdit::focusOutEvent(e);
  }

  virtual void focusOutEvent(QFocusEvent *e)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTextEdit_Adaptor, QFocusEvent *>(&QTextEdit_Adaptor::cbs_focusOutEvent_1729_0, e);
    } else {
      QTextEdit::focusOutEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QTextEdit::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTextEdit_Adaptor, QHideEvent *>(&QTextEdit_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QTextEdit::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QTextEdit::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QTextEdit_Adaptor, QPainter *>(&QTextEdit_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QTextEdit::initPainter(painter);
    }
  }

  //  [adaptor impl] void QTextEdit::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QTextEdit::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTextEdit_Adaptor, QInputMethodEvent *>(&QTextEdit_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QTextEdit::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::insertFromMimeData(const QMimeData *source)
  void cbs_insertFromMimeData_2168_0(const QMimeData *source)
  {
    QTextEdit::insertFromMimeData(source);
  }

  virtual void insertFromMimeData(const QMimeData *source)
  {
    if (cb_insertFromMimeData_2168_0.can_issue()) {
      cb_insertFromMimeData_2168_0.issue<QTextEdit_Adaptor, const QMimeData *>(&QTextEdit_Adaptor::cbs_insertFromMimeData_2168_0, source);
    } else {
      QTextEdit::insertFromMimeData(source);
    }
  }

  //  [adaptor impl] void QTextEdit::keyPressEvent(QKeyEvent *e)
  void cbs_keyPressEvent_1514_0(QKeyEvent *e)
  {
    QTextEdit::keyPressEvent(e);
  }

  virtual void keyPressEvent(QKeyEvent *e)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTextEdit_Adaptor, QKeyEvent *>(&QTextEdit_Adaptor::cbs_keyPressEvent_1514_0, e);
    } else {
      QTextEdit::keyPressEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QTextEdit::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTextEdit_Adaptor, QKeyEvent *>(&QTextEdit_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QTextEdit::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QTextEdit::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTextEdit_Adaptor, QEvent *>(&QTextEdit_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QTextEdit::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QTextEdit::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTextEdit::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTextEdit_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTextEdit_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTextEdit::metric(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::mouseDoubleClickEvent(QMouseEvent *e)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *e)
  {
    QTextEdit::mouseDoubleClickEvent(e);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *e)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTextEdit_Adaptor, QMouseEvent *>(&QTextEdit_Adaptor::cbs_mouseDoubleClickEvent_1738_0, e);
    } else {
      QTextEdit::mouseDoubleClickEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QTextEdit::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTextEdit_Adaptor, QMouseEvent *>(&QTextEdit_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QTextEdit::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QTextEdit::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTextEdit_Adaptor, QMouseEvent *>(&QTextEdit_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QTextEdit::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QTextEdit::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTextEdit_Adaptor, QMouseEvent *>(&QTextEdit_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QTextEdit::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QTextEdit::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTextEdit_Adaptor, QMoveEvent *>(&QTextEdit_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QTextEdit::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QTextEdit::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QTextEdit_Adaptor, bool, const QByteArray &, void *, long int *>(&QTextEdit_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QTextEdit::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QTextEdit::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QTextEdit::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTextEdit_Adaptor, QPaintEvent *>(&QTextEdit_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QTextEdit::paintEvent(e);
    }
  }

  //  [adaptor impl] QPaintDevice *QTextEdit::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QTextEdit::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QTextEdit_Adaptor, QPaintDevice *, QPoint *>(&QTextEdit_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QTextEdit::redirected(offset);
    }
  }

  //  [adaptor impl] void QTextEdit::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QTextEdit::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTextEdit_Adaptor, QResizeEvent *>(&QTextEdit_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QTextEdit::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QTextEdit::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QTextEdit::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QTextEdit_Adaptor, int, int>(&QTextEdit_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QTextEdit::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QPainter *QTextEdit::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QTextEdit::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QTextEdit_Adaptor, QPainter *>(&QTextEdit_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QTextEdit::sharedPainter();
    }
  }

  //  [adaptor impl] void QTextEdit::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QTextEdit::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTextEdit_Adaptor, QShowEvent *>(&QTextEdit_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QTextEdit::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QTextEdit::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTextEdit_Adaptor, QTabletEvent *>(&QTextEdit_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QTextEdit::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextEdit::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QTextEdit::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextEdit_Adaptor, QTimerEvent *>(&QTextEdit_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QTextEdit::timerEvent(e);
    }
  }

  //  [adaptor impl] bool QTextEdit::viewportEvent(QEvent *)
  bool cbs_viewportEvent_1217_0(QEvent *arg1)
  {
    return QTextEdit::viewportEvent(arg1);
  }

  virtual bool viewportEvent(QEvent *arg1)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QTextEdit_Adaptor, bool, QEvent *>(&QTextEdit_Adaptor::cbs_viewportEvent_1217_0, arg1);
    } else {
      return QTextEdit::viewportEvent(arg1);
    }
  }

  //  [adaptor impl] QSize QTextEdit::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QTextEdit::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QTextEdit_Adaptor, QSize>(&QTextEdit_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QTextEdit::viewportSizeHint();
    }
  }

  //  [adaptor impl] void QTextEdit::wheelEvent(QWheelEvent *e)
  void cbs_wheelEvent_1718_0(QWheelEvent *e)
  {
    QTextEdit::wheelEvent(e);
  }

  virtual void wheelEvent(QWheelEvent *e)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTextEdit_Adaptor, QWheelEvent *>(&QTextEdit_Adaptor::cbs_wheelEvent_1718_0, e);
    } else {
      QTextEdit::wheelEvent(e);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_loadResource_2360_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_canInsertFromMimeData_c2168_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_createMimeDataFromSelection_c0_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_doSetTextCursor_2453_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_insertFromMimeData_2168_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QTextEdit_Adaptor::~QTextEdit_Adaptor() { }

//  Constructor QTextEdit::QTextEdit(QWidget *parent) (adaptor class)

static void _init_ctor_QTextEdit_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTextEdit_Adaptor> ();
}

static void _call_ctor_QTextEdit_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QTextEdit_Adaptor *> (new QTextEdit_Adaptor (arg1));
}


//  Constructor QTextEdit::QTextEdit(const QString &text, QWidget *parent) (adaptor class)

static void _init_ctor_QTextEdit_Adaptor_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QTextEdit_Adaptor> ();
}

static void _call_ctor_QTextEdit_Adaptor_3232 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QWidget *arg2 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  ret.write<QTextEdit_Adaptor *> (new QTextEdit_Adaptor (arg1, arg2));
}


// void QTextEdit::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// bool QTextEdit::canInsertFromMimeData(const QMimeData *source)

static void _init_cbs_canInsertFromMimeData_c2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canInsertFromMimeData_c2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_canInsertFromMimeData_c2168_0 (arg1));
}

static void _set_callback_cbs_canInsertFromMimeData_c2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_canInsertFromMimeData_c2168_0 = cb;
}


// void QTextEdit::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTextEdit::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTextEdit::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QTextEdit::contextMenuEvent(QContextMenuEvent *e)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// emitter void QTextEdit::copyAvailable(bool b)

static void _init_emitter_copyAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_copyAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_copyAvailable_864 (arg1);
}


// exposed void QTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_create_2208 (arg1, arg2, arg3);
}


// QMimeData *QTextEdit::createMimeDataFromSelection()

static void _init_cbs_createMimeDataFromSelection_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_createMimeDataFromSelection_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMimeData * > ((QMimeData *)((QTextEdit_Adaptor *)cls)->cbs_createMimeDataFromSelection_c0_0 ());
}

static void _set_callback_cbs_createMimeDataFromSelection_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_createMimeDataFromSelection_c0_0 = cb;
}


// emitter void QTextEdit::currentCharFormatChanged(const QTextCharFormat &format)

static void _init_emitter_currentCharFormatChanged_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentCharFormatChanged_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_currentCharFormatChanged_2814 (arg1);
}


// emitter void QTextEdit::cursorPositionChanged()

static void _init_emitter_cursorPositionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_cursorPositionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_cursorPositionChanged_0 ();
}


// emitter void QTextEdit::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_customContextMenuRequested_1916 (arg1);
}


// void QTextEdit::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QTextEdit::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_destroy_1620 (arg1, arg2);
}


// emitter void QTextEdit::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_destroyed_1302 (arg1);
}


// void QTextEdit::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QTextEdit::doSetTextCursor(const QTextCursor &cursor)

static void _init_cbs_doSetTextCursor_2453_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_doSetTextCursor_2453_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = args.read<const QTextCursor & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_doSetTextCursor_2453_0 (arg1);
}

static void _set_callback_cbs_doSetTextCursor_2453_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_doSetTextCursor_2453_0 = cb;
}


// void QTextEdit::dragEnterEvent(QDragEnterEvent *e)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTextEdit::dragLeaveEvent(QDragLeaveEvent *e)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTextEdit::dragMoveEvent(QDragMoveEvent *e)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QTextEdit::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_drawFrame_1426 (arg1);
}


// void QTextEdit::dropEvent(QDropEvent *e)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QTextEdit::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QTextEdit::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTextEdit::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QTextEdit::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTextEdit::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_focusNextChild_0 ());
}


// bool QTextEdit::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTextEdit::focusOutEvent(QFocusEvent *e)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTextEdit::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_focusPreviousChild_0 ());
}


// bool QTextEdit::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QTextEdit::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTextEdit_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTextEdit::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QTextEdit::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed void QTextEdit::initStyleOption(QStyleOptionFrame *option)

static void _init_fp_initStyleOption_c2356 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2356 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = gsi::arg_reader<QStyleOptionFrame * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_initStyleOption_c2356 (arg1);
}


// void QTextEdit::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery property)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("property");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTextEdit_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QTextEdit::insertFromMimeData(const QMimeData *source)

static void _init_cbs_insertFromMimeData_2168_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("source");
  decl->add_arg<const QMimeData * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_insertFromMimeData_2168_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMimeData *arg1 = args.read<const QMimeData * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_insertFromMimeData_2168_0 (arg1);
}

static void _set_callback_cbs_insertFromMimeData_2168_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_insertFromMimeData_2168_0 = cb;
}


// exposed bool QTextEdit::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_isSignalConnected_c2394 (arg1));
}


// void QTextEdit::keyPressEvent(QKeyEvent *e)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTextEdit::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTextEdit::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// QVariant QTextEdit::loadResource(int type, const QUrl &name)

static void _init_cbs_loadResource_2360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_loadResource_2360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  ret.write<QVariant > ((QVariant)((QTextEdit_Adaptor *)cls)->cbs_loadResource_2360_0 (arg1, arg2));
}

static void _set_callback_cbs_loadResource_2360_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_loadResource_2360_0 = cb;
}


// int QTextEdit::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTextEdit_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QTextEdit::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextEdit_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTextEdit::mouseDoubleClickEvent(QMouseEvent *e)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTextEdit::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTextEdit::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTextEdit::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QTextEdit::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// QPaintEngine *QTextEdit::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTextEdit_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTextEdit::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QTextEdit::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_receivers_c1731 (arg1));
}


// QPaintDevice *QTextEdit::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QTextEdit_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// emitter void QTextEdit::redoAvailable(bool b)

static void _init_emitter_redoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_redoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_redoAvailable_864 (arg1);
}


// void QTextEdit::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QTextEdit::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// emitter void QTextEdit::selectionChanged()

static void _init_emitter_selectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_selectionChanged_0 ();
}


// exposed QObject *QTextEdit::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_sender_c0 ());
}


// exposed int QTextEdit::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_senderSignalIndex_c0 ());
}


// exposed void QTextEdit::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  int arg4 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QTextEdit::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = gsi::arg_reader<const QMargins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_setViewportMargins_2115 (arg1);
}


// void QTextEdit::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QTextEdit::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QTextEdit::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QTextEdit_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QTextEdit::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTextEdit::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextEdit_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QTextEdit::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// emitter void QTextEdit::textChanged()

static void _init_emitter_textChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_textChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_textChanged_0 ();
}


// void QTextEdit::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QTextEdit::undoAvailable(bool b)

static void _init_emitter_undoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_undoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_undoAvailable_864 (arg1);
}


// exposed void QTextEdit::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_updateMicroFocus_0 ();
}


// bool QTextEdit::viewportEvent(QEvent *)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextEdit_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QTextEdit::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QTextEdit_Adaptor *)cls)->fp_QTextEdit_viewportMargins_c0 ());
}


// QSize QTextEdit::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTextEdit_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// void QTextEdit::wheelEvent(QWheelEvent *e)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextEdit_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QTextEdit::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_windowIconChanged_1787 (arg1);
}


// emitter void QTextEdit::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_windowIconTextChanged_2025 (arg1);
}


// emitter void QTextEdit::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTextEdit_Adaptor *)cls)->emitter_QTextEdit_windowTitleChanged_2025 (arg1);
}


// exposed void QTextEdit::zoomInF(float range)

static void _init_fp_zoomInF_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("range");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_zoomInF_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextEdit_Adaptor *)cls)->fp_QTextEdit_zoomInF_970 (arg1);
}


namespace gsi
{

gsi::Class<QTextEdit> &qtdecl_QTextEdit ();

static gsi::Methods methods_QTextEdit_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextEdit::QTextEdit(QWidget *parent)\nThis method creates an object of class QTextEdit.", &_init_ctor_QTextEdit_Adaptor_1315, &_call_ctor_QTextEdit_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextEdit::QTextEdit(const QString &text, QWidget *parent)\nThis method creates an object of class QTextEdit.", &_init_ctor_QTextEdit_Adaptor_3232, &_call_ctor_QTextEdit_Adaptor_3232);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTextEdit::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@hide", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*canInsertFromMimeData", "@brief Virtual method bool QTextEdit::canInsertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canInsertFromMimeData_c2168_0, &_call_cbs_canInsertFromMimeData_c2168_0, &_set_callback_cbs_canInsertFromMimeData_c2168_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTextEdit::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextEdit::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTextEdit::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTextEdit::contextMenuEvent(QContextMenuEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("emit_copyAvailable", "@brief Emitter for signal void QTextEdit::copyAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_copyAvailable_864, &_call_emitter_copyAvailable_864);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QTextEdit::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@hide", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("*createMimeDataFromSelection", "@brief Virtual method QMimeData *QTextEdit::createMimeDataFromSelection()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createMimeDataFromSelection_c0_0, &_call_cbs_createMimeDataFromSelection_c0_0, &_set_callback_cbs_createMimeDataFromSelection_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_currentCharFormatChanged", "@brief Emitter for signal void QTextEdit::currentCharFormatChanged(const QTextCharFormat &format)\nCall this method to emit this signal.", false, &_init_emitter_currentCharFormatChanged_2814, &_call_emitter_currentCharFormatChanged_2814);
  methods += new qt_gsi::GenericMethod ("emit_cursorPositionChanged", "@brief Emitter for signal void QTextEdit::cursorPositionChanged()\nCall this method to emit this signal.", false, &_init_emitter_cursorPositionChanged_0, &_call_emitter_cursorPositionChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTextEdit::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextEdit::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QTextEdit::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTextEdit::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextEdit::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@hide", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*doSetTextCursor", "@brief Virtual method void QTextEdit::doSetTextCursor(const QTextCursor &cursor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doSetTextCursor_2453_0, &_call_cbs_doSetTextCursor_2453_0, &_set_callback_cbs_doSetTextCursor_2453_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTextEdit::dragEnterEvent(QDragEnterEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTextEdit::dragLeaveEvent(QDragLeaveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTextEdit::dragMoveEvent(QDragMoveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QTextEdit::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTextEdit::dropEvent(QDropEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTextEdit::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTextEdit::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QTextEdit::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTextEdit::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTextEdit::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTextEdit::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTextEdit::focusOutEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTextEdit::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QTextEdit::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTextEdit::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTextEdit::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QTextEdit::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Method void QTextEdit::initStyleOption(QStyleOptionFrame *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2356, &_call_fp_initStyleOption_c2356);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTextEdit::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTextEdit::inputMethodQuery(Qt::InputMethodQuery property)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@hide", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*insertFromMimeData", "@brief Virtual method void QTextEdit::insertFromMimeData(const QMimeData *source)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertFromMimeData_2168_0, &_call_cbs_insertFromMimeData_2168_0, &_set_callback_cbs_insertFromMimeData_2168_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTextEdit::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTextEdit::keyPressEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTextEdit::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTextEdit::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@hide", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("loadResource", "@brief Virtual method QVariant QTextEdit::loadResource(int type, const QUrl &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0, &_set_callback_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTextEdit::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTextEdit::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTextEdit::mouseDoubleClickEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTextEdit::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTextEdit::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTextEdit::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTextEdit::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QTextEdit::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTextEdit::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTextEdit::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTextEdit::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QTextEdit::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("emit_redoAvailable", "@brief Emitter for signal void QTextEdit::redoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_redoAvailable_864, &_call_emitter_redoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTextEdit::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QTextEdit::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QTextEdit::selectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_0, &_call_emitter_selectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTextEdit::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTextEdit::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTextEdit::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QTextEdit::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTextEdit::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QTextEdit::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QTextEdit::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTextEdit::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTextEdit::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTextEdit::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("emit_textChanged", "@brief Emitter for signal void QTextEdit::textChanged()\nCall this method to emit this signal.", false, &_init_emitter_textChanged_0, &_call_emitter_textChanged_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextEdit::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_undoAvailable", "@brief Emitter for signal void QTextEdit::undoAvailable(bool b)\nCall this method to emit this signal.", false, &_init_emitter_undoAvailable_864, &_call_emitter_undoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTextEdit::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QTextEdit::viewportEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QTextEdit::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QTextEdit::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTextEdit::wheelEvent(QWheelEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QTextEdit::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QTextEdit::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QTextEdit::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("*zoomInF", "@brief Method void QTextEdit::zoomInF(float range)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_zoomInF_970, &_call_fp_zoomInF_970);
  return methods;
}

gsi::Class<QTextEdit_Adaptor> decl_QTextEdit_Adaptor (qtdecl_QTextEdit (), "QtWidgets", "QTextEdit",
  methods_QTextEdit_Adaptor (),
  "@qt\n@brief Binding of QTextEdit");

}


//  Implementation of the enum wrapper class for QTextEdit::AutoFormattingFlag
namespace qt_gsi
{

static gsi::Enum<QTextEdit::AutoFormattingFlag> decl_QTextEdit_AutoFormattingFlag_Enum ("QtWidgets", "QTextEdit_AutoFormattingFlag",
    gsi::enum_const ("AutoNone", QTextEdit::AutoNone, "@brief Enum constant QTextEdit::AutoNone") +
    gsi::enum_const ("AutoBulletList", QTextEdit::AutoBulletList, "@brief Enum constant QTextEdit::AutoBulletList") +
    gsi::enum_const ("AutoAll", QTextEdit::AutoAll, "@brief Enum constant QTextEdit::AutoAll"),
  "@qt\n@brief This class represents the QTextEdit::AutoFormattingFlag enum");

static gsi::QFlagsClass<QTextEdit::AutoFormattingFlag > decl_QTextEdit_AutoFormattingFlag_Enums ("QtWidgets", "QTextEdit_QFlags_AutoFormattingFlag",
  "@qt\n@brief This class represents the QFlags<QTextEdit::AutoFormattingFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextEdit> inject_QTextEdit_AutoFormattingFlag_Enum_in_parent (decl_QTextEdit_AutoFormattingFlag_Enum.defs ());
static gsi::ClassExt<QTextEdit> decl_QTextEdit_AutoFormattingFlag_Enum_as_child (decl_QTextEdit_AutoFormattingFlag_Enum, "AutoFormattingFlag");
static gsi::ClassExt<QTextEdit> decl_QTextEdit_AutoFormattingFlag_Enums_as_child (decl_QTextEdit_AutoFormattingFlag_Enums, "QFlags_AutoFormattingFlag");

}


//  Implementation of the enum wrapper class for QTextEdit::LineWrapMode
namespace qt_gsi
{

static gsi::Enum<QTextEdit::LineWrapMode> decl_QTextEdit_LineWrapMode_Enum ("QtWidgets", "QTextEdit_LineWrapMode",
    gsi::enum_const ("NoWrap", QTextEdit::NoWrap, "@brief Enum constant QTextEdit::NoWrap") +
    gsi::enum_const ("WidgetWidth", QTextEdit::WidgetWidth, "@brief Enum constant QTextEdit::WidgetWidth") +
    gsi::enum_const ("FixedPixelWidth", QTextEdit::FixedPixelWidth, "@brief Enum constant QTextEdit::FixedPixelWidth") +
    gsi::enum_const ("FixedColumnWidth", QTextEdit::FixedColumnWidth, "@brief Enum constant QTextEdit::FixedColumnWidth"),
  "@qt\n@brief This class represents the QTextEdit::LineWrapMode enum");

static gsi::QFlagsClass<QTextEdit::LineWrapMode > decl_QTextEdit_LineWrapMode_Enums ("QtWidgets", "QTextEdit_QFlags_LineWrapMode",
  "@qt\n@brief This class represents the QFlags<QTextEdit::LineWrapMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextEdit> inject_QTextEdit_LineWrapMode_Enum_in_parent (decl_QTextEdit_LineWrapMode_Enum.defs ());
static gsi::ClassExt<QTextEdit> decl_QTextEdit_LineWrapMode_Enum_as_child (decl_QTextEdit_LineWrapMode_Enum, "LineWrapMode");
static gsi::ClassExt<QTextEdit> decl_QTextEdit_LineWrapMode_Enums_as_child (decl_QTextEdit_LineWrapMode_Enums, "QFlags_LineWrapMode");

}

