package com.univocity.parsers.common.record;

import com.univocity.parsers.common.*;

/**
 * An abstract factory class which allows subclasses to provide implementations of {@link Record}
 *
 * @param <R> the specific type of {@link Record} that is provided
 */
public abstract class AbstractRecordFactory<R extends Record, M extends RecordMetaData> {
	protected final M metaData;

	/**
	 * Creates a new factory of {@link Record} based the state of a parser
	 *
	 * @param context            the parser context
	 */
	public AbstractRecordFactory(Context context) {
		this.metaData = createMetaData(context);
	}

	/**
	 * Creates a new {@link Record} with a row parsed from the input
	 *
	 * @param data the row parsed from the input
	 *
	 * @return a {@link Record} that provides many utility methods for consuming the data collected for a record parsed from the input.
	 */
	public abstract R newRecord(String[] data);

	public abstract M createMetaData(Context context);

	/**
	 * Returns the metadata information associated with the records generated by this factory class
	 *
	 * @return the record metadata.
	 */
	public final M getRecordMetaData() {
		return metaData;
	}
}
