/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.algorithm;

import java.security.NoSuchAlgorithmException;
import jonelo.jacksum.adapt.gnu.crypto.hash.HashFactory;
import jonelo.jacksum.adapt.gnu.crypto.hash.IMessageDigest;
import jonelo.jacksum.algorithm.AbstractChecksum;

public class Edonkey
extends AbstractChecksum {
    private static final String AUX_ALGORITHM = "md4";
    private IMessageDigest md4 = null;
    private IMessageDigest md4final = null;
    private boolean virgin = true;
    private static final int BLOCKSIZE = 9728000;
    private byte[] edonkeyHash = new byte[16];
    private byte[] digest = null;

    public Edonkey() throws NoSuchAlgorithmException {
        this.separator = " ";
        this.encoding = "hex";
        this.md4 = HashFactory.getInstance(AUX_ALGORITHM);
        if (this.md4 == null) {
            throw new NoSuchAlgorithmException("md4 is an unknown algorithm.");
        }
        this.md4final = HashFactory.getInstance(AUX_ALGORITHM);
        this.virgin = true;
    }

    public void reset() {
        this.md4.reset();
        this.md4final.reset();
        this.length = 0L;
        this.virgin = true;
    }

    public void update(byte by) {
        this.md4.update(by);
        ++this.length;
        if (this.length % 9728000L == 0L) {
            System.arraycopy(this.md4.digest(), 0, this.edonkeyHash, 0, 16);
            this.md4final.update(this.edonkeyHash, 0, 16);
            this.md4.reset();
        }
    }

    public void update(int n) {
        this.update((byte)(n & 0xFF));
    }

    public void update(byte[] byArray, int n, int n2) {
        int n3 = (int)(this.length % 9728000L);
        int n4 = 9728000 - n3;
        int n5 = n2 - n;
        if (n4 > n5) {
            this.md4.update(byArray, n, n2);
            this.length += (long)n2;
        } else if (n4 == n5) {
            this.md4.update(byArray, n, n2);
            this.length += (long)n2;
            System.arraycopy(this.md4.digest(), 0, this.edonkeyHash, 0, 16);
            this.md4final.update(this.edonkeyHash, 0, 16);
            this.md4.reset();
        } else if (n4 < n5) {
            this.md4.update(byArray, n, n4);
            this.length += (long)n4;
            System.arraycopy(this.md4.digest(), 0, this.edonkeyHash, 0, 16);
            this.md4final.update(this.edonkeyHash, 0, 16);
            this.md4.reset();
            this.md4.update(byArray, n + n4, n5 - n4);
            this.length += (long)(n5 - n4);
        }
    }

    public String toString() {
        return this.getFormattedValue() + this.separator + (this.isTimestampWanted() ? this.getTimestampFormatted() + this.separator : "") + this.getFilename();
    }

    public byte[] getByteArray() {
        Object object;
        if (this.virgin) {
            if (this.length < 9728000L) {
                System.arraycopy(this.md4.digest(), 0, this.edonkeyHash, 0, 16);
            } else {
                object = (IMessageDigest)this.md4final.clone();
                object.update(this.md4.digest(), 0, 16);
                System.arraycopy(object.digest(), 0, this.edonkeyHash, 0, 16);
            }
            this.virgin = false;
            this.digest = this.edonkeyHash;
        }
        object = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, object, 0, this.digest.length);
        return object;
    }
}

