/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEVIEWER_H
#define FILEVIEWER_H

#include <QtGui>

#include "backend/iointerface.h"
//#include "ifpguiview.h"

class QWidget;
class QDragEnterEvent;
class QDragMoveEvent;
class QDragLeaveEvent;
class QDropEvent;


extern QPixmap *folderLocked;
extern QPixmap *folderClosed;
extern QPixmap *folderOpen;
extern QPixmap *fileNormal;
extern QPixmap *fileMusic;

// /** File 'type'. */
// #define IFP_FILE                1
// /** Dir 'type'. */
// #define IFP_DIR                 2


class FileItem : public QTreeWidgetItem
{
public:
    // name, filetype, fsize
    FileItem(QTreeWidgetItem *parent, const QStringList &fileproperties, IOInterface *Intf)
            : QTreeWidgetItem(parent, fileproperties, IO_INTF_FILE + 1000)
    {
        if (Intf->isAudioFileType(fileproperties[0]))
            setIcon(0, QIcon(QPixmap(*fileMusic)));
        else
            setIcon(0, QIcon(QPixmap(*fileNormal)));

        //openPersistentEditor(this, 0);
    }

    bool operator< ( const QTreeWidgetItem & other ) const
    {
        int sortCol = treeWidget()->sortColumn();
        if (other.type() == type())
            return text(sortCol).toLower() < other.text(sortCol).toLower();
        else
            return(type() > other.type());
    }

};

class DirectoryItem : public QTreeWidgetItem
{
public:
    DirectoryItem(QTreeWidget *parent, const QStringList& dirname, IOInterface *Intf);
    DirectoryItem(DirectoryItem *parent, const QStringList& dirname, IOInterface *Intf);

    QString fullName();
    QString baseName();

    void setOpen(bool);
    void setDirName(const QString&);

    bool operator< ( const QTreeWidgetItem & other ) const
    {
        int sortCol = treeWidget()->sortColumn();
        if (other.type() == type())
            return text(sortCol).toLower() < other.text(sortCol).toLower();
        else
            return(type() > other.type());
    }

private:
    QFile file;
    DirectoryItem *parent_dir;
    bool readable;
    bool showDirsOnly;
    IOInterface *ioIntf;
};

class DirectoryView : public QTreeWidget
{
    Q_OBJECT

public:
    DirectoryView(QWidget *parent = 0, bool sdo = FALSE);
    bool showDirsOnly() {return dirsOnly;}
    QString fullPath(QTreeWidgetItem* item);
    QString baseDirectory(QTreeWidgetItem* item);
    void clearItem(QTreeWidgetItem* item);
    QString currentDirectory(void);

    int msgflag, delmsgflag;
    IOInterface *ioIntf;

public slots:
    void setDir(const QString &);
    void fvUpOneLevel(void);
    void fvCreateDirectory(void);
    void fvRenameFile(void);
    void fvDeleteFile(void);
    void fvProperties(void);
    void fvRefreshFileItem(void);
    void fvTransferSelectedFiles(QString& destDir);
    void setItemExpanded(QTreeWidgetItem * item);

protected slots:
    void openFolder();
    void keyPressEvent(QKeyEvent *);
    void fvItemRenamed(QTreeWidgetItem * item, int col);

protected:
    void dragEnterEvent(QDragEnterEvent *e);
    void dragMoveEvent(QDragMoveEvent *e);
    void dragLeaveEvent(QDragLeaveEvent *e);
    void dropEvent(QDropEvent *e);
    void mouseMoveEvent(QMouseEvent *e);
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);

private:
    void contextMenuEvent(QContextMenuEvent *);
    void unselectAllChildren(QTreeWidgetItem *parentItem);
    int getListOfSelectedItems(QList<FileInfos> *file_info_list);
    void createActions();

    bool dirsOnly;
    QTreeWidgetItem *oldCurrent;
    QTreeWidgetItem *dropItem;
    QTimer* autoopen_timer;
    QPoint presspos;
    bool mousePressed;
    bool yesAll;
    QString OldRenamePath;
    QString OldFileName;
    //QAction *fmPropertiesAct;
    QAction *dvCreateDirectoryAct, *dvRenameFileAct, *dvDeleteFileAct;
    QAction *dvRefreshFileItemAct;

};

//class ifpGUIView;

class fileManagerView : public QWidget
{
    Q_OBJECT
public:
    fileManagerView(QWidget *parent, const QString title = "", bool sort = FALSE, int ioIntfType = 0);
    ~fileManagerView();

    QString currentDirectory(void);
    bool isProcessing();

    //ifpGUIView *ifpGuiViewParent;

public slots:
    void setDir(const QString &);
    void fmCreateDirectory(void);
    void fmRenameFile(void);
    void fmDeleteFile(void);
    void fmRefreshFileItem(void);
    void fmTransferSelectedFiles(QString& destDir);
    int  fmUploadFileList(QString& destination, QList<FileInfos> *file_info_list);

protected slots:
    void upOneLevelClick(void);
    void refreshClick(void);
    void createDirectoryClick(void);
    void propertiesClick(void);
    void renameClick(void);
    void deleteClick(void);


private:
    void createActions();
    void createToolBars();
    void showItemContextMenu(const QPoint &position);

    QGridLayout  *top_layout;
    DirectoryView *internal_fileview;
    //FileViewToolBar *filetoolbar;
    QToolBar *fileToolBar;

    QAction *fmUpOneLevelAct, *fmPropertiesAct;
    QAction *fmCreateDirectoryAct, *fmRenameFileAct, *fmDeleteFileAct;
    QAction *fmRefreshFileItemAct;
    //QAction *fmTransferSelectedFilesAct;

};

#endif
