/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1301, USA.
 */
#ifndef GF_ITEM_H
#define GF_ITEM_H

#define GF_ITEM(obj) ((GfItem *)(obj))

typedef struct _GfItem			GfItem;

typedef enum _GfItemType {
	GF_ITEM_TYPE_ICON = 0,
	GF_ITEM_TYPE_IMAGE,
	GF_ITEM_TYPE_TEXT,
	GF_ITEM_TYPE_UNKNOWN
} GfItemType;

typedef enum _GfItemPosition {
	GF_ITEM_POSITION_NW = 0,
	GF_ITEM_POSITION_N,
	GF_ITEM_POSITION_NE,
	GF_ITEM_POSITION_W,
	GF_ITEM_POSITION_C,
	GF_ITEM_POSITION_E,
	GF_ITEM_POSITION_SW,
	GF_ITEM_POSITION_S,
	GF_ITEM_POSITION_SE,
	GF_ITEM_POSITION_UNKNOWN
} GfItemPosition;

#include <gdk/gdk.h>

#include "gf_event_info.h"
#include "gf_item_icon.h"
#include "gf_item_image.h"
#include "gf_item_offset.h"
#include "gf_item_text.h"
#include "gf_notification.h"

#include "xmlnode.h"

G_BEGIN_DECLS

GfItem *gf_item_new(GfNotification *notification);
GfItem *gf_item_new_from_xmlnode(GfNotification *notification, xmlnode *node);
GfItem *gf_item_copy(GfItem *item);
xmlnode *gf_item_to_xmlnode(GfItem *item);
void gf_item_destroy(GfItem *item);

void gf_item_set_type(GfItem *item, GfItemType type);
GfItemType gf_item_get_type(GfItem *item);
const gchar *gf_item_type_to_string(GfItemType type, gboolean i18n);
GfItemType gf_item_type_from_string(const gchar *string, gboolean i18n);
const gchar *gf_item_position_to_string(GfItemPosition position, gboolean i18n);
GfItemPosition gf_item_position_from_string(const gchar *position, gboolean i18n);
void gf_item_set_notification(GfItem *item, GfNotification *notification);
GfNotification *gf_item_get_notification(GfItem *item);
void gf_item_set_horz_offset(GfItem *item, GfItemOffset *offset);
GfItemOffset *gf_item_get_horz_offset(GfItem *item);
void gf_item_set_vert_offset(GfItem *item, GfItemOffset *offset);
GfItemOffset *gf_item_get_vert_offset(GfItem *item);
void gf_item_set_position(GfItem *item, GfItemPosition position);
GfItemPosition gf_item_get_position(GfItem *item);

void gf_item_set_item_icon(GfItem *item, GfItemIcon *icon);
GfItemIcon *gf_item_get_item_icon(GfItem *item);
void gf_item_set_item_image(GfItem *item, GfItemImage *image);
GfItemImage *gf_item_get_item_image(GfItem *item);
void gf_item_set_item_text(GfItem *item, GfItemText *text);
GfItemText *gf_item_get_item_text(GfItem *item);

void gf_item_get_render_position(gint *x, gint *y, gint width, gint height,
								 gint img_width, gint img_height, GfItem *item);

void gf_item_render(GfItem *item, GdkPixbuf *pixbuf, GfEventInfo *info);

void gf_items_swap(GfItem *item1, GfItem *item2);

G_END_DECLS

#endif /* GF_ITEM_H */
