""" This file is part of the Gudhi Library - https://gudhi.inria.fr/ - which is released under MIT.
    See file LICENSE or go to https://gudhi.inria.fr/licensing/ for full license details.
    Author(s):       Vincent Rouvreau

    Copyright (C) 2016 Inria

    Modification(s):
      - YYYY/MM Author: Description of the modification
"""

import gudhi

__author__ = "Vincent Rouvreau"
__copyright__ = "Copyright (C) 2016 Inria"
__license__ = "MIT"


def test_basic_bottleneck():
    diag1 = [[2.7, 3.7], [9.6, 14.0], [34.2, 34.974], [3.0, float("Inf")]]
    diag2 = [[2.8, 4.45], [9.5, 14.1], [3.2, float("Inf")]]

    assert gudhi.bottleneck_distance(diag1, diag2, 0.1) == 0.8081763781405569
    assert gudhi.bottleneck_distance(diag1, diag2) == 0.75
