/*
    Copyright (C) 2013  Robert Lipe, robertlipe+source@gpsbabel.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

 */
#ifndef HEIGHTGRID_H_INCLUDED_
#define HEIGHTGRID_H_INCLUDED_

/* Created by "./tools/createGeoidGrid 1.0 int8_t" using GeographicLib utility GeoidEval with egm96-5. */

static constexpr double geoid_grid_deg = 1.0;
static constexpr double geoid_scale = 1.0;
static constexpr int geoid_row = 181;
static constexpr int geoid_col = 361;
static constexpr int8_t geoid_delta[geoid_row][geoid_col] = {
  /*           -180,-179,-178,-177,-176,-175,-174,-173,-172,-171,-170,-169,-168,-167,-166,-165,-164,-163,-162,-161,-160,-159,-158,-157,-156,-155,-154,-153,-152,-151,-150,-149,-148,-147,-146,-145,-144,-143,-142,-141,-140,-139,-138,-137,-136,-135,-134,-133,-132,-131,-130,-129,-128,-127,-126,-125,-124,-123,-122,-121,-120,-119,-118,-117,-116,-115,-114,-113,-112,-111,-110,-109,-108,-107,-106,-105,-104,-103,-102,-101,-100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,  97,  98,  99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180 */
  /* -90.0 */ { -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30},
  /* -89.0 */ { -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30},
  /* -88.0 */ { -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -26, -26, -26, -26, -26, -26, -26, -26, -26, -27, -27, -27, -27, -27, -27, -27, -27, -28, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -30, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -30, -30},
  /* -87.0 */ { -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -27, -27, -27, -27, -26, -26, -26, -26, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -24, -24, -24, -25, -25, -25, -25, -25, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -24, -24, -24, -23, -23, -23, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -22, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -20, -20, -20, -20, -20, -20, -20, -20, -20, -21, -21, -21, -21, -21, -21, -22, -22, -22, -22, -22, -22, -22, -22, -22, -23, -23, -23, -23, -23, -23, -24, -24, -24, -24, -24, -24, -25, -25, -25, -25, -25, -26, -26, -26, -26, -27, -27, -27, -27, -28, -28, -28, -28, -28, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -30, -31, -31, -31, -31, -31, -31, -31, -31, -31, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -32, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -33, -32, -32, -32, -32, -32, -32, -32, -32},
  /* -86.0 */ { -33, -33, -34, -34, -34, -34, -34, -34, -34, -34, -35, -35, -35, -35, -35, -35, -35, -36, -36, -36, -36, -36, -36, -37, -37, -37, -37, -37, -37, -37, -37, -37, -36, -36, -35, -35, -34, -34, -33, -33, -32, -32, -32, -32, -32, -32, -32, -33, -33, -34, -34, -34, -34, -34, -34, -33, -33, -32, -32, -31, -31, -31, -31, -31, -31, -32, -32, -32, -32, -32, -32, -32, -31, -31, -30, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -27, -27, -26, -26, -25, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -24, -24, -24, -24, -24, -25, -25, -25, -25, -26, -26, -26, -26, -27, -27, -26, -26, -26, -25, -24, -24, -23, -22, -21, -21, -20, -20, -20, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -15, -16, -16, -16, -16, -16, -17, -17, -17, -17, -17, -18, -18, -18, -18, -19, -19, -19, -19, -20, -20, -20, -20, -21, -21, -21, -22, -22, -22, -23, -23, -23, -23, -24, -24, -24, -24, -25, -25, -25, -26, -26, -27, -27, -27, -28, -28, -28, -29, -29, -29, -30, -30, -30, -31, -31, -31, -32, -32, -32, -32, -32, -33, -33, -33, -33, -33, -33, -34, -34, -34, -34, -34, -34, -34, -34, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -36, -35, -35, -35, -35, -34, -34, -34, -34, -33, -33, -33, -33, -33, -33, -33, -33, -33},
  /* -85.0 */ { -37, -38, -39, -39, -40, -40, -40, -39, -39, -39, -39, -39, -40, -40, -41, -41, -41, -42, -42, -42, -42, -42, -42, -42, -42, -42, -42, -43, -43, -43, -43, -42, -42, -42, -41, -41, -41, -40, -40, -40, -40, -39, -39, -39, -38, -38, -38, -37, -37, -38, -38, -38, -38, -38, -38, -37, -37, -36, -35, -35, -34, -34, -34, -34, -34, -34, -34, -35, -35, -34, -34, -33, -32, -32, -31, -30, -30, -29, -29, -29, -29, -28, -28, -28, -27, -27, -27, -26, -26, -26, -26, -27, -27, -28, -28, -29, -29, -30, -30, -30, -30, -29, -29, -29, -28, -28, -27, -27, -26, -25, -25, -24, -23, -23, -22, -22, -23, -23, -24, -24, -25, -25, -25, -25, -25, -25, -25, -25, -24, -25, -25, -25, -25, -25, -25, -25, -24, -23, -22, -21, -19, -18, -18, -17, -17, -17, -18, -18, -18, -19, -19, -19, -19, -18, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -9, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -13, -13, -14, -14, -14, -15, -15, -16, -16, -16, -17, -17, -18, -18, -19, -19, -20, -20, -20, -21, -21, -21, -22, -22, -22, -23, -23, -24, -24, -24, -25, -25, -26, -26, -26, -27, -28, -28, -29, -29, -30, -30, -31, -32, -32, -32, -33, -33, -34, -34, -34, -35, -35, -35, -35, -35, -35, -35, -36, -36, -36, -36, -36, -36, -36, -36, -37, -37, -37, -37, -36, -36, -36, -36, -36, -37, -37, -37, -37, -37, -37, -37, -36, -36, -36, -35, -35, -36, -36, -37, -37, -38, -38, -38, -37, -37, -36, -35, -35, -34, -34, -35, -36, -37},
  /* -84.0 */ { -44, -45, -45, -45, -45, -45, -45, -45, -44, -44, -44, -44, -45, -45, -45, -45, -44, -44, -44, -44, -44, -44, -44, -44, -45, -45, -45, -45, -44, -44, -44, -44, -43, -43, -43, -43, -42, -42, -42, -41, -41, -41, -41, -41, -41, -40, -40, -40, -40, -40, -39, -39, -39, -39, -39, -39, -39, -38, -38, -38, -37, -37, -36, -36, -36, -36, -36, -35, -35, -34, -34, -33, -32, -32, -31, -31, -30, -30, -30, -30, -30, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -27, -27, -26, -26, -26, -25, -25, -24, -24, -24, -24, -24, -25, -25, -26, -26, -26, -25, -25, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -22, -21, -21, -20, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -19, -19, -19, -19, -18, -18, -18, -18, -17, -17, -17, -16, -16, -16, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -15, -15, -15, -15, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -10,  -9,  -9,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -7,  -7,  -8,  -8,  -9,  -9, -10, -10, -10, -11, -11, -12, -12, -13, -13, -13, -14, -14, -15, -15, -16, -16, -17, -17, -18, -18, -19, -19, -20, -20, -21, -22, -22, -22, -23, -23, -24, -24, -25, -26, -26, -27, -28, -28, -29, -30, -30, -31, -32, -33, -33, -34, -35, -35, -35, -36, -36, -36, -36, -37, -37, -37, -37, -37, -37, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -38, -37, -37, -37, -36, -36, -35, -35, -34, -34, -34, -34, -34, -34, -34, -35, -36, -37, -38, -39, -41, -41, -42, -42, -42, -42, -42, -42, -43, -43, -44},
  /* -83.0 */ { -45, -45, -46, -46, -46, -46, -46, -46, -46, -46, -47, -47, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -46, -45, -45, -44, -44, -44, -44, -44, -44, -44, -43, -43, -43, -43, -42, -42, -42, -42, -42, -42, -42, -41, -41, -41, -41, -41, -40, -40, -40, -39, -39, -38, -38, -38, -37, -37, -36, -36, -35, -35, -34, -33, -32, -32, -31, -31, -30, -30, -29, -29, -29, -29, -30, -30, -30, -30, -30, -30, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -28, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -24, -24, -23, -22, -22, -21, -21, -20, -20, -20, -21, -21, -21, -21, -21, -21, -20, -20, -19, -19, -18, -18, -18, -18, -17, -17, -17, -17, -17, -18, -18, -18, -18, -18, -17, -16, -16, -15, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -11, -11, -11, -10, -10, -10, -11, -11, -11, -11, -10, -10,  -9,  -8,  -6,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -8,  -9,  -9, -10, -10, -11, -11, -12, -12, -13, -14, -15, -15, -16, -17, -18, -18, -19, -20, -20, -21, -22, -22, -23, -23, -24, -25, -25, -26, -27, -28, -28, -29, -30, -31, -31, -32, -32, -33, -34, -34, -35, -36, -37, -37, -38, -39, -39, -39, -39, -39, -39, -39, -40, -40, -41, -41, -41, -41, -41, -41, -40, -40, -40, -40, -40, -40, -40, -39, -39, -38, -37, -37, -36, -36, -36, -37, -38, -38, -39, -39, -40, -40, -41, -41, -42, -42, -43, -44, -44, -44, -45, -45, -45, -45, -45, -45},
  /* -82.0 */ { -48, -48, -48, -48, -48, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -49, -48, -48, -48, -48, -48, -48, -47, -47, -47, -46, -46, -46, -46, -46, -45, -45, -45, -45, -45, -45, -44, -44, -44, -43, -43, -43, -42, -42, -42, -42, -42, -42, -41, -41, -41, -40, -39, -39, -38, -38, -37, -37, -36, -36, -35, -35, -35, -34, -34, -33, -33, -33, -32, -32, -31, -31, -30, -30, -30, -30, -30, -30, -30, -29, -29, -29, -28, -28, -28, -28, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -28, -28, -29, -29, -29, -28, -28, -28, -27, -27, -27, -27, -26, -26, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -25, -24, -24, -23, -23, -23, -23, -24, -24, -24, -23, -22, -21, -20, -20, -20, -20, -19, -19, -19, -18, -17, -17, -17, -17, -17, -17, -17, -16, -15, -14, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,  -0,   0,   1,   1,   1,   1,   1,   1,   0,   0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   1,   1,   0,  -0,  -1,  -1,  -2,  -3,  -3,  -4,  -4,  -5,  -6,  -6,  -7,  -8,  -9, -10, -11, -12, -13, -14, -15, -16, -16, -17, -18, -19, -19, -20, -21, -21, -22, -23, -24, -25, -26, -26, -27, -28, -29, -30, -31, -31, -32, -33, -33, -34, -35, -36, -37, -38, -39, -40, -41, -41, -40, -40, -41, -41, -42, -43, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -44, -43, -43, -42, -41, -40, -40, -41, -42, -44, -45, -45, -46, -46, -46, -47, -47, -47, -47, -47, -47, -47, -48, -48, -48, -48, -48, -48, -48},
  /* -81.0 */ { -50, -50, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -49, -49, -49, -48, -48, -48, -47, -47, -47, -46, -46, -46, -46, -45, -45, -44, -44, -43, -42, -41, -41, -41, -41, -41, -41, -40, -40, -40, -40, -39, -39, -38, -38, -37, -37, -37, -36, -36, -36, -35, -35, -34, -33, -32, -32, -32, -31, -31, -30, -29, -28, -28, -27, -27, -27, -27, -26, -26, -26, -26, -26, -26, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -25, -25, -25, -25, -24, -24, -23, -23, -23, -23, -23, -23, -24, -24, -24, -24, -25, -25, -25, -25, -25, -25, -25, -24, -24, -23, -23, -22, -22, -22, -21, -21, -20, -20, -20, -20, -20, -20, -19, -19, -18, -18, -17, -16, -16, -16, -16, -16, -15, -15, -15, -14, -14, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -1,  -1,  -0,   0,   1,   2,   2,   3,   3,   3,   2,   2,   2,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   5,   5,   6,   6,   5,   5,   5,   5,   4,   4,   4,   4,   3,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,   4,   3,   2,   2,   1,   1,  -0,  -1,  -1,  -1,  -2,  -3,  -4,  -5,  -6,  -8,  -9, -10, -11, -11, -13, -14, -15, -15, -16, -17, -18, -19, -20, -21, -21, -22, -24, -25, -26, -27, -28, -29, -30, -30, -31, -32, -33, -33, -34, -35, -36, -37, -38, -39, -39, -40, -40, -40, -41, -41, -42, -43, -44, -45, -46, -46, -47, -47, -47, -47, -47, -47, -48, -48, -48, -48, -48, -49, -49, -50, -49, -48, -47, -45, -45, -46, -47, -48, -50, -50, -50, -50, -49, -49, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50},
  /* -80.0 */ { -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -52, -52, -53, -53, -53, -53, -53, -53, -53, -52, -52, -52, -52, -52, -53, -53, -52, -52, -52, -51, -51, -51, -51, -50, -50, -49, -49, -49, -48, -48, -48, -47, -47, -47, -46, -46, -45, -44, -42, -42, -41, -41, -41, -41, -41, -40, -40, -40, -39, -39, -38, -38, -38, -38, -38, -38, -38, -38, -38, -37, -36, -35, -34, -33, -33, -32, -31, -30, -29, -28, -27, -26, -26, -25, -25, -24, -23, -23, -22, -22, -23, -23, -23, -22, -22, -22, -22, -23, -24, -25, -25, -25, -24, -24, -23, -23, -23, -23, -23, -22, -22, -21, -21, -21, -21, -21, -20, -20, -20, -21, -21, -21, -22, -22, -22, -22, -22, -21, -21, -20, -19, -18, -17, -17, -17, -17, -18, -18, -18, -18, -18, -17, -17, -17, -17, -18, -19, -19, -18, -17, -16, -15, -15, -15, -15, -15, -15, -14, -14, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -0,   0,   1,   1,   1,   1,   2,   2,   3,   3,   4,   4,   4,   4,   4,   3,   3,   2,   2,   2,   3,   3,   3,   4,   4,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   7,   8,   9,   9,   9,   8,   8,   7,   7,   7,   6,   5,   5,   4,   4,   4,   5,   5,   5,   5,   5,   6,   6,   6,   5,   4,   4,   3,   3,   2,   2,   1,   0,  -0,  -1,  -1,  -2,  -3,  -4,  -6,  -7,  -8, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -27, -28, -29, -30, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -39, -40, -40, -40, -41, -42, -42, -43, -44, -44, -45, -46, -47, -48, -49, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -50, -51, -51, -51, -51, -51, -51, -52, -53, -54, -55, -54, -54, -53, -52, -51, -51, -51, -51, -51, -51, -51, -51, -51, -51, -52, -52, -52, -52, -53},
  /* -79.0 */ { -54, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -55, -54, -54, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -52, -51, -51, -50, -50, -50, -50, -50, -51, -51, -51, -50, -49, -48, -47, -47, -46, -46, -45, -44, -43, -42, -42, -41, -41, -41, -41, -40, -40, -39, -39, -38, -37, -37, -36, -36, -36, -36, -36, -35, -35, -34, -34, -34, -34, -33, -32, -31, -31, -30, -29, -28, -27, -26, -26, -25, -23, -22, -21, -20, -19, -18, -16, -15, -17, -20, -23, -25, -25, -24, -23, -23, -23, -23, -23, -23, -22, -22, -22, -21, -20, -20, -20, -20, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -16, -15, -15, -15, -15, -16, -16, -16, -16, -16, -15, -15, -15, -15, -14, -15, -15, -15, -14, -13, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -1,  -1,  -0,  -0,   0,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   9,   9,  10,  10,  10,  10,   9,   8,   8,   7,   7,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4,   3,   3,   2,   2,   1,   0,  -0,  -1,  -2,  -2,  -3,  -3,  -5,  -7,  -8, -10, -11, -12, -12, -13, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -26, -27, -28, -29, -30, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -41, -41, -42, -42, -43, -44, -44, -45, -46, -47, -48, -49, -50, -51, -51, -52, -52, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -53, -52, -52, -53, -54, -56, -57, -57, -56, -55, -54, -53, -53, -53, -52, -52, -53, -53, -53, -52, -52, -53, -53, -54, -54, -54},
  /* -78.0 */ { -56, -56, -57, -57, -57, -57, -57, -56, -56, -56, -57, -57, -57, -56, -56, -56, -56, -56, -56, -56, -55, -54, -54, -54, -53, -53, -53, -54, -54, -54, -53, -52, -52, -52, -51, -51, -51, -50, -51, -51, -51, -51, -49, -48, -47, -46, -46, -45, -45, -44, -42, -41, -40, -40, -39, -40, -40, -39, -39, -38, -38, -37, -36, -36, -35, -35, -35, -35, -34, -34, -34, -34, -34, -34, -34, -33, -33, -32, -31, -31, -31, -30, -29, -28, -27, -26, -24, -22, -21, -20, -19, -17, -15, -13, -15, -18, -22, -24, -24, -22, -21, -20, -20, -21, -21, -21, -21, -20, -19, -19, -19, -19, -18, -18, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -16, -15, -16, -16, -16, -15, -14, -14, -14, -14, -15, -15, -15, -15, -15, -14, -14, -14, -13, -11, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -6,  -6,  -6,  -5,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -1,  -1,  -2,  -3,  -2,  -2,  -1,  -0,   0,   1,   1,   2,   2,   2,   3,   3,   4,   4,   4,   5,   6,   6,   7,   7,   7,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  11,  10,  10,   9,   9,   9,   9,   8,   8,   7,   7,   6,   6,   6,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   2,   2,   1,   1,  -0,  -1,  -2,  -2,  -2,  -2,  -3,  -4,  -5,  -6,  -8,  -9, -10, -12, -13, -14, -15, -17, -18, -20, -22, -22, -22, -22, -23, -24, -25, -26, -27, -29, -30, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -42, -42, -42, -43, -44, -44, -45, -46, -47, -49, -50, -50, -51, -51, -52, -53, -54, -55, -55, -56, -56, -57, -57, -57, -56, -56, -56, -55, -55, -54, -53, -52, -52, -53, -54, -55, -55, -54, -53, -53, -53, -54, -54, -54, -54, -54, -54, -54, -54, -54, -54, -55, -56, -56},
  /* -77.0 */ { -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -59, -59, -59, -59, -58, -57, -57, -57, -57, -56, -56, -56, -56, -55, -55, -55, -55, -54, -53, -53, -52, -51, -50, -49, -48, -47, -46, -46, -45, -44, -43, -43, -43, -42, -42, -41, -40, -39, -38, -37, -36, -36, -37, -37, -38, -37, -37, -37, -37, -36, -36, -36, -36, -35, -35, -35, -35, -35, -34, -34, -33, -32, -32, -31, -31, -30, -29, -28, -27, -26, -26, -25, -24, -23, -22, -21, -21, -20, -19, -18, -18, -18, -20, -20, -20, -18, -17, -16, -17, -19, -21, -21, -20, -19, -19, -18, -18, -18, -17, -17, -17, -17, -17, -16, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -10,  -9,  -7,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -2,  -1,   0,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   2,   2,   2,   1,   1,   2,   2,   3,   4,   4,   4,   5,   5,   6,   6,   6,   6,   7,   8,   9,   9,  10,  10,  10,  11,  11,  12,  12,  13,  13,  13,  13,  13,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  10,  10,   9,   9,  10,  10,  10,   9,   8,   7,   7,   6,   6,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   2,   2,   2,   1,   1,   0,   0,  -0,  -1,  -2,  -3,  -4,  -5,  -7,  -8,  -9, -10, -12, -14, -16, -18, -19, -19, -19, -19, -20, -20, -21, -22, -24, -26, -27, -29, -30, -32, -33, -34, -35, -36, -37, -38, -39, -40, -41, -42, -42, -42, -42, -44, -45, -45, -46, -48, -49, -50, -50, -50, -51, -52, -53, -54, -55, -56, -56, -57, -57, -58, -58, -57, -57, -57, -56, -56, -55, -55, -54, -53, -52, -53, -54, -55, -55, -55, -55, -55, -55, -55, -56, -57, -57, -56, -55, -55, -56, -56, -57, -57, -57, -58},
  /* -76.0 */ { -60, -60, -60, -60, -60, -60, -59, -59, -59, -59, -59, -59, -59, -59, -59, -60, -61, -62, -62, -62, -63, -63, -63, -63, -63, -63, -61, -60, -58, -57, -56, -55, -54, -54, -53, -52, -50, -49, -48, -47, -45, -44, -43, -43, -42, -41, -41, -40, -41, -41, -40, -38, -37, -36, -36, -36, -36, -36, -37, -37, -37, -36, -36, -36, -36, -35, -33, -32, -32, -32, -32, -32, -31, -30, -30, -29, -28, -28, -27, -27, -26, -26, -25, -25, -24, -23, -23, -22, -22, -22, -21, -20, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -19, -18, -18, -17, -18, -18, -17, -15, -13, -13, -13, -13, -14, -15, -15, -14, -13, -12, -12, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -2,  -1,  -1,  -1,  -1,  -0,   1,   3,   4,   5,   5,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6,   7,   7,   8,   8,   8,   9,   9,  10,  10,  10,  11,  12,  12,  12,  13,  13,  13,  14,  14,  15,  15,  15,  15,  15,  15,  15,  14,  13,  12,  13,  13,  13,  13,  12,  12,  12,  13,  13,  13,  13,  12,  12,  12,  12,  12,  13,  13,  13,  14,  13,  13,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  10,   9,   8,   7,   7,   6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   4,   4,   4,   4,   4,   3,   4,   4,   3,   0,  -2,  -4,  -5,  -5,  -6,  -7,  -8,  -9, -10, -12, -13, -15, -16, -17, -18, -18, -19, -20, -21, -23, -24, -26, -28, -29, -30, -32, -33, -35, -35, -36, -37, -37, -38, -39, -40, -41, -41, -41, -42, -43, -45, -46, -47, -49, -50, -50, -50, -50, -51, -52, -53, -54, -55, -56, -56, -57, -57, -58, -58, -58, -58, -57, -57, -56, -56, -57, -57, -56, -55, -54, -55, -57, -58, -58, -58, -57, -57, -57, -57, -58, -58, -58, -58, -57, -58, -58, -58, -59, -59, -60},
  /* -75.0 */ { -62, -62, -62, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -63, -64, -64, -64, -64, -64, -64, -64, -64, -63, -63, -63, -63, -62, -62, -62, -61, -60, -58, -56, -54, -52, -51, -50, -49, -48, -47, -47, -46, -44, -44, -44, -44, -44, -43, -42, -40, -39, -39, -39, -38, -38, -37, -37, -37, -36, -36, -36, -37, -36, -35, -33, -32, -31, -30, -30, -29, -29, -28, -27, -27, -26, -26, -26, -26, -25, -25, -24, -23, -22, -21, -21, -21, -20, -20, -19, -19, -18, -18, -17, -17, -17, -17, -16, -16, -15, -15, -16, -15, -13, -12, -10,  -9,  -8,  -7,  -6,  -6,  -5,  -5,  -6,  -9, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   0,   2,   3,   4,   5,   6,   8,   9,  10,  10,  10,  11,  11,  11,  11,  11,  11,  10,   9,   9,   9,  10,  11,  11,  11,  11,  12,  13,  13,  13,  14,  14,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  16,  16,  15,  15,  15,  16,  16,  16,  15,  14,  15,  16,  16,  16,  16,  16,  16,  16,  15,  15,  16,  17,  17,  16,  15,  15,  15,  14,  14,  14,  13,  12,  12,  12,  13,  13,  13,  12,  11,  10,   9,   9,   9,   8,   8,   8,   8,   8,   7,   7,   7,   6,   6,   6,   6,   6,   5,   5,   5,   4,   2,  -0,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -11, -12, -14, -15, -16, -17, -18, -19, -21, -23, -25, -26, -27, -29, -30, -31, -32, -33, -34, -35, -36, -36, -37, -37, -38, -39, -41, -42, -42, -43, -43, -45, -46, -48, -48, -48, -48, -49, -50, -51, -51, -52, -53, -54, -55, -55, -56, -57, -57, -57, -58, -58, -58, -58, -58, -58, -58, -58, -59, -58, -56, -54, -54, -55, -57, -58, -58, -58, -58, -58, -59, -59, -59, -59, -59, -59, -59, -59, -60, -61, -62},
  /* -74.0 */ { -61, -62, -63, -63, -64, -65, -65, -65, -65, -66, -66, -65, -65, -65, -65, -65, -65, -65, -65, -65, -65, -64, -64, -64, -63, -63, -63, -63, -62, -62, -61, -61, -60, -59, -59, -58, -58, -57, -56, -55, -53, -51, -50, -49, -49, -49, -49, -47, -45, -43, -43, -43, -41, -40, -39, -39, -38, -38, -37, -37, -37, -37, -38, -38, -38, -36, -35, -33, -32, -31, -31, -30, -30, -29, -28, -28, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -19, -19, -18, -18, -18, -17, -16, -16, -16, -16, -17, -16, -16, -14, -13, -13, -13, -12, -11, -10,  -8,  -7,  -6,  -6,  -5,  -3,  -2,  -1,  -1,  -1,  -2,  -4,  -6,  -7,  -7,  -7,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -2,  -1,  -1,  -0,  -0,  -1,  -1,  -1,  -2,  -2,  -1,  -1,  -0,   1,   1,   2,   2,   3,   3,   3,   4,   5,   6,   7,   7,   8,   9,  10,  11,  13,  14,  14,  13,  13,  12,  11,  11,  12,  13,  14,  14,  15,  15,  16,  16,  16,  17,  17,  18,  18,  18,  18,  19,  19,  19,  19,  19,  18,  18,  18,  18,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  20,  20,  20,  20,  20,  19,  18,  18,  18,  19,  19,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  17,  16,  14,  12,  12,  12,  13,  13,  13,  12,  11,  10,  10,   9,   9,   9,   8,   8,   7,   7,   6,   5,   5,   4,   3,   1,  -0,  -2,  -3,  -4,  -6,  -7,  -8,  -9, -11, -12, -14, -15, -17, -18, -20, -21, -24, -26, -27, -28, -29, -29, -30, -31, -32, -33, -34, -35, -36, -36, -37, -38, -39, -40, -41, -42, -42, -42, -44, -46, -47, -46, -45, -46, -47, -49, -50, -50, -50, -51, -51, -52, -53, -55, -56, -56, -57, -57, -58, -58, -58, -58, -59, -59, -59, -58, -57, -55, -53, -50, -48, -49, -53, -56, -58, -59, -58, -59, -59, -59, -59, -59, -59, -60, -60, -60, -61, -61},
  /* -73.0 */ { -61, -61, -62, -63, -64, -64, -65, -65, -66, -66, -66, -66, -66, -65, -65, -65, -65, -65, -65, -65, -64, -64, -64, -64, -63, -63, -63, -62, -62, -61, -61, -60, -60, -59, -58, -58, -57, -57, -56, -55, -55, -54, -53, -52, -52, -51, -50, -50, -49, -47, -46, -45, -44, -42, -40, -40, -40, -39, -38, -38, -37, -36, -36, -35, -35, -35, -34, -34, -33, -33, -32, -32, -31, -31, -29, -28, -27, -26, -25, -25, -24, -23, -22, -22, -22, -21, -21, -21, -20, -18, -18, -18, -18, -17, -17, -17, -16, -16, -15, -15, -14, -13, -12, -11, -10,  -9,  -8,  -7,  -5,  -3,  -2,  -1,   0,   1,   2,   3,   3,   2,  -1,  -3,  -4,  -4,  -4,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -2,  -2,  -2,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -1,   0,   1,   2,   3,   4,   6,   7,   7,   7,   7,   8,   8,   8,   9,  11,  13,  15,  15,  14,  13,  12,  13,  13,  14,  15,  16,  17,  18,  18,  19,  18,  18,  18,  18,  19,  19,  19,  19,  19,  20,  20,  20,  20,  20,  19,  19,  20,  23,  23,  22,  21,  21,  21,  20,  21,  22,  22,  22,  21,  22,  22,  23,  23,  24,  23,  22,  22,  21,  21,  21,  22,  22,  21,  21,  20,  20,  19,  19,  19,  19,  19,  19,  20,  21,  21,  20,  20,  20,  20,  20,  19,  17,  14,  12,  13,  14,  15,  16,  16,  14,  13,  13,  13,  12,  11,  11,  10,   9,   8,   7,   6,   5,   5,   4,   3,   2,   0,  -0,  -1,  -3,  -5,  -7,  -8,  -9, -11, -13, -15, -17, -18, -20, -22, -24, -27, -28, -29, -28, -29, -30, -31, -31, -32, -33, -33, -34, -35, -36, -37, -38, -39, -40, -40, -38, -39, -41, -43, -43, -43, -43, -45, -46, -48, -50, -49, -49, -49, -50, -51, -52, -53, -54, -55, -56, -57, -57, -57, -58, -58, -58, -59, -58, -58, -56, -55, -54, -52, -51, -51, -52, -55, -58, -58, -57, -57, -58, -58, -58, -58, -59, -60, -61, -61, -61, -61},
  /* -72.0 */ { -62, -62, -62, -62, -63, -64, -65, -66, -66, -66, -66, -65, -65, -65, -65, -65, -64, -64, -64, -64, -63, -63, -63, -63, -62, -62, -62, -61, -61, -60, -60, -59, -59, -59, -58, -57, -56, -56, -55, -54, -54, -53, -52, -52, -51, -51, -50, -49, -48, -47, -46, -45, -45, -44, -44, -43, -42, -41, -40, -39, -38, -37, -35, -34, -33, -33, -33, -33, -32, -32, -31, -31, -30, -30, -29, -28, -27, -26, -25, -24, -23, -23, -22, -21, -21, -22, -22, -22, -20, -18, -17, -17, -17, -16, -15, -15, -15, -14, -13, -13, -12, -12, -11, -10,  -9,  -7,  -6,  -4,  -2,  -0,   2,   2,   3,   4,   6,   7,   7,   6,   3,   1,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,   0,   1,   2,   4,   6,   7,   8,   8,   8,   9,  10,  10,  10,  12,  14,  14,  13,  13,  13,  12,  12,  13,  13,  14,  16,  17,  18,  17,  17,  16,  15,  16,  15,  15,  16,  16,  16,  17,  18,  17,  17,  18,  19,  20,  21,  23,  23,  21,  20,  21,  22,  22,  22,  22,  23,  25,  26,  26,  26,  26,  26,  25,  25,  24,  22,  21,  22,  23,  24,  24,  24,  24,  23,  21,  21,  21,  21,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  20,  18,  16,  14,  13,  13,  13,  13,  14,  15,  15,  15,  15,  15,  14,  13,  13,  12,  11,  10,   9,   8,   6,   5,   5,   4,   3,   2,   1,  -1,  -3,  -5,  -6,  -8,  -9, -11, -12, -14, -16, -17, -19, -20, -22, -24, -26, -27, -27, -28, -29, -30, -31, -32, -32, -32, -32, -33, -34, -35, -36, -37, -38, -37, -37, -38, -39, -40, -40, -41, -42, -43, -45, -48, -50, -51, -51, -50, -50, -51, -52, -52, -53, -54, -55, -56, -57, -57, -57, -58, -57, -57, -57, -56, -54, -53, -55, -56, -57, -56, -55, -55, -56, -55, -53, -54, -56, -58, -58, -58, -59, -60, -61, -61, -62, -62},
  /* -71.0 */ { -61, -61, -62, -63, -64, -65, -65, -65, -64, -65, -66, -65, -64, -64, -64, -64, -63, -63, -63, -63, -62, -62, -62, -61, -61, -61, -61, -60, -60, -59, -59, -58, -58, -57, -57, -56, -56, -55, -54, -53, -53, -52, -51, -51, -50, -49, -48, -47, -47, -46, -45, -44, -43, -43, -42, -42, -41, -40, -40, -40, -39, -39, -38, -38, -37, -36, -36, -35, -34, -34, -33, -32, -32, -30, -28, -27, -27, -26, -25, -24, -24, -23, -22, -22, -22, -21, -20, -18, -17, -17, -16, -15, -14, -14, -14, -14, -14, -13, -12, -11, -11, -10, -10,  -8,  -7,  -6,  -4,  -3,  -1,   0,   3,   4,   5,   7,  10,  11,  11,  10,   8,   5,   4,   3,   2,   1,   1,  -0,  -1,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   3,   5,   7,   8,  10,  11,  11,  11,  11,  11,  11,  10,  11,  11,  11,  13,  13,  13,  12,  13,  13,  14,  14,  14,  13,  12,  12,  11,  11,  11,  12,  13,  14,  15,  16,  16,  16,  18,  20,  22,  22,  22,  22,  21,  20,  20,  21,  22,  22,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  24,  25,  25,  26,  26,  25,  24,  23,  23,  23,  23,  22,  23,  23,  22,  21,  23,  25,  25,  25,  23,  21,  18,  15,  15,  16,  16,  16,  16,  16,  16,  15,  16,  16,  15,  15,  14,  13,  12,  11,  10,   9,   8,   7,   6,   5,   3,   1,  -1,  -2,  -4,  -5,  -6,  -7,  -9, -10, -11, -13, -14, -15, -17, -18, -19, -20, -22, -24, -25, -26, -27, -27, -28, -29, -30, -31, -31, -32, -32, -33, -34, -34, -35, -35, -36, -37, -38, -39, -39, -40, -42, -43, -44, -46, -47, -48, -49, -49, -50, -51, -52, -52, -52, -53, -55, -56, -57, -57, -57, -58, -57, -57, -57, -56, -54, -55, -57, -59, -59, -60, -59, -58, -58, -58, -57, -57, -58, -59, -59, -59, -59, -60, -61, -61, -61, -61},
  /* -70.0 */ { -62, -62, -63, -64, -64, -64, -64, -64, -63, -63, -63, -63, -63, -63, -62, -62, -62, -62, -62, -62, -61, -61, -61, -60, -60, -60, -60, -59, -58, -58, -57, -57, -56, -56, -55, -55, -54, -54, -53, -52, -52, -51, -50, -49, -48, -47, -47, -46, -45, -45, -44, -43, -42, -41, -40, -40, -40, -40, -39, -38, -37, -36, -36, -36, -35, -35, -34, -34, -34, -33, -33, -33, -32, -32, -31, -31, -30, -29, -28, -27, -26, -26, -27, -27, -27, -25, -22, -21, -22, -22, -21, -19, -17, -15, -13, -12, -11, -10, -10, -10, -10,  -9,  -7,  -6,  -4,  -4,  -3,  -2,   0,   2,   4,   5,   7,  10,  12,  13,  13,  11,   8,   6,   5,   4,   4,   4,   2,   1,  -1,  -1,  -1,  -0,   0,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   4,   4,   4,   5,   6,   7,   8,   9,  10,  10,  10,  10,  11,  11,  10,  11,  13,  14,  14,  14,  15,  15,  15,  15,  15,  14,  14,  14,  14,  16,  17,  17,  17,  18,  18,  17,  16,  16,  17,  19,  20,  21,  21,  21,  21,  20,  20,  21,  21,  20,  21,  22,  21,  21,  20,  19,  20,  21,  22,  23,  25,  27,  27,  26,  27,  27,  26,  27,  27,  28,  28,  28,  27,  26,  26,  26,  25,  26,  26,  25,  26,  28,  28,  26,  24,  22,  20,  17,  17,  17,  17,  17,  17,  16,  16,  16,  15,  16,  16,  15,  14,  14,  13,  12,  11,  11,   9,   8,   8,   7,   6,   4,   3,   1,  -1,  -2,  -4,  -6,  -7,  -9, -10, -12, -13, -14, -16, -17, -18, -18, -19, -19, -22, -24, -24, -25, -26, -27, -28, -29, -30, -30, -31, -32, -32, -33, -34, -34, -36, -37, -37, -38, -38, -39, -42, -44, -44, -43, -43, -44, -45, -46, -47, -49, -51, -51, -51, -52, -54, -55, -55, -56, -57, -56, -56, -56, -56, -55, -55, -56, -57, -57, -57, -57, -57, -58, -59, -59, -59, -59, -58, -58, -59, -59, -59, -60, -60, -61, -61, -62},
  /* -69.0 */ { -61, -61, -61, -62, -63, -63, -63, -63, -62, -61, -61, -60, -60, -60, -60, -59, -59, -59, -59, -59, -59, -59, -58, -59, -58, -58, -57, -57, -57, -56, -56, -55, -55, -54, -54, -53, -52, -52, -51, -51, -50, -49, -49, -48, -47, -46, -45, -45, -44, -43, -42, -42, -41, -40, -40, -39, -39, -38, -37, -36, -36, -36, -35, -35, -34, -34, -34, -33, -33, -32, -32, -31, -31, -31, -30, -29, -29, -28, -28, -27, -26, -26, -25, -25, -25, -24, -22, -21, -19, -17, -16, -16, -16, -15, -14, -14, -13, -12, -11,  -9,  -8,  -7,  -7,  -6,  -4,  -3,  -2,   0,   3,   4,   5,   6,   7,   9,  11,  12,  11,   9,   8,   7,   7,   6,   7,   7,   6,   5,   3,   3,   3,   4,   4,   4,   5,   4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   4,   4,   3,   3,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6,   6,   7,   7,   8,   8,   9,  10,   9,   9,   9,   9,  10,  11,  10,  10,  11,  11,  12,  13,  13,  14,  14,  14,  15,  16,  15,  15,  16,  16,  16,  15,  15,  15,  16,  16,  16,  17,  17,  18,  18,  18,  19,  21,  23,  23,  23,  24,  24,  22,  21,  21,  21,  23,  24,  24,  25,  27,  28,  28,  28,  26,  27,  29,  31,  33,  34,  32,  30,  30,  30,  29,  28,  28,  27,  27,  28,  29,  29,  27,  25,  23,  22,  20,  19,  18,  17,  16,  16,  16,  16,  17,  17,  17,  16,  15,  14,  14,  13,  13,  12,  11,  11,  10,   9,   9,   8,   8,   7,   5,   2,   0,  -2,  -5,  -6,  -8, -10, -11, -13, -15, -16, -17, -18, -18, -19, -19, -20, -22, -23, -24, -25, -26, -26, -27, -28, -29, -30, -30, -31, -32, -33, -35, -36, -37, -37, -37, -37, -37, -40, -43, -43, -42, -42, -43, -44, -44, -46, -47, -48, -50, -51, -51, -52, -53, -53, -54, -54, -53, -53, -53, -53, -54, -55, -55, -55, -56, -57, -58, -58, -58, -58, -58, -58, -58, -58, -58, -58, -59, -60, -60, -60, -60, -61, -61},
  /* -68.0 */ { -58, -59, -60, -61, -61, -62, -61, -60, -59, -58, -58, -58, -58, -58, -57, -57, -57, -56, -56, -56, -56, -56, -56, -56, -56, -55, -55, -55, -55, -54, -54, -53, -53, -52, -52, -51, -50, -50, -49, -49, -48, -48, -47, -46, -46, -45, -44, -44, -43, -42, -41, -40, -40, -39, -38, -38, -37, -37, -36, -36, -36, -35, -35, -34, -33, -33, -32, -32, -31, -31, -30, -30, -30, -29, -29, -28, -28, -28, -27, -26, -26, -25, -24, -24, -23, -22, -22, -21, -20, -19, -18, -17, -16, -15, -14, -14, -13, -12, -11, -11, -10,  -9,  -8,  -7,  -5,  -3,  -1,   1,   2,   3,   5,   6,   7,   7,   8,   8,   9,   9,   9,   8,   9,   8,   9,  10,   9,   8,   7,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   7,   7,   8,   8,   8,   9,  10,  10,  10,  10,  11,  11,  11,  12,  12,  12,  13,  13,  14,  14,  15,  16,  15,  14,  15,  15,  15,  14,  14,  15,  15,  15,  15,  15,  16,  16,  16,  16,  17,  17,  18,  19,  22,  23,  23,  23,  24,  25,  25,  25,  25,  25,  24,  25,  26,  26,  27,  29,  30,  32,  35,  36,  37,  38,  38,  36,  34,  34,  34,  32,  31,  30,  30,  30,  29,  28,  27,  27,  25,  24,  23,  21,  20,  19,  18,  17,  17,  17,  18,  17,  16,  15,  15,  14,  13,  13,  12,  10,  10,  11,   9,   9,  10,   9,   7,   6,   4,   2,   1,  -2,  -3,  -5,  -8,  -9, -11, -12, -13, -14, -16, -17, -18, -18, -18, -18, -19, -22, -24, -25, -26, -26, -27, -28, -29, -29, -29, -30, -31, -34, -35, -36, -37, -37, -37, -37, -37, -39, -41, -41, -41, -41, -41, -43, -44, -45, -46, -48, -49, -50, -51, -52, -52, -52, -53, -53, -52, -51, -51, -51, -51, -53, -53, -54, -55, -55, -55, -55, -55, -55, -55, -55, -56, -56, -57, -57, -57, -58, -58, -59, -59, -59, -58},
  /* -67.0 */ { -58, -58, -59, -58, -58, -57, -56, -56, -56, -56, -56, -55, -55, -55, -55, -54, -54, -54, -54, -54, -54, -54, -53, -53, -53, -52, -52, -52, -51, -51, -51, -51, -50, -49, -49, -48, -47, -47, -46, -46, -46, -46, -45, -45, -44, -44, -43, -42, -42, -41, -40, -39, -38, -38, -37, -37, -36, -36, -36, -35, -35, -35, -34, -34, -33, -32, -32, -31, -31, -30, -29, -29, -29, -28, -28, -27, -27, -27, -26, -26, -25, -25, -24, -23, -22, -21, -21, -20, -19, -18, -17, -16, -16, -14, -13, -13, -12, -11, -10, -10,  -9,  -7,  -6,  -5,  -4,  -2,  -1,   2,   4,   5,   6,   8,   9,   9,   9,  10,  11,  12,  12,  11,  11,  11,  12,  12,  13,  12,  10,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,   9,   9,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8,   8,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   9,   9,  10,  10,  11,  11,  11,  11,  12,  13,  13,  13,  14,  15,  15,  15,  16,  16,  16,  16,  16,  16,  15,  16,  16,  16,  16,  16,  15,  15,  16,  16,  17,  17,  18,  18,  18,  18,  20,  22,  22,  22,  23,  23,  23,  24,  25,  26,  26,  26,  26,  27,  29,  31,  32,  33,  34,  36,  39,  41,  41,  39,  35,  33,  32,  31,  30,  30,  29,  28,  27,  26,  26,  24,  23,  24,  25,  25,  24,  22,  20,  19,  18,  18,  18,  17,  16,  16,  16,  15,  14,  14,  12,  10,  10,  10,   9,   8,   8,   6,   4,   3,   1,  -1,  -1,  -2,  -3,  -3,  -6,  -8,  -9, -11, -12, -13, -15, -17, -18, -18, -18, -17, -18, -22, -25, -26, -27, -28, -28, -28, -29, -29, -30, -31, -32, -34, -36, -37, -37, -36, -37, -38, -39, -40, -40, -40, -40, -40, -41, -42, -43, -44, -45, -47, -48, -49, -49, -49, -49, -49, -49, -49, -49, -48, -49, -50, -50, -50, -51, -51, -51, -50, -50, -51, -52, -53, -53, -53, -54, -54, -55, -56, -56, -56, -57, -57, -57, -58, -58},
  /* -66.0 */ { -55, -54, -53, -53, -54, -54, -54, -54, -54, -53, -53, -53, -53, -52, -52, -52, -52, -52, -52, -52, -52, -51, -51, -50, -50, -50, -50, -50, -49, -49, -48, -48, -47, -47, -46, -45, -45, -45, -44, -43, -43, -43, -43, -43, -42, -42, -42, -41, -41, -40, -39, -38, -38, -37, -36, -36, -35, -35, -34, -34, -34, -33, -33, -32, -32, -32, -31, -30, -30, -29, -28, -28, -27, -27, -26, -26, -25, -25, -25, -24, -24, -23, -23, -22, -21, -20, -20, -19, -19, -17, -16, -16, -15, -14, -13, -12, -12, -11, -10,  -8,  -7,  -7,  -5,  -4,  -3,  -2,  -0,   1,   2,   5,   7,   9,  10,  11,  12,  13,  14,  15,  16,  15,  15,  14,  14,  15,  16,  16,  14,  13,  13,  12,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  11,  11,  11,  11,  10,  10,  10,   9,   9,   9,   9,   9,   8,   8,   8,   8,   8,   8,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   9,   9,   9,  10,  10,  11,  11,  12,  13,  14,  15,  15,  15,  15,  15,  15,  16,  16,  17,  17,  18,  19,  18,  18,  18,  17,  17,  17,  18,  18,  18,  17,  17,  18,  18,  18,  19,  19,  20,  19,  19,  22,  23,  23,  23,  23,  23,  24,  24,  25,  25,  26,  27,  27,  28,  29,  30,  30,  31,  33,  34,  35,  37,  36,  34,  32,  31,  30,  28,  27,  26,  25,  25,  25,  25,  24,  24,  24,  23,  22,  21,  20,  20,  19,  18,  17,  15,  15,  15,  16,  16,  15,  14,  13,  12,  12,  10,   9,   8,   7,   5,   3,   1,   0,  -0,  -1,  -3,  -2,  -1,  -2,  -3,  -6,  -8, -10, -12, -14, -14, -15, -15, -16, -18, -19, -21, -22, -23, -24, -25, -25, -26, -27, -28, -29, -30, -31, -32, -33, -35, -36, -36, -37, -37, -38, -39, -39, -40, -41, -42, -42, -42, -42, -43, -44, -45, -45, -45, -46, -46, -46, -45, -46, -47, -49, -48, -47, -47, -47, -47, -47, -48, -48, -48, -48, -49, -49, -49, -50, -51, -52, -52, -52, -53, -54, -54, -55, -55, -55, -55, -55, -55},
  /* -65.0 */ { -52, -51, -51, -52, -51, -51, -51, -51, -51, -51, -51, -50, -50, -50, -50, -50, -49, -49, -49, -49, -49, -49, -48, -48, -48, -47, -47, -47, -46, -46, -46, -45, -45, -44, -44, -43, -43, -42, -42, -42, -42, -42, -41, -41, -41, -41, -40, -40, -39, -39, -38, -37, -37, -36, -35, -35, -34, -33, -33, -33, -32, -32, -31, -31, -31, -30, -30, -30, -29, -28, -28, -27, -26, -26, -26, -25, -25, -24, -24, -23, -23, -22, -22, -21, -20, -20, -18, -17, -17, -16, -15, -15, -14, -13, -12, -11, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -2,  -1,   0,   1,   2,   4,   5,   6,   8,  11,  13,  14,  15,  15,  16,  18,  18,  18,  18,  18,  18,  19,  19,  16,  15,  15,  14,  13,  13,  14,  15,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  13,  12,  13,  12,  12,  12,  11,  11,  11,  10,  10,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  11,  11,  11,  12,  12,  14,  15,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  19,  19,  20,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  20,  20,  21,  21,  21,  20,  21,  23,  24,  24,  25,  26,  26,  26,  27,  28,  28,  28,  28,  29,  30,  30,  31,  30,  30,  30,  31,  31,  30,  30,  30,  29,  29,  28,  27,  27,  27,  27,  27,  26,  25,  25,  25,  24,  23,  22,  21,  20,  20,  20,  19,  18,  18,  16,  15,  14,  14,  14,  13,  12,  11,  10,   8,   7,   6,   5,   4,   4,   3,   3,   1,   0,  -1,  -1,  -2,  -4,  -7,  -8,  -9, -11, -12, -13, -15, -17, -18, -19, -19, -20, -20, -21, -22, -25, -27, -29, -31, -32, -32, -32, -33, -33, -34, -35, -35, -35, -36, -36, -37, -38, -39, -41, -42, -43, -44, -44, -44, -44, -45, -45, -45, -45, -46, -46, -46, -46, -45, -45, -44, -44, -44, -44, -44, -44, -44, -44, -44, -45, -46, -46, -47, -47, -48, -49, -49, -50, -51, -51, -52, -52, -52, -52, -52, -52, -52, -52},
  /* -64.0 */ { -51, -51, -50, -50, -50, -50, -50, -49, -49, -49, -48, -48, -48, -48, -47, -47, -47, -47, -47, -46, -46, -45, -45, -45, -45, -45, -44, -43, -43, -43, -43, -42, -42, -42, -42, -41, -41, -40, -40, -40, -40, -39, -39, -39, -39, -39, -38, -38, -37, -37, -36, -36, -35, -35, -34, -33, -33, -32, -32, -31, -31, -31, -30, -30, -29, -29, -29, -28, -28, -27, -27, -26, -26, -25, -25, -24, -24, -23, -23, -23, -22, -21, -21, -20, -19, -18, -17, -17, -16, -15, -14, -13, -13, -12, -12, -11, -10,  -9,  -8,  -6,  -5,  -4,  -3,  -1,   0,   1,   2,   3,   4,   6,   7,   8,  10,  11,  14,  16,  17,  18,  18,  19,  21,  21,  21,  21,  22,  22,  20,  18,  17,  15,  15,  16,  16,  17,  17,  17,  17,  17,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  14,  14,  14,  13,  13,  12,  12,  12,  12,  11,  11,  11,  11,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  12,  13,  13,  14,  16,  17,  17,  17,  17,  18,  18,  18,  18,  19,  19,  20,  20,  20,  21,  21,  20,  20,  20,  20,  21,  21,  21,  21,  21,  22,  22,  22,  23,  23,  23,  23,  24,  25,  26,  27,  27,  28,  28,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  29,  30,  30,  29,  29,  28,  28,  27,  27,  27,  26,  26,  26,  25,  24,  23,  23,  22,  22,  22,  21,  20,  19,  18,  16,  15,  15,  14,  13,  12,  11,  10,   8,   7,   5,   4,   3,   3,   2,   2,   0,   0,  -0,  -2,  -4,  -8,  -9, -10, -11, -12, -13, -16, -18, -19, -20, -21, -22, -22, -22, -23, -25, -27, -28, -30, -31, -32, -33, -34, -35, -36, -37, -37, -38, -39, -40, -40, -41, -41, -41, -41, -41, -41, -41, -41, -42, -43, -44, -44, -43, -43, -42, -42, -42, -42, -42, -42, -41, -41, -41, -41, -41, -41, -41, -41, -42, -43, -43, -44, -45, -45, -46, -47, -47, -48, -48, -48, -48, -49, -50, -50, -50, -51, -51, -51},
  /* -63.0 */ { -50, -50, -49, -49, -49, -49, -48, -48, -47, -47, -47, -46, -46, -45, -45, -45, -44, -44, -44, -43, -43, -43, -42, -42, -42, -41, -41, -41, -40, -40, -40, -40, -39, -39, -39, -39, -38, -38, -38, -38, -38, -37, -37, -37, -37, -36, -36, -36, -35, -35, -35, -34, -33, -33, -33, -32, -32, -31, -30, -30, -30, -29, -29, -28, -28, -28, -27, -27, -26, -26, -26, -25, -25, -24, -24, -23, -23, -22, -22, -21, -21, -20, -20, -19, -18, -17, -17, -16, -15, -14, -13, -13, -12, -12, -11, -10, -10,  -8,  -7,  -6,  -5,  -4,  -3,  -1,   0,   2,   3,   4,   5,   6,   8,   9,  10,  12,  13,  14,  15,  15,  17,  19,  21,  22,  23,  24,  24,  23,  22,  22,  21,  20,  20,  19,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  16,  16,  15,  15,  14,  14,  14,  13,  13,  13,  12,  12,  12,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  13,  14,  14,  14,  15,  16,  17,  17,  18,  18,  19,  20,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  24,  24,  24,  25,  24,  25,  26,  27,  27,  28,  29,  29,  30,  30,  31,  31,  30,  30,  31,  31,  30,  29,  29,  29,  29,  29,  29,  30,  30,  30,  31,  30,  30,  30,  29,  29,  29,  28,  27,  27,  26,  26,  26,  25,  25,  24,  24,  24,  23,  22,  21,  20,  18,  18,  18,  17,  16,  14,  13,  12,  10,   8,   7,   6,   4,   3,   2,   0,  -1,  -2,  -3,  -4,  -6,  -7,  -8,  -9, -10, -12, -13, -13, -15, -16, -18, -20, -21, -22, -23, -23, -24, -25, -27, -28, -29, -30, -31, -32, -32, -33, -34, -34, -35, -36, -37, -38, -39, -39, -40, -40, -40, -41, -41, -41, -41, -41, -40, -40, -40, -40, -39, -39, -39, -39, -39, -39, -38, -38, -37, -38, -38, -37, -38, -38, -39, -40, -40, -41, -42, -42, -43, -43, -44, -44, -45, -46, -47, -49, -49, -50, -50, -50, -50, -50, -50},
  /* -62.0 */ { -49, -49, -49, -48, -48, -48, -47, -47, -46, -46, -45, -45, -44, -44, -43, -43, -42, -42, -42, -41, -41, -40, -40, -40, -39, -39, -38, -38, -38, -37, -37, -37, -37, -36, -36, -36, -36, -36, -36, -36, -35, -35, -35, -34, -34, -34, -33, -33, -33, -32, -32, -32, -31, -31, -31, -30, -30, -30, -29, -29, -28, -27, -27, -27, -26, -26, -26, -26, -25, -25, -25, -24, -24, -23, -23, -22, -22, -21, -21, -21, -20, -19, -19, -18, -17, -16, -16, -15, -15, -14, -13, -12, -12, -11, -10, -10,  -9,  -8,  -7,  -6,  -5,  -3,  -2,  -1,   1,   2,   3,   4,   6,   7,   8,  10,  12,  13,  14,  15,  15,  14,  14,  15,  18,  21,  22,  22,  22,  23,  23,  22,  21,  20,  20,  20,  20,  21,  22,  23,  22,  22,  21,  19,  19,  19,  20,  20,  20,  20,  19,  20,  19,  20,  19,  19,  19,  19,  18,  18,  18,  17,  16,  16,  16,  15,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  15,  16,  17,  18,  19,  20,  20,  21,  22,  23,  23,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,  26,  26,  26,  26,  27,  27,  28,  29,  30,  30,  31,  32,  32,  32,  32,  32,  32,  31,  31,  31,  31,  31,  31,  30,  30,  31,  31,  31,  31,  31,  31,  31,  30,  30,  30,  29,  28,  28,  28,  28,  27,  27,  26,  26,  25,  25,  24,  23,  22,  22,  22,  21,  21,  20,  19,  17,  15,  13,  12,  10,   9,   7,   6,   4,   2,   1,  -0,  -1,  -2,  -3,  -5,  -6,  -7,  -8,  -9,  -9, -10, -11, -13, -14, -15, -16, -18, -19, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -32, -33, -34, -34, -35, -35, -36, -36, -36, -37, -37, -38, -38, -38, -39, -39, -38, -37, -37, -37, -37, -37, -36, -36, -36, -36, -35, -35, -34, -35, -35, -35, -35, -35, -36, -37, -37, -38, -39, -39, -40, -41, -42, -43, -45, -47, -48, -48, -48, -48, -49, -49, -49, -49, -49, -49},
  /* -61.0 */ { -48, -47, -47, -47, -47, -46, -46, -45, -45, -45, -44, -43, -43, -43, -42, -42, -41, -41, -40, -40, -39, -39, -38, -37, -37, -36, -36, -35, -35, -35, -35, -34, -34, -34, -34, -34, -34, -33, -33, -33, -33, -32, -32, -32, -32, -32, -31, -30, -30, -30, -29, -29, -28, -28, -28, -29, -28, -27, -27, -26, -26, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -23, -22, -22, -21, -21, -21, -20, -20, -19, -18, -18, -17, -17, -16, -15, -15, -14, -14, -13, -12, -12, -11, -10,  -9,  -8,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -0,   1,   2,   3,   5,   7,   8,   9,  11,  12,  14,  15,  17,  17,  18,  18,  18,  17,  16,  15,  16,  21,  23,  24,  24,  22,  21,  21,  21,  21,  23,  25,  26,  26,  24,  21,  18,  20,  20,  21,  22,  21,  22,  22,  22,  22,  22,  22,  22,  21,  19,  17,  17,  17,  16,  17,  18,  18,  18,  17,  17,  16,  16,  16,  16,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  26,  26,  26,  27,  28,  28,  28,  28,  28,  29,  29,  30,  31,  31,  32,  32,  33,  33,  33,  33,  33,  33,  32,  32,  32,  32,  32,  31,  31,  31,  31,  31,  31,  31,  32,  32,  32,  31,  31,  31,  30,  30,  30,  30,  29,  29,  28,  28,  27,  27,  26,  26,  25,  25,  24,  24,  23,  23,  22,  21,  19,  17,  14,  12,  11,   9,   8,   6,   5,   3,   2,   1,   0,  -1,  -2,  -4,  -5,  -6,  -7,  -8,  -8,  -9, -10, -11, -13, -14, -15, -16, -17, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -30, -31, -31, -32, -33, -33, -34, -34, -35, -35, -35, -35, -35, -35, -35, -35, -35, -35, -34, -34, -34, -34, -33, -33, -33, -33, -32, -31, -32, -32, -33, -33, -33, -33, -34, -35, -36, -37, -38, -39, -40, -41, -43, -45, -45, -46, -46, -47, -47, -48, -48, -48, -48, -48, -48, -48},
  /* -60.0 */ { -46, -46, -46, -45, -45, -45, -44, -44, -44, -43, -43, -43, -42, -41, -41, -40, -40, -39, -39, -38, -37, -37, -36, -35, -35, -34, -34, -33, -33, -33, -32, -32, -32, -32, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -29, -29, -29, -28, -28, -27, -27, -27, -27, -26, -26, -25, -25, -24, -24, -24, -24, -23, -23, -23, -23, -23, -23, -23, -23, -23, -23, -22, -21, -21, -20, -20, -20, -19, -18, -18, -17, -16, -16, -15, -14, -14, -14, -13, -12, -12, -11, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -5,  -4,  -4,  -2,  -1,   0,   1,   2,   4,   6,   7,   8,   9,  12,  13,  15,  16,  17,  17,  18,  18,  19,  20,  21,  21,  20,  20,  20,  21,  21,  21,  20,  20,  19,  18,  19,  17,  16,  16,  18,  20,  21,  22,  21,  20,  21,  22,  23,  23,  23,  24,  24,  24,  23,  22,  18,  13,  10,  13,  18,  20,  20,  21,  21,  21,  21,  20,  19,  18,  18,  18,  17,  17,  16,  16,  16,  16,  15,  15,  15,  16,  15,  15,  16,  16,  16,  16,  17,  17,  17,  18,  19,  20,  21,  22,  23,  23,  24,  24,  25,  25,  25,  25,  26,  26,  26,  26,  27,  28,  28,  29,  29,  29,  29,  29,  30,  31,  32,  32,  32,  33,  33,  34,  34,  34,  35,  34,  34,  34,  34,  33,  33,  33,  33,  33,  33,  33,  33,  32,  32,  33,  33,  33,  32,  32,  31,  31,  31,  31,  31,  31,  30,  29,  29,  28,  27,  27,  27,  28,  27,  26,  26,  25,  25,  24,  22,  21,  17,  14,  12,  11,  10,   9,   8,   7,   5,   4,   3,   2,   0,  -1,  -2,  -3,  -4,  -5,  -7,  -7,  -8,  -9, -10, -11, -12, -14, -15, -16, -17, -18, -20, -21, -22, -23, -24, -25, -26, -26, -27, -28, -28, -29, -30, -30, -31, -31, -32, -32, -33, -33, -33, -33, -33, -33, -33, -33, -33, -32, -32, -31, -31, -31, -30, -30, -30, -30, -29, -29, -30, -31, -31, -31, -31, -31, -33, -35, -36, -37, -38, -39, -40, -41, -42, -43, -44, -44, -45, -46, -46, -46, -47, -47, -47, -47, -46, -46},
  /* -59.0 */ { -45, -44, -44, -44, -44, -43, -43, -43, -42, -42, -41, -41, -41, -40, -39, -39, -38, -37, -37, -36, -35, -35, -34, -33, -33, -32, -32, -31, -31, -30, -30, -30, -30, -29, -29, -29, -29, -29, -28, -28, -28, -28, -27, -27, -27, -27, -27, -27, -26, -25, -25, -24, -24, -23, -23, -23, -23, -22, -22, -22, -21, -21, -21, -21, -21, -22, -22, -22, -22, -21, -20, -20, -19, -20, -19, -18, -17, -17, -16, -16, -16, -15, -14, -14, -13, -12, -12, -12, -11, -11, -10,  -9,  -9,  -8,  -7,  -6,  -6,  -5,  -4,  -3,  -2,  -2,  -1,   1,   2,   3,   4,   6,   7,   9,  11,  12,  13,  15,  16,  17,  17,  18,  19,  20,  19,  19,  20,  21,  21,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  20,  20,  19,  20,  20,  21,  20,  21,  21,  22,  22,  23,  23,  24,  24,  24,  23,  22,  20,  15,   9,  15,  18,  20,  21,  21,  21,  21,  21,  21,  21,  20,  20,  20,  20,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  17,  17,  18,  18,  18,  19,  19,  20,  21,  22,  22,  23,  24,  24,  25,  25,  26,  26,  26,  27,  28,  28,  28,  29,  29,  30,  30,  30,  31,  32,  32,  33,  33,  34,  34,  35,  35,  36,  36,  36,  36,  36,  36,  36,  35,  35,  34,  34,  34,  34,  34,  34,  34,  34,  34,  34,  33,  33,  33,  32,  31,  32,  32,  32,  32,  31,  30,  30,  29,  29,  30,  30,  30,  29,  29,  27,  26,  25,  24,  23,  19,  16,  14,  13,  12,  12,  10,   9,   8,   7,   6,   5,   3,   2,   0,  -1,  -2,  -3,  -4,  -6,  -7,  -8,  -8,  -9, -11, -12, -13, -14, -15, -16, -18, -19, -20, -21, -22, -23, -24, -24, -25, -26, -27, -27, -28, -29, -29, -30, -30, -30, -30, -30, -31, -31, -31, -31, -31, -30, -30, -30, -30, -29, -29, -29, -28, -28, -28, -27, -27, -27, -27, -28, -29, -29, -29, -30, -34, -34, -33, -34, -36, -37, -38, -39, -40, -41, -41, -42, -43, -44, -44, -45, -45, -45, -45, -45, -45, -45, -45},
  /* -58.0 */ { -43, -43, -43, -42, -42, -42, -41, -41, -41, -40, -40, -39, -38, -38, -37, -37, -36, -35, -34, -34, -33, -33, -32, -31, -31, -30, -30, -29, -29, -28, -28, -28, -27, -27, -27, -27, -27, -27, -26, -26, -26, -26, -26, -25, -25, -25, -24, -23, -23, -23, -22, -22, -21, -21, -21, -21, -21, -20, -20, -20, -20, -20, -19, -20, -20, -20, -19, -19, -19, -19, -19, -18, -18, -17, -17, -17, -16, -16, -15, -15, -14, -14, -13, -13, -12, -11, -11, -11, -10,  -9,  -8,  -8,  -8,  -7,  -6,  -6,  -5,  -4,  -3,  -2,  -1,  -0,   1,   1,   3,   4,   5,   7,   8,  10,  11,  13,  13,  15,  15,  16,  16,  17,  18,  19,  20,  20,  20,  20,  20,  20,  20,  20,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  19,  19,  20,  20,  20,  20,  21,  21,  22,  22,  23,  24,  24,  24,  23,  22,  20,  15,  10,  15,  18,  20,  20,  20,  19,  19,  19,  19,  19,  19,  19,  19,  19,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  20,  20,  19,  19,  19,  19,  19,  19,  19,  19,  20,  21,  22,  23,  23,  24,  25,  26,  26,  27,  28,  27,  28,  28,  29,  29,  30,  31,  32,  32,  33,  33,  34,  34,  35,  35,  36,  37,  37,  37,  37,  37,  37,  38,  38,  37,  37,  37,  36,  36,  35,  35,  35,  35,  35,  35,  35,  34,  34,  34,  34,  34,  33,  32,  31,  32,  31,  31,  30,  30,  30,  30,  30,  30,  30,  29,  28,  28,  26,  25,  23,  21,  18,  16,  15,  15,  14,  13,  12,  10,   9,   8,   7,   6,   4,   3,   1,  -0,  -1,  -2,  -4,  -5,  -6,  -7,  -8,  -9, -10, -11, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -24, -25, -26, -26, -27, -27, -28, -28, -28, -29, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -27, -27, -27, -26, -26, -26, -26, -26, -26, -26, -26, -27, -27, -28, -28, -32, -32, -28, -31, -32, -34, -35, -36, -37, -38, -39, -39, -41, -41, -42, -42, -42, -42, -42, -42, -43, -43, -43, -43},
  /* -57.0 */ { -40, -40, -40, -40, -39, -39, -39, -39, -39, -38, -37, -37, -36, -36, -35, -35, -34, -33, -33, -32, -31, -31, -30, -30, -29, -28, -28, -27, -27, -27, -26, -26, -26, -25, -25, -25, -25, -25, -25, -24, -23, -23, -22, -22, -22, -22, -22, -21, -21, -21, -20, -20, -20, -20, -19, -19, -18, -18, -19, -19, -19, -18, -18, -17, -17, -17, -17, -17, -17, -16, -16, -16, -16, -16, -16, -15, -15, -14, -13, -13, -13, -12, -12, -12, -11, -11, -11, -10,  -9,  -9,  -9,  -8,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -1,  -0,   1,   2,   3,   4,   5,   6,   6,   7,   8,   8,   9,  12,  14,  13,  14,  15,  16,  17,  18,  19,  20,  20,  20,  20,  19,  18,  19,  19,  18,  18,  18,  19,  19,  18,  19,  18,  18,  18,  19,  19,  20,  20,  20,  21,  21,  21,  22,  23,  23,  23,  23,  22,  20,  16,   8,   9,  16,  19,  20,  20,  20,  20,  20,  21,  21,  21,  21,  22,  22,  23,  23,  24,  24,  24,  25,  24,  23,  23,  23,  23,  22,  22,  22,  22,  21,  20,  20,  19,  20,  20,  20,  20,  21,  22,  23,  25,  25,  26,  27,  28,  28,  29,  29,  29,  29,  30,  30,  31,  32,  32,  33,  34,  34,  35,  36,  36,  37,  38,  39,  39,  39,  39,  39,  39,  39,  39,  39,  39,  38,  38,  37,  37,  36,  36,  36,  36,  36,  36,  35,  35,  35,  35,  35,  35,  35,  35,  35,  34,  35,  34,  34,  34,  32,  31,  31,  30,  29,  29,  28,  26,  23,  20,  19,  18,  17,  16,  16,  15,  13,  12,  11,  10,   9,   8,   6,   5,   4,   2,   1,  -1,  -2,  -3,  -4,  -5,  -7,  -8,  -9, -10, -11, -12, -14, -15, -16, -17, -18, -19, -20, -21, -22, -22, -23, -24, -24, -25, -26, -26, -26, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -25, -25, -25, -24, -24, -24, -24, -24, -24, -24, -25, -25, -25, -26, -26, -30, -30, -27, -30, -29, -31, -33, -34, -35, -36, -36, -37, -38, -38, -39, -39, -40, -40, -40, -40, -40, -40, -40, -40},
  /* -56.0 */ { -37, -37, -38, -37, -37, -37, -37, -36, -36, -35, -35, -34, -34, -33, -33, -32, -32, -31, -30, -30, -30, -29, -28, -27, -27, -27, -26, -26, -25, -25, -24, -24, -24, -24, -23, -23, -23, -23, -22, -21, -21, -20, -20, -20, -20, -20, -20, -20, -20, -19, -19, -19, -18, -19, -18, -17, -17, -16, -15, -15, -14, -14, -14, -14, -14, -14, -14, -15, -14, -14, -14, -15, -14, -14, -14, -14, -14, -13, -12, -12, -12, -11, -11, -11, -11, -11, -11, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -2,  -1,   1,   2,   3,   4,   5,   5,   5,   5,   4,   6,  11,  14,  15,  16,  14,  13,  14,  15,  16,  17,  18,  18,  19,  18,  17,  18,  18,  17,  17,  17,  18,  18,  18,  18,  17,  17,  17,  17,  17,  18,  18,  19,  19,  19,  19,  20,  21,  21,  21,  21,  21,  21,  21,  17,   5,   5,  15,  19,  20,  20,  21,  20,  20,  20,  21,  21,  22,  22,  22,  23,  23,  24,  24,  25,  26,  25,  25,  25,  25,  25,  24,  24,  24,  24,  24,  24,  23,  22,  22,  22,  22,  22,  22,  23,  24,  25,  26,  27,  28,  29,  29,  30,  31,  31,  31,  31,  32,  31,  32,  33,  34,  35,  35,  36,  37,  37,  38,  39,  40,  41,  41,  41,  42,  41,  41,  41,  41,  41,  41,  40,  40,  39,  39,  39,  38,  38,  37,  37,  37,  36,  36,  35,  35,  35,  35,  36,  36,  35,  34,  34,  33,  33,  33,  33,  32,  31,  31,  30,  29,  27,  24,  22,  20,  19,  19,  18,  17,  16,  15,  14,  13,  12,  10,   9,   8,   7,   5,   4,   3,   1,   0,  -1,  -2,  -4,  -5,  -6,  -7,  -9, -10, -11, -12, -13, -15, -16, -17, -18, -19, -20, -21, -21, -22, -23, -23, -24, -25, -25, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -25, -24, -23, -23, -23, -22, -22, -22, -23, -23, -23, -23, -24, -24, -24, -24, -25, -25, -26, -27, -28, -28, -29, -31, -32, -32, -31, -32, -33, -34, -35, -36, -37, -37, -37, -37, -37, -37, -37, -37, -37},
  /* -55.0 */ { -34, -35, -35, -35, -35, -34, -34, -34, -33, -33, -32, -32, -31, -31, -31, -30, -30, -30, -29, -28, -27, -27, -26, -26, -25, -25, -24, -24, -24, -23, -23, -23, -23, -23, -23, -22, -21, -21, -20, -20, -20, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -17, -16, -16, -15, -15, -14, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -11, -11, -10, -10, -10, -10, -10, -10, -10,  -8,  -7,  -6,  -5,  -5,  -5,  -4,  -3,  -3,  -2,  -1,   1,   2,   3,   4,   5,   5,   3,   3,   7,  10,  11,  13,  14,  14,  14,  14,  12,  11,  12,  13,  15,  17,  17,  18,  18,  17,  15,  14,  14,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  17,  16,  17,  19,  21,  23,  21,  17,  11,  12,  10,   8,   7,   4,   3,   8,  15,  18,  20,  21,  20,  20,  21,  21,  21,  22,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  27,  27,  27,  27,  26,  26,  26,  26,  26,  26,  26,  25,  25,  24,  24,  24,  25,  26,  27,  28,  29,  30,  31,  32,  32,  33,  33,  33,  34,  33,  33,  34,  34,  35,  35,  36,  37,  38,  39,  40,  41,  43,  44,  44,  45,  45,  44,  44,  44,  44,  44,  43,  42,  41,  41,  41,  41,  40,  39,  39,  38,  38,  37,  37,  36,  36,  35,  35,  35,  35,  34,  35,  35,  35,  35,  34,  34,  34,  33,  33,  32,  30,  28,  25,  23,  21,  20,  19,  19,  18,  17,  15,  14,  13,  12,  10,   9,   8,   7,   5,   4,   2,   2,   0,  -1,  -2,  -3,  -5,  -6,  -7,  -9, -10, -11, -12, -13, -15, -16, -17, -18, -19, -20, -20, -21, -22, -22, -23, -24, -24, -25, -25, -25, -25, -25, -25, -25, -25, -24, -25, -24, -24, -24, -24, -23, -23, -22, -22, -21, -21, -21, -21, -21, -22, -22, -22, -22, -22, -22, -22, -23, -23, -23, -22, -23, -26, -26, -27, -27, -28, -27, -26, -25, -26, -28, -30, -32, -33, -34, -34, -33, -33, -33, -34, -34, -34},
  /* -54.0 */ { -31, -32, -32, -31, -31, -31, -31, -31, -31, -30, -30, -29, -29, -29, -28, -28, -28, -27, -27, -26, -26, -25, -25, -24, -24, -23, -23, -23, -23, -23, -23, -22, -21, -21, -21, -20, -20, -20, -19, -19, -18, -18, -18, -18, -17, -17, -18, -19, -19, -18, -18, -17, -16, -15, -15, -14, -14, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -12, -12, -12, -12, -12, -11, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -2,  -1,   0,   2,   3,   4,   5,   5,   4,   4,   9,  12,  10,   9,  10,  12,  12,  12,  12,  11,  10,   9,  10,  11,  10,  10,  10,   9,   7,   7,   9,  12,  13,  12,  11,  11,  12,  14,  14,  14,  13,  14,  16,  16,  15,  17,  18,  18,  17,  12,  12,  13,  13,  13,  14,  14,  13,  14,  15,  17,  19,  21,  21,  21,  21,  21,  22,  22,  22,  23,  23,  23,  24,  25,  25,  25,  26,  26,  27,  27,  27,  28,  28,  28,  27,  27,  27,  27,  28,  28,  27,  27,  26,  26,  27,  27,  28,  28,  28,  29,  29,  31,  31,  32,  33,  34,  35,  36,  36,  36,  37,  34,  35,  36,  36,  36,  37,  38,  39,  40,  41,  43,  44,  45,  47,  47,  47,  47,  46,  45,  45,  44,  45,  43,  43,  44,  45,  43,  41,  41,  40,  39,  38,  38,  38,  37,  36,  36,  35,  34,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  34,  33,  31,  27,  24,  23,  24,  22,  20,  20,  18,  17,  16,  14,  13,  12,  11,   9,   8,   7,   6,   4,   3,   1,   0,  -1,  -2,  -4,  -5,  -6,  -7,  -9, -10, -11, -12, -14, -15, -16, -17, -18, -19, -20, -20, -21, -22, -22, -23, -23, -24, -24, -25, -24, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -22, -22, -22, -21, -20, -20, -20, -20, -19, -21, -21, -21, -21, -21, -21, -21, -21, -22, -22, -22, -22, -19, -23, -22, -23, -23, -24, -22, -22, -22, -22, -23, -24, -24, -26, -28, -29, -30, -30, -31, -31, -31, -31},
  /* -53.0 */ { -28, -28, -29, -28, -29, -29, -28, -28, -28, -28, -27, -27, -26, -26, -26, -26, -25, -25, -25, -24, -24, -23, -23, -22, -22, -23, -23, -22, -21, -21, -21, -20, -20, -20, -20, -19, -19, -19, -18, -18, -18, -18, -18, -19, -20, -20, -20, -19, -18, -17, -17, -16, -16, -15, -14, -14, -13, -13, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -10, -10,  -9,  -9,  -8,  -8,  -8,  -8,  -8,  -7,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,   0,   1,   2,   3,   4,   5,   5,   5,   9,  11,  10,  10,   9,   9,  11,  12,  12,  12,  13,  13,  12,  12,  11,  11,  11,  10,  10,   8,   6,   5,   5,   6,   7,   6,   4,   6,   8,   6,   4,   4,   6,   6,   4,   3,   3,   5,  10,  11,  12,  13,  15,  15,  16,  16,  16,  16,  16,  16,  17,  19,  19,  20,  20,  21,  21,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  27,  27,  28,  28,  28,  28,  27,  27,  27,  27,  27,  27,  26,  26,  26,  27,  27,  27,  28,  29,  30,  31,  32,  32,  33,  34,  35,  35,  36,  36,  37,  38,  38,  38,  37,  36,  37,  37,  37,  38,  39,  40,  41,  42,  44,  45,  46,  47,  48,  48,  48,  51,  50,  47,  46,  47,  45,  44,  45,  43,  43,  42,  41,  41,  41,  39,  38,  37,  37,  36,  35,  35,  35,  35,  35,  35,  34,  34,  35,  37,  40,  39,  37,  35,  34,  32,  30,  28,  26,  24,  23,  22,  20,  19,  17,  16,  15,  13,  12,  11,   9,   8,   7,   5,   4,   3,   1,  -0,  -1,  -3,  -4,  -5,  -6,  -8,  -9, -10, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -21, -21, -22, -23, -23, -24, -24, -24, -24, -24, -23, -23, -23, -23, -23, -22, -22, -22, -22, -21, -21, -20, -20, -19, -19, -19, -19, -19, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -20, -17, -19, -19, -20, -21, -20, -19, -19, -19, -18, -18, -19, -20, -21, -23, -26, -27, -27, -28, -28, -28},
  /* -52.0 */ { -25, -25, -25, -26, -26, -26, -26, -25, -25, -24, -24, -24, -24, -24, -23, -23, -23, -23, -22, -22, -21, -21, -21, -22, -22, -21, -20, -20, -20, -20, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -19, -20, -19, -19, -19, -19, -18, -18, -17, -17, -16, -15, -15, -14, -13, -13, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -5,  -5,  -4,  -3,  -2,  -1,  -0,   1,   2,   3,   4,   5,   5,   5,   7,  13,  13,  13,  11,  10,   9,  10,  10,  10,  11,  12,  13,  14,  14,  14,  12,  12,  12,  12,  11,  10,   9,   8,   7,   6,   6,   6,   5,   4,   4,   5,   5,   5,   5,   5,   6,   7,   8,  10,  11,  10,  13,  15,  15,  15,  16,  15,  15,  15,  18,  17,  18,  19,  19,  20,  20,  21,  22,  22,  23,  24,  24,  25,  25,  26,  26,  27,  27,  27,  28,  28,  28,  27,  27,  27,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  27,  29,  30,  31,  31,  33,  33,  34,  35,  35,  36,  36,  36,  36,  37,  37,  37,  38,  37,  36,  39,  39,  38,  39,  40,  41,  43,  44,  45,  46,  47,  49,  49,  47,  47,  47,  47,  47,  46,  45,  44,  44,  43,  43,  43,  42,  42,  41,  40,  39,  38,  37,  37,  36,  36,  36,  35,  35,  35,  34,  35,  37,  38,  38,  38,  37,  36,  33,  30,  29,  28,  27,  25,  23,  22,  21,  19,  18,  16,  15,  14,  12,  11,   9,   8,   6,   5,   4,   2,   1,  -1,  -2,  -3,  -5,  -6,  -7,  -8, -10, -11, -12, -13, -14, -16, -17, -18, -19, -19, -20, -21, -21, -22, -22, -23, -23, -24, -24, -24, -23, -23, -23, -22, -22, -22, -22, -21, -21, -21, -20, -20, -20, -19, -19, -19, -18, -18, -18, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -15, -16, -17, -17, -18, -18, -15, -16, -16, -15, -16, -16, -17, -17, -19, -21, -23, -24, -24, -24, -25},
  /* -51.0 */ { -21, -21, -21, -21, -22, -23, -23, -22, -22, -21, -21, -21, -21, -21, -21, -21, -21, -21, -20, -20, -20, -20, -21, -20, -20, -20, -19, -19, -19, -18, -18, -18, -17, -17, -17, -18, -18, -17, -17, -18, -19, -18, -18, -18, -18, -18, -18, -18, -18, -17, -16, -15, -15, -14, -13, -13, -12, -12, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -2,  -1,  -0,   1,   2,   2,   3,   5,   5,   5,   5,   9,  14,  15,  15,  13,  11,  10,  10,  10,  10,  11,  12,  13,  13,  12,  12,  13,  13,  13,  12,  11,  10,  10,   9,   7,   6,   6,   6,   6,   5,   6,   6,   8,   9,   8,   7,   6,   6,   7,   7,   8,   8,  10,  10,  11,  12,  12,  13,  13,  15,  16,  17,  17,  18,  19,  20,  20,  21,  22,  23,  23,  24,  25,  25,  26,  26,  26,  27,  27,  28,  28,  27,  27,  27,  27,  27,  26,  26,  25,  25,  25,  25,  25,  25,  26,  26,  27,  27,  27,  29,  31,  31,  32,  32,  33,  34,  34,  34,  35,  35,  36,  36,  37,  37,  38,  36,  38,  40,  40,  39,  40,  41,  42,  43,  44,  46,  46,  46,  47,  46,  47,  46,  46,  46,  45,  45,  44,  44,  44,  44,  43,  43,  41,  41,  40,  39,  38,  38,  37,  37,  36,  36,  37,  37,  36,  35,  38,  39,  38,  38,  37,  36,  33,  31,  30,  29,  28,  27,  25,  24,  22,  20,  19,  18,  16,  15,  13,  12,  11,   9,   8,   6,   5,   3,   2,   0,  -1,  -3,  -4,  -5,  -7,  -8,  -9, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -21, -21, -22, -23, -23, -23, -24, -24, -24, -23, -23, -23, -22, -22, -21, -21, -21, -20, -20, -20, -19, -19, -19, -19, -18, -18, -18, -17, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -16, -15, -14, -12, -12, -14, -14, -11, -12, -12, -12, -13, -13, -14, -14, -15, -16, -18, -20, -20, -21, -21},
  /* -50.0 */ { -17, -17, -17, -15, -17, -19, -20, -19, -19, -19, -19, -19, -19, -19, -19, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -18, -17, -17, -16, -16, -16, -16, -16, -17, -17, -16, -17, -18, -18, -18, -17, -17, -17, -18, -18, -18, -18, -17, -17, -17, -16, -15, -14, -14, -13, -12, -12, -12, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -1,  -0,   0,   1,   2,   3,   4,   5,   6,   5,   6,  10,  13,  16,  16,  14,  13,  11,  10,  10,  11,  11,  11,  12,  13,  13,  13,  12,  12,  11,  11,   9,   8,   6,   4,   3,   3,   2,   2,   2,   2,   2,   3,   5,   6,   6,   6,   3,   3,   3,   4,   5,   6,   7,   8,   9,  10,  11,  11,  12,  14,  15,  16,  17,  18,  19,  20,  20,  21,  22,  23,  23,  25,  25,  26,  26,  27,  27,  27,  27,  27,  27,  27,  26,  26,  26,  25,  25,  25,  25,  24,  25,  25,  24,  25,  24,  25,  25,  26,  26,  27,  28,  30,  31,  31,  32,  33,  33,  34,  34,  35,  35,  35,  36,  37,  37,  38,  38,  40,  40,  40,  41,  41,  42,  43,  43,  44,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  44,  44,  44,  43,  43,  42,  41,  40,  39,  38,  37,  37,  36,  39,  40,  39,  37,  39,  41,  40,  37,  37,  36,  35,  33,  32,  31,  30,  29,  27,  26,  24,  23,  22,  20,  19,  17,  16,  14,  13,  11,  10,   9,   7,   6,   4,   2,   1,  -1,  -2,  -4,  -5,  -6,  -8,  -9, -10, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -21, -22, -22, -23, -23, -23, -24, -24, -24, -24, -23, -23, -23, -22, -22, -22, -21, -20, -20, -19, -19, -18, -18, -19, -18, -18, -17, -17, -17, -18, -18, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -15, -14, -13, -13, -11, -10, -12, -10,  -9, -10, -10, -10, -10, -10, -10, -11, -12, -13, -13, -14, -15, -17},
  /* -49.0 */ { -10, -12, -14, -15, -16, -16, -16, -16, -17, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -16, -17, -16, -16, -15, -15, -15, -15, -15, -15, -16, -16, -15, -16, -16, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -16, -16, -15, -15, -14, -13, -13, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -9, -10, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -1,  -1,   0,   1,   2,   3,   3,   4,   5,   6,   6,   6,  10,  15,  16,  17,  16,  15,  13,  12,  12,  11,  11,  11,  11,  12,  11,  11,  11,  10,  10,   9,   7,   6,   3,   1,  -0,  -1,  -1,  -1,  -1,  -1,  -1,   0,   1,   1,   2,   2,   1,   1,   2,   3,   3,   4,   4,   6,   6,   7,   8,   9,  12,  13,  14,  15,  16,  17,  19,  20,  21,  21,  23,  23,  24,  25,  26,  27,  27,  27,  28,  27,  27,  26,  26,  25,  25,  25,  24,  24,  24,  24,  23,  24,  24,  25,  24,  24,  25,  23,  25,  26,  27,  28,  28,  29,  30,  30,  31,  32,  33,  33,  33,  34,  34,  34,  35,  35,  37,  38,  39,  40,  42,  42,  42,  42,  43,  43,  42,  43,  44,  44,  45,  44,  44,  44,  45,  45,  45,  45,  45,  45,  45,  44,  44,  43,  42,  41,  41,  40,  39,  38,  38,  38,  37,  37,  38,  39,  41,  41,  40,  38,  36,  34,  33,  32,  31,  30,  29,  28,  26,  25,  24,  22,  21,  20,  18,  17,  15,  14,  12,  11,   9,   8,   6,   5,   3,   2,   0,  -2,  -3,  -5,  -6,  -8,  -9, -10, -12, -13, -14, -15, -17, -18, -19, -19, -20, -21, -22, -22, -23, -23, -23, -24, -24, -24, -24, -24, -24, -24, -23, -23, -22, -22, -21, -21, -20, -20, -19, -18, -18, -17, -18, -18, -17, -17, -17, -17, -17, -17, -16, -16, -14, -15, -16, -16, -16, -16, -16, -15, -15, -14, -12, -12, -11, -10, -11,  -8,  -9,  -6,  -7,  -8,  -8,  -8,  -7,  -7,  -7,  -7,  -8,  -9,  -9,  -9, -10},
  /* -48.0 */ {  -5,  -8, -11, -12, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -14, -13, -14, -14, -14, -14, -14, -15, -15, -16, -16, -16, -16, -17, -17, -17, -17, -17, -17, -17, -16, -16, -15, -15, -15, -14, -14, -13, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -9, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -2,  -2,  -1,  -1,  -0,   1,   2,   2,   3,   4,   5,   6,   7,   7,   7,  11,  15,  16,  17,  18,  16,  15,  14,  12,  11,  11,  11,  11,  11,  11,  11,  10,   8,   7,   5,   4,   2,   1,  -0,  -1,  -2,  -2,  -2,  -3,  -3,  -3,  -2,  -1,  -1,  -1,  -1,  -0,  -0,   0,   1,   2,   2,   3,   4,   6,   7,   8,  10,  11,  13,  14,  15,  16,  18,  19,  20,  21,  22,  23,  24,  25,  26,  26,  27,  28,  28,  28,  27,  27,  26,  25,  25,  24,  24,  24,  24,  23,  23,  23,  22,  23,  23,  24,  24,  26,  25,  26,  26,  26,  27,  28,  29,  30,  30,  31,  32,  32,  32,  32,  33,  33,  33,  34,  34,  35,  37,  39,  40,  41,  44,  44,  44,  43,  43,  43,  43,  44,  44,  44,  43,  44,  44,  45,  45,  45,  45,  45,  45,  45,  44,  44,  43,  43,  42,  41,  40,  38,  38,  37,  36,  36,  36,  39,  39,  40,  40,  39,  37,  35,  33,  32,  31,  30,  29,  28,  27,  25,  24,  23,  22,  20,  19,  17,  16,  15,  13,  11,  10,   8,   7,   5,   4,   2,   1,  -1,  -3,  -4,  -6,  -7,  -9, -10, -12, -13, -14, -16, -17, -18, -19, -20, -21, -22, -22, -23, -24, -24, -24, -24, -25, -25, -25, -25, -25, -24, -24, -24, -23, -23, -22, -22, -21, -20, -20, -19, -18, -18, -17, -18, -17, -17, -17, -16, -16, -16, -15, -14, -14, -14, -15, -15, -15, -15, -15, -15, -14, -14, -13, -11, -10,  -9,  -8, -11, -10,  -6,  -3,  -4,  -5,  -5,  -6,  -5,  -5,  -5,  -5,  -6,  -5,  -5,  -4,  -5},
  /* -47.0 */ {  -5,  -7,  -8,  -8,  -9,  -9, -10, -10, -10, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -14, -14, -14, -14, -15, -15, -15, -16, -16, -17, -17, -17, -16, -16, -16, -16, -16, -15, -15, -14, -14, -14, -13, -13, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,  -0,   0,   1,   1,   2,   3,   4,   5,   6,   7,   8,   9,   9,  10,  13,  18,  20,  20,  17,  16,  14,  13,  12,  12,  12,  11,  12,  11,  11,   9,   7,   6,   4,   2,   0,  -1,  -1,  -2,  -3,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,   0,   2,   3,   4,   6,   7,   9,  11,  12,  14,  15,  16,  17,  19,  20,  21,  23,  23,  25,  26,  26,  27,  28,  27,  27,  27,  27,  27,  25,  25,  24,  24,  24,  23,  23,  23,  22,  22,  22,  22,  23,  24,  25,  26,  25,  26,  26,  26,  27,  27,  28,  29,  30,  31,  31,  32,  32,  33,  33,  33,  33,  33,  34,  34,  35,  37,  40,  41,  43,  45,  45,  45,  44,  46,  43,  45,  44,  43,  43,  44,  45,  46,  46,  45,  45,  46,  48,  48,  45,  44,  43,  42,  41,  40,  39,  38,  37,  36,  35,  34,  34,  36,  38,  37,  36,  36,  35,  33,  32,  31,  30,  29,  28,  26,  25,  24,  23,  22,  20,  19,  18,  16,  15,  13,  12,  10,   9,   7,   6,   4,   2,   1,  -1,  -2,  -4,  -6,  -7,  -9, -10, -12, -13, -15, -16, -17, -19, -20, -21, -21, -22, -23, -24, -25, -25, -25, -25, -25, -26, -26, -26, -25, -25, -25, -25, -24, -24, -23, -23, -22, -21, -20, -20, -19, -18, -17, -17, -18, -17, -17, -17, -16, -16, -15, -13, -12, -13, -14, -14, -14, -14, -13, -13, -13, -12, -12, -11, -11,  -9,  -7,  -7,  -7,  -8,  -4,  -2,   1,   1,  -1,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -4,  -5},
  /* -46.0 */ {  -2,  -3,  -4,  -4,  -4,  -5,  -5,  -6,  -7,  -8,  -9,  -9, -10, -10, -10, -10, -11, -10, -10, -10, -10, -10, -10, -10,  -9, -10, -10, -11, -11, -12, -12, -13, -13, -14, -14, -14, -15, -15, -15, -16, -16, -16, -16, -16, -16, -16, -15, -15, -15, -15, -14, -14, -13, -13, -13, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -1,  -0,   0,   1,   2,   2,   4,   5,   5,   7,   8,   9,  10,  11,  11,  15,  18,  23,  23,  19,  16,  15,  14,  13,  12,  12,  12,  12,  11,  10,   9,   5,   4,   2,   0,  -0,  -1,  -2,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -3,  -4,  -4,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -1,   0,   2,   3,   5,   7,   9,  10,  12,  13,  15,  16,  17,  19,  20,  22,  23,  24,  25,  26,  27,  27,  27,  26,  27,  26,  25,  25,  25,  24,  23,  23,  23,  23,  23,  22,  22,  21,  21,  22,  22,  23,  24,  24,  25,  25,  26,  27,  27,  27,  28,  29,  30,  31,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33,  34,  35,  38,  40,  42,  45,  45,  46,  46,  46,  45,  46,  45,  46,  46,  44,  46,  47,  47,  45,  47,  52,  50,  47,  44,  43,  43,  42,  41,  40,  38,  37,  35,  34,  34,  33,  33,  33,  34,  34,  33,  33,  32,  31,  30,  29,  29,  28,  27,  25,  24,  23,  22,  20,  19,  18,  17,  15,  14,  12,  11,   9,   7,   6,   4,   2,   1,  -1,  -3,  -4,  -6,  -7,  -9, -11, -12, -14, -15, -16, -18, -19, -21, -21, -22, -23, -24, -25, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -26, -25, -25, -24, -24, -23, -22, -22, -21, -20, -19, -18, -18, -17, -18, -17, -16, -16, -16, -15, -14, -14, -14, -14, -14, -13, -13, -12, -12, -11, -11, -10, -10,  -9,  -8,  -8,  -7,  -5,  -5,  -5,  -2,   4,   4,   5,   6,   3,   1,   1,   1,   1,   1,   0,  -0,  -1,  -2},
  /* -45.0 */ {   3,   3,   3,   3,   1,  -0,  -1,  -3,  -4,  -5,  -6,  -7,  -8,  -8,  -8,  -9,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -8,  -8,  -8,  -9, -10, -10, -11, -12, -12, -12, -13, -13, -13, -14, -14, -15, -15, -15, -15, -15, -16, -16, -15, -15, -15, -15, -14, -14, -14, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -1,  -0,   0,   1,   2,   3,   4,   5,   6,   6,   7,   9,  10,  11,  11,  13,  16,  19,  19,  18,  17,  16,  15,  14,  12,  12,  12,  11,  11,  11,   9,   5,   3,   2,   0,   0,  -0,  -1,  -2,  -3,  -3,  -3,  -4,  -4,  -4,  -3,  -4,  -4,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -0,   1,   3,   5,   7,   9,  10,  12,  13,  15,  17,  18,  19,  21,  22,  23,  24,  25,  26,  26,  26,  26,  26,  26,  26,  25,  25,  25,  25,  24,  24,  23,  22,  21,  21,  21,  21,  22,  22,  22,  23,  24,  25,  26,  26,  26,  27,  27,  28,  28,  29,  30,  31,  32,  32,  33,  33,  33,  33,  33,  33,  33,  33,  33,  34,  35,  38,  39,  42,  44,  46,  46,  47,  46,  46,  46,  46,  45,  45,  46,  46,  46,  45,  44,  45,  45,  44,  43,  43,  42,  41,  40,  39,  37,  36,  34,  33,  32,  32,  32,  31,  31,  31,  31,  31,  30,  30,  29,  28,  27,  26,  25,  24,  23,  21,  20,  19,  18,  16,  15,  14,  12,  11,   9,   8,   6,   4,   3,   1,  -1,  -3,  -5,  -6,  -8,  -9, -11, -13, -14, -16, -17, -19, -20, -21, -22, -23, -24, -25, -26, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -27, -26, -26, -26, -25, -24, -24, -23, -22, -21, -20, -19, -19, -18, -17, -17, -17, -16, -16, -15, -15, -14, -13, -13, -12, -12, -12, -11, -11, -10,  -9,  -9,  -8,  -8,  -8,  -7,  -6,  -4,  -3,  -3,  -3,  -6,  -1,   4,   5,   8,   7,   6,   5,   5,   6,   5,   5,   5,   4,   3},
  /* -44.0 */ {  10,  10,   9,  10,   9,   6,   3,   1,  -0,  -2,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -5,  -6,  -4,  -6,  -7,  -7,  -7,  -7,  -7,  -8,  -9,  -9, -10, -10, -11, -11, -12, -12, -12, -13, -14, -14, -14, -15, -15, -15, -15, -14, -15, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -2,  -2,  -1,  -0,   1,   2,   3,   3,   4,   5,   6,   7,   8,   9,  10,  11,  10,  12,  14,  17,  18,  18,  19,  18,  16,  15,  14,  12,  11,  11,  11,  11,  10,   6,   6,   2,   1,   1,  -0,  -1,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -4,  -5,  -5,  -6,  -6,  -6,  -6,  -5,  -4,  -3,  -2,  -0,   1,   3,   5,   7,   8,  10,  12,  13,  15,  16,  18,  19,  21,  22,  23,  24,  25,  26,  25,  26,  26,  26,  25,  25,  25,  24,  24,  23,  23,  22,  22,  23,  22,  21,  21,  21,  21,  21,  22,  23,  24,  24,  25,  26,  27,  27,  28,  28,  28,  29,  30,  30,  31,  32,  32,  33,  33,  33,  34,  34,  33,  33,  33,  34,  34,  35,  38,  40,  42,  44,  45,  46,  46,  46,  46,  44,  44,  44,  45,  44,  44,  44,  44,  44,  43,  43,  43,  42,  41,  39,  39,  37,  36,  34,  33,  32,  32,  31,  31,  30,  30,  30,  30,  29,  29,  28,  27,  26,  25,  24,  23,  22,  21,  20,  19,  18,  16,  15,  13,  12,  11,   9,   8,   6,   4,   3,   1,  -1,  -3,  -5,  -6,  -8, -10, -12, -13, -14, -16, -18, -19, -21, -22, -23, -24, -25, -26, -27, -28, -28, -29, -29, -29, -29, -29, -29, -29, -28, -28, -28, -27, -27, -27, -26, -26, -25, -24, -23, -23, -22, -21, -20, -19, -18, -17, -17, -16, -16, -15, -15, -13, -10,  -8,  -9, -11,  -9,  -9,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -6,  -5,  -4,  -3,  -1,  -1,   0,   1,  -0,   2,   5,   8,   9,   9,  11,  10,  11,  12,  11,  11,  10,  10},
  /* -43.0 */ {  14,  13,  12,  12,  10,   9,   7,   4,   3,   2,   0,  -1,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -6,  -6,  -7,  -7,  -8,  -9,  -9, -10, -11, -11, -12, -12, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -7,  -6,  -5,  -5,  -5,  -4,  -4,  -3,  -2,  -2,  -1,  -0,   1,   2,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  10,  12,  15,  17,  20,  20,  20,  20,  19,  16,  14,  13,  13,  12,  11,  12,  11,   9,   6,   4,   1,   1,   0,  -1,  -2,  -2,  -2,  -3,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -7,  -7,  -6,  -6,  -5,  -3,  -2,  -1,   1,   3,   5,   7,   8,  10,  11,  13,  14,  16,  18,  19,  20,  22,  23,  24,  25,  25,  25,  25,  25,  25,  24,  24,  24,  23,  23,  23,  22,  21,  22,  21,  19,  19,  20,  21,  21,  21,  22,  23,  24,  25,  25,  26,  28,  28,  28,  28,  28,  29,  29,  30,  30,  31,  32,  33,  33,  33,  34,  34,  33,  34,  34,  33,  33,  34,  35,  37,  40,  41,  43,  43,  44,  45,  45,  44,  43,  44,  44,  43,  43,  44,  44,  43,  43,  42,  42,  41,  39,  38,  37,  36,  35,  33,  32,  32,  31,  30,  30,  30,  29,  29,  28,  27,  27,  26,  25,  24,  24,  23,  22,  21,  20,  19,  18,  16,  15,  13,  12,  11,   9,   8,   6,   4,   3,   1,  -1,  -3,  -5,  -7,  -8, -11, -12, -14, -16, -17, -18, -20, -21, -23, -24, -25, -26, -27, -28, -29, -29, -30, -30, -30, -30, -30, -30, -30, -30, -30, -29, -29, -28, -28, -27, -27, -26, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -16, -15, -15, -14,  -9,  -5,  -4,  -5,  -8,  -9,  -8,  -8,  -7,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -0,   1,   2,   3,   4,   5,   7,   8,   9,  11,  13,  12,  10,  12,  14,  14,  15,  14,  14},
  /* -42.0 */ {  15,  15,  14,  13,  11,  10,   9,   7,   5,   4,   3,   2,   1,   0,   0,  -1,   0,  -0,  -2,  -2,  -2,  -3,  -4,  -4,  -4,  -5,  -5,  -6,  -7,  -7,  -8,  -9, -10, -11, -11, -12, -12, -12, -12, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -5,  -5,  -4,  -4,  -3,  -2,  -2,  -1,  -0,   1,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  11,  12,  16,  17,  20,  21,  22,  23,  23,  19,  16,  14,  13,  13,  12,  12,  12,  12,  10,   6,   2,   1,   0,  -1,  -1,  -2,  -3,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -8,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   1,   3,   5,   6,   8,  10,  11,  13,  14,  16,  18,  19,  20,  22,  23,  24,  25,  25,  25,  25,  25,  24,  24,  24,  24,  23,  23,  22,  22,  21,  20,  20,  20,  24,  21,  22,  20,  20,  21,  22,  23,  24,  25,  26,  26,  27,  28,  28,  29,  29,  29,  29,  30,  30,  31,  31,  32,  34,  35,  35,  35,  34,  34,  33,  33,  33,  34,  35,  37,  38,  40,  41,  42,  43,  44,  44,  43,  44,  44,  43,  43,  43,  43,  42,  42,  40,  40,  39,  37,  36,  35,  35,  33,  32,  31,  30,  30,  29,  28,  28,  28,  28,  27,  26,  25,  24,  23,  22,  22,  21,  20,  19,  18,  17,  16,  15,  13,  12,  10,   9,   7,   6,   4,   2,   1,  -1,  -3,  -5,  -7,  -9, -11, -13, -14, -16, -18, -19, -21, -22, -24, -25, -26, -27, -28, -29, -30, -31, -31, -31, -32, -32, -31, -31, -31, -31, -31, -31, -30, -30, -29, -29, -28, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -15, -14, -12,  -6,  -2,  -1,  -2,  -5,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -2,  -1,  -1,  -0,   1,   2,   3,   4,   6,   7,   9,  11,  12,  13,  14,  15,  15,  11,   9,  10,  11,  14,  16,  15},
  /* -41.0 */ {  19,  18,  17,  15,  13,  12,  10,   7,   6,   5,   4,   4,   3,   2,   2,   4,   2,   0,   0,  -1,  -1,  -1,  -1,  -1,  -2,  -3,  -4,  -4,  -5,  -6,  -7,  -8, -10, -10, -11, -11, -11, -11, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -8,  -8,  -7,  -7,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -1,  -1,  -0,  -0,   0,   1,   2,   3,   4,   5,   6,   8,   9,  10,  11,  11,  11,  16,  19,  21,  22,  23,  24,  23,  20,  16,  14,  14,  13,  13,  13,  13,  12,  11,   9,   5,   2,   1,  -0,  -1,  -2,  -3,  -3,  -4,  -5,  -5,  -6,  -7,  -8,  -8,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   0,   2,   4,   6,   8,  10,  11,  13,  14,  16,  18,  19,  20,  21,  22,  23,  24,  25,  24,  24,  24,  24,  24,  23,  23,  23,  22,  22,  20,  20,  20,  19,  18,  17,  18,  18,  19,  19,  20,  21,  22,  23,  25,  26,  27,  27,  27,  29,  29,  29,  29,  29,  29,  30,  30,  30,  31,  33,  35,  36,  35,  35,  33,  33,  33,  33,  33,  33,  35,  36,  37,  38,  39,  40,  42,  43,  43,  43,  44,  43,  43,  42,  42,  41,  41,  40,  39,  37,  36,  35,  34,  32,  31,  30,  29,  29,  28,  28,  27,  27,  27,  26,  26,  25,  24,  22,  21,  20,  19,  19,  18,  18,  16,  15,  14,  13,  11,  10,   8,   7,   5,   4,   2,   0,  -2,  -4,  -5,  -7,  -9, -11, -13, -15, -17, -19, -20, -22, -23, -24, -26, -27, -28, -29, -30, -31, -32, -32, -33, -33, -33, -33, -33, -33, -33, -32, -32, -32, -32, -31, -30, -30, -29, -28, -28, -27, -26, -25, -23, -22, -21, -20, -18, -17, -16, -16, -15, -14, -12,  -6,  -2,  -1,  -1,  -0,  -3,  -5,  -4,  -3,  -2,  -1,  -1,   0,   1,   1,   2,   3,   4,   5,   6,   7,   8,   9,  13,  14,  15,  16,  16,  18,  16,  13,  13,  17,  16,  15,  17,  19},
  /* -40.0 */ {  21,  20,  19,  17,  15,  13,  11,   9,   8,   7,   6,   6,   5,   5,   6,   3,   3,   3,   2,   1,   1,   1,   0,  -0,  -1,  -2,  -2,  -3,  -4,  -6,  -7,  -8,  -9, -10, -10, -10, -10, -11, -11, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -2,  -1,  -1,  -1,  -0,   0,   0,   1,   2,   3,   4,   6,   7,   8,   9,  11,  11,  10,  13,  17,  22,  23,  23,  23,  21,  19,  16,  15,  14,  13,  13,  14,  14,  13,  13,  12,  10,   5,   2,   0,  -0,  -2,  -3,  -4,  -4,  -5,  -6,  -6,  -7,  -7,  -8,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   0,   2,   4,   6,   8,  10,  11,  13,  14,  16,  17,  19,  20,  21,  22,  23,  23,  24,  24,  24,  23,  23,  23,  23,  22,  22,  22,  22,  20,  19,  18,  18,  18,  17,  18,  18,  19,  19,  20,  20,  21,  22,  24,  25,  26,  26,  27,  26,  28,  28,  29,  29,  29,  29,  29,  30,  30,  32,  34,  35,  35,  34,  33,  33,  33,  34,  34,  33,  33,  34,  34,  35,  37,  38,  40,  41,  42,  43,  43,  43,  42,  42,  41,  40,  40,  39,  38,  36,  35,  33,  32,  31,  30,  29,  28,  27,  27,  27,  26,  26,  26,  25,  24,  23,  22,  21,  20,  18,  18,  17,  17,  16,  15,  13,  12,  10,   9,   7,   6,   4,   2,   1,  -1,  -2,  -4,  -6,  -8, -10, -12, -14, -16, -18, -19, -21, -23, -24, -25, -27, -28, -29, -30, -31, -32, -33, -33, -34, -34, -34, -34, -34, -34, -34, -34, -34, -33, -33, -32, -32, -31, -30, -30, -29, -28, -27, -26, -25, -24, -23, -21, -20, -18, -17, -15, -15, -14, -12,  -7,  -2,  -2,  -1,  -0,   1,   0,  -2,  -2,  -1,   1,   1,   2,   3,   3,   4,   4,   5,   6,   7,   8,  10,  12,  12,  15,  18,  19,  19,  19,  20,  19,  15,  13,  16,  18,  19,  19,  21},
  /* -39.0 */ {  22,  22,  21,  19,  17,  16,  13,  12,  11,  10,   9,   8,  10,   8,   6,   6,   5,   4,   3,   3,   3,   2,   1,   1,   0,  -1,  -2,  -3,  -4,  -6,  -7,  -8,  -8,  -9,  -9,  -9, -10, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -13, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   1,   1,   2,   3,   4,   6,   7,   8,   9,  10,  11,   9,  13,  17,  20,  24,  23,  20,  18,  17,  16,  14,  14,  14,  14,  13,  12,  13,  13,  13,  11,   8,   3,   1,  -0,  -2,  -3,  -4,  -4,  -5,  -5,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -1,   1,   2,   4,   6,   8,  10,  11,  13,  14,  16,  17,  18,  19,  20,  21,  22,  23,  23,  23,  23,  23,  23,  22,  22,  22,  22,  20,  20,  19,  19,  18,  17,  17,  17,  17,  18,  19,  19,  20,  20,  21,  22,  23,  24,  25,  26,  26,  28,  27,  28,  27,  28,  29,  29,  29,  30,  30,  30,  32,  34,  33,  32,  33,  32,  32,  32,  32,  32,  32,  32,  32,  33,  34,  36,  37,  39,  40,  40,  41,  41,  43,  42,  41,  40,  40,  38,  37,  35,  33,  31,  30,  29,  28,  27,  26,  26,  26,  26,  25,  25,  25,  24,  23,  22,  20,  19,  18,  17,  16,  16,  15,  15,  13,  11,   9,   8,   6,   5,   3,   2,   0,  -2,  -3,  -5,  -7,  -9, -11, -12, -14, -16, -18, -20, -22, -23, -25, -27, -28, -29, -30, -31, -32, -33, -33, -34, -34, -35, -35, -35, -35, -35, -35, -35, -35, -35, -34, -34, -33, -33, -32, -31, -30, -29, -29, -28, -27, -26, -24, -23, -22, -20, -18, -16, -15, -13, -10,  -6,  -3,  -1,   1,   2,   2,   3,   1,  -1,   0,   2,   3,   4,   5,   5,   6,   7,   7,   7,   8,   9,  11,  13,  16,  16,  18,  21,  22,  22,  22,  22,  24,  23,  25,  25,  20,  21,  20,  22},
  /* -38.0 */ {  21,  23,  23,  22,  20,  18,  16,  14,  13,  13,  11,  12,  12,   9,   8,   7,   6,   5,   4,   4,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -7,  -8,  -8,  -9, -10, -10, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -13, -13, -12, -12, -12, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -2,  -2,  -1,  -1,  -1,   0,   1,   2,   3,   4,   5,   6,   8,   9,  10,  11,   9,  14,  20,  21,  24,  24,  21,  19,  18,  16,  16,  15,  16,  15,  14,  15,  15,  15,  13,  11,   9,   4,   2,   1,  -1,  -2,  -3,  -4,  -5,  -5,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   1,   2,   4,   6,   8,   9,  11,  13,  14,  15,  16,  18,  19,  20,  20,  21,  22,  22,  22,  22,  22,  21,  21,  21,  21,  20,  20,  19,  19,  17,  16,  16,  16,  17,  17,  18,  19,  19,  20,  21,  22,  23,  23,  23,  24,  25,  26,  26,  27,  27,  27,  27,  27,  28,  29,  29,  29,  29,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  31,  30,  30,  31,  32,  34,  35,  36,  37,  38,  39,  39,  41,  41,  41,  41,  39,  37,  36,  34,  32,  31,  29,  27,  26,  26,  25,  25,  25,  25,  24,  24,  23,  22,  21,  20,  19,  17,  16,  15,  14,  14,  13,  14,  12,   9,   7,   6,   4,   3,   1,  -0,  -2,  -4,  -6,  -8, -10, -11, -13, -15, -17, -19, -21, -22, -24, -26, -27, -29, -30, -31, -32, -33, -34, -34, -34, -35, -35, -36, -36, -36, -37, -36, -37, -36, -36, -35, -35, -35, -34, -33, -33, -32, -31, -30, -29, -28, -27, -26, -24, -22, -21, -19, -17, -15, -12,  -8,  -4,  -1,   2,   3,   4,   7,   7,   6,   7,   6,   2,   4,   5,   6,   7,   8,   9,   9,   9,  10,  11,  12,  13,  17,  18,  19,  21,  24,  25,  25,  24,  25,  26,  28,  30,  29,  26,  22,  21,  21},
  /* -37.0 */ {  20,  21,  23,  23,  22,  20,  18,  17,  15,  15,  14,  13,  12,  11,  10,   8,   7,   6,   6,   5,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -4,  -5,  -6,  -6,  -7,  -7,  -8,  -8,  -9, -10, -10, -10, -10, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -13, -12, -12, -12, -12, -12, -11, -11, -10, -10, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -1,   0,   1,   2,   3,   5,   6,   7,   8,   9,  11,  11,   9,  12,  21,  21,  25,  25,  23,  20,  18,  17,  17,  17,  17,  16,  17,  17,  16,  15,  14,  12,  10,   8,   4,   2,  -0,  -2,  -3,  -4,  -5,  -5,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -2,  -1,   1,   2,   4,   6,   7,   9,  11,  12,  13,  15,  16,  17,  18,  19,  20,  21,  21,  21,  21,  21,  21,  20,  20,  19,  19,  19,  19,  18,  18,  18,  17,  16,  16,  17,  17,  18,  18,  19,  20,  21,  22,  23,  23,  24,  24,  25,  25,  26,  26,  26,  27,  27,  27,  29,  29,  29,  29,  28,  30,  30,  30,  29,  30,  29,  30,  30,  31,  31,  30,  29,  28,  29,  30,  31,  31,  32,  34,  36,  37,  37,  37,  38,  39,  39,  38,  36,  36,  33,  31,  30,  28,  26,  25,  25,  24,  24,  24,  24,  23,  23,  22,  21,  19,  18,  17,  16,  15,  14,  13,  12,  12,  11,  10,   8,   5,   4,   2,   0,  -1,  -3,  -5,  -7,  -8, -10, -12, -14, -16, -17, -19, -21, -23, -25, -26, -28, -29, -31, -32, -33, -34, -35, -36, -37, -37, -38, -39, -39, -39, -39, -39, -38, -39, -39, -38, -38, -37, -36, -35, -35, -34, -33, -32, -30, -29, -28, -27, -26, -25, -23, -21, -18, -13,  -9,  -6,  -4,  -1,   2,   4,   5,   7,   9,  12,  14,  14,  12,   6,   7,   8,   9,  10,  12,  11,  12,  12,  13,  14,  16,  17,  19,  21,  22,  24,  25,  26,  27,  27,  28,  29,  32,  33,  33,  30,  23,  21,  20},
  /* -36.0 */ {  23,  17,  22,  24,  24,  23,  21,  19,  18,  16,  16,  14,  14,  12,  11,   9,   9,   7,   6,   5,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -7,  -8,  -9,  -9,  -9, -10, -10, -10, -10, -11, -11, -12, -11, -11, -11, -11, -11, -12, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -1,  -0,   1,   2,   3,   5,   6,   7,   8,  10,  11,  12,  11,   9,  19,  21,  25,  27,  26,  23,  20,  19,  18,  18,  18,  18,  17,  17,  17,  17,  15,  13,  11,   9,   7,   4,   1,  -1,  -3,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   1,   2,   4,   6,   7,   9,  10,  12,  13,  14,  16,  17,  18,  18,  19,  20,  20,  20,  20,  19,  19,  18,  18,  18,  18,  18,  17,  17,  17,  18,  17,  17,  17,  17,  18,  18,  19,  19,  20,  21,  22,  23,  24,  24,  25,  25,  26,  26,  26,  27,  27,  28,  29,  31,  31,  30,  28,  28,  28,  28,  28,  28,  28,  28,  28,  30,  30,  30,  29,  27,  27,  27,  27,  28,  28,  30,  32,  34,  35,  35,  34,  34,  34,  35,  34,  34,  33,  33,  31,  29,  27,  25,  24,  24,  24,  24,  24,  23,  23,  22,  20,  19,  18,  17,  15,  14,  13,  12,  11,  11,  10,   9,   8,   6,   4,   1,  -0,  -2,  -3,  -5,  -7,  -9, -11, -12, -14, -16, -18, -20, -22, -24, -25, -27, -28, -30, -31, -33, -33, -36, -37, -38, -39, -39, -40, -40, -40, -41, -41, -40, -39, -38, -38, -38, -38, -39, -38, -37, -36, -36, -35, -34, -33, -31, -30, -29, -28, -26, -24, -21, -18, -11,  -7,  -5,  -3,  -1,   1,   3,   5,   6,   8,  10,  12,  16,  19,  17,  10,   9,  10,  12,  13,  14,  14,  15,  15,  16,  18,  19,  20,  22,  24,  25,  25,  27,  28,  29,  29,  31,  33,  36,  37,  36,  34,  33,  28,  23},
  /* -35.0 */ {  28,  18,  20,  25,  26,  25,  23,  21,  20,  19,  17,  16,  14,  13,  12,  10,   9,   8,   6,   5,   5,   3,   2,   1,   0,  -0,  -1,  -2,  -3,  -3,  -4,  -5,  -6,  -6,  -7,  -8,  -8,  -9,  -9,  -9, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -0,   1,   2,   4,   5,   6,   7,   8,  10,  11,  13,  13,  10,  12,  21,  25,  30,  26,  22,  21,  20,  20,  19,  18,  18,  17,  17,  17,  16,  15,  14,  13,  10,   9,   8,   3,  -0,  -3,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   0,   2,   5,   7,   6,   8,   9,  11,  12,  14,  15,  16,  16,  17,  18,  18,  18,  19,  19,  18,  18,  18,  17,  17,  17,  17,  17,  17,  18,  17,  17,  17,  18,  18,  18,  19,  20,  20,  20,  21,  21,  22,  23,  24,  25,  25,  26,  26,  26,  26,  28,  30,  31,  32,  31,  30,  29,  29,  26,  27,  28,  27,  26,  26,  27,  28,  30,  30,  29,  27,  25,  25,  25,  26,  26,  27,  30,  33,  33,  33,  32,  31,  31,  31,  31,  30,  31,  30,  30,  29,  26,  25,  23,  22,  22,  22,  22,  22,  21,  20,  19,  17,  16,  15,  14,  13,  12,  11,  10,   9,   8,   7,   6,   4,   2,  -1,  -2,  -4,  -6,  -7,  -9, -11, -13, -15, -17, -18, -20, -22, -24, -26, -28, -29, -30, -32, -33, -34, -37, -38, -40, -40, -40, -40, -40, -39, -38, -39, -40, -38, -35, -33, -32, -32, -34, -35, -35, -34, -33, -33, -33, -33, -33, -32, -31, -28, -25, -22, -19, -15, -11,  -7,  -4,  -2,  -0,   1,   2,   4,   6,   8,  10,  12,  14,  17,  20,  20,  17,  11,  13,  14,  15,  16,  17,  17,  17,  19,  21,  22,  24,  25,  26,  26,  27,  28,  31,  32,  32,  34,  38,  39,  38,  38,  38,  38,  37,  28},
  /* -34.0 */ {  37,  24,  18,  25,  27,  27,  26,  23,  21,  20,  17,  16,  16,  14,  12,  11,   9,   8,   7,   6,   5,   4,   3,   2,   1,   0,  -0,  -2,  -2,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -8,  -9,  -9, -10, -10, -10, -11, -11, -11, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -12, -12, -12, -12, -11, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,   0,   1,   2,   3,   5,   7,   7,  10,  10,  11,  12,  14,  13,   8,  19,  25,  32,  24,  22,  22,  23,  22,  21,  19,  18,  17,  17,  17,  17,  16,  16,  15,  13,  10,   8,   6,   2,  -1,  -3,  -5,  -6,  -6,  -7,  -7,  -8,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   1,   3,   3,   5,   6,   7,   9,   9,  11,  12,  13,  14,  15,  16,  16,  17,  18,  18,  18,  18,  17,  17,  16,  16,  16,  16,  16,  16,  17,  18,  17,  18,  19,  18,  20,  20,  20,  21,  21,  21,  22,  23,  23,  24,  25,  25,  26,  26,  26,  27,  29,  31,  32,  33,  33,  32,  31,  30,  28,  27,  29,  28,  26,  26,  26,  27,  29,  29,  29,  26,  23,  23,  23,  23,  24,  25,  28,  31,  33,  31,  30,  28,  28,  28,  27,  27,  27,  28,  29,  27,  25,  24,  22,  21,  20,  20,  20,  20,  19,  18,  17,  16,  15,  14,  12,  11,  10,   9,   8,   7,   6,   5,   3,   1,  -1,  -2,  -4,  -6,  -8,  -9, -11, -13, -15, -17, -19, -21, -22, -24, -26, -28, -30, -31, -32, -33, -35, -37, -38, -40, -41, -41, -40, -40, -40, -37, -36, -37, -38, -36, -33, -31, -28, -28, -30, -30, -30, -30, -29, -27, -26, -27, -28, -28, -27, -24, -22, -18, -14, -11,  -8,  -4,  -2,   1,   3,   4,   4,   6,   8,  10,  12,  14,  17,  19,  22,  24,  22,  18,  15,  17,  18,  19,  19,  20,  20,  23,  24,  26,  27,  27,  27,  28,  30,  32,  32,  33,  36,  39,  39,  39,  39,  40,  40,  41,  41,  37},
  /* -33.0 */ {  43,  35,  18,  24,  28,  28,  27,  24,  23,  20,  19,  18,  16,  14,  12,  11,  10,   9,   8,   7,   6,   5,   3,   2,   1,   1,  -0,  -1,  -2,  -2,  -3,  -4,  -4,  -5,  -6,  -7,  -8,  -9,  -9, -10, -10, -10, -11, -11, -11, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -0,   0,   1,   3,   4,   5,   6,   6,   8,   9,  11,  12,  14,  15,  10,  15,  26,  32,  23,  21,  23,  25,  25,  23,  20,  19,  18,  17,  18,  17,  17,  16,  15,  13,  11,   8,   7,   4,  -0,  -3,  -4,  -5,  -6,  -7,  -8,  -8,  -8,  -8,  -7,  -6,  -5,  -3,  -2,  -1,   1,   2,   3,   4,   6,   7,   7,   8,   9,  11,  12,  13,  14,  14,  15,  16,  16,  17,  17,  17,  17,  16,  16,  16,  16,  16,  16,  16,  17,  17,  19,  19,  19,  20,  20,  23,  21,  22,  22,  22,  23,  23,  24,  24,  25,  26,  27,  27,  27,  28,  31,  31,  33,  34,  34,  32,  31,  29,  28,  29,  29,  30,  29,  25,  25,  25,  26,  27,  29,  26,  22,  20,  21,  21,  22,  23,  26,  31,  30,  28,  26,  25,  25,  24,  24,  23,  23,  24,  25,  25,  24,  22,  21,  19,  19,  18,  18,  17,  17,  16,  15,  14,  13,  12,  11,   9,   8,   7,   6,   5,   4,   3,   1,  -1,  -3,  -5,  -7,  -8, -10, -11, -12, -15, -17, -19, -21, -23, -25, -27, -28, -30, -32, -33, -34, -35, -37, -39, -39, -40, -41, -40, -40, -41, -40, -38, -38, -39, -38, -36, -33, -30, -27, -27, -28, -28, -28, -28, -27, -26, -23, -22, -21, -21, -21, -19, -17, -15, -14, -11,  -7,  -2,   1,   3,   7,   7,   8,   8,   9,  12,  14,  17,  19,  22,  25,  27,  26,  25,  20,  19,  21,  24,  22,  24,  24,  27,  28,  29,  30,  29,  30,  30,  34,  34,  35,  36,  37,  38,  40,  40,  40,  41,  42,  42,  43,  43},
  /* -32.0 */ {  44,  41,  23,  20,  28,  30,  29,  25,  24,  21,  20,  19,  17,  15,  13,  12,  11,  10,   8,   7,   6,   4,   3,   2,   1,   1,   0,  -0,  -2,  -2,  -3,  -3,  -4,  -5,  -6,  -7,  -8,  -9,  -9, -10, -10, -10, -10, -11, -11, -12, -12, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -2,  -2,  -1,  -1,  -1,  -0,   0,   1,   2,   3,   4,   5,   6,   7,   9,  10,  12,  13,  15,  16,  12,  15,  29,  32,  26,  21,  24,  25,  27,  25,  22,  20,  18,  17,  17,  17,  16,  15,  14,  13,  11,   8,   6,   5,  -1,  -3,  -4,  -5,  -6,  -8,  -8,  -7,  -8,  -7,  -7,  -6,  -5,  -2,  -1,   0,   1,   2,   3,   4,   6,   6,   7,   8,   9,  10,  11,  12,  13,  13,  14,  15,  15,  16,  16,  16,  16,  16,  16,  16,  15,  15,  15,  16,  17,  18,  19,  19,  19,  20,  20,  23,  21,  23,  23,  23,  23,  24,  24,  25,  25,  27,  27,  28,  29,  31,  30,  32,  33,  35,  37,  36,  35,  34,  34,  33,  33,  31,  31,  27,  24,  23,  23,  24,  25,  24,  20,  18,  18,  19,  20,  21,  24,  26,  26,  25,  23,  23,  21,  21,  20,  20,  20,  20,  21,  22,  21,  21,  21,  19,  16,  16,  15,  15,  14,  14,  13,  12,  11,  10,   9,   8,   6,   5,   4,   3,   2,   0,  -2,  -4,  -6,  -7,  -9, -11, -13, -14, -15, -16, -19, -21, -23, -25, -26, -28, -30, -29, -31, -32, -34, -35, -36, -37, -40, -40, -41, -40, -41, -41, -40, -39, -39, -39, -38, -36, -35, -31, -27, -27, -26, -25, -26, -26, -24, -24, -22, -20, -19, -20, -19, -18, -15, -12, -12,  -9,  -4,   0,   2,   4,   9,  10,  12,  13,  12,  13,  16,  20,  22,  24,  26,  28,  30,  29,  27,  22,  23,  24,  25,  26,  28,  29,  30,  31,  32,  31,  32,  32,  36,  37,  37,  39,  40,  41,  42,  42,  42,  42,  43,  43,  44,  44},
  /* -31.0 */ {  46,  45,  33,  19,  28,  31,  29,  28,  26,  23,  21,  19,  17,  16,  14,  12,  11,  10,   8,   7,   6,   4,   3,   2,   1,   1,  -0,  -1,  -1,  -2,  -2,  -3,  -3,  -5,  -6,  -7,  -8,  -8,  -9,  -9,  -9,  -9, -10, -11, -11, -12, -12, -13, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -3,  -2,  -2,  -1,  -0,  -0,   0,   1,   1,   1,   2,   3,   4,   5,   6,   7,   8,  10,  11,  13,  14,  16,  13,  17,  31,  33,  27,  24,  25,  25,  27,  26,  22,  20,  18,  17,  17,  16,  15,  15,  14,  13,  11,   8,   6,   4,   1,  -3,  -5,  -6,  -8,  -8,  -8,  -8,  -9,  -8,  -7,  -5,  -4,  -1,   1,   3,   3,   2,   3,   4,   5,   5,   6,   6,   7,   8,   9,  10,  11,  12,  12,  13,  14,  14,  15,  16,  16,  15,  15,  15,  15,  15,  15,  16,  17,  18,  18,  19,  20,  21,  21,  22,  24,  23,  23,  23,  24,  24,  25,  26,  26,  27,  28,  29,  29,  31,  31,  32,  33,  35,  35,  35,  35,  35,  34,  35,  36,  36,  32,  30,  25,  22,  22,  22,  22,  22,  17,  16,  16,  16,  16,  18,  20,  22,  22,  22,  21,  19,  18,  17,  17,  17,  17,  18,  18,  18,  18,  19,  18,  18,  15,  14,  13,  13,  13,  12,  11,  10,   9,   8,   7,   6,   4,   3,   2,   1,  -0,  -2,  -4,  -6,  -8, -10, -12, -13, -15, -17, -17, -18, -21, -23, -25, -27, -28, -28, -30, -32, -34, -34, -36, -37, -37, -39, -39, -39, -40, -40, -40, -40, -40, -40, -39, -38, -37, -36, -31, -30, -26, -25, -25, -24, -24, -23, -24, -21, -20, -20, -19, -20, -18, -16, -13,  -9,  -7,  -6,  -2,   1,   4,   7,  11,  10,  14,  16,  16,  17,  18,  22,  24,  25,  27,  30,  32,  33,  31,  25,  26,  29,  28,  29,  31,  32,  33,  33,  34,  34,  34,  35,  37,  39,  40,  41,  42,  43,  45,  43,  43,  43,  44,  44,  45,  46},
  /* -30.0 */ {  48,  46,  40,  26,  25,  31,  31,  30,  27,  25,  23,  21,  19,  16,  15,  14,  12,  10,   9,   7,   6,   4,   3,   2,   1,   1,  -0,  -1,  -2,  -2,  -1,  -2,  -4,  -5,  -6,  -6,  -7,  -7,  -8,  -8,  -9,  -9, -10, -11, -11, -12, -13, -13, -13, -13, -13, -13, -12, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -2,  -2,  -1,   0,   0,   1,   1,   1,   2,   2,   3,   4,   5,   5,   7,   8,   9,  10,  12,  13,  15,  16,  14,  15,  33,  37,  32,  27,  25,  24,  24,  26,  23,  21,  19,  18,  17,  15,  14,  13,  11,  10,   9,   6,   4,   3,   3,   1,  -4,  -6,  -7,  -8,  -8,  -9, -10,  -9,  -7,  -6,  -4,  -1,  -0,   0,   1,   1,   3,   3,   4,   4,   5,   5,   6,   7,   8,   9,   9,  10,  11,  12,  13,  13,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  17,  17,  18,  19,  20,  21,  23,  23,  25,  22,  23,  24,  24,  25,  26,  26,  26,  27,  28,  29,  32,  31,  32,  34,  35,  34,  33,  33,  33,  33,  32,  34,  33,  36,  35,  30,  28,  24,  21,  21,  20,  20,  16,  14,  13,  14,  14,  15,  15,  18,  19,  19,  18,  16,  15,  14,  14,  14,  15,  15,  15,  14,  14,  14,  15,  15,  14,  13,  12,  11,  10,  10,   9,   8,   7,   6,   5,   4,   3,   1,   0,  -1,  -3,  -5,  -7,  -9, -11, -13, -15, -16, -18, -19, -20, -21, -23, -25, -27, -30, -31, -31, -32, -33, -35, -36, -37, -38, -38, -38, -39, -39, -39, -40, -39, -40, -40, -40, -39, -37, -36, -33, -29, -27, -24, -24, -22, -23, -22, -22, -21, -20, -18, -18, -17, -18, -17, -14, -10,  -6,  -4,  -1,   0,   3,   6,   8,  12,  13,  15,  18,  19,  21,  22,  24,  26,  28,  28,  32,  34,  36,  35,  30,  29,  29,  30,  32,  33,  33,  35,  36,  36,  36,  36,  37,  39,  42,  43,  44,  45,  45,  46,  45,  45,  45,  45,  45,  46,  48},
  /* -29.0 */ {  48,  47,  46,  35,  23,  30,  31,  31,  28,  26,  23,  21,  19,  17,  15,  14,  12,  10,   9,   7,   6,   4,   3,   2,   1,   0,  -0,  -1,  -2,  -2,  -2,  -3,  -4,  -5,  -5,  -5,  -6,  -7,  -7,  -8,  -8, -10, -11, -12, -12, -13, -13, -13, -14, -13, -13, -13, -13, -12, -12, -11, -11, -11, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -1,  -0,   0,   1,   1,   2,   2,   2,   3,   3,   4,   5,   6,   7,   8,   9,  11,  12,  14,  15,  17,  16,  14,  31,  38,  35,  31,  28,  26,  26,  24,  24,  22,  20,  19,  17,  16,  14,  11,  10,   9,   8,   7,   6,   4,   2,   1,  -3,  -6,  -8,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -6,  -4,  -3,  -1,   0,   1,   2,   2,   2,   2,   3,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  12,  13,  14,  15,  14,  15,  15,  15,  15,  15,  16,  17,  18,  18,  19,  20,  21,  22,  24,  24,  23,  24,  24,  24,  25,  25,  26,  26,  27,  28,  30,  32,  31,  32,  32,  32,  31,  31,  32,  32,  31,  31,  31,  31,  34,  35,  29,  27,  25,  19,  18,  18,  18,  13,  12,  11,  11,  12,  12,  11,  13,  15,  15,  15,  15,  13,  11,  10,  10,  11,  11,  11,  10,  10,  10,  11,  11,  10,  11,  11,  10,   9,   8,   7,   6,   5,   4,   3,   2,   0,  -1,  -2,  -4,  -6,  -8, -10, -12, -14, -15, -17, -19, -20, -22, -23, -25, -27, -29, -31, -33, -33, -33, -34, -36, -37, -36, -37, -38, -39, -38, -38, -38, -39, -39, -39, -39, -40, -39, -38, -36, -34, -28, -26, -23, -23, -21, -21, -20, -20, -18, -17, -17, -16, -16, -16, -16, -15, -12,  -9,  -4,  -1,   2,   4,   5,   8,  10,  12,  14,  16,  19,  20,  23,  25,  26,  28,  30,  31,  33,  35,  37,  37,  34,  31,  33,  32,  34,  35,  35,  37,  38,  39,  38,  38,  40,  41,  46,  45,  46,  47,  47,  47,  47,  46,  47,  47,  46,  46,  48},
  /* -28.0 */ {  48,  49,  48,  41,  25,  30,  35,  32,  30,  27,  24,  22,  19,  17,  15,  13,  12,  10,   9,   7,   6,   5,   4,   2,   1,   0,  -0,  -1,  -1,  -1,  -2,  -3,  -4,  -4,  -5,  -5,  -4,  -5,  -6,  -8,  -9, -11, -11, -12, -13, -13, -13, -14, -14, -13, -13, -13, -12, -12, -11, -11, -11, -10, -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -1,  -1,  -0,   0,   1,   1,   2,   2,   3,   3,   3,   4,   4,   5,   6,   7,   8,   9,  11,  12,  14,  15,  17,  17,  13,  26,  35,  38,  35,  29,  29,  27,  24,  24,  23,  21,  20,  18,  16,  14,  11,   9,   8,   8,   7,   6,   6,   2,   1,  -2,  -6,  -8, -10, -10, -11, -11, -11, -10,  -9,  -7,  -6,  -4,  -3,  -2,  -1,  -0,  -0,   1,   1,   2,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  12,  13,  14,  14,  14,  14,  15,  15,  15,  16,  17,  17,  18,  19,  20,  21,  22,  23,  25,  24,  24,  25,  25,  25,  25,  26,  26,  27,  28,  30,  32,  32,  32,  32,  32,  30,  31,  31,  33,  31,  30,  30,  30,  32,  32,  28,  26,  24,  19,  18,  17,  15,  12,  10,   8,   9,  10,  10,   9,   8,  12,  12,  12,  12,  11,   8,   7,   7,   7,   8,   8,   8,   7,   7,   7,   7,   8,   9,   8,   8,   7,   7,   6,   4,   3,   2,   1,  -0,  -2,  -3,  -5,  -7,  -9, -11, -13, -15, -17, -19, -20, -22, -23, -24, -26, -28, -30, -31, -34, -35, -35, -36, -37, -38, -38, -37, -38, -39, -39, -38, -38, -38, -39, -39, -39, -39, -39, -38, -37, -34, -29, -24, -21, -20, -20, -20, -19, -18, -16, -15, -14, -14, -14, -13, -12, -12, -12, -10,  -9,  -6,   0,   4,   5,   8,   9,  11,  13,  15,  18,  20,  22,  25,  27,  29,  30,  32,  33,  35,  38,  40,  40,  38,  35,  36,  35,  36,  36,  38,  39,  41,  41,  41,  40,  42,  44,  46,  47,  47,  48,  48,  49,  49,  48,  48,  47,  47,  47,  48},
  /* -27.0 */ {  48,  50,  49,  45,  29,  31,  34,  33,  31,  28,  25,  22,  19,  17,  15,  13,  12,  10,   9,   7,   7,   5,   4,   2,   2,   0,  -0,  -1,  -1,  -1,  -2,  -3,  -4,  -4,  -4,  -4,  -5,  -6,  -7,  -9, -10, -11, -12, -12, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -11, -11, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -0,   0,   1,   1,   1,   2,   2,   3,   3,   4,   4,   5,   6,   7,   8,   9,  10,  12,  13,  14,  16,  18,  19,  13,  23,  35,  41,  41,  37,  36,  26,  25,  24,  24,  22,  21,  19,  17,  15,  11,   8,   6,   5,   7,   6,   4,   1,   0,  -3,  -7,  -8, -11, -10, -10, -11, -12,  -9,  -9,  -8,  -7,  -5,  -4,  -3,  -3,  -2,  -2,  -1,  -1,   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  14,  14,  14,  15,  15,  15,  16,  17,  17,  18,  19,  20,  21,  22,  22,  24,  26,  25,  25,  25,  25,  25,  25,  25,  26,  28,  31,  32,  33,  33,  31,  32,  30,  29,  28,  29,  28,  29,  29,  29,  29,  29,  28,  24,  22,  18,  15,  14,  13,  11,   7,   6,   6,   7,   7,   7,   6,   9,  10,   9,   8,   6,   5,   4,   4,   4,   4,   5,   5,   5,   4,   4,   4,   4,   5,   6,   6,   6,   5,   3,   3,   1,   0,  -1,  -2,  -4,  -6,  -8, -10, -12, -14, -16, -18, -19, -21, -23, -24, -26, -27, -27, -29, -32, -34, -36, -37, -38, -39, -39, -40, -40, -40, -40, -40, -39, -39, -38, -38, -38, -38, -38, -38, -38, -37, -34, -30, -26, -23, -20, -18, -18, -18, -17, -15, -14, -13, -12, -11, -10, -10,  -8,  -7,  -5,  -2,   0,   0,   1,   4,   7,   9,  12,  14,  16,  18,  20,  22,  24,  26,  29,  32,  34,  35,  36,  38,  41,  43,  43,  39,  37,  37,  37,  38,  41,  41,  42,  43,  44,  44,  43,  45,  46,  48,  49,  50,  50,  50,  50,  50,  50,  49,  48,  48,  47,  48},
  /* -26.0 */ {  49,  51,  50,  47,  34,  32,  34,  34,  31,  28,  25,  22,  20,  17,  15,  14,  12,  10,   9,   8,   7,   6,   4,   3,   2,   1,   0,  -0,  -1,  -2,  -2,  -3,  -4,  -3,  -5,  -6,  -7,  -8,  -9, -10, -11, -11, -12, -12, -13, -13, -13, -13, -13, -13, -13, -12, -11, -11, -11, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -1,  -1,  -0,  -0,   0,   1,   1,   1,   1,   2,   2,   4,   4,   4,   5,   6,   6,   8,   9,   9,  11,  13,  15,  16,  17,  18,  16,  20,  34,  41,  43,  41,  36,  29,  27,  25,  25,  23,  21,  19,  17,  14,  11,   7,   5,   4,   5,   5,   4,   2,  -0,  -2,  -6, -10, -11, -11, -10, -11, -11, -11, -10,  -9,  -7,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -2,  -1,  -0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  13,  14,  14,  14,  14,  15,  16,  16,  17,  18,  19,  19,  20,  21,  22,  23,  25,  27,  29,  24,  25,  25,  25,  25,  26,  28,  31,  32,  34,  34,  30,  28,  29,  28,  27,  27,  26,  26,  26,  26,  26,  27,  26,  20,  19,  16,  13,  12,  10,  10,   6,   5,   4,   5,   5,   4,   5,   8,   9,   7,   5,   3,   2,   2,   2,   2,   2,   3,   3,   3,   2,   2,   2,   2,   2,   3,   2,   2,   1,   1,   0,  -1,  -2,  -4,  -5,  -7,  -9, -11, -13, -15, -17, -19, -20, -22, -24, -25, -27, -29, -30, -29, -31, -34, -36, -38, -39, -40, -40, -41, -42, -42, -42, -41, -39, -40, -40, -39, -38, -37, -37, -37, -38, -37, -35, -31, -27, -24, -22, -19, -17, -17, -17, -14, -12, -11, -11, -10,  -8,  -7,  -6,  -2,   0,   3,   4,   1,   2,   4,   8,  10,  12,  14,  17,  19,  21,  23,  24,  26,  28,  31,  35,  38,  39,  40,  42,  45,  45,  45,  42,  40,  40,  40,  41,  41,  43,  45,  46,  47,  46,  46,  47,  49,  50,  51,  51,  51,  52,  52,  51,  51,  50,  49,  49,  49,  49},
  /* -25.0 */ {  50,  51,  51,  50,  39,  28,  34,  34,  31,  28,  25,  22,  19,  17,  15,  14,  12,  10,  10,   9,   8,   7,   5,   4,   3,   2,   1,   0,  -1,  -2,  -3,  -4,  -4,  -5,  -5,  -7,  -8,  -9,  -9, -10, -11, -11, -12, -12, -12, -13, -13, -13, -13, -12, -11, -11, -11, -11, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,  -0,   0,   1,   1,   1,   2,   2,   3,   3,   3,   4,   5,   5,   8,   8,   8,  10,  11,  12,  14,  17,  18,  19,  16,  18,  36,  38,  41,  43,  39,  29,  27,  26,  25,  23,  21,  19,  17,  13,  10,   6,   4,   3,   2,   3,   4,   2,  -1,  -2,  -3,  -6, -10, -12, -11, -12, -11, -11,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,   0,   1,   2,   3,   4,   5,   7,   8,   9,  10,  12,  12,  13,  13,  13,  14,  14,  14,  15,  16,  16,  17,  18,  19,  20,  21,  22,  23,  24,  26,  28,  26,  24,  24,  24,  24,  25,  28,  30,  32,  33,  33,  29,  28,  28,  27,  26,  24,  24,  24,  22,  21,  21,  19,  21,  15,  15,  12,  11,  11,   8,   7,   6,   4,   3,   3,   3,   2,   5,   8,   9,   7,   3,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,  -0,  -0,  -1,  -2,  -3,  -4,  -5,  -6,  -8, -10, -12, -14, -16, -18, -20, -22, -24, -25, -27, -28, -30, -32, -33, -32, -33, -36, -38, -39, -41, -41, -42, -43, -43, -43, -43, -43, -42, -41, -40, -39, -38, -38, -37, -37, -35, -34, -34, -30, -25, -22, -21, -18, -16, -16, -15, -12,  -9,  -7,  -6,  -7,  -6,  -4,  -3,  -3,   0,   2,   3,   3,   5,   7,  10,  13,  16,  19,  21,  24,  26,  27,  28,  29,  32,  34,  38,  41,  44,  46,  46,  47,  47,  47,  43,  43,  41,  43,  44,  44,  48,  47,  48,  49,  48,  48,  49,  51,  53,  54,  53,  52,  53,  53,  52,  52,  51,  50,  49,  49,  50},
  /* -24.0 */ {  50,  52,  52,  51,  45,  24,  32,  33,  31,  28,  25,  22,  20,  17,  15,  14,  12,  11,  11,  10,   8,   7,   6,   4,   3,   2,   1,   0,  -1,  -2,  -4,  -4,  -4,  -5,  -6,  -8,  -8,  -9,  -9, -10, -11, -11, -12, -12, -12, -13, -12, -12, -12, -12, -11, -11, -11, -10, -10, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   0,   0,   1,   1,   1,   2,   2,   3,   3,   4,   4,   6,   6,   8,   8,   9,  11,  12,  14,  16,  18,  19,  17,  17,  32,  34,  40,  43,  43,  31,  27,  24,  24,  23,  20,  18,  16,  13,   9,   5,   2,   1,  -1,  -0,  -0,  -1,  -3,  -2,  -3,  -4,  -6,  -8,  -9, -10, -12, -11, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,   0,   2,   3,   4,   5,   7,   8,   9,  11,  12,  12,  13,  13,  13,  13,  14,  14,  15,  16,  16,  17,  18,  19,  20,  21,  22,  24,  26,  27,  25,  23,  23,  23,  23,  25,  28,  29,  31,  33,  32,  29,  27,  26,  26,  24,  23,  22,  21,  19,  17,  19,  18,  15,  11,  12,   9,   8,   9,   6,   4,   4,   3,   2,   2,   1,  -0,   5,   7,   8,   6,   2,  -1,  -2,  -2,  -1,  -1,  -1,  -1,  -0,  -1,  -2,  -2,  -2,  -1,  -1,  -2,  -2,  -3,  -3,  -4,  -5,  -6,  -8,  -9, -11, -13, -15, -17, -19, -22, -23, -25, -27, -29, -30, -31, -33, -34, -35, -35, -36, -38, -41, -42, -43, -43, -43, -44, -44, -44, -45, -44, -43, -42, -41, -40, -39, -37, -37, -35, -32, -32, -33, -30, -25, -21, -19, -16, -13, -11, -10,  -8,  -5,  -4,  -4,  -4,  -3,  -1,   0,   2,   3,   4,   3,   5,   7,  10,  13,  17,  22,  24,  26,  28,  31,  32,  32,  33,  35,  38,  42,  46,  47,  48,  49,  49,  49,  48,  45,  44,  46,  47,  46,  47,  48,  49,  51,  50,  50,  50,  51,  54,  55,  55,  54,  53,  53,  54,  54,  53,  52,  51,  50,  50,  50},
  /* -23.0 */ {  50,  52,  52,  52,  51,  29,  28,  31,  30,  28,  25,  23,  20,  18,  16,  14,  13,  12,  11,  10,   9,   8,   6,   5,   3,   3,   2,   1,  -1,  -1,  -3,  -4,  -5,  -7,  -7,  -8,  -8,  -9,  -9, -10, -10, -11, -11, -11, -12, -11, -12, -12, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -8,  -8,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   0,   0,   1,   1,   2,   2,   3,   4,   4,   6,   7,   7,   8,   9,  10,  12,  14,  16,  18,  20,  18,  15,  33,  36,  40,  44,  43,  37,  25,  24,  23,  21,  19,  18,  16,  13,   9,   5,  -0,  -2,  -3,  -4,  -5,  -5,  -5,  -4,  -2,  -3,  -4,  -6,  -6,  -6, -11, -11, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -5,  -4,  -3,  -2,  -1,   0,   1,   3,   4,   5,   7,   8,  10,  11,  12,  12,  13,  13,  13,  13,  14,  14,  15,  16,  17,  17,  18,  19,  20,  22,  23,  25,  26,  25,  24,  22,  22,  23,  24,  28,  29,  30,  32,  32,  30,  27,  25,  23,  22,  21,  19,  18,  17,  16,  15,  15,  14,  12,  10,   6,   6,   6,   3,   1,   0,   1,  -0,  -0,  -1,  -1,   3,   4,   6,   3,   1,  -3,  -4,  -5,  -4,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -5,  -6,  -7,  -8,  -9, -11, -13, -14, -17, -18, -21, -23, -25, -27, -28, -30, -32, -33, -35, -36, -37, -38, -38, -38, -41, -43, -43, -44, -45, -45, -45, -45, -46, -46, -45, -44, -43, -41, -39, -37, -37, -36, -34, -32, -31, -32, -31, -27, -21, -16, -13, -10,  -9,  -7,  -5,  -5,  -2,  -0,   1,   2,   3,   4,   6,   8,   9,  11,  13,  15,  19,  22,  24,  26,  28,  30,  33,  36,  37,  37,  37,  39,  42,  46,  49,  50,  50,  51,  51,  51,  50,  50,  48,  48,  49,  48,  50,  51,  52,  52,  52,  52,  52,  53,  57,  58,  57,  52,  49,  50,  50,  52,  53,  54,  52,  51,  50,  50},
  /* -22.0 */ {  50,  52,  52,  53,  52,  44,  26,  30,  30,  28,  26,  23,  21,  18,  15,  14,  13,  12,  11,  11,  10,   9,   8,   5,   4,   4,   2,   1,  -0,  -1,  -3,  -4,  -5,  -6,  -6,  -7,  -8,  -9,  -9,  -9, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10,  -9,  -8,  -7,  -7,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   0,   1,   1,   2,   2,   3,   4,   6,   6,   7,   8,   9,  10,  11,  13,  16,  17,  19,  20,  15,  33,  37,  43,  44,  42,  39,  27,  23,  21,  21,  20,  18,  16,  14,   9,   4,  -1,  -3,  -4,  -6,  -6,  -7,  -6,  -5,  -3,  -3,  -4,  -5,  -5,  -6,  -8, -10, -10, -10, -10,  -9,  -8,  -7,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -3,  -2,  -1,   1,   2,   3,   4,   6,   8,   9,  10,  11,  12,  12,  13,  13,  13,  13,  14,  14,  15,  16,  17,  17,  18,  19,  21,  22,  23,  24,  25,  24,  23,  22,  23,  24,  27,  28,  29,  30,  31,  29,  27,  25,  21,  19,  19,  18,  16,  16,  14,  13,  11,  10,  10,   8,   4,   3,   2,  -1,  -2,  -3,  -2,  -2,  -3,  -3,  -2,   0,   0,   4,   3,  -0,  -5,  -7,  -7,  -7,  -6,  -5,  -4,  -4,  -6,  -6,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -9, -10, -12, -14, -16, -18, -20, -22, -24, -26, -28, -30, -32, -33, -35, -37, -38, -39, -39, -40, -40, -40, -44, -45, -45, -46, -46, -46, -46, -46, -47, -47, -47, -45, -44, -42, -40, -35, -34, -36, -33, -31, -31, -31, -29, -27, -22, -15, -12,  -9,  -7,  -7,  -6,  -2,   0,   3,   5,   5,   5,   7,  10,  13,  14,  15,  16,  19,  21,  25,  27,  30,  31,  34,  37,  40,  41,  41,  42,  43,  46,  49,  51,  52,  54,  53,  53,  54,  53,  52,  51,  51,  52,  51,  54,  52,  54,  54,  54,  53,  53,  59,  60,  58,  54,  51,  60,  61,  60,  58,  57,  54,  53,  51,  50,  50},
  /* -21.0 */ {  50,  52,  52,  53,  53,  52,  35,  27,  30,  28,  26,  23,  20,  18,  16,  14,  14,  12,  12,  11,  11,   9,   7,   6,   5,   4,   2,   1,   0,  -0,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -8,  -9,  -9, -10, -10, -10, -10, -11, -11, -11, -12, -12, -12, -12, -12, -11, -11, -10, -10,  -9,  -8,  -7,  -6,  -6,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,   0,   0,   1,   1,   2,   3,   4,   6,   8,   8,   9,  10,  12,  14,  16,  18,  20,  20,  16,  32,  38,  43,  42,  43,  40,  29,  22,  23,  21,  21,  18,  16,  14,   9,   4,  -1,  -4,  -6,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -4,  -5,  -6,  -6,  -8, -11,  -9, -10,  -8,  -6,  -5,  -6,  -5,  -6,  -6,  -6,  -7,  -6,  -6,  -6,  -5,  -4,  -3,  -2,  -0,   1,   3,   4,   6,   7,   8,  10,  12,  12,  12,  13,  13,  13,  13,  14,  14,  15,  16,  16,  17,  17,  18,  19,  20,  22,  22,  23,  23,  23,  22,  23,  25,  26,  25,  27,  29,  28,  29,  28,  24,  21,  18,  18,  16,  15,  14,  13,  12,  10,   8,   5,   4,   3,   0,  -2,  -4,  -5,  -5,  -6,  -7,  -6,  -6,  -5,  -4,  -3,   0,   3,  -1,  -6,  -9,  -9,  -9,  -9,  -8,  -1,  -2, -10,  -9,  -8,  -7,  -8,  -8,  -9,  -9, -10, -11, -12, -13, -15, -17, -19, -22, -23, -26, -28, -30, -32, -34, -35, -37, -39, -40, -41, -42, -42, -43, -43, -43, -46, -46, -46, -47, -48, -47, -47, -47, -47, -48, -47, -46, -44, -42, -39, -37, -35, -35, -33, -31, -30, -28, -27, -24, -22, -18, -12,  -9,  -8,  -6,  -3,   1,   4,   6,   7,   8,   9,  11,  14,  16,  17,  20,  22,  24,  26,  28,  31,  32,  34,  36,  40,  44,  44,  43,  44,  47,  50,  53,  54,  55,  55,  56,  55,  56,  56,  53,  52,  54,  54,  54,  57,  54,  57,  57,  54,  54,  62,  60,  60,  57,  50,  62,  64,  64,  63,  62,  60,  59,  54,  53,  51,  50},
  /* -20.0 */ {  50,  51,  51,  51,  52,  52,  43,  24,  29,  29,  26,  23,  21,  18,  16,  15,  13,  12,  11,  10,   9,   9,  10,   7,   5,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -4,  -6,  -6,  -7,  -8,  -8,  -9,  -9, -10, -10, -10, -11, -11, -11, -12, -12, -12, -11, -11, -11, -10, -10,  -9,  -8,  -8,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -1,  -1,  -0,   0,   1,   1,   2,   3,   5,   7,   8,   9,  11,  13,  15,  16,  18,  20,  19,  16,  34,  42,  43,  43,  44,  42,  30,  23,  24,  22,  20,  18,  16,  14,   9,   4,  -1,  -5,  -7,  -8,  -8,  -8,  -9,  -8,  -8,  -7,  -6, -10,  -6,  -6,  -7, -10,  -7,  -9,  -7,  -8,  -7,  -6,  -5,  -6,  -6,  -6,  -7,  -7,  -7,  -6,  -6,  -5,  -3,  -2,  -1,   1,   3,   4,   6,   7,   8,  10,  12,  12,  12,  12,  13,  13,  13,  13,  14,  15,  15,  16,  16,  17,  17,  18,  18,  19,  20,  21,  21,  23,  23,  24,  25,  25,  25,  26,  26,  26,  25,  23,  22,  19,  16,  15,  14,  13,  11,  11,  10,  10,   7,   5,   1,   1,  -1,  -4,  -4,  -9, -11,  -9, -10, -10,  -9,  -8,  -7,  -6,  -2,   1,  -1,  -7, -11, -11, -11, -11, -11, -11, -12, -12,  -7, -12, -10, -11, -11, -11, -12, -12, -13, -15, -16, -18, -21, -23, -25, -27, -29, -32, -33, -35, -37, -39, -40, -42, -44, -45, -46, -47, -46, -45, -45, -48, -48, -48, -48, -48, -49, -48, -48, -48, -48, -47, -46, -44, -42, -40, -37, -35, -34, -32, -30, -28, -26, -24, -22, -19, -17, -12,  -7,  -6,  -3,   1,   4,   8,   9,  10,  11,  14,  16,  18,  21,  23,  24,  24,  25,  28,  31,  33,  34,  37,  39,  43,  46,  45,  45,  48,  52,  55,  56,  57,  57,  57,  57,  57,  58,  56,  54,  55,  55,  55,  56,  58,  57,  58,  56,  56,  60,  59,  61,  58,  51,  55,  64,  65,  65,  64,  63,  61,  59,  57,  52,  51,  50},
  /* -19.0 */ {  51,  50,  51,  51,  51,  50,  47,  26,  29,  29,  29,  25,  21,  18,  16,  14,  12,  12,  11,  10,  10,   9,   8,   6,   5,   4,   3,   2,   2,   2,   1,  -0,  -2,  -3,  -5,  -6,  -6,  -7,  -8,  -8,  -9,  -9, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -10, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -1,  -1,  -0,   1,   2,   3,   4,   6,   8,  10,  12,  13,  15,  17,  19,  21,  14,  20,  35,  44,  43,  44,  43,  39,  30,  22,  23,  22,  19,  17,  16,  12,   8,   4,  -2,  -5,  -7,  -8,  -8, -11, -11,  -9,  -9, -10, -10, -11, -11,  -9,  -8,  -7,  -8, -11,  -9,  -8,  -7,  -6,  -5,  -5,  -5,  -6,  -6,  -7,  -7,  -7,  -6,  -5,  -3,  -2,  -0,   1,   3,   5,   6,   7,   8,  10,  11,  11,  12,  12,  12,  12,  13,  13,  13,  14,  15,  16,  16,  16,  16,  17,  17,  18,  19,  19,  19,  19,  20,  22,  24,  24,  26,  25,  23,  22,  22,  21,  20,  17,  14,  13,  12,  11,  10,   8,   6,   6,   6,   6,   2,  -2,  -5,  -6,  -7,  -7, -11, -12, -13, -12, -11, -10, -10,  -8,  -3,  -1,  -2,  -7, -13, -13, -14, -13, -13, -14, -15, -12, -10, -13, -13, -14, -15, -16, -15, -16, -17, -18, -20, -22, -25, -27, -29, -31, -34, -36, -37, -39, -41, -42, -44, -45, -47, -49, -49, -50, -51, -48, -47, -51, -51, -51, -50, -49, -50, -49, -49, -48, -47, -46, -45, -44, -42, -40, -37, -35, -33, -31, -29, -27, -24, -22, -20, -17, -15, -14,  -7,  -4,  -0,   4,   8,  10,  11,  13,  16,  18,  20,  22,  24,  27,  29,  28,  29,  31,  34,  36,  37,  40,  42,  45,  47,  48,  49,  52,  56,  58,  59,  58,  58,  58,  58,  58,  59,  57,  57,  57,  58,  57,  56,  58,  58,  57,  57,  59,  59,  61,  60,  58,  53,  64,  66,  66,  65,  64,  63,  61,  59,  57,  55,  51,  51},
  /* -18.0 */ {  50,  51,  50,  49,  49,  48,  47,  33,  26,  29,  27,  25,  21,  18,  16,  14,  13,  13,  11,  10,   9,   8,   7,   7,   6,   4,   5,   3,   3,   3,   3,   3,  -0,  -3,  -4,  -4,  -6,  -7,  -6,  -7,  -8,  -9,  -9, -10, -10, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -2,  -2,  -1,  -0,   1,   2,   4,   5,   8,  10,  12,  14,  16,  17,  17,  13,  18,  27,  38,  44,  44,  45,  41,  38,  30,  22,  22,  22,  21,  16,  13,  10,   6,   2,  -1,  -3,  -6,  -8,  -9, -13, -13, -11, -12, -12, -11, -11, -10, -10,  -9,  -8,  -6, -11,  -7,  -9,  -8,  -7,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -6,  -5,  -3,  -1,  -0,   2,   3,   5,   6,   7,   8,  10,  10,  11,  12,  12,  13,  13,  13,  13,  13,  14,  15,  15,  16,  16,  16,  16,  16,  16,  17,  18,  17,  17,  18,  20,  22,  25,  26,  24,  21,  20,  19,  18,  17,  14,  12,  11,  10,   9,   8,   4,   3,   2,   3,   4,   2,  -4,  -8, -10, -10,  -9, -11, -13, -14, -15, -14, -14, -11, -10,  -7,  -5,  -5,  -7, -13, -15, -16, -16, -16, -16, -16, -17, -17, -16, -16, -16, -17, -18, -19, -20, -21, -22, -24, -26, -29, -31, -33, -36, -38, -40, -41, -42, -44, -45, -47, -49, -50, -52, -53, -52, -54, -52, -48, -53, -53, -52, -52, -51, -50, -51, -49, -48, -47, -45, -44, -43, -41, -39, -36, -34, -32, -30, -27, -25, -22, -19, -17, -14, -12, -10,  -7,  -5,   0,   6,   8,  12,  14,  17,  20,  22,  24,  27,  28,  29,  32,  32,  33,  35,  37,  39,  41,  44,  45,  48,  50,  50,  51,  54,  57,  60,  60,  59,  58,  59,  60,  60,  60,  59,  59,  60,  60,  59,  57,  59,  58,  58,  59,  61,  60,  60,  60,  57,  58,  65,  67,  66,  65,  64,  63,  61,  59,  57,  56,  53,  50},
  /* -17.0 */ {  51,  50,  49,  48,  47,  46,  45,  36,  24,  28,  27,  24,  20,  17,  16,  14,  12,  12,  11,  10,   9,   8,   7,   7,   6,   6,   5,   4,   5,   5,   3,   1,  -1,  -3,  -2,  -3,  -3,  -4,  -6,  -7,  -7,  -8,  -9, -10, -11, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -1,  -0,   1,   3,   5,   7,  10,  13,  15,  16,  14,  12,  19,  30,  39,  45,  45,  44,  43,  36,  25,  21,  23,  22,  22,  19,  14,  10,   7,   4,   1,  -1,  -3,  -4,  -7,  -9, -12, -12, -13, -15, -15, -12, -12, -11, -10,  -9,  -8, -12, -10, -10,  -9,  -8,  -8,  -7,  -7,  -6,  -7,  -7,  -8,  -8,  -7,  -6,  -4,  -2,  -1,   0,   2,   4,   5,   6,   7,   9,   9,  10,  11,  11,  12,  12,  13,  13,  13,  13,  13,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  17,  18,  21,  22,  23,  24,  22,  21,  19,  18,  17,  15,  13,  11,  10,   9,   7,   7,   7,  -0,  -1,   1,   1,  -3,  -9, -11, -11, -11, -12, -13, -13, -15, -18, -17, -16, -14, -12, -13, -11,  -8,  -9, -13, -17, -17, -18, -18, -17, -17, -19, -19, -17, -17, -20, -21, -22, -23, -24, -24, -26, -28, -30, -33, -35, -38, -40, -42, -44, -45, -46, -47, -49, -50, -52, -54, -55, -56, -57, -56, -54, -51, -55, -54, -54, -53, -52, -49, -51, -49, -48, -46, -44, -42, -42, -40, -37, -35, -33, -31, -28, -25, -22, -20, -17, -14, -10,  -9,  -6,  -6,  -4,  -0,   7,  12,  16,  19,  22,  24,  26,  29,  31,  33,  31,  33,  35,  36,  38,  39,  43,  45,  45,  48,  50,  52,  52,  54,  57,  59,  61,  62,  59,  60,  61,  63,  63,  63,  61,  61,  61,  61,  60,  60,  60,  59,  58,  60,  59,  60,  60,  60,  58,  62,  66,  66,  66,  65,  63,  62,  61,  59,  58,  55,  54,  51},
  /* -16.0 */ {  52,  49,  48,  46,  45,  44,  42,  34,  22,  28,  26,  23,  20,  17,  16,  14,  12,  12,  11,  10,   9,   8,   7,   7,   7,   6,   6,   5,   5,   4,   2,   1,  -1,   1,  -0,  -2,  -4,  -5,  -5,  -5,  -6,  -8,  -9, -10, -10, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -5,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -5,  -4,  -4,  -3,  -3,  -2,  -1,   0,   2,   5,   7,  10,  13,  15,  13,  15,  30,  38,  42,  45,  45,  46,  41,  32,  25,  22,  22,  24,  22,  21,  17,  13,   9,   5,   2,  -0,  -2,  -4,  -5,  -6,  -8, -11, -13, -13, -14, -14, -13, -12, -11,  -9,  -9,  -8,  -9, -14, -11,  -9,  -8,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -4,  -3,  -2,  -0,   2,   3,   5,   6,   7,   8,   9,  10,  10,  11,  11,  12,  13,  14,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  16,  20,  23,  24,  24,  22,  20,  18,  17,  16,  14,  12,  10,   8,   7,   7,   5,   3,   2,  -3,  -5,  -9,  -8, -10, -12, -11, -10, -14, -15, -16, -15, -22, -20, -21, -19, -18, -18, -17, -13, -10, -14, -18, -19, -20, -20, -19, -20, -21, -22, -20, -19, -21, -25, -26, -27, -27, -28, -29, -32, -34, -37, -40, -42, -45, -46, -48, -50, -50, -51, -52, -54, -55, -57, -58, -59, -59, -58, -57, -54, -57, -56, -56, -54, -53, -52, -50, -49, -46, -45, -43, -40, -40, -37, -35, -33, -31, -28, -25, -22, -19, -18, -15, -11,  -9,  -8,  -6,  -3,  -1,   2,   8,  14,  20,  22,  25,  27,  29,  33,  34,  35,  34,  35,  37,  39,  41,  43,  45,  47,  49,  50,  51,  52,  54,  56,  59,  62,  63,  62,  61,  63,  63,  64,  64,  63,  61,  61,  61,  62,  63,  62,  62,  61,  61,  60,  60,  59,  61,  60,  62,  64,  66,  66,  65,  64,  62,  61,  59,  58,  56,  54,  53,  52},
  /* -15.0 */ {  49,  48,  46,  45,  44,  42,  38,  27,  27,  29,  26,  23,  20,  17,  15,  14,  13,  12,  11,  10,   9,   8,   7,   7,   6,   6,   6,   5,   3,   2,   1,   1,   2,   0,  -2,  -3,  -4,  -5,  -5,  -6,  -7,  -8,  -9, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -2,  -0,   2,   4,   7,  10,  12,  11,  15,  30,  38,  44,  46,  47,  47,  45,  33,  27,  27,  26,  25,  22,  20,  19,  16,  13,   8,   3,  -0,  -2,  -4,  -5,  -6,  -7,  -9, -12, -14, -15, -14, -13, -13, -13, -11, -10, -11,  -8, -13, -14, -12, -11,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -0,   1,   3,   5,   6,   7,   9,  10,  10,  10,  11,  12,  12,  12,  13,  13,  13,  13,  14,  13,  13,  13,  13,  13,  14,  14,  14,  14,  15,  15,  16,  18,  21,  22,  24,  22,  20,  18,  16,  15,  13,  11,   9,   7,   5,   4,   3,   2,  -0,  -3,  -8,  -9, -10, -11, -10, -12, -14, -16, -18, -19, -20, -23, -21, -23, -24, -26, -23, -20, -18, -14, -15, -19, -22, -22, -23, -22, -22, -23, -24, -27, -24, -24, -28, -29, -30, -31, -32, -33, -36, -38, -41, -43, -46, -49, -51, -52, -53, -54, -55, -56, -57, -58, -59, -60, -61, -61, -58, -56, -56, -59, -58, -57, -55, -54, -53, -49, -48, -44, -43, -41, -40, -37, -34, -32, -31, -28, -25, -22, -18, -15, -14, -12,  -8,  -5,  -3,  -1,   1,   4,   6,  10,  15,  21,  26,  28,  30,  32,  35,  37,  37,  37,  39,  41,  43,  45,  47,  48,  51,  53,  52,  52,  54,  56,  58,  61,  64,  65,  63,  63,  64,  64,  63,  62,  61,  62,  62,  63,  63,  63,  64,  63,  64,  62,  61,  62,  63,  59,  54,  62,  64,  65,  65,  64,  63,  61,  59,  58,  56,  55,  53,  51,  49},
  /* -14.0 */ {  47,  46,  44,  43,  38,  36,  32,  31,  33,  30,  29,  24,  19,  17,  16,  14,  13,  13,  12,  10,   9,   8,   7,   7,   6,   6,   5,   4,   3,   2,   3,   1,  -1,  -2,  -3,  -3,  -4,  -5,  -6,  -6,  -7,  -7,  -8,  -9,  -9,  -9, -10, -10, -10,  -9, -10,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -5,  -5,  -6,  -6,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -1,   1,   4,   6,   9,   9,  12,  24,  38,  37,  40,  45,  49,  44,  34,  31,  29,  29,  28,  25,  21,  19,  18,  15,  12,  10,   4,  -2,  -4,  -6,  -8,  -9, -10, -10, -11, -15, -17, -14, -13, -13, -13, -14, -12, -10,  -9, -12, -13, -12, -11, -10,  -9,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   0,   2,   4,   5,   6,   8,   9,   9,  10,  10,  11,  11,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  12,  13,  13,  13,  13,  14,  15,  15,  16,  17,  19,  21,  22,  22,  21,  18,  16,  14,  12,   9,   6,   5,   4,   3,   1,  -0,  -2,  -5,  -7, -11, -11, -12, -11, -16, -17, -19, -20, -20, -22, -24, -23, -25, -26, -27, -25, -24, -18, -16, -16, -22, -24, -24, -25, -25, -25, -26, -27, -29, -29, -27, -31, -32, -34, -35, -36, -37, -40, -42, -45, -47, -50, -53, -55, -56, -58, -59, -60, -60, -61, -62, -62, -62, -64, -64, -63, -61, -60, -60, -59, -59, -56, -55, -53, -50, -46, -42, -41, -40, -38, -35, -30, -28, -27, -25, -21, -17, -14,  -9, -10,  -8,  -4,  -1,   1,   3,   6,   8,  10,  14,  19,  22,  27,  29,  32,  34,  36,  38,  39,  42,  42,  45,  48,  50,  51,  52,  54,  55,  55,  55,  57,  59,  62,  64,  66,  65,  64,  65,  64,  62,  62,  63,  63,  63,  64,  65,  66,  65,  64,  64,  65,  64,  64,  63,  62,  62,  52,  57,  65,  64,  64,  63,  61,  59,  58,  56,  54,  53,  51,  50,  47},
  /* -13.0 */ {  41,  44,  41,  36,  36,  34,  32,  29,  28,  25,  24,  21,  19,  17,  15,  14,  13,  14,  13,  12,  10,   9,   8,   7,   7,   6,   4,   4,   3,   2,   1,   0,  -0,  -1,  -3,  -3,  -4,  -4,  -5,  -5,  -6,  -6,  -7,  -8,  -8,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -6,  -7,  -7,  -8,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -4,  -4,  -2,  -1,   1,   4,   6,   6,   7,  17,  32,  36,  34,  36,  41,  37,  31,  30,  31,  31,  29,  27,  24,  21,  19,  17,  13,  12,  11,   5,  -2,  -5,  -8,  -8,  -8, -11, -12, -12, -16, -18, -14, -13, -14, -16, -13, -12, -11, -11, -11, -12, -13, -12, -10,  -9,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -6,  -5,  -4,  -3,  -1,   1,   2,   4,   5,   7,   9,   9,   9,  10,  10,  10,  11,  12,  12,  14,  13,  13,  13,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  14,  15,  16,  17,  18,  22,  21,  22,  22,  18,  15,  13,  11,   8,   5,   4,   2,   1,   0,  -2,  -5,  -5,  -6, -10, -14, -12, -15, -19, -17, -21, -22, -21, -22, -25, -27, -28, -27, -22, -27, -27, -21, -18, -21, -26, -26, -27, -28, -27, -28, -29, -30, -32, -34, -31, -34, -36, -37, -38, -39, -42, -44, -46, -49, -51, -54, -57, -59, -60, -62, -64, -64, -64, -64, -65, -65, -65, -66, -67, -65, -66, -63, -60, -61, -59, -57, -56, -53, -48, -43, -42, -40, -38, -37, -31, -26, -24, -22, -19, -17, -13, -10,  -6,  -4,  -3,   1,   3,   5,   7,  11,  12,  15,  18,  23,  26,  29,  32,  35,  36,  37,  39,  42,  44,  46,  49,  52,  54,  55,  56,  57,  58,  58,  59,  60,  61,  64,  67,  65,  64,  66,  65,  65,  65,  64,  64,  64,  64,  65,  67,  68,  68,  66,  66,  64,  65,  64,  63,  62,  59,  48,  59,  62,  62,  62,  60,  59,  57,  56,  54,  52,  50,  48,  46,  41},
  /* -12.0 */ {  43,  41,  39,  35,  34,  31,  31,  27,  26,  25,  23,  20,  18,  17,  15,  15,  14,  14,  14,  13,  10,   9,   8,   7,   7,   6,   5,   4,   3,   3,   2,   1,   0,  -0,  -2,  -2,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -6,  -7,  -8,  -8,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -7,  -8,  -9,  -9,  -9, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   1,   3,   4,   2,  10,  24,  32,  33,  31,  31,  31,  28,  27,  29,  29,  30,  27,  23,  21,  19,  18,  15,  11,   9,   8,   2,  -5,  -8, -10,  -9, -11, -14, -16, -14, -15, -17, -16, -16, -16, -16, -13, -12, -12, -12, -11, -12, -13, -12, -11,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -6,  -5,  -4,  -2,  -0,   2,   3,   5,   6,   7,   9,  10,  10,  10,  10,  11,  11,  12,  12,  12,  13,  13,  12,  12,  11,  11,  11,  11,  11,  11,  12,  12,  13,  14,  15,  16,  17,  17,  19,  21,  22,  21,  19,  15,  12,  10,   7,   5,   3,   1,  -0,  -2,  -3,  -5,  -7,  -9, -10, -13, -13, -16, -19, -19, -23, -24, -24, -23, -26, -27, -26, -24, -27, -28, -29, -25, -24, -26, -29, -29, -30, -30, -30, -31, -32, -33, -35, -37, -34, -36, -39, -41, -42, -44, -46, -48, -51, -53, -55, -58, -61, -63, -64, -66, -68, -68, -68, -68, -68, -69, -68, -68, -69, -68, -67, -65, -62, -63, -59, -58, -56, -52, -48, -44, -39, -38, -36, -33, -28, -24, -21, -17, -14, -13,  -9,  -7,  -3,   0,   3,   6,   7,   8,  10,  13,  15,  17,  21,  23,  25,  30,  35,  37,  38,  41,  43,  45,  46,  49,  52,  54,  56,  57,  59,  60,  61,  62,  62,  62,  63,  67,  69,  68,  67,  68,  67,  67,  65,  65,  66,  66,  66,  67,  65,  67,  68,  67,  63,  67,  64,  62,  61,  60,  56,  46,  58,  61,  60,  60,  58,  57,  53,  52,  50,  49,  46,  46,  42,  43},
  /* -11.0 */ {  39,  38,  34,  33,  31,  29,  28,  27,  26,  24,  22,  20,  19,  17,  17,  15,  15,  15,  15,  12,  11,   9,   8,   8,   7,   6,   6,   5,   5,   4,   3,   3,   2,   1,  -0,  -2,  -2,  -3,  -3,  -4,  -4,  -4,  -4,  -5,  -6,  -7,  -7,  -8,  -8,  -9,  -9,  -9,  -9, -10, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -8,  -9,  -9, -10, -10, -11, -11, -11, -11, -11, -11, -11, -10, -10, -10,  -9,  -9,  -8,  -7,  -6,  -5,  -4,  -2,  -1,   1,   2,  -0,   2,  15,  27,  32,  31,  29,  28,  26,  27,  28,  28,  27,  27,  24,  21,  19,  18,  15,  11,   7,   2,  -2,  -4,  -9, -10, -10, -11, -12, -16, -19, -17, -16, -16, -16, -17, -17, -16, -16, -13, -12, -13, -12, -10, -10, -12, -11, -11, -10, -10,  -9,  -9,  -8,  -8,  -7,  -6,  -5,  -3,  -1,   1,   2,   4,   6,   7,   8,  10,  11,  12,  11,  11,  11,  11,  12,  13,  13,  13,  13,  12,  12,  12,  11,  11,  11,  10,  10,  11,  11,  12,  13,  14,  14,  15,  17,  18,  18,  20,  19,  16,  13,  10,   8,   6,   4,   1,  -1,  -1,  -3,  -4,  -6,  -9, -10, -11, -12, -14, -15, -17, -18, -22, -25, -24, -24, -27, -27, -29, -29, -30, -31, -30, -31, -30, -30, -31, -30, -31, -32, -32, -33, -34, -36, -37, -38, -36, -38, -42, -45, -47, -48, -50, -52, -55, -57, -58, -62, -65, -67, -69, -70, -71, -72, -72, -72, -72, -72, -72, -70, -70, -70, -68, -67, -63, -65, -60, -57, -55, -52, -48, -44, -39, -37, -33, -29, -26, -23, -19, -14,  -8,  -8,  -7,  -5,  -2,  -0,   3,   5,   5,   4,   7,  11,  13,  16,  18,  23,  27,  29,  30,  31,  37,  42,  46,  48,  49,  52,  55,  57,  59,  59,  60,  62,  63,  64,  66,  66,  67,  69,  72,  72,  70,  70,  69,  68,  69,  72,  75,  74,  74,  72,  70,  65,  69,  68,  65,  64,  58,  62,  56,  55,  52,  54,  58,  59,  57,  56,  52,  51,  49,  46,  45,  43,  41,  40,  39,  39},
  /* -10.0 */ {  35,  33,  31,  30,  29,  27,  27,  26,  25,  22,  21,  20,  18,  17,  16,  15,  16,  15,  14,  13,  11,  10,   8,   8,   7,   7,   7,   6,   6,   5,   5,   4,   2,   2,   0,  -1,  -1,  -2,  -2,  -3,  -3,   1,  -2,  -4,  -5,  -6,  -7,  -7,  -8,  -9,  -9, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -10, -10,  -9,  -9,  -8,  -8,  -8,  -8,  -8,  -8,  -9,  -9, -10, -11, -11, -12, -12, -12, -12, -12, -12, -11, -11, -11, -11, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -2,  -1,   1,   0,  -1,   9,  20,  24,  28,  27,  23,  26,  26,  27,  27,  26,  25,  23,  21,  18,  16,  14,  11,   7,   3,  -1,  -4,  -4,  -7, -10, -12, -12, -13, -15, -19, -19, -19, -19, -17, -16, -15, -17, -17, -14, -12, -12, -11,  -9,  -9, -12, -11, -11, -11, -10, -10,  -9,  -8,  -7,  -7,  -6,  -4,  -3,  -1,   2,   4,   5,   7,   8,   9,  10,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  11,  10,  10,  10,  10,  10,  10,  11,  11,  12,  13,  14,  15,  17,  17,  17,  16,  13,  11,   8,   6,   4,   2,  -2,  -4,  -5,  -5,  -7,  -6,  -9, -13, -12, -11, -12, -17, -15, -19, -22, -23, -24, -27, -31, -30, -32, -32, -33, -33, -34, -33, -33, -32, -30, -32, -33, -33, -34, -35, -36, -38, -39, -38, -39, -42, -46, -49, -51, -52, -54, -56, -59, -61, -63, -65, -68, -71, -73, -74, -75, -76, -76, -76, -75, -75, -75, -74, -71, -70, -69, -68, -65, -65, -60, -58, -54, -52, -47, -43, -39, -35, -32, -27, -23, -21, -16, -11,  -6,  -5,  -8,  -7,  -4,  -2,   1,   5,  10,  10,  11,  14,  16,  19,  27,  36,  34,  27,  27,  33,  33,  36,  42,  47,  50,  52,  55,  58,  60,  61,  63,  65,  64,  66,  68,  69,  70,  72,  74,  74,  71,  69,  69,  75,  78,  78,  77,  74,  73,  73,  71,  70,  67,  66,  63,  63,  63,  58,  60,  60,  58,  58,  57,  56,  54,  51,  50,  47,  44,  43,  41,  39,  38,  36,  35,  35},
  /*  -9.0 */ {  32,  29,  29,  27,  26,  25,  24,  24,  23,  22,  20,  19,  17,  17,  16,  15,  15,  15,  13,  12,  11,   9,  12,   9,   8,   8,   8,   7,   7,   7,   5,   5,   3,   2,   1,   0,   0,  -0,  -1,  -0,   2,  -2,  -3,  -3,  -4,  -6,  -7,  -8,  -8,  -9, -10, -10, -10, -11, -11, -11, -11, -12, -12, -12, -13, -13, -12, -12, -12, -11, -11, -10, -10,  -9,  -9,  -9,  -9,  -9, -10, -10, -11, -12, -12, -12, -13, -13, -13, -13, -12, -12, -12, -12, -11, -11, -10,  -9,  -8,  -7,  -5,  -4,  -2,  -0,   0,  -2,   6,  14,  19,  19,  18,  19,  21,  25,  25,  26,  26,  24,  23,  20,  17,  14,  12,  11,   8,   4,   1,  -3,  -5,  -8, -10, -13, -15, -16, -16, -17, -21, -22, -21, -21, -20, -19, -18, -16, -14, -14, -12, -11,  -9,  -8,  -7,  -8, -11, -11, -11, -10, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -2,  -0,   2,   4,   6,   8,   9,  10,  12,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  13,  12,  10,  10,   9,   9,   9,   9,   9,  10,  10,  11,  11,  13,  16,  16,  15,  13,  10,   8,   6,   4,   2,  -0,  -3,  -6,  -8, -10,  -9,  -8, -12, -14, -13, -11, -12, -14, -13, -19, -21, -24, -25, -31, -33, -33, -34, -35, -35, -37, -34, -38, -35, -34, -34, -34, -36, -35, -36, -37, -38, -40, -41, -40, -44, -46, -49, -52, -54, -56, -58, -60, -63, -64, -66, -69, -72, -75, -76, -78, -79, -80, -80, -79, -78, -77, -77, -76, -74, -72, -70, -68, -65, -65, -60, -58, -55, -50, -46, -42, -37, -32, -30, -25, -21, -17, -13, -10,  -9,  -9,  -6,  -3,   1,   7,  11,  16,  21,  24,  27,  31,  35,  33,  36,  40,  37,  35,  32,  37,  42,  42,  37,  34,  41,  46,  52,  56,  60,  62,  65,  67,  66,  67,  69,  70,  71,  73,  75,  74,  74,  71,  77,  82,  78,  78,  78,  77,  74,  73,  71,  70,  69,  67,  63,  62,  62,  54,  60,  59,  56,  56,  54,  52,  49,  48,  45,  43,  42,  41,  39,  38,  36,  35,  33,  32},
  /*  -8.0 */ {  29,  27,  26,  25,  24,  22,  21,  21,  20,  20,  19,  18,  17,  17,  17,  16,  15,  15,  14,  12,  12,  10,  10,  10,   9,   9,   9,   9,   8,   8,   6,   5,   4,   3,   2,   2,   2,   1,   0,   3,   1,  -1,  -2,  -3,  -4,  -5,  -6,  -8,  -8,  -9, -10, -10, -11, -12, -12, -12, -13, -13, -13, -14, -13, -13, -13, -13, -13, -13, -12, -12, -11, -11, -11, -10, -10, -10, -11, -11, -11, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -12, -12, -11, -10,  -9,  -8,  -7,  -5,  -4,  -2,  -0,  -0,  -2,   9,  15,  20,  13,  12,  15,  21,  23,  24,  26,  24,  22,  20,  18,  15,  11,  10,   8,   4,   1,  -1,  -4,  -7, -10, -14, -16, -18, -19, -19, -20, -22, -23, -23, -23, -23, -23, -22, -19, -16, -13, -11, -10,  -8,  -6,  -5,  -5, -10, -11, -11, -11,  -9,  -8,  -8,  -7,  -6,  -5,  -4,  -2,   0,   2,   4,   6,   8,  10,  11,  12,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  13,  13,  10,  10,   9,   9,   8,   8,   8,   9,   9,  10,  11,  13,  13,  12,  10,   7,   6,   4,   1,  -1,  -3,  -5,  -7,  -8, -12, -14, -11, -12, -11, -14, -14, -15, -17, -15, -17, -22, -25, -27, -29, -34, -35, -36, -37, -38, -40, -36, -40, -38, -36, -37, -36, -37, -38, -38, -39, -41, -42, -43, -44, -47, -50, -53, -55, -58, -60, -61, -63, -66, -69, -69, -72, -76, -79, -80, -82, -82, -83, -84, -83, -82, -81, -80, -79, -77, -75, -72, -70, -66, -65, -61, -58, -54, -50, -45, -42, -35, -30, -26, -23, -19, -15, -13, -12, -12,  -7,   2,  12,  19,  24,  25,  27,  30,  33,  34,  33,  35,  37,  37,  38,  38,  41,  43,  45,  46,  48,  46,  42,  42,  46,  47,  51,  59,  63,  66,  67,  68,  69,  70,  71,  72,  74,  75,  75,  74,  75,  84,  75,  68,  72,  73,  69,  71,  69,  69,  68,  70,  65,  63,  61,  57,  59,  58,  56,  54,  51,  50,  49,  47,  44,  42,  41,  39,  39,  37,  36,  34,  33,  31,  29},
  /*  -7.0 */ {  27,  25,  24,  22,  21,  21,  20,  19,  20,  19,  18,  17,  17,  17,  17,  16,  15,  14,  14,  13,  12,  12,  11,  11,  11,  10,  10,   9,   9,   8,   7,   6,   5,   4,   4,   3,   3,   3,   2,   0,  -0,  -0,  -1,  -2,  -4,  -5,  -6,  -7,  -8,  -9, -10, -10, -11, -12, -12, -13, -13, -14, -14, -14, -15, -15, -15, -14, -14, -14, -14, -13, -13, -12, -12, -12, -12, -11, -12, -12, -12, -13, -13, -13, -13, -13, -13, -13, -14, -13, -13, -13, -12, -12, -11, -10,  -8,  -7,  -5,  -3,  -2,  -0,  -2,   3,   9,  17,  19,  11,  12,  16,  20,  22,  23,  24,  23,  22,  19,  16,  13,   9,   7,   4,   1,  -2,  -4,  -6,  -9, -12, -16, -18, -20, -21, -21, -21, -22, -23, -24, -24, -25, -24, -23, -21, -18, -14, -11, -10,  -9,  -6,  -4,  -4,  -9, -10,  -9,  -9,  -8,  -7,  -7,  -6,  -5,  -4,  -2,  -1,   1,   3,   5,   8,   9,  10,  12,  13,  14,  15,  16,  16,  16,  16,  16,  15,  15,  15,  16,  16,  16,  16,  15,  13,  11,  10,   9,   9,   8,   8,   7,   7,   8,  11,  13,  11,  10,   9,   7,   5,   3,   1,  -2,  -5,  -7,  -9, -10, -11, -13, -16, -15, -11, -11, -13, -14, -16, -16, -19, -20, -22, -25, -27, -30, -34, -36, -37, -38, -39, -40, -43, -43, -39, -39, -38, -38, -39, -39, -40, -42, -43, -44, -45, -49, -51, -53, -56, -58, -61, -63, -65, -66, -69, -73, -73, -74, -78, -82, -84, -85, -86, -86, -87, -86, -84, -82, -81, -81, -78, -76, -73, -70, -65, -64, -61, -58, -52, -48, -44, -40, -34, -29, -23, -18, -17, -15, -12,  -9,  -6,   8,  20,  22,  22,  24,  25,  28,  31,  34,  37,  39,  41,  43,  44,  44,  49,  48,  48,  49,  50,  50,  50,  50,  50,  45,  42,  46,  54,  63,  67,  68,  70,  70,  70,  72,  73,  75,  76,  77,  77,  78,  73,  60,  59,  65,  67,  70,  68,  60,  63,  70,  67,  62,  59,  56,  59,  58,  55,  53,  52,  50,  48,  46,  44,  42,  40,  39,  37,  37,  35,  32,  31,  30,  29,  27},
  /*  -6.0 */ {  26,  24,  22,  21,  20,  19,  19,  18,  19,  18,  17,  17,  17,  17,  17,  16,  16,  15,  15,  14,  13,  12,  12,  12,  12,  11,  11,  10,  10,  10,   9,   7,   7,   6,   5,   5,   4,   3,   3,   1,   1,   0,  -1,  -2,  -4,  -5,  -6,  -7,  -8,  -9, -10, -10, -11, -12, -13, -14, -14, -14, -15, -15, -15, -15, -16, -16, -15, -15, -15, -15, -14, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -12, -12, -11,  -9,  -8,  -6,  -5,  -3,  -1,  -0,  -3,   8,  10,  17,  19,  14,  13,  15,  18,  20,  22,  23,  23,  21,  18,  14,  12,   8,   3,   1,  -2,  -5,  -6,  -9, -11, -14, -17, -19, -21, -21, -22, -22, -23, -24, -24, -26, -25, -24, -23, -22, -19, -15, -12, -11,  -8,  -7,  -5,  -5,  -8,  -8,  -8,  -8,  -7,  -6,  -6,  -5,  -3,  -2,  -1,   1,   2,   4,   6,   8,  10,  12,  13,  14,  15,  16,  17,  18,  17,  17,  16,  16,  16,  16,  16,  17,  17,  17,  16,  15,  12,  11,   9,   9,   8,   7,   7,   7,   8,   9,  11,   7,   6,   5,   4,   1,  -1,  -4,  -6,  -8, -10, -13, -15, -15, -15, -16, -15, -13, -13, -13, -15, -18, -18, -20, -20, -19, -23, -28, -32, -34, -37, -39, -39, -40, -41, -42, -42, -42, -41, -40, -40, -39, -41, -42, -43, -44, -45, -49, -51, -54, -56, -59, -61, -64, -66, -68, -69, -72, -76, -77, -76, -80, -86, -87, -88, -89, -89, -90, -90, -89, -87, -86, -84, -81, -77, -75, -71, -66, -63, -61, -56, -51, -48, -44, -37, -31, -27, -21, -17, -17, -12, -10,  -4,   8,  14,  19,  21,  24,  26,  28,  31,  34,  37,  40,  42,  44,  46,  47,  50,  49,  51,  52,  55,  55,  54,  54,  53,  53,  50,  35,  44,  53,  58,  66,  68,  70,  70,  70,  73,  75,  79,  81,  82,  81,  72,  71,  70,  75,  81,  75,  60,  57,  56,  71,  65,  63,  60,  60,  60,  58,  56,  54,  52,  49,  47,  45,  44,  42,  40,  39,  37,  36,  34,  33,  32,  31,  28,  27,  26},
  /*  -5.0 */ {  24,  23,  21,  20,  20,  19,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  16,  16,  15,  14,  14,  13,  13,  13,  13,  12,  12,  12,  11,  11,  10,   9,   8,   8,   7,   6,   5,   4,   3,   2,   1,  -0,  -1,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -10, -11, -12, -12, -13, -14, -14, -15, -15, -16, -16, -17, -17, -17, -17, -16, -16, -16, -16, -15, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -12, -11, -10,  -9,  -8,  -6,  -4,  -2,  -0,   1,  -2,  11,  17,  18,  11,  10,  11,  15,  19,  21,  21,  22,  20,  19,  15,  13,  10,   6,   0,  -3,  -4,  -6,  -8, -11, -13, -16, -18, -20, -21, -22, -22, -22, -24, -25, -25, -26, -26, -25, -23, -22, -19, -15, -12, -10,  -8,  -7,  -6,  -7,  -8,  -8,  -7,  -6,  -5,  -5,  -4,  -3,  -2,  -1,   0,   2,   3,   5,   7,   9,  11,  12,  14,  15,  16,  17,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  16,  14,  12,  10,   9,   8,   8,   7,   7,   6,   6,   4,   4,   3,   2,   0,  -2,  -6,  -8, -10, -12, -14, -15, -16, -17, -16, -16, -15, -13, -15, -15, -16, -19, -20, -19, -19, -18, -23, -27, -30, -34, -38, -40, -41, -42, -42, -43, -43, -43, -43, -42, -42, -41, -43, -41, -41, -44, -49, -51, -54, -56, -59, -61, -64, -66, -69, -71, -72, -75, -78, -81, -81, -84, -88, -90, -91, -91, -92, -93, -93, -92, -88, -87, -86, -83, -79, -76, -72, -67, -64, -60, -56, -50, -46, -42, -35, -30, -24, -19, -19, -15,  -9,  -4,   8,  13,  16,  20,  23,  26,  28,  30,  33,  36,  40,  43,  45,  47,  47,  50,  54,  54,  57,  57,  56,  56,  58,  58,  58,  56,  55,  43,  49,  59,  57,  68,  68,  70,  69,  72,  76,  81,  84,  81,  77,  70,  68,  74,  78,  80,  82,  80,  74,  58,  60,  64,  66,  66,  63,  61,  59,  57,  54,  52,  50,  47,  45,  43,  42,  41,  39,  37,  35,  34,  33,  31,  29,  28,  27,  26,  24},
  /*  -4.0 */ {  24,  22,  21,  20,  19,  19,  18,  18,  18,  18,  16,  17,  17,  16,  17,  17,  17,  16,  15,  14,  14,  14,  14,  14,  14,  14,  13,  12,  13,  12,  12,  11,  10,   9,   8,   7,   6,   4,   3,   2,   1,  -0,  -2,  -3,  -4,  -5,  -6,  -7,  -9,  -9, -10, -11, -12, -13, -14, -15, -15, -16, -16, -17, -18, -18, -18, -18, -18, -18, -18, -17, -17, -16, -16, -16, -15, -15, -15, -15, -15, -14, -14, -14, -14, -14, -14, -14, -14, -13, -13, -12, -11, -11,  -9,  -8,  -7,  -5,  -3,  -1,   1,   2,   0,   8,  16,  17,  13,  10,  12,  16,  20,  21,  21,  20,  18,  16,  13,  10,   8,   4,  -2,  -5,  -6,  -7,  -8, -10, -12, -16, -20, -20, -20, -21, -22, -23, -24, -25, -25, -26, -27, -26, -23, -21, -19, -15, -13, -10,  -8,  -9,  -8,  -8,  -7,  -6,  -6,  -6,  -4,  -3,  -3,  -2,  -1,   0,   1,   3,   5,   6,   7,  10,  11,  13,  14,  16,  17,  18,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  15,  14,  12,  11,   9,   8,   8,   5,   5,   5,   3,   3,   3,   1,  -2,  -6,  -9, -10, -13, -14, -15, -17, -18, -18, -18, -16, -15, -12, -12, -15, -17, -19, -20, -19, -19, -18, -21, -24, -31, -33, -37, -40, -41, -43, -44, -44, -44, -44, -44, -44, -44, -44, -44, -42, -44, -49, -51, -54, -56, -59, -61, -64, -67, -69, -71, -73, -75, -77, -81, -84, -86, -87, -90, -92, -93, -94, -94, -95, -94, -94, -91, -87, -87, -85, -80, -76, -73, -66, -63, -60, -55, -49, -44, -39, -33, -28, -22, -19, -19, -10,  -3,   7,  11,  14,  17,  21,  24,  27,  29,  32,  35,  39,  42,  44,  48,  50,  48,  51,  57,  57,  61,  59,  56,  58,  59,  59,  59,  59,  58,  57,  54,  65,  67,  70,  76,  81,  82,  81,  77,  79,  78,  77,  75,  75,  77,  79,  81,  81,  80,  78,  74,  66,  63,  63,  65,  64,  61,  59,  56,  54,  52,  50,  48,  45,  44,  43,  41,  40,  38,  35,  34,  32,  30,  29,  29,  27,  26,  25,  24},
  /*  -3.0 */ {  23,  21,  20,  20,  19,  19,  18,  18,  18,  17,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  14,  14,  15,  15,  14,  14,  14,  14,  14,  13,  12,  11,  10,   9,   8,   7,   6,   5,   4,   3,   1,  -0,  -1,  -3,  -4,  -5,  -7,  -8,  -9, -10, -11, -12, -13, -14, -15, -16, -17, -17, -18, -18, -19, -19, -19, -20, -19, -19, -19, -18, -18, -18, -17, -17, -16, -16, -16, -16, -15, -15, -15, -15, -14, -14, -14, -14, -13, -13, -12, -12, -11, -10,  -8,  -7,  -6,  -4,  -3,  -0,   2,   4,   3,   5,  10,  22,  16,  10,  14,  18,  20,  20,  19,  18,  17,  14,  10,   8,   6,   2,  -2,  -4,  -7,  -9, -12, -15, -15, -15, -18, -18, -19, -20, -22, -22, -24, -25, -26, -26, -27, -27, -24, -22, -20, -16, -13, -11, -11, -11, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   0,   1,   2,   4,   5,   6,   8,  10,  11,  13,  15,  16,  18,  19,  20,  19,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  17,  15,  14,  13,  11,  10,   8,   8,   7,   4,   4,   5,   4,   2,  -2,  -8, -11, -13, -15, -15, -18, -20, -19, -19, -18, -16, -14,  -9,  -9, -13, -16, -18, -19, -18, -18, -16, -20, -25, -30, -31, -38, -40, -41, -43, -45, -45, -46, -46, -45, -45, -45, -46, -46, -47, -49, -51, -53, -55, -58, -61, -64, -66, -69, -71, -73, -75, -77, -80, -84, -87, -89, -90, -92, -95, -96, -97, -97, -98, -98, -96, -93, -88, -89, -87, -82, -77, -73, -67, -63, -59, -54, -48, -43, -37, -31, -27, -21, -23, -15, -10,   4,   8,  12,  15,  18,  22,  25,  28,  31,  34,  38,  41,  43,  45,  50,  53,  54,  56,  61,  61,  61,  58,  58,  60,  60,  59,  58,  60,  60,  59,  63,  69,  69,  69,  69,  77,  78,  76,  77,  78,  77,  78,  78,  79,  79,  80,  79,  78,  77,  76,  71,  67,  62,  63,  63,  61,  59,  56,  54,  52,  50,  48,  45,  44,  42,  40,  39,  38,  37,  34,  33,  32,  30,  27,  26,  26,  25,  24,  23},
  /*  -2.0 */ {  22,  21,  20,  19,  19,  19,  17,  17,  17,  16,  16,  16,  15,  15,  15,  15,  15,  15,  14,  15,  15,  15,  15,  15,  15,  15,  15,  14,  14,  13,  12,  12,  11,  10,   9,   8,   6,   5,   4,   3,   1,  -0,  -2,  -3,  -4,  -6,  -7,  -8,  -9, -10, -11, -13, -14, -15, -16, -17, -18, -19, -19, -20, -20, -21, -21, -21, -21, -21, -20, -20, -19, -19, -18, -18, -17, -17, -17, -16, -16, -16, -15, -15, -14, -14, -13, -13, -13, -12, -11, -11, -10,  -9,  -8,  -7,  -5,  -4,  -2,   0,   3,   5,   6,  11,  18,  23,  23,  14,  16,  19,  20,  19,  17,  16,  15,  14,  10,   7,   5,   1,  -2,  -5,  -7,  -9, -12, -15, -16, -17, -19, -22, -22, -22, -23, -23, -24, -25, -25, -25, -26, -26, -22, -20, -19, -17, -16, -16, -13, -12, -11, -10,  -8,  -7,  -6,  -4,  -4,  -2,  -1,   1,   2,   4,   5,   6,   8,   8,  10,  12,  13,  14,  15,  17,  18,  20,  20,  20,  20,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  16,  15,  14,  12,  11,  10,   7,   5,   7,   7,   4,   2,  -3,  -7, -11, -15, -18, -20, -21, -21, -21, -20, -19, -17, -14,  -7,  -8, -12, -16, -18, -18, -17, -19, -15, -20, -25, -29, -31, -38, -41, -41, -44, -45, -47, -47, -47, -47, -46, -47, -48, -48, -49, -51, -53, -55, -57, -60, -63, -66, -69, -71, -72, -75, -77, -79, -83, -86, -89, -91, -92, -93, -97, -98, -99,-100,-101,-100, -98, -94, -92, -90, -87, -83, -78, -72, -68, -64, -59, -54, -47, -42, -36, -30, -26, -25, -17, -16,  -3,   5,   8,  12,  15,  19,  22,  26,  29,  33,  36,  39,  42,  45,  48,  51,  53,  51,  57,  64,  64,  61,  61,  61,  62,  64,  62,  59,  64,  68,  69,  71,  71,  70,  72,  72,  74,  75,  74,  71,  71,  73,  76,  78,  78,  78,  78,  76,  74,  73,  70,  66,  63,  62,  62,  61,  60,  57,  54,  51,  49,  48,  46,  44,  42,  41,  40,  38,  37,  35,  33,  32,  30,  27,  28,  27,  25,  24,  23,  22},
  /*  -1.0 */ {  21,  20,  20,  19,  19,  17,  17,  17,  16,  16,  16,  15,  14,  16,  15,  14,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  15,  14,  14,  13,  12,  12,  11,  10,   9,   8,   7,   5,   4,   2,   1,  -0,  -2,  -3,  -5,  -6,  -7,  -9, -10, -11, -12, -13, -15, -16, -17, -18, -19, -20, -21, -21, -22, -22, -22, -23, -22, -22, -22, -21, -21, -20, -19, -19, -18, -18, -17, -17, -17, -16, -16, -15, -14, -14, -13, -13, -12, -11, -11, -10, -10,  -6,  -4,  -4,  -3,  -2,  -1,   1,   4,   7,   9,  10,  16,  24,  23,  15,  17,  19,  20,  19,  17,  15,  14,  12,   8,   5,   2,  -1,  -3,  -6,  -8,  -9, -12, -15, -18, -20, -21, -24, -24, -23, -24, -23, -25, -25, -25, -25, -24, -22, -22, -23, -22, -20, -18, -16, -14, -12, -10,  -8,  -6,  -4,  -2,  -1,   1,   4,   5,   6,   6,   7,   7,   8,   8,   9,  10,  13,  15,  17,  18,  18,  19,  19,  20,  20,  20,  20,  20,  19,  19,  18,  18,  18,  18,  18,  18,  17,  18,  17,  17,  16,  16,  14,  14,  12,   9,   8,   8,   6,   4,   0,  -4,  -8, -13, -15, -19, -21, -21, -21, -21, -20, -18, -16, -12,  -7,  -8, -12, -14, -17, -17, -15, -15, -16, -20, -24, -28, -31, -34, -40, -42, -43, -45, -48, -49, -48, -49, -48, -48, -49, -50, -51, -53, -54, -56, -59, -62, -64, -67, -70, -72, -74, -77, -78, -81, -85, -88, -91, -94, -93, -95, -99, -99,-100,-101,-102,-101,-100, -97, -95, -92, -88, -84, -79, -74, -67, -62, -59, -54, -47, -41, -35, -29, -27, -23, -17, -12,  -0,   3,   8,  11,  15,  19,  22,  26,  30,  34,  37,  41,  45,  48,  50,  54,  54,  54,  55,  62,  61,  64,  61,  50,  44,  45,  55,  68,  71,  72,  74,  77,  79,  78,  75,  75,  72,  70,  69,  72,  73,  73,  73,  73,  73,  73,  72,  71,  69,  64,  62,  60,  60,  59,  60,  59,  58,  56,  53,  50,  48,  46,  44,  42,  41,  39,  39,  37,  35,  33,  32,  31,  28,  28,  28,  26,  24,  24,  22,  21},
  /*   0.0 */ {  21,  20,  20,  19,  19,  18,  17,  16,  15,  15,  15,  15,  15,  15,  14,  15,  16,  16,  16,  16,  16,  17,  16,  16,  17,  16,  15,  14,  14,  13,  13,  12,  11,  10,   9,   8,   6,   5,   3,   2,   1,  -1,  -2,  -4,  -6,  -7,  -8,  -9, -11, -12, -13, -14, -16, -17, -18, -19, -20, -21, -22, -23, -23, -24, -24, -24, -24, -23, -23, -22, -22, -21, -20, -20, -19, -19, -18, -18, -17, -16, -16, -15, -14, -13, -13, -12, -11, -11, -10,  -9,  -8,  -6,  -4,  -4,  -3,  -2,  -0,   1,   3,   6,  10,   9,  14,  22,  25,  17,  18,  20,  21,  19,  19,  17,  14,  11,   7,   3,   0,  -2,  -5,  -7,  -8, -10, -13, -16, -19, -21, -23, -25, -26, -25, -24, -24, -26, -27, -26, -26, -25, -23, -25, -25, -23, -20, -19, -16, -14, -12, -10,  -8,  -7,  -4,  -2,   0,   2,   4,   6,   8,   9,  10,  10,  10,  11,  12,  13,  13,  15,  17,  18,  19,  19,  19,  19,  19,  19,  20,  19,  19,  19,  19,  18,  18,  17,  17,  17,  17,  17,  17,  17,  16,  17,  16,  14,  12,   9,   9,   8,   6,   3,  -1,  -4,  -8, -11, -15, -17, -19, -20, -21, -21, -19, -17, -15, -12,  -7, -10, -12, -12, -14, -16, -16, -14, -12, -19, -23, -27, -30, -33, -35, -41, -43, -45, -48, -49, -50, -49, -49, -49, -50, -51, -52, -53, -55, -58, -60, -63, -66, -68, -71, -73, -75, -78, -80, -83, -86, -89, -92, -95, -95, -96,-100,-101,-102,-103,-103,-103,-102, -99, -94, -93, -89, -84, -79, -74, -69, -63, -58, -53, -47, -40, -34, -30, -29, -19, -13,  -7,  -2,   2,   6,  10,  14,  18,  22,  26,  30,  34,  37,  41,  45,  50,  54,  55,  55,  53,  54,  58,  61,  63,  56,  55,  51,  47,  69,  72,  74,  77,  76,  73,  74,  73,  72,  68,  68,  70,  71,  72,  72,  72,  72,  71,  69,  68,  66,  66,  62,  63,  61,  59,  58,  59,  59,  59,  56,  54,  52,  49,  47,  45,  44,  42,  41,  39,  38,  36,  34,  32,  31,  29,  28,  28,  25,  25,  23,  23,  22,  21},
  /*   1.0 */ {  19,  20,  19,  19,  18,  17,  17,  16,  15,  15,  15,  14,  14,  14,  15,  15,  15,  16,  16,  16,  16,  17,  17,  17,  16,  16,  15,  15,  14,  13,  12,  11,  11,  10,   8,   7,   6,   5,   3,   1,  -0,  -2,  -4,  -5,  -7,  -8,  -9, -11, -12, -13, -15, -16, -17, -18, -19, -21, -22, -23, -24, -24, -25, -25, -25, -25, -25, -25, -24, -24, -23, -22, -21, -21, -20, -19, -19, -18, -17, -17, -16, -15, -14, -13, -13, -12, -11, -10,  -9,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   1,   2,   3,   6,   8,  10,  12,  18,  28,  24,  19,  20,  22,  21,  20,  17,  14,  10,   6,   2,   1,  -1,  -6,  -8,  -9, -11, -14, -17, -20, -23, -25, -26, -28, -28, -27, -26, -27, -28, -27, -26, -26, -28, -27, -25, -22, -20, -18, -15, -13, -11,  -8,  -6,  -4,  -1,   1,   4,   5,   6,   7,   8,   9,  10,  10,  11,  12,  13,  13,  12,  12,  15,  16,  17,  17,  17,  18,  19,  19,  20,  20,  19,  19,  18,  18,  18,  18,  17,  17,  17,  16,  16,  16,  16,  15,  16,  14,  13,  11,  11,   9,   7,   4,  -0,  -3,  -6, -10, -13, -15, -18, -19, -19, -19, -18, -16, -14, -13, -11, -12, -13, -14, -14, -16, -12, -16, -14, -19, -24, -26, -29, -31, -33, -36, -42, -44, -47, -50, -51, -49, -50, -50, -51, -52, -53, -54, -56, -58, -61, -64, -66, -68, -71, -73, -76, -78, -81, -84, -88, -91, -94, -96, -96, -97,-100,-102,-103,-103,-103,-103,-102,-100, -96, -95, -91, -86, -80, -74, -68, -61, -58, -52, -47, -40, -35, -32, -26, -19, -12,  -7,  -3,   1,   4,   9,  13,  17,  21,  25,  29,  33,  37,  41,  45,  50,  55,  58,  58,  58,  56,  56,  64,  65,  63,  67,  68,  58,  65,  71,  72,  73,  74,  74,  74,  73,  71,  71,  71,  71,  71,  71,  71,  71,  70,  69,  68,  67,  66,  66,  62,  62,  59,  58,  57,  57,  57,  57,  55,  53,  50,  48,  46,  45,  43,  42,  40,  39,  37,  35,  33,  31,  31,  28,  29,  26,  26,  24,  23,  21,  20,  19},
  /*   2.0 */ {  19,  19,  19,  18,  18,  17,  16,  15,  15,  14,  14,  14,  14,  14,  14,  15,  15,  16,  15,  16,  17,  17,  18,  18,  16,  15,  14,  14,  14,  13,  12,  11,  10,   9,   7,   6,   5,   4,   2,   0,  -1,  -3,  -4,  -6,  -8,  -9, -11, -12, -13, -14, -16, -17, -18, -20, -21, -22, -23, -24, -25, -26, -26, -27, -27, -27, -26, -26, -25, -25, -24, -23, -23, -22, -21, -20, -19, -18, -18, -17, -16, -15, -14, -13, -12, -10, -10,  -9,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   0,   1,   3,   5,   7,   9,  11,  11,  13,  20,  26,  24,  20,  20,  20,  18,  14,  11,   8,   4,  -0,  -1,  -4,  -6,  -9, -10, -12, -16, -19, -22, -24, -26, -28, -29, -29, -29, -28, -29, -29, -28, -30, -32, -29, -27, -24, -22, -20, -17, -15, -13, -10,  -8,  -5,  -2,   0,   3,   5,   7,   7,   8,   9,  10,  10,  11,  11,  12,  12,  12,  13,  13,  14,  14,  15,  16,  18,  20,  20,  20,  19,  18,  18,  18,  19,  19,  18,  17,  17,  17,  17,  16,  16,  16,  15,  15,  16,  14,  13,  13,  12,   9,   7,   4,   0,  -1,  -3,  -7, -10, -14, -16, -18, -16, -16, -15, -14, -13, -13, -11, -11, -13, -14, -14, -16, -15, -17, -16, -20, -23, -25, -28, -30, -30, -33, -36, -40, -46, -50, -51, -50, -50, -51, -52, -53, -54, -55, -56, -58, -61, -63, -66, -68, -71, -74, -76, -79, -81, -85, -89, -92, -95, -97, -97, -99,-100,-102,-104,-104,-104,-104,-103,-102, -99, -95, -90, -85, -80, -73, -66, -61, -56, -51, -47, -43, -39, -32, -27, -21, -10,  -7,  -4,  -0,   4,   8,  12,  15,  20,  23,  26,  30,  34,  38,  41,  45,  53,  56,  58,  57,  54,  54,  59,  59,  60,  64,  70,  62,  56,  68,  69,  72,  74,  74,  74,  73,  72,  71,  70,  70,  70,  69,  70,  69,  68,  67,  66,  66,  65,  64,  62,  60,  57,  56,  56,  56,  56,  55,  54,  52,  50,  47,  46,  44,  42,  40,  39,  38,  36,  34,  32,  31,  30,  27,  28,  26,  25,  23,  21,  21,  20,  19},
  /*   3.0 */ {  19,  18,  18,  17,  17,  16,  16,  15,  14,  14,  14,  14,  14,  14,  14,  15,  15,  16,  16,  17,  17,  18,  17,  17,  16,  15,  14,  14,  12,  11,  10,  10,   9,   8,   7,   5,   4,   3,   1,  -0,  -2,  -3,  -5,  -7,  -9, -10, -11, -13, -14, -16, -17, -18, -20, -21, -22, -23, -25, -25, -26, -27, -28, -28, -28, -28, -28, -27, -26, -26, -25, -24, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -12, -11, -10,  -9,  -8,  -7,  -5,  -4,  -3,  -2,  -1,   0,   1,   2,   4,   5,   7,  10,  12,  13,  11,  15,  24,  27,  18,  18,  16,  12,   9,   6,   3,   1,  -3,  -6,  -7,  -6, -10, -13, -14, -17, -20, -23, -26, -28, -29, -30, -30, -30, -31, -31, -29, -29, -31, -31, -29, -27, -25, -23, -21, -18, -15, -12, -10,  -7,  -4,  -2,   1,   4,   5,   6,   8,   8,   9,  10,  11,  11,  12,  13,  13,  15,  15,  15,  16,  17,  18,  18,  19,  20,  21,  20,  21,  20,  20,  20,  19,  18,  18,  18,  17,  17,  17,  16,  15,  14,  16,  17,  17,  16,  15,  15,  13,  11,   8,   6,   3,   1,  -0,  -3,  -7, -10, -13, -14, -13, -12, -12, -11, -12, -12, -11, -11, -13, -14, -13, -13, -15, -17, -18, -20, -21, -24, -27, -29, -30, -31, -35, -37, -41, -47, -50, -50, -52, -51, -53, -53, -54, -56, -57, -59, -61, -63, -66, -68, -71, -73, -76, -79, -82, -86, -90, -93, -95, -98, -96, -99,-101,-103,-104,-103,-104,-104,-104,-102, -99, -95, -91, -85, -80, -74, -67, -60, -55, -51, -49, -44, -37, -31, -29, -19, -12,  -9,  -5,  -1,   2,   5,   9,  13,  18,  21,  24,  28,  31,  35,  40,  45,  50,  54,  57,  55,  55,  57,  59,  62,  65,  68,  70,  67,  56,  62,  67,  73,  73,  74,  73,  72,  71,  70,  69,  69,  69,  68,  68,  68,  67,  66,  65,  64,  64,  63,  61,  57,  56,  54,  54,  55,  55,  54,  53,  50,  49,  47,  46,  43,  41,  40,  38,  36,  34,  32,  30,  30,  29,  26,  28,  25,  24,  22,  21,  20,  19,  19},
  /*   4.0 */ {  17,  17,  16,  16,  17,  16,  15,  14,  14,  14,  13,  13,  14,  13,  14,  14,  15,  16,  17,  16,  17,  17,  17,  16,  15,  15,  14,  13,  12,  11,  10,   9,   7,   6,   5,   4,   3,   2,   0,  -1,  -3,  -4,  -6,  -8, -10, -12, -13, -15, -16, -17, -19, -20, -21, -22, -23, -25, -26, -27, -28, -28, -29, -29, -29, -29, -29, -29, -28, -27, -27, -26, -25, -24, -23, -21, -20, -19, -18, -17, -16, -14, -13, -12, -11, -10,  -9,  -8,  -7,  -5,  -4,  -3,  -2,  -0,   1,   3,   4,   5,   7,   9,  10,  13,  14,  13,  10,  17,  27,  18,  19,  10,   6,   4,   2,  -1,  -3,  -6,  -7,  -8,  -9, -12, -14, -15, -18, -22, -24, -27, -31, -33, -33, -32, -33, -34, -32, -29, -30, -31, -32, -30, -28, -26, -23, -21, -18, -15, -13, -10,  -7,  -4,  -1,   2,   4,   5,   6,   8,   9,  10,  10,  12,  12,  13,  14,  15,  16,  16,  17,  17,  18,  19,  19,  20,  21,  22,  22,  24,  25,  24,  23,  22,  21,  20,  20,  19,  18,  17,  16,  15,  17,  19,  21,  19,  18,  20,  16,  15,  14,  12,  10,   8,   5,   3,  -3,  -6,  -8,  -9, -10, -11, -11, -11, -11, -11, -11, -11, -12, -13, -13, -12, -11, -14, -16, -17, -16, -18, -22, -26, -30, -30, -31, -34, -37, -39, -43, -47, -49, -53, -54, -52, -53, -54, -55, -57, -59, -61, -63, -65, -67, -70, -73, -77, -80, -83, -87, -90, -93, -96, -98, -96,-100,-101,-103,-104,-104,-106,-106,-105,-103, -99, -95, -90, -86, -80, -73, -67, -60, -55, -51, -51, -44, -43, -33, -22, -20, -15, -11,  -7,  -2,   1,   3,   6,  10,  15,  19,  22,  25,  29,  33,  37,  42,  47,  52,  56,  55,  57,  59,  61,  63,  66,  68,  69,  70,  62,  65,  66,  71,  72,  72,  72,  71,  70,  69,  68,  67,  67,  67,  67,  67,  66,  65,  64,  63,  62,  62,  59,  57,  55,  53,  53,  54,  54,  52,  53,  49,  48,  47,  45,  41,  41,  38,  36,  34,  33,  31,  30,  28,  28,  25,  26,  24,  23,  21,  19,  19,  18,  17},
  /*   5.0 */ {  16,  16,  16,  16,  16,  15,  13,  13,  13,  13,  12,  12,  13,  13,  14,  14,  15,  16,  16,  17,  16,  17,  16,  15,  15,  14,  13,  12,  11,  10,   9,   8,   6,   5,   4,   3,   1,  -0,  -1,  -3,  -4,  -6,  -8, -10, -12, -13, -15, -16, -17, -19, -20, -21, -23, -24, -25, -26, -27, -28, -29, -30, -30, -30, -31, -31, -31, -30, -29, -29, -28, -27, -26, -24, -23, -22, -21, -19, -18, -17, -15, -14, -13, -11, -10,  -9,  -8,  -7,  -6,  -5,  -4,  -3,  -1,   0,   2,   4,   6,   6,   8,   9,  10,  12,  13,  14,  12,  16,  27,  23,  22,  13,   3,  -0,  -2,  -5,  -6,  -5,  -8,  -9, -10, -15, -13, -14, -19, -24, -25, -27, -33, -34, -33, -34, -34, -34, -36, -35, -35, -34, -33, -31, -29, -26, -24, -21, -18, -16, -13, -10,  -7,  -4,  -1,   2,   4,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,  17,  17,  17,  17,  18,  19,  20,  20,  21,  23,  23,  27,  30,  30,  29,  27,  26,  24,  25,  24,  22,  20,  20,  17,  16,  18,  21,  19,  19,  20,  21,  20,  18,  16,  14,  12,   9,   6,   4,  -1,  -5,  -8,  -8,  -7,  -9,  -9, -10, -11, -12, -11, -11, -11, -12, -13, -13, -13, -13, -15, -14, -15, -17, -21, -24, -29, -30, -31, -34, -36, -39, -41, -46, -49, -53, -54, -54, -53, -54, -55, -56, -57, -60, -62, -64, -66, -70, -74, -78, -81, -84, -88, -91, -94, -96, -97, -96,-100,-101,-102,-103,-105,-107,-106,-105,-103, -99, -95, -90, -86, -80, -73, -67, -60, -54, -52, -50, -49, -42, -29, -26, -21, -17, -13,  -8,  -3,  -1,   0,   3,   8,  12,  17,  20,  23,  27,  31,  34,  39,  44,  49,  54,  57,  59,  62,  62,  64,  66,  67,  64,  65,  53,  56,  68,  70,  69,  70,  71,  69,  68,  68,  67,  67,  66,  66,  65,  66,  65,  64,  63,  62,  61,  61,  59,  55,  54,  53,  52,  54,  52,  51,  51,  49,  47,  45,  43,  40,  40,  36,  34,  33,  30,  30,  29,  28,  27,  25,  24,  23,  22,  21,  18,  18,  17,  16},
  /*   6.0 */ {  16,  16,  16,  16,  15,  13,  12,  11,  12,  12,  12,  12,  13,  13,  14,  14,  15,  15,  16,  17,  16,  16,  15,  14,  13,  13,  12,  11,  10,   8,   7,   6,   5,   4,   3,   1,   0,  -1,  -3,  -5,  -6,  -8, -10, -11, -13, -15, -16, -18, -19, -20, -22, -23, -24, -25, -27, -28, -29, -30, -31, -31, -32, -32, -32, -32, -32, -31, -31, -30, -29, -28, -26, -25, -24, -23, -21, -20, -18, -17, -15, -14, -12, -11, -10,  -9,  -8,  -6,  -5,  -4,  -3,  -2,  -1,   1,   3,   4,   6,   8,   9,  10,  13,  13,  14,  14,  12,  19,  26,  20,  13,  20,   6,  -3,  -5,  -7, -10,  -8,  -6,  -7, -13, -17, -16, -19, -23, -26, -27, -28, -32, -32, -32, -33, -33, -36, -38, -38, -38, -36, -34, -32, -30, -27, -24, -22, -19, -16, -13, -10,  -7,  -4,  -1,   2,   4,   5,   7,   8,   9,  10,  11,  12,  13,  15,  16,  17,  18,  18,  18,  19,  20,  21,  22,  23,  25,  28,  30,  31,  31,  29,  29,  27,  27,  28,  27,  27,  26,  25,  21,  19,  19,  20,  19,  20,  21,  22,  23,  20,  18,  15,  12,  10,   8,   5,   1,  -3,  -6,  -6,  -6,  -7,  -8,  -9, -11, -11, -10, -10, -11, -12, -13, -13, -13, -13, -13, -13, -13, -14, -18, -23, -26, -29, -30, -32, -34, -37, -40, -42, -49, -52, -53, -55, -54, -54, -54, -55, -57, -58, -60, -62, -66, -70, -74, -78, -82, -85, -88, -91, -94, -96, -97, -97,-100,-101,-102,-102,-104,-105,-100, -98,-100, -98, -95, -90, -85, -79, -73, -67, -60, -55, -55, -54, -52, -40, -34, -30, -23, -19, -15, -10,  -7,  -5,  -3,   0,   6,  10,  14,  17,  21,  24,  28,  31,  35,  42,  47,  53,  53,  56,  60,  67,  65,  66,  67,  70,  64,  45,  60,  68,  68,  67,  67,  69,  66,  66,  67,  66,  66,  65,  64,  64,  64,  64,  63,  63,  61,  60,  59,  58,  57,  53,  53,  52,  52,  50,  49,  50,  48,  45,  43,  41,  38,  36,  35,  32,  31,  29,  29,  28,  28,  25,  27,  24,  23,  21,  21,  18,  18,  16,  16},
  /*   7.0 */ {  16,  15,  15,  15,  14,  11,  11,  11,  11,  11,  11,  12,  12,  13,  13,  14,  14,  14,  15,  15,  15,  15,  14,  13,  12,  11,  10,   9,   8,   7,   6,   5,   4,   3,   1,  -0,  -1,  -3,  -5,  -6,  -8, -10, -11, -13, -15, -16, -18, -20, -21, -23, -24, -25, -27, -28, -29, -30, -31, -32, -32, -33, -33, -34, -33, -34, -33, -33, -32, -31, -30, -29, -27, -26, -25, -23, -22, -20, -18, -16, -15, -13, -12, -10,  -9,  -8,  -7,  -6,  -5,  -3,  -2,  -1,   0,   1,   3,   5,   6,   8,  11,  11,  12,  12,  12,  12,  14,  17,  22,  14,   4,  11,   3,  -5,  -7,  -8, -10, -12, -10, -12, -16, -21, -24, -26, -27, -29, -30, -31, -32, -33, -33, -34, -39, -40, -40, -40, -39, -38, -35, -32, -30, -28, -25, -22, -19, -16, -13, -10,  -7,  -4,  -1,   1,   3,   4,   6,   7,   9,  10,  12,  13,  14,  15,  17,  17,  18,  19,  19,  20,  21,  22,  23,  27,  31,  31,  31,  32,  31,  30,  30,  28,  28,  28,  28,  27,  26,  27,  26,  25,  24,  23,  22,  22,  22,  21,  20,  20,  19,  17,  15,  12,   8,   6,   3,  -0,  -2,  -3,  -3,  -5,  -6,  -9,  -9,  -8,  -8, -10, -11, -11, -12, -13, -12, -12, -11, -11, -11, -11, -14, -19, -23, -25, -26, -28, -31, -33, -36, -39, -44, -51, -53, -54, -56, -54, -53, -54, -56, -57, -59, -62, -66, -70, -74, -78, -82, -85, -89, -91, -94, -96, -97, -97,-100,-100,-101,-101,-103,-103, -97, -93, -95, -96, -94, -90, -85, -79, -74, -67, -60, -56, -58, -59, -50, -42, -35, -31, -25, -21, -17, -14, -12,  -9,  -5,  -2,   3,   7,  11,  15,  18,  22,  26,  31,  33,  36,  44,  48,  52,  53,  55,  59,  67,  66,  69,  71,  62,  51,  62,  67,  67,  66,  66,  67,  68,  63,  63,  61,  64,  64,  63,  63,  63,  63,  62,  61,  60,  59,  58,  58,  53,  52,  55,  52,  50,  50,  48,  46,  49,  43,  41,  39,  37,  35,  33,  32,  30,  28,  26,  27,  26,  26,  26,  23,  22,  21,  19,  18,  17,  16,  16},
  /*   8.0 */ {  15,  14,  13,  13,  12,  10,  10,  10,  11,  11,  11,  12,  12,  13,  13,  13,  15,  14,  14,  13,  14,  13,  12,  11,  10,   9,   8,   7,   6,   6,   5,   4,   2,   1,  -0,  -1,  -3,  -4,  -6,  -8,  -9, -11, -13, -14, -16, -18, -19, -22, -23, -25, -26, -27, -29, -30, -31, -32, -33, -34, -35, -35, -35, -35, -35, -35, -35, -34, -33, -32, -31, -29, -28, -27, -25, -23, -22, -20, -18, -16, -15, -13, -12, -10,  -9,  -8,  -6,  -5,  -4,  -3,  -2,  -0,   1,   2,   4,   5,   7,   9,  11,  12,  14,  15,  15,  15,  15,  12,   9,   4,   2,   4,   0,  -5,  -9, -10, -11, -13, -14, -18, -21, -25, -27, -29, -30, -31, -33, -35, -37, -38, -37, -39, -43, -43, -42, -42, -40, -37, -35, -32, -30, -28, -25, -21, -18, -15, -12, -10,  -7,  -5,  -3,  -2,  -0,   2,   4,   6,   7,   9,  10,  12,  13,  15,  17,  19,  19,  19,  20,  21,  23,  24,  31,  33,  30,  32,  34,  35,  34,  31,  30,  29,  27,  28,  27,  26,  26,  26,  26,  26,  25,  25,  24,  24,  22,  21,  20,  19,  18,  16,  14,  12,   9,   6,   4,   2,  -1,  -1,  -2,  -3,  -5,  -5,  -6,  -7,  -7,  -9, -10, -10, -11, -12, -12, -10,  -8,  -8,  -9, -11, -12, -16, -19, -21, -22, -25, -28, -29, -31, -34, -39, -47, -52, -53, -54, -55, -52, -53, -54, -55, -58, -62, -66, -70, -74, -78, -81, -85, -88, -91, -93, -95, -96, -97, -99,-100,-100, -97, -99,-100, -96, -94, -95, -95, -92, -88, -84, -78, -73, -67, -62, -58, -58, -60, -49, -43, -36, -32, -27, -23, -19, -17, -14, -11,  -7,  -3,  -0,   4,   8,  13,  16,  20,  25,  29,  33,  36,  38,  46,  50,  52,  54,  56,  60,  67,  71,  71,  65,  55,  61,  65,  64,  64,  64,  64,  64,  63,  63,  65,  58,  63,  63,  62,  61,  62,  59,  60,  60,  59,  59,  58,  52,  50,  52,  49,  48,  49,  46,  44,  42,  41,  39,  37,  35,  33,  31,  30,  29,  28,  28,  27,  25,  26,  23,  22,  22,  20,  19,  18,  16,  16,  15},
  /*   9.0 */ {  14,  13,  13,  12,  11,  10,  10,  10,  11,  11,  11,  12,  12,  13,  13,  13,  13,  14,  13,  13,  12,  12,  11,  10,   9,   8,   7,   6,   5,   4,   3,   2,   1,  -0,  -1,  -3,  -4,  -6,  -7,  -9, -11, -12, -14, -15, -17, -19, -21, -23, -25, -26, -28, -29, -31, -32, -33, -34, -35, -36, -37, -37, -37, -37, -37, -37, -36, -35, -34, -33, -32, -30, -29, -27, -25, -23, -22, -20, -18, -16, -15, -13, -12, -10,  -9,  -8,  -6,  -5,  -3,  -2,  -1,   0,   1,   3,   4,   6,   6,   7,  10,  15,  13,  11,  12,  14,  10,   1,   2,  -2,  -2,  -2, -11,  -5,  -8, -12, -13, -15, -18, -23, -29, -33, -35, -34, -33, -36, -40, -40, -42, -44, -42, -44, -44, -43, -42, -41, -39, -37, -35, -33, -30, -26, -23, -20, -16, -14, -12, -10,  -8,  -6,  -4,  -3,  -1,   1,   3,   5,   7,   8,  10,  12,  13,  15,  16,  19,  20,  19,  21,  23,  25,  29,  32,  32,  30,  33,  34,  35,  34,  31,  29,  28,  27,  27,  26,  25,  24,  24,  25,  25,  24,  24,  25,  25,  23,  23,  21,  19,  19,  16,  14,  12,   9,   6,   4,   1,  -1,  -1,  -1,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -8,  -9, -10,  -8,  -4,  -7,  -7,  -7,  -8, -12, -12, -14, -17, -18, -22, -25, -27, -28, -30, -34, -42, -49, -51, -52, -53, -51, -51, -53, -55, -58, -62, -66, -70, -74, -77, -80, -84, -87, -90, -92, -94, -95, -96, -98, -99, -96, -96, -97, -97, -96, -95, -98, -95, -92, -88, -84, -78, -73, -67, -62, -61, -59, -61, -51, -44, -39, -34, -29, -25, -22, -20, -17, -13,  -9,  -6,  -3,   2,   6,  10,  13,  18,  23,  26,  31,  35,  38,  42,  49,  49,  54,  55,  53,  60,  64,  68,  68,  51,  60,  62,  62,  61,  61,  62,  61,  62,  62,  62,  59,  61,  60,  61,  60,  57,  55,  56,  56,  54,  54,  51,  56,  47,  51,  46,  43,  43,  43,  42,  40,  38,  35,  35,  34,  32,  30,  29,  30,  29,  28,  25,  28,  26,  22,  22,  20,  19,  18,  18,  16,  15,  14},
  /*  10.0 */ {  13,  12,  12,  11,  10,  10,  10,  10,  11,  12,  12,  12,  12,  13,  13,  15,  13,  13,  12,  11,  10,  10,   9,   8,   7,   6,   5,   5,   3,   2,   1,   0,  -1,  -2,  -3,  -4,  -5,  -7,  -8, -10, -11, -13, -15, -17, -19, -21, -23, -24, -26, -28, -29, -31, -32, -34, -35, -36, -37, -38, -38, -39, -39, -39, -39, -39, -38, -37, -36, -34, -33, -31, -29, -27, -26, -24, -22, -20, -18, -16, -15, -13, -12, -10,  -9,  -7,  -6,  -5,  -3,  -2,  -1,   0,   1,   3,   4,   4,   6,  10,  14,   9,   6,   3,   1,   1,  -2,  -4,  -3,  -5,  -4,  -1, -13, -14, -11, -13, -16, -17, -23, -28, -32, -40, -45, -43, -42, -41, -42, -44, -46, -45, -45, -45, -45, -44, -43, -41, -39, -37, -35, -32, -29, -26, -22, -19, -16, -15, -13, -11,  -9,  -7,  -5,  -3,  -1,   1,   3,   5,   6,   8,  10,  11,  13,  14,  16,  16,  17,  19,  21,  25,  29,  30,  31,  33,  32,  33,  33,  32,  32,  30,  28,  28,  27,  26,  25,  24,  23,  22,  24,  24,  23,  23,  24,  25,  24,  24,  22,  19,  18,  17,  15,  13,  10,   8,   6,   4,   2,   0,  -0,  -0,  -0,  -1,  -2,  -3,  -5,  -6,  -5,  -6,  -7,  -8,  -4,  -4,  -5,  -6,  -7,  -8, -10, -12, -13, -15, -18, -20, -23, -25, -26, -28, -32, -37, -44, -48, -50, -51, -50, -50, -51, -54, -58, -62, -66, -70, -72, -76, -79, -83, -85, -88, -91, -93, -94, -95, -97, -97, -95, -95, -95, -95, -96, -98, -97, -95, -91, -88, -84, -79, -74, -68, -63, -63, -61, -64, -53, -46, -42, -36, -32, -28, -25, -23, -19, -16, -12,  -9,  -5,  -1,   3,   8,  11,  15,  19,  24,  29,  32,  37,  40,  45,  50,  52,  56,  54,  62,  65,  65,  64,  50,  59,  60,  59,  59,  58,  58,  59,  60,  60,  60,  60,  55,  61,  56,  54,  52,  53,  55,  53,  51,  51,  46,  45,  44,  44,  42,  41,  41,  40,  39,  38,  36,  35,  36,  33,  32,  30,  28,  28,  26,  25,  26,  25,  23,  22,  21,  20,  19,  18,  16,  15,  14,  13},
  /*  11.0 */ {  12,  11,  11,  11,  11,  11,  11,  10,  11,  10,  12,  12,  12,  13,  13,  13,  13,  12,  11,  10,   9,   8,   8,   6,   6,   5,   4,   3,   2,   0,  -1,  -1,  -2,  -3,  -4,  -5,  -6,  -8,  -9, -11, -12, -15, -16, -18, -20, -22, -24, -26, -28, -29, -31, -32, -34, -35, -37, -38, -39, -40, -40, -41, -41, -41, -41, -40, -39, -38, -37, -35, -34, -32, -30, -28, -26, -24, -22, -20, -18, -16, -14, -13, -11, -10,  -9,  -7,  -6,  -5,  -3,  -2,  -0,   1,   2,   3,   1,  -1,   6,   8,   9,   6,   3,   1,  -1,  -2,  -4,  -6,  -9,  -9,   0,  -5, -13, -17, -17, -17, -22, -23, -26, -30, -30, -33, -39, -42, -46, -45, -45, -47, -47, -46, -45, -45, -45, -44, -43, -41, -39, -37, -35, -31, -27, -25, -22, -20, -18, -17, -15, -13, -11,  -8,  -6,  -4,  -2,   0,   2,   4,   7,   9,  10,  12,  14,  15,  16,  16,  17,  19,  20,  26,  28,  29,  31,  32,  35,  34,  32,  32,  31,  29,  29,  29,  28,  26,  25,  24,  23,  23,  22,  23,  22,  21,  22,  22,  22,  22,  21,  19,  18,  16,  15,  13,  11,  10,   8,   6,   4,   3,   3,   2,   2,   0,  -1,  -2,  -3,  -3,  -2,  -3,  -5,  -5,  -4,  -5,  -5,  -3,  -6,  -7,  -9, -11, -12, -13, -17, -20, -21, -24, -25, -28, -28, -33, -40, -44, -47, -48, -48, -49, -52, -54, -58, -62, -65, -68, -71, -75, -78, -81, -84, -87, -90, -91, -92, -93, -95, -94, -92, -94, -94, -93, -93, -99, -96, -93, -90, -88, -84, -79, -74, -68, -64, -63, -61, -63, -53, -48, -44, -38, -34, -30, -28, -25, -22, -18, -15, -12,  -8,  -3,   1,   6,   9,  12,  16,  20,  25,  30,  35,  39,  42,  48,  52,  54,  55,  60,  62,  65,  55,  52,  57,  58,  57,  56,  56,  56,  56,  58,  58,  58,  59,  50,  51,  43,  38,  41,  46,  51,  50,  50,  47,  46,  44,  43,  42,  41,  40,  39,  37,  39,  36,  34,  34,  33,  32,  29,  29,  27,  27,  28,  26,  23,  25,  22,  21,  20,  19,  17,  16,  15,  14,  13,  12},
  /*  12.0 */ {  11,  10,  11,  11,  11,  11,  10,  11,  11,  10,  11,  12,  12,  12,  12,  12,  11,  10,  10,   9,   8,   8,   6,   5,   5,   4,   3,   2,   0,  -1,  -2,  -2,  -3,  -4,  -5,  -6,  -8,  -9, -10, -12, -13, -15, -18, -19, -21, -23, -25, -27, -29, -31, -32, -34, -35, -37, -38, -39, -40, -41, -42, -42, -42, -42, -42, -41, -40, -39, -38, -36, -35, -33, -31, -29, -27, -25, -22, -20, -18, -16, -14, -12, -10,  -9,  -8,  -7,  -6,  -5,  -3,  -2,  -1,  -0,  -2,  -3,  -2,  -0,   6,   9,   7,   6,   3,   3,   0,  -2,  -4,  -6, -10, -16, -20, -18, -16, -22, -23, -25, -26, -30, -34, -36, -32, -38, -38, -43, -49, -49, -45, -48, -47, -46, -45, -45, -44, -43, -42, -41, -38, -35, -32, -29, -26, -24, -22, -20, -19, -17, -15, -13, -11,  -9,  -6,  -4,  -2,   1,   3,   6,   8,  10,  12,  14,  15,  15,  16,  18,  19,  20,  21,  27,  28,  29,  30,  30,  33,  33,  33,  32,  31,  29,  29,  29,  28,  27,  26,  25,  24,  24,  22,  22,  20,  20,  21,  21,  22,  21,  21,  19,  17,  16,  14,  13,  12,  11,   8,   7,   5,   5,   5,   5,   4,   3,   1,  -0,  -0,  -0,  -1,  -1,  -3,  -4,  -5,  -5,  -4,  -2,  -2,  -3,  -8,  -9, -10, -12, -15, -17, -19, -21, -23, -26, -28, -30, -34, -37, -41, -43, -45, -46, -51, -54, -57, -60, -63, -67, -70, -73, -76, -79, -82, -85, -88, -89, -90, -92, -93, -91, -90, -89, -91, -91, -93, -96, -95, -92, -89, -87, -83, -79, -74, -69, -64, -63, -62, -62, -54, -49, -46, -39, -36, -32, -29, -27, -24, -20, -17, -14, -10,  -5,   1,   4,   6,   9,  13,  18,  22,  27,  31,  36,  38,  43,  49,  51,  52,  55,  58,  60,  47,  52,  55,  55,  55,  54,  54,  54,  54,  55,  56,  56,  56,  54,  53,  48,  46,  48,  38,  35,  42,  47,  47,  46,  45,  43,  41,  40,  39,  38,  36,  34,  33,  33,  32,  30,  31,  28,  27,  30,  26,  26,  23,  23,  22,  20,  19,  18,  17,  16,  14,  14,  13,  12,  11},
  /*  13.0 */ {  10,  10,  11,  11,  10,  10,  10,  10,  10,  10,  10,  10,  12,  12,  12,  11,  11,  10,   8,   8,   7,   6,   5,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -4,  -4,  -5,  -6,  -7,  -9, -10, -11, -13, -14, -16, -18, -20, -22, -24, -26, -28, -30, -32, -34, -35, -37, -38, -39, -41, -42, -43, -43, -43, -43, -43, -43, -42, -41, -40, -39, -37, -35, -33, -31, -30, -28, -25, -23, -20, -18, -16, -14, -12, -11,  -9,  -8,  -7,  -6,  -5,  -4,  -4,  -6,  -5,  -3,  -1,  -0,   4,   7,   7,   6,   5,   2,   0,  -2,  -4,  -6,  -8, -11, -17, -22, -24, -26, -26, -30, -35, -38, -40, -40, -37, -35, -38, -42, -39, -48, -48, -46, -47, -46, -46, -45, -44, -44, -43, -41, -40, -37, -34, -31, -27, -25, -24, -22, -20, -18, -17, -15, -13, -11,  -9,  -6,  -3,  -1,   2,   4,   7,   9,  11,  13,  14,  16,  16,  17,  19,  20,  21,  23,  29,  30,  31,  31,  31,  31,  31,  32,  33,  31,  29,  28,  28,  28,  27,  26,  26,  25,  24,  23,  22,  21,  20,  19,  20,  21,  21,  20,  19,  17,  15,  14,  13,  12,  11,  10,   8,   7,   6,   7,   7,   8,   6,   4,   2,   2,   2,   1,  -1,  -2,  -2,  -4,  -4,  -3,  -3,  -1,  -2,  -5,  -8,  -9, -11, -11, -15, -18, -19, -21, -23, -26, -28, -31, -34, -37, -40, -42, -44, -47, -52, -57, -59, -62, -65, -68, -71, -74, -77, -80, -83, -86, -87, -88, -89, -89, -91, -88, -86, -87, -89, -92, -93, -92, -90, -87, -86, -82, -78, -73, -69, -65, -62, -62, -61, -57, -50, -47, -41, -38, -34, -32, -29, -25, -22, -20, -16, -12,  -7,  -2,   1,   3,   6,  11,  15,  19,  24,  28,  32,  36,  38,  38,  47,  50,  51,  53,  46,  45,  51,  53,  53,  52,  52,  52,  52,  52,  54,  54,  55,  55,  54,  53,  52,  53,  54,  53,  46,  32,  40,  47,  46,  44,  42,  41,  39,  38,  36,  34,  35,  32,  31,  30,  30,  29,  28,  26,  26,  24,  22,  21,  20,  20,  18,  17,  16,  15,  14,  14,  13,  12,  12,  10},
  /*  14.0 */ {   9,  10,  10,  10,   9,   9,   9,   9,   9,   9,  10,  11,  11,  11,  11,  10,  10,   9,   8,   7,   6,   5,   4,   3,   2,   1,  -0,  -2,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -8, -10, -11, -12, -14, -15, -17, -19, -21, -23, -25, -27, -29, -32, -33, -35, -36, -38, -39, -40, -42, -43, -44, -44, -44, -44, -44, -44, -43, -42, -41, -39, -37, -36, -34, -32, -30, -28, -25, -23, -21, -18, -16, -14, -13, -11,  -9,  -8,  -7,  -6,  -6,  -9,  -7,  -4,  -3,   0,   3,   4,   5,   6,   6,   3,   2,   1,  -1,  -3,  -6,  -8, -12, -15, -18, -21, -23, -25, -29, -33, -35, -36, -37, -37, -37, -37, -38, -41, -39, -47, -53, -49, -48, -48, -47, -46, -44, -43, -42, -41, -38, -35, -32, -29, -26, -25, -23, -21, -20, -18, -16, -14, -11,  -9,  -7,  -5,  -2,   0,   3,   6,   8,  10,  13,  15,  17,  18,  18,  19,  20,  21,  24,  26,  29,  30,  30,  31,  32,  30,  31,  31,  31,  30,  29,  29,  28,  29,  27,  25,  25,  24,  23,  23,  22,  21,  20,  19,  19,  20,  20,  20,  19,  17,  15,  14,  14,  13,  11,  10,   9,   8,   8,  10,   9,   9,   7,   5,   4,   4,   3,   2,   1,  -0,  -1,  -2,  -2,  -3,  -5,  -5,  -2,  -4,  -6,  -8, -10,  -8, -10, -14, -17, -19, -22, -24, -26, -29, -31, -34, -36, -39, -41, -45, -51, -54, -58, -60, -63, -66, -69, -72, -75, -78, -81, -83, -84, -86, -87, -86, -88, -86, -85, -87, -89, -90, -92, -91, -88, -86, -86, -80, -77, -73, -69, -65, -62, -62, -60, -59, -51, -46, -42, -38, -35, -33, -30, -27, -24, -21, -18, -14,  -9,  -4,  -2,  -0,   3,   8,  12,  17,  21,  26,  30,  34,  34,  36,  44,  48,  50,  52,  44,  46,  50,  50,  50,  50,  50,  50,  50,  51,  52,  52,  53,  53,  53,  53,  53,  53,  54,  55,  55,  43,  32,  43,  44,  43,  42,  40,  38,  37,  34,  36,  34,  31,  30,  29,  30,  27,  26,  27,  24,  24,  24,  22,  19,  18,  17,  16,  14,  14,  14,  14,  12,  11,   9,   9},
  /*  15.0 */ {   9,   9,   8,   9,   8,   8,   8,   8,   8,   9,   8,  10,  10,  11,  10,  10,   9,   8,   7,   6,   5,   4,   3,   3,   2,   1,  -1,  -2,  -3,  -4,  -4,  -5,  -6,  -8,  -9, -10, -12, -13, -14, -15, -17, -18, -20, -22, -24, -26, -28, -31, -33, -35, -36, -38, -39, -40, -41, -42, -44, -44, -45, -45, -45, -45, -44, -44, -42, -41, -39, -38, -36, -34, -32, -31, -29, -26, -23, -21, -19, -17, -15, -13, -11, -10,  -9,  -9,  -9, -10,  -5,  -5,   1,   4,   2,   2,   2,   4,   4,   3,   1,  -1,  -1,  -3,  -6,  -8, -10, -14, -15, -18, -21, -21, -24, -28, -30, -32, -35, -37, -38, -40, -39, -40, -42, -40, -55, -56, -49, -50, -49, -49, -47, -44, -43, -41, -38, -36, -33, -31, -28, -26, -25, -23, -21, -19, -17, -15, -13, -10,  -8,  -5,  -3,  -0,   3,   5,   8,  10,  13,  15,  18,  20,  25,  25,  21,  22,  23,  25,  28,  30,  29,  31,  32,  33,  29,  30,  30,  30,  29,  28,  28,  28,  29,  28,  26,  24,  22,  22,  23,  22,  21,  21,  20,  19,  19,  20,  20,  19,  17,  15,  15,  14,  13,  12,  10,  10,  10,   9,  11,  11,  10,   9,   7,   7,   6,   5,   4,   3,   2,   0,   0,   0,  -1,  -3,  -3,   1,  -4,  -6,  -7,  -9,  -5,  -8, -12, -15, -16, -18, -21, -24, -27, -29, -32, -34, -37, -40, -45, -50, -54, -57, -58, -61, -64, -67, -70, -73, -76, -79, -81, -82, -84, -83, -84, -83, -84, -85, -87, -88, -87, -88, -89, -87, -84, -83, -79, -76, -72, -69, -64, -61, -60, -62, -56, -50, -47, -43, -39, -36, -34, -31, -29, -27, -24, -21, -17, -12,  -7,  -5,  -3,   2,   6,   9,  14,  18,  23,  27,  31,  32,  41,  43,  41,  42,  44,  42,  45,  47,  47,  48,  48,  48,  48,  49,  49,  50,  51,  51,  52,  52,  52,  52,  52,  54,  55,  55,  50,  37,  40,  43,  44,  42,  40,  38,  36,  35,  31,  30,  29,  29,  29,  28,  25,  26,  24,  23,  22,  19,  18,  19,  16,  15,  14,  13,  13,  12,  12,  11,  10,   9,   9},
  /*  16.0 */ {   7,   7,   8,   8,   8,   8,   8,   8,   8,   9,  10,  10,  10,   9,  10,   9,   8,   8,   7,   6,   5,   4,   4,   4,   3,   1,  -0,  -2,  -3,  -4,  -5,  -6,  -7,  -8, -10, -11, -13, -14, -16, -17, -19, -21, -22, -24, -26, -27, -29, -32, -34, -35, -37, -39, -40, -41, -42, -43, -44, -45, -45, -46, -46, -45, -45, -44, -43, -42, -40, -38, -36, -34, -33, -31, -29, -26, -24, -21, -19, -17, -15, -15, -14, -12,  -8,  -3,  -3,  -8,  -6,  -2,  -2,  -3,  -2,  -1,  -3,  -2,  -0,  -1,  -2,  -2,  -4,  -5,  -7, -10, -13, -15, -17, -19, -23, -25, -27, -29, -31, -34, -37, -39, -41, -42, -42, -41, -41, -42, -61, -55, -49, -46, -46, -47, -46, -44, -42, -40, -38, -34, -32, -29, -27, -25, -24, -22, -20, -18, -16, -14, -11,  -8,  -5,  -3,  -1,   3,   5,   8,  10,  13,  15,  17,  19,  21,  23,  31,  25,  24,  25,  26,  27,  30,  30,  32,  33,  32,  28,  28,  29,  29,  28,  28,  28,  28,  29,  29,  28,  27,  24,  23,  24,  23,  21,  22,  21,  21,  21,  21,  21,  19,  17,  17,  15,  14,  13,  12,  11,  10,  11,  11,  11,  12,  11,  10,   9,   8,   7,   6,   5,   5,   3,   2,   2,   1,   0,   0,   1,  -1,  -3,  -4,  -5,  -6,  -5,  -9, -12, -15, -17, -19, -21, -23, -26, -29, -31, -33, -36, -40, -44, -47, -52, -56, -56, -59, -62, -65, -67, -70, -74, -75, -78, -80, -80, -80, -80, -80, -81, -83, -85, -85, -83, -81, -82, -84, -83, -81, -78, -75, -72, -68, -64, -61, -60, -61, -56, -51, -47, -44, -40, -37, -35, -32, -31, -30, -27, -23, -19, -14, -12,  -9,  -6,  -1,   4,   7,  13,  16,  20,  24,  29,  31,  41,  43,  38,  33,  41,  44,  45,  45,  45,  45,  46,  46,  46,  46,  47,  49,  49,  50,  51,  51,  51,  52,  52,  53,  54,  54,  53,  40,  36,  43,  42,  41,  41,  37,  35,  36,  31,  30,  29,  28,  28,  25,  24,  26,  23,  22,  20,  20,  18,  17,  16,  15,  13,  12,  12,  11,  11,  10,   9,   8,   7},
  /*  17.0 */ {   7,   7,   6,   7,   7,   8,   8,   8,   9,   9,  10,  10,  10,   9,   9,   8,   8,   7,   6,   6,   6,   5,   5,   5,   4,   2,   0,  -1,  -3,  -4,  -5,  -7,  -8,  -9, -10, -12, -14, -15, -17, -19, -21, -22, -23, -25, -27, -29, -31, -33, -35, -36, -38, -39, -40, -42, -43, -44, -45, -45, -46, -46, -46, -46, -45, -44, -44, -42, -40, -39, -37, -35, -33, -31, -30, -27, -24, -22, -20, -20, -19, -14,  -8,  -5,  -3,  -2,  -6,  -9,  -7,  -5,  -5,  -6,  -5,  -4,  -5,  -9,  -9,  -8,  -6,  -6,  -7,  -8, -10, -12, -14, -17, -19, -21, -25, -29, -30, -33, -38, -41, -43, -44, -45, -45, -43, -42, -41, -56, -62, -53, -49, -49, -48, -47, -44, -42, -41, -39, -36, -34, -31, -28, -25, -24, -22, -21, -19, -17, -15, -13, -10,  -7,  -4,  -1,   2,   5,   8,  10,  13,  15,  16,  18,  21,  29,  25,  27,  25,  25,  26,  27,  27,  30,  32,  32,  34,  30,  27,  27,  28,  28,  28,  28,  28,  27,  28,  29,  28,  28,  27,  26,  25,  24,  22,  23,  22,  22,  22,  24,  23,  21,  20,  19,  17,  15,  14,  13,  11,  10,  11,  11,  12,  13,  12,  11,  10,  10,   8,   8,   7,   5,   4,   4,   3,   3,   2,   1,   0,  -1,  -2,  -3,  -4,  -4,  -4,  -8, -12, -16, -20, -22, -23, -24, -25, -28, -32, -34, -36, -39, -42, -44, -50, -55, -55, -56, -59, -62, -64, -69, -71, -72, -75, -77, -76, -77, -78, -77, -78, -79, -79, -80, -80, -77, -75, -78, -80, -80, -77, -73, -71, -67, -63, -61, -60, -60, -58, -51, -48, -44, -41, -38, -37, -33, -32, -30, -27, -25, -20, -17, -15, -11,  -8,  -5,   1,   4,   8,  12,  16,  21,  25,  28,  34,  43,  41,  33,  40,  43,  42,  42,  43,  43,  44,  44,  44,  44,  45,  47,  48,  49,  50,  50,  51,  51,  51,  52,  53,  52,  49,  38,  31,  40,  44,  40,  41,  37,  37,  32,  31,  30,  28,  27,  26,  24,  23,  24,  21,  20,  19,  18,  17,  16,  14,  13,  12,  11,  11,  10,   9,   9,   8,   7,   7},
  /*  18.0 */ {   6,   6,   6,   7,   8,   9,   9,   8,   9,   9,   9,  10,   9,   9,   8,   8,   8,   7,   7,   7,   7,   7,   7,   6,   3,   1,  -1,  -2,  -3,  -5,  -6,  -7,  -8, -10, -11, -13, -15, -16, -18, -20, -22, -23, -25, -26, -28, -30, -32, -34, -36, -37, -39, -40, -41, -42, -43, -44, -45, -46, -46, -47, -47, -46, -46, -45, -44, -42, -41, -39, -37, -35, -33, -32, -30, -28, -25, -23, -23, -18, -14,  -9,  -7,  -6,  -4,  -6, -12, -11, -13, -11, -10,  -8,  -7,  -6,  -8, -11, -11, -12, -12, -13, -11, -12, -15, -16, -15, -15, -20, -23, -25, -28, -29, -34, -38, -41, -45, -42, -42, -45, -46, -43, -49, -62, -58, -51, -48, -47, -45, -44, -42, -41, -39, -38, -35, -33, -30, -27, -24, -23, -21, -19, -18, -16, -14, -12,  -9,  -6,  -3,  -0,   3,   6,   9,  12,  14,  16,  18,  20,  22,  24,  25,  25,  26,  27,  26,  26,  26,  28,  33,  32,  35,  31,  30,  29,  28,  28,  28,  27,  27,  27,  27,  27,  29,  29,  29,  28,  27,  26,  24,  23,  23,  23,  24,  27,  25,  23,  22,  20,  18,  16,  15,  15,  13,  12,  12,  11,  11,  12,  13,  12,  11,  11,   9,   8,   7,   6,   6,   5,   4,   4,   4,   3,   0,  -1,  -1,  -2,  -2,  -0,  -4,  -9, -14, -18, -22, -25, -27, -28, -29, -32, -34, -34, -35, -36, -40, -44, -48, -54, -53, -54, -56, -58, -62, -66, -66, -69, -72, -70, -71, -75, -74, -75, -75, -75, -75, -75, -75, -75, -72, -70, -72, -76, -74, -71, -69, -67, -63, -60, -59, -59, -55, -50, -48, -44, -42, -39, -37, -34, -32, -32, -30, -25, -21, -19, -16, -13,  -8,  -6,  -4,   1,   5,   9,  13,  18,  22,  25,  31,  39,  37,  31,  36,  38,  40,  40,  41,  41,  41,  42,  42,  43,  43,  45,  46,  47,  48,  49,  50,  50,  50,  52,  51,  50,  44,  37,  31,  39,  41,  43,  38,  36,  33,  32,  30,  28,  26,  25,  24,  22,  21,  21,  20,  19,  18,  18,  16,  14,  12,  15,  12,  11,  10,   9,   8,   7,   7,   6,   6},
  /*  19.0 */ {   5,   5,   5,   5,   6,   7,   8,   9,   8,  10,   9,  10,   9,   9,   8,   8,   8,   8,   7,   8,   7,   7,   7,   6,  13,   8,  -2,  -2,  -3,  -5,  -7,  -8,  -9, -10, -12, -14, -16, -17, -19, -21, -22, -24, -25, -27, -29, -31, -33, -35, -36, -38, -39, -40, -42, -43, -44, -44, -46, -46, -47, -47, -47, -47, -46, -45, -44, -43, -41, -39, -37, -35, -34, -32, -30, -28, -28, -25, -19, -16, -13, -11,  -7,  -5,  -4,  -6, -13, -13, -14, -12, -11, -10,  -9,  -7,  -7, -12, -12, -14, -13, -14, -16, -16, -20, -22, -24, -26, -27, -27, -27, -28, -27, -29, -36, -44, -55, -62, -61, -55, -55, -61, -62, -57, -52, -48, -48, -47, -45, -43, -41, -40, -39, -37, -34, -32, -29, -25, -23, -21, -19, -17, -16, -14, -12, -10,  -8,  -5,  -2,   1,   4,   8,  11,  14,  15,  17,  18,  20,  22,  23,  24,  26,  27,  27,  26,  26,  26,  29,  33,  34,  35,  32,  31,  31,  30,  28,  28,  27,  26,  26,  26,  27,  28,  30,  31,  30,  30,  28,  26,  25,  24,  23,  25,  28,  26,  25,  23,  21,  19,  18,  18,  18,  17,  16,  13,  11,  11,  12,  13,  12,  12,  13,  11,   9,   8,   8,   7,   6,   5,   5,   5,   5,   2,   1,  -0,  -1,   1,  -0,  -5, -10, -15, -19, -23, -27, -29, -31, -32, -34, -36, -37, -36, -35, -37, -42, -43, -50, -50, -52, -54, -56, -58, -60, -63, -67, -65, -67, -69, -69, -70, -70, -71, -72, -71, -72, -72, -70, -68, -65, -67, -67, -70, -68, -67, -65, -63, -60, -60, -57, -51, -49, -48, -44, -41, -39, -38, -35, -33, -31, -29, -27, -24, -21, -18, -14, -10,  -7,  -4,   0,   4,   7,  10,  15,  19,  22,  24,  30,  33,  30,  33,  35,  37,  38,  39,  39,  40,  40,  40,  41,  42,  43,  45,  46,  47,  49,  49,  49,  49,  51,  50,  48,  42,  35,  33,  38,  38,  38,  37,  35,  33,  31,  29,  26,  25,  23,  22,  21,  20,  19,  17,  19,  15,  17,  14,  12,  11,  10,   9,   9,   7,   7,   7,   6,   6,   6,   5},
  /*  20.0 */ {   4,   5,   4,   4,   4,   5,   6,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,   8,   8,   7,   5,   6,  18,  12,  -2,  -3,  -4,  -5,  -7,  -8, -10, -11, -13, -15, -17, -18, -20, -22, -23, -24, -26, -28, -29, -31, -33, -35, -36, -38, -39, -41, -42, -43, -44, -45, -46, -47, -47, -48, -48, -47, -46, -46, -44, -43, -41, -40, -38, -36, -34, -32, -30, -29, -29, -21, -16, -14, -12, -10,  -7,  -6,  -6, -10, -15, -19, -17, -16, -13, -12, -11, -10,  -9, -13, -16, -15, -17, -17, -18, -19, -19, -21, -23, -25, -26, -27, -36, -37, -41, -45, -47, -51, -59, -62, -65, -63, -59, -57, -53, -50, -47, -46, -45, -46, -45, -43, -41, -40, -38, -36, -33, -30, -27, -24, -21, -18, -17, -15, -14, -12, -10,  -8,  -6,  -4,  -1,   2,   6,   9,  13,  15,  17,  18,  19,  20,  21,  23,  23,  25,  26,  25,  25,  26,  28,  31,  33,  34,  34,  34,  33,  32,  30,  29,  27,  27,  27,  27,  27,  27,  29,  30,  31,  31,  32,  30,  28,  27,  25,  24,  25,  27,  27,  25,  23,  21,  20,  20,  22,  23,  24,  20,  14,  12,  12,  12,  13,  14,  14,  14,  12,  11,  10,   9,   9,   8,   7,   6,   7,   6,   3,   2,   2,   2,   3,  -1,  -5, -10, -15, -20, -24, -28, -31, -33, -34, -35, -36, -37, -35, -33, -35, -39, -43, -48, -49, -50, -52, -55, -56, -57, -61, -63, -61, -64, -65, -66, -66, -67, -67, -67, -68, -68, -68, -67, -65, -65, -63, -63, -64, -64, -62, -61, -60, -57, -55, -53, -50, -51, -48, -44, -42, -39, -37, -35, -34, -31, -30, -28, -25, -23, -21, -17, -13,  -9,  -6,  -2,   2,   5,   9,  13,  17,  20,  21,  22,  31,  28,  31,  33,  34,  35,  36,  37,  38,  38,  39,  40,  41,  42,  44,  45,  47,  48,  49,  49,  49,  50,  49,  47,  41,  31,  36,  41,  41,  37,  36,  33,  31,  28,  28,  27,  24,  21,  22,  21,  19,  18,  15,  14,  13,  13,  11,  10,   9,   7,   8,   6,   6,   5,   7,   5,   5,   4,   4},
  /*  21.0 */ {   3,   2,   2,   2,   3,   4,   5,   6,   7,   8,   8,   9,   9,  10,   9,   9,   9,   9,   8,   7,   6,   6,  12,  15,  10,  -0,  -2,  -3,  -4,  -6,  -8,  -9, -11, -12, -14, -16, -17, -19, -20, -22, -23, -25, -27, -28, -30, -32, -34, -35, -36, -38, -40, -41, -42, -43, -45, -46, -46, -47, -48, -48, -47, -47, -47, -46, -45, -43, -42, -40, -38, -36, -34, -32, -31, -30, -28, -22, -18, -15, -13, -11, -10, -10, -13, -15, -19, -22, -21, -21, -14, -13, -14, -12, -12, -11, -18, -19, -20, -20, -22, -23, -24, -21, -23, -25, -29, -34, -42, -44, -46, -44, -48, -51, -51, -51, -52, -52, -51, -51, -51, -50, -49, -47, -45, -44, -44, -42, -41, -39, -36, -34, -31, -29, -26, -22, -19, -16, -15, -13, -12, -10,  -8,  -6,  -4,  -2,   1,   4,   7,  11,  14,  16,  17,  18,  18,  19,  20,  21,  22,  23,  24,  24,  24,  25,  28,  32,  35,  36,  35,  35,  35,  33,  32,  30,  29,  28,  27,  27,  27,  27,  29,  29,  30,  31,  32,  32,  30,  29,  28,  26,  26,  28,  27,  25,  24,  22,  21,  22,  25,  29,  30,  24,  17,  14,  13,  13,  13,  15,  15,  14,  13,  11,  10,   9,  10,   9,   9,   9,   8,   6,   4,   3,   4,   6,   4,  -0,  -4,  -8, -13, -19, -24, -28, -31, -33, -35, -35, -36, -36, -35, -34, -33, -35, -40, -43, -46, -48, -50, -55, -55, -57, -58, -57, -57, -59, -61, -62, -63, -63, -63, -63, -64, -64, -65, -65, -64, -64, -62, -60, -60, -62, -59, -58, -57, -56, -54, -52, -51, -52, -48, -43, -42, -39, -37, -36, -34, -32, -31, -29, -27, -24, -22, -19, -15, -11,  -8,  -4,  -1,   3,   8,  12,  15,  18,  19,  21,  28,  26,  29,  31,  33,  34,  35,  36,  36,  37,  38,  39,  40,  41,  42,  45,  46,  47,  48,  48,  48,  49,  48,  44,  35,  29,  38,  37,  36,  34,  33,  33,  29,  30,  26,  25,  23,  19,  19,  18,  16,  16,  14,  12,  12,  10,   9,   8,   7,   6,   5,   4,   5,   4,   5,   6,   4,   4,   3},
  /*  22.0 */ {   1,   1,   1,   1,   2,   3,   4,   5,   6,   7,   8,   8,   9,   9,   9,   9,   8,   8,   7,   8,  14,  11,   7,   2,  -1,  -0,  -1,  -3,  -5,  -7,  -9, -10, -11, -13, -15, -16, -18, -20, -21, -23, -24, -25, -27, -29, -31, -32, -34, -35, -36, -38, -39, -41, -42, -43, -45, -45, -46, -47, -47, -48, -47, -47, -47, -46, -45, -43, -42, -40, -38, -37, -35, -33, -31, -29, -25, -22, -18, -15, -13, -12, -12, -14, -16, -19, -24, -26, -24, -24, -18, -16, -15, -15, -14, -13, -18, -20, -19, -17, -18, -20, -21, -23, -24, -29, -32, -37, -38, -42, -43, -49, -51, -51, -51, -51, -52, -52, -52, -52, -51, -50, -50, -49, -47, -45, -44, -42, -40, -38, -36, -34, -31, -27, -24, -21, -17, -14, -13, -11, -10,  -8,  -6,  -4,  -2,   0,   3,   6,   9,  11,  14,  15,  17,  17,  17,  18,  19,  20,  22,  23,  24,  24,  24,  25,  27,  33,  36,  36,  36,  37,  37,  35,  33,  32,  30,  29,  27,  26,  25,  25,  27,  29,  30,  31,  32,  32,  31,  32,  31,  30,  30,  30,  27,  27,  25,  24,  23,  24,  26,  28,  28,  26,  20,  17,  15,  13,  13,  15,  15,  14,  13,  12,  11,  10,   9,   9,  10,  11,   8,   6,   5,   4,   6,   6,   4,   1,  -2,  -6, -10, -16, -23, -27, -31, -33, -34, -34, -34, -35, -35, -33, -32, -32, -36, -41, -42, -45, -44, -49, -52, -53, -54, -54, -54, -56, -58, -60, -60, -60, -61, -60, -59, -60, -60, -61, -62, -62, -60, -58, -58, -59, -58, -57, -57, -56, -54, -51, -51, -51, -48, -44, -42, -40, -38, -37, -34, -33, -30, -30, -29, -26, -23, -20, -17, -14, -10,  -6,  -2,   1,   5,  10,  14,  17,  19,  22,  23,  24,  27,  28,  30,  32,  34,  35,  35,  36,  37,  38,  39,  40,  41,  44,  45,  47,  48,  47,  49,  47,  43,  33,  26,  32,  37,  37,  36,  34,  32,  30,  27,  26,  23,  22,  20,  19,  17,  16,  15,  13,  11,  10,   8,   7,   7,   6,   5,   4,   3,   3,   2,   4,   2,   2,   3,   2,   1},
  /*  23.0 */ {  -1,  -1,  -0,   1,   1,   2,   3,   4,   5,   6,   7,   7,   7,   6,   7,   8,  10,  11,  12,   7,   4,   4,   3,   3,   3,   2,  -0,  -3,  -6,  -8,  -9, -11, -12, -14, -16, -17, -18, -20, -21, -22, -24, -26, -27, -29, -31, -33, -34, -35, -36, -38, -40, -41, -42, -43, -45, -46, -46, -47, -47, -48, -47, -47, -46, -46, -45, -43, -42, -40, -39, -37, -33, -33, -31, -28, -25, -21, -18, -16, -14, -13, -13, -16, -18, -22, -26, -29, -27, -26, -27, -25, -20, -16, -17, -18, -19, -23, -23, -22, -22, -23, -24, -25, -24, -27, -30, -36, -39, -44, -47, -49, -50, -51, -51, -52, -52, -52, -53, -53, -52, -51, -50, -49, -47, -46, -44, -42, -39, -37, -34, -31, -29, -26, -22, -19, -16, -12, -11,  -9,  -8,  -6,  -4,  -2,  -1,   2,   4,   7,   9,  11,  13,  15,  16,  17,  17,  18,  20,  21,  22,  23,  24,  25,  26,  27,  29,  33,  36,  38,  37,  39,  38,  36,  35,  33,  31,  29,  28,  26,  25,  25,  27,  27,  30,  32,  32,  33,  33,  34,  36,  34,  33,  31,  29,  29,  27,  25,  25,  26,  27,  27,  27,  25,  22,  19,  16,  14,  14,  14,  15,  14,  13,  13,  11,  10,  10,   9,  11,  11,   8,   7,   6,   6,   7,   6,   5,   2,   0,  -3,  -8, -13, -20, -26, -30, -32, -33, -33, -33, -33, -33, -30, -28, -30, -38, -40, -43, -46, -45, -47, -47, -48, -50, -51, -52, -53, -55, -56, -57, -56, -57, -58, -59, -60, -58, -59, -60, -60, -57, -55, -56, -56, -57, -56, -56, -55, -54, -51, -51, -51, -48, -44, -43, -41, -39, -37, -35, -33, -31, -30, -29, -28, -26, -22, -19, -15, -12,  -8,  -4,  -0,   4,   8,  13,  16,  19,  26,  20,  17,  19,  22,  26,  30,  32,  34,  35,  36,  37,  38,  39,  40,  39,  42,  44,  46,  47,  48,  47,  40,  33,  27,  31,  35,  36,  35,  34,  31,  29,  31,  25,  24,  23,  21,  19,  15,  14,  13,  12,  11,   9,   8,   7,   5,   4,   3,   2,   2,   1,   1,   1,  -0,   1,   0,  -0,  -1,  -1},
  /*  24.0 */ {  -2,  -2,  -1,  -0,   0,   2,   2,   3,   4,   4,   4,   6,   7,  12,  14,  10,   7,   5,   5,   4,   4,   4,   4,   3,   2,   1,  -2,  -5,  -7,  -9, -10, -11, -13, -14, -16, -17, -19, -20, -21, -22, -24, -26, -28, -29, -31, -33, -34, -36, -37, -39, -40, -41, -42, -43, -44, -45, -46, -47, -47, -47, -47, -47, -46, -45, -44, -43, -42, -41, -37, -35, -33, -33, -30, -27, -22, -19, -18, -17, -15, -14, -13, -18, -20, -23, -28, -31, -31, -28, -28, -29, -28, -24, -21, -23, -24, -26, -25, -25, -26, -26, -26, -27, -27, -32, -34, -39, -43, -45, -48, -50, -51, -52, -52, -52, -51, -52, -52, -53, -52, -51, -50, -49, -47, -46, -44, -41, -39, -36, -34, -31, -28, -25, -21, -17, -13, -11,  -9,  -7,  -5,  -3,  -2,   0,   2,   3,   5,   7,   9,  11,  14,  16,  17,  18,  19,  20,  20,  22,  23,  24,  25,  27,  28,  30,  31,  33,  35,  37,  40,  39,  38,  38,  36,  34,  33,  31,  30,  29,  27,  26,  26,  28,  29,  31,  32,  33,  34,  36,  37,  37,  35,  34,  33,  30,  28,  26,  26,  26,  27,  27,  26,  25,  22,  20,  17,  15,  14,  15,  14,  14,  13,  13,  12,  12,  11,  10,  11,  11,   9,   8,   8,   8,   8,   8,   6,   4,   2,  -2,  -5, -11, -18, -24, -28, -31, -33, -33, -33, -33, -30, -27, -30, -36, -37, -39, -42, -45, -47, -48, -45, -46, -46, -48, -48, -49, -51, -52, -53, -54, -55, -55, -56, -58, -58, -59, -59, -59, -58, -57, -56, -55, -56, -56, -55, -55, -55, -52, -51, -51, -49, -46, -43, -41, -39, -37, -36, -33, -32, -32, -31, -29, -27, -24, -20, -17, -13, -10,  -6,  -2,   2,   6,  10,  14,  17,  24,  15,  18,  21,  23,  27,  25,  29,  32,  35,  36,  37,  37,  37,  38,  39,  42,  44,  45,  46,  48,  44,  35,  29,  36,  37,  35,  34,  32,  33,  30,  28,  25,  24,  21,  20,  19,  16,  16,  13,  12,  11,   9,   7,   5,   4,   3,   2,   1,   1,  -0,  -1,  -1,  -1,  -1,  -2,  -2,  -3,  -2,  -2},
  /*  25.0 */ {  -3,  -2,  -1,  -1,  -1,  -0,   1,   0,   5,   6,   7,   6,  14,   7,   3,   4,   4,   4,   4,   4,   3,   3,   2,   1,  -0,  -2,  -4,  -7,  -8, -10, -11, -12, -14, -15, -16, -17, -19, -20, -21, -23, -25, -26, -28, -30, -31, -33, -34, -36, -38, -39, -41, -42, -43, -44, -45, -46, -46, -47, -47, -47, -47, -46, -45, -45, -43, -43, -41, -39, -37, -34, -35, -33, -30, -26, -22, -21, -20, -19, -16, -15, -16, -19, -23, -22, -27, -32, -32, -30, -28, -27, -27, -28, -28, -26, -24, -27, -23, -23, -24, -24, -28, -28, -32, -33, -39, -43, -44, -47, -49, -51, -52, -52, -52, -51, -51, -51, -51, -52, -52, -51, -49, -48, -47, -45, -43, -41, -38, -35, -33, -29, -26, -22, -19, -15, -11,  -8,  -7,  -4,  -2,  -0,   1,   3,   5,   6,   8,   9,  11,  13,  15,  17,  18,  19,  21,  21,  21,  22,  23,  25,  26,  28,  31,  33,  33,  31,  34,  34,  37,  39,  40,  39,  38,  36,  34,  32,  31,  30,  29,  28,  27,  27,  27,  28,  28,  30,  33,  35,  36,  36,  36,  35,  33,  30,  29,  27,  26,  25,  27,  28,  26,  25,  22,  20,  19,  17,  16,  15,  14,  13,  13,  13,  13,  13,  13,  12,  13,  12,  10,   9,  10,  10,  10,   9,   8,   5,   2,  -2,  -5, -10, -16, -22, -27, -30, -31, -32, -33, -33, -28, -27, -29, -30, -32, -32, -34, -36, -38, -42, -43, -43, -45, -46, -46, -46, -48, -49, -48, -52, -54, -54, -56, -59, -60, -60, -60, -62, -62, -62, -61, -59, -56, -55, -54, -53, -52, -51, -50, -51, -49, -45, -41, -40, -39, -37, -35, -33, -31, -32, -32, -30, -27, -25, -21, -17, -14, -11,  -7,  -4,   1,   5,   9,  12,  15,  18,  20,  22,  25,  28,  26,  25,  24,  29,  33,  36,  34,  36,  37,  37,  39,  41,  43,  44,  46,  47,  42,  33,  38,  38,  35,  34,  32,  31,  28,  27,  26,  24,  21,  19,  17,  15,  14,  13,  10,   9,   9,   7,   5,   3,   2,   1,   0,  -1,  -1,  -2,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -3,  -3},
  /*  26.0 */ {  -4,  -3,  -3,  -2,  -2,  -1,   6,   2,   5,   6,   3,   5,   5,   3,   4,   4,   4,   3,   3,   2,   2,   1,  -0,  -2,  -3,  -5,  -7,  -8,  -9, -11, -12, -13, -14, -15, -17, -18, -19, -20, -22, -23, -25, -27, -28, -30, -32, -33, -35, -36, -38, -39, -41, -42, -43, -44, -45, -46, -46, -46, -46, -46, -46, -46, -45, -44, -43, -42, -41, -37, -36, -35, -35, -31, -29, -24, -21, -21, -21, -20, -18, -19, -20, -23, -25, -23, -27, -33, -31, -29, -29, -29, -27, -26, -26, -25, -26, -28, -25, -25, -24, -26, -28, -30, -33, -39, -44, -43, -45, -48, -50, -51, -53, -52, -51, -50, -50, -50, -50, -51, -51, -50, -49, -47, -46, -44, -42, -39, -37, -34, -31, -28, -24, -21, -17, -13, -10,  -6,  -4,  -2,   1,   2,   4,   6,   7,   9,  11,  12,  13,  15,  17,  19,  20,  22,  23,  24,  24,  24,  25,  26,  27,  29,  32,  34,  34,  31,  31,  34,  36,  39,  39,  40,  40,  37,  35,  33,  32,  32,  31,  30,  28,  27,  26,  26,  26,  28,  30,  32,  34,  33,  33,  32,  31,  29,  28,  27,  26,  26,  28,  30,  28,  26,  24,  22,  21,  19,  17,  15,  14,  13,  13,  12,  13,  13,  13,  13,  14,  12,  11,  13,  12,  12,  11,  10,   8,   5,   2,  -1,  -5, -10, -15, -21, -26, -28, -30, -31, -32, -33, -31, -26, -22, -24, -26, -28, -30, -31, -31, -35, -40, -42, -44, -45, -45, -45, -46, -48, -48, -49, -53, -55, -57, -59, -61, -62, -64, -66, -66, -65, -64, -62, -58, -53, -50, -49, -48, -53, -55, -52, -49, -46, -42, -39, -38, -37, -36, -33, -31, -31, -30, -28, -26, -24, -21, -19, -16, -13,  -9,  -6,  -1,   3,   7,  10,  13,  16,  19,  22,  26,  28,  29,  29,  28,  25,  28,  33,  36,  36,  36,  37,  39,  40,  42,  43,  44,  43,  39,  35,  39,  38,  36,  34,  32,  28,  27,  26,  24,  22,  19,  17,  14,  13,  11,  10,   8,   7,   6,   5,   3,   2,   1,  -0,  -2,  -3,  -3,  -4,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -4},
  /*  27.0 */ {  -4,  -5,  -4,  -1,  -1,  -3,  -3,  -3,  -1,  -1,   1,   2,   2,   3,   3,   3,   2,   1,   0,   0,  -1,  -2,  -3,  -5,  -6,  -7,  -8, -10, -11, -12, -13, -14, -15, -16, -17, -18, -20, -21, -23, -24, -26, -28, -29, -31, -32, -33, -35, -36, -38, -39, -41, -42, -43, -44, -45, -45, -45, -46, -46, -46, -45, -45, -44, -43, -43, -43, -38, -37, -36, -36, -33, -31, -27, -24, -23, -22, -21, -20, -20, -21, -22, -25, -26, -25, -28, -31, -30, -29, -29, -29, -27, -26, -26, -27, -29, -27, -25, -26, -26, -27, -30, -30, -33, -38, -44, -44, -45, -48, -50, -52, -52, -52, -51, -49, -49, -49, -49, -49, -49, -49, -48, -46, -45, -43, -41, -38, -35, -33, -30, -26, -23, -19, -15, -12,  -8,  -4,  -1,   1,   3,   5,   7,   8,  10,  12,  14,  15,  17,  18,  20,  21,  23,  23,  25,  26,  26,  26,  25,  26,  28,  30,  31,  34,  34,  33,  32,  32,  36,  38,  39,  39,  40,  38,  38,  35,  33,  33,  33,  32,  30,  27,  26,  26,  25,  26,  27,  29,  30,  30,  30,  30,  29,  29,  28,  27,  27,  28,  30,  31,  30,  27,  25,  23,  22,  20,  18,  16,  15,  14,  14,  14,  13,  13,  13,  14,  13,  12,  14,  15,  14,  12,  11,  10,   7,   4,   1,  -2,  -6, -10, -15, -20, -25, -27, -29, -28, -26, -26, -30, -28, -20, -22, -24, -25, -27, -29, -31, -31, -35, -40, -45, -43, -45, -45, -44, -46, -48, -47, -50, -54, -57, -60, -63, -66, -67, -67, -67, -65, -59, -51, -47, -41, -41, -42, -42, -47, -56, -56, -51, -46, -44, -40, -36, -35, -35, -34, -32, -31, -31, -29, -27, -24, -22, -19, -18, -15, -11,  -7,  -4,   1,   5,   9,  12,  15,  17,  21,  24,  27,  30,  31,  32,  26,  24,  29,  33,  35,  35,  37,  39,  40,  42,  43,  44,  42,  46,  33,  33,  35,  34,  32,  29,  28,  25,  23,  22,  18,  16,  15,  13,  11,  10,   8,   7,   5,   4,   3,   1,   0,  -1,  -2,  -3,  -4,  -5,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -4},
  /*  28.0 */ {  -5,  -4,  -0,  -2,   1,  -4,  -5,  -3,  -2,  -1,  -0,   0,   1,   1,   0,  -0,  -1,  -2,  -2,  -3,  -3,  -5,  -6,  -7,  -8,  -9, -10, -11, -12, -13, -14, -14, -15, -16, -18, -19, -21, -22, -24, -25, -27, -28, -30, -31, -32, -34, -35, -36, -38, -39, -40, -42, -43, -44, -44, -44, -45, -45, -45, -45, -44, -44, -43, -43, -43, -37, -37, -35, -36, -34, -32, -29, -25, -24, -24, -23, -22, -21, -21, -23, -24, -26, -28, -28, -27, -28, -27, -26, -26, -25, -26, -27, -30, -31, -30, -26, -25, -26, -28, -30, -31, -34, -36, -38, -45, -45, -46, -48, -50, -52, -52, -51, -50, -48, -48, -47, -47, -47, -47, -46, -46, -44, -43, -41, -39, -36, -34, -31, -28, -25, -21, -18, -14, -10,  -6,  -2,   2,   4,   6,   8,  10,  11,  13,  15,  17,  19,  20,  21,  23,  25,  26,  26,  26,  27,  27,  27,  27,  27,  28,  30,  31,  34,  38,  45,  44,  41,  41,  39,  39,  39,  39,  39,  38,  36,  36,  36,  36,  34,  31,  30,  28,  28,  27,  27,  28,  28,  28,  28,  29,  29,  28,  28,  29,  29,  29,  30,  30,  30,  29,  26,  25,  23,  22,  21,  20,  17,  15,  15,  15,  15,  15,  14,  14,  13,  11,  13,  18,  17,  14,  12,  10,   8,   6,   3,  -0,  -3,  -7, -11, -15, -19, -23, -26, -24, -21, -19, -19, -21, -19, -18, -20, -20, -21, -25, -30, -32, -32, -32, -38, -44, -42, -45, -48, -47, -47, -46, -47, -48, -53, -56, -60, -63, -63, -58, -55, -53, -45, -33, -29, -29, -29, -30, -31, -30, -34, -41, -48, -49, -42, -40, -37, -34, -32, -33, -35, -37, -37, -35, -31, -28, -25, -23, -20, -19, -16, -12,  -9,  -5,  -1,   3,   7,  10,  13,  16,  20,  23,  26,  29,  31,  31,  29,  25,  26,  33,  35,  35,  37,  38,  40,  41,  42,  43,  40,  48,  32,  30,  32,  33,  30,  28,  24,  22,  21,  18,  17,  15,  13,  11,   9,   8,   6,   5,   4,   3,   1,   0,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -5,  -5,  -5},
  /*  29.0 */ {  -5,  -3,  -5,  -6,  -5,  -6,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -3,  -3,  -3,  -4,  -4,  -4,  -6,  -7,  -8,  -9, -10, -10, -11, -12, -12, -13, -13, -15, -16, -17, -17, -19, -20, -22, -23, -25, -26, -27, -29, -30, -31, -33, -34, -35, -36, -38, -39, -41, -42, -43, -43, -44, -44, -44, -44, -44, -44, -43, -43, -42, -42, -41, -38, -35, -37, -35, -33, -31, -29, -25, -24, -25, -24, -23, -22, -22, -24, -24, -25, -27, -29, -28, -27, -27, -26, -25, -25, -25, -25, -29, -29, -27, -28, -28, -29, -29, -30, -32, -35, -37, -41, -46, -46, -47, -48, -51, -52, -52, -51, -49, -48, -47, -46, -45, -45, -44, -44, -43, -42, -40, -38, -37, -34, -32, -29, -26, -23, -19, -16, -12,  -8,  -4,  -0,   4,   7,   9,  11,  13,  15,  16,  18,  20,  22,  23,  25,  26,  27,  28,  28,  27,  28,  29,  29,  29,  29,  30,  32,  32,  34,  39,  37,  37,  36,  42,  42,  41,  41,  42,  42,  40,  40,  40,  40,  40,  38,  36,  34,  31,  29,  28,  28,  28,  27,  27,  27,  27,  28,  29,  28,  29,  30,  31,  31,  30,  29,  29,  26,  25,  23,  22,  23,  21,  20,  18,  16,  15,  16,  16,  15,  16,  14,  13,  15,  20,  17,  14,  12,  10,   8,   5,   2,  -0,  -3,  -7, -11, -15, -18, -21, -21, -15, -12, -13, -11,  -8,  -7, -11, -17, -17, -17, -22, -25, -27, -30, -30, -34, -42, -39, -45, -50, -49, -48, -47, -47, -49, -51, -55, -57, -55, -48, -40, -34, -31, -29, -30, -30, -31, -33, -34, -33, -32, -31, -30, -40, -44, -40, -37, -34, -32, -31, -32, -38, -43, -42, -39, -34, -30, -27, -24, -21, -20, -18, -13,  -9,  -6,  -2,   2,   6,   8,  12,  15,  19,  22,  24,  27,  29,  30,  30,  26,  24,  29,  33,  36,  36,  38,  39,  40,  42,  43,  36,  37,  23,  30,  32,  30,  28,  25,  23,  21,  20,  17,  16,  13,  11,  10,   9,   7,   5,   4,   3,   2,   1,  -1,  -3,  -3,  -5,  -5,  -6,  -6,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -5},
  /*  30.0 */ {  -8,  -8,  -8,  -8,  -7,  -8,  -6,  -6,  -6,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -7,  -7,  -8,  -9, -10, -11, -11, -12, -12, -13, -13, -14, -15, -16, -17, -17, -18, -20, -21, -23, -24, -25, -27, -28, -29, -31, -32, -33, -34, -36, -37, -38, -39, -40, -41, -42, -42, -43, -43, -43, -43, -43, -43, -42, -42, -41, -40, -38, -35, -37, -35, -33, -31, -30, -28, -25, -25, -25, -24, -22, -23, -24, -24, -23, -24, -27, -28, -29, -29, -28, -28, -28, -28, -27, -28, -28, -28, -28, -29, -29, -29, -29, -30, -32, -36, -39, -41, -46, -46, -47, -49, -51, -52, -52, -51, -49, -47, -46, -45, -43, -42, -42, -41, -41, -40, -38, -36, -35, -33, -30, -28, -25, -21, -18, -14, -10,  -6,  -3,   1,   5,   9,  12,  14,  16,  18,  20,  22,  23,  25,  26,  28,  29,  30,  30,  33,  33,  30,  31,  30,  30,  31,  32,  33,  34,  35,  35,  37,  39,  40,  41,  44,  42,  40,  43,  47,  49,  48,  47,  46,  44,  41,  39,  38,  35,  33,  30,  29,  27,  26,  26,  26,  27,  27,  28,  29,  30,  31,  31,  30,  30,  29,  28,  27,  26,  24,  23,  22,  22,  21,  21,  18,  17,  17,  16,  16,  16,  17,  17,  17,  19,  17,  14,  12,  10,   7,   5,   2,  -0,  -4,  -8, -13, -15, -17, -18, -13,  -7,  -8,  -8,  -6,  -6,  -7, -13, -16, -15, -19, -22, -23, -24, -27, -28, -28, -34, -33, -39, -49, -49, -47, -46, -46, -48, -50, -48, -39, -35, -29, -25, -26, -27, -28, -30, -30, -31, -33, -34, -35, -35, -34, -35, -38, -38, -36, -35, -34, -32, -31, -32, -41, -44, -42, -41, -38, -32, -27, -24, -22, -22, -19, -15, -11,  -7,  -3,   1,   4,   7,  10,  14,  17,  21,  23,  25,  28,  30,  31,  30,  26,  27,  32,  34,  36,  37,  39,  39,  42,  42,  35,  25,  23,  30,  30,  28,  26,  23,  21,  19,  17,  16,  14,  12,  11,   9,   8,   6,   4,   3,   2,  -0,  -1,  -3,  -4,  -5,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -7,  -7,  -7,  -7,  -5,  -8},
  /*  31.0 */ {  -8,  -9,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -9,  -9, -10, -11, -12, -13, -13, -13, -13, -14, -15, -15, -16, -18, -20, -21, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -33, -35, -36, -37, -38, -39, -40, -41, -41, -42, -42, -42, -42, -42, -42, -42, -41, -41, -40, -38, -34, -35, -36, -34, -32, -30, -28, -27, -26, -26, -24, -24, -23, -24, -25, -24, -24, -25, -27, -27, -28, -28, -29, -28, -28, -28, -28, -29, -29, -29, -28, -29, -29, -29, -30, -31, -34, -36, -40, -43, -44, -44, -48, -51, -52, -52, -51, -50, -48, -46, -45, -43, -42, -40, -40, -39, -39, -38, -36, -35, -33, -31, -28, -26, -23, -19, -16, -12,  -8,  -5,  -1,   3,   7,  11,  14,  18,  20,  22,  24,  25,  27,  28,  29,  30,  32,  32,  32,  34,  32,  32,  32,  31,  30,  32,  33,  35,  36,  37,  37,  38,  39,  41,  44,  44,  44,  43,  46,  51,  53,  54,  52,  50,  48,  46,  43,  42,  39,  37,  34,  32,  29,  27,  27,  27,  27,  28,  29,  31,  32,  31,  31,  30,  29,  28,  28,  27,  27,  26,  24,  23,  22,  21,  21,  19,  17,  15,  15,  16,  16,  17,  17,  18,  20,  18,  16,  14,  12,   9,   5,   2,  -1,  -6, -10, -14, -16, -16, -11,  -5,  -3,  -4,  -5,  -5,  -7,  -9, -14, -14, -15, -19, -21, -22, -23, -25, -26, -25, -26, -31, -37, -48, -47, -45, -44, -46, -48, -44, -36, -24, -22, -24, -26, -28, -29, -30, -31, -31, -33, -34, -35, -36, -36, -37, -36, -37, -38, -37, -36, -34, -32, -31, -31, -33, -41, -43, -42, -39, -35, -29, -24, -23, -22, -20, -16, -12,  -8,  -4,  -1,   3,   6,   9,  13,  16,  19,  22,  24,  27,  29,  30,  31,  29,  27,  30,  33,  36,  37,  38,  39,  42,  42,  35,  20,  24,  29,  28,  26,  24,  22,  20,  18,  16,  14,  13,  11,  10,   9,   7,   6,   4,   3,   1,  -1,  -3,  -4,  -5,  -7,  -7,  -8,  -8,  -8,  -8,  -9,  -8,  -8,  -8,  -6,  -8,  -8,  -9,  -8},
  /*  32.0 */ {  -9, -10,  -9,  -9, -10, -10,  -9, -10, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9, -10, -11, -11, -12, -13, -14, -14, -14, -14, -15, -16, -17, -18, -20, -21, -23, -24, -25, -26, -27, -28, -29, -30, -31, -32, -33, -34, -36, -37, -38, -39, -40, -40, -40, -41, -41, -42, -42, -42, -42, -42, -41, -41, -39, -38, -37, -33, -35, -34, -33, -31, -30, -28, -27, -26, -25, -24, -23, -26, -24, -26, -26, -27, -28, -28, -28, -27, -28, -27, -27, -27, -27, -27, -28, -29, -29, -28, -27, -28, -29, -31, -33, -34, -37, -39, -41, -43, -46, -50, -51, -51, -51, -50, -48, -47, -45, -43, -37, -40, -39, -37, -37, -37, -36, -35, -34, -31, -29, -26, -24, -21, -18, -14, -10,  -7,  -3,   1,   4,   8,  12,  16,  20,  23,  25,  27,  28,  30,  31,  33,  34,  35,  36,  36,  36,  38,  34,  34,  33,  33,  33,  34,  36,  38,  39,  40,  41,  40,  40,  42,  43,  43,  44,  46,  48,  49,  50,  55,  54,  51,  48,  47,  44,  41,  39,  38,  36,  32,  30,  28,  28,  29,  30,  32,  33,  32,  33,  32,  30,  29,  27,  27,  27,  29,  30,  27,  25,  22,  18,  14,  11,  11,  12,  16,  19,  17,  17,  16,  20,  21,  20,  19,  18,  15,  11,   7,   2,  -2,  -7, -10, -12, -14, -12,  -4,  -1,  -1,  -2,  -3,  -5,  -6, -10, -12, -12, -14, -18, -21, -22, -24, -24, -25, -25, -26, -31, -40, -45, -43, -43, -44, -46, -46, -35, -28, -25, -24, -26, -28, -29, -30, -31, -32, -33, -35, -37, -37, -37, -37, -38, -38, -39, -39, -39, -37, -34, -34, -32, -32, -31, -35, -41, -41, -38, -34, -29, -26, -24, -24, -21, -17, -13,  -9,  -6,  -2,   2,   5,   9,  12,  15,  18,  21,  24,  26,  29,  30,  32,  31,  26,  31,  33,  33,  36,  37,  39,  42,  42,  33,  16,  25,  29,  28,  26,  24,  22,  20,  17,  16,  13,  12,  11,   9,   8,   7,   6,   4,   1,  -1,  -3,  -4,  -6,  -7,  -8,  -8,  -9,  -8,  -8,  -9,  -8,  -5,  -9,  -9,  -9,  -9,  -9,  -9,  -9},
  /*  33.0 */ {  -9, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -11, -12, -13, -13, -14, -14, -15, -15, -15, -15, -16, -17, -18, -20, -21, -23, -24, -25, -26, -27, -28, -29, -29, -30, -32, -33, -34, -35, -36, -37, -38, -39, -39, -40, -41, -41, -41, -41, -42, -41, -41, -41, -40, -38, -38, -37, -33, -34, -34, -33, -32, -31, -29, -28, -26, -24, -24, -22, -22, -24, -22, -25, -27, -30, -30, -30, -28, -27, -28, -28, -27, -27, -27, -28, -29, -30, -30, -30, -30, -29, -29, -31, -33, -34, -36, -39, -40, -44, -48, -50, -51, -51, -50, -49, -47, -46, -44, -42, -40, -38, -38, -36, -35, -35, -34, -32, -31, -29, -27, -25, -22, -18, -16, -12,  -9,  -5,  -1,   3,   6,  10,  14,  17,  21,  25,  28,  30,  32,  33,  34,  36,  37,  38,  39,  39,  40,  38,  38,  38,  37,  35,  35,  35,  36,  40,  43,  45,  48,  45,  43,  41,  42,  42,  41,  39,  46,  48,  51,  52,  55,  52,  52,  50,  48,  45,  42,  40,  39,  36,  32,  30,  29,  29,  31,  33,  33,  33,  32,  31,  30,  29,  28,  27,  27,  28,  28,  29,  23,  14,  10,   7,   7,   7,   9,  12,  14,  15,  16,  16,  20,  24,  24,  21,  19,  17,  13,   8,   3,  -1,  -4,  -5,  -3,  -3,  -0,   4,   3,   1,  -1,  -4,  -5,  -8, -10, -12, -12, -14, -19, -21, -21, -21, -23, -24, -23, -26, -29, -37, -45, -47, -47, -45, -40, -34, -27, -23, -24, -25, -27, -29, -30, -31, -32, -33, -34, -36, -37, -38, -38, -38, -39, -39, -40, -40, -40, -37, -36, -35, -34, -34, -33, -34, -38, -39, -36, -34, -31, -28, -26, -23, -21, -18, -15, -11,  -6,  -2,   1,   5,   8,  11,  15,  18,  21,  24,  26,  28,  31,  32,  33,  31,  34,  35,  34,  34,  36,  37,  41,  43,  34,  15,  24,  28,  27,  25,  23,  21,  18,  16,  14,  13,  10,   9,   7,   6,   5,   5,   3,   0,  -2,  -4,  -6,  -7,  -8,  -9,  -9,  -9,  -9, -10, -10,  -7,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9},
  /*  34.0 */ { -10, -10,  -9, -10, -10, -11, -12, -12, -12, -12, -13, -13, -12, -12, -12, -12, -12, -13, -13, -14, -14, -15, -15, -16, -16, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -29, -29, -31, -32, -32, -34, -35, -36, -37, -38, -39, -40, -40, -41, -41, -41, -41, -41, -41, -41, -41, -40, -39, -37, -37, -34, -32, -32, -33, -31, -30, -29, -26, -24, -23, -22, -23, -21, -23, -24, -24, -26, -28, -29, -30, -27, -27, -29, -30, -29, -28, -27, -28, -27, -28, -28, -29, -30, -30, -31, -31, -31, -32, -34, -36, -39, -40, -41, -47, -48, -48, -49, -48, -47, -46, -45, -43, -42, -40, -38, -37, -35, -34, -33, -32, -30, -29, -28, -25, -22, -20, -16, -13, -10,  -6,  -3,   1,   4,   8,  11,  15,  18,  22,  26,  29,  32,  35,  36,  38,  39,  40,  41,  41,  42,  42,  42,  42,  40,  38,  38,  38,  38,  38,  40,  42,  43,  44,  46,  45,  43,  42,  41,  40,  37,  38,  43,  45,  46,  48,  52,  51,  51,  50,  48,  46,  45,  42,  39,  34,  31,  29,  30,  32,  33,  34,  33,  33,  32,  32,  31,  29,  28,  26,  25,  23,  19,  13,   9,   9,   6,   1,   1,   5,   8,  10,  13,  14,  15,  18,  28,  26,  22,  20,  18,  14,  10,   6,   1,   0,   4,   5,   5,   6,   6,   4,  -1,  -3,  -5,  -7, -10, -11, -12, -14, -17, -20, -21, -20, -20, -21, -22, -22, -23, -28, -35, -42, -48, -44, -38, -32, -25, -25, -23, -24, -25, -26, -28, -30, -32, -34, -34, -36, -37, -38, -39, -39, -40, -41, -41, -41, -41, -40, -39, -38, -36, -36, -36, -36, -36, -38, -38, -36, -35, -33, -28, -25, -23, -21, -19, -15, -11,  -7,  -3,   1,   5,   8,  11,  14,  18,  21,  24,  26,  28,  30,  31,  32,  32,  34,  37,  37,  40,  36,  37,  40,  39,  25,  11,  23,  27,  25,  24,  21,  19,  17,  16,  14,  11,   9,   7,   5,   4,   4,   3,   2,  -0,  -2,  -4,  -6,  -8,  -8,  -9, -10,  -9, -10, -12, -12,  -9, -11,  -9,  -8,  -9,  -9,  -9,  -8, -10},
  /*  35.0 */ { -10, -10, -10, -10, -10, -12, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14, -14, -14, -15, -15, -16, -16, -16, -17, -18, -19, -20, -21, -22, -23, -23, -24, -26, -27, -28, -29, -30, -32, -33, -33, -34, -35, -36, -38, -39, -39, -40, -40, -40, -41, -41, -41, -41, -41, -40, -39, -39, -36, -34, -33, -32, -32, -31, -30, -29, -27, -25, -24, -24, -23, -21, -22, -20, -22, -24, -25, -27, -28, -28, -27, -28, -27, -30, -32, -32, -30, -28, -28, -28, -29, -28, -29, -30, -31, -30, -31, -33, -32, -32, -35, -37, -39, -40, -43, -45, -47, -46, -46, -45, -45, -44, -42, -40, -39, -37, -36, -34, -33, -31, -30, -29, -27, -26, -23, -20, -18, -15, -11,  -8,  -4,  -1,   2,   6,   9,  13,  16,  20,  23,  27,  30,  34,  37,  39,  41,  42,  43,  44,  45,  44,  45,  46,  44,  43,  43,  42,  41,  41,  40,  41,  42,  44,  47,  48,  46,  46,  48,  47,  44,  43,  41,  41,  40,  40,  44,  48,  50,  50,  50,  50,  49,  47,  44,  42,  37,  36,  37,  38,  37,  37,  36,  36,  36,  34,  34,  33,  29,  28,  26,  23,  17,  12,   9,  17,  20,  17,  10,   6,   6,   7,   7,  17,  28,  24,  19,  24,  26,  25,  22,  20,  17,  13,  10,   6,   6,   9,  11,  11,   9,   6,   1,  -2,  -5,  -7,  -9, -11, -12, -14, -16, -17, -21, -22, -23, -22, -22, -22, -23, -25, -29, -32, -35, -37, -35, -32, -28, -27, -23, -22, -22, -25, -26, -29, -32, -33, -35, -36, -37, -38, -39, -40, -41, -42, -43, -43, -42, -42, -42, -41, -40, -40, -39, -38, -38, -39, -39, -38, -36, -35, -34, -32, -27, -22, -21, -19, -16, -11,  -7,  -2,   2,   4,   7,  11,  14,  17,  20,  22,  25,  28,  29,  30,  31,  33,  35,  36,  36,  37,  37,  41,  39,  34,  23,  13,  20,  24,  23,  22,  21,  19,  17,  15,  12,  10,   8,   6,   5,   4,   3,   1,  -1,  -2,  -3,  -5,  -6,  -8,  -9, -10, -10, -10, -10, -12,  -9,  -4, -13, -10, -10, -10, -10,  -9, -10, -10},
  /*  36.0 */ { -11, -11, -11, -12, -12, -12, -13, -13, -13, -14, -14, -14, -14, -14, -13, -13, -13, -14, -14, -15, -15, -15, -16, -16, -17, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -29, -30, -31, -32, -33, -34, -35, -36, -37, -37, -39, -39, -39, -40, -40, -40, -40, -40, -40, -40, -39, -38, -36, -33, -34, -32, -29, -30, -29, -29, -27, -25, -23, -23, -21, -20, -21, -20, -19, -19, -21, -24, -27, -28, -29, -29, -28, -29, -30, -30, -29, -29, -29, -29, -29, -29, -29, -30, -30, -30, -32, -32, -32, -34, -33, -32, -36, -37, -40, -40, -43, -44, -44, -44, -43, -43, -42, -41, -39, -38, -37, -35, -33, -31, -30, -29, -27, -26, -23, -21, -18, -16, -11,  -9,  -5,  -3,   0,   4,   7,  11,  14,  18,  22,  25,  28,  31,  34,  38,  41,  43,  46,  47,  47,  48,  48,  48,  49,  48,  48,  48,  47,  45,  44,  43,  41,  42,  43,  45,  47,  49,  46,  46,  47,  44,  43,  45,  45,  42,  42,  42,  46,  48,  48,  47,  47,  48,  48,  46,  44,  43,  43,  43,  43,  42,  40,  39,  39,  38,  37,  38,  31,  29,  29,  27,  21,  14,  11,  19,  28,  31,  29,  25,  16,  12,  15,  15,  21,  27,  25,  23,  25,  27,  26,  24,  22,  20,  16,  14,  13,  13,  15,  15,  12,  10,   5,   5,   1,  -2,  -4,  -8, -10, -12, -13, -15, -18, -23, -27, -28, -29, -30, -30, -31, -32, -35, -29, -28, -30, -30, -31, -30, -26, -21, -24, -25, -30, -33, -33, -32, -34, -36, -37, -38, -39, -41, -42, -43, -44, -45, -46, -48, -47, -48, -47, -44, -46, -44, -43, -43, -42, -40, -37, -36, -34, -31, -29, -26, -22, -17, -17, -15, -12,  -7,  -2,   2,   4,   8,  10,  13,  16,  19,  22,  24,  27,  30,  28,  28,  30,  33,  33,  34,  36,  40,  42,  41,  38,  31,  19,  16,  22,  22,  22,  21,  19,  16,  14,  12,  10,   8,   6,   5,   3,   2,   2,   0,  -2,  -4,  -5,  -6,  -7,  -8,  -9, -10, -10, -10, -12, -11, -11, -12, -11, -11, -11, -11, -10, -11, -11},
  /*  37.0 */ { -12, -12, -12, -13, -12, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -13, -14, -14, -15, -15, -15, -16, -16, -17, -18, -18, -20, -20, -21, -22, -23, -24, -25, -26, -27, -29, -30, -31, -33, -34, -35, -36, -37, -37, -37, -38, -39, -39, -39, -40, -40, -40, -40, -39, -39, -38, -37, -33, -33, -32, -27, -27, -28, -27, -27, -26, -23, -23, -23, -22, -21, -21, -19, -17, -17, -20, -23, -26, -28, -28, -29, -29, -30, -30, -31, -30, -30, -30, -31, -30, -29, -30, -31, -32, -32, -31, -32, -32, -32, -33, -33, -34, -36, -39, -39, -42, -43, -43, -43, -42, -42, -42, -40, -39, -37, -35, -34, -32, -31, -28, -28, -25, -24, -22, -19, -16, -13, -10,  -7,  -4,  -1,   2,   5,   9,  12,  16,  19,  23,  26,  29,  33,  36,  38,  42,  45,  47,  49,  51,  51,  51,  51,  52,  52,  52,  52,  49,  49,  49,  48,  47,  46,  46,  47,  47,  51,  52,  48,  46,  51,  49,  52,  52,  50,  47,  47,  48,  51,  50,  47,  46,  45,  44,  45,  45,  43,  43,  43,  43,  43,  42,  42,  42,  40,  38,  41,  31,  29,  28,  27,  23,  21,  25,  31,  36,  38,  37,  34,  30,  28,  29,  29,  33,  33,  32,  29,  30,  30,  27,  25,  23,  22,  19,  18,  19,  20,  17,  16,  12,   8,   5,  -3,  -7,  -9, -10, -10, -10, -11, -14, -17, -23, -28, -31, -33, -35, -37, -38, -41, -44, -45, -39, -33, -30, -29, -29, -31, -28, -28, -34, -42, -48, -51, -51, -51, -46, -42, -39, -42, -42, -44, -46, -46, -50, -56, -58, -57, -55, -54, -50, -47, -46, -44, -43, -43, -44, -42, -40, -37, -34, -31, -30, -25, -21, -16, -16, -16, -12,  -8,  -3,   0,   4,   7,  10,  13,  16,  19,  21,  23,  26,  29,  27,  28,  29,  31,  32,  33,  35,  37,  40,  42,  43,  39,  28,  16,  18,  22,  22,  20,  18,  16,  14,  11,  10,   8,   6,   4,   2,   1,   1,  -0,  -2,  -4,  -5,  -6,  -7,  -8,  -9,  -9, -10, -11, -13, -12, -13, -13, -12, -11, -11, -11, -11, -12, -12},
  /*  38.0 */ { -13, -12, -13, -13, -13, -13, -13, -13, -13, -12, -12, -12, -12, -12, -12, -12, -12, -13, -13, -14, -14, -15, -15, -16, -17, -17, -18, -19, -20, -21, -22, -22, -24, -25, -26, -27, -29, -30, -31, -33, -33, -35, -35, -36, -36, -37, -37, -38, -38, -39, -39, -39, -39, -39, -38, -37, -37, -33, -32, -31, -26, -24, -25, -25, -25, -24, -23, -21, -19, -21, -20, -19, -17, -15, -16, -17, -21, -23, -25, -26, -27, -27, -29, -30, -32, -32, -33, -32, -32, -31, -30, -30, -31, -32, -34, -35, -34, -34, -33, -32, -32, -33, -34, -35, -37, -37, -39, -42, -42, -41, -41, -41, -41, -40, -38, -36, -34, -32, -30, -28, -28, -27, -24, -22, -20, -18, -15, -11,  -8,  -5,  -2,   1,   4,   7,   9,  13,  16,  20,  23,  27,  31,  34,  37,  39,  42,  45,  48,  51,  53,  54,  55,  56,  55,  55,  55,  55,  53,  52,  51,  50,  49,  48,  49,  47,  48,  49,  50,  48,  45,  44,  49,  53,  55,  55,  55,  52,  51,  51,  52,  50,  49,  47,  46,  45,  44,  44,  43,  42,  42,  43,  44,  43,  43,  44,  42,  42,  38,  31,  29,  25,  23,  25,  29,  36,  39,  39,  39,  38,  36,  36,  37,  37,  37,  36,  35,  36,  35,  34,  31,  28,  26,  23,  23,  24,  24,  20,  18,  16,  13,   5,  -8, -12, -12, -13, -16, -17, -16, -15, -19, -26, -29, -31, -33, -35, -36, -38, -38, -39, -43, -44, -41, -33, -30, -28, -28, -30, -33, -46, -52, -53, -54, -54, -55, -56, -56, -56, -55, -49, -45, -44, -48, -54, -59, -60, -58, -53, -48, -47, -47, -45, -44, -45, -46, -49, -47, -45, -42, -39, -36, -32, -30, -25, -20, -17, -16, -15, -13,  -9,  -5,  -1,   3,   7,  10,  13,  15,  18,  20,  23,  26,  26,  26,  27,  28,  29,  31,  31,  32,  36,  36,  38,  42,  41,  35,  24,  17,  21,  22,  21,  19,  16,  13,  12,  10,   8,   6,   4,   3,   1,  -0,  -2,  -3,  -4,  -4,  -5,  -7,  -9,  -9, -10, -11, -12, -10,  -8, -14, -13, -12, -11, -11, -11, -12, -13, -13},
  /*  39.0 */ { -13, -12, -13, -13, -13, -13, -13, -12, -12, -12, -12, -11, -11, -12, -12, -12, -12, -13, -13, -13, -14, -14, -15, -15, -16, -17, -17, -18, -19, -21, -22, -22, -23, -24, -26, -27, -28, -30, -31, -32, -33, -34, -34, -35, -35, -36, -36, -37, -37, -37, -37, -37, -37, -37, -36, -36, -34, -30, -30, -27, -24, -25, -24, -22, -22, -21, -21, -20, -18, -18, -20, -18, -17, -14, -14, -16, -20, -22, -24, -25, -26, -27, -28, -30, -32, -33, -33, -33, -33, -33, -32, -32, -32, -33, -35, -35, -35, -34, -35, -34, -32, -33, -34, -33, -35, -36, -37, -37, -39, -40, -39, -38, -38, -38, -37, -36, -33, -32, -31, -27, -27, -25, -24, -22, -19, -16, -13, -10,  -7,  -3,  -0,   2,   5,   8,  11,  14,  17,  20,  24,  27,  30,  33,  36,  39,  43,  45,  49,  52,  54,  56,  57,  58,  58,  58,  57,  56,  55,  54,  52,  51,  51,  49,  49,  49,  48,  49,  50,  51,  49,  49,  53,  54,  55,  55,  54,  54,  54,  53,  53,  52,  50,  49,  49,  47,  46,  45,  44,  44,  45,  46,  44,  43,  43,  43,  43,  43,  44,  37,  30,  29,  27,  28,  33,  38,  40,  40,  40,  40,  39,  40,  40,  39,  37,  37,  36,  36,  36,  34,  31,  30,  29,  28,  27,  26,  24,  21,  18,  14,  11,  -0, -12, -17, -17, -18, -21, -20, -19, -21, -24, -27, -29, -31, -33, -34, -36, -37, -38, -36, -35, -36, -36, -35, -33, -30, -30, -36, -47, -51, -52, -51, -51, -54, -57, -59, -60, -62, -63, -63, -63, -58, -55, -55, -56, -56, -52, -51, -49, -47, -46, -48, -52, -52, -52, -51, -48, -45, -42, -39, -36, -32, -28, -25, -19, -16, -14, -13, -12,  -9,  -5,  -1,   2,   6,  10,  13,  15,  17,  20,  23,  24,  23,  25,  25,  26,  28,  30,  31,  31,  33,  35,  37,  39,  41,  38,  25,  15,  20,  22,  21,  20,  18,  16,  13,  11,   9,   7,   5,   4,   2,   0,  -1,  -3,  -4,  -5,  -6,  -7,  -9,  -9, -10, -11, -13, -15, -13, -14, -13, -12, -12, -12, -12, -13, -13, -13},
  /*  40.0 */ { -13, -13, -12, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -11, -11, -11, -11, -12, -12, -13, -13, -13, -13, -14, -15, -16, -16, -17, -18, -20, -21, -22, -22, -24, -25, -26, -28, -28, -30, -30, -31, -32, -33, -34, -34, -35, -35, -36, -36, -36, -37, -37, -36, -36, -35, -34, -31, -28, -28, -23, -23, -23, -23, -21, -20, -19, -19, -19, -18, -16, -18, -17, -16, -13, -12, -17, -19, -21, -23, -24, -25, -26, -27, -28, -30, -32, -33, -33, -33, -33, -33, -33, -33, -34, -35, -34, -34, -34, -35, -35, -34, -33, -35, -35, -35, -34, -34, -35, -35, -35, -35, -34, -34, -34, -34, -34, -33, -31, -30, -29, -27, -25, -23, -21, -18, -15, -12,  -9,  -6,  -2,   1,   4,   7,  10,  13,  16,  19,  23,  26,  29,  32,  35,  38,  41,  43,  46,  49,  52,  55,  57,  59,  59,  59,  60,  59,  58,  57,  56,  54,  54,  52,  51,  52,  51,  49,  48,  47,  46,  46,  46,  49,  54,  56,  55,  55,  54,  52,  52,  53,  52,  51,  50,  48,  49,  48,  45,  45,  44,  46,  48,  46,  44,  44,  44,  45,  46,  45,  38,  39,  34,  34,  36,  40,  40,  41,  40,  40,  40,  39,  38,  39,  39,  38,  37,  35,  34,  32,  30,  29,  30,  29,  29,  27,  26,  22,  20,  19,  11,   3,  -8, -16, -21, -18, -15, -16, -15, -18, -21, -24, -26, -28, -30, -33, -34, -35, -36, -37, -38, -39, -41, -41, -42, -40, -39, -35, -35, -41, -45, -46, -50, -56, -60, -62, -62, -64, -66, -67, -67, -66, -66, -67, -66, -64, -63, -62, -59, -56, -55, -57, -57, -55, -54, -53, -50, -47, -45, -43, -40, -36, -32, -29, -25, -20, -16, -13, -11, -10,  -8,  -4,  -1,   3,   5,   8,  11,  14,  17,  20,  24,  24,  23,  23,  24,  25,  26,  29,  30,  31,  31,  33,  34,  38,  40,  37,  24,  15,  17,  21,  21,  20,  18,  17,  15,  12,  10,   8,   6,   5,   3,   1,  -0,  -2,  -3,  -4,  -6,  -7,  -8,  -9, -10, -11, -13, -11, -15, -13, -12, -11, -12, -12, -13, -13, -12, -13},
  /*  41.0 */ { -12, -12, -12, -12, -12, -11, -11, -11, -11, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -12, -12, -12, -13, -14, -15, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -31, -31, -32, -33, -33, -33, -33, -33, -32, -32, -32, -32, -32, -33, -30, -25, -25, -23, -22, -21, -20, -19, -18, -17, -17, -17, -17, -14, -13, -14, -16, -12, -11, -15, -18, -20, -21, -22, -23, -24, -26, -27, -28, -30, -32, -32, -33, -33, -33, -33, -33, -34, -35, -34, -36, -35, -34, -34, -35, -33, -34, -34, -33, -34, -32, -31, -32, -32, -31, -31, -29, -28, -30, -31, -30, -29, -28, -27, -26, -24, -21, -19, -16, -13, -10,  -7,  -4,  -1,   3,   7,   9,  12,  16,  19,  21,  24,  27,  30,  34,  37,  40,  42,  45,  47,  50,  53,  55,  58,  59,  61,  61,  60,  60,  59,  58,  57,  56,  56,  54,  52,  52,  51,  51,  50,  49,  48,  48,  48,  49,  55,  56,  56,  56,  55,  54,  54,  53,  51,  50,  50,  49,  48,  46,  46,  45,  45,  46,  48,  47,  46,  46,  47,  48,  48,  48,  46,  40,  35,  37,  43,  44,  43,  42,  41,  41,  39,  38,  37,  36,  36,  36,  35,  34,  31,  28,  26,  25,  24,  24,  24,  25,  26,  23,  18,  11,   5,   5,  -6, -16, -16, -11, -12, -13, -14, -17, -21, -25, -27, -28, -30, -32, -33, -34, -36, -37, -40, -42, -44, -41, -45, -49, -44, -38, -34, -34, -33, -35, -44, -54, -59, -61, -63, -65, -66, -65, -64, -62, -62, -62, -64, -63, -61, -61, -60, -58, -56, -56, -56, -56, -55, -53, -50, -48, -46, -42, -40, -38, -33, -28, -24, -21, -17, -14, -11,  -8,  -7,  -3,   1,   3,   5,   7,  10,  14,  18,  21,  24,  26,  27,  24,  23,  24,  25,  26,  27,  28,  30,  30,  32,  35,  36,  29,  17,  11,  10,  16,  19,  19,  18,  17,  16,  14,  12,  10,   7,   6,   4,   2,   1,  -1,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -11, -12,  -7,  -8, -13, -11, -11, -12, -12, -12, -12, -12, -12},
  /*  42.0 */ { -11, -11, -11, -11, -11, -10, -10,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -9,  -9, -10, -10, -10, -10, -11, -11, -12, -13, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -29, -30, -30, -31, -31, -32, -32, -32, -31, -31, -31, -31, -30, -30, -30, -27, -24, -23, -21, -20, -19, -18, -17, -16, -15, -15, -15, -15, -14, -14, -14, -14, -13, -12, -14, -18, -19, -19, -21, -22, -24, -25, -25, -28, -29, -28, -32, -32, -33, -33, -34, -34, -34, -34, -34, -35, -36, -36, -35, -35, -33, -32, -33, -33, -31, -32, -30, -30, -29, -28, -28, -27, -26, -25, -27, -26, -26, -26, -26, -24, -23, -20, -17, -13, -10,  -8,  -6,  -1,   4,   5,   9,  12,  15,  18,  21,  24,  26,  29,  32,  35,  38,  42,  44,  46,  48,  51,  53,  56,  58,  60,  62,  61,  61,  61,  60,  60,  59,  58,  57,  57,  55,  54,  54,  53,  51,  51,  50,  51,  52,  53,  56,  56,  57,  57,  54,  54,  54,  52,  50,  50,  50,  51,  50,  47,  47,  46,  46,  46,  51,  47,  48,  48,  49,  48,  46,  47,  44,  39,  37,  41,  45,  44,  45,  43,  41,  40,  40,  38,  34,  30,  28,  27,  28,  29,  27,  25,  22,  20,  19,  19,  18,  20,  20,  19,  14,  12,   9,  -1,  -8, -11, -12, -11, -12, -14, -17, -20, -23, -25, -27, -28, -29, -31, -33, -34, -35, -39, -41, -43, -43, -40, -36, -38, -37, -36, -35, -37, -38, -38, -38, -39, -44, -52, -56, -56, -57, -60, -63, -62, -64, -63, -62, -63, -63, -63, -61, -58, -56, -56, -56, -55, -54, -53, -50, -48, -46, -43, -40, -36, -33, -29, -26, -23, -19, -16, -11,  -7,  -5,  -2,   0,   2,   4,   6,   8,  13,  18,  21,  23,  25,  26,  25,  23,  23,  24,  25,  26,  27,  28,  29,  30,  35,  33,  22,  21,  15,  11,   9,  10,  14,  16,  17,  16,  15,  13,  11,   9,   7,   5,   3,   2,  -0,  -1,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -12, -10, -11, -13, -11, -11, -11, -12, -12, -11, -11, -11},
  /*  43.0 */ { -10, -10,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -9,  -9, -10, -11, -11, -12, -12, -13, -14, -16, -17, -18, -19, -20, -21, -22, -22, -23, -24, -25, -26, -27, -28, -29, -30, -30, -30, -30, -31, -30, -30, -30, -29, -29, -29, -29, -24, -23, -21, -20, -19, -18, -18, -16, -16, -15, -14, -13, -12, -11, -10, -10, -14, -12, -14, -15, -15, -18, -19, -21, -24, -26, -27, -26, -27, -29, -29, -30, -31, -32, -34, -35, -35, -35, -34, -34, -34, -35, -36, -36, -37, -36, -35, -35, -34, -32, -32, -29, -28, -27, -27, -27, -26, -24, -25, -23, -22, -22, -21, -21, -20, -20, -18, -14, -10,  -8,  -7,  -2,   4,  10,  13,  16,  17,  19,  20,  23,  26,  29,  31,  34,  37,  40,  43,  45,  47,  50,  52,  54,  56,  59,  61,  62,  62,  62,  62,  62,  62,  62,  61,  60,  58,  58,  58,  57,  56,  53,  51,  52,  55,  53,  54,  55,  57,  56,  56,  55,  54,  51,  50,  51,  52,  52,  51,  50,  50,  49,  48,  46,  46,  47,  49,  49,  48,  47,  43,  43,  43,  43,  43,  44,  46,  45,  44,  44,  42,  41,  40,  38,  36,  31,  29,  28,  26,  23,  21,  20,  19,  20,  18,  15,  17,  22,  23,  22,  17,  12,   5,  -1,  -6,  -8,  -9, -10, -12, -14, -17, -19, -20, -23, -25, -27, -28, -29, -32, -32, -34, -37, -39, -41, -42, -42, -40, -41, -41, -42, -44, -43, -42, -41, -42, -44, -47, -46, -48, -49, -51, -48, -49, -53, -62, -65, -63, -64, -64, -62, -57, -57, -60, -57, -56, -55, -53, -52, -50, -49, -46, -44, -43, -40, -38, -34, -31, -28, -25, -22, -18, -13,  -8,  -4,  -2,  -1,   1,   3,   5,   8,  11,  15,  19,  21,  22,  24,  25,  25,  26,  26,  27,  26,  26,  27,  28,  29,  32,  33,  30,  31,  28,  28,  21,  11,   3,   6,  12,  15,  14,  14,  12,  11,   9,   7,   5,   3,   1,   0,  -2,  -3,  -5,  -5,  -6,  -7,  -8, -11,  -8, -10, -11,  -9, -10, -11, -11, -10, -10, -10, -10},
  /*  44.0 */ {  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -9,  -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -23, -24, -25, -26, -27, -28, -28, -29, -29, -29, -29, -29, -29, -28, -28, -28, -29, -28, -23, -22, -21, -19, -18, -18, -17, -17, -15, -13, -11, -11, -11,  -9,  -8, -10, -13, -10, -15, -15, -13, -17, -20, -23, -25, -25, -26, -26, -27, -28, -29, -29, -31, -33, -36, -37, -36, -36, -34, -34, -36, -35, -36, -36, -37, -37, -37, -36, -34, -31, -29, -29, -28, -27, -27, -26, -24, -24, -23, -23, -23, -21, -19, -18, -15, -13, -12, -11,  -9,  -7,  -3,   3,   8,  12,  16,  17,  18,  20,  23,  25,  28,  30,  33,  35,  38,  40,  44,  46,  48,  51,  53,  55,  57,  59,  61,  63,  64,  64,  64,  64,  63,  63,  63,  61,  60,  58,  58,  58,  56,  55,  55,  53,  50,  47,  47,  51,  51,  49,  48,  50,  46,  47,  49,  49,  49,  49,  51,  52,  51,  50,  51,  52,  49,  46,  46,  45,  42,  41,  42,  43,  44,  46,  47,  46,  45,  44,  43,  40,  40,  39,  37,  36,  35,  33,  32,  29,  25,  22,  20,  17,  17,  15,  13,  16,  21,  20,  18,  14,   7,   2,  -2,  -5,  -7,  -9, -11, -12, -13, -15, -16, -18, -20, -23, -25, -27, -29, -30, -32, -34, -36, -37, -38, -39, -38, -39, -41, -42, -44, -44, -45, -45, -46, -47, -47, -49, -49, -51, -51, -52, -52, -56, -61, -66, -64, -60, -61, -60, -58, -59, -60, -62, -58, -56, -54, -53, -52, -51, -49, -47, -46, -44, -42, -40, -37, -35, -32, -28, -25, -22, -18, -14, -10,  -6,  -4,  -2,   0,   2,   4,   7,   9,  13,  16,  19,  20,  22,  25,  25,  24,  25,  25,  27,  27,  26,  27,  28,  30,  31,  31,  32,  31,  31,  31,  30,  19,   2,  -3,   2,   9,  11,  12,  11,  10,   8,   6,   4,   3,   2,  -0,  -1,  -3,  -4,  -5,  -5,  -8, -11,  -8, -11, -10,  -9,  -9, -10,  -9,  -9,  -9,  -8,  -8},
  /*  45.0 */ {  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -5,  -6,  -7,  -7,  -8,  -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -22, -24, -25, -26, -26, -27, -27, -28, -28, -28, -27, -26, -27, -26, -27, -27, -27, -23, -22, -20, -20, -19, -17, -16, -15, -15, -14, -13, -11,  -9,  -9,  -7, -12, -11, -14, -15, -15, -15, -17, -20, -22, -23, -24, -25, -25, -27, -27, -28, -28, -31, -31, -34, -36, -37, -37, -36, -35, -36, -37, -37, -37, -37, -36, -35, -34, -34, -32, -30, -30, -28, -27, -26, -26, -25, -24, -23, -22, -21, -20, -18, -17, -15, -13, -10,  -7,  -4,  -2,   3,   6,  10,  14,  17,  19,  21,  23,  26,  28,  30,  32,  34,  37,  39,  42,  44,  46,  49,  51,  53,  55,  57,  60,  61,  63,  65,  65,  65,  65,  64,  64,  63,  62,  61,  59,  59,  59,  59,  57,  55,  56,  54,  53,  51,  48,  46,  46,  45,  45,  44,  47,  48,  47,  47,  49,  51,  53,  53,  51,  52,  53,  45,  42,  39,  41,  43,  43,  44,  46,  46,  46,  46,  45,  44,  43,  43,  42,  38,  37,  34,  32,  33,  32,  31,  29,  27,  26,  26,  22,  18,  16,  14,  13,  13,  13,  11,   8,   4,   1,  -2,  -4,  -6,  -9, -11, -12, -14, -16, -18, -20, -22, -24, -26, -28, -29, -30, -32, -33, -35, -37, -38, -38, -39, -41, -42, -43, -44, -44, -45, -47, -48, -50, -49, -45, -40, -44, -52, -56, -58, -63, -66, -67, -65, -61, -59, -57, -57, -57, -56, -53, -53, -51, -49, -49, -49, -49, -47, -47, -46, -44, -42, -40, -37, -34, -32, -29, -26, -22, -18, -15, -12,  -8,  -5,  -2,   0,   2,   4,   6,   8,  11,  14,  16,  18,  20,  23,  24,  23,  24,  25,  29,  30,  26,  26,  27,  28,  29,  28,  28,  27,  26,  26,  26,  28,  24,  14,   1,  -4,   3,  10,  12,  11,  10,   8,   6,   5,   3,   2,  -0,  -2,  -3,  -4,  -5,  -7, -10,  -3, -10,  -9,  -8,  -9,  -7,  -8,  -7,  -7,  -7,  -6},
  /*  46.0 */ {  -5,  -4,  -4,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,  -0,  -1,  -1,  -0,  -0,  -1,  -1,  -2,  -3,  -4,  -4,  -5,  -6,  -7,  -8,  -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -20, -21, -22, -23, -24, -25, -25, -26, -26, -26, -26, -25, -25, -25, -25, -25, -26, -26, -23, -20, -20, -20, -20, -21, -18, -16, -16, -15, -13, -12, -12, -11, -11, -13, -14, -15, -16, -16, -16, -16, -19, -21, -22, -24, -25, -26, -27, -27, -27, -28, -28, -30, -31, -32, -34, -35, -36, -36, -37, -38, -38, -38, -37, -37, -36, -35, -34, -33, -33, -32, -29, -28, -26, -25, -25, -24, -22, -20, -19, -18, -17, -15, -13, -12,  -9,  -6,  -2,   1,   4,   7,  10,  14,  18,  20,  24,  26,  29,  29,  31,  33,  35,  38,  40,  42,  45,  47,  49,  52,  53,  55,  57,  60,  61,  63,  65,  66,  66,  66,  65,  64,  63,  61,  61,  61,  60,  59,  59,  57,  55,  54,  52,  50,  49,  48,  47,  47,  47,  46,  48,  49,  48,  48,  48,  49,  50,  50,  50,  49,  49,  51,  52,  48,  49,  49,  48,  45,  47,  47,  46,  45,  45,  45,  44,  43,  42,  42,  41,  39,  37,  32,  31,  31,  29,  27,  25,  23,  22,  20,  17,  15,  13,  12,  11,   9,   7,   6,   3,   1,  -1,  -4,  -6,  -8, -10, -12, -15, -16, -18, -20, -22, -24, -26, -27, -29, -30, -31, -33, -35, -36, -37, -38, -39, -41, -41, -42, -43, -44, -44, -46, -48, -50, -51, -51, -51, -50, -52, -51, -51, -56, -60, -61, -60, -58, -54, -53, -51, -50, -49, -52, -50, -49, -49, -49, -48, -46, -45, -45, -44, -42, -41, -39, -36, -34, -32, -28, -25, -22, -19, -16, -13, -11,  -7,  -3,   0,   2,   4,   5,   7,  10,  12,  14,  17,  19,  20,  21,  22,  22,  24,  27,  29,  29,  26,  25,  26,  26,  26,  26,  24,  23,  23,  23,  23,  24,  25,  24,  17,   7,   4,  10,  12,  12,  10,   9,   7,   5,   3,   1,  -1,  -2,  -3,  -4,  -7,  -4,  -5,  -9,  -7,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -5},
  /*  47.0 */ {  -3,  -3,  -2,  -1,  -1,  -1,   0,   0,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   1,   0,  -0,  -1,  -2,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -10, -11, -13, -14, -15, -16, -18, -19, -20, -21, -22, -22, -23, -24, -24, -24, -24, -23, -23, -23, -24, -24, -25, -24, -23, -21, -20, -18, -20, -20, -19, -17, -16, -15, -14, -13, -13, -12, -12, -12, -14, -15, -16, -16, -16, -17, -19, -21, -22, -24, -25, -26, -27, -28, -29, -30, -29, -31, -32, -33, -35, -36, -37, -37, -37, -37, -37, -37, -37, -37, -37, -36, -35, -34, -33, -31, -29, -28, -28, -26, -24, -22, -21, -20, -19, -18, -17, -15, -14, -11,  -8,  -4,  -0,   3,   6,   8,  11,  15,  17,  21,  25,  28,  32,  35,  36,  35,  36,  38,  41,  44,  46,  48,  50,  52,  54,  56,  57,  60,  62,  63,  65,  66,  66,  66,  65,  64,  62,  62,  62,  61,  60,  59,  58,  57,  56,  55,  53,  50,  50,  50,  49,  48,  48,  50,  50,  49,  49,  48,  48,  48,  48,  48,  48,  48,  50,  49,  48,  48,  49,  50,  50,  49,  48,  48,  47,  45,  45,  44,  43,  42,  42,  41,  39,  39,  36,  33,  33,  31,  29,  28,  25,  24,  22,  21,  20,  18,  15,  14,  11,   9,   7,   5,   2,  -1,  -4,  -6,  -8, -11, -14, -15, -16, -18, -19, -20, -21, -22, -23, -25, -27, -29, -30, -32, -34, -35, -35, -36, -37, -39, -39, -41, -42, -43, -44, -45, -46, -47, -47, -48, -49, -49, -49, -48, -47, -47, -48, -53, -54, -51, -47, -43, -45, -47, -49, -49, -48, -47, -46, -45, -44, -43, -44, -44, -43, -42, -40, -38, -35, -33, -31, -28, -26, -23, -20, -17, -15, -12,  -8,  -4,  -1,   2,   4,   5,   7,   9,  12,  13,  16,  18,  19,  20,  20,  21,  23,  25,  26,  28,  27,  25,  24,  24,  25,  25,  22,  21,  20,  21,  21,  21,  22,  23,  25,  24,  16,   4,  10,  12,  12,  10,   9,   7,   5,   3,   1,   0,  -1,  -3,  -7,  -3,  -4,  -6,  -5,  -4,  -5,  -5,  -4,  -4,  -4,  -3,  -3},
  /*  48.0 */ {  -1,  -0,  -0,   1,   1,   1,   2,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   2,   1,   1,  -0,  -1,  -2,  -3,  -4,  -4,  -5,  -7,  -8,  -9, -10, -11, -12, -14, -15, -16, -17, -18, -19, -20, -21, -21, -22, -22, -22, -22, -22, -22, -22, -23, -23, -23, -20, -20, -22, -18, -18, -18, -17, -17, -16, -15, -15, -13, -14, -14, -15, -15, -16, -16, -17, -17, -18, -18, -18, -21, -22, -24, -25, -27, -27, -28, -29, -31, -32, -31, -33, -35, -35, -36, -37, -37, -37, -37, -38, -38, -38, -38, -38, -36, -35, -33, -33, -32, -30, -28, -28, -27, -24, -22, -21, -20, -19, -18, -17, -16, -14,  -9,  -4,  -2,   2,   5,   8,   9,  13,  17,  21,  25,  27,  29,  32,  35,  36,  36,  37,  40,  42,  44,  46,  49,  51,  52,  54,  56,  58,  60,  62,  63,  65,  66,  65,  65,  64,  63,  63,  63,  62,  62,  61,  60,  58,  57,  56,  55,  54,  53,  52,  52,  53,  54,  52,  51,  51,  50,  49,  48,  47,  46,  46,  46,  46,  47,  48,  49,  49,  48,  47,  46,  45,  45,  45,  46,  46,  44,  44,  44,  43,  41,  40,  39,  38,  36,  34,  34,  33,  31,  30,  28,  25,  24,  22,  21,  20,  18,  16,  14,  12,   9,   7,   4,   1,  -3,  -5,  -9, -12, -13, -14, -16, -17, -18, -19, -20, -22, -21, -20, -22, -24, -27, -29, -31, -33, -33, -33, -34, -35, -36, -38, -40, -41, -41, -42, -43, -43, -43, -43, -43, -45, -46, -47, -50, -51, -51, -51, -49, -46, -43, -42, -44, -48, -49, -49, -48, -47, -46, -44, -44, -44, -44, -44, -43, -43, -41, -40, -37, -34, -32, -30, -28, -26, -23, -21, -18, -16, -13,  -9,  -6,  -2,   2,   3,   5,   7,   9,  11,  14,  16,  17,  18,  19,  19,  20,  21,  22,  23,  25,  26,  26,  24,  22,  24,  23,  22,  22,  20,  20,  20,  20,  20,  21,  21,  24,  25,  15,   2,   7,  10,  10,   9,   8,   6,   5,   3,   2,   1,  -2,  -4,  -0,  -6,  -3,  -2,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -1},
  /*  49.0 */ {   0,   1,   1,   2,   2,   3,   4,   4,   5,   6,   6,   6,   6,   7,   7,   7,   7,   6,   6,   5,   5,   5,   4,   3,   3,   2,   1,   0,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -11, -12, -13, -14, -16, -17, -18, -18, -19, -19, -20, -20, -20, -21, -21, -22, -21, -20, -17, -17, -21, -19, -17, -16, -16, -16, -16, -15, -15, -15, -14, -15, -15, -16, -16, -17, -17, -17, -18, -19, -19, -20, -21, -22, -23, -25, -27, -28, -29, -31, -32, -33, -34, -35, -36, -37, -38, -38, -39, -39, -38, -38, -39, -39, -39, -39, -38, -37, -36, -35, -34, -33, -30, -27, -27, -26, -24, -20, -19, -20, -20, -18, -16, -14, -10,  -3,   2,   5,   7,   9,  12,  15,  22,  24,  22,  23,  26,  29,  33,  35,  37,  39,  41,  43,  45,  47,  50,  52,  53,  55,  56,  58,  60,  62,  64,  65,  65,  64,  64,  64,  63,  63,  63,  62,  61,  60,  59,  58,  57,  56,  56,  58,  58,  58,  56,  55,  54,  53,  52,  51,  50,  49,  48,  47,  46,  45,  45,  45,  47,  47,  48,  48,  48,  48,  47,  46,  47,  47,  46,  46,  43,  43,  43,  43,  41,  39,  37,  33,  32,  34,  34,  33,  31,  28,  26,  23,  23,  21,  19,  17,  15,  13,  10,  10,   9,   7,   5,   1,  -3,  -5,  -7,  -9, -12, -14, -15, -16, -16, -16, -19, -21, -22, -20, -19, -22, -24, -27, -29, -31, -31, -31, -32, -33, -34, -35, -37, -38, -39, -40, -40, -40, -40, -40, -42, -44, -45, -45, -46, -47, -44, -44, -42, -41, -42, -43, -44, -46, -47, -46, -46, -45, -45, -45, -44, -43, -43, -42, -42, -41, -40, -39, -37, -34, -32, -30, -28, -25, -23, -21, -19, -16, -13, -10,  -7,  -3,   0,   3,   5,   7,   9,  11,  13,  14,  16,  16,  18,  19,  20,  20,  21,  21,  23,  24,  24,  23,  21,  22,  22,  21,  21,  20,  20,  20,  20,  21,  21,  21,  22,  25,  25,  12,   1,   4,   8,   9,   9,   8,   7,   5,   4,   2,  -1,   1,   1,  -2,   0,   0,  -0,  -0,   0,  -0,   0,   0,   0,   0},
  /*  50.0 */ {  -6,  -6,  -5,  -4,  -2,  -1,   1,   2,   3,   5,   5,   7,   7,   8,   8,   9,   9,   8,   8,   8,   7,   7,   7,   6,   5,   5,   4,   3,   2,   1,  -0,  -1,  -2,  -3,  -4,  -5,  -7,  -8,  -9, -10, -12, -13, -14, -15, -16, -17, -17, -17, -18, -18, -18, -20, -20, -16, -15, -17, -17, -17, -17, -16, -16, -16, -16, -16, -15, -14, -16, -17, -18, -17, -17, -17, -17, -19, -19, -19, -20, -20, -21, -23, -24, -25, -27, -28, -29, -30, -31, -33, -34, -35, -35, -36, -38, -39, -39, -40, -40, -39, -39, -39, -40, -40, -40, -39, -38, -36, -35, -33, -31, -29, -26, -25, -24, -24, -23, -23, -21, -19, -18, -16, -13, -10,  -5,   1,   4,   8,  11,  13,  16,  22,  24,  23,  23,  26,  29,  32,  35,  38,  40,  42,  45,  47,  49,  51,  53,  54,  56,  57,  59,  61,  62,  63,  64,  64,  64,  63,  63,  63,  63,  63,  62,  61,  60,  58,  58,  57,  56,  57,  57,  59,  58,  58,  56,  55,  54,  53,  52,  50,  48,  46,  45,  45,  45,  45,  46,  47,  48,  49,  48,  48,  48,  47,  47,  47,  46,  45,  44,  44,  43,  42,  40,  37,  35,  33,  31,  32,  32,  32,  31,  29,  27,  25,  23,  21,  19,  16,  14,  12,  11,  11,  11,  10,   8,   5,   3,   0,  -5,  -7,  -8, -10, -12, -14, -15, -15, -16, -17, -20, -21, -18, -17, -19, -22, -24, -26, -28, -29, -29, -30, -31, -32, -33, -34, -35, -35, -36, -38, -39, -40, -42, -44, -45, -45, -45, -44, -43, -43, -41, -41, -40, -41, -42, -42, -45, -46, -46, -46, -45, -43, -43, -42, -42, -41, -41, -40, -40, -40, -39, -37, -34, -32, -30, -27, -25, -23, -21, -19, -16, -14, -11,  -8,  -5,  -1,   3,   5,   7,   9,  11,  12,  12,  13,  15,  17,  19,  20,  21,  21,  20,  21,  22,  23,  22,  21,  21,  22,  21,  19,  19,  19,  19,  20,  20,  21,  21,  22,  22,  24,  24,  16,   5,   2,   6,   8,   8,   8,   7,   5,   4,   3,   4,   1,   3,   2,   2,   1,   1,   1,   1,  -1,  -3,  -5,  -6},
  /*  51.0 */ {  -8,  -6,  -7,  -8, -10, -11, -11, -10,  -7,  -5,  -2,   2,   5,   8,   9,  10,  10,  10,  10,  10,  10,  10,   9,   8,   7,   7,   6,   5,   4,   3,   3,   2,   1,  -0,  -1,  -3,  -3,  -5,  -6,  -8,  -9, -10, -11, -13, -14, -14, -15, -15, -16, -17, -17, -16, -15, -15, -15, -15, -14, -14, -15, -15, -16, -16, -16, -16, -14, -13, -17, -18, -19, -19, -19, -20, -20, -21, -21, -21, -21, -22, -23, -25, -27, -28, -30, -31, -31, -32, -33, -34, -35, -36, -37, -38, -39, -40, -40, -40, -41, -42, -41, -41, -42, -42, -41, -39, -37, -36, -34, -33, -32, -29, -26, -24, -22, -21, -20, -19, -18, -17, -15, -13, -10,  -8,  -5,  -2,   3,   9,  11,  14,  16,  20,  24,  24,  25,  27,  31,  34,  36,  39,  41,  43,  45,  48,  50,  52,  53,  55,  57,  58,  59,  61,  62,  63,  63,  63,  63,  63,  63,  63,  63,  62,  62,  60,  59,  58,  57,  59,  60,  58,  59,  60,  59,  58,  56,  55,  54,  54,  53,  51,  48,  46,  45,  45,  44,  45,  45,  45,  46,  47,  48,  48,  47,  46,  46,  44,  44,  43,  42,  41,  39,  38,  37,  36,  34,  31,  30,  30,  30,  30,  28,  25,  25,  25,  23,  20,  18,  16,  14,  13,  12,  11,  10,   9,   7,   6,   5,   3,  -1,  -4,  -6,  -8, -10, -11, -13, -14, -15, -17, -18, -18, -16, -16, -18, -20, -23, -24, -26, -27, -27, -28, -29, -30, -31, -32, -33, -35, -36, -38, -39, -40, -41, -42, -43, -43, -42, -42, -41, -41, -41, -40, -40, -40, -41, -42, -43, -43, -43, -43, -43, -43, -42, -40, -40, -39, -38, -38, -38, -38, -39, -37, -34, -32, -29, -27, -25, -23, -21, -19, -16, -14, -11,  -8,  -5,  -2,   2,   4,   6,   8,   9,  10,  11,  12,  14,  16,  17,  18,  20,  20,  20,  19,  20,  21,  21,  20,  19,  20,  18,  17,  17,  18,  18,  18,  19,  19,  20,  22,  23,  23,  25,  25,  20,   6,   1,   5,   7,   8,   8,   8,   6,   6,   6,   5,   4,   3,   1,  -1,  -4,  -5,  -9, -10,  -8,  -5,  -8},
  /*  52.0 */ {   4,   2,   4,   5,   7,   8,   7,   6,   6,   3,   2,  -2,  -3,  -0,   2,   6,   8,  10,  11,  11,  11,  11,  11,  10,  10,   9,   9,   8,   7,   7,   6,   5,   4,   2,   1,   0,  -1,  -2,  -4,  -5,  -7,  -8,  -9, -10, -11, -12, -12, -13, -14, -13, -14, -14, -14, -14, -13, -12, -13, -14, -14, -14, -15, -15, -15, -13, -12, -15, -18, -19, -20, -20, -20, -20, -21, -22, -22, -22, -23, -24, -24, -27, -30, -31, -32, -33, -33, -33, -34, -35, -36, -37, -39, -41, -42, -43, -43, -42, -43, -43, -43, -43, -44, -43, -42, -40, -39, -36, -34, -33, -31, -30, -28, -26, -23, -20, -18, -17, -16, -15, -13, -10,  -8,  -5,  -1,   2,   4,   9,  12,  15,  17,  21,  22,  24,  26,  29,  32,  34,  36,  39,  42,  45,  47,  49,  50,  52,  54,  56,  57,  58,  60,  61,  61,  62,  62,  62,  62,  62,  62,  62,  62,  61,  61,  59,  58,  57,  58,  61,  61,  60,  60,  59,  58,  58,  56,  56,  55,  54,  54,  52,  49,  48,  46,  45,  45,  44,  44,  43,  44,  44,  45,  45,  44,  44,  43,  42,  41,  40,  39,  37,  35,  33,  33,  32,  30,  29,  28,  28,  27,  26,  24,  21,  22,  23,  21,  20,  18,  16,  14,  13,  12,  11,  10,   8,   7,   7,   6,   4,   2,  -0,  -1,  -3,  -4,  -6,  -7,  -8,  -9, -12, -14, -14, -13, -13, -16, -18, -21, -23, -25, -25, -25, -26, -27, -28, -29, -30, -31, -33, -34, -36, -37, -39, -40, -41, -41, -41, -42, -43, -44, -43, -43, -42, -41, -39, -39, -40, -41, -42, -43, -41, -40, -40, -39, -38, -37, -37, -38, -38, -39, -40, -39, -36, -34, -32, -30, -27, -25, -23, -21, -19, -16, -14, -12,  -9,  -7,  -4,  -0,   2,   4,   6,   7,   8,   9,  11,  12,  14,  16,  18,  19,  19,  18,  18,  19,  20,  20,  19,  19,  18,  18,  16,  16,  17,  18,  19,  19,  20,  20,  21,  22,  23,  24,  24,  24,  12,   2,  -1,   3,   7,   8,   9,   9,   8,   6,   3,   1,  -3,  -6,  -2,   1,   5,   6,   4,   6,   6,   4},
  /*  53.0 */ {   5,   2,   2,   2,   3,   3,   5,   6,   8,  10,  13,  14,  14,  10,   4,   0,   0,   2,   4,   7,   9,  10,  11,  11,  12,  11,  11,  10,   9,   8,   7,   6,   6,   5,   3,   2,   1,  -0,  -2,  -3,  -5,  -6,  -7,  -8,  -9,  -9, -11, -12,  -9, -11, -12, -12, -13, -12, -11, -12, -12, -13, -13, -14, -14, -15, -14, -15, -16, -18, -20, -21, -22, -22, -22, -22, -22, -23, -24, -24, -25, -26, -27, -28, -30, -32, -33, -34, -34, -35, -36, -38, -39, -40, -41, -42, -43, -44, -45, -45, -45, -45, -45, -45, -45, -44, -43, -41, -39, -37, -34, -32, -30, -29, -27, -25, -23, -22, -19, -18, -16, -15, -14, -10,  -7,  -3,  -0,   4,   7,  10,  13,  15,  19,  21,  23,  25,  28,  31,  34,  36,  39,  41,  44,  45,  47,  50,  51,  54,  56,  58,  59,  59,  60,  60,  60,  60,  61,  61,  61,  61,  61,  60,  60,  60,  60,  60,  60,  59,  59,  60,  61,  60,  61,  60,  59,  58,  57,  56,  56,  55,  55,  53,  51,  49,  46,  45,  44,  43,  42,  42,  42,  41,  41,  41,  41,  41,  40,  39,  37,  36,  34,  33,  31,  30,  31,  30,  29,  28,  28,  27,  26,  24,  22,  20,  19,  19,  18,  17,  17,  16,  14,  12,  11,  10,   9,   8,   8,   7,   5,   5,   4,   3,   1,   0,  -1,  -2,  -3,  -4,  -6,  -9, -11, -12, -11, -12, -15, -17, -19, -20, -23, -24, -24, -25, -26, -27, -28, -29, -30, -32, -33, -35, -37, -38, -39, -39, -40, -40, -40, -41, -41, -42, -41, -40, -39, -39, -40, -41, -41, -40, -40, -40, -39, -38, -37, -36, -36, -37, -38, -38, -37, -36, -35, -35, -34, -31, -29, -27, -25, -23, -20, -19, -17, -15, -12, -10,  -8,  -6,  -4,  -2,   0,   2,   5,   6,   8,   9,  11,  13,  15,  17,  18,  18,  17,  18,  18,  18,  19,  19,  18,  18,  17,  16,  16,  17,  18,  18,  18,  19,  20,  21,  21,  23,  23,  24,  24,  21,  17,   5,  -3,   1,   8,  10,   9,   5,   1,  -3,  -0,   3,   5,   7,   5,   2,   2,   1,   1,   2,   5},
  /*  54.0 */ {   5,  -0,   2,   3,   4,   4,   5,   6,   7,   8,  10,  11,  13,  15,  18,  18,  16,  13,   8,   7,   8,   8,   8,   8,   9,  10,  11,  11,  11,  10,  11,  10,   9,   7,   5,   4,   3,   1,   0,  -1,  -2,  -3,  -4,  -5,  -6,  -8,  -9,  -6,  -8,  -9,  -9, -10, -10, -10, -11, -12, -12, -13, -14, -14, -14, -15, -15, -16, -18, -19, -20, -22, -23, -23, -24, -25, -25, -26, -26, -26, -27, -29, -30, -30, -31, -32, -34, -36, -37, -38, -39, -39, -40, -42, -43, -44, -45, -46, -46, -46, -45, -45, -45, -44, -44, -43, -42, -41, -39, -37, -35, -32, -31, -29, -27, -24, -23, -21, -20, -18, -18, -16, -15, -13,  -9,  -5,  -1,   2,   6,  11,  14,  16,  18,  21,  24,  27,  30,  32,  35,  38,  40,  42,  44,  47,  49,  51,  53,  55,  58,  59,  60,  60,  60,  60,  60,  61,  61,  61,  61,  61,  61,  60,  60,  60,  61,  61,  61,  60,  59,  58,  58,  58,  59,  59,  59,  58,  58,  57,  56,  55,  54,  53,  51,  48,  46,  44,  43,  41,  41,  41,  40,  40,  39,  39,  40,  39,  39,  37,  36,  35,  34,  32,  30,  29,  29,  29,  28,  28,  27,  26,  25,  24,  23,  21,  20,  18,  17,  17,  16,  16,  15,  13,  11,  10,   9,   9,   8,   7,   7,   6,   5,   4,   3,   2,   0,   0,  -1,  -3,  -5,  -8, -10, -11, -10, -10, -12, -14, -17, -18, -20, -22, -23, -24, -26, -27, -27, -28, -30, -31, -33, -34, -36, -37, -38, -38, -39, -39, -39, -39, -40, -39, -39, -40, -38, -36, -37, -39, -40, -39, -39, -38, -37, -36, -36, -37, -39, -40, -39, -38, -36, -34, -34, -33, -32, -33, -31, -27, -24, -22, -21, -19, -17, -15, -13, -11,  -9,  -8,  -6,  -4,  -2,   1,   4,   5,   7,   8,  10,  12,  13,  14,  16,  17,  16,  16,  17,  17,  18,  17,  16,  17,  17,  15,  16,  17,  18,  18,  19,  19,  20,  20,  20,  22,  22,  24,  25,  24,  22,  14,   5,  -1,   4,   6,   2,   0,   2,   4,   4,   3,   2,   2,   2,   3,   3,   2,   2,   4,   5},
  /*  55.0 */ {  -1,   1,   2,   3,   4,   5,   5,   6,   6,   7,   9,  10,  12,  14,  14,  16,  17,  17,  17,  18,  17,  16,  14,  13,  12,  10,   9,  10,  12,  12,  11,   9,   8,   7,   7,   6,   5,   3,   2,   1,   0,  -1,  -2,  -3,  -5,  -7,  -4,  -4,  -5,  -6,  -7,  -8,  -8,  -9,  -9, -10, -11, -12, -12, -14, -15, -16, -17, -17, -18, -19, -20, -22, -23, -24, -25, -26, -27, -28, -28, -29, -29, -31, -31, -32, -33, -34, -35, -37, -39, -40, -41, -42, -42, -43, -45, -46, -46, -47, -47, -46, -45, -45, -45, -44, -44, -44, -43, -41, -39, -37, -35, -33, -31, -29, -26, -24, -23, -20, -17, -16, -15, -13, -12, -11,  -8,  -4,  -1,   3,   8,  13,  15,  16,  18,  22,  25,  28,  31,  34,  37,  39,  41,  43,  45,  47,  50,  52,  54,  56,  58,  60,  60,  60,  60,  60,  60,  60,  61,  61,  61,  61,  61,  60,  60,  60,  61,  62,  62,  60,  58,  58,  57,  56,  56,  56,  58,  58,  58,  57,  56,  55,  54,  53,  51,  48,  46,  44,  43,  42,  42,  41,  41,  40,  41,  40,  40,  39,  37,  36,  34,  34,  33,  31,  29,  28,  27,  26,  25,  25,  25,  24,  23,  22,  21,  20,  19,  19,  17,  17,  16,  16,  15,  15,  14,  12,  11,  10,   9,   7,   6,   6,   6,   5,   4,   3,   2,   1,  -0,  -2,  -4,  -6,  -8, -10,  -9,  -9, -10, -12, -14, -17, -18, -20, -22, -23, -24, -25, -26, -27, -29, -30, -32, -33, -34, -35, -35, -36, -36, -36, -36, -37, -37, -37, -38, -37, -35, -36, -38, -38, -38, -38, -37, -38, -38, -38, -38, -40, -40, -40, -39, -37, -35, -34, -33, -32, -32, -32, -30, -26, -25, -23, -20, -18, -17, -15, -13, -11,  -9,  -8,  -6,  -4,  -2,   0,   2,   4,   5,   7,   9,  12,  13,  14,  14,  15,  15,  15,  16,  16,  16,  15,  16,  16,  16,  16,  17,  18,  18,  19,  19,  20,  20,  20,  20,  21,  21,  24,  25,  23,  22,  20,  14,   1,  -1,   1,   8,  14,   9,   7,   5,   2,   2,   2,  -0,  -2,   1,   4,   4,   2,  -1},
  /*  56.0 */ {   2,   2,   3,   3,   3,   3,   3,   4,   5,   8,  10,  12,  13,  13,  14,  14,  15,  15,  15,  16,  17,  16,  14,  13,  12,  13,  14,  11,   7,   6,   7,   8,   9,   9,   8,   8,   6,   6,   5,   3,   2,   1,  -1,  -2,  -4,  -1,  -0,  -1,  -2,  -2,  -3,  -6,  -7,  -7,  -8,  -8, -10, -11, -13, -14, -15, -16, -17, -18, -19, -20, -21, -23, -24, -25, -27, -28, -29, -29, -29, -30, -31, -31, -32, -33, -34, -35, -37, -38, -40, -41, -42, -43, -44, -45, -46, -48, -47, -48, -48, -48, -47, -47, -46, -45, -44, -44, -43, -41, -39, -37, -35, -33, -31, -29, -27, -26, -25, -21, -17, -15, -13, -11, -10,  -9,  -6,  -0,   5,   6,   8,  11,  14,  17,  20,  23,  26,  28,  31,  34,  37,  39,  41,  43,  45,  47,  49,  52,  54,  56,  58,  60,  61,  61,  61,  61,  61,  61,  61,  61,  61,  61,  62,  63,  63,  61,  61,  61,  61,  62,  62,  60,  58,  57,  55,  56,  57,  58,  58,  57,  56,  55,  54,  52,  50,  48,  47,  45,  45,  44,  43,  42,  42,  41,  41,  40,  39,  38,  37,  36,  35,  33,  32,  30,  28,  26,  25,  25,  24,  23,  23,  22,  21,  21,  20,  19,  19,  17,  17,  17,  17,  16,  15,  15,  14,  13,  12,  10,   9,   8,   8,   7,   6,   6,   5,   4,   3,   1,  -1,  -2,  -5,  -6,  -7,  -7,  -7,  -8,  -8, -10, -13, -16, -18, -19, -20, -22, -23, -24, -25, -27, -28, -30, -31, -31, -32, -34, -34, -35, -35, -35, -35, -36, -36, -36, -36, -36, -37, -38, -38, -38, -38, -39, -39, -39, -40, -41, -41, -41, -40, -39, -38, -37, -36, -34, -34, -33, -32, -29, -28, -27, -26, -24, -22, -20, -18, -15, -11, -10,  -9,  -8,  -7,  -4,  -2,  -0,   2,   4,   6,   8,  10,  11,  12,  13,  13,  14,  15,  15,  15,  15,  14,  14,  15,  15,  16,  17,  18,  18,  18,  19,  19,  19,  18,  18,  18,  20,  21,  22,  24,  23,  21,  19,  15,  11,   7,   8,   9,   8,   8,   7,   6,   4,   2,   3,   1,   1,  -0,  -0,  -0,   1,   2},
  /*  57.0 */ {   2,   2,   2,   3,   3,   2,   5,  10,  11,  11,  12,  12,  12,  13,  13,  14,  15,  15,  15,  15,  14,  15,  16,  15,  12,  12,  13,  14,  15,  14,  11,   8,   7,   8,   8,   8,   7,   6,   5,   4,   3,   1,   0,  -1,   1,   2,   1,   1,   1,   1,  -2,  -3,  -4,  -5,  -6,  -8,  -8, -10, -12, -13, -14, -15, -17, -19, -20, -22, -22, -23, -25, -26, -28, -29, -29, -30, -30, -31, -32, -33, -34, -35, -36, -38, -39, -41, -42, -43, -45, -46, -47, -47, -48, -48, -49, -49, -48, -48, -48, -48, -47, -45, -44, -44, -42, -41, -39, -37, -35, -33, -31, -29, -28, -27, -23, -20, -16, -13, -11, -10,  -9,  -7,  -1,   4,   6,   8,  11,  13,  16,  18,  21,  24,  27,  29,  32,  34,  37,  39,  42,  44,  46,  47,  49,  51,  53,  55,  57,  60,  61,  62,  62,  62,  62,  61,  61,  61,  61,  61,  61,  61,  62,  62,  61,  60,  60,  60,  60,  60,  60,  57,  55,  56,  56,  58,  58,  57,  56,  55,  54,  52,  50,  48,  47,  46,  46,  44,  43,  43,  42,  41,  40,  39,  38,  38,  37,  36,  34,  32,  30,  28,  27,  25,  23,  22,  22,  21,  20,  21,  21,  20,  19,  19,  18,  16,  16,  17,  16,  14,  13,  13,  13,  13,  12,  11,   9,   9,   8,   9,   8,   7,   6,   5,   4,   2,   0,  -1,  -3,  -5,  -5,  -5,  -6,  -6,  -7, -10, -12, -14, -16, -18, -19, -21, -22, -23, -25, -26, -28, -29, -29, -30, -31, -32, -33, -34, -34, -34, -35, -35, -36, -36, -36, -37, -38, -38, -38, -39, -39, -39, -39, -40, -41, -40, -40, -40, -39, -38, -37, -36, -35, -35, -34, -34, -33, -30, -27, -24, -24, -23, -21, -19, -17, -15, -13, -12, -10, -10,  -8,  -5,  -4,  -2,   1,   4,   6,   7,   9,  10,  11,  11,  12,  12,  14,  15,  15,  15,  14,  14,  14,  15,  15,  16,  17,  17,  18,  18,  18,  17,  17,  16,  17,  18,  19,  20,  21,  21,  20,  19,  18,  15,  11,  10,  10,   9,   8,   7,   6,   5,   3,   2,   2,   2,   1,   1,   1,   2,   2},
  /*  58.0 */ {   2,   1,   1,   2,   4,   4,   7,   9,   9,  10,  11,  11,  12,  12,  13,  14,  14,  14,  15,  15,  15,  15,  15,  15,  16,  15,  13,  13,  12,  13,  14,  13,  10,   6,   6,   7,   7,   7,   5,   4,   3,   3,   2,   3,   4,   3,   2,   3,   2,   1,  -0,  -1,  -2,  -4,  -5,  -6,  -9, -12, -13, -15, -15, -17, -19, -20, -21, -23, -24, -24, -26, -28, -29, -30, -31, -32, -32, -33, -34, -35, -36, -37, -38, -40, -41, -43, -44, -45, -46, -47, -48, -48, -48, -49, -49, -48, -48, -48, -47, -47, -46, -45, -44, -42, -41, -38, -37, -35, -33, -32, -30, -28, -28, -26, -22, -19, -16, -12,  -9,  -8,  -7,  -3,   3,   5,   6,   9,  11,  14,  17,  19,  22,  25,  27,  30,  32,  35,  38,  40,  42,  43,  45,  47,  49,  51,  52,  54,  56,  58,  60,  62,  63,  63,  63,  63,  63,  62,  62,  61,  61,  61,  61,  61,  61,  61,  61,  60,  60,  60,  60,  57,  56,  56,  56,  58,  57,  57,  56,  55,  53,  50,  49,  49,  48,  47,  46,  45,  44,  43,  42,  42,  41,  39,  38,  37,  36,  34,  33,  31,  29,  27,  25,  22,  21,  20,  20,  20,  19,  19,  20,  19,  18,  17,  16,  15,  16,  15,  15,  15,  14,  14,  14,  13,  12,  11,  11,  10,   9,   9,   9,   8,   7,   6,   5,   4,   2,   1,  -1,  -2,  -3,  -3,  -4,  -5,  -5,  -8, -11, -13, -15, -16, -18, -20, -21, -22, -24, -25, -26, -27, -28, -29, -30, -30, -32, -33, -33, -34, -34, -35, -36, -36, -35, -35, -36, -37, -37, -38, -38, -37, -36, -38, -39, -40, -40, -40, -39, -37, -36, -35, -34, -34, -34, -33, -33, -32, -29, -27, -24, -22, -20, -19, -17, -16, -16, -14, -13, -11,  -9,  -7,  -5,  -2,   1,   2,   4,   6,   7,   8,  10,  10,  10,  11,  11,  12,  14,  15,  14,  13,  13,  13,  13,  14,  15,  15,  16,  16,  17,  17,  16,  16,  17,  16,  17,  19,  19,  18,  18,  19,  17,  15,  13,  10,  10,   9,   7,   6,   7,   6,   3,   2,   2,   1,   1,   1,   1,   1,   2},
  /*  59.0 */ {   1,   1,   4,   6,   6,   7,   8,   8,   9,   9,  10,  11,  11,  12,  12,  13,  13,  14,  15,  15,  15,  15,  15,  15,  15,  15,  14,  12,  11,  10,  11,  13,  12,  11,   8,   7,   6,   6,   7,   8,   7,   5,   7,   9,   6,   5,   5,   3,   2,   2,   0,  -1,  -3,  -4,  -5,  -8, -11, -12, -13, -15, -17, -18, -19, -20, -20, -21, -24, -27, -29, -30, -31, -32, -33, -33, -34, -35, -35, -36, -38, -40, -41, -42, -43, -45, -46, -48, -49, -49, -49, -49, -48, -48, -48, -48, -48, -47, -46, -46, -45, -44, -44, -42, -39, -36, -34, -33, -31, -29, -28, -27, -26, -24, -21, -18, -15, -11,  -7,  -5,  -1,   3,   5,   5,   7,  10,  13,  15,  18,  21,  23,  25,  28,  31,  34,  36,  38,  40,  43,  45,  46,  47,  49,  50,  52,  53,  55,  57,  59,  61,  62,  63,  64,  64,  63,  63,  63,  62,  62,  61,  61,  61,  60,  61,  61,  60,  59,  59,  58,  56,  56,  55,  56,  55,  55,  57,  56,  55,  54,  52,  51,  48,  47,  47,  46,  45,  44,  44,  44,  45,  44,  42,  40,  38,  35,  33,  31,  29,  28,  26,  24,  21,  19,  18,  19,  20,  20,  19,  18,  17,  17,  16,  15,  15,  15,  16,  17,  16,  15,  14,  14,  14,  13,  13,  13,  11,  10,   9,   9,   8,   7,   7,   6,   5,   4,   2,   1,   0,  -1,  -2,  -3,  -3,  -5,  -9, -10, -12, -14, -15, -17, -18, -20, -21, -22, -24, -25, -27, -28, -28, -29, -30, -31, -31, -32, -33, -33, -34, -34, -34, -35, -34, -35, -36, -37, -36, -35, -34, -34, -34, -34, -35, -36, -36, -36, -36, -36, -34, -32, -32, -32, -31, -31, -30, -29, -28, -27, -25, -23, -20, -19, -19, -19, -18, -16, -14, -11,  -8,  -6,  -5,  -3,  -1,   0,   1,   2,   4,   6,   7,   8,   9,  10,  11,  12,  13,  13,  13,  13,  13,  13,  13,  14,  14,  15,  16,  17,  18,  17,  17,  16,  16,  16,  16,  16,  17,  17,  17,  16,  14,  14,  12,  10,   7,   6,   6,   7,   5,   1,   0,   0,   0,  -0,   0,   0,   1,   1},
  /*  60.0 */ {   0,   3,   5,   5,   5,   6,   7,   7,   8,   9,   9,  10,  10,  11,  12,  12,  12,  13,  13,  15,  15,  15,  15,  15,  15,  15,  14,  13,   9,  11,  13,  13,  13,  12,  12,  12,  11,  10,  11,  10,  11,  12,  11,  10,   8,   7,   5,   4,   3,   2,   0,  -1,  -3,  -4,  -5,  -7, -10, -12, -12, -14, -16, -17, -18, -20, -22, -24, -26, -28, -29, -30, -31, -32, -33, -34, -35, -36, -37, -39, -40, -41, -42, -43, -44, -46, -47, -48, -49, -50, -49, -48, -47, -46, -47, -47, -47, -45, -44, -43, -43, -42, -42, -41, -38, -35, -32, -30, -28, -27, -25, -24, -23, -21, -19, -17, -13,  -8,  -5,  -2,   1,   4,   5,   7,   9,  11,  14,  17,  19,  22,  24,  27,  29,  30,  33,  36,  39,  41,  44,  45,  48,  48,  49,  50,  51,  52,  54,  56,  58,  60,  61,  63,  64,  64,  64,  64,  64,  63,  63,  62,  61,  61,  61,  60,  60,  60,  60,  60,  60,  58,  58,  57,  55,  56,  56,  55,  55,  54,  54,  53,  51,  49,  48,  47,  47,  45,  45,  45,  44,  45,  45,  42,  40,  39,  36,  33,  31,  29,  27,  25,  23,  20,  19,  19,  19,  20,  19,  18,  16,  16,  15,  15,  16,  16,  16,  16,  16,  16,  14,  12,  11,  12,  11,  11,  11,  11,  11,  10,   8,   7,   7,   7,   6,   5,   4,   3,   2,   0,  -1,  -2,  -3,  -3,  -4,  -8, -10, -11, -13, -15, -16, -17, -18, -20, -21, -23, -24, -25, -26, -26, -28, -28, -29, -30, -31, -31, -32, -32, -32, -32, -32, -32, -33, -34, -34, -33, -32, -31, -31, -33, -35, -35, -34, -34, -34, -34, -33, -33, -32, -31, -31, -31, -29, -28, -28, -28, -28, -28, -27, -26, -23, -20, -19, -18, -17, -15, -12, -10,  -8,  -6,  -4,  -3,  -2,  -1,   1,   2,   4,   4,   5,   5,   6,   9,  10,  11,  12,  13,  12,  13,  14,  14,  14,  14,  14,  15,  16,  17,  17,  17,  17,  16,  15,  14,  14,  14,  14,  15,  14,  13,  13,  13,  12,  11,   9,   8,   9,   4,  -1,  -1,  -1,  -2,  -2,  -1,  -0,   0,   0},
  /*  61.0 */ {   5,   4,   4,   4,   5,   6,   6,   7,   7,   7,   8,   8,   9,  10,  11,  11,  11,  12,  12,  13,  14,  14,  14,  14,  14,  15,  15,  15,  11,   6,   8,  12,  14,  16,  17,  18,  18,  16,  15,  17,  16,  13,  12,  10,   8,   7,   6,   5,   4,   3,   1,  -0,  -1,  -2,  -3,  -5,  -8, -11, -12, -14, -16, -18, -20, -22, -24, -26, -28, -29, -30, -31, -32, -32, -33, -34, -35, -37, -38, -39, -41, -42, -43, -44, -45, -46, -48, -48, -49, -49, -49, -48, -47, -46, -46, -46, -45, -44, -43, -42, -40, -38, -37, -37, -35, -33, -31, -29, -27, -25, -24, -23, -22, -21, -20, -18, -13,  -8,  -3,  -0,   3,   6,   8,   9,  11,  13,  16,  19,  21,  23,  25,  27,  29,  31,  33,  36,  38,  42,  46,  46,  48,  49,  49,  50,  51,  52,  53,  55,  56,  58,  60,  62,  63,  64,  65,  65,  65,  64,  64,  63,  63,  62,  61,  61,  60,  60,  60,  60,  59,  60,  59,  59,  58,  58,  57,  57,  55,  53,  52,  51,  51,  51,  49,  48,  47,  46,  45,  46,  46,  46,  45,  43,  40,  38,  36,  34,  32,  31,  29,  26,  23,  21,  20,  19,  19,  19,  19,  18,  17,  15,  15,  16,  16,  16,  16,  15,  15,  14,  13,  12,  12,  12,  11,  11,  11,  11,  10,   9,   9,   8,   7,   7,   6,   5,   3,   3,   1,  -0,  -2,  -3,  -4,  -3,  -3,  -6,  -9, -10, -11, -13, -15, -17, -18, -19, -20, -21, -23, -24, -24, -25, -26, -27, -27, -28, -29, -29, -29, -29, -29, -29, -29, -29, -30, -31, -30, -30, -30, -30, -31, -32, -33, -34, -34, -34, -33, -33, -32, -31, -31, -30, -30, -30, -29, -28, -27, -26, -26, -26, -26, -26, -24, -21, -19, -19, -17, -15, -13, -11, -10,  -8,  -7,  -6,  -5,  -3,  -1,   0,   2,   3,   3,   4,   5,   8,   9,  11,  11,  12,  13,  13,  13,  14,  14,  14,  15,  15,  15,  16,  16,  16,  17,  16,  15,  14,  13,  13,  14,  14,  14,  12,  11,  12,  12,  12,  11,  10,  10,  10,   8,   5,   3,   1,  -1,  -2,  -0,   4,   5},
  /*  62.0 */ {   5,   5,   4,   5,   5,   6,   6,   6,   6,   6,   7,   7,   8,   8,   9,  10,  10,  11,  11,  12,  12,  12,  12,  12,  12,  14,  16,  15,  12,  10,  11,  16,  18,  18,  17,  17,  18,  18,  17,  15,  13,  12,  11,   9,   8,   7,   6,   5,   4,   2,   2,   1,   0,  -1,  -2,  -4,  -7, -11, -13, -14, -15, -18, -20, -22, -24, -26, -28, -29, -29, -30, -31, -32, -34, -34, -35, -37, -38, -40, -42, -42, -43, -44, -45, -46, -47, -48, -48, -48, -48, -48, -47, -46, -45, -44, -44, -43, -42, -40, -39, -38, -36, -34, -33, -31, -29, -27, -25, -24, -24, -23, -21, -19, -16, -13,  -9,  -5,  -1,   2,   6,  10,   9,  10,  12,  15,  18,  20,  22,  23,  25,  29,  31,  33,  37,  42,  45,  48,  49,  47,  47,  50,  50,  50,  51,  52,  53,  54,  55,  57,  59,  60,  62,  63,  64,  65,  65,  65,  65,  64,  64,  64,  63,  62,  62,  61,  61,  60,  60,  60,  60,  60,  59,  59,  58,  57,  56,  54,  52,  50,  49,  50,  50,  49,  48,  47,  46,  45,  45,  46,  46,  45,  42,  39,  37,  35,  34,  32,  30,  27,  23,  22,  21,  19,  19,  19,  18,  18,  19,  19,  18,  18,  18,  17,  17,  16,  15,  14,  14,  14,  13,  12,  11,  12,  11,  11,  10,   9,   9,   8,   8,   7,   6,   4,   2,   1,  -0,  -1,  -1,  -2,  -3,  -3,  -3,  -6,  -9, -10, -11, -11, -13, -15, -17, -18, -19, -20, -21, -22, -22, -23, -24, -25, -25, -25, -26, -27, -27, -28, -27, -27, -27, -27, -27, -27, -28, -29, -29, -29, -29, -29, -30, -30, -31, -31, -31, -31, -31, -30, -30, -29, -29, -29, -29, -28, -27, -25, -25, -24, -24, -23, -22, -20, -19, -22, -22, -18, -14, -12, -12, -11, -10,  -9,  -8,  -6,  -5,  -3,  -1,  -0,   1,   1,   2,   4,   7,   8,   9,  11,  12,  12,  12,  12,  12,  13,  13,  14,  14,  14,  14,  14,  14,  15,  14,  14,  13,  13,  13,  13,  13,  12,  11,  11,  11,  10,  10,  11,  11,  11,  10,   8,   6,   4,   2,   3,   5,   5,   5},
  /*  63.0 */ {   4,   5,   5,   4,   5,   5,   5,   5,   6,   6,   6,   7,   7,   7,   7,   8,   9,  10,  11,  11,  11,  11,  11,  12,  12,  12,  12,  14,  16,  17,  15,  15,  16,  17,  17,  17,  16,  15,  13,  12,  12,  11,  10,   8,   7,   6,   5,   4,   3,   2,   2,   1,   0,  -1,  -3,  -5,  -8, -11, -12, -14, -16, -18, -20, -22, -23, -25, -27, -27, -28, -29, -30, -31, -32, -34, -35, -36, -38, -39, -41, -42, -43, -44, -45, -45, -45, -45, -45, -45, -45, -44, -44, -43, -43, -42, -41, -41, -40, -39, -38, -37, -36, -35, -33, -32, -31, -29, -28, -26, -23, -20, -16, -13, -11,  -9,  -6,  -4,  -1,   2,   7,  10,  11,  12,  14,  16,  18,  20,  22,  25,  28,  30,  32,  37,  41,  44,  47,  49,  50,  48,  46,  48,  50,  50,  51,  52,  52,  53,  55,  56,  57,  59,  61,  62,  63,  64,  65,  65,  65,  65,  65,  65,  63,  63,  63,  62,  61,  61,  61,  62,  62,  61,  60,  60,  59,  57,  56,  54,  52,  51,  50,  50,  49,  48,  47,  47,  45,  45,  45,  45,  44,  42,  41,  40,  37,  35,  33,  32,  31,  29,  25,  22,  20,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  16,  15,  15,  15,  14,  14,  14,  13,  13,  12,  12,  11,  11,  11,   9,   9,   9,   9,   8,   6,   4,   2,   1,   1,   1,  -0,  -2,  -2,  -2,  -3,  -6,  -8, -10, -11, -11, -12, -13, -14, -16, -17, -18, -19, -20, -21, -21, -22, -23, -23, -23, -24, -24, -24, -25, -24, -25, -26, -26, -26, -27, -26, -27, -27, -27, -28, -29, -29, -29, -29, -30, -30, -30, -29, -30, -30, -29, -29, -29, -28, -26, -25, -24, -24, -23, -22, -22, -23, -22, -20, -18, -18, -17, -15, -14, -14, -13, -13, -12, -11, -11, -10,  -8,  -7,  -6,  -5,  -4,  -2,   1,   5,   7,   8,   8,   9,   9,  10,  11,  11,  11,  12,  12,  12,  12,  12,  11,  12,  13,  13,  13,  13,  13,  13,  12,  12,  11,  12,  12,  11,  10,  10,  10,   9,   9,   9,   8,   7,   7,   6,   5,   5,   5,   4},
  /*  64.0 */ {   4,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   7,   7,   8,   9,  10,  10,  10,  10,  10,  11,  12,  12,  12,  13,  14,  14,  15,  15,  14,  13,  13,  13,  12,  12,  11,  10,  10,   9,   8,   7,   6,   5,   5,   4,   3,   2,  -0,  -3,  -6,  -8,  -9, -11, -13, -14, -16, -18, -19, -21, -22, -23, -24, -25, -27, -28, -29, -30, -32, -34, -34, -35, -37, -39, -40, -42, -43, -44, -44, -43, -43, -42, -41, -41, -40, -40, -40, -40, -39, -39, -38, -37, -37, -36, -35, -34, -34, -33, -32, -31, -29, -28, -26, -23, -20, -16, -13, -11,  -8,  -4,  -2,  -2,  -1,   1,   7,  12,  14,  15,  16,  19,  21,  22,  26,  28,  28,  29,  33,  36,  40,  43,  46,  49,  50,  50,  48,  45,  47,  50,  52,  53,  54,  54,  54,  55,  56,  58,  59,  61,  62,  63,  65,  65,  65,  66,  66,  66,  67,  67,  66,  65,  65,  64,  63,  63,  62,  61,  60,  58,  57,  55,  53,  52,  52,  52,  51,  51,  50,  49,  47,  45,  43,  42,  43,  43,  42,  41,  41,  39,  36,  34,  32,  31,  30,  30,  28,  26,  24,  21,  19,  18,  17,  18,  18,  18,  18,  18,  18,  17,  16,  16,  16,  15,  15,  15,  14,  14,  13,  13,  12,  11,  10,   9,   9,   9,   8,   7,   6,   5,   4,   2,   1,  -0,  -1,  -2,  -3,  -2,  -2,  -4,  -6,  -8, -10, -11, -12, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -21, -21, -21, -21, -22, -22, -22, -22, -23, -24, -25, -25, -25, -25, -24, -24, -25, -27, -28, -28, -28, -28, -28, -29, -29, -29, -28, -27, -26, -26, -26, -25, -24, -23, -22, -21, -20, -20, -20, -20, -20, -19, -18, -18, -18, -17, -16, -16, -15, -14, -13, -11,  -9, -10,  -9,  -6,  -3,  -0,   1,   3,   4,   5,   6,   6,   6,   7,   8,   9,   9,   9,  11,  11,  10,  10,  10,  10,  10,  10,  11,  11,  11,  12,  12,  12,  12,  12,  12,  11,  11,  11,  10,  10,   9,   9,   8,   8,   8,   7,   6,   5,   4,   4,   4,   4},
  /*  65.0 */ {   5,   4,   4,   5,   5,   5,   5,   4,   4,   4,   4,   4,   5,   6,   6,   7,   7,   7,   8,   8,   9,   9,   9,   9,   9,  10,  10,  10,  10,  11,  11,  11,  11,  12,  12,  12,  12,  12,  11,  11,  11,  11,  10,   9,   9,   8,   7,   7,   5,   3,   2,  -0,  -3,  -7, -10, -11, -11, -13, -15, -16, -16, -18, -19, -20, -20, -22, -22, -24, -25, -26, -28, -29, -31, -33, -34, -34, -36, -37, -38, -39, -40, -41, -41, -41, -41, -40, -39, -38, -38, -38, -37, -37, -37, -37, -36, -35, -33, -33, -33, -33, -32, -32, -30, -28, -26, -25, -23, -21, -19, -16, -13, -11,  -8,  -6,  -5,  -2,   1,   3,   6,  12,  16,  18,  19,  20,  22,  26,  28,  27,  27,  29,  33,  37,  40,  43,  46,  48,  49,  49,  48,  45,  44,  46,  48,  51,  54,  56,  56,  56,  56,  58,  59,  59,  61,  63,  64,  64,  65,  66,  66,  67,  67,  67,  67,  67,  66,  66,  64,  63,  62,  61,  60,  58,  57,  56,  54,  53,  53,  52,  52,  51,  51,  50,  48,  46,  45,  44,  43,  41,  41,  40,  40,  39,  38,  36,  34,  32,  31,  30,  29,  27,  25,  23,  20,  19,  18,  18,  18,  18,  17,  18,  18,  17,  17,  17,  17,  17,  17,  17,  15,  13,  13,  12,  11,  10,   9,   8,   8,   7,   7,   6,   6,   5,   4,   2,   1,  -0,  -0,  -2,  -3,  -2,  -1,  -2,  -4,  -6,  -8, -10, -11, -11, -13, -13, -14, -15, -16, -17, -18, -18, -19, -19, -19, -19, -20, -21, -20, -20, -20, -21, -22, -23, -23, -23, -23, -22, -23, -25, -25, -25, -25, -25, -25, -24, -24, -25, -25, -24, -23, -22, -22, -22, -21, -20, -19, -18, -18, -17, -17, -18, -18, -18, -18, -17, -17, -17, -17, -17, -17, -16, -14, -10,  -7,  -5,  -4,  -4,  -3,  -2,  -0,   0,   1,   2,   3,   3,   4,   5,   6,   6,   7,   9,   9,   9,  10,   9,   7,   7,   8,   8,   8,   8,   9,   9,   9,  10,  10,  10,  10,  11,  11,  11,  11,  10,  10,   9,   9,   7,   7,   7,   6,   6,   5,   5,   5,   5,   5},
  /*  66.0 */ {   5,   4,   4,   4,   4,   4,   3,   3,   4,   4,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6,   7,   7,   7,   7,   8,   8,   9,   9,  10,  10,   9,   9,  10,  10,   9,   9,   9,   9,   9,   9,   9,   8,   7,   6,   6,   4,   2,  -0,  -2,  -4,  -5,  -6,  -7,  -7,  -9, -10, -12, -13, -15, -16, -17, -18, -19, -19, -19, -20, -21, -23, -24, -25, -27, -29, -30, -32, -33, -34, -36, -36, -37, -38, -38, -39, -39, -39, -38, -37, -37, -36, -36, -36, -36, -35, -34, -34, -34, -33, -33, -32, -31, -30, -30, -29, -28, -28, -26, -24, -23, -21, -18, -16, -13, -11,  -8,  -5,  -1,   3,   6,   8,   9,  13,  17,  19,  21,  22,  24,  27,  28,  30,  31,  32,  34,  36,  39,  42,  44,  45,  47,  48,  48,  48,  48,  49,  49,  51,  53,  55,  57,  58,  58,  59,  60,  60,  61,  61,  62,  63,  64,  65,  65,  65,  66,  66,  65,  65,  65,  64,  63,  63,  62,  60,  58,  58,  56,  54,  54,  53,  52,  52,  51,  51,  50,  49,  47,  46,  45,  44,  43,  43,  42,  41,  40,  39,  37,  35,  34,  33,  32,  31,  30,  29,  28,  25,  23,  22,  20,  20,  19,  18,  18,  18,  18,  17,  17,  18,  18,  17,  16,  15,  15,  15,  14,  13,  12,  12,  12,  10,   8,   6,   6,   7,   6,   4,   3,   2,   1,   0,  -1,  -2,  -3,  -4,  -5,  -6,  -6,  -5,  -4,  -6,  -8, -10, -11, -12, -13, -14, -16, -17, -17, -17, -17, -17, -17, -17, -18, -19, -19, -19, -18, -19, -20, -21, -22, -22, -22, -22, -23, -23, -22, -22, -22, -23, -23, -22, -22, -22, -22, -21, -21, -20, -20, -19, -18, -17, -17, -16, -16, -15, -15, -15, -16, -15, -15, -15, -15, -14, -14, -15, -15, -14, -12,  -8,  -6,  -4,  -4,  -5,  -4,  -3,  -2,  -1,  -0,   1,   2,   3,   4,   5,   5,   5,   5,   7,   8,   8,   7,   5,   4,   5,   7,   7,   7,   7,   7,   7,   8,   8,   9,   9,  10,  10,  10,  10,  10,  10,   9,   9,   8,   8,   8,   6,   6,   6,   6,   5,   5,   5,   5},
  /*  67.0 */ {   5,   5,   4,   4,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   4,   4,   5,   5,   5,   6,   6,   7,   8,   8,   9,   9,   9,   9,   9,   9,   8,   7,   7,   7,   7,   7,   7,   7,   6,   5,   4,   4,   2,  -0,  -1,  -2,  -3,  -4,  -5,  -5,  -6,  -8,  -9, -10, -12, -13, -15, -16, -16, -17, -18, -19, -20, -22, -23, -25, -26, -28, -30, -31, -32, -33, -34, -35, -36, -36, -37, -37, -37, -37, -37, -36, -35, -34, -34, -33, -32, -31, -31, -32, -32, -31, -31, -30, -29, -28, -28, -27, -27, -26, -26, -24, -22, -21, -19, -16, -14, -10,  -7,  -3,   1,   6,   8,   7,   8,  11,  15,  18,  19,  21,  23,  25,  26,  26,  28,  30,  31,  33,  36,  39,  41,  43,  44,  46,  47,  48,  48,  49,  50,  53,  55,  56,  57,  57,  57,  57,  58,  58,  59,  60,  60,  60,  61,  62,  63,  63,  64,  64,  64,  64,  63,  63,  63,  62,  60,  59,  58,  57,  56,  55,  54,  53,  52,  52,  51,  51,  50,  49,  48,  48,  47,  45,  43,  43,  42,  43,  42,  41,  40,  38,  36,  33,  31,  30,  31,  31,  31,  30,  28,  26,  24,  23,  22,  20,  19,  18,  18,  18,  17,  17,  17,  17,  18,  18,  17,  16,  15,  14,  13,  12,  12,  11,   9,   8,   7,   8,   7,   6,   4,   3,   2,   1,   0,  -0,  -1,  -2,  -3,  -4,  -5,  -7,  -7,  -6,  -5,  -5,  -7,  -8, -10, -12, -13, -14, -15, -15, -15, -15, -15, -15, -16, -16, -16, -17, -17, -17, -18, -17, -18, -18, -19, -20, -20, -19, -20, -20, -20, -20, -20, -19, -19, -20, -20, -19, -18, -18, -19, -19, -18, -18, -17, -17, -16, -15, -15, -14, -14, -13, -13, -12, -12, -12, -12, -12, -13, -14, -14, -11,  -8,  -5,  -5,  -5,  -5,  -5,  -4,  -3,  -2,  -2,  -1,   0,   3,   3,   3,   3,   5,   6,   5,   2,   2,   4,   5,   5,   6,   6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   8,   8,   8,   8,   8,   9,   9,   8,   8,   8,   7,   7,   6,   6,   6,   6,   6,   6,   5},
  /*  68.0 */ {   5,   4,   4,   3,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   3,   4,   4,   4,   4,   4,   5,   6,   8,   8,   7,   7,   8,   9,   9,   9,   9,   8,   8,   8,   7,   7,   6,   5,   4,   3,   2,   0,  -2,  -2,  -2,  -2,  -3,  -5,  -6,  -6,  -7,  -8,  -8,  -9, -10, -10, -11, -12, -15, -17, -18, -19, -21, -23, -25, -26, -28, -29, -30, -31, -32, -32, -33, -33, -34, -35, -35, -35, -35, -35, -35, -34, -34, -33, -32, -30, -30, -30, -30, -31, -31, -30, -28, -26, -26, -26, -26, -25, -24, -23, -22, -21, -19, -17, -14, -12,  -9,  -5,  -2,   0,   2,   3,   6,   9,  12,  14,  17,  19,  22,  24,  25,  25,  25,  25,  26,  27,  29,  32,  34,  36,  38,  40,  42,  43,  45,  46,  47,  48,  49,  51,  54,  56,  56,  56,  56,  57,  58,  59,  59,  59,  59,  60,  59,  59,  60,  61,  61,  62,  62,  62,  62,  61,  61,  60,  59,  59,  58,  57,  56,  55,  54,  52,  51,  51,  51,  50,  49,  49,  48,  48,  48,  47,  45,  44,  42,  41,  41,  41,  41,  41,  39,  36,  32,  30,  30,  31,  32,  31,  29,  28,  27,  25,  24,  23,  22,  21,  20,  19,  18,  18,  18,  18,  18,  17,  16,  15,  14,  13,  11,  11,  11,  10,  10,   9,   9,   8,   6,   5,   4,   3,   2,   1,  -0,  -1,  -1,  -2,  -3,  -3,  -4,  -5,  -6,  -7,  -7,  -6,  -6,  -7,  -9, -11, -12, -13, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -16, -16, -16, -15, -16, -17, -17, -18, -18, -17, -17, -16, -16, -16, -17, -16, -16, -16, -17, -16, -16, -16, -16, -17, -16, -17, -16, -16, -15, -15, -15, -14, -13, -12, -12, -11, -11, -11, -11, -12, -14, -15, -16, -14, -10,  -7,  -5,  -5,  -5,  -5,  -4,  -4,  -3,  -2,  -1,   1,   1,   1,   2,   1,   0,   1,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   7,   7,   7,   8,   8,   8,   8,   7,   6,   6,   6,   6,   6,   6,   6,   6,   6,   5},
  /*  69.0 */ {   4,   3,   3,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   3,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   5,   6,   7,   7,   7,   7,   5,   4,   3,   1,  -2,  -4,  -5,  -6,  -6,  -6,  -6,  -6,  -7,  -8,  -8,  -9,  -9,  -9,  -8,  -8,  -9, -11, -12, -14, -15, -17, -18, -19, -20, -21, -22, -23, -26, -28, -30, -30, -31, -31, -32, -31, -31, -31, -32, -32, -32, -32, -31, -31, -30, -29, -28, -28, -28, -28, -28, -28, -27, -25, -24, -23, -24, -23, -22, -21, -21, -19, -17, -14, -11,  -9,  -6,  -4,  -2,  -0,   1,   1,   4,   9,  13,  15,  16,  18,  21,  24,  25,  26,  27,  26,  24,  23,  24,  26,  29,  31,  34,  36,  38,  39,  41,  42,  44,  45,  47,  48,  50,  51,  53,  55,  54,  55,  57,  59,  59,  60,  61,  61,  60,  59,  59,  59,  59,  59,  60,  60,  61,  61,  60,  60,  60,  59,  58,  58,  57,  56,  54,  52,  52,  51,  51,  50,  49,  49,  49,  48,  47,  47,  46,  45,  44,  43,  43,  41,  40,  39,  39,  39,  38,  37,  35,  33,  32,  31,  31,  30,  29,  28,  27,  26,  25,  24,  22,  21,  20,  19,  18,  17,  17,  16,  15,  14,  13,  13,  12,  11,  10,  10,   9,   8,   8,   7,   6,   4,   4,   3,   2,   1,   0,  -0,  -1,  -2,  -3,  -3,  -4,  -5,  -5,  -5,  -6,  -7,  -7,  -8,  -8,  -9, -10, -11, -11, -12, -12, -12, -12, -12, -13, -13, -13, -14, -14, -14, -15, -15, -15, -14, -14, -15, -16, -16, -15, -15, -15, -14, -14, -15, -15, -16, -17, -17, -16, -16, -15, -15, -15, -15, -14, -14, -13, -13, -12, -12, -12, -12, -12, -12, -11, -10, -10, -10, -12, -13, -14, -14, -13, -11,  -7,  -5,  -5,  -6,  -5,  -4,  -4,  -3,  -2,  -2,  -1,   0,   0,   0,   0,   1,   1,   1,   2,   2,   3,   3,   4,   4,   3,   3,   3,   4,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4},
  /*  70.0 */ {   3,   2,   2,   2,   1,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,  -0,  -0,  -1,  -1,  -2,  -2,  -2,  -1,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -5,  -6,  -7,  -7,  -8,  -9,  -9, -10, -11, -11, -12, -13, -13, -14, -15, -17, -18, -18, -18, -18, -18, -19, -20, -22, -25, -27, -28, -28, -28, -28, -29, -29, -28, -28, -28, -28, -28, -27, -27, -26, -25, -25, -25, -26, -26, -26, -25, -25, -24, -22, -21, -21, -20, -20, -18, -17, -15, -13, -11,  -8,  -5,  -2,  -1,   1,   3,   4,   4,   5,   7,  10,  14,  16,  19,  21,  23,  24,  26,  27,  28,  28,  27,  26,  26,  27,  30,  32,  35,  36,  38,  39,  40,  42,  43,  44,  46,  47,  48,  50,  52,  54,  55,  55,  56,  57,  57,  57,  56,  57,  58,  58,  57,  56,  57,  58,  60,  59,  59,  59,  59,  59,  59,  59,  58,  57,  56,  55,  54,  52,  51,  51,  51,  51,  50,  50,  49,  48,  47,  47,  46,  45,  45,  44,  43,  43,  42,  41,  40,  39,  39,  38,  37,  35,  33,  31,  30,  28,  28,  27,  25,  24,  25,  24,  23,  21,  20,  19,  18,  17,  16,  15,  14,  14,  13,  12,  11,  10,  10,   9,   8,   7,   6,   6,   5,   4,   3,   2,   2,   1,  -0,  -1,  -2,  -2,  -2,  -2,  -3,  -4,  -5,  -6,  -7,  -7,  -8,  -8,  -9,  -9,  -9, -10, -10, -10, -10, -10, -11, -11, -11, -12, -13, -13, -14, -14, -14, -14, -15, -14, -14, -13, -13, -13, -12, -12, -13, -14, -14, -15, -15, -15, -15, -15, -15, -15, -14, -13, -12, -11, -10,  -9,  -9, -10, -11, -11, -11, -11, -11, -11, -10, -10,  -9,  -8,  -9,  -9,  -9, -10, -10, -10,  -9,  -7,  -6,  -6,  -6,  -5,  -4,  -3,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,   3},
  /*  71.0 */ {   3,   2,   2,   1,   1,   1,   1,   1,   1,   1,   2,   1,   1,   1,   0,  -0,  -0,  -0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -2,  -2,  -3,  -3,  -4,  -4,  -4,  -4,  -3,  -2,  -3,  -4,  -5,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -3,  -4,  -5,  -7,  -9, -10, -11, -12, -12, -13, -13, -14, -15, -15, -15, -16, -16, -17, -17, -17, -18, -19, -21, -23, -24, -25, -25, -25, -25, -25, -26, -26, -25, -24, -23, -23, -22, -21, -20, -19, -20, -21, -21, -21, -20, -20, -19, -18, -18, -17, -16, -15, -13, -12, -10,  -8,  -6,  -4,  -2,  -0,   1,   2,   3,   3,   5,   8,  10,  12,  14,  16,  17,  19,  22,  24,  26,  26,  27,  28,  29,  28,  28,  28,  30,  32,  34,  36,  37,  38,  39,  40,  41,  42,  43,  45,  46,  47,  49,  50,  51,  52,  53,  53,  54,  55,  54,  54,  54,  54,  53,  53,  55,  56,  56,  57,  57,  56,  57,  57,  57,  57,  58,  57,  57,  56,  56,  55,  54,  54,  53,  53,  52,  52,  51,  50,  49,  48,  47,  46,  46,  45,  44,  44,  43,  42,  42,  41,  40,  40,  39,  37,  35,  33,  31,  29,  28,  28,  27,  25,  24,  23,  22,  21,  20,  19,  17,  17,  16,  16,  15,  15,  13,  12,  11,  10,   9,   9,   8,   8,   8,   7,   6,   5,   3,   3,   2,   2,   1,   1,   0,  -1,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -9,  -9, -10, -10, -10, -10,  -9,  -9, -10, -11, -11, -12, -12, -13, -13, -14, -14, -14, -14, -14, -14, -14, -14, -15, -15, -15, -14, -14, -13, -13, -12, -12, -12, -13, -13, -12, -11, -10,  -9,  -9,  -9, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -0,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   3,   3,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   3,   3,   3,   2,   2,   3},
  /*  72.0 */ {   2,   2,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,  -0,  -0,  -0,   0,   0,   1,   0,   0,  -0,  -1,  -1,  -2,  -2,  -3,  -3,  -4,  -6,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -7,  -6,  -5,  -4,  -5,  -7, -10, -11, -10, -10, -10,  -9, -10, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -21, -21, -22, -22, -22, -22, -23, -23, -22, -21, -20, -19, -18, -18, -18, -17, -16, -17, -17, -17, -16, -15, -14, -13, -13, -12, -11, -10,  -9,  -8,  -8,  -6,  -4,  -1,   1,   1,   2,   4,   7,   9,  10,  11,  12,  13,  14,  16,  17,  19,  21,  23,  25,  26,  26,  25,  26,  27,  28,  30,  32,  34,  35,  36,  37,  37,  38,  39,  39,  40,  41,  42,  43,  44,  46,  47,  48,  49,  49,  50,  50,  51,  51,  51,  51,  53,  54,  53,  53,  53,  53,  54,  55,  55,  54,  54,  54,  54,  54,  54,  53,  53,  53,  53,  53,  53,  53,  52,  52,  52,  52,  51,  51,  50,  49,  49,  48,  47,  46,  45,  44,  43,  42,  42,  41,  41,  41,  40,  38,  36,  34,  33,  31,  29,  27,  26,  24,  23,  22,  21,  20,  19,  18,  18,  17,  16,  15,  15,  14,  13,  12,  11,  10,   9,   8,   8,   7,   7,   6,   6,   5,   4,   3,   3,   2,   2,   2,   1,  -1,  -2,  -2,  -3,  -3,  -4,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -9, -10, -11, -11, -11, -11, -12, -12, -12, -13, -13, -13, -13, -13, -13, -14, -14, -14, -13, -13, -13, -13, -12, -13, -14, -14, -13, -12, -12, -11, -10, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   2,   2},
  /*  73.0 */ {   2,   2,   2,   1,   1,   0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -1,  -1,  -1,  -1,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -9,  -9,  -9,  -9,  -9,  -8,  -7,  -7,  -7,  -8, -10, -10, -10, -10,  -9,  -9,  -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20, -20, -20, -20, -20, -20, -21, -20, -19, -18, -17, -16, -15, -15, -14, -13, -12, -12, -12, -12, -12, -11, -11, -11, -11, -10,  -8,  -6,  -5,  -5,  -3,  -1,   2,   3,   4,   6,   9,  12,  13,  13,  14,  14,  14,  15,  16,  17,  19,  22,  24,  22,  20,  20,  21,  22,  23,  24,  26,  29,  31,  32,  34,  36,  37,  37,  37,  37,  38,  39,  40,  41,  42,  42,  43,  45,  46,  47,  48,  48,  49,  49,  49,  48,  48,  49,  50,  50,  49,  50,  51,  51,  51,  52,  53,  53,  52,  51,  51,  50,  51,  51,  51,  51,  51,  51,  50,  50,  50,  50,  49,  49,  49,  49,  49,  48,  48,  47,  46,  46,  45,  44,  43,  43,  42,  42,  41,  40,  37,  35,  33,  31,  30,  29,  28,  26,  24,  23,  22,  21,  20,  19,  18,  17,  17,  16,  16,  15,  14,  14,  13,  12,  10,  10,   9,   8,   7,   7,   6,   5,   4,   3,   3,   2,   2,   2,   2,   2,   1,  -0,  -2,  -2,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -8,  -8,  -9,  -9,  -9,  -9,  -9, -10, -10, -11, -11, -12, -12, -12, -11, -11, -11, -11, -11, -12, -13, -13, -13, -12, -12, -12, -12, -13, -13, -13, -12, -11, -11, -11, -10, -10, -10, -10,  -9,  -9,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -1,  -1,  -1,  -1,  -0,  -0,  -0,  -0,   0,   0,   1,   1,   1,   1,   1,   2,   2,   2,   2,   1,   1,   2,   2,   1,   1,   1,   1,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2},
  /*  74.0 */ {   1,   1,   2,   2,   1,   1,   1,   1,   2,   2,   2,   3,   2,   2,   1,   1,   0,   0,  -0,  -1,  -3,  -4,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -5,  -4,  -4,  -5,  -6,  -7,  -7,  -8,  -9,  -9,  -9, -10, -10, -10,  -9,  -9,  -7,  -6,  -5,  -5,  -7,  -9,  -9,  -9,  -9, -10, -10, -11, -12, -12, -13, -14, -15, -15, -15, -16, -16, -17, -17, -17, -17, -17, -17, -17, -16, -16, -15, -14, -13, -12, -12, -12, -11, -10, -10, -10, -10, -10, -10,  -9,  -8,  -8,  -7,  -6,  -5,  -4,  -3,  -1,   1,   3,   6,   8,  11,  13,  14,  15,  15,  16,  16,  16,  17,  18,  20,  21,  20,  19,  18,  18,  20,  21,  22,  24,  25,  27,  29,  30,  32,  33,  34,  34,  35,  35,  36,  37,  37,  38,  38,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  47,  47,  47,  47,  47,  48,  48,  48,  48,  48,  49,  49,  50,  50,  51,  50,  49,  49,  48,  48,  48,  48,  48,  48,  48,  48,  47,  47,  47,  47,  47,  46,  45,  45,  45,  45,  45,  45,  44,  43,  43,  42,  41,  40,  39,  39,  38,  36,  35,  33,  31,  29,  28,  26,  25,  24,  23,  22,  21,  20,  19,  19,  18,  17,  16,  15,  15,  14,  13,  12,  11,  10,   9,   9,   8,   7,   7,   6,   5,   4,   4,   3,   3,   2,   2,   2,   2,   1,   0,  -1,  -2,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -5,  -5,  -5,  -5,  -6,  -6,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -9,  -9,  -9,  -9, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -11, -11, -11, -11, -11, -11, -10, -11, -11, -11, -10, -10,  -9,  -9,  -9,  -8,  -8,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -0,   0,   1,   0,   0,   0,   1,   1,   1,   1,   2,   3,   3,   3,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1},
  /*  75.0 */ {   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   2,   2,   1,   1,   0,  -0,  -1,  -1,  -2,  -2,  -2,  -3,  -4,  -4,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -5,  -6,  -6,  -7,  -7,  -8,  -8,  -9,  -9,  -9,  -9,  -8,  -7,  -6,  -4,  -3,  -4,  -6,  -8, -10, -10, -11, -11, -11, -12, -12, -12, -12, -11, -11, -12, -12, -12, -13, -13, -14, -14, -14, -14, -14, -14, -13, -12, -12, -11, -10,  -9,  -9,  -8,  -7,  -7,  -7,  -6,  -5,  -4,  -3,  -2,  -1,   1,   2,   4,   6,   7,   7,   6,   5,   7,   9,  12,  14,  15,  16,  17,  18,  18,  19,  19,  19,  19,  18,  18,  17,  17,  18,  19,  20,  21,  22,  23,  25,  27,  28,  30,  31,  32,  32,  33,  33,  34,  35,  36,  36,  36,  37,  37,  38,  38,  39,  40,  41,  42,  42,  43,  44,  45,  46,  46,  45,  45,  46,  47,  47,  47,  45,  44,  44,  44,  45,  45,  46,  47,  47,  47,  46,  46,  46,  46,  46,  46,  45,  45,  45,  45,  44,  44,  44,  44,  44,  44,  44,  44,  43,  42,  42,  41,  41,  40,  40,  40,  40,  40,  37,  35,  33,  31,  30,  29,  28,  27,  26,  24,  23,  22,  21,  21,  20,  19,  18,  18,  17,  16,  15,  14,  13,  12,  11,  10,   9,   9,   8,   7,   7,   6,   5,   4,   4,   3,   3,   2,   2,   2,   3,   3,   2,   1,  -1,  -2,  -2,  -3,  -3,  -4,  -4,  -4,  -4,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -9,  -8,  -7,  -7,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   1,   1,   2,   2,   2,   2,   2,   2,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2},
  /*  76.0 */ {   2,   2,   2,   1,  -0,  -1,  -0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -7,  -6,  -5,  -5,  -5,  -5,  -5,  -6,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -9, -10, -10, -10, -10, -10, -10, -10,  -9,  -9,  -8,  -8,  -7,  -7,  -6,  -6,  -6,  -5,  -5,  -4,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -0,   1,   2,   3,   4,   5,   6,   8,  10,  11,  12,  13,  14,  14,  15,  15,  16,  16,  17,  17,  17,  18,  19,  19,  20,  21,  21,  22,  24,  25,  27,  28,  29,  30,  31,  31,  32,  32,  32,  33,  33,  34,  35,  36,  37,  38,  38,  39,  40,  41,  41,  42,  43,  44,  45,  46,  47,  47,  46,  44,  42,  40,  39,  38,  38,  38,  38,  38,  38,  39,  41,  42,  42,  43,  43,  44,  45,  44,  44,  43,  43,  43,  42,  42,  43,  43,  43,  43,  43,  43,  43,  43,  42,  42,  41,  41,  40,  39,  40,  40,  39,  37,  34,  32,  31,  30,  30,  29,  28,  27,  26,  25,  24,  23,  22,  21,  20,  19,  18,  18,  17,  16,  15,  14,  13,  12,  11,  11,  10,  10,   9,   8,   8,   7,   7,   6,   5,   5,   5,   4,   4,   3,   3,   2,   2,   2,   2,   2,   1,   1,  -0,  -1,  -1,  -2,  -3,  -3,  -4,  -4,  -5,  -5,  -5,  -6,  -6,  -7,  -7,  -7,  -6,  -6,  -6,  -7,  -7,  -8,  -8,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -6,  -6,  -5,  -5,  -4,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,  -0,  -0,  -0,  -0,  -1,  -0,   0,   1,   1,   1,   0,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2,   1,   1,   2},
  /*  77.0 */ {   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3,   2,   2,   1,   1,   0,  -0,  -1,  -1,  -1,  -1,  -2,  -2,  -3,  -3,  -2,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -6,  -6,  -6,  -5,  -4,  -3,  -3,  -3,  -3,  -4,  -5,  -5,  -5,  -5,  -5,  -6,  -6,  -6,  -7,  -7,  -8,  -8,  -8,  -8,  -8,  -8,  -7,  -7,  -6,  -7,  -7,  -7,  -7,  -6,  -6,  -5,  -4,  -3,  -3,  -2,  -3,  -3,  -2,  -1,  -0,   1,   3,   5,   6,   6,   7,   7,   8,   9,   9,   9,   9,   9,  10,  10,  11,  11,  13,  14,  16,  17,  19,  20,  21,  22,  23,  23,  24,  24,  24,  25,  26,  27,  27,  28,  29,  30,  30,  31,  31,  31,  31,  32,  33,  33,  34,  35,  35,  36,  37,  38,  38,  39,  40,  41,  42,  42,  43,  43,  43,  43,  42,  41,  39,  36,  33,  31,  31,  33,  33,  33,  33,  33,  34,  36,  38,  39,  40,  40,  41,  42,  42,  42,  42,  41,  41,  41,  41,  42,  41,  41,  41,  42,  42,  41,  41,  40,  40,  40,  39,  38,  38,  37,  35,  33,  32,  30,  30,  29,  29,  28,  28,  27,  26,  25,  24,  23,  22,  21,  20,  19,  18,  17,  17,  16,  15,  15,  14,  13,  13,  12,  11,  11,  10,   9,   9,   8,   7,   7,   6,   6,   5,   5,   5,   4,   4,   3,   3,   2,   2,   1,   1,   1,   1,   1,   1,   0,  -1,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -7,  -7,  -7,  -7,  -7,  -7,  -7,  -6,  -5,  -5,  -5,  -4,  -4,  -4,  -4,  -4,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -0,  -0,   0,   0,  -0,  -0,  -1,  -0,   0,   0,   1,   1,   1,   2,   2,   1,   1,   0,   0,   0,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   4,   3,   3,   3,   4,   4,   4,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2},
  /*  78.0 */ {   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   4,   4,   4,   4,   3,   3,   2,   2,   1,   0,   0,  -0,  -0,  -0,  -1,  -2,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -6,  -6,  -6,  -6,  -6,  -6,  -6,  -5,  -5,  -5,  -4,  -4,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -5,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,   1,   2,   4,   5,   6,   8,   9,  10,  10,  10,  10,   9,   9,   9,   9,  10,  12,  14,  16,  17,  18,  19,  20,  22,  23,  24,  25,  26,  26,  27,  28,  28,  29,  29,  30,  30,  30,  30,  31,  31,  31,  32,  32,  33,  33,  33,  34,  34,  34,  35,  35,  36,  37,  37,  38,  38,  39,  39,  39,  38,  37,  36,  35,  34,  32,  31,  30,  29,  30,  30,  31,  31,  31,  31,  31,  33,  35,  36,  36,  36,  37,  38,  39,  40,  39,  39,  38,  38,  38,  39,  39,  39,  40,  40,  40,  39,  39,  39,  39,  38,  37,  35,  34,  32,  32,  32,  31,  30,  29,  29,  29,  28,  27,  26,  24,  24,  23,  22,  21,  20,  19,  19,  18,  17,  17,  16,  16,  15,  14,  14,  13,  13,  12,  12,  11,  10,  10,   9,   9,   8,   7,   7,   7,   6,   6,   5,   5,   4,   4,   3,   3,   3,   3,   2,   1,   1,   0,  -0,  -0,  -1,  -1,  -1,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -5,  -5,  -5,  -5,  -5,  -5,  -4,  -3,  -3,  -2,  -2,  -2,  -1,  -1,  -1,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -0,   1,   2,   2,   2,   2,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   3,   3,   3,   3,   3,   2,   2,   2,   2,   3,   3,   3},
  /*  79.0 */ {   3,   3,   4,   4,   4,   3,   3,   3,   3,   3,   2,   2,   2,   3,   3,   3,   3,   3,   2,   2,   2,   1,  -0,  -1,  -1,  -1,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -4,  -3,  -3,  -2,  -1,  -1,  -0,   0,   1,   1,   0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,   0,   1,   1,   1,   0,   1,   1,   1,   2,   2,   3,   4,   5,   6,   6,   6,   5,   5,   5,   5,   6,   8,   9,  10,  11,  11,  11,  10,   8,   8,   7,   7,   7,   8,   9,  11,  12,  14,  15,  17,  18,  20,  21,  22,  23,  24,  25,  26,  26,  27,  27,  28,  28,  29,  29,  30,  30,  31,  32,  32,  33,  33,  34,  34,  35,  35,  35,  35,  36,  36,  36,  37,  37,  37,  36,  35,  34,  33,  32,  31,  30,  29,  29,  28,  28,  29,  29,  30,  30,  30,  30,  31,  31,  32,  33,  34,  35,  36,  37,  37,  36,  36,  35,  36,  36,  37,  37,  37,  37,  38,  38,  39,  39,  38,  38,  37,  37,  36,  35,  35,  35,  34,  33,  32,  30,  29,  28,  28,  27,  26,  25,  24,  24,  23,  22,  22,  21,  20,  20,  19,  18,  18,  17,  17,  16,  15,  15,  14,  14,  14,  13,  13,  12,  11,  11,  10,  10,   9,   9,   8,   8,   8,   7,   7,   6,   6,   6,   5,   5,   4,   3,   3,   3,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -2,  -2,  -1,  -1,  -0,   0,   0,   1,   1,   1,   1,   1,  -0,  -1,  -2,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,   1,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   3,   3,   3,   3,   3,   4,   4,   3,   3,   2,   2,   2,   2,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   3,   3,   3,   3},
  /*  80.0 */ {   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -0,  -1,  -1,  -1,  -1,  -1,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -3,  -3,  -3,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -1,  -1,   0,   1,   2,   2,   3,   4,   4,   5,   5,   4,   4,   3,   3,   2,   2,   2,   2,   2,   3,   3,   4,   5,   5,   6,   8,   9,  10,  11,  11,  11,  10,   9,   8,   8,   8,   9,  10,  12,  13,  15,  15,  15,  15,  14,  13,  12,  10,   9,   8,   7,   7,   8,   9,  10,  11,  13,  14,  15,  17,  18,  20,  21,  22,  23,  24,  25,  26,  27,  27,  28,  28,  29,  30,  30,  31,  32,  32,  33,  33,  34,  34,  35,  35,  36,  37,  37,  37,  37,  37,  36,  36,  35,  34,  33,  33,  32,  32,  32,  32,  32,  32,  32,  31,  31,  31,  31,  32,  32,  32,  32,  33,  34,  34,  35,  34,  34,  34,  34,  34,  34,  34,  34,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  35,  34,  33,  33,  32,  31,  30,  30,  29,  29,  29,  28,  27,  27,  26,  25,  25,  24,  24,  23,  23,  22,  22,  21,  20,  20,  19,  18,  18,  17,  17,  16,  16,  16,  15,  14,  14,  13,  13,  12,  12,  11,  11,  11,  11,  11,  10,   9,   9,   8,   8,   7,   7,   6,   6,   5,   5,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   3,   3,   2,   2,   2,   2,   1,   0,  -0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,  -0,  -0,   0,   0,  -0,  -0,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -0,   0,   1,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   2,   2,   2,   1,   1,   1,   1,   1,   0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   3,   3,   4,   4,   4},
  /*  81.0 */ {   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   2,   2,   3,   3,   4,   4,   5,   5,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   7,   8,   8,   9,  10,  10,  11,  11,  11,  11,  11,  12,  13,  14,  15,  16,  16,  17,  16,  16,  16,  17,  17,  18,  19,  19,  19,  18,  17,  15,  14,  12,  12,  11,  12,  12,  14,  15,  16,  18,  19,  20,  21,  21,  22,  23,  23,  24,  25,  25,  26,  27,  28,  29,  29,  30,  31,  32,  33,  34,  34,  35,  35,  34,  34,  34,  35,  35,  35,  35,  35,  34,  33,  32,  32,  32,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  32,  33,  33,  33,  32,  31,  31,  31,  31,  32,  32,  33,  33,  32,  32,  32,  32,  32,  32,  32,  32,  31,  31,  31,  31,  31,  31,  31,  30,  30,  30,  29,  29,  28,  28,  28,  28,  27,  27,  26,  26,  25,  25,  24,  24,  23,  23,  22,  21,  21,  20,  20,  19,  19,  18,  18,  18,  18,  17,  17,  16,  16,  16,  15,  15,  15,  14,  14,  14,  14,  13,  13,  12,  12,  11,  10,  10,   9,   9,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7,   6,   6,   6,   6,   5,   5,   4,   4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4,   3,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2,   1,   1,   1,   1,   1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   1,   1,   1,   2,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4},
  /*  82.0 */ {   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6,   6,   7,   8,   8,   9,  10,  10,  11,  11,  11,  11,  11,  12,  12,  13,  13,  13,  14,  14,  14,  15,  16,  17,  17,  18,  18,  19,  19,  20,  21,  21,  21,  21,  21,  20,  20,  19,  19,  19,  19,  18,  17,  17,  16,  16,  16,  16,  16,  17,  17,  18,  18,  18,  19,  19,  19,  20,  20,  21,  22,  24,  25,  26,  27,  29,  29,  30,  31,  31,  31,  32,  32,  32,  32,  32,  32,  31,  31,  30,  30,  29,  29,  28,  27,  27,  27,  27,  27,  28,  29,  30,  31,  31,  32,  32,  31,  31,  30,  30,  29,  29,  29,  29,  30,  31,  31,  31,  31,  31,  31,  31,  31,  31,  31,  32,  32,  31,  31,  31,  30,  30,  29,  28,  28,  27,  27,  26,  26,  26,  26,  25,  24,  24,  23,  23,  22,  22,  22,  22,  21,  21,  21,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  19,  19,  18,  18,  17,  17,  17,  17,  17,  17,  17,  16,  16,  16,  16,  15,  14,  13,  12,  12,  11,  11,  11,  11,  11,  11,  10,  10,  10,  10,   9,   9,   9,   8,   8,   8,   8,   8,   8,   8,   7,   7,   8,   8,   8,   8,   8,   7,   6,   6,   5,   5,   5,   5,   5,   5,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   5,   5,   5,   5,   5,   4,   3,   3,   3,   3,   3,   3,   3,   3,   2,   2,   2,   2,   2,   2,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,   4},
  /*  83.0 */ {   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,  10,  10,  11,  11,  12,  12,  12,  13,  13,  14,  14,  15,  15,  15,  16,  16,  16,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  22,  22,  22,  23,  23,  24,  24,  25,  25,  26,  26,  27,  28,  28,  29,  29,  29,  30,  30,  30,  30,  30,  30,  30,  30,  29,  29,  29,  28,  28,  28,  28,  28,  28,  28,  28,  27,  27,  27,  27,  28,  28,  28,  29,  29,  29,  29,  29,  29,  29,  28,  28,  28,  28,  28,  28,  28,  28,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  26,  26,  26,  25,  25,  25,  25,  24,  24,  24,  23,  23,  23,  22,  22,  22,  21,  21,  21,  21,  20,  20,  19,  19,  19,  18,  18,  18,  18,  17,  17,  16,  16,  16,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  14,  14,  13,  13,  12,  12,  12,  11,  11,  11,  11,  11,  10,  10,  10,  10,   9,   9,   8,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   7,   7,   7,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   4,   4,   4,   5,   5,   6,   7,   7,   8,   8,   7,   6,   6,   5,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   5,   5,   5,   5},
  /*  84.0 */ {   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8,   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  17,  17,  17,  18,  18,  19,  19,  19,  19,  20,  20,  20,  20,  20,  21,  21,  21,  21,  22,  22,  22,  22,  22,  23,  23,  23,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  26,  26,  26,  26,  26,  26,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  27,  26,  26,  26,  26,  26,  26,  26,  26,  25,  25,  25,  25,  25,  25,  25,  24,  24,  24,  24,  24,  24,  23,  23,  23,  23,  23,  22,  22,  22,  22,  21,  21,  21,  21,  20,  20,  20,  19,  19,  19,  19,  18,  18,  18,  18,  17,  17,  17,  16,  16,  16,  16,  15,  15,  15,  15,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  12,  12,  12,  12,  11,  11,  11,  11,  11,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,   9,   9,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6,   6,   7,   7,   8,   8,   9,   9,   8,   8,   8,   8,   7,   7,   7,   7,   7,   7,   6,   6,   6,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   6,   6,   6,   6,   6,   6,   6},
  /*  85.0 */ {   8,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  19,  19,  19,  19,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,  25,  25,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  25,  25,  25,  25,  25,  25,  24,  24,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  25,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  23,  23,  23,  23,  22,  22,  22,  21,  21,  21,  21,  20,  20,  20,  20,  20,  20,  19,  19,  19,  19,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  11,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   8,   8,   8,   8,   7,   7,   7,   7,   7,   8,   8,   9,   9,   9,  10,  10,   9,   9,   9,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   6,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8},
  /*  86.0 */ {   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  20,  20,  20,  21,  21,  22,  22,  22,  23,  23,  23,  23,  22,  22,  22,  21,  21,  21,  21,  20,  20,  20,  20,  21,  21,  21,  21,  21,  21,  21,  21,  21,  21,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  22,  22,  22,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  22,  22,  22,  22,  22,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,  22,  22,  22,  22,  22,  22,  22,  21,  21,  21,  21,  21,  21,  21,  20,  20,  20,  20,  20,  20,  20,  20,  20,  19,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  16,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  12,  12,  12,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  10,  10,  10,  10,  10,  10,  10,   9,   9,   9,   9,   9,   9,   9,   9,   9,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  10,   9,   9,   8,   8,   8,   8,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   8,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,   9,   9},
  /*  87.0 */ {  10,  10,  10,  10,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  20,  20,  20,  20,  20,  20,  21,  21,  21,  21,  21,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  20,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  11,  11,  11,  11,  11,  10,  10,  10,  10,  10,  10,  10,  10,  10,  11,  11,  11,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  12,  12,  11,  11,  10,  10,   9,   9,   9,   9,   8,   8,   8,   9,   9,   9,   9,   9,   9,   9,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10,  10},
  /*  88.0 */ {  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  12,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  19,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  18,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  17,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  12,  12,  12,  12,  12,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  12,  12,  12,  12,  13,  13,  13,  13,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  14,  14,  14,  14,  13,  13,  13,  13,  12,  12,  12,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11,  11},
  /*  89.0 */ {  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  16,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13,  13},
  /*  90.0 */ {  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14,  14}
};
#endif  // HEIGHTGRID_H_INCLUDED_
