/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityMesg;
import com.garmin.fit.BikeProfileMesg;
import com.garmin.fit.BloodPressureMesg;
import com.garmin.fit.CadenceZoneMesg;
import com.garmin.fit.CapabilitiesMesg;
import com.garmin.fit.CourseMesg;
import com.garmin.fit.CoursePointMesg;
import com.garmin.fit.DeviceInfoMesg;
import com.garmin.fit.DeviceSettingsMesg;
import com.garmin.fit.EventMesg;
import com.garmin.fit.Field;
import com.garmin.fit.FieldCapabilitiesMesg;
import com.garmin.fit.FileCapabilitiesMesg;
import com.garmin.fit.FileCreatorMesg;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.GoalMesg;
import com.garmin.fit.HrZoneMesg;
import com.garmin.fit.HrmProfileMesg;
import com.garmin.fit.HrvMesg;
import com.garmin.fit.LapMesg;
import com.garmin.fit.LengthMesg;
import com.garmin.fit.MemoGlobMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgCapabilitiesMesg;
import com.garmin.fit.MesgNum;
import com.garmin.fit.MetZoneMesg;
import com.garmin.fit.MonitoringInfoMesg;
import com.garmin.fit.MonitoringMesg;
import com.garmin.fit.PadMesg;
import com.garmin.fit.PowerZoneMesg;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.ScheduleMesg;
import com.garmin.fit.SdmProfileMesg;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.SlaveDeviceMesg;
import com.garmin.fit.SoftwareMesg;
import com.garmin.fit.SpeedZoneMesg;
import com.garmin.fit.SportMesg;
import com.garmin.fit.TotalsMesg;
import com.garmin.fit.UserProfileMesg;
import com.garmin.fit.WeightScaleMesg;
import com.garmin.fit.WorkoutMesg;
import com.garmin.fit.WorkoutStepMesg;
import com.garmin.fit.ZonesTargetMesg;
import java.util.ArrayList;

public class Factory {
    private static final Mesg[] mesgs = new Mesg[41];

    public static Mesg createMesg(Mesg mesg) {
        switch (mesg.getNum()) {
            case 0: {
                return new FileIdMesg(mesg);
            }
            case 49: {
                return new FileCreatorMesg(mesg);
            }
            case 35: {
                return new SoftwareMesg(mesg);
            }
            case 106: {
                return new SlaveDeviceMesg(mesg);
            }
            case 1: {
                return new CapabilitiesMesg(mesg);
            }
            case 37: {
                return new FileCapabilitiesMesg(mesg);
            }
            case 38: {
                return new MesgCapabilitiesMesg(mesg);
            }
            case 39: {
                return new FieldCapabilitiesMesg(mesg);
            }
            case 2: {
                return new DeviceSettingsMesg(mesg);
            }
            case 3: {
                return new UserProfileMesg(mesg);
            }
            case 4: {
                return new HrmProfileMesg(mesg);
            }
            case 5: {
                return new SdmProfileMesg(mesg);
            }
            case 6: {
                return new BikeProfileMesg(mesg);
            }
            case 7: {
                return new ZonesTargetMesg(mesg);
            }
            case 12: {
                return new SportMesg(mesg);
            }
            case 8: {
                return new HrZoneMesg(mesg);
            }
            case 53: {
                return new SpeedZoneMesg(mesg);
            }
            case 131: {
                return new CadenceZoneMesg(mesg);
            }
            case 9: {
                return new PowerZoneMesg(mesg);
            }
            case 10: {
                return new MetZoneMesg(mesg);
            }
            case 15: {
                return new GoalMesg(mesg);
            }
            case 34: {
                return new ActivityMesg(mesg);
            }
            case 18: {
                return new SessionMesg(mesg);
            }
            case 19: {
                return new LapMesg(mesg);
            }
            case 101: {
                return new LengthMesg(mesg);
            }
            case 20: {
                return new RecordMesg(mesg);
            }
            case 21: {
                return new EventMesg(mesg);
            }
            case 23: {
                return new DeviceInfoMesg(mesg);
            }
            case 78: {
                return new HrvMesg(mesg);
            }
            case 31: {
                return new CourseMesg(mesg);
            }
            case 32: {
                return new CoursePointMesg(mesg);
            }
            case 26: {
                return new WorkoutMesg(mesg);
            }
            case 27: {
                return new WorkoutStepMesg(mesg);
            }
            case 28: {
                return new ScheduleMesg(mesg);
            }
            case 33: {
                return new TotalsMesg(mesg);
            }
            case 30: {
                return new WeightScaleMesg(mesg);
            }
            case 51: {
                return new BloodPressureMesg(mesg);
            }
            case 103: {
                return new MonitoringInfoMesg(mesg);
            }
            case 55: {
                return new MonitoringMesg(mesg);
            }
            case 145: {
                return new MemoGlobMesg(mesg);
            }
            case 105: {
                return new PadMesg(mesg);
            }
        }
        return new Mesg("unknown", MesgNum.INVALID);
    }

    public static Mesg createMesg(int n) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Mesg(mesgs[i]);
        }
        return new Mesg("unknown", n);
    }

    public static Mesg createMesg(String string) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Mesg(mesgs[i]);
        }
        return new Mesg(string, MesgNum.INVALID);
    }

    public static Field createField(String string, String string2) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Field(mesgs[i].getField(string2, false));
        }
        return new Field(string2, 255, 0, 1.0, 0.0, "", false);
    }

    public static Field createField(String string, int n) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Field(mesgs[i].getField(n));
        }
        return new Field("unknown", n, 0, 1.0, 0.0, "", false);
    }

    public static Field createField(int n, int n2) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Field(mesgs[i].getField(n2));
        }
        return new Field("unknown", n2, 0, 1.0, 0.0, "", false);
    }

    public static Field createField(int n, String string) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Field(mesgs[i].getField(string, false));
        }
        return new Field(string, 255, 0, 1.0, 0.0, "", false);
    }

    public static Field createField(String string, String string2, ArrayList<Object> arrayList) {
        Field field = Factory.createField(string, string2);
        field.values = arrayList;
        return field;
    }

    static {
        int n = 0;
        Factory.mesgs[n] = FileIdMesg.fileIdMesg;
        Factory.mesgs[++n] = FileCreatorMesg.fileCreatorMesg;
        Factory.mesgs[++n] = SoftwareMesg.softwareMesg;
        Factory.mesgs[++n] = SlaveDeviceMesg.slaveDeviceMesg;
        Factory.mesgs[++n] = CapabilitiesMesg.capabilitiesMesg;
        Factory.mesgs[++n] = FileCapabilitiesMesg.fileCapabilitiesMesg;
        Factory.mesgs[++n] = MesgCapabilitiesMesg.mesgCapabilitiesMesg;
        Factory.mesgs[++n] = FieldCapabilitiesMesg.fieldCapabilitiesMesg;
        Factory.mesgs[++n] = DeviceSettingsMesg.deviceSettingsMesg;
        Factory.mesgs[++n] = UserProfileMesg.userProfileMesg;
        Factory.mesgs[++n] = HrmProfileMesg.hrmProfileMesg;
        Factory.mesgs[++n] = SdmProfileMesg.sdmProfileMesg;
        Factory.mesgs[++n] = BikeProfileMesg.bikeProfileMesg;
        Factory.mesgs[++n] = ZonesTargetMesg.zonesTargetMesg;
        Factory.mesgs[++n] = SportMesg.sportMesg;
        Factory.mesgs[++n] = HrZoneMesg.hrZoneMesg;
        Factory.mesgs[++n] = SpeedZoneMesg.speedZoneMesg;
        Factory.mesgs[++n] = CadenceZoneMesg.cadenceZoneMesg;
        Factory.mesgs[++n] = PowerZoneMesg.powerZoneMesg;
        Factory.mesgs[++n] = MetZoneMesg.metZoneMesg;
        Factory.mesgs[++n] = GoalMesg.goalMesg;
        Factory.mesgs[++n] = ActivityMesg.activityMesg;
        Factory.mesgs[++n] = SessionMesg.sessionMesg;
        Factory.mesgs[++n] = LapMesg.lapMesg;
        Factory.mesgs[++n] = LengthMesg.lengthMesg;
        Factory.mesgs[++n] = RecordMesg.recordMesg;
        Factory.mesgs[++n] = EventMesg.eventMesg;
        Factory.mesgs[++n] = DeviceInfoMesg.deviceInfoMesg;
        Factory.mesgs[++n] = HrvMesg.hrvMesg;
        Factory.mesgs[++n] = CourseMesg.courseMesg;
        Factory.mesgs[++n] = CoursePointMesg.coursePointMesg;
        Factory.mesgs[++n] = WorkoutMesg.workoutMesg;
        Factory.mesgs[++n] = WorkoutStepMesg.workoutStepMesg;
        Factory.mesgs[++n] = ScheduleMesg.scheduleMesg;
        Factory.mesgs[++n] = TotalsMesg.totalsMesg;
        Factory.mesgs[++n] = WeightScaleMesg.weightScaleMesg;
        Factory.mesgs[++n] = BloodPressureMesg.bloodPressureMesg;
        Factory.mesgs[++n] = MonitoringInfoMesg.monitoringInfoMesg;
        Factory.mesgs[++n] = MonitoringMesg.monitoringMesg;
        Factory.mesgs[++n] = MemoGlobMesg.memoGlobMesg;
        Factory.mesgs[++n] = PadMesg.padMesg;
        ++n;
    }
}

