<h1 align=center>Material Design for Bootstrap</h1>

Material Design for Bootstrap is the best way to use [Material Design guidelines by Google](http://www.google.com/design/spec/material-design/introduction.html)
in your Bootstrap 4 based application.
Since this is a fully customizable version of Bootstrap, just include Material Design for Bootstrap CSS instead of Bootstrap CSS, and include the JavaScript at
the end of your document (just before the `</body>` tag), and everything will be converted to Material Design.


## Documentation

- [Getting Started](https://fezvrasta.github.io/bootstrap-material-design/docs/4.0/getting-started/introduction/)
- [Building](https://fezvrasta.github.io/bootstrap-material-design/docs/4.0/getting-started/build-tools/)
- [Material Design components](https://fezvrasta.github.io/bootstrap-material-design/docs/4.0/material-design/buttons/)
- [Bootstrap default rendering reference documentation](https://fezvrasta.github.io/bootstrap-material-design/docs/4.0/components/alerts/)
- [Migration](https://fezvrasta.github.io/bootstrap-material-design/docs/4.0/migration/)


## Support

The things to do are a lot and the time is little, if you are a passionate developer
with experience with Bootstrap and Material Design for Bootstrap and you have some spare
time, please consider becoming a contributor of this project!  
If you are interested contact @FezVrasta or just adopt one of our [issues](https://github.com/FezVrasta/bootstrap-material-design/issues).

If you like this project you may support it by [donating](https://www.paypal.me/fezvrasta), starring this repository or reporting issues.  
All issues filed should be reduced to a [CodePen](http://codepen.io/rosskevin/pen/eJMMVB) test case where possible.


## Contributing

### Development
If you want to get involved, please do so by submitting pull requests.  
Before undertaking any major PR effort, please check the [existing issues](https://github.com/FezVrasta/bootstrap-material-design/issues).  
If there isn't one, please file a new issue so we can discuss and assign the work so effort is not duplicated.  
Thank you!

### Standard guidelines
Please read through our [contributing guidelines](CONTRIBUTING.md). Included are directions for opening issues, coding standards, and notes on development.

Moreover, if your pull request contains JavaScript patches or features, you must include relevant unit tests. All HTML and CSS should conform to the [Code Guide](http://codeguide.co/), maintained by [Mark Otto](https://github.com/mdo), one of Bootstrap's founders.

Editor preferences are available in the [editor config](https://github.com/FezVrasta/bootstrap-material-design/blob/master/.editorconfig) for easy use in common text editors. Read more and download plugins at <http://editorconfig.org>.


## Versioning

For transparency into our release cycle and in striving to maintain backward compatibility, this project is maintained under
[the Semantic Versioning guidelines](http://semver.org/). Sometimes we screw up, but we'll adhere to those rules whenever possible.

See [the Releases section of our GitHub project](https://github.com/fezvrasta/bootstrap-material-design/releases) for changelogs
of each release version.


## License
[MIT License](LICENSE.md)
