//////////////////////////////////////////////////////////////////////
// Code I used for testing follows, none of this is reachable (PMJ) //
//////////////////////////////////////////////////////////////////////

#include "sudoku-solve.H"
#include "sudoku.H"
#include <iostream>

namespace sudoku_test
{
#ifndef SUDOKU_SOLVE_DEBUG
	const bool debug_output = false;
#else
	const bool debug_output = SUDOKU_SOLVE_DEBUG ;
#endif
	// test case from The Daily Telegraph, Friday 22-7-2005 - algorithm should
	// be able to solve this. (rating: 'diabolical')
	void Telegraph(sudoku::Board& b)
	{
		b.Set(sudoku::Index(0,0), 1);
		b.Set(sudoku::Index(0,3), 4);
		b.Set(sudoku::Index(0,6), 5);
		b.Set(sudoku::Index(0,7), 0);
		
		b.Set(sudoku::Index(1,1), 3);
		b.Set(sudoku::Index(1,8), 6);
		
		b.Set(sudoku::Index(2,1), 4);
		b.Set(sudoku::Index(2,3), 8);
		b.Set(sudoku::Index(2,5), 7);
		b.Set(sudoku::Index(2,8), 3);
		
		b.Set(sudoku::Index(3,0), 0);
		b.Set(sudoku::Index(3,2), 8);
		b.Set(sudoku::Index(3,6), 6);
		b.Set(sudoku::Index(3,7), 7);
		
		b.Set(sudoku::Index(4,4), 8);
		
		b.Set(sudoku::Index(5,1), 2);
		b.Set(sudoku::Index(5,2), 3);
		b.Set(sudoku::Index(5,6), 0);
		b.Set(sudoku::Index(5,8), 1);
		
		b.Set(sudoku::Index(6,0), 2);
		b.Set(sudoku::Index(6,3), 5);
		b.Set(sudoku::Index(6,5), 1);
		b.Set(sudoku::Index(6,7), 6);
		
		b.Set(sudoku::Index(7,0), 3);
		b.Set(sudoku::Index(7,7), 2);
		
		b.Set(sudoku::Index(8,1), 6);
		b.Set(sudoku::Index(8,2), 1);
		b.Set(sudoku::Index(8,5), 2);
		b.Set(sudoku::Index(8,8), 7);
	}
	
	void KevinBryanUnsolveableBug(sudoku::Board& b)
	{
		/*
		9  |425| 6 
		 7 |   |  5
			6|  8|   
		- ---+---+---
		2  |  6| 8 
			8|   |5  
		 4 |9  |  7
		- ---+---+---
			 |6  |8  
		3  |   | 1 
		 6 |841|  9
		*/
		b.Set(sudoku::Index(0,0), 9 - 1);
		b.Set(sudoku::Index(0,3), 4 - 1);
		b.Set(sudoku::Index(0,4), 2 - 1);
		b.Set(sudoku::Index(0,5), 5 - 1);
		b.Set(sudoku::Index(0,7), 6 - 1);
		
		b.Set(sudoku::Index(1,1), 7 - 1);
		b.Set(sudoku::Index(1,8), 5 - 1);
		
		b.Set(sudoku::Index(2,2), 6 - 1);
		b.Set(sudoku::Index(2,5), 8 - 1);
		
		b.Set(sudoku::Index(3,0), 2 - 1);
		b.Set(sudoku::Index(3,5), 6 - 1);
		b.Set(sudoku::Index(3,7), 8 - 1);
		
		b.Set(sudoku::Index(4,2), 8 - 1);
		b.Set(sudoku::Index(4,6), 5 - 1);
		
		b.Set(sudoku::Index(5,1), 4 - 1);
		b.Set(sudoku::Index(5,3), 9 - 1);
		b.Set(sudoku::Index(5,8), 7 - 1);
		
		b.Set(sudoku::Index(6,3), 6 - 1);
		b.Set(sudoku::Index(6,6), 8 - 1);
		
		b.Set(sudoku::Index(7,0), 3 - 1);
		b.Set(sudoku::Index(7,7), 1 - 1);
		
		b.Set(sudoku::Index(8,1), 6 - 1);
		b.Set(sudoku::Index(8,3), 8 - 1);
		b.Set(sudoku::Index(8,4), 4 - 1);
		b.Set(sudoku::Index(8,5), 1 - 1);
		b.Set(sudoku::Index(8,8), 9 - 1);
	}
	
	// test case for which the algorithm should fail cleanly. (deadlock)
	void Unsolveable(sudoku::Board& b)
	{
		b.Set(sudoku::Index(0,0), 0);
		b.Set(sudoku::Index(1,4), 0);
		b.Set(sudoku::Index(2,6), 1);
		b.Set(sudoku::Index(2,7), 2);
		b.Set(sudoku::Index(2,8), 3);
	}
	
	int main()
	{
		sudoku::Board b;
		//Unsolveable(b);
		KevinBryanUnsolveableBug(b);
		//b.Print();
		std::cout << b.Solveable() << " " << b.Filled() << std::endl;
		
		//b.UnSet(sudoku::Index(2,7));
		b.Print<debug_output>();
		std::cout << b.Solveable() << " " << b.Filled() << std::endl;
		std::cout << "Solving: ";
		std::cout << (sudoku::Solve(b) ? "success" : "failed") << std::endl;
		b.Print<debug_output>();
		return 0;
	}
}

int main()
{
	return sudoku_test::main();
}
//////////////////////////////////////////////////////////////////////
// Code I used for testing follows, none of this is reachable (PMJ) //
//////////////////////////////////////////////////////////////////////

#include "sudoku-solve.H"
#include "sudoku.H"
#include <iostream>

namespace sudoku_test
{
#ifndef SUDOKU_SOLVE_DEBUG
	const bool debug_output = false;
#else
	const bool debug_output = SUDOKU_SOLVE_DEBUG ;
#endif
	// test case from The Daily Telegraph, Friday 22-7-2005 - algorithm should
	// be able to solve this. (rating: 'diabolical')
	void Telegraph(sudoku::Board& b)
	{
		b.Set(sudoku::Index(0,0), 1);
		b.Set(sudoku::Index(0,3), 4);
		b.Set(sudoku::Index(0,6), 5);
		b.Set(sudoku::Index(0,7), 0);
		
		b.Set(sudoku::Index(1,1), 3);
		b.Set(sudoku::Index(1,8), 6);
		
		b.Set(sudoku::Index(2,1), 4);
		b.Set(sudoku::Index(2,3), 8);
		b.Set(sudoku::Index(2,5), 7);
		b.Set(sudoku::Index(2,8), 3);
		
		b.Set(sudoku::Index(3,0), 0);
		b.Set(sudoku::Index(3,2), 8);
		b.Set(sudoku::Index(3,6), 6);
		b.Set(sudoku::Index(3,7), 7);
		
		b.Set(sudoku::Index(4,4), 8);
		
		b.Set(sudoku::Index(5,1), 2);
		b.Set(sudoku::Index(5,2), 3);
		b.Set(sudoku::Index(5,6), 0);
		b.Set(sudoku::Index(5,8), 1);
		
		b.Set(sudoku::Index(6,0), 2);
		b.Set(sudoku::Index(6,3), 5);
		b.Set(sudoku::Index(6,5), 1);
		b.Set(sudoku::Index(6,7), 6);
		
		b.Set(sudoku::Index(7,0), 3);
		b.Set(sudoku::Index(7,7), 2);
		
		b.Set(sudoku::Index(8,1), 6);
		b.Set(sudoku::Index(8,2), 1);
		b.Set(sudoku::Index(8,5), 2);
		b.Set(sudoku::Index(8,8), 7);
	}
	
	void KevinBryanUnsolveableBug(sudoku::Board& b)
	{
		/*
		9  |425| 6 
		 7 |   |  5
			6|  8|   
		- ---+---+---
		2  |  6| 8 
			8|   |5  
		 4 |9  |  7
		- ---+---+---
			 |6  |8  
		3  |   | 1 
		 6 |841|  9
		*/
		b.Set(sudoku::Index(0,0), 9 - 1);
		b.Set(sudoku::Index(0,3), 4 - 1);
		b.Set(sudoku::Index(0,4), 2 - 1);
		b.Set(sudoku::Index(0,5), 5 - 1);
		b.Set(sudoku::Index(0,7), 6 - 1);
		
		b.Set(sudoku::Index(1,1), 7 - 1);
		b.Set(sudoku::Index(1,8), 5 - 1);
		
		b.Set(sudoku::Index(2,2), 6 - 1);
		b.Set(sudoku::Index(2,5), 8 - 1);
		
		b.Set(sudoku::Index(3,0), 2 - 1);
		b.Set(sudoku::Index(3,5), 6 - 1);
		b.Set(sudoku::Index(3,7), 8 - 1);
		
		b.Set(sudoku::Index(4,2), 8 - 1);
		b.Set(sudoku::Index(4,6), 5 - 1);
		
		b.Set(sudoku::Index(5,1), 4 - 1);
		b.Set(sudoku::Index(5,3), 9 - 1);
		b.Set(sudoku::Index(5,8), 7 - 1);
		
		b.Set(sudoku::Index(6,3), 6 - 1);
		b.Set(sudoku::Index(6,6), 8 - 1);
		
		b.Set(sudoku::Index(7,0), 3 - 1);
		b.Set(sudoku::Index(7,7), 1 - 1);
		
		b.Set(sudoku::Index(8,1), 6 - 1);
		b.Set(sudoku::Index(8,3), 8 - 1);
		b.Set(sudoku::Index(8,4), 4 - 1);
		b.Set(sudoku::Index(8,5), 1 - 1);
		b.Set(sudoku::Index(8,8), 9 - 1);
	}
	
	// test case for which the algorithm should fail cleanly. (deadlock)
	void Unsolveable(sudoku::Board& b)
	{
		b.Set(sudoku::Index(0,0), 0);
		b.Set(sudoku::Index(1,4), 0);
		b.Set(sudoku::Index(2,6), 1);
		b.Set(sudoku::Index(2,7), 2);
		b.Set(sudoku::Index(2,8), 3);
	}
	
	int main()
	{
		sudoku::Board b;
		//Unsolveable(b);
		KevinBryanUnsolveableBug(b);
		//b.Print();
		std::cout << b.Solveable() << " " << b.Filled() << std::endl;
		
		//b.UnSet(sudoku::Index(2,7));
		b.Print<debug_output>();
		std::cout << b.Solveable() << " " << b.Filled() << std::endl;
		std::cout << "Solving: ";
		std::cout << (sudoku::Solve(b) ? "success" : "failed") << std::endl;
		b.Print<debug_output>();
		return 0;
	}
}

int main()
{
	return sudoku_test::main();
}
