// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace Gtk {

	using System;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class EditableAdapter : GLib.GInterfaceAdapter, Gtk.IEditable {

		[StructLayout (LayoutKind.Sequential)]
		struct GtkEditableInterface {
			IntPtr TextInserted;
			IntPtr TextDeleted;
			IntPtr Changed;
			public InsertTextNativeDelegate InsertText;
			public DeleteTextNativeDelegate DeleteText;
			public GetCharsNativeDelegate GetChars;
			public SelectRegionNativeDelegate SelectRegion;
			public GetSelectionBoundsNativeDelegate GetSelectionBounds;
			public SetPositionNativeDelegate SetPosition;
			public GetPositionNativeDelegate GetPosition;
		}

		static GtkEditableInterface iface;

		static EditableAdapter ()
		{
			GLib.GType.Register (_gtype, typeof (EditableAdapter));
			iface.InsertText = new InsertTextNativeDelegate (InsertText_cb);
			iface.DeleteText = new DeleteTextNativeDelegate (DeleteText_cb);
			iface.GetChars = new GetCharsNativeDelegate (GetChars_cb);
			iface.SelectRegion = new SelectRegionNativeDelegate (SelectRegion_cb);
			iface.GetSelectionBounds = new GetSelectionBoundsNativeDelegate (GetSelectionBounds_cb);
			iface.SetPosition = new SetPositionNativeDelegate (SetPosition_cb);
			iface.GetPosition = new GetPositionNativeDelegate (GetPosition_cb);
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void InsertTextNativeDelegate (IntPtr inst, IntPtr new_text, int new_text_length, ref int position);

		static void InsertText_cb (IntPtr inst, IntPtr new_text, int new_text_length, ref int position)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				__obj.InsertText (GLib.Marshaller.Utf8PtrToString (new_text), ref position);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void DeleteTextNativeDelegate (IntPtr inst, int start_pos, int end_pos);

		static void DeleteText_cb (IntPtr inst, int start_pos, int end_pos)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				__obj.DeleteText (start_pos, end_pos);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate IntPtr GetCharsNativeDelegate (IntPtr inst, int start_pos, int end_pos);

		static IntPtr GetChars_cb (IntPtr inst, int start_pos, int end_pos)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				string __result;
				__result = __obj.GetChars (start_pos, end_pos);
				return GLib.Marshaller.StringToPtrGStrdup(__result);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SelectRegionNativeDelegate (IntPtr inst, int start_pos, int end_pos);

		static void SelectRegion_cb (IntPtr inst, int start_pos, int end_pos)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				__obj.SelectRegion (start_pos, end_pos);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate bool GetSelectionBoundsNativeDelegate (IntPtr inst, out int start_pos, out int end_pos);

		static bool GetSelectionBounds_cb (IntPtr inst, out int start_pos, out int end_pos)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				bool __result;
				__result = __obj.GetSelectionBounds (out start_pos, out end_pos);
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void SetPositionNativeDelegate (IntPtr inst, int position);

		static void SetPosition_cb (IntPtr inst, int position)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				__obj.Position = position;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate int GetPositionNativeDelegate (IntPtr inst);

		static int GetPosition_cb (IntPtr inst)
		{
			try {
				IEditableImplementor __obj = GLib.Object.GetObject (inst, false) as IEditableImplementor;
				int __result;
				__result = __obj.Position;
				return __result;
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, true);
				// NOTREACHED: above call does not return.
				throw e;
			}
		}

		static int class_offset = 2 * IntPtr.Size;

		static void Initialize (IntPtr ptr, IntPtr data)
		{
			IntPtr ifaceptr = new IntPtr (ptr.ToInt64 () + class_offset);
			GtkEditableInterface native_iface = (GtkEditableInterface) Marshal.PtrToStructure (ifaceptr, typeof (GtkEditableInterface));
			native_iface.InsertText = iface.InsertText;
			native_iface.DeleteText = iface.DeleteText;
			native_iface.GetChars = iface.GetChars;
			native_iface.SelectRegion = iface.SelectRegion;
			native_iface.GetSelectionBounds = iface.GetSelectionBounds;
			native_iface.SetPosition = iface.SetPosition;
			native_iface.GetPosition = iface.GetPosition;
			Marshal.StructureToPtr (native_iface, ifaceptr, false);
		}

		GLib.Object implementor;

		public EditableAdapter ()
		{
			InitHandler = new GLib.GInterfaceInitHandler (Initialize);
		}

		public EditableAdapter (IEditableImplementor implementor)
		{
			if (implementor == null)
				throw new ArgumentNullException ("implementor");
			else if (!(implementor is GLib.Object))
				throw new ArgumentException ("implementor must be a subclass of GLib.Object");
			this.implementor = implementor as GLib.Object;
		}

		public EditableAdapter (IntPtr handle)
		{
			if (!_gtype.IsInstance (handle))
				throw new ArgumentException ("The gobject doesn't implement the GInterface of this adapter", "handle");
			implementor = GLib.Object.GetObject (handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_editable_get_type();

		private static GLib.GType _gtype = new GLib.GType (gtk_editable_get_type ());

		public static GLib.GType GType {
			get {
				return _gtype;
			}
		}

		public override GLib.GType GInterfaceGType {
			get {
				return _gtype;
			}
		}

		public override IntPtr Handle {
			get {
				return implementor.Handle;
			}
		}

		public IntPtr OwnedHandle {
			get {
				return implementor.OwnedHandle;
			}
		}

		public static IEditable GetObject (IntPtr handle, bool owned)
		{
			GLib.Object obj = GLib.Object.GetObject (handle, owned);
			return GetObject (obj);
		}

		public static IEditable GetObject (GLib.Object obj)
		{
			if (obj == null)
				return null;
			else if (obj is IEditableImplementor)
				return new EditableAdapter (obj as IEditableImplementor);
			else if (obj as IEditable == null)
				return new EditableAdapter (obj.Handle);
			else
				return obj as IEditable;
		}

		public IEditableImplementor Implementor {
			get {
				return implementor as IEditableImplementor;
			}
		}

		[UnmanagedFunctionPointer (CallingConvention.Cdecl)]
		delegate void TextInsertedSignalDelegate (IntPtr inst, IntPtr arg0, int arg1, ref int arg2, IntPtr gch);

		static void TextInsertedSignalCallback (IntPtr inst, IntPtr arg0, int arg1, ref int arg2, IntPtr gch)
		{
			Gtk.TextInsertedArgs args = new Gtk.TextInsertedArgs ();
			try {
				GLib.Signal sig = ((GCHandle) gch).Target as GLib.Signal;
				if (sig == null)
					throw new Exception("Unknown signal GC handle received " + gch);

				args.Args = new object[3];
				args.Args[0] = GLib.Marshaller.Utf8PtrToString (arg0);
				args.Args[1] = arg1;
				args.Args[2] = arg2;
				Gtk.TextInsertedHandler handler = (Gtk.TextInsertedHandler) sig.Handler;
				handler (GLib.Object.GetObject (inst), args);
			} catch (Exception e) {
				GLib.ExceptionManager.RaiseUnhandledException (e, false);
			}

			try {
				arg2 = ((int)args.Args[2]);
			} catch (Exception) {
				Exception ex = new Exception ("args.RetVal or 'out' property unset or set to incorrect type in Gtk.TextInsertedHandler callback");
				GLib.ExceptionManager.RaiseUnhandledException (ex, true);
				// NOTREACHED: above call doesn't return.
				throw ex;
			}
		}

		[GLib.Signal("insert-text")]
		public event Gtk.TextInsertedHandler TextInserted {
			add {
				GLib.Object.GetObject (Handle).AddSignalHandler ("insert-text", value, new TextInsertedSignalDelegate(TextInsertedSignalCallback));
			}
			remove {
				GLib.Object.GetObject (Handle).RemoveSignalHandler ("insert-text", value);
			}
		}

		[GLib.Signal("delete-text")]
		public event Gtk.TextDeletedHandler TextDeleted {
			add {
				GLib.Object.GetObject (Handle).AddSignalHandler ("delete-text", value, typeof (Gtk.TextDeletedArgs));
			}
			remove {
				GLib.Object.GetObject (Handle).RemoveSignalHandler ("delete-text", value);
			}
		}

		[GLib.Signal("changed")]
		public event System.EventHandler Changed {
			add {
				GLib.Object.GetObject (Handle).AddSignalHandler ("changed", value);
			}
			remove {
				GLib.Object.GetObject (Handle).RemoveSignalHandler ("changed", value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_copy_clipboard(IntPtr raw);

		public void CopyClipboard() {
			gtk_editable_copy_clipboard(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_cut_clipboard(IntPtr raw);

		public void CutClipboard() {
			gtk_editable_cut_clipboard(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_delete_selection(IntPtr raw);

		public void DeleteSelection() {
			gtk_editable_delete_selection(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_delete_text(IntPtr raw, int start_pos, int end_pos);

		public void DeleteText(int start_pos, int end_pos) {
			gtk_editable_delete_text(Handle, start_pos, end_pos);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr gtk_editable_get_chars(IntPtr raw, int start_pos, int end_pos);

		public string GetChars(int start_pos, int end_pos) {
			IntPtr raw_ret = gtk_editable_get_chars(Handle, start_pos, end_pos);
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_editable_get_editable(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_set_editable(IntPtr raw, bool is_editable);

		public bool IsEditable { 
			get {
				bool raw_ret = gtk_editable_get_editable(Handle);
				bool ret = raw_ret;
				return ret;
			}
			set {
				gtk_editable_set_editable(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int gtk_editable_get_position(IntPtr raw);

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_set_position(IntPtr raw, int position);

		public int Position { 
			get {
				int raw_ret = gtk_editable_get_position(Handle);
				int ret = raw_ret;
				return ret;
			}
			set {
				gtk_editable_set_position(Handle, value);
			}
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool gtk_editable_get_selection_bounds(IntPtr raw, out int start_pos, out int end_pos);

		public bool GetSelectionBounds(out int start_pos, out int end_pos) {
			bool raw_ret = gtk_editable_get_selection_bounds(Handle, out start_pos, out end_pos);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_insert_text(IntPtr raw, IntPtr new_text, int new_text_length, ref int position);

		public void InsertText(string new_text, ref int position) {
			IntPtr native_new_text = GLib.Marshaller.StringToPtrGStrdup (new_text);
			gtk_editable_insert_text(Handle, native_new_text, System.Text.Encoding.UTF8.GetByteCount (new_text), ref position);
			GLib.Marshaller.Free (native_new_text);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_paste_clipboard(IntPtr raw);

		public void PasteClipboard() {
			gtk_editable_paste_clipboard(Handle);
		}

		[DllImport("gtk-3-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void gtk_editable_select_region(IntPtr raw, int start_pos, int end_pos);

		public void SelectRegion(int start_pos, int end_pos) {
			gtk_editable_select_region(Handle, start_pos, end_pos);
		}

#endregion
	}
}
