/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.deployment;

import java.util.*;

/**
 * This is a descriptor for the taglib config used in a web application.
 */
public class JspConfigDescriptor extends Descriptor {
    
    private Set list = null;
    private Vector jspGroups = null;
    /**
     * return the set of tag lib elements
     */
    public Set getTagLibSet() {
	if(list == null) {
	    list = new HashSet();
	}
	return list;
    }

    /**
     * return the enumeration of tag lib elements
     */
    public Enumeration getTagLibs() {
	return (new Vector(this.getTagLibSet())).elements();
    }

    /**
     * add a tag lib element to the set.
     */
    public void addTagLib(TagLibConfigurationDescriptor desc) {
	getTagLibSet().add(desc);
        changed();
    }

    /**
     * remove a tag lib element from the set.
     */
    public void removeTagLib(TagLibConfigurationDescriptor desc) {
	getTagLibSet().remove(desc);
        changed();
    }

    /**
     * return the set of jsp-group elements 
     */
    public Collection getJspGroupSet() {
	if(jspGroups == null) {
	    jspGroups = new Vector();
	}
	return jspGroups;
    }

    /**
     * return the enumeration of jsp-group elements 
     */
    public Enumeration getJspGroups() {
	return (new Vector(getJspGroupSet())).elements();
    }

    /**
     * add a jsp group element to the set.
     */
    public void addJspGroup(JspGroupDescriptor desc) {
	getJspGroupSet().add(desc);
        changed();
    }

    /**
     * remove a jsp group element from the set.
     */
    public void removeJspGroup(JspGroupDescriptor desc) {
	getJspGroupSet().remove(desc);
        changed();
    }

    /**
     * @return a string describing the values I hold
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("\nTagLibs : ").append(list).append(" jsp groups:").append(jspGroups);
    }
}
