import categories
from code import values

import gtk
import os



#
# Class for appointments popup window.
#
class Popup(gtk.Window):

    def __init__(self):

        gtk.Window.__init__(self, gtk.WINDOW_POPUP)
        #self.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("lightyellow"))

        frame = gtk.Frame()
        frame.show()
        frame.set_shadow_type(gtk.SHADOW_OUT)
        self.add(frame)

        vbox = gtk.VBox()
        vbox.show()
        frame.add(vbox)

        titleframe = gtk.Viewport()
        titleframe.show()
        #titleframe.modify_bg(gtk.STATE_NORMAL,
        #                       gtk.gdk.color_parse("yellow"))
        titleframe.set_shadow_type(gtk.SHADOW_OUT)
        vbox.add(titleframe)

        
        self.__title = gtk.Label("")
        self.__title.show()
        titleframe.add(self.__title)


        self.__vbox = gtk.VBox()
        self.__vbox.show()
        vbox.pack_start(self.__vbox, gtk.TRUE, gtk.TRUE, 0)



    def __create_item(self, etime, text, location, categs):

        # escape certain characters for Pango
        text = text.replace("&", "&amp;")
        text = text.replace("<", "&lt;")
        text = text.replace(">", "&gt;")
        text = text.replace("\\\"", "\"")
        location = location.replace("&", "&amp;")
        location = location.replace("<", "&lt;")
        location = location.replace(">", "&gt;")
        location = location.replace("\\\"", "\"")

        item = gtk.HBox()
        item.show()

        align = gtk.Alignment(1, 0.5, 0, 0)
        align.show()
        item.pack_start(align, gtk.FALSE, gtk.FALSE, 10)
        lbl = gtk.Label("")
        lbl.set_markup("<small><b>%(etime)s</b></small>" % vars())
        lbl.show()
        align.add(lbl)

        align = gtk.Alignment(0, 0.5, 0, 0)
        align.show()
        item.pack_start(align, gtk.TRUE, gtk.TRUE, 8)
        lbl = gtk.Label("")
        lbl.set_justify(gtk.JUSTIFY_LEFT)
        lbl.set_markup("<small>%(text)s</small>" % vars())
        lbl.show()
        align.add(lbl)

        if (location):
            align = gtk.Alignment(1, 0.5, 0, 0)
            align.show()
            item.pack_start(align, gtk.FALSE, gtk.FALSE, 4)
            lbl = gtk.Label("")
            lbl.set_justify(gtk.JUSTIFY_LEFT)
            lbl.set_markup("<small>[%(location)s]</small>" % vars())
            lbl.show()
            align.add(lbl)

        for c in categs:
            icon = categories.ICONS.get(c)
            if (not icon): continue
            imgfile = os.path.join(os.environ[values.DESKCALHOME],
                                   values.GFXDIR, icon)
            img = gtk.Image()
            img.show()
            img.set_from_file(imgfile)
            item.pack_end(img, gtk.FALSE, gtk.FALSE, 2)
        #end for

        return item




    def set_title(self, title):

        self.__title.set_markup("<b>" + title + "</b>")



    def show(self, year, month, day, events):

        # remove old event items
        for c in self.__vbox.get_children():
            self.__vbox.remove(c)

        # display the given events
        for e in events:
            estart = e.get_occurrence(year, month, day)
            if (estart):
                shour, smin, ssec = estart.get_daytime()
            if (estart.has_daytime()):
                etime = "%(shour)02d:%(smin)02d" % vars()
                
            else:
                etime = "--:--"
            summary = e.get_summary()
            location = e.get_location()
            categs = e.get_categories()

            sep = gtk.HSeparator()
            sep.show()
            self.__vbox.pack_start(sep, gtk.FALSE, gtk.FALSE, 0)

            item = self.__create_item(etime, summary, location, categs)
            self.__vbox.pack_start(item, gtk.FALSE, gtk.FALSE, 8)
        #end for

        # this does not resize the window to 10, 10 but to its minimal size
        # request
        self.resize(10, 10)
        gtk.Window.show(self)
