/**************************************************************************\
 Closed Captionning decoding         Initial version
 by Chrisitan Lupien
    (lupien@physics.utoronto.ca)

 This is part of the Gatos project:
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila,
        Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

//#define CCTEST

#ifdef CCTEST
#include <stdio.h>
#endif

#include "gatos.h"
#include "cc.h"

/*  Display area is 15 row by 32 CC_COLUMNS
    starts on line 43 and ends on line 237 on interlaced display (195 lines
    long. Note full height is 21 to 262, first line is 1 and the frame is 525
    including blanking (fields are 262.5).
    E.I. A full screen has 3 more lines(18 of 13 CC_ROWS each), about 1.5 above
    and below the 15.
    Overall the text should be inside 80% vertically and horizontally of the
    displayable area (considering 15x34).
    Caption mode: 4 CC_ROWS max anyhere on screen
    Should erase the screen when shitching channels or fields.
    The receiver can keep capturing and analysing captions without displaying
    them.
    Roll up mode default row is 15, column 1; turn off unused CC_ROWS.
    If more characters than column is received the overwrite the column 32
    character or midrow code move 1 to the right
    backsapce move 1 to the left and erase it. backspace at col 1 is ignored
*/

/* Currently the display of caption is done on the tty where xatitv
   is started so the program cannot be run in backgound mode (it blocks if you
   try. Also since I am using ncurses you need to have a correctly set
   TERM variable. You can try a couple of different ones (linux, VT100, xterm).
   For modes CC1 and CC2 the program puts a blue screen (if ncurses thinks your
   terminal handles colors). The blue screen corresponds to the addresable size
   of the TV screen.

   Things to do:
   Text modes can be wrong. I guessed most of it. I guess I should remove
   pop, paint and roll modes handling (may be even erase screen).
   Some of the characters are not in iso-latin-1 so I use another character
   instead. 
   The EDS data is not handled properly. (on one example I got it contained 
   the tv show name and the channel name)
   To make the output use X and overlay or go in a separate window. Also 
   needs to handle the Italic font.
   And a lot more ....
*/

/* the following are valid codes for the iso01mod-8x16 font */
#define TMSYM 0x9f
#define MUSNOTE 0x9e
#define BLOCK 0x88

#define SCR_MODE_NONE 0
#define SCR_MODE_ROLL 1
#define SCR_MODE_POP 2
#define SCR_MODE_PAINT 3

struct screen {
  int num_row;
  int mode; /* none, roll, pop, paint */
  int roll;
  int clrflag;
  int cur_row;
  int cur_col;
  int row[CC_ROWS];
  unsigned char text[CC_ROWS][CC_COLUMNS]; 
  int attrib[CC_ROWS][CC_COLUMNS]; /* just need 4 for cc. I use a full page in 
                                Text mode so 15. No doc on text mode so this
                                is just a try */
  int dnum_row;
  int dcur_row;
  int dcur_col;
  int drow[4];
  unsigned char dtext[4][CC_COLUMNS];  /* Display for pop mode */
  int dattrib[4][CC_COLUMNS];
  int cur_attrib[CC_ROWS];
} sd[4]; /* screen data for CC1,CC2,Text1,Text2 */

/* My attribute logic with a current attribute perline can be wrong,
   It could be that erasing by backspace a mid-line code changes the attribute
*/

struct edsdata eds_sd;
struct ccdata ccout[4];
static int selector=-2;

void cc_decode(int, int);
void eds_decode(int, int);
void cc_control(int, int);
void cc_preamb(int low, int high);
void clear_sd(unsigned char *,int *);

struct ccdata * cc_get_data(void) {
  int i;
  for(i=0;i<=CC_MODE_TEXT2;i++) {
    ccout[i].clrflag=&(sd[i].clrflag);
    if(sd[i].mode!=SCR_MODE_POP) {
      ccout[i].num_row=sd[i].num_row;
      ccout[i].row=sd[i].row;
      ccout[i].text=sd[i].text;
      ccout[i].attrib=sd[i].attrib;
      } else {
      ccout[i].num_row=sd[i].dnum_row;
      ccout[i].row=sd[i].drow;
      ccout[i].text=sd[i].dtext;
      ccout[i].attrib=sd[i].dattrib;
      }
    }
  return ccout;
}

struct edsdata *eds_get_data(void) {
  return &eds_sd;
}

void cc_reset(void) {
  int i;
  for(i=0;i<4;i++) {
    sd[i].num_row=0;
    sd[i].dnum_row=0;
    sd[i].cur_row=0;
    sd[i].cur_col=0;
    sd[i].mode=SCR_MODE_NONE;
    sd[i].clrflag=1;
    }
  selector=-2;
  eds_sd.num=0;
  eds_sd.cur=0;
  for(i=0;i<EDS_BUFMAX;i++) eds_sd.buf[i]=0;
  }

void cc_hook(void) {
  struct CCdata data;
  int stat,dat;
  static int cclow_valid=0;
  static unsigned char cclow=0;
  static int edslow_valid=0;
  static unsigned char edslow=0;
  int i;
  gatos_getCCdata(&data);
  for(i=0; i<data.num_valid;i++) {
    stat=data.status[i];
/*
    if (data.data[i]!=0)
      printf("data=%3u(%c) %s %s %s %s\n",data.data[i],data.data[i],
                                    (stat&CCS_OVER)?"OVL":"   ",
                                    (stat&CCS_PAR)?"PAR":"   ",
                                    (stat&CCS_HIGH)?"HIGH":"LOW ",
                                    (stat&CCS_EDS)?"EDS":"CC ") ;
*/
    dat=data.data[i];
    /* we want to decode pairs low/high pairs of bytes 
     * so we combine them together */
    if(stat&CCS_EDS) {
      if(stat&CCS_PAR) dat=0xff; /* To possibly be replaced by a CC_BAD char */
      if(!(stat&CCS_HIGH)) {
         edslow=dat; edslow_valid=1; continue;}
      if((stat&CCS_HIGH) && edslow_valid) {
        edslow_valid=0; eds_decode(edslow,dat);}
      } else {
      if(stat&CCS_PAR) dat=0xff; /* To possibly be replaced by a CC_BAD char */
      if(!(stat&CCS_HIGH)) {
         cclow=dat; cclow_valid=1; continue;}
      if((stat&CCS_HIGH) && cclow_valid) {
        cclow_valid=0; cc_decode(cclow,dat);}
      }
    }
  }

int cfilter(int c,int alt){
/* assuming iso 8859-1 set */
  if (alt) {
    if(c==0x30) return 0xae; /* Registered */
    if(c==0x31) return 0xb0; /* degree */
    if(c==0x32) return 0xbd; /* 1/2 */
    if(c==0x33) return 0xbf; /* inverted query */
    if(c==0x34) return TMSYM;  /* should be trademark <SUP>TM */
    if(c==0x35) return 0xa2; /* cents sign */
    if(c==0x36) return 0xa3; /* Pounds Sterling sign */
    if(c==0x37) return MUSNOTE; /* should be a musical note, is inverted !*/; 
    if(c==0x38) return 0xe0; /* grave a or A */
    if(c==0x39) return CC_INVSPACE; /* transparent space */
    if(c==0x3a) return 0xe8; /* grave e or E */
    if(c==0x3b) return 0xe2; /* circumflex a or A*/
    if(c==0x3c) return 0xea; /* circumflex e or E*/
    if(c==0x3d) return 0xee; /* circumflex i or I*/
    if(c==0x3e) return 0xf4; /* circumflex o or O*/
    if(c==0x3f) return 0xfb; /* circumflex u or U*/
    return CC_BAD;
    }
  if((c<0x20)||(c>0x7f)) return CC_BAD;
  if(c==0x23) return '#'; /* pound (number) sign; 0x23 is # in ascii */
  if(c==0x2a) return 0xe1; /* accute a or A */
  if(c==0x5c) return 0xe9; /* accute e or E */
  if(c==0x5e) return 0xed; /* accute i or I */
  if(c==0x5f) return 0xf3; /* accute o or O */
  if(c==0x60) return 0xfa; /* accute u or U */
  /* 0x61 to 0x7b (a-z) can be replaced by A-Z */
  if(c==0x7b) return 0xe7;  /* c cedilla or C */
  if(c==0x7c) return 0xf7;  /* division sign */
  if(c==0x7d) return 0xd1; /* N tilde */
  if(c==0x7e) return 0xf1; /* n tilde or N*/
  if(c==0x7f) return BLOCK; /* solid block */
  return c;
  }

void set12(int is2) {
  int flag=0;
  if(selector<0) {flag=1; selector=0;}
  if(selector>=(CC_MODE_TEXT1)) 
   selector=CC_MODE_TEXT1+is2;
  else selector=CC_MODE_CC1+is2;
  if(flag) selector-=2;
  }

void setText(int isT) {
  int is2;
  if(selector<0) selector+=2;
  is2=selector&0x01;
  if(isT) selector=CC_MODE_TEXT1+is2;
  else selector=CC_MODE_CC1+is2;
  }

void cc_char(char code) {
  int col=sd[selector].cur_col-1;
  int row=sd[selector].cur_row-1;
  if(selector<0) return;
  if(sd[selector].num_row==0) return;
  sd[selector].text[row][col]=code;
  sd[selector].attrib[row][col]=sd[selector].cur_attrib[row]|CC_ATTR_NEWCHAR;
  if(col<(CC_COLUMNS-1)) sd[selector].cur_col++;
  }

void eds_decode(int low, int high) {
 int dat[2]={low,high};
 int i;
#if defined (CCTEST) && defined (EDSTEST)
  printf("%c%c",(char)low,(char)high); return;
#endif
 for(i=0;i<2;i++) {
   if(dat[i]!=0) {
     eds_sd.num++;
     eds_sd.buf[eds_sd.cur]=dat[i];
     eds_sd.cur++;
     if(eds_sd.cur>=EDS_BUFMAX) eds_sd.cur=0;
     }
   }
}

void cc_decode(int low, int high) {
  static int plow,phigh;
  /* check for codes */
#if defined (CCTEST) && !defined (EDSTEST)
  printf("%c%c",(char)low,(char)high); return;
#endif
  if((low>=0x10)&&(low<=0x1f)) {
    if((high<0x20)||(high>0x7f)) {
      /* invalid control, hope for the repeat to work! */
      plow=phigh=0;
      return;
      }
    if((high==phigh)&&(low=plow)) {
      /* repeated code, do nothing */
      plow=phigh=0;
      return;
      }
    /* looks like a valid code, do it */
    plow=low; phigh=high;
    cc_control(low,high);
    return;
    }
  if((low==0xff)&&(high==phigh)) {
    /* repeat code partially failed, skip it anyway */
    plow=phigh=0;
    return;
    }
  /* otherwise we just decode them as single char, parity errors are replaced
     by CC_BAD char */
  plow=phigh=0;
  if(low>0x0f) cc_char(cfilter(low,0)); /* check for an invalid low byte, 
                                           write the high anyway */
  if(high>=0x20) { /* the documentation does not mention what to do if
                      a char has valid parity but is below 0x20 so I decide
                      to skip it. I could also just print a CC_BAD. */
    cc_char(cfilter(high,0));
    }
  }

#define EXCH(A,T,B) T=A;A=B;B=T;
void sw_fields(struct screen * data) {
  int tmpint;
  unsigned char tmpchar;
  int row,col;
  EXCH(data->num_row,tmpint,data->dnum_row)
  EXCH(data->cur_row,tmpint,data->dcur_row)
  EXCH(data->cur_col,tmpint,data->dcur_col)
  for(row=0;row<4;row++) {
    EXCH(data->row[row],tmpint,data->drow[row])
    for(col=0;col<CC_COLUMNS;col++) {
      EXCH(data->attrib[row][col],tmpint,data->dattrib[row][col])
      EXCH(data->text[row][col],tmpchar,data->dtext[row][col])
      }
    }
  }

void cp_fields(struct screen * data) {
  int row,col;
  data->dnum_row=data->num_row;
  data->dcur_row=data->cur_row;
  data->dcur_col=data->cur_col;
  for(row=0;row<4;row++) {
    data->drow[row]=data->row[row];
    for(col=0;col<CC_COLUMNS;col++) {
      data->dattrib[row][col]=data->attrib[row][col];
      data->dtext[row][col]=data->text[row][col];
      }
    }
  }

void rollit(void) {
  int row;
  int col;
  int roll=sd[selector].roll;
  int num=sd[selector].num_row;
  int delta;
  struct screen *data=&(sd[selector]);
  if(num<roll) {
    sd[selector].num_row++;
    num++;
    }
  else {
    delta=num-roll;
    for(row=delta+1;row<num;row++) {
      data->row[row-delta-1]=data->row[row];
      for(col=0;col<CC_COLUMNS;col++) {
        data->attrib[row-delta-1][col]=data->attrib[row][col];
        data->text[row-delta-1][col]=data->text[row][col];
        }
      }
    num=roll;
    sd[selector].num_row=num;
    }
  sd[selector].cur_row=num;
  num--;
  sd[selector].row[num]=sd[selector].row[num-1];
  for(row=0;row<num;row++)
    sd[selector].row[row]--;
  sd[selector].cur_col=1;
  sd[selector].cur_attrib[num]=0;
  clear_sd(sd[selector].text[num],sd[selector].attrib[num]); 
  }

void cc_control(int low, int high) {
  int row,col,cur_attrib,num,tmp=selector,delta;
  struct screen *data;
  if((high>=0x40)&&(high<=0x4e)) {cc_preamb(low,high); return; }
  if((high>=0x50)&&(high<=0x5f)) {cc_preamb(low,high); return; }
  if((high>=0x60)&&(high<=0x6e)) {cc_preamb(low,high); return; }
  if((high>=0x70)&&(high<=0x7f)) {cc_preamb(low,high); return; }
  if((low==0x11)||(low==0x19)) {
    /* Alternate code, color, underline, italics  attribute*/
    if(high>0x3f) return; /*invalid code: skip it */
    set12(low==0x19);
    /* color as highest priority, italics next highest, flash has lowest */
    if(high>=0x30) { /* Alternate code */
      cc_char(cfilter(high,1));
      return;
      }
    if(high<=0x2d) { /* color, underline */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      sd[selector].cur_attrib[sd[selector].cur_row-1]=((high-0x20)<<3);
      cc_char(' '); /* Mid-Row codes are spacing */
      return;
      }
    if(high==0x2e) { /* italics, no underline */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      cur_attrib=sd[selector].cur_attrib[sd[selector].cur_row-1];
      sd[selector].cur_attrib[sd[selector].cur_row-1]= 
                             (cur_attrib&0xf8)|CC_ATTR_ITALICS;
      cc_char(' '); /* Mid-Row codes are spacing */
      return;
      }
    if(high==0x2f) { /* italics, underline */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      cur_attrib=sd[selector].cur_attrib[sd[selector].cur_row-1];
      sd[selector].cur_attrib[sd[selector].cur_row-1]= 
                    (cur_attrib&0xf8)|CC_ATTR_ITALICS|CC_ATTR_UNDERLINE;
      cc_char(' '); /* Mid-Row codes are spacing */
      return;
      }
    }
  if((low==0x14)||(low==0x1c)) { /* Misc codes */
    if((high<0x20)||(high>0x2f)) return; /* invalid code; skip it */
    set12(low==0x1c);
    if(high==0x20) { /* resume caption loading pop */
      setText(0);
      if(sd[selector].mode!=SCR_MODE_POP) {
        sd[selector].mode=SCR_MODE_POP;
        cp_fields(&(sd[selector]));
        }
      return;
      }
    if(high==0x21) { /* Backspace */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      if(sd[selector].cur_col<=1) return;
      sd[selector].cur_col--;
      cc_char(CC_INVSPACE);
      return;
      }
    if(high==0x22) return; /* Reserved (formerly Alarm Off). */
    if(high==0x23) return; /* Reserved (formerly Alarm On). */
    if(high==0x24) { /* Delete to end of Row */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      row=sd[selector].cur_row-1;
      for(col=sd[selector].cur_col-1; col<CC_COLUMNS;col++) {
        sd[selector].text[row][col]=CC_INVSPACE;
        sd[selector].attrib[row][col]=CC_ATTR_NEWCHAR;
        }
      return;
      }
    if((high>=0x25)&&(high<=0x27)) { /* Rool-Up Caption high-0x25+2 CC_ROWS */
      setText(0);
      if(sd[selector].mode!=SCR_MODE_ROLL) {
        sd[selector].mode=SCR_MODE_ROLL;
        sd[selector].num_row=1;
        sd[selector].clrflag=1;
        sd[selector].dnum_row=0;
        sd[selector].cur_row=1;
        sd[selector].cur_col=1;
        sd[selector].cur_attrib[0]=0;
        sd[selector].row[0]=15;
        clear_sd(sd[selector].text[0],sd[selector].attrib[0]); 
        }
      num=high-0x25+2;
      if(num<sd[selector].num_row) {
        sd[selector].clrflag=1;
        delta=sd[selector].num_row-num;
        data=&(sd[selector]);
        for(row=delta;row<num;row++) {
          data->row[row-delta]=data->row[row];
          for(col=0;col<CC_COLUMNS;col++) {
            data->attrib[row-delta][col]=data->attrib[row][col];
            data->text[row-delta][col]=data->text[row][col];
            data->row[row-delta]=data->row[row];
            }
          }
        data->cur_row=num;
        }
      sd[selector].roll=num;
      if(tmp==selector) sd[selector].cur_col=1;
      return;
      }
    if(high==0x28) { /* Flash On */
      if(selector<0) return;
      if(sd[selector].num_row==0) return;
      row=sd[selector].cur_row-1;
      sd[selector].cur_attrib[row]|=CC_ATTR_FLASH;
      cc_char(' ');
      return;
      }
    if(high==0x29) { /* Resume Direct Captioning paint */
      setText(0);
      if(sd[selector].mode!=SCR_MODE_PAINT) {
        if(sd[selector].mode==SCR_MODE_POP) {
          sw_fields(&(sd[selector]));
          }
        sd[selector].mode=SCR_MODE_PAINT;
        }
      return;
      }
    if(high==0x2a) { /* Text restart */
      setText(1);
      if(sd[selector].num_row==0) {
        sd[selector].num_row=1;
        sd[selector].cur_row=1;
        sd[selector].cur_col=1;
        sd[selector].cur_attrib[0]=0;
        sd[selector].row[0]=CC_ROWS;
        sd[selector].roll=CC_ROWS;
        }
      clear_sd(sd[selector].text[sd[selector].cur_row-1],
              sd[selector].attrib[sd[selector].cur_row-1]); 
      return;
      }
    if(high==0x2b) { /* Resume Text display */
      setText(1);
      if(sd[selector].num_row==0) {
        sd[selector].num_row=1;
        sd[selector].cur_row=1;
        sd[selector].cur_col=1;
        sd[selector].cur_attrib[0]=0;
        clear_sd(sd[selector].text[0],sd[selector].attrib[0]); 
        sd[selector].row[0]=CC_ROWS;
        sd[selector].roll=CC_ROWS;
        }
      return;
      }
    if(high==0x2c) { /* Erase Displayed memory */
      if(selector<0) return;
      if(sd[selector].mode==SCR_MODE_POP) {
        sd[selector].dnum_row=0;
        sd[selector].dcur_row=0;
        sd[selector].dcur_col=0;
        }
      else {
        sd[selector].num_row=0;
        sd[selector].cur_row=0;
        sd[selector].cur_col=0;
        }
      sd[selector].clrflag=1;
      return;
      }
    if(high==0x2d) { /* Carriage return */
      if(selector<0) return;
      if((sd[selector].mode!=SCR_MODE_ROLL)&&(selector<=(CC_MODE_CC2)))
        return;
      rollit();
      sd[selector].clrflag=1;
      return;
      }
    if(high==0x2e) { /* Erase non-displayed memory */
      if(selector<0) return;
      if(sd[selector].mode==SCR_MODE_POP) {
        sd[selector].num_row=0;
        sd[selector].cur_row=0;
        sd[selector].cur_col=0;
        }
      return;
      }
    if(high==0x2f) { /* End of caption, flip memories */
      setText(0);
      if(sd[selector].mode!=SCR_MODE_POP) {
        sd[selector].mode=SCR_MODE_POP;
        cp_fields(&(sd[selector]));
        } else {
        sd[selector].clrflag=1;
        sw_fields(&(sd[selector]));
        }
      return;
      }
    }
  if((low==0x17)||(low==0x1f)) { /* Tab offsets */
    if((high>=0x21)&&(high<=0x23)) return; /* invalid code; skip it */
    set12(low==0x1f);
    if(selector<0) return;
    if(sd[selector].num_row==0) return;
    col=(sd[selector].cur_col+=high-0x20);
    if(col>CC_COLUMNS) sd[selector].cur_col=CC_COLUMNS;
    return;
    }
  }

void clear_sd(unsigned char *text,int *attrib){
  int i;
  for(i=0;i<CC_COLUMNS;i++) {
    text[i]=CC_INVSPACE;
    attrib[i]=CC_ATTR_NEWCHAR;
    }
  }

void cc_preamb(int low, int high) {
  int secf,colf=0;
  int cur_col=0,cur_row,cur_attrib=0;
  int row,col;
  int delta;
  struct screen *data;
  if((low==0x10)&&(high&0x20)) return;
  if((low==0x18)&&(high&0x20)) return;
  set12(secf=(low>=0x18));
  if(selector<0) return;
  low-= 0x10+secf*0x08;
  low= ((low<<1)|(high>=0x60));
  if(high&0x10) { /* Not attribute but column indent */
    cur_col=1+2*(high&0x0f);
    colf=1; 
    }
  else {
    high&=0x0f;
    if(high<=0x4d) cur_attrib=((high&0x0f)<<3);
    else cur_attrib=CC_ATTR_ITALICS;
    }
  /* now lets handle the row code, It is in low and is not a linear relation */
  if(low==0) cur_row=11;  /* row 11 */
  else if(low<=5) cur_row=low-1; /* CC_ROWS 1 to 4 */
  else if(low<=9) cur_row=low+6;  /* CC_ROWS 12 to 15 */
  else cur_row=low-5; /* CC_ROWS 5 to 10 */
  if(selector<=(CC_MODE_CC2)) {
    if(sd[selector].mode==SCR_MODE_ROLL) {
      delta=sd[selector].row[sd[selector].cur_row-1]-cur_row;
      if(delta!=0) {
        sd[selector].clrflag=1;
        for(row=sd[selector].num_row-1;row>=0;row--) 
          sd[selector].row[row]-=delta;
        }
      }
    else { /* we do the more complicated ones: POP and PAINT */
      /* first check if it exists already */
      for(row=0;row<sd[selector].num_row;row++)
        if(cur_row==sd[selector].row[row]) break;
      if(row!=sd[selector].num_row) {
        sd[selector].cur_row=row+1;
        }
      else {
        if(sd[selector].num_row==4) { /* let's get rid of the oldest one */
          sd[selector].clrflag=1;
          data=&(sd[selector]);
          for(row=1;row<4;row++)
            for(col=0;col<CC_COLUMNS;col++) {
              data->attrib[row-1][col]=data->attrib[row][col];
              data->text[row-1][col]=data->text[row][col];
              data->row[row-1]=data->row[row];
              }
          sd[selector].num_row--;
          }
        sd[selector].num_row++;
        row=sd[selector].cur_row=sd[selector].num_row;
        row--;
        clear_sd(sd[selector].text[row],sd[selector].attrib[row]);
        sd[selector].cur_attrib[row]=0;
        sd[selector].row[row]=cur_row;
        sd[selector].cur_col=1;
        }
      }
    }
  if(colf) sd[selector].cur_col=cur_col;
  else sd[selector].cur_attrib[sd[selector].cur_row-1]=cur_attrib;
  }
/* may be a color atttribute removes the indent or vice versa */
