#!/bin/sh
#
##############################################################
# This will generate automatically configure and Makefile.in #
##############################################################
#
#######
M4FILES="gettext.m4 curses.m4 libtool.m4 gatos.m4"
#######
# Put here args for *auto*programs
#######
ACLOCAL_ARGS=""
AUTOHEADER_ARGS=""
AUTOCONF_ARGS=""
AUTOMAKE_ARGS=""
#######
#
#######
 echo -n "Check if m4 directory available:"
 if test -d m4; then
   echo " yes"
   echo -n "Erase old acinclude.m4:"
   rm -f acinclude.m4
   echo " done"
   echo "Concatenate files:"
   for m4_file in $M4FILES; do
     echo "    m4/$m4_file"
     cat m4/$m4_file >> acinclude.m4
   done
   echo " to acinclude.m4."
 else
   echo " no"
   echo "m4 directory not found, skipping generation of acinclude.m4"
   exit
 fi
#######
#
#######
 echo -n "Start aclocal with args ($ACLOCAL_ARGS):"
 aclocal $ACLOCAL_ARGS
 echo " done"
 echo -n "Start autoheader with args ($AUTOHEADER_ARGS):"
 autoheader $AUTOHEADER_ARGS
 echo " done"
 echo -n "Start autoconf with args ($AUTOCONF_ARGS):"
 autoconf $AUTOCONF_ARGS
 echo " done"
 echo -n "Start automake with args ($AUTOMAKE_ARGS):"
 automake $AUTOMAKE_ARGS
 echo " done"
#######
#
#######
 echo -n "Delete config.cache:"
 rm -f config.cache
 echo " done"
#######
#
##
# End of autogen.sh
####
