/*
 * fhist - file history and comparison tools
 * Copyright (C) 1991-1995, 1998, 2002, 2008, 2010 Peter Miller
 *
 * Derived from a work
 * Copyright (C) 1990 David I. Bell.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Definitions to use releaseable memory allocation.
 */

#ifndef CMALLOC_H
#define CMALLOC_H

#include <common/ac/stddef.h>

#include <common/main.h>

/*
 * prevent use of libc functions
 */
#undef malloc
#define malloc(n)       !/!/!cmalloc((unsigned long) (n))
#undef realloc
#define realloc(p,n)    !/!/!cmrealloc((char *) (p), (unsigned long) (n))
#undef calloc
#define calloc(n,s)     !/!/!cmcalloc((unsigned long) (n), (unsigned long) (s))
#undef free
#define free(p)         !/!/!cmfree((char *) (p))

/*
 * these functions can be released
 * by using the cmreset function.
 */
void *cm_alloc_and_check(size_t);
void *cm_realloc_and_check(void *, size_t);
void *cm_calloc_and_check(size_t, size_t);
void cm_free(void *);
void cm_reset(void);

#endif /* CMALLOC_H */
