      subroutine getedg (ihole, iz, emu)
      implicit double precision (a-h, o-z)
      include '../HEADERS/dim.h'
      include '../HEADERS/const.h'
                                                                                
      dimension exmu(1:100,1:29)
                                                                                
c edge energies for each element for z = 1, 98
c some values taken from W.T.Elam's table:
c Li L1, Be to C L1-3, N & O L2-3, F L1-3, Mg to Cl M1-3,
c Ti to Cu M4-5, Zn N2-3, Ga to Br N1-3, Rh to Ag N4-5,
c Sb to I O1-3, Ce N5, Pm M1 N1 N6-7 O1-3, Eu N6-7, Gd N4,
c Er N6, Tm N6, Au O4-5, Pb to At P1-3, Rn P2-3, Ac P1-3
c Pa P1-3, and all values up to from z=92 to z=98
      data (exmu( 1,i),i=1,29)  /13.6,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 2,i),i=1,29)  /24.6,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 3,i),i=1,29)  /54.7,5.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 4,i),i=1,29)  /111.5,8.0,3.0,3.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 5,i),i=1,29)  /188.0,12.6,4.7,4.7,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 6,i),i=1,29)  /284.2,18.0,7.2,7.2,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 7,i),i=1,29)  /409.9,37.3,17.5,17.5,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu( 8,i),i=1,29)  /543.1,41.6,18.2,18.2,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
                                                                                
c     To test a problem with sum rules for F absorber in LiF, I
c     have put the Flourine edge energies back to Feff default.
c     MPP 8/7/03. Set back 10/16/03 MPP.
      data (exmu( 9,i),i=1,29)  /696.7,45.0,19.9,19.9,
c      data (exmu( 9,i),i=1,29)  /-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(10,i),i=1,29)  /870.2,48.5,21.7,21.6,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(11,i),i=1,29)  /1070.8,63.5,30.65,30.81,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(12,i),i=1,29)  /1303.0,88.7,49.78,49.5,
     1                           2.0,1.0,1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(13,i),i=1,29)  /1559.6,117.8,72.95,72.55,
     1                           4.0,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(14,i),i=1,29)  /1839.0,149.7,99.82,99.42,
     1                           8.0,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(15,i),i=1,29)  /2145.5,189.0,136.0,135.0,
     1                           12.0,7.0,6.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(16,i),i=1,29)  /2472.0,230.9,163.6,162.5,
     1                           14.0,8.0,7.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(17,i),i=1,29)  /2822.4,270.0,202.0,200.0,
     1                           18.0,10.0,10.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(18,i),i=1,29)  /3205.9,326.3,250.6,248.4,
     1                           29.3,15.9,15.7,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(19,i),i=1,29)  /3608.4,378.6,297.3,294.6,
     1                           34.8,18.3,18.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(20,i),i=1,29)  /4038.5,438.4,349.7,346.2,
     1                           44.3,25.4,25.4,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(21,i),i=1,29)  /4492.0,498.0,403.6,398.7,
     1                           51.1,28.3,28.3,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(22,i),i=1,29)  /4966.0,560.9,460.2,453.8,
     1                           58.7,32.6,32.6,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(23,i),i=1,29)  /5465.0,626.7,519.8,512.1,
     1                           66.3,37.2,37.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(24,i),i=1,29)  /5989.0,696.0,583.8,574.1,
     1                           74.1,42.2,42.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(25,i),i=1,29)  /6539.0,769.1,649.9,638.7,
     1                           82.3,47.2,47.2,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(26,i),i=1,29)  /7112.0,844.6,719.9,706.8,
     1                           91.3,52.7,52.7,2.0,2.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(27,i),i=1,29)  /7709.0,925.1,793.2,778.1,
     1                           101.0,58.9,59.9,3.0,3.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(28,i),i=1,29)  /8333.0,1008.6,870.0,852.7,
     1                           110.8,68.0,66.2,4.0,4.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(29,i),i=1,29)  /8979.0,1096.7,952.3,932.7,
     1                           122.5,77.3,75.1,5.0,5.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(30,i),i=1,29)  /9659.0,1196.2,1044.9,1021.8,
     1                          139.8,91.4,88.6,10.2,10.1,
     1                          -1.0,1.0,1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(31,i),i=1,29)  /10367.0,1299.0,1143.2,1116.4,
     1                           159.5,103.5,100.0,18.7,18.7,
     1                           1.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(32,i),i=1,29)  /11103.0,1414.6,1248.1,1217.0,
     1                           180.1,124.9,120.8,29.8,29.2,
     1                           5.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(33,i),i=1,29)  /11867.0,1527.0,1359.1,1323.6,
     1                           204.7,146.2,141.2,41.7,41.7,
     1                           8.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(34,i),i=1,29)  /12658.0,1652.0,1474.3,1433.9,
     1                           229.6,166.5,160.7,55.5,54.6,
     1                           12.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(35,i),i=1,29)  /13474.0,1782.0,1596.0,1550.0,
     1                           257.0,189.0,182.0,70.0,69.0,
     1                           27.0,3.0,3.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(36,i),i=1,29)  /14326.0,1921.0,1730.9,1678.4,
     1                           292.8,222.2,214.4,95.0,93.8,
     1                           27.5,14.1,14.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(37,i),i=1,29)  /15200.0,2065.0,1864.0,1804.0,
     1                           326.7,248.7,239.1,113.0,112.0,
     1                           30.5,16.3,15.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(38,i),i=1,29)  /16105.0,2216.0,2007.0,1940.0,
     1                           358.7,280.3,270.0,136.0,134.2,
     1                           38.9,21.3,20.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(39,i),i=1,29)  /17038.0,2373.0,2156.0,2080.0,
     1                           392.0,310.6,298.8,157.7,155.8,
     1                           43.8,24.4,23.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(40,i),i=1,29)  /17998.0,2532.0,2307.0,2223.0,
     1                           430.3,343.5,329.8,181.1,178.8,
     1                           50.6,28.5,27.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(41,i),i=1,29)  /18986.0,2698.0,2465.0,2371.0,
     1                           466.6,376.1,360.6,205.0,202.3,
     1                           56.4,32.6,30.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(42,i),i=1,29)  /20000.0,2866.0,2625.0,2520.0,
     1                           506.3,411.6,394.0,231.1,227.9,
     1                           63.2,37.6,35.5,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(43,i),i=1,29)  /21044.0,3043.0,2793.0,2677.0,
     1                           544.0,447.6,417.7,257.6,253.9,
     1                           69.5,42.3,39.9,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(44,i),i=1,29)  /22117.0,3224.0,2967.0,2838.0,
     1                           586.1,483.5,461.4,284.2,280.0,
     1                           75.0,46.3,43.2,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(45,i),i=1,29)  /23220.0,3412.0,3146.0,3004.0,
     1                           628.1,521.3,496.5,311.9,307.2,
     1                           81.4,50.5,47.3,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(46,i),i=1,29)  /24350.0,3604.0,3330.0,3173.0,
     1                           671.6,559.9,532.3,340.5,335.2,
     1                           87.1,55.7,50.9,2.0,2.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(47,i),i=1,29)  /25514.0,3806.0,3524.0,3351.0,
     1                           719.0,603.8,573.0,374.0,368.3,
     1                           97.0,63.7,58.3,4.0,4.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(48,i),i=1,29)  /26711.0,4018.0,3727.0,3538.0,
     1                           772.0,652.6,618.4,411.9,405.2,
     1                           109.8,63.9,63.9,11.7,10.7,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(49,i),i=1,29)  /27940.0,4238.0,3938.0,3730.0,
     1                           827.2,703.2,665.3,451.4,443.9,
     1                           122.9,73.5,73.5,17.7,16.9,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(50,i),i=1,29)  /29200.0,4465.0,4156.0,3929.0,
     1                           884.7,756.5,714.6,493.2,484.9,
     1                           137.1,83.6,83.6,24.9,23.9,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(51,i),i=1,29)  /30491.0,4698.0,4380.0,4132.0,
     1                           946.0,812.7,766.4,537.5,528.2,
     1                           153.2,95.6,95.6,33.3,32.1,-1.0,-1.0,
     1                           7.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(52,i),i=1,29)  /31814.0,4939.0,4612.0,4341.0,
     1                           1006.0,870.8,820.0,583.4,573.0,
     1                           169.4,103.3,103.3,41.9,40.4,-1.0,-1.0,
     1                           12.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(53,i),i=1,29)  /33169.0,5188.0,4852.0,4557.0,
     1                           1072.0,931.0,875.0,630.8,619.3,
     1                           186.0,123.0,123.0,50.6,48.9,-1.0,-1.0,
     1                           14.0,2.0,2.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(54,i),i=1,29)  /34561.0,5453.0,5107.0,4786.0,
     1                           1148.7,1002.1,940.6,689.0,676.4,
     1                           213.2,146.7,145.5,69.5,67.5,-1.0,-1.0,
     1                           23.3,13.4,12.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(55,i),i=1,29)  /35985.0,5714.0,5359.0,5012.0,
     1                           1211.0,1071.0,1003.0,740.5,726.6,
     1                           232.3,172.4,161.3,79.8,77.5,-1.0,-1.0,
     1                           22.7,14.2,12.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(56,i),i=1,29)  /37441.0,5989.0,5624.0,5247.0,
     1                           1293.0,1137.0,1063.0,795.7,780.5,
     1                           253.5,192.0,178.6,92.6,89.9,-1.0,-1.0,
     1                           30.3,17.0,14.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(57,i),i=1,29)  /38925.0,6266.0,5891.0,5483.0,
     1                           1362.0,1209.0,1128.0,853.0,836.0,
     1                          274.7,205.8,196.0,105.3,102.5,-1.0,-1.0,
     1                           34.3,19.3,16.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(58,i),i=1,29)  /40443.0,6549.0,6164.0,5723.0,
     1                           1436.0,1274.0,1187.0,902.4,883.8,
     1                           291.0,223.2,206.5,109.0,109.0,0.1,0.1,
     1                           37.8,19.8,17.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(59,i),i=1,29)  /41991.0,6835.0,6440.0,5964.0,
     1                           1511.0,1337.0,1242.0,948.3,928.8,
     1                           304.5,236.3,217.6,115.1,115.1,2.0,2.0,
     1                           37.4,22.3,22.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(60,i),i=1,29)  /43569.0,7126.0,6722.0,6208.0,
     1                           1575.0,1403.0,1297.0,1003.3,980.4,
     1                           319.2,243.3,224.6,120.5,120.5,1.5,1.5,
     1                           37.5,21.1,21.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(61,i),i=1,29)  /45184.0,7428.0,7013.0,6459.0,
     1                           1650.0,1471.0,1357.0,1052.0,1027.0,
     1                           331.0,242.0,242.0,120.0,120.0,4.0,4.0,
     1                           38.0,22.0,22.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(62,i),i=1,29)  /46834.0,7737.0,7312.0,6716.0,
     1                           1723.0,1541.0,1420.0,1110.9,1083.4,
     1                           347.2,265.6,247.4,129.0,129.0,5.2,5.2,
     1                           37.4,21.3,21.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(63,i),i=1,29)  /48519.0,8052.0,7617.0,6977.0,
     1                           1800.0,1614.0,1481.0,1158.6,1127.5,
     1                           360.0,284.0,257.0,133.0,127.7,6.0,6.0,
     1                           32.0,22.0,22.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(64,i),i=1,29)  /50239.0,8376.0,7930.0,7243.0,
     1                           1881.0,1688.0,1544.0,1221.9,1189.6,
     1                           378.6,286.0,271.0,142.6,142.6,8.6,8.6,
     1                           36.0,28.0,21.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(65,i),i=1,29)  /51996.0,8708.0,8252.0,7514.0,
     1                           1968.0,1768.0,1611.0,1276.9,1241.1,
     1                           396.0,322.4,284.1,150.5,150.5,7.7,2.4,
     1                           45.6,28.7,22.6,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(66,i),i=1,29)  /53789.0,9046.0,8581.0,7790.0,
     1                           2047.0,1842.0,1676.0,1333.0,1292.6,
     1                           414.2,333.5,293.2,153.6,153.6,8.0,4.3,
     1                           49.9,26.3,26.3,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(67,i),i=1,29)  /55618.0,9394.0,8918.0,8071.0,
     1                           2128.0,1923.0,1741.0,1392.0,1351.0,
     1                           432.4,343.5,308.2,160.0,160.0,8.6,5.2,
     1                           49.3,30.8,24.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(68,i),i=1,29)  /57486.0,9751.0,9264.0,8358.0,
     1                           2207.0,2006.0,1812.0,1453.0,1409.0,
     1                           449.8,366.2,320.2,167.6,167.6,4.7,4.7,
     1                           50.6,31.4,24.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(69,i),i=1,29)  /59390.0,10116.0,9617.0,8648.0,
     1                           2307.0,2090.0,1885.0,1515.0,1468.0,
     1                           470.9,385.9,332.6,175.5,175.5,4.6,4.6,
     1                           54.7,31.8,25.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(70,i),i=1,29)  /61332.0,10486.0,9978.0,8944.0,
     1                           2398.0,2173.0,1950.0,1576.0,1528.0,
     1                           480.5,388.7,339.7,191.2,182.4,2.5,1.3,
     1                           52.0,30.3,24.1,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(71,i),i=1,29)  /63314.0,10870.0,10349.0,9244.0,
     1                           2491.0,2264.0,2024.0,1639.0,1589.0,
     1                           506.8,412.4,359.2,206.1,196.3,8.9,7.5,
     1                           57.3,33.6,26.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(72,i),i=1,29)  /65351.0,11271.0,10739.0,9561.0,
     1                           2601.0,2365.0,2108.0,1716.0,1662.0,
     1                          538.0,438.2,380.7,220.0,211.5,15.9,14.2,
     1                           64.2,38,29.9,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(73,i),i=1,29)  /67416.0,11682.0,11136.0,9881.0,
     1                           2708.0,2469.0,2194.0,1793.0,1735.0,
     1                          563.4,463.4,400.9,237.9,226.4,23.5,21.6,
     1                           69.7,42.2,32.7,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(74,i),i=1,29)  /69525.0,12100.0,11544.0,10207.0,
     1                           2820.0,2575.0,2281.0,1872.0,1809.0,
     1                          594.1,490.4,423.6,255.9,243.5,33.6,31.4,
     1                           75.6,45.3,36.8,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(75,i),i=1,29)  /71676.0,12527.0,11959.0,10535.0,
     1                           2932.0,2682.0,2367.0,1949.0,1883.0,
     1                          625.4,518.7,446.8,273.9,260.5,42.9,40.5,
     1                           83.0,45.6,34.6,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                
      data (exmu(76,i),i=1,29) /73871.0,12968.0,12385.0,10871.0,
     1                          3049.0,2792.0,2457.0,2031.0,1960.0,
     1                          658.2,549.1,470.7,293.1,278.5,53.4,50.7,
     1                          84.0,58.0,44.5,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(77,i),i=1,29) /76111.0,13419.0,12824.0,11215.0,
     1                          3174.0,2909.0,2551.0,2116.0,2040.0,
     1                          691.1,577.8,495.8,311.9,296.3,63.8,60.8,
     1                          95.2,63.0,48.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(78,i),i=1,29) /78395.0,13880.0,13273.0,11564.0,
     1                          3296.0,3027.0,2645.0,2202.0,2122.0,
     1                          725.4,609.1,519.4,331.6,314.6,74.5,71.2,
     1                          101.7,65.3,51.7,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(79,i),i=1,29) /80725.0,14353.0,13734.0,11919.0,
     1                          3425.0,3148.0,2743.0,2291.0,2206.0,
     1                          762.1,642.7,546.3,353.2,335.1,87.6,84.0,
     1                          107.2,74.2,57.2,5.0,5.0,-1.0,-1.0,
     1                         -1.0,-1.0,-1.0,-1.0,-1.0,
     1                         -1.0/
                                                                                
      data (exmu(80,i),i=1,29)/83102.0,14839.0,14209.0,12284.0,
     1                         3562.0,3279.0,2847.0,2385.0,2295.0,
     1                         802.2,680.2,576.6,378.2,358.8,104.0,99.9,
     1                         127.0,83.1,64.5,9.6,7.8,-1.0,-1.0,
     1                        -1.0,-1.0,-1.0,-1.0,-1.0,
     1                        -1.0/
                                                                                
      data (exmu(81,i),i=1,29)/85530.0,15347.0,14698.0,12658.0,
     1                        3704.0,3416.0,2957.0,2485.0,2389.0,
     1                        846.2,720.5,609.5,405.7,385.0,122.2,117.8,
     1                        136.0,94.6,73.5,14.7,12.5,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(82,i),i=1,29)/88005.0,15861.0,15200.0,13035.0,
     1                        3851.0,3554.0,3066.0,2586.0,2484.0,
     1                        891.8,761.9,643.5,434.3,412.2,141.7,136.9,
     1                        147.0,106.4,83.3,20.7,18.1,-1.0,-1.0,
     1                        3.0,1.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(83,i),i=1,29)/90526.0,16388.0,15711.0,13419.0,
     1                        3999.0,3696.0,3177.0,2688.0,2580.0,
     1                        939.0,805.2,678.8,464.0,440.1,162.3,157.0,
     1                        159.3,119.0,92.6,26.9,23.8,-1.0,-1.0,
     1                        8.0,3.0,3.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(84,i),i=1,29)/93105.0,16939.0,16244.0,13814.0,
     1                        4149.0,3854.0,3302.0,2798.0,2683.0,
     1                        995.0,851.0,705.0,500.0,473.0,184.0,184.0,
     1                        177.0,132.0,104.0,31.0,31.0,-1.0,-1.0,
     1                        9.0,4.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(85,i),i=1,29)/95730.0,17493.0,16785.0,14214.0,
     1                       4317.0,4008.0,3426.0,2909.0,2787.0,
     1                       1042.0,886.0,740.0,533.0,507.0,210.0,210.0,
     1                       195.0,148.0,115.0,40.0,40.0,-1.0,-1.0,
     1                       13.0,6.0,1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(86,i),i=1,29)/98404.0,18049.0,17337.0,14619.0,
     1                       4482.0,4159.0,3538.0,3022.0,2892.0,
     1                       1097.0,929.0,768.0,567.0,541.0,238.0,238.0,
     1                       214.0,164.0,127.0,48.0,48.0,-1.0,-1.0,
     1                       26.0,8.0,2.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(87,i),i=1,29)/101137.0,18639.0,17907.0,15031.0,
     1                       4652.0,4327.0,3663.0,3136.0,3000.0,
     1                       1153.0,980.0,810.0,603.0,577.0,268.0,268.0,
     1                       234.0,182.0,140.0,58.0,58.0,-1.0,-1.0,
     1                       34.0,15.0,15.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(88,i),i=1,29)/103922.0,19237.0,18484.0,15444.0,
     1                       4822.0,4490.0,3792.0,3248.0,3105.0,
     1                      1208.0,1058.0,879.0,636.0,603.0,299.0,299.0,
     1                       254.0,200.0,153.0,68.0,68.0,-1.0,-1.0,
     1                       44.0,19.0,19.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(89,i),i=1,29)/106755.0,19840.0,19083.0,15871.0,
     1                       5002.0,4656.0,3909.0,3370.0,3219.0,
     1                      1269.0,1080.0,890.0,675.0,639.0,319.0,319.0,
     1                       272.0,215.0,167.0,80.0,80.0,-1.0,-1.0,
     1                       37.0,24.0,15.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(90,i),i=1,29)/109651.0,20472.0,19693.0,16300.0,
     1                       5182.0,4830.0,4046.0,3491.0,3332.0,
     1                      1330.0,1168.0,966.4,712.1,675.2,342.4,333.1,
     1                       290.0,229.0,182.0,92.5,85.4,-1.0,-1.0,
     1                       41.4,24.5,16.6,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(91,i),i=1,29)/112601.0,21105.0,20314.0,16733.0,
     1                       5367.0,5001.0,4174.0,3611.0,3442.0,
     1                     1387.0,1224.0,1007.0,743.0,708.0,371.0,360.0,
     1                       310.0,232.0,232.0,94.0,94.0,-1.0,-1.0,
     1                       43.0,27.0,17.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(92,i),i=1,29)/115606.0,21757.0,20948.0,17166.0,
     1                       5548.0,5182.0,4303.0,3728.0,3552.0,
     1                     1439.0,1271.0,1043.0,778.3,736.2,388.2,377.4,
     1                       321.0,257.0,192.0,102.8,94.2,-1.0,-1.0,
     1                       43.9,26.8,16.8,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(93,i),i=1,29)/118669.0,22427.0,21600.0,17610.0,
     1                       5739.0,5366.0,4435.0,3849.0,3664.0,
     1                     1501.0,1328.0,1085.0,816.0,771.0,414.0,403.0,
     1                       338.0,274.0,206.0,109.0,101.0,-1.0,-1.0,
     1                       47.0,29.0,18.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(94,i),i=1,29)/121791.0,23104.0,22266.0,18057.0,
     1                       5933.0,5547.0,4563.0,3970.0,3775.0,
     1                     1559.0,1380.0,1123.0,846.0,798.0,436.0,424.0,
     1                       350.0,283.0,213.0,113.0,102.0,-1.0,-1.0,
     1                       46.0,29.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(95,i),i=1,29)/124982.0,23808.0,22952.0,18510.0,
     1                       6133.0,5739.0,4698.0,4096.0,3890.0,
     1                     1620.0,1438.0,1165.0,880.0,829.0,461.0,446.0,
     1                       365.0,298.0,219.0,116.0,106.0,-1.0,-1.0,
     1                       48.0,29.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(96,i),i=1,29)/128241.0,24526.0,23651.0,18970.0,
     1                       6337.0,5937.0,4838.0,4224.0,4009.0,
     1                     1684.0,1498.0,1207.0,916.0,862.0,484.0,470.0,
     1                       383.0,313.0,229.0,124.0,110.0,-1.0,-1.0,
     1                        50.0,30.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(97,i),i=1,29)/131556.0,25256.0,24371.0,19435.0,
     1                       6545.0,6138.0,4976.0,4353.0,4127.0,
     1                     1748.0,1558.0,1249.0,955.0,898.0,511.0,495.0,
     1                       399.0,326.0,237.0,130.0,117.0,-1.0,-1.0,
     1                       52.0,32.0,16.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(98,i),i=1,29)/134939.0,26010.0,25108.0,19907.0,
     1                       6761.0,6345.0,5116.0,4484.0,4247.0,
     1                     1813.0,1620.0,1292.0,991.0,930.0,538.0,520.0,
     1                       416.0,341.0,245.0,137.0,122.0,-1.0,-1.0,
     1                       54.0,33.0,17.0,-1.0,-1.0,
     1                      -1.0/
                                                                                
      data (exmu(99,i),i=1,29)/-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0,-1.0,-1.0,-1.0,-1.0,
     1                       -1.0/
                                                                                
      data (exmu(100,i),i=1,29) /-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0,-1.0,-1.0,-1.0,-1.0,
     1                          -1.0/
                                                                                

      if(exmu(iz,ihole).gt.0.) emu = exmu(iz,ihole) / hart

      return
      end
