/*
	FATSort, utility for sorting FAT directory structures
	Copyright (C) 2004 Boris Leidner <fatsort(at)formenos.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	This file contains platform dependend macros.
*/

#ifndef __platform_h__
#define __platform_h__

#ifndef __WIN32__
#if defined(linux) || defined(__linux) || defined(__linux__)
#undef __LINUX__
#define __LINUX__	1
#elif defined(__FreeBSD__) || defined(__DragonFly__) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__APPLE__)
#undef __BSD__
#define __BSD__		1
#endif
#endif

#ifdef __WIN32__
#define off_t off64_t

// types defined under Unix but not Windows
typedef unsigned char u_char;
typedef unsigned char u_int8_t;
typedef signed char int8_t;
typedef unsigned short u_int16_t;
typedef unsigned int u_int32_t;
typedef short int int16_t;
typedef int int32_t;
// extra header files needed under Windows
// #include <windows.h>
// #include <winioctl.h>
// #include <ctype.h>
#endif

#endif // __platform_h__
