/*
 * bookinfo - Żҥ֥å/EPWING Ҵɽ
 *
 *	Written by Junn Ohta (ohta@src.ricoh.co.jp). Public Domain.
 */

char	*progname = "bookinfo";
char	*version = "1.0";
char	*date = "1999/01/12";
char	*author = "Junn Ohta (ohta@src.ricoh.co.jp)";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "epw.h"

#define	MEGA		1048576L	/* 1024 * 1024 */
#define	NAME_LEN	28		/* ̻̾ɽ */

int	verbose = FALSE;
long	blkno;
uchr	*bookfile;

int	main();
void	usage();
int	bookinfo();
long	estimate();
int	nonzero();
ulng	val();
uchr	*hexstr();
uchr	*jisstr();
uchr	*idname();
int	idmust();
int	markdel();
uchr	*bktype();
uchr	*protinfo();
uchr	*idxhndl();
uchr	*dspvalid();
uchr	*dsplist();
uchr	*dspstyle();
uchr	*idxinfo();

int
main(ac, av)
int	ac;
char	**av;
{
    int		ret;

    ac--, av++;
    while (ac > 0 && **av == '-') {
	switch (av[0][1]) {
	case 'v':
	case 'V':
	    verbose = TRUE;
	    break;
	case 'd':
	case 'D':
	    if (markdel(&av[0][2]) == ERR)
		usage();
	    break;
	default:
	    usage();
	}
	ac--, av++;
    }
    if (ac < 1 || ac > 2)
	usage();
    bookfile = *av;
    ac--, av++;
    blkno = 1L;
    if (ac == 1)
	blkno = strtol(*av, NULL, 0);

    ret = bookinfo(bookfile, blkno);
    if (ret == ERR)
	exit(1);
    exit(0);
}

void
usage()
{
    fprintf(stderr, "Żҥ֥å/EPWING Ҵɽ");
    fprintf(stderr, " Ver.%s (%s)\n    Written by %s, Public Domain.\n\n",
	version, date, author);
    fprintf(stderr, "ˡ: %s [-v] [-d<IDꥹ>]", progname);
    fprintf(stderr, " <ҥե> [<֥åֹ>]\n\n");
    fprintf(stderr, "ץ:\n");
    fprintf(stderr, "    -v: ʣ縡Ÿɽ\n");
    fprintf(stderr, "    -d: ID򥵥׻ǥȤʤ\n");
    exit(1);
}

int
bookinfo(bookfile, blkno)
char	*bookfile;
long	blkno;
{
    int		i, j, k, must, mark;
    long	size1, size2, cblks;
    uchr	tmp[32], tmp2[32], tmp3[32], tmp4[32];
    INFO_T	*infop;
    ITEM_T	*itemp;
    CINFO_T	*cinfop;
    CENT_T	*centp;
    CITEM_T	*citemp;
    struct stat	st;

    if (open_book(bookfile) == ERR) {
	fprintf(stderr, "%s: %s ץǤޤ\n", progname, bookfile);
	return ERR;
    }
    if ((infop = getinfo(blkno)) == NULL) {
	fprintf(stderr, "%s: Ҵ󤬼Ǥޤ\n", progname);
	return ERR;
    }
    close_book();

    printf("; Żҥ֥å/EPWING Ҵ");
    printf(" (generated by %s v%s)\n\n", progname, version);
    printf("оݽҥե = %s\n", bookfile);
    printf("ߥ֥å = %d\n", blkno);
    printf("ҹǿ = %d\n", infop->items);
    printf("ͽΰ1(Ҽ/ݸ) = %sH\n",
	hexstr(infop->resv1, tmp, RESV1_LEN));
    printf("  Ҽ: %s\n", bktype(infop->resv1));
    printf("  ݸ: %s\n", protinfo(infop->resv1));
    printf("INDEXμ谷ˡ = %02XH (%s)\n",
	infop->idxhndl, idxhndl(infop->idxhndl));
    if (nonzero(infop->resv2, RESV2_LEN))
	printf("ͽΰ2 = %sH\n", hexstr(infop->resv2, tmp, RESV2_LEN));
    printf("\n");

    printf(" ID ̾                              ");
    printf("   Ƭ  INDEX ͽ3/4\n");
    itemp = infop->item;
    for (i = 0; i < infop->items; i++) {
	must = idmust(itemp->itemid);
	mark = must? '*': ' ';
	if (itemp->itemid != ID_CINFO) {
	    /*
	     * ʣ縡ʳ
	     */
	    printf("%c%02X %-*s      %7lu%7lu %-9s %s/%s\n",
		mark, itemp->itemid, NAME_LEN, idname(itemp->itemid),
		itemp->topblk, itemp->blks, idxinfo(itemp),
		hexstr(itemp->resv3, tmp, RESV3_LEN),
		hexstr(itemp->resv4, tmp2, RESV4_LEN));
	    itemp++;
	    continue;
	}
	/*
	 * ʣ縡
	 */
	cblks = itemp->blks;
	cinfop = itemp->cinfo;
	if (verbose) {
	    /*
	     * ʣ縡ܺɽ
	     */
	    printf("%c%02X ʣ %-*s %7lu%7lu %-9s %s/%s\n",
		mark, ID_CINFO, CRESV1_LEN * 2,
		nonzero(cinfop->cresv1, CRESV1_LEN)?
		    hexstr(cinfop->cresv1, tmp, CRESV1_LEN): (uchr *)"",
		itemp->topblk, itemp->blks, idxinfo(itemp),
		hexstr(itemp->resv3, tmp2, RESV3_LEN),
		hexstr(itemp->resv4, tmp3, RESV4_LEN));
	    centp = cinfop->cent;
	    for (j = 0; j < cinfop->cents; j++) {
		printf("  %3s%-*s                            %s\n",
		    (j < cinfop->cents - 1)? "|--": "'--",
		    CNAME_LEN, jisstr(centp->cname, tmp, CNAME_LEN),
		    hexstr(centp->cresv2, tmp2, CRESV2_LEN));
		citemp = centp->citem;
		for (k = 0; k < centp->citems; k++) {
		    printf("  %3s%c%02X %-*s %7lu%7lu           %s/%s\n",
			(j < cinfop->cents - 1)? "|  ": "   ",
			mark, citemp->citemid,
			NAME_LEN, idname(citemp->citemid),
			citemp->ctopblk, citemp->cblks,
			hexstr(citemp->cresv3, tmp, CRESV3_LEN),
			hexstr(citemp->cresv4, tmp2, CRESV4_LEN));
		    cblks += citemp->cblks;
		    citemp++;
		}
		centp++;
	    }
	} else {
	    /*
	     * ʣ縡Ϲץɽ
	     */
	    centp = cinfop->cent;
	    for (j = 0; j < cinfop->cents; j++) {
		citemp = centp->citem;
		for (k = 0; k < centp->citems; k++) {
		    cblks += citemp->cblks;
		    citemp++;
		}
		centp++;
	    }
	    printf("%c%02X %-*s          ***%7lu %-9s %s/%s\n",
		mark, ID_CINFO, NAME_LEN, "ʣ縡",
		cblks, idxinfo(itemp),
		hexstr(itemp->resv3, tmp, RESV3_LEN),
		hexstr(itemp->resv4, tmp2, RESV4_LEN));
	}
	itemp++;
    }
    printf("\n");

    printf("ɽˡν;:\n");
    printf("  ̵ͭե饰 = %02XH (%s)\n",
	infop->dspvalid, dspvalid(infop->dspvalid));
    printf("  ɽɽ = %02XH (%s)\n",
	infop->dsplist, dsplist(infop->dsplist));
    printf("  ʸɽˡ = %02XH (%s)\n",
	infop->dspstyle, dspstyle(infop->dspstyle));
    if (nonzero(infop->resv5, RESV5_LEN))
	printf("  ͽΰ5 = %sH\n", hexstr(infop->resv5, tmp, RESV5_LEN));
    if (nonzero(infop->resv6, RESV6_LEN))
	printf("  ͽΰ6 = %sH\n", hexstr(infop->resv6, tmp, RESV6_LEN));
    printf("\n");

    stat(bookfile, &st);
    size1 = st.st_size;
    size2 = estimate(infop, blkno);
    printf("ҥե륵 = %3ldMB\n", (size1 + MEGA - 1) / MEGA);
    printf("ޡʬΥ = %3ldMB\n", (size2 + MEGA - 1) / MEGA);
    printf("\n");
    freeinfo(infop);
    return OK;
}

/*
 * ׻ѤΥơ֥
 */
typedef	struct slot_t {
    dword	topblk;
    dword	blks;
} SLOT_T;

long
estimate(infop, blkno)
INFO_T	*infop;
long	blkno;
{
    int		i, j, k, m, n, num, must;
    long	blks;
    ITEM_T	*itemp;
    CINFO_T	*cinfop;
    CENT_T	*centp;
    CITEM_T	*citemp;
    SLOT_T	*slot;

    num = 1;
    itemp = infop->item;
    for (i = 0; i < infop->items; i++) {
	must = idmust(itemp->itemid);
	if (!must) {
	    itemp++;
	    continue;
	}
	num++;
	if (itemp->itemid != ID_CINFO) {
	    itemp++;
	    continue;
	}
	cinfop = itemp->cinfo;
	centp = cinfop->cent;
	for (j = 0; j < cinfop->cents; j++) {
	    citemp = centp->citem;
	    for (k = 0; k < centp->citems; k++) {
		num++;
		citemp++;
	    }
	    centp++;
	}
	itemp++;
    }

    slot = (SLOT_T *)malloc(sizeof(SLOT_T) * num);
    if (slot == NULL)
	return 0L;
    slot[0].topblk = blkno;
    slot[0].blks = 1L;
    n = 1;
    itemp = infop->item;
    for (i = 0; i < infop->items; i++) {
	must = idmust(itemp->itemid);
	if (!must) {
	    itemp++;
	    continue;
	}
	for (m = 0; m < n; m++) {
	    if (slot[m].topblk == itemp->topblk)
		break;
	}
	if (m == n) {
	    slot[n].topblk = itemp->topblk;
	    slot[n].blks = itemp->blks;
	    n++;
	}
	if (itemp->itemid != ID_CINFO) {
	    itemp++;
	    continue;
	}
	cinfop = itemp->cinfo;
	centp = cinfop->cent;
	for (j = 0; j < cinfop->cents; j++) {
	    citemp = centp->citem;
	    for (k = 0; k < centp->citems; k++) {
		for (m = 0; m < n; m++) {
		    if (slot[m].topblk == citemp->ctopblk)
			break;
		}
		if (m == n) {
		    slot[n].topblk = citemp->ctopblk;
		    slot[n].blks = citemp->cblks;
		    n++;
		}
		citemp++;
	    }
	    centp++;
	}
	itemp++;
    }

    blks = 0L;
    for (m = 0; m < n; m++)
	blks += slot[m].blks;
    free((char *)slot);
    return blks * BLKSIZ;
}

int
nonzero(p, len)
uchr	*p;
int	len;
{
    while (len--)
	if (*p++)
	    return TRUE;
    return FALSE;
}

ulng
val(str, len)
uchr	*str;
int	len;
{
    ulng	l;

    l = 0L;
    while (len--)
	l = (l << 8) + *str++;
    return l;
}

uchr *
hexstr(hex, buf, len)
uchr	*hex, *buf;
int	len;
{
    uchr	*p;

    p = buf;
    while (len--) {
	*p++ = "0123456789ABCDEF"[*hex >> 4];
	*p++ = "0123456789ABCDEF"[*hex & 0x0f];
	hex++;
    }
    *p = '\0';
    return buf;
}

uchr *
jisstr(p, buf, len)
uchr	*p, *buf;
int	len;
{
    int		c1, c2;
    uchr	*pend, *q;

    pend = p + len;
    while (pend >= p + 2 &&
	(pend[-1] == '\0' && pend[-2] == '\0' ||
	 pend[-1] == 0x21 && pend[-2] == 0x21))
	pend -= 2;
    q = buf;
#ifdef EUC
    while (p < pend)
	*q++ = (*p++ | 0x80);
#endif
#ifdef SJIS
    while (p < pend) {
	c1 = *p++;
	c2 = *p++;
	if (c1 & 0x01) {
	    c2 += 0x1f;
	    if (c2 > 0x7e)
		c2++;
	} else {
	    c2 += 0x7e;
	}
	c1 = (c1 + 0xe1) >> 1;
	if (c1 > 0x9f)
	    c1 += 0x40;
	*q++ = c1;
	*q++ = c2;
    }
#endif
    *q = '\0';
    return buf;
}

/*
 * ҹǼ̻ɽ
 */
typedef struct itype_t {
    byte	idmin;
    byte	idmax;
    int		must;
    uchr	*name;
} ITYPE_T;

ITYPE_T	itypetbl[] = {
    { 0x00, 0x00, TRUE,  "ʸ"				},
    { 0x01, 0x01, TRUE,  "˥塼"			},
    { 0x02, 0x02, TRUE,  "ɽ"			},
    { 0x03, 0x03, FALSE, "︡Ф"		},
    { 0x04, 0x04, TRUE,  "פʸФ"		},
    { 0x05, 0x05, TRUE,  "ɽФ"		},
    { 0x06, 0x06, TRUE,  "פʸФ"		},
    { 0x07, 0x07, TRUE,  "ɽФ"		},
    { 0x08, 0x08, TRUE,  "ױѻФ"		},
    { 0x09, 0x09, TRUE,  "ױѻФ"		},
    { 0x0a, 0x0a, FALSE, "Ф"		},
    { 0x0b, 0x0b, FALSE, "ֹ渫Ф"		},
    { 0x0d, 0x0d, FALSE, "̾︡Ф"		},
    { 0x0f, 0x0f, FALSE, "ǸФ"			},
    { 0x20, 0x20, FALSE, "˥塼"			},
    { 0x21, 0x21, FALSE, "ɽ"			},
    { 0x23, 0x23, FALSE, "ɽ(1ɽ)"	},
    { 0x24, 0x24, FALSE, "Ф"			},
    { 0x30, 0x30, FALSE, "ʥǥå"		},
    { 0x40, 0x40, FALSE, "ѻǥå"		},
    { 0x50, 0x50, FALSE, "ǥå"		},
    { 0x60, 0x60, FALSE, "ɽǥå"		},
    { 0x70, 0x70, TRUE,  "פʥǥå"	},
    { 0x71, 0x71, TRUE,  "ɽǥå"	},
    { 0x72, 0x72, TRUE,  "ױѻǥå"	},
    { 0x80, 0x80, FALSE, "︡ǥå"		},
    { 0x81, 0x81, FALSE, "ǥå"	},
    { 0x90, 0x90, TRUE,  "פʥǥå"	},
    { 0x91, 0x91, TRUE,  "ɽǥå"	},
    { 0x92, 0x92, TRUE,  "ױѻǥå"	},
    { 0xa0, 0xa0, FALSE, "ֹ楤ǥå"		},
    { 0xa1, 0xa1, FALSE, "̾︡ǥå"	},
    { 0xb0, 0xb0, FALSE, "ڡǥå"	},
    { 0xb1, 0xb1, FALSE, "ǥå"		},
    { 0xd0, 0xd0, FALSE, "Υ"			},
    { 0xd1, 0xd1, FALSE, "ĥΥ"		},
    { 0xd2, 0xd2, FALSE, "顼"			},
    { 0xd8, 0xd8, FALSE, "PCM"			},
    { 0xe0, 0xe0, FALSE, ""			},
    { 0xf0, 0xf0, FALSE, "ž"				},
    { 0xf1, 0xf1, TRUE,  "(1616ɥå)"		},
    { 0xf2, 0xf2, TRUE,  "(816ɥå)"		},
    { 0xf3, 0xf3, TRUE,  "(2424ɥå)"		},
    { 0xf4, 0xf4, TRUE,  "(1224ɥå)"		},
    { 0xf5, 0xf5, TRUE,  "(3030ɥå)"		},
    { 0xf6, 0xf6, TRUE,  "(1530ɥå)"		},
    { 0xf7, 0xf7, TRUE,  "(4848ɥå)"		},
    { 0xf8, 0xf8, TRUE,  "(2448ɥå)"		},
    { 0xff, 0xff, FALSE, "ʣ縡"		},
    { 0x00, 0x2f, FALSE, "¾Υƥȥǡ"	},
    { 0x70, 0x7f, FALSE, "¾θץǥå"	},
    { 0x80, 0x8f, FALSE, "¾ξ︡ǥå"	},
    { 0x90, 0x9f, FALSE, "¾ץǥå"	},
    { 0xa0, 0xbf, FALSE, "¾Υǥå"		},
    { 0xd0, 0xdf, FALSE, "¾Υޥǥǡ"	}
};

uchr *
idname(id)
int	id;
{
    int		i, n;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++) {
	if (id >= itypetbl[i].idmin && id <= itypetbl[i].idmax)
	    return itypetbl[i].name;
    }
    return "???";
}

int
idmust(id)
int	id;
{
    int		i, n;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++) {
	if (id >= itypetbl[i].idmin && id <= itypetbl[i].idmax)
	    return itypetbl[i].must;
    }
    return FALSE;
}

int
markdel(str)
uchr	*str;
{
    int		i, n;
    int		dmin, dmax;

    n = sizeof(itypetbl) / sizeof(itypetbl[0]);
    for (i = 0; i < n; i++)
	itypetbl[i].must = TRUE;
    while (*str) {
	dmin = dmax = hex(str);
	if (dmin < 0)
	    return ERR;
	str += 2;
	if (*str == '-') {
	    str++;
	    dmax = hex(str);
	    if (dmax < 0)
		return ERR;
	    str += 2;
	}
	for (i = 0; i < n; i++) {
	    if (dmax >= itypetbl[i].idmin && dmin <= itypetbl[i].idmax)
		itypetbl[i].must = FALSE;
	}
	if (*str == ',')
	    str++;
    }
    return OK;
}

uchr *
bktype(str)
uchr	*str;
{
    switch (*str & 0xf0) {
    case 0x00: return "켭ŵ"; 
    case 0x10: return "¼ŵ"; 
    case 0x20: return "¼ŵ"; 
    case 0x30: return "±Ѽŵ"; 
    case 0x40: return "Ѹ켭ŵ"; 
    case 0x50: return "ɴʻŵ"; 
    case 0x60: return "̽ʪ"; 
    case 0x70: return "켭ŵ"; 
    default:   return "";
    }
}

uchr *
protinfo(str)
uchr	*str;
{
    static uchr	buf[160];

    strcpy(buf, "ɽ");
    strcat(buf, (str[1] & 0x01)? "ػ": "");
    strcat(buf, ", ");
    strcat(buf, (str[1] & 0x02)? "ػ": "");
    strcat(buf, ", ƥȰ");
    strcat(buf, (str[1] & 0x04)? "ػ": "");
    strcat(buf, ", ǰ");
    strcat(buf, (str[1] & 0x08)? "ػ": "");
    strcat(buf, ",\n            顼ǰ");
    strcat(buf, (str[1] & 0x10)? "" :"ػ");
    strcat(buf, ", ư");
    strcat(buf, (str[1] & 0x20)? "" :"ػ");
    strcat(buf, ", ̰");
    strcat(buf, (str[1] & 0x80)? "" :"ػ");
    return buf;
}

int
hex(s)
uchr	*s;
{
    int		n;

    if (!isxdigit(s[0]) || !isxdigit(s[1]))
	return -1;
    if (s[0] >= '0' && s[0] <= '9')
	n = s[0] - '0';
    else if (s[0] >= 'A' && s[0] <= 'F')
	n = s[0] - 'A' + 10;
    else if (s[0] >= 'a' && s[0] <= 'f')
	n = s[0] - 'a' + 10;
    n <<= 4;
    if (s[1] >= '0' && s[1] <= '9')
	n += s[1] - '0';
    else if (s[1] >= 'A' && s[1] <= 'F')
	n += s[1] - 'A' + 10;
    else if (s[1] >= 'a' && s[1] <= 'f')
	n += s[1] - 'a' + 10;
    return n;
}

uchr *
idxhndl(n)
int	n;
{
    switch (n) {
    case 0x00: return "INDEXͭ˰¸";
    case 0x01: return "INDEX̵";
    case 0x02: return "INDEXͭ";
    }
    return "";
}

uchr *
dspvalid(n)
int	n;
{
    switch (n) {
    case 0x00: return ";̵";
    case 0x01: return ";ͭ";
    }
    return "";
}

uchr *
dsplist(n)
int	n;
{
    switch (n) {
    case 0x00: return "ľʸɽ";
    case 0x01: return "ɽɽؼɽ";
    }
    return "";
}

uchr *
dspstyle(n)
int	n;
{
    switch (n) {
    case 0x00: return "̤ñ̤Ϣ³ɽ";
    case 0x01: return "̤Ƭʸɽ";
    }
    return "";
}

/*
 * ǥåʬΥǡɽˡ
 */
#define	I_KATA_MASK	0x00c00000L	/* 			*/
#define	 I_KATA_HIRA	0x00000000L	/*   Ҥ餬ʤѴƵϿ(k)	*/
#define	 I_KATA_ASIS	0x00400000L	/*   Τޤ޵Ͽ(.)		*/
#define	I_LCASE_MASK	0x00300000L	/* Ѿʸ			*/
#define	 I_LCASE_UCASE	0x00000000L	/*   ʸѴƵϿ(a)	*/
#define	 I_LCASE_ASIS	0x00100000L	/*   Τޤ޵Ͽ(.)		*/
#define	I_SYM_MASK	0x000c0000L	/* 				*/
#define	 I_SYM_DEL	0x00000000L	/*   ƵϿ(s)	*/
#define	 I_SIM_ASIS	0x00040000L	/*   Τޤ޵Ͽ(.)		*/
#define	I_CHOU_MASK	0x00030000L	/* Ĺ				*/
#define	 I_CHOU_BOIN	0x00000000L	/*   ľ첻ѴƵϿ(c)*/
#define	 I_CHOU_ASIS	0x00010000L	/*   Τޤ޵Ͽ(.)		*/
#define	 I_CHOU_DEL	0x00020000L	/*   ĹƵϿ(C)	*/
#define	I_SOKU_MASK	0x0000c000L	/* ¥				*/
#define	 I_SOKU_LARGE	0x00000000L	/*   礭ʸѴƵϿ(t)*/
#define	 I_SOKU_ASIS	0x00004000L	/*   Τޤ޵Ͽ(.)		*/
#define	I_YOU_MASK	0x00003000L	/* ٹ				*/
#define	 I_YOU_LARGE	0x00000000L	/*   礭ʸѴƵϿ(y)*/
#define	 I_YOU_ASIS	0x00001000L	/*   Τޤ޵Ͽ(.)		*/
#define	I_GAI_MASK	0x00000c00L	/* Ѿʸ		*/
#define	 I_GAI_LARGE	0x00000000L	/*   礭ʸѴƵϿ(g)*/
#define	 I_GAI_ASIS	0x00000400L	/*   Τޤ޵Ͽ(.)		*/
#define	I_DAKU_MASK	0x00000300L	/* 				*/
#define	 I_DAKU_SEI	0x00000000L	/*   ѴƵϿ(d)	*/
#define	 I_DAKU_ASIS	0x00000100L	/*   Τޤ޵Ͽ(.)		*/
#define	I_HAN_MASK	0x000000c0L	/* Ⱦ			*/
#define	 I_HAN_SEI	0x00000000L	/*   ѴƵϿ(h)	*/
#define	 I_HAN_ASIS	0x00000040L	/*   Τޤ޵Ͽ(.)		*/
#define	I_RESV_MASK	0x0000003fL	/* ͽΰ			*/

uchr *
idxinfo(item)
ITEM_T	*item;
{
    dword	d;
    static uchr	buf[10];

    if (item->idxvalid == 0x01)
	return "";
    d = item->idxinfo;
    buf[0] = ((d & I_KATA_MASK ) == I_KATA_HIRA  )? 'k': '.';
    buf[1] = ((d & I_LCASE_MASK) == I_LCASE_UCASE)? 'a': '.';
    buf[2] = ((d & I_SYM_MASK  ) == I_SYM_DEL    )? 's': '.';
    buf[3] = ((d & I_CHOU_MASK ) == I_CHOU_BOIN  )? 'c':
	     ((d & I_CHOU_MASK ) == I_CHOU_DEL   )? 'C': '.';
    buf[4] = ((d & I_SOKU_MASK ) == I_SOKU_LARGE )? 't': '.';
    buf[5] = ((d & I_YOU_MASK  ) == I_YOU_LARGE  )? 'y': '.';
    buf[6] = ((d & I_GAI_MASK  ) == I_GAI_LARGE  )? 'g': '.';
    buf[7] = ((d & I_DAKU_MASK ) == I_DAKU_SEI   )? 'd': '.';
    buf[8] = ((d & I_HAN_MASK  ) == I_HAN_SEI    )? 'h': '.';
    buf[9] = '\0';
    return buf;
}
