/*
 * MIT License
 *
 * Copyright 2017 Broad Institute
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.broadinstitute.dropseqrna.barnyard;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Log;

public class Utils {
	private static Log log = Log.getInstance(Utils.class);	
	private static String DEFAULT_CELL_BARCODE="DEFAULT";

	public static SAMRecord getClone (final SAMRecord r) {
		SAMRecord rr=null;
		try {
			rr = (SAMRecord) r.clone();
		} catch (CloneNotSupportedException e) {
			log.info("This should never happen.  SAMRecord can't be cloned?");
		}
		return (rr);
	}

	public static String getCellBC (final SAMRecord r, final String cellBCTag) {
		String currentCell = r.getStringAttribute(cellBCTag);
		if (currentCell==null) return (DEFAULT_CELL_BARCODE);
		return (currentCell);
	}

	public static String negativeStrandToString(final boolean readNegativeStrand) {
		if (readNegativeStrand) return "-";
		return "+";
	}

	public static String positiveStrandToString(final boolean readPositiveStrand) {
		if (readPositiveStrand) return "+";
		return "-";
	}
}
