﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Windows.Forms;

/// <summary>
///  Specifies the angle of screen orientation
/// </summary>
public enum ScreenOrientation
{
    /// <summary>
    ///  The screen is oriented at 0 degrees
    /// </summary>
    Angle0 = 0,

    /// <summary>
    ///  The screen is oriented at 90 degrees
    /// </summary>
    Angle90 = 1,

    /// <summary>
    ///  The screen is oriented at 180 degrees.
    /// </summary>
    Angle180 = 2,

    /// <summary>
    ///  The screen is oriented at 270 degrees.
    /// </summary>
    Angle270 = 3,
}
