
#ifndef UTIL_DEF_H
#define UTIL_DEF_H

namespace Util {
  // Adobe's PDF Reference 1.7, sect. 3.4, reads, "However, to increase
  // compatibility with other applications that process PDF files, lines
  // that are not part of stream object data are limited to no more
  // than 255 characters, with one exception."  Whether any modern PDF
  // readers actually enforce the limit, this programmer does not know;
  // but in the PDF source text the present software writes, PDF strings
  // probably pose the main overrun hazard.  The next parameter limits
  // the these PDF strings' lengths.
  const int max_pdf_string_length = 0xc0; // -1 for no limit
}

#endif

