# coding: utf-8

"""
    Debian Code Search

    OpenAPI for https://codesearch.debian.net/  # noqa: E501

    OpenAPI spec version: 1.4.0
    Contact: stapelberg@debian.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from debian_codesearch_client.swagger_client.api_client import ApiClient


class SearchApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def search(self, query, **kwargs):  # noqa: E501
        """Searches through source code  # noqa: E501

        Performs a search through the full Debian Code Search corpus, blocking until all results are available (might take a few seconds depending on the search query).  Search results are ordered by their ranking (best results come first).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The search query, for example `who knows...` (literal) or `who knows\\.\\.\\.` (regular expression). See https://codesearch.debian.net/faq for more details about which keywords are supported. The regular expression flavor is RE2, see https://github.com/google/re2/blob/master/doc/syntax.txt (required)
        :param str match_mode: Whether the query is to be interpreted as a literal (`literal`) instead of as an RE2 regular expression (`regexp`). Literal searches are faster and do not require escaping special characters, regular expression searches are more powerful.
        :return: list[SearchResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.search_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, query, **kwargs):  # noqa: E501
        """Searches through source code  # noqa: E501

        Performs a search through the full Debian Code Search corpus, blocking until all results are available (might take a few seconds depending on the search query).  Search results are ordered by their ranking (best results come first).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The search query, for example `who knows...` (literal) or `who knows\\.\\.\\.` (regular expression). See https://codesearch.debian.net/faq for more details about which keywords are supported. The regular expression flavor is RE2, see https://github.com/google/re2/blob/master/doc/syntax.txt (required)
        :param str match_mode: Whether the query is to be interpreted as a literal (`literal`) instead of as an RE2 regular expression (`regexp`). Literal searches are faster and do not require escaping special characters, regular expression searches are more powerful.
        :return: list[SearchResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["query", "match_mode"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method search" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'query' is set
        if self.api_client.client_side_validation and (
            "query" not in params or params["query"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `query` when calling `search`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "query" in params:
            query_params.append(("query", params["query"]))  # noqa: E501
        if "match_mode" in params:
            query_params.append(("match_mode", params["match_mode"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api_key"]  # noqa: E501

        return self.api_client.call_api(
            "/search",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[SearchResult]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def searchperpackage(self, query, **kwargs):  # noqa: E501
        """Like /search, but aggregates per package  # noqa: E501

        The search results are currently sorted arbitrarily, but we intend to sort them by ranking eventually: https://github.com/Debian/dcs/blob/51338e934eb7ee18d00c5c18531c0790a83cb698/cmd/dcs-web/querymanager.go#L719  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.searchperpackage(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The search query, for example `who knows...` (literal) or `who knows\\.\\.\\.` (regular expression). See https://codesearch.debian.net/faq for more details about which keywords are supported. The regular expression flavor is RE2, see https://github.com/google/re2/blob/master/doc/syntax.txt (required)
        :param str match_mode: Whether the query is to be interpreted as a literal (`literal`) instead of as an RE2 regular expression (`regexp`). Literal searches are faster and do not require escaping special characters, regular expression searches are more powerful.
        :return: list[PackageSearchResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.searchperpackage_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.searchperpackage_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def searchperpackage_with_http_info(self, query, **kwargs):  # noqa: E501
        """Like /search, but aggregates per package  # noqa: E501

        The search results are currently sorted arbitrarily, but we intend to sort them by ranking eventually: https://github.com/Debian/dcs/blob/51338e934eb7ee18d00c5c18531c0790a83cb698/cmd/dcs-web/querymanager.go#L719  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.searchperpackage_with_http_info(query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query: The search query, for example `who knows...` (literal) or `who knows\\.\\.\\.` (regular expression). See https://codesearch.debian.net/faq for more details about which keywords are supported. The regular expression flavor is RE2, see https://github.com/google/re2/blob/master/doc/syntax.txt (required)
        :param str match_mode: Whether the query is to be interpreted as a literal (`literal`) instead of as an RE2 regular expression (`regexp`). Literal searches are faster and do not require escaping special characters, regular expression searches are more powerful.
        :return: list[PackageSearchResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["query", "match_mode"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method searchperpackage" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'query' is set
        if self.api_client.client_side_validation and (
            "query" not in params or params["query"] is None
        ):  # noqa: E501
            raise ValueError(
                "Missing the required parameter `query` when calling `searchperpackage`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "query" in params:
            query_params.append(("query", params["query"]))  # noqa: E501
        if "match_mode" in params:
            query_params.append(("match_mode", params["match_mode"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["api_key"]  # noqa: E501

        return self.api_client.call_api(
            "/searchperpackage",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[PackageSearchResult]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
