pragma Ada_2005;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with System;
with Interfaces.C.Strings;
limited with dbus_errors_h;
with dbus_types_h;
with dbus_memory_h;
with dbus_connection_h;
with dbus_arch_deps_h;

package dbus_server_h is

   --  skipped empty struct DBusServer

   type DBusNewConnectionFunction is access procedure
        (arg1 : System.Address;
         arg2 : System.Address;
         arg3 : System.Address);
   pragma Convention (C, DBusNewConnectionFunction);  -- ../dbus/dbus-server.h:47

   function dbus_server_listen (address : Interfaces.C.Strings.chars_ptr; error : access dbus_errors_h.DBusError) return System.Address;  -- ../dbus/dbus-server.h:52
   pragma Import (C, dbus_server_listen, "dbus_server_listen");

   function dbus_server_ref (server : System.Address) return System.Address;  -- ../dbus/dbus-server.h:55
   pragma Import (C, dbus_server_ref, "dbus_server_ref");

   procedure dbus_server_unref (server : System.Address);  -- ../dbus/dbus-server.h:57
   pragma Import (C, dbus_server_unref, "dbus_server_unref");

   procedure dbus_server_disconnect (server : System.Address);  -- ../dbus/dbus-server.h:59
   pragma Import (C, dbus_server_disconnect, "dbus_server_disconnect");

   function dbus_server_get_is_connected (server : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:61
   pragma Import (C, dbus_server_get_is_connected, "dbus_server_get_is_connected");

   function dbus_server_get_address (server : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-server.h:63
   pragma Import (C, dbus_server_get_address, "dbus_server_get_address");

   function dbus_server_get_id (server : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-server.h:65
   pragma Import (C, dbus_server_get_id, "dbus_server_get_id");

   procedure dbus_server_set_new_connection_function
     (server : System.Address;
      c_function : DBusNewConnectionFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction);  -- ../dbus/dbus-server.h:67
   pragma Import (C, dbus_server_set_new_connection_function, "dbus_server_set_new_connection_function");

   function dbus_server_set_watch_functions
     (server : System.Address;
      add_function : dbus_connection_h.DBusAddWatchFunction;
      remove_function : dbus_connection_h.DBusRemoveWatchFunction;
      toggled_function : dbus_connection_h.DBusWatchToggledFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:72
   pragma Import (C, dbus_server_set_watch_functions, "dbus_server_set_watch_functions");

   function dbus_server_set_timeout_functions
     (server : System.Address;
      add_function : dbus_connection_h.DBusAddTimeoutFunction;
      remove_function : dbus_connection_h.DBusRemoveTimeoutFunction;
      toggled_function : dbus_connection_h.DBusTimeoutToggledFunction;
      data : System.Address;
      free_data_function : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:79
   pragma Import (C, dbus_server_set_timeout_functions, "dbus_server_set_timeout_functions");

   function dbus_server_set_auth_mechanisms (server : System.Address; mechanisms : System.Address) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:86
   pragma Import (C, dbus_server_set_auth_mechanisms, "dbus_server_set_auth_mechanisms");

   function dbus_server_allocate_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:90
   pragma Import (C, dbus_server_allocate_data_slot, "dbus_server_allocate_data_slot");

   procedure dbus_server_free_data_slot (slot_p : access dbus_arch_deps_h.dbus_int32_t);  -- ../dbus/dbus-server.h:92
   pragma Import (C, dbus_server_free_data_slot, "dbus_server_free_data_slot");

   function dbus_server_set_data
     (server : System.Address;
      slot : int;
      data : System.Address;
      free_data_func : dbus_memory_h.DBusFreeFunction) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-server.h:94
   pragma Import (C, dbus_server_set_data, "dbus_server_set_data");

   function dbus_server_get_data (server : System.Address; slot : int) return System.Address;  -- ../dbus/dbus-server.h:99
   pragma Import (C, dbus_server_get_data, "dbus_server_get_data");

end dbus_server_h;
