% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-create.R
\name{sqlCreateTable}
\alias{sqlCreateTable}
\title{Compose query to create a simple table}
\usage{
sqlCreateTable(con, table, fields, row.names = NA, temporary = FALSE, ...)
}
\arguments{
\item{con}{A database connection.}

\item{table}{Name of the table. Escaped with
\code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.}

\item{fields}{Either a character vector or a data frame.

A named character vector: Names are column names, values are types.
Names are escaped with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}.
Field types are unescaped.

A data frame: field types are generated using
\code{\link[=dbDataType]{dbDataType()}}.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{temporary}{If \code{TRUE}, will generate a temporary table statement.}

\item{...}{Other arguments used by individual methods.}
}
\description{
Exposes an interface to simple \verb{CREATE TABLE} commands. The default
method is ANSI SQL 99 compliant.
This method is mostly useful for backend implementers.
}
\details{
The \code{row.names} argument must be passed explicitly in order to avoid
a compatibility warning.  The default will be changed in a later release.
}
\examples{
sqlCreateTable(ANSI(), "my-table", c(a = "integer", b = "text"))
sqlCreateTable(ANSI(), "my-table", iris)

# By default, character row names are converted to a row_names colum
sqlCreateTable(ANSI(), "mtcars", mtcars[, 1:5])
sqlCreateTable(ANSI(), "mtcars", mtcars[, 1:5], row.names = FALSE)
}
