/*
 *  dancer-XML parser
 *  Copyright (C) 2000,2002 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/* loadxml test routine ...
 *
 * 8 sep MM started 
 * copyright 2000 Junichi Uekawa
 */

#include <stdio.h>
#include "dancer-xml.h"

static void
space(int i)
{
  while (i--)
    printf(" ");  
}

static void
recurse_attribute(dxml_attribute * a )
{
  printf(" %s=\"%s\"", a->attribute_name, a->attribute_data);
  if (a->next) 
    recurse_attribute(a->next);  
}

static void
recurse_element(dxml_element * e, int level)
{
  if (e->element_type == element_type_element)
    {
      space(level);
      printf("<%s", e->element_name);
      if (e->element_attribute) 
	recurse_attribute(e->element_attribute);      
      printf(">\n");      
      if (e->child) 
	recurse_element (e->child, level+1);
      space(level);printf("</%s>\n", e->element_name);      
    }
  else
    {
      space(level);      
      printf("%s\n", e->element_name);
    }
  if (e->next) recurse_element(e->next, level);  
}

int
main(int argc, char ** argv)
{
  dxml_element * tmp ;
  
  printf("<?xml version=\"1.0\"?>\n");
  tmp = dxml_read_xml(stdin);
  if (tmp)
    recurse_element (tmp, 0);
  else
    {
      printf ("Something wicked happened!\n");
      return 1;
    }

  return 0;  
}

