#include <stddef.h>
#include <stdio.h>
#include <time.h>
#include <string>
#include <vector>

#include "accesslog.h"
#include "client.h"
#include "log.h"
#include "mutexlock.h"

using namespace std;

AccessLogThread::AccessLogThread()
{
	pthread_mutex_init(&mutex, NULL);
}

AccessLogThread::AccessLogThread(const string &filename)
	: filename(filename) {
	pthread_mutex_init(&mutex, NULL);
}

void AccessLogThread::write(const ClientStats& client)
{
	{
		MutexLock lock(&mutex);
		pending_writes.push_back(client);
	}
	wakeup();
}

void AccessLogThread::do_work()
{
	// Open the file.
	if (filename.empty()) {
		logfp = NULL;
	} else {
		logfp = fopen(filename.c_str(), "a+");
		if (logfp == NULL) {
			log_perror(filename.c_str());
			// Continue as before.
		}
	}

	while (!should_stop()) {
		// Empty the queue.
		vector<ClientStats> writes;
		{
			MutexLock lock(&mutex);
			swap(pending_writes, writes);
		}

		if (logfp != NULL) {
			// Do the actual writes.
			time_t now = time(NULL);
			for (size_t i = 0; i < writes.size(); ++i) {
				fprintf(logfp, "%llu %s %s %d %llu %llu %llu\n",
					(long long unsigned)(writes[i].connect_time),
					writes[i].remote_addr.c_str(),
					writes[i].url.c_str(),
					int(now - writes[i].connect_time),
					(long long unsigned)(writes[i].bytes_sent),
					(long long unsigned)(writes[i].bytes_lost),
					(long long unsigned)(writes[i].num_loss_events));
			}
			fflush(logfp);
		}

		// Wait until we are being woken up, either to quit or because
		// there is material in pending_writes.
		wait_for_wakeup(NULL);
	}

	if (logfp != NULL) {	
		if (fclose(logfp) == EOF) {
			log_perror("fclose");
		}
	}

	logfp = NULL;
}
