#include "netbuffer"

bool Netbuffer::insertat(unsigned index, char const *s, unsigned len) {
    PROFILE("Netbuffer::insertat");
    debugmsg(Mstr("Netbuffer: inserting ") + Mstr(s) + Mstr(" at ") +
	     Mstr(index) + "\n");

    if (!len)
	len = strlen(s);

    if (index >= buf_sz)
	return false;
    check_space(len);
    memmove (buf_data + index + len, buf_data + index, buf_sz - index);
    memcpy (buf_data + index, s, len);
    buf_sz += len;
    
    return true;
}
    
