/* $Id: hdrl_image_math.h,v 1.2 2013-10-16 16:52:20 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 16:52:20 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_IMAGE_MATH_H
#define HDRL_IMAGE_MATH_H
#include "hdrl_image.h"
#include <cpl.h>

CPL_BEGIN_DECLS

hdrl_image *hdrl_image_power_create(const hdrl_image *self,const double exponent);
cpl_error_code hdrl_image_power(hdrl_image *self,const double exponent);
cpl_error_code hdrl_image_get_sqsum(const hdrl_image *self,double *result,double *error);
cpl_error_code hdrl_image_get_sum(const hdrl_image *self,double *result,double *error);
double hdrl_image_get_stdev(const hdrl_image *self);
cpl_error_code hdrl_image_get_median(const hdrl_image *self,double *result,double *error);
cpl_error_code hdrl_image_get_mean(const hdrl_image *self,double *result,double *error);
cpl_error_code hdrl_image_div_scalar(hdrl_image *self,double value,double error);
hdrl_image *hdrl_image_div_image_create(const hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_div_image(hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_mul_scalar(hdrl_image *self,double value,double error);
hdrl_image *hdrl_image_mul_image_create(const hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_mul_image(hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_sub_scalar(hdrl_image *self,double value,double error);
hdrl_image *hdrl_image_sub_image_create(const hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_sub_image(hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_add_scalar(hdrl_image *self,double value,double error);
hdrl_image *hdrl_image_add_image_create(const hdrl_image *self,const hdrl_image *other);
cpl_error_code hdrl_image_add_image(hdrl_image *self,const hdrl_image *other);
CPL_END_DECLS

#endif
