.\" Copyright 2016 by Medical Research Council
.\"
.\" %%%LICENSE_START(GPLv3+_DOC_FULL)
.\" This is free documentation; you can redistribute it and/or
.\" modify it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 3 of
.\" the License, or (at your option) any later version.
.\"
.\" The GNU General Public License's references to "object code"
.\" and "executables" are to be interpreted as the output of any
.\" document formatting or typesetting system, including
.\" intermediate and printed output.
.\"
.\" This manual is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public
.\" License along with this manual; if not, see
.\" <http://www.gnu.org/licenses/>.
.\" %%%LICENSE_END

.TH COOT 1

.SH NAME
coot \- macromolecular modeling

.SH SYNOPSIS

.B coot
.br
.B [\-\-coords|--pdb|--xyzin
.I <coordinates-file-name>
.B ]
.br
.B [\-\-map 
.I <CCP4-format-map-file-name>
.B ]
.br
.B [\-\-data|--hklin
.I <mtz-file-name>
.B ]
.br
.B [\-\-auto   
.I <mtz-file-name>
.B ]
.br
.B [\-\-script
.I <python/scheme script file-name>
.B ]
.br
.B [\-\-dictionary 
.I <mmCIF/pdbx dictionary file-name>
.B ]
.br
.B [\-\-code  
.I <wwPDB accession-code>
.B ]
.br
.B [\-\-comp_id|--comp-id
.I <wwPDB comp-id>
.B ]
.br
.B [\-\-splash\-screen
.I <alternate splash screen>
.B ]
.br
.B [\-\-help]     
.br
.B [\-\-python]
.br
.B [\-\-no\-state\-script]
.br
.B [\-\-no\-startup\-scripts]
.br
.B [\-\-no\-graphics]
.br
.B [\-\-no\-splash\-screen]
.br
.B [\-\-version]
.br
.B [\-\-version\-full]
.br
.B [\-\-no\-guano]
.br
.B [\-\-self\-test]

.SH DESCRIPTION
 
   Coot is a molecular graphics applications for modeling and
   valiation. Although one can load files using the command line -
   typical operations would involve loading files using menu items in
   the File menu.

   Coot is particularly useful in the modeling of proteins and ligands
   in reference to x-ray data.

.SH OPTIONS

.B \-\-coords|--pdb|--xyzin
.I <coordinates-file-name>

.B \-\-map 
.I <CCP4-format-map-file-name>

.B \-\-data|--hklin
.I <mtz-file-name>

.B \-\-auto   
.I <mtz-file-name>
Try to automatically read the data in the given mtz file, don't allow the user to select the columns

.B \-\-script
.I <python/scheme script file-name>

.B \-\-ccp4\-project 
.I <directory-name>

.B \-\-dictionary 
.I <mmCIF/pdbx dictionary file-name>

.B \-\-code  
.I <wwPDB accession-code>

.B \-\-comp_id|--comp-id
.I <wwPDB comp-id>

.B \-\-title  
.I title    
   the graphics window starts with this text

.B \-\-port
.I port     

.B \-\-hostname|--host
.I hostname  

.B \-\-splash\-screen 
.I <alternate splash screen>

.B \-\-help print command line options

.B \-\-em start in E.M.m mode.  This affects the default map radius

.B \-\-python use python on the command line (needs
.B --no-graphics
)

.B \-\-no\-state\-script  
don't read the state file on start up

.B \-\-no\-startup\-scripts 
don't read any files on startup

.B \-\-no\-graphics  
use the command line    

.B \-\-no\-splash\-screen
no splash screen at start

.B \-\-stereo  
start in stereo graphics mode

.B \-\-side\-by\-side start
in side-by-side stereo graphics mode    

.B \-\-zalman\-stereo
start in Zalman-stereo graphics mode   

.B \-\-version Print version information

.B \-\-version\-full Print version and binary type information

.B  \-\-no\-guano
don't write files on exit

.B \-\-small\-screen 
start with small screen

.B \-\-self\-test run the self test


.SH AUTHOR

Paul Emsley, Kevin Cowtan, Bernhard Lohkamp
