---
layout: post
title:  "GTK4 Coot Update"
date: Wed 9 Aug 15:51:04 BST 2023
---


Last year I decided to rework the interface to _Coot_ once more - so that it uses GTK4 (emphasis on the "4") as gui toolkit.

This was primarily done so that _Coot_ could be/would be distributed by CCP4. It was another long-term rather mundane exercise including the problem that much of _Coot_'s interactive analysis had been using GooCanvas, and GooCanvas is not available with GTK4.

(Obviously, the more time I spend on re-working the GUI, the less time I have to spend on improving the model-building, validation and analysis tools of _Coot_ and Moorhen (which is what I'd rather be doing).)

Fortunately for this project, Global Phasing Ltd recognised the importance of the project and financed the hiring of Jakub Smulski from a freelancing company to help work on the project. After a brief on-boarding, Jakub took control of the rewrite of the tools in _Coot_ that had been using GooCanvas, which is to say the validation graphs - and (more recently) the ligand building tool (_i.e._ the replacement of "Lidia" in _Coot_).

Jakub is making good progress on the ligand-builder and it seems that we can expect that it will be stable and useful enough for a release in a few weeks.

For my part, I brought back Python and the Python-based GUI, wrote a Ramachandran Plot tools that works in OpenGL (rather than GooCanvas) and fixed up 100 other dialog and widget-related things. For details on this, you can track the progress of the todo list in the repo:

[https://github.com/pemsley/coot/blob/main/rel-todo-gtk4](https://github.com/pemsley/coot/blob/main/rel-todo-gtk4)

During this last year of work I've had a MacBook Pro and so I could build _Coot_ on macOS. As you may know, macOS doesn't provide the tools and libraries for cross-platform development. The project that does though is Homebrew - and so _Coot_ is built using the Homebrew infrastructure. I'd like to thank [Yoshitaka Moriwaki](https://github.com/YoshitakaMo) for setting up the Homebrew formula and being a source of help and advice over the previous two years.

Luca Bacci recently helped out with the necessary patches so that the GTK4 worked on macOS Ventura.

So, now we are approaching a state where _Coot_ can be released. In any sane software version numbering scheme, this amount of work and change to the user interface would require a bump in the major version. However, seeing as Version 1 didn't get much of an outing, this new GTK4-version will be version 1.1 - so that it can carry the torch of Version 1.

The auto-builder script now compiles _Coot_ and its dependencies, soup to nuts, on Ubuntu 22.04 LTS (provided you have installed things like swig, cmake, gfortran and libssl (the script tells you what you need)).

It looks that I will be able to draw the strings together for a release in early to mid September (September 2023, that is).

