<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Core/LocationType.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:630f891b9d0d1621cdbf3254e8536d4f)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Core_DAO_LocationType constructor.
 */
class CRM_Core_DAO_LocationType extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_location_type';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Location Type ID
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Location Type Name.
   *
   * @var string
   */
  public $name;
  /**
   * Location Type Display Name.
   *
   * @var string
   */
  public $display_name;
  /**
   * vCard Location Type Name.
   *
   * @var string
   */
  public $vcard_name;
  /**
   * Location Type Description.
   *
   * @var string
   */
  public $description;
  /**
   * Is this location type a predefined system location?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Is this property active?
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Is this location type the default?
   *
   * @var boolean
   */
  public $is_default;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_location_type';
    parent::__construct();
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location Type ID') ,
          'description' => 'Location Type ID',
          'required' => true,
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Location Type') ,
          'description' => 'Location Type Name.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'display_name' => array(
          'name' => 'display_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Display Name') ,
          'description' => 'Location Type Display Name.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 1,
        ) ,
        'vcard_name' => array(
          'name' => 'vcard_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('vCard Location Type') ,
          'description' => 'vCard Location Type Name.',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'description' => array(
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Description') ,
          'description' => 'Location Type Description.',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Location Type is Reserved?') ,
          'description' => 'Is this location type a predefined system location?',
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Location Type is Active?') ,
          'description' => 'Is this property active?',
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
        'is_default' => array(
          'name' => 'is_default',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Default Location Type?') ,
          'description' => 'Is this location type the default?',
          'table_name' => 'civicrm_location_type',
          'entity' => 'LocationType',
          'bao' => 'CRM_Core_BAO_LocationType',
          'localizable' => 0,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'location_type', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'location_type', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'UI_name' => array(
        'name' => 'UI_name',
        'field' => array(
          0 => 'name',
        ) ,
        'localizable' => false,
        'unique' => true,
        'sig' => 'civicrm_location_type::1::name',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
