// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Created by postproc-cld2 4.0 on 2013-06-14 17:18:11
// From command line:
//  --cld2 --cc --just_read_raw --delta_octa
//  --wrt=cld2_generated_quadchrome0604.bin --standard --minchars=5
//  --mincount=2 --max_items_per_langscript=300 --flatmap --rr_alloc
//  --freq_alloc --boostcloseweakerpercent=00 --indirectbits=12 --thresh=224
//  --v25 --kentries=16 --tablename=DeltaOctaChrome0614
//  --remap=xxx-Latn=>ut-Latn    sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl
//  nn-Latn=>no-Latn mo-Cyrl=>ro-Cyrl     --include=af-Latn ar-Arab be-Cyrl
//  bg-Cyrl ca-Latn cs-Latn cy-Latn    da-Latn de-Latn el-Grek en-Latn
//  es-Latn et-Latn fa-Arab fi-Latn fr-Latn    ga-Latn gd-Latn hi-Deva
//  hr-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr    ja-Hani ko-Hani
//  lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn    pl-Latn
//  pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn
//  sr-Cyrl    sv-Latn sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn
//  yi-Hebr    zh-Hani zh-TW zh-Hani    sq-Latn az-Latn eu-Latn bn-Beng
//  gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab    bh-Deva mr-Deva ne-Deva
//  lg-Latn rw-Latn gd-Latn    ut-Latn ut-Deva    tlh-Latn ceb-Latn blu-Latn
//  jw-Latn  --ko_english --force_to_lang_soft --nosoft_cram2 --nomsidlevel
//  --shapeflatprob --langpriorpercent=10 --skipnuc --noshapeforcetop
//  --noshapeeventop --noshapesteep2 --spread=15 --nodoubleclose
//  --langcounts --writebin --list_items=120
//  i18n/encodings/cld2/prob_data/vetted_octa_prob_20130527.utf8
//
#include "cld2tablesummary.h"
namespace CLD2 {

static const uint32 kDeltaOctaChrome0614BuildDate = 20130614;    // yyyymmdd


// Of 21808 offered items into 16384 table entries:
// 14834 filled (68%), 3 merged (0%), 6971 dropped (31%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 65 languages in range ENGLISH..X_KLINGON:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Unknown BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG
//     TURKISH UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY
//     WELSH NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC
//     CATALAN BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE
//     VIETNAMESE SLOVAK AZERBAIJANI PERSIAN YIDDISH AFRIKAANS
//     HAITIAN_CREOLE KINYARWANDA GANDA CEBUANO HMONG X_KLINGON

//  ENGLISH 198
//  DANISH 202
//  DUTCH 203
//  FINNISH 201
//  FRENCH 183
//  GERMAN 203
//  HEBREW 204
//  ITALIAN 199
//  Japanese 204
//  Korean 198
//  NORWEGIAN 383
//  POLISH 211
//  PORTUGUESE 208
//  RUSSIAN 208
//  SPANISH 213
//  SWEDISH 199
//  Chinese 207
//  CZECH 386
//  ICELANDIC 212
//  LATVIAN 220
//  LITHUANIAN 201
//  ROMANIAN 395
//  HUNGARIAN 207
//  ESTONIAN 196
//  Unknown 5
//  BULGARIAN 204
//  CROATIAN 395
//  SERBIAN 552
//  IRISH 207
//  GALICIAN 194
//  TAGALOG 209
//  TURKISH 200
//  UKRAINIAN 204
//  HINDI 409
//  MACEDONIAN 195
//  BENGALI 212
//  INDONESIAN 405
//  MALAY 331
//  WELSH 213
//  NEPALI 211
//  ALBANIAN 199
//  BELARUSIAN 200
//  JAVANESE 200
//  URDU 200
//  BIHARI 286
//  ARABIC 204
//  CATALAN 197
//  BASQUE 202
//  SCOTS_GAELIC 211
//  SWAHILI 199
//  SLOVENIAN 206
//  MARATHI 190
//  MALTESE 203
//  VIETNAMESE 213
//  SLOVAK 308
//  AZERBAIJANI 200
//  PERSIAN 206
//  YIDDISH 207
//  AFRIKAANS 202
//  HAITIAN_CREOLE 200
//  KINYARWANDA 202
//  GANDA 212
//  CEBUANO 208
//  HMONG 190
//  X_KLINGON 205



// Recognized language-script combinations [67]:
static const char* const kDeltaOctaChrome0614RecognizedLangScripts =
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva blu-Latn bn-Beng "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "hi-Deva hr-Latn ht-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr "
  "ja-Hani jw-Latn ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl mr-Deva "
  "ms-Latn mt-Latn ne-Deva nl-Latn no-Latn pl-Latn pt-Latn ro-Cyrl "
  "ro-Latn ru-Cyrl rw-Latn sk-Latn sl-Latn sq-Latn sr-Cyrl sr-Latn "
  "sv-Latn sw-Latn tl-Latn tlh-Latn tr-Latn uk-Cyrl un-Latn ur-Arab "
  "vi-Latn yi-Hebr zh-Hani ";

static const uint32 kDeltaOctaChrome0614Size = 4096;    // Bucket count
static const uint32 kDeltaOctaChrome0614KeyMask = 0xfffff000;    // Mask hash key

static const IndirectProbBucket4 kDeltaOctaChrome0614[kDeltaOctaChrome0614Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0x92901002,0xe6dc0003,0x62d8e004,0xd83dc005}},	// [000] _vihar_, _नामित_, _cafef_, _مشابہ_,
   {{0x67c95006,0xe2ca6007,0x7a7b7008,0x42484009}},	//   _zastosow, _ugode_, _ўзровень_, _sammo_,
   {{0x3a4ba00a,0x81aa500b,0x29edc00c,0xd4d9200d}},	//   _בלילה_, _заповедн, _finitura_, _бабруйск,
   {{0x627ef00e,0x5292500f,0x22497010,0x73ac1011}},	//   _ikinci_, _intara_, _agamba_, _grupė_,
   {{0x99da4012,0x9b7dd008,0x72d9f013,0xb2ca4014}},	//   _galleria_, _prenumer, _kuten_, _galleri_,
   {{0x7e716015,0x83eb9016,0xf7041017,0xacf76018}},	//   _karaoké_, _nesta_, _смайлікі_, _साईकिल_,
   {{0xc319c019,0xc290301a,0xe116e01b,0xee9bf00e}},	//   _حيران_, _sumali_, _телефону_, _sammitin,
   {{0xb2900012,0x72ff401c,0xefb7101d,0x6b4e301e}},	//   _asiat_, _marimar_, _þínum_, _sammendr,
   {{0x8a3e501f,0x82d98020,0x23874021,0x6f67e022}},	//   _haritası_, _ogres_, _cierto_, _स्वच्छन्,
   {{0x0ae45023,0x2a7e3024,0x2d5dc025,0xbd3d8026}},	//   _facultat, _تشخیص_, _북마크하기_, _cooperac,
   {{0xf291900e,0x0364b027,0x2683b028,0x6a22d029}},	//   _insan_, _podrazum, _बारात_, _отбор_,
   {{0x5245d02a,0x7236d022,0x625ad02b,0x00000000}},	//   _автомаши, _znojmo_, _faller_, --,
   {{0xd292502c,0x9afd602d,0xbc67202e,0x6b9a202f}},	//   _antara_, _investis, _другие_, _ekonomic,
   {{0xeccea030,0x50c3d031,0xe2484032,0x39fe0033}},	//   _县级以上地方人民, _مدرسہ_, _gamme_, _novament,
   {{0x79eb2005,0xd3ebe034,0x6e059035,0x70d12036}},	//   _طاہرالقا, _detto_, _kendaraa, _この人とブロとも,
   {{0xe3a7e031,0x53ebe037,0x0d692038,0xf5850039}},	//   _مجموعی_, _letto_, _kulturës_, _سنگاپور_,
   {{0xf27ed03a,0x8849b03b,0xcc7d703c,0x174df03b}},	// [010] _ocena_, _コメント記入欄を, _versija_, _バックナンバ_,
   {{0xabd7c03d,0x6219e03e,0x32d9f03f,0xaf3a5040}},	//   _vendedor, _podnikán, _guten_, _hellenic_,
   {{0x48739041,0xd3eb9033,0x841a6042,0x99f8a03e}},	//   _बेंगलुरु_, _desta_, _правилам, _severní_,
   {{0xa200c043,0x92019019,0x5f914044,0x53338045}},	//   _undir_, _ansin_, _phẩm_, _чернігів,
   {{0x32da9046,0xba53b047,0xe3f85048,0x2e42a036}},	//   _amplify_, _menerima_, _malum_, _カタログ情報を_,
   {{0x03ea6049,0xe25a604a,0x0ad2004b,0xa712504c}},	//   _multe_, _mulle_, _gratuite, _construç,
   {{0x2e44204d,0x72d17005,0x8c53004e,0xb1fab04f}},	//   _katapult_, _لوکلائزی, _pustaka_, _quantrim,
   {{0x02018050,0x52240051,0xe2918052,0x12d87053}},	//   _jirin_, _olika_, _jiran_, _banen_,
   {{0xc27ee054,0x6eeae055,0x43eb9043,0x4a87f056}},	//   _mannen_, _مساوي_, _besti_, _perindus,
   {{0x62feb057,0xc3eb9058,0xa25b9059,0x3224505a}},	//   _activar_, _jesti_, _jesli_, _kelke_,
   {{0x1501105b,0x7e403024,0xe836505c,0x52d7105d}},	//   _espesyal_, _هالیوود_, _аквариум, _murongo_,
   {{0x62d9f05e,0x8cea605f,0x00000000,0x00000000}},	//   _zuten_, _приказан, --, --,
   {{0x0845c060,0xa247b017,0x58dbd061,0x793df062}},	//   _главна_, _bendruom, _amaethyd, _ব্যয়_,
   {{0xde482063,0xcdc05064,0x00000000,0x00000000}},	//   _البطولات_, _antikala, --, --,
   {{0x553c0065,0x5d54c066,0x35509067,0x32019068}},	//   _तब्बल_, _आवागमन_, _प्रत्याप, _misin_,
   {{0xd2935069,0x6201c06a,0xa248406b,0x2470f06c}},	//   _가능합니다_, _invia_, _samme_, _דאַװענען_,
   {{0x3bf48062,0xd1db806c,0x826e806d,0xfa5c106c}},	// [020] _আওয়ামী_, _כּסדר_, _bütövlüy, _אפערירן_,
   {{0xa290506e,0x53eb906f,0x527ff03c,0x83f8d070}},	//   _cilat_, _cesti_, _jaunu_, _kudus_,
   {{0x995be071,0xec079072,0x78e62073,0xea7f4074}},	//   _معاہدہ_, _наконт_, _ефтин_, _barabara_,
   {{0x9aa7c075,0xeebc103f,0x10485076,0xfc6c103f}},	//   _जिज्ञासा_, _aktuelle_, _naturaln, _aktuell_,
   {{0xf2919012,0x72b40077,0x9fd60078,0x2308206c}},	//   _kisan_, _clica_, _pojemnoś, _ארײַנלאָ,
   {{0x18ac8079,0x727ee07a,0xa27ee07b,0x52fe8007}},	//   _preskoči_, _hannen_, _nainen_, _inviter_,
   {{0x6d22307c,0x8262307c,0xa8229062,0x00000000}},	//   _metohije_, _metohiji_, _অতঃপর_, --,
   {{0x9320007d,0x1308907e,0x83c8607f,0x4f946049}},	//   _abiye_, _ngobrol_, _kurven_, _апелулуй_,
   {{0xa230b063,0x53ba1080,0x24e33062,0xb650b063}},	//   _الآراء_, _виноград, _উৎসাহ_, _الآثار_,
   {{0xc6e8002a,0xb2d8d081,0x2291901f,0x71b1e062}},	//   _контроль_, _budes_, _nisan_, _সাথেই_,
   {{0x19ba3082,0x92240083,0x0cd72063,0x82903059}},	//   _privacid, _slika_, _لعلاج_, _ramach_,
   {{0xcbf58084,0x2e55901a,0x42d8d085,0x00000000}},	//   _कांग्रेस_, _katangia, _luder_, --,
   {{0x2201c086,0x1acb1003,0x894d8044,0x0b6ca021}},	//   _envia_, _फेडरेशन_, _innostre, _pantalla_,
   {{0x12fca087,0x2c7af088,0x45f72089,0xf94b707f}},	//   _apricot_, _glasnik_, _अमेठी_, _総合ポイント_,
   {{0xd2d8e08a,0x72d9f08b,0x225ae030,0x8394d08c}},	//   _kafee_, _lutem_, _taille_, _seoses_,
   {{0x82d4708d,0x8394708e,0xa290508f,0x2efe9025}},	//   _পাঁড়ফোর, _mense_, _silat_, _이용하시기_,
   {{0x52ca9049,0x22a69090,0x8d30c03e,0x891d0036}},	// [030] _publici_, _životní_, _vlastnic, _ご利用ガイド_,
   {{0xd8b2c030,0x97a6b091,0x00000000,0x00000000}},	//   _查看详细资料_, _protivni, --, --,
   {{0x56813092,0x5444b067,0xd2d86093,0xcc51d094}},	//   _सुनाई_, _सम्प्रदा, _broer_, _कमलेश_,
   {{0x01c70095,0x0ffb1041,0x53f40096,0x15d5905d}},	//   _حالتون_, _स्पाइसी_, _lister_, _batangiy,
   {{0x32cad097,0x23212061,0xf25a9098,0xb977a099}},	//   _reeds_, _ysbyty_, _atali_, _kojiblee,
   {{0x2156b09a,0xc7671072,0x63ebe09b,0x016af09c}},	//   _ליובאַוו, _царква_, _wette_, _fagperso,
   {{0x82ca7036,0xb3eb9083,0x5291709d,0x00000000}},	//   _hunde_, _mestu_, _praksis_, --,
   {{0xf2d9909e,0xb296c06d,0x9b553064,0x82903056}},	//   _museu_, _strateji_, _firmalar, _rajah_,
   {{0xf9d6a09f,0x222510a0,0x07b9e038,0xe3f8d0a1}},	//   _skotland, _muckle_, _komuniki, _budur_,
   {{0x232630a2,0xd247b071,0x82d800a3,0x00000000}},	//   _bynciau_, _üdvözlet, _remonts_, --,
   {{0x307af0a4,0x62e9e0a5,0xfc00f0a6,0xac05e038}},	//   _besplatn, _dominio_, _loksins_, _perseri_,
   {{0x5888802b,0xcf5a70a7,0x1200e0a8,0xdae720a9}},	//   _тексту_, _абсолвир, _sifil_, _vietfone,
   {{0x42919055,0xebb860aa,0x478760ab,0x41a6501b}},	//   _pisan_, _दृष्टिको, _सर्विस_, _kyseessä_,
   {{0x1b3880ac,0x52b7d075,0xf38700ad,0xdd2b30ae}},	//   _театры_, _गुरुङ_, _tubrog_, _acontece_,
   {{0x72905051,0xd352d0af,0x5a75c0b0,0xb212b054}},	//   _bilar_, _पहीले_, _deklaras, _tocht_,
   {{0x62da604e,0x920250b1,0xdc1650b2,0x57ec201b}},	//   _gereja_, _altima_, _sigurnos, _устанавл,
   {{0xa3cef01b,0xcd910055,0xc6a18036,0x13ebe0b3}},	// [040] _voivat_, _ملاحظه_, _ご了承ください_, _rette_,
   {{0xa29020b4,0x23ebe06b,0xbe06c057,0xc67c8041}},	//   _askar_, _sette_, _condemna, _uniwersy,
   {{0x1108d0b5,0x825a90a9,0xaf2120b6,0xa27eb0b7}},	//   _абеба_, _igala_, _esperien, _jednim_,
   {{0x6c5d70b8,0xa9e700b9,0xdb0c70ba,0x8ae1f0bb}},	//   _viettel_, _ospraved, _possible, _kostnade,
   {{0xb291e01b,0x33ea90b6,0x37b760bc,0x4c6aa03e}},	//   _antaa_, _stati_, _tagubili, _गुल्मी_,
   {{0x1e6f90bd,0x620070be,0x42907033,0x806850bf}},	//   _व्यक्तिय, _minis_, _minas_, _neophodn,
   {{0x5291501f,0xe17bf005,0x029020c0,0xf3cef002}},	//   _sigara_, _پھانسی_, _makau_, _sohvad_,
   {{0x5712009a,0x6e46d0c1,0x5d2e4030,0x9396d038}},	//   _החרדית_, _stratega, _承担一切因您的行, _strategj,
   {{0x239480c2,0x4f240075,0xf2d80044,0x7591c0c3}},	//   _langsung_, _našem_, _phien_, _입력하세요_,
   {{0xd688202a,0x23ea00c4,0x41b95005,0xdc361073}},	//   _контролю_, _buite_, _اشتہارات_, _circumsc,
   {{0x3a94c011,0xbdc80028,0x127ef0c5,0xb239f023}},	//   _хутчэй_, _अध्यापक_, _seinem_, _termeni_,
   {{0x2a74b0c6,0x129030c7,0xf2ecf06a,0x9472e0c8}},	//   _अजूनही_, _cumann_, _миграция_, _प्रभो_,
   {{0x5612c079,0x03eb9043,0x53a390c9,0x632460ca}},	//   _licencom_, _bestu_, _gospa_, _oficiri_,
   {{0x6ef76067,0x7682a0cb,0xf248d0cc,0xb2907065}},	//   _जानकी_, _वरदान_, _premi_, _dinas_,
   {{0x848620a4,0x995e10cd,0xf86bc0ce,0x21d92005}},	//   _stručnja, _transmet, _bountifu, _مغفرت_,
   {{0x0ab0c0cf,0xcde0c0d0,0x129110d1,0x12d840d2}},	//   _संस्कृति_, _संस्कृतम, _nicaea_, _timey_,
   {{0x82d570d3,0x6e9590d4,0x00000000,0x00000000}},	// [050] _seromba_, _נותרו_, --, --,
   {{0x7b5520d5,0x4af0e005,0xe29070d6,0x4f6630d7}},	//   _अप्लिकेश, _بیٹسمین_, _hinar_, _gumantun,
   {{0x5d47d0d8,0x5d85d025,0x9e9e303f,0xf290c0bf}},	//   _دراصل_, _카테고리의_, _erstellt_, _izdao_,
   {{0xdd7dd031,0x42eff005,0xe34170d9,0x72f3f0da}},	//   _اجراء_, _tragédia_, _diferan_, _gedicht_,
   {{0x53a3a0db,0x8b77803a,0x02ea100d,0x32da70a6}},	//   _hoppa_, _čestitam_, _regiono_, _noregi_,
   {{0xdf3980dc,0x6a7ae036,0xc29e10dd,0xbedc60de}},	//   _बॉलिवुड_, _エグザイル_, _читам_, _acciones_,
   {{0xcc1970df,0x012710dd,0x2e64e0e0,0x4a0b6091}},	//   _निश्चिन्, _часови_, _आयोगले_, _pojavila_,
   {{0x923c90e1,0x23eae0e2,0xe3f960e3,0x23eac02b}},	//   _присутна_, _contoh_, _siguri_, _tiltak_,
   {{0x2c6050db,0xefaf50e4,0xfc0b90e5,0x3b0a307f}},	//   _platser_, _csillago, _ymholiad_, _下記のボタンを押,
   {{0xbb62a0e6,0x7302000b,0x60b150e7,0x2291c00e}},	//   _भयानक_, _članku_, _tráfico_, _livan_,
   {{0x8212b0e8,0x32d750a0,0x7b6c60c1,0x73e5c034}},	//   _anche_, _eaglais_, _pharetra_, _олимпия_,
   {{0x13076052,0x604ac0e5,0x1a2be036,0x3e6770e9}},	//   _bimbang_, _peiriann, _オプション_, _autorizā,
   {{0x220ec007,0xa2905047,0x727ef0ea,0x42d8c0d9}},	//   _хабар_, _salah_, _ikindi_, _jaden_,
   {{0x63f8a0eb,0xb29070ec,0x820020ed,0x89ed70ee}},	//   _kabul_, _einar_, _dakit_, _sainsnya_,
   {{0xd2fd502b,0x9fa74005,0x18a8306c,0x00000000}},	//   _kopiert_, _لائسنس_, _בערסאָן_, --,
   {{0xe288400a,0x522400be,0xec6a8059,0x57a660ef}},	//   _methods_, _klike_, _systemy_, _topluluk_,
   {{0xa8db9030,0x52d8800b,0xe200100e,0xd9a34019}},	// [060] _胶南市城建局_, _raketa_, _sahil_, _limistéi,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x12d800f0,0xec6b4067,0x322490f1,0x00000000}},	//   _thiel_, _जयन्ती_, _takket_, --,
   {{0x729070f2,0x234fc0f3,0x4af36051,0x6c6900f4}},	//   _pinas_, _estekak_, _konstate, _overall_,
   {{0xd519a0f5,0xd3f470f6,0x00000000,0x00000000}},	//   _размяшчэ, _kartat_, --, --,
   {{0x42084019,0x469480d1,0x92ea00b1,0xbc508076}},	//   _جوالات_, _cawmseej_, _puritan_, _सोचें_,
   {{0xd4ecb03b,0x612d2072,0xcbf540ba,0x52fce0f7}},	//   _ファッション_, _часта_, _espectac, _mingit_,
   {{0x6f87506f,0x0f41d0f8,0xb24940a4,0x00000000}},	//   _tišine_, _pangakon, _premda_, --,
   {{0xe3ebe051,0x5883c04b,0x5ebb20f9,0x00000000}},	//   _detta_, _您现在的位置_, _alergije_, --,
   {{0x926c208f,0x8291e0be,0xca8150a1,0xe5d4700e}},	//   _rekod_, _antan_, _assosias, _redaksiy,
   {{0x93ea90b6,0x0202002d,0x025af0fa,0x22494023}},	//   _stato_, _musiqi_, _spillt_, _vremea_,
   {{0x4eafb03b,0xfe5230fb,0x520250a3,0x00000000}},	//   _知的財産本部_, _dikataka, _notika_, --,
   {{0xf2d510fc,0x6af1f0bf,0xe200701d,0xa23690fd}},	//   _sellest_, _непријат, _vinir_, _jjaja_,
   {{0x89cff0fe,0x920260ff,0xe3f98070,0x00000000}},	//   _stretnut, _aktier_, _buruk_, --,
   {{0xf2014100,0x9e4ec101,0xb1570102,0xde922103}},	//   _breith_, _кайда_, _उपलब्धता_, _потреб_,
   {{0x9790d002,0x26ce3104,0x7fa25053,0xa25950b6}},	//   _qastahvi, _detaljni, _nedenfor_, _particol,
   {{0x52889105,0x5bdfd007,0x73d50106,0x00000000}},	// [070] _maharani_, _eigenver, _adottati_, --,
   {{0x7f5f30c4,0x42d880c0,0xefdf8107,0xf3730108}},	//   _hospitaa, _cakera_, _mobitelo, _temacie_,
   {{0x33e77109,0x0e8cb034,0x00000000,0x00000000}},	//   _sportivi_, _прокурор_, --, --,
   {{0xf291810a,0x89787090,0x42d9f02a,0x00000000}},	//   _siyasa_, _velikost, _etter_, --,
   {{0xd7c2d10b,0xb2cac10c,0x2291e0be,0xd290b0d1}},	//   _বাইরে_, _melden_, _mitan_, _licas_,
   {{0xe0a0b063,0x4201110d,0xe9cf2069,0x22ea110e}},	//   _البخاري_, _mizik_, _momentee, _coginio_,
   {{0xc2a6c10f,0x23ea8110,0x4f5cd0c0,0xd224002b}},	//   _member_, _maktab_, _inggeris_, _slike_,
   {{0x89c9f023,0x92d8506f,0x03f98111,0x537d4112}},	//   _germania_, _izlet_, _guruh_, _etranje_,
   {{0x960bc04c,0x59a34019,0x53870113,0xa1c3c114}},	//   _вчера_, _limistéa, _svarar_, _полония_,
   {{0xf3874115,0x53fa7116,0x52d920a9,0xd20c7036}},	//   _sheria_, _forumi_, _quyet_, _ラガマフィン_,
   {{0x13a48117,0xa584f025,0x3b8d202b,0xf2ca0034}},	//   _redakcij, _브라우저입니다_, _artiklar, _guida_,
   {{0x92305118,0xc290c119,0xf2cae055,0x6201811a}},	//   _vremena_, _lilama_, _tindak_, _miria_,
   {{0xcc618045,0x0851811b,0x637f811c,0xb75bf11d}},	//   _sverige_, _sveriges_, _hahaaaa_, _मुर्खता_,
   {{0x0200b11e,0x63ebe043,0x9d56011f,0x00000000}},	//   _andika_, _setti_, _लैंगिक_, --,
   {{0x048910a7,0x8a02c120,0x00000000,0x00000000}},	//   _интерв_, _ankarada_, --, --,
   {{0xa3ea6121,0xa2d98122,0xcd7f50e6,0x2c02a070}},	//   _multo_, _arren_, _विश्रांत, _नेतृत्वा,
   {{0x62267103,0x12002123,0xf03da0d4,0x03940100}},	// [080] _verkar_, _homing_, _directio, _coise_,
   {{0x92004124,0x3e70d067,0x53eaf01d,0x48754125}},	//   _damit_, _गिद्ध_, _vantar_, _mrnicegu,
   {{0x3237806b,0x48c7b0dc,0x63f990e2,0x99fc2031}},	//   _byrja_, _मणिपुर_, _musuh_, _sebesség,
   {{0x027ec0be,0x7200b126,0x5290b04c,0xd2009127}},	//   _anonse_, _dicis_, _dicas_, _wakiri_,
   {{0x93b19128,0x73f8301a,0xc200405b,0x3e0f2023}},	//   _nisqa_, _simula_, _gamit_, _comentea,
   {{0x82003129,0x92b4010c,0xb2240007,0x4fcd1063}},	//   _simili_, _klick_, _klikk_, _الفعل_,
   {{0xa24890fd,0x0197601b,0xafc5e075,0xcf7bf11f}},	//   _maama_, _телефоны_, _užitečné_, _फौजदारी_,
   {{0x43866080,0x8f80212a,0xb53bc057,0xc212b12b}},	//   _gjort_, _prochain, _sabadell_, _pochi_,
   {{0x77e79022,0x4f4a404b,0x46dd1108,0xd320812c}},	//   _स्वर्ण_, _personna, _पोलिश_, _dakyah_,
   {{0x0a35012d,0x72fc7045,0xf2dfa049,0xbba3112e}},	//   _straitéi, _senga_, _аместеку, _imihango_,
   {{0x526c512f,0x9bb64067,0x4290204e,0x6f6f3020}},	//   _selon_, _न्यूट्रा, _kakak_, _komandas_,
   {{0x7290300b,0x8aaf0041,0xf6de5038,0xf7e3d012}},	//   _člana_, _ख़िलाफ़_, _futbolli, _позиции_,
   {{0x1f9c6036,0xa2bc9041,0x1631a0c1,0x43fa6130}},	//   _このブログをリン, _यूनुस_, _economai, _natuur_,
   {{0x02002099,0x02b4010c,0x229270e9,0xb8b920e1}},	//   _askiv_, _blick_, _nosaka_, _наставил,
   {{0x0e911015,0x7200b0b7,0x19040131,0x556ff00b}},	//   _mystère_, _raditi_, _comataid, _posvetio_,
   {{0xce93a083,0x00000000,0x00000000,0x00000000}},	//   _animiran, --, --, --,
   {{0x62249132,0x05bc5133,0x08e6906c,0x3b25b0a4}},	// [090] _kwake_, _国家外汇管理局_, _גופֿא_, _priprema_,
   {{0x1200c08b,0xbbb9e0b6,0x5290c036,0x87eb3005}},	//   _midis_, _заседани, _udland_, _کرچیاں_,
   {{0x93ea6069,0xa2ba7038,0x2486d0ab,0x3933c12b}},	//   _grote_, _mendoni_, _रोमांस_, _полето_,
   {{0x427f4051,0x7523d060,0x454f1087,0xb0429059}},	//   _svensk_, _поздрав_, _methamph, _pomiędzy_,
   {{0x02b4e0b8,0x1ce05073,0x12da6122,0x727f70c1}},	//   _vincom_, _унижений_, _arreta_, _wrando_,
   {{0xa37d4134,0xe2d9c135,0xf200406d,0x735be0cd}},	//   _zdravie_, _suvel_, _ramil_, _mungesa_,
   {{0xf239f136,0xe2904067,0xc2005137,0x0200c138}},	//   _termini_, _samal_, _galit_, _halisi_,
   {{0x5ec3a08e,0xd291d139,0x69c4001b,0x9d3af030}},	//   _christus_, _anwar_, _moderaat, _domicile_,
   {{0xb2a770a2,0x93ea600a,0x620190ce,0x7273600e}},	//   _arabeg_, _wrote_, _visih_, _günah_,
   {{0x5018c0a4,0x305a004f,0xa201e07d,0x52c2000e}},	//   _preporuč, _agribank_, _sitin_, _italiya_,
   {{0x5c77312b,0xc3eae13a,0xc27a8036,0xfc66a07a}},	//   _console_, _lufte_, _氏名又は名称_, _hurtigt_,
   {{0x425ad0ba,0xc405f13b,0x00000000,0x00000000}},	//   _taller_, _doručení_, --, --,
   {{0xa25a913c,0x029040a1,0x62027038,0xcd523063}},	//   _suala_, _tamam_, _arriti_, _ههههه_,
   {{0x2060507f,0x00000000,0x00000000,0x00000000}},	//   _このカテゴリから_, --, --, --,
   {{0xef078076,0x348f7063,0x6a65c133,0xb2fd0040}},	//   _odtwarza, _حسناتك_, _有难题就提问_, _bhagat_,
   {{0x40f1313d,0x8c5d20ed,0xe8c5d13e,0x00000000}},	//   _भैरवी_, _bertako_, _атрактив, --,
   {{0xe27e00f2,0x2290713f,0x6af7b129,0xea435072}},	// [0a0] _aming_, _manau_, _konsumat, _месенджа,
   {{0xeaf7b114,0x72330051,0xb2595140,0x5e7350e6}},	//   _consumat, _exempel_, _portafol, _समर्थ_,
   {{0x92fc501f,0xa2d50005,0xd6bad00a,0xd2006099}},	//   _belge_, _naponta_, _javascri, _nplig_,
   {{0xe2fc7115,0x3447e0e1,0x3394e04b,0xb0f66141}},	//   _lengo_, _прелази_, _laisse_, _menimbul,
   {{0xc1422012,0xbb4820d4,0xf0cce062,0x00000000}},	//   _стран_, _עגבניות_, _হাদীস_, --,
   {{0xa30e6142,0x73f3c143,0x0aff1144,0xe213e130}},	//   _casados_, _قطعات_, _sahranje, _botha_,
   {{0xa2486145,0xf992e146,0x42a69147,0x0dc720c3}},	//   _akoma_, _verklige, _ajabu_, _부동산써브가_,
   {{0xce6270f4,0x135f1097,0xaa4cc148,0x00000000}},	//   _practice_, _jongste_, _تجزيه_, --,
   {{0xa907b09b,0x47eb8065,0x92907149,0x5bb7b041}},	//   _redakteu, _प्रकारे_, _danau_, _सुर्खियो,
   {{0x52919072,0x9a5f810b,0x83ea2047,0x578a3005}},	//   _visai_, _pregunta_, _bukti_, _گراؤنڈ_,
   {{0xe683b13d,0xb6988124,0x59cfa0d4,0x5290a0cd}},	//   _सोनार_, _wesentli, _עצמכם_, _babai_,
   {{0x92f1e111,0xfecc503c,0x2b7480c3,0xb2fc503c}},	//   _skripsi_, _papildus_, _개인정보보호_, _papildu_,
   {{0xd291f14a,0x72da514b,0x111c101b,0x827f714c}},	//   _anuas_, _gutera_, _основани, _mpanga_,
   {{0x4389b01b,0x53f8e07e,0x4c23107a,0x0a835062}},	//   _helsinki_, _manusa_, _mulighed_, _স্বেচ্ছা,
   {{0x123c6069,0xf356b026,0x53e7314d,0x68da314e}},	//   _감사합니다_, _obtenir_, _måtte_, _startpag,
   {{0x1290702d,0xefe9e070,0xec5ce14f,0x2290c150}},	//   _manat_, _बाजारात_, _योगेश_, _pidas_,
   {{0x425a00cd,0xb386d06b,0xb3cf700b,0x22639140}},	// [0b0] _prill_, _gjera_, _glavne_, _definiti_,
   {{0x6c519151,0x6f38d152,0xd27eb0db,0x00000000}},	//   _taktika_, _देखिन्छ_, _boende_, --,
   {{0xf2011020,0xfbd8c07b,0xf2b40091,0x327ee002}},	//   _aicina_, _сначала_, _slici_, _tannen_,
   {{0xa26c101e,0xe2240153,0xdc80c0dd,0x071ec00d}},	//   _behov_, _pliki_, _девет_, _майго_,
   {{0xa2cae08b,0x24268101,0x0b62d154,0x73949073}},	//   _mendja_, _автобусн, _घुटना_, _clasa_,
   {{0x31588155,0x7447e156,0x19321024,0x00000000}},	//   _javouhey_, _анексязэ_, _بنزین_, --,
   {{0x9d6a1157,0x42dab00a,0x33731108,0xe2ca900a}},	//   _atomique_, _october_, _finanse_, _grade_,
   {{0x4c7120bd,0x72516157,0xf318e0f2,0x37eef036}},	//   _बाल्टी_, _poslanci_, _salitang_, _ヘルプデスク_,
   {{0x82002022,0xe3e73158,0xa8ed106c,0x00000000}},	//   _komise_, _nätet_, _כּבֿוד_, --,
   {{0x066c500d,0xed60b133,0x9e4d700a,0x8394e063}},	//   _наступны_, _香港紫金碳雕加盟, _compared_, _paiste_,
   {{0x8d8e4159,0x425a605c,0x93eb315a,0xdc56a038}},	//   _encontra, _sulle_, _texty_, _partive_,
   {{0x43eaf055,0x73878105,0x00000000,0x00000000}},	//   _banter_, _asyraf_, --, --,
   {{0x02d8e15b,0x62fc7159,0x8c5d2107,0x00000000}},	//   _manera_, _tengo_, _pustimo_, --,
   {{0xc3552061,0x42026137,0x82d8c07d,0xb2ca900a}},	//   _calendr_, _korina_, _teleko_, _trade_,
   {{0x62b67026,0x4f44515c,0xe7d0c04f,0x9200a01f}},	//   _tercer_, _энциклоп, _congdong, _tabii_,
   {{0xca830051,0xb2e30145,0x229050e4,0x7489012b}},	//   _familjen_, _familje_, _halak_, _присъеди,
   {{0x5f761044,0x7a92006c,0xd2d3a15d,0x0872815e}},	// [0c0] _khỏan_, _אַדרעס_, _fridtjof_, _удивител,
   {{0x2f19815f,0x557d615f,0x92e3c160,0x2c2840a3}},	//   _располаг, _populaçã, _भयभीत_, _plastmas,
   {{0x327f7034,0xa27fd128,0x325ad161,0xb248900f}},	//   _quando_, _pawns_, _hallar_, _shami_,
   {{0x8e683162,0x7290e047,0x725ad103,0x0a7a5035}},	//   _अनुभूति_, _sifat_, _kallar_, _लोकशाही_,
   {{0xa2da0068,0x95f9507b,0x22ef410e,0x0396609c}},	//   _lisesi_, _напряжен, _diffyg_, _morsom_,
   {{0xb2903163,0x03f40164,0x9c5f10eb,0x937a0165}},	//   _namana_, _gister_, _unuttum_, _buradan_,
   {{0xba08e07b,0x725a4132,0x0a2bd101,0x228f4133}},	//   _salasana_, _jumla_, _мъжете_, _中国中小企业安徽,
   {{0x3631307a,0x62005166,0x327ff167,0xd6ab3168}},	//   _お問い合わせ_, _malih_, _jauns_, _езеро_,
   {{0x52240169,0x00000000,0x00000000,0x00000000}},	//   _aliko_, --, --, --,
   {{0xe1dc2011,0x82cbc009,0x52eb716a,0x1248c16b}},	//   _клубы_, _hevdi_, _medical_, _filmai_,
   {{0x93f98105,0x7290b16c,0xa4732133,0x14259038}},	//   _turut_, _ascas_, _网站或个人未经本, _artistik,
   {{0xd6d3716d,0x3c59f16e,0x00000000,0x00000000}},	//   _मालिक_, _listrik_, --, --,
   {{0x8395416f,0xb290e170,0xf0462159,0xb27f805f}},	//   _presne_, _danach_, _incremen, _poznat_,
   {{0x2309c171,0xe6975172,0x2988813e,0xc2907173}},	//   _também_, _offentli, _местото_, _panal_,
   {{0xd1b62174,0x4da200be,0xa2cb812a,0xbede9073}},	//   _सबैभन्दा_, _prensipa, _perdu_, _transmis_,
   {{0x03005175,0xe30e4176,0xd276106c,0x43ea70c4}},	//   _kulaani_, _estamos_, _אינדיע_, _punte_,
   {{0x92d800b8,0xb4a670d0,0x801f5177,0xb04c3178}},	// [0d0] _chieu_, _प्रादुर्, _handiago, _politisk_,
   {{0x52485179,0x5200610a,0x9a0e217a,0x80be517b}},	//   _filmy_, _croix_, _трьох_, _комплетн,
   {{0xbc59f070,0x5f45302d,0xef2bc062,0x3200701a}},	//   _distrik_, _formalaş, _কল্পনা_, _tanim_,
   {{0xb2d9f17c,0xbbbd017d,0xcb00a17e,0x5680c17f}},	//   _putem_, _নরাধম_, _división_, _predvodi,
   {{0x42da6180,0xd25b2128,0x12926088,0x00000000}},	//   _streda_, _styli_, _zorana_, --,
   {{0x62428051,0x92920181,0x43859044,0x92007076}},	//   _soomaali_, _strany_, _tốcđộ_, _zanim_,
   {{0xd2d5202f,0x83d52117,0x5b55211b,0xc291001a}},	//   _kontakty_, _kontakti_, _kontakta_, _maaari_,
   {{0x2061c02a,0xb2bd1182,0x00000000,0x00000000}},	//   _стати_, _присутни_, --, --,
   {{0x36832045,0xf2da1109,0x6c22d03b,0x6d6610c3}},	//   _послуги_, _impetu_, _zebrafis, _부동산개발_,
   {{0x17ada106,0x22a7f14c,0x72918056,0x00000000}},	//   _direttiv, _kkubo_, _tiram_, --,
   {{0xdf1c90a7,0xe290c01c,0x690a0005,0x18c53183}},	//   _формулат, _halaga_, _مریضوں_, _spreagad,
   {{0x4461712b,0x5301909f,0xcd9d50ba,0x02e6017d}},	//   _ентусиас, _musashi_, _connecta, _granada_,
   {{0x32b2802e,0xc546c181,0x5387f147,0xd700f184}},	//   _voidaan_, _zároveň_, _uhuru_, _struchtú,
   {{0xd3f47185,0xeb2dc0c0,0x1b07d045,0x3291e186}},	//   _unutar_, _tembakan_, _тиждень_, _kitaa_,
   {{0xe7dec16c,0xb2da602f,0x9962e187,0x620110be}},	//   _epiphani, _hotely_, _селектор, _vizit_,
   {{0x28464188,0x53ea905d,0x856620d4,0xde7c50e0}},	//   _qualidad, _itatu_, _הבלעדית_, _होम्स_,
   {{0xf92d7025,0xa1880020,0xe4ada0d4,0x6e38e121}},	// [0e0] _자바스크립트를_, _festivāl, _השפלה_, _karapata,
   {{0x234c700a,0x13877063,0x7c85e0d1,0x4292600d}},	//   _several_, _tharla_, _nujtxeeg_, _kitais_,
   {{0xc25a906a,0xf3784006,0xadff5189,0x7283f0c9}},	//   _quale_, _badania_, _pandanga, _prikaza_,
   {{0xc0d2f005,0xef63918a,0x00000000,0x00000000}},	//   _تمھارے_, _говорю_, --, --,
   {{0x6290718b,0x1c67318c,0x42245164,0x00000000}},	//   _kanak_, _kultuur_, _wolke_, --,
   {{0xd290201a,0x00000000,0x00000000,0x00000000}},	//   _lakas_, --, --, --,
   {{0x50062071,0xcc1690e7,0xc2de502d,0x73eaf052}},	//   _ٹریفک_, _rápida_, _dilində_, _hantar_,
   {{0x6ae6e17d,0x00000000,0x00000000,0x00000000}},	//   _জোনাকি_, --, --, --,
   {{0xe3f8d099,0xcc1570f7,0xd3ea911e,0xa33a5024}},	//   _rieux_, _सान्निध्, _atatu_, _وردپرس_,
   {{0xc8465003,0xa7bb1108,0xb9b7718d,0xe325d005}},	//   _महासंग्र, _mazurski, _класифік, _róbert_,
   {{0x92d8018e,0xf2da6177,0xeb78a18f,0xf2f5b020}},	//   _thiet_, _berean_, _vergeten_, _valodā_,
   {{0x8bca2073,0x72ca7067,0xe2018055,0xec6e4073}},	//   _политико_, _kunda_, _kirik_, _andreea_,
   {{0x69ead170,0xb2b6a069,0x1290b0a7,0x00000000}},	//   _vergange, _verdere_, _bacau_, --,
   {{0x65b85030,0x92ca7190,0xa08a60ce,0xb2019067}},	//   _构成犯罪的_, _munda_, _blackfoo, _ansip_,
   {{0xc73f007b,0x727eb12b,0x3da8f0a6,0x00000000}},	//   _оставить_, _niente_, _greinasa, --,
   {{0xc2caf191,0xf6e7603b,0x6200b158,0xa212b030}},	//   _bandar_, _人が役に立つと評, _facit_, _fiche_,
   {{0xf3a38192,0xb3949193,0x13eae065,0x13875045}},	// [0f0] _corpo_, _clase_, _rentan_, _sterkt_,
   {{0x32901002,0x03877178,0xbae21024,0x4b676108}},	//   _dahar_, _starte_, _آپدیت_, _घूमने_,
   {{0xd2011194,0x79a3704c,0x97c7917d,0x00000000}},	//   _kabiri_, _ministér, _টুকরো_, --,
   {{0xd513c17d,0x332030d1,0x00000000,0x00000000}},	//   _নোয়াখাল, _lwmyam_, --, --,
   {{0xa24a011c,0xa27ed130,0x2b07701d,0xe10110b5}},	//   _kasmas_, _vinnig_, _samskipt, _акватикэ_,
   {{0x239660fb,0x2b6fa038,0xf2a05135,0xa5f09035}},	//   _persib_, _momentin_, _klubid_, _सप्टेंबर_,
   {{0x6290f0c2,0xad2ca0c2,0xe290206f,0x2476b039}},	//   _enhavo_, _veritate_, _nakar_, _hirtelen_,
   {{0xc25a914c,0xff302013,0x72018137,0xdda9310a}},	//   _ngalo_, _редакции_, _tirik_, _fulgence_,
   {{0x5d84b079,0xce481195,0xe27eb130,0xb2ca7196}},	//   _odredite_, _capacida, _moenie_, _gundi_,
   {{0x9140c038,0x00000000,0x00000000,0x00000000}},	//   _pretendo, --, --, --,
   {{0xc2cad0b5,0x3386b197,0x03e65198,0x7407e0f8}},	//   _crede_, _modrim_, _महामंत्र, _dunungan_,
   {{0xd2902199,0xb2b9e15d,0x6b82419a,0x85411063}},	//   _makar_, _endelig_, _planinar, _الذاتية_,
   {{0xb3173015,0x925a9019,0x72f070bc,0x00000000}},	//   _concile_, _ngall_, _malinaw_, --,
   {{0xb2d8304b,0x489e4012,0xa2d8b073,0x829020f8}},	//   _samedi_, _закладки_, _vedete_, _wakas_,
   {{0x4642b049,0xd290c130,0x93a4307c,0x92919189}},	//   _местоиме, _nadat_, _zanatlij, _kisah_,
   {{0xa2ca70fa,0x10513012,0x0a8680bd,0x6890819b}},	//   _fundi_, _истории_, _europejs, _अनिश्चित,
   {{0x22ecb19c,0xe3ead112,0x126d419d,0x237fa010}},	// [100] _springe_, _arete_, _akfohg_, _wajamaa_,
   {{0x834c2070,0xa431f049,0x302b916b,0xac75406d}},	//   _मंजूर_, _кларинет_, _школах_, _deputat_,
   {{0x62cae145,0xe3dcd099,0xb2d8311e,0xcccc80a7}},	//   _mendon_, _brower_, _nimero_, _виитоаре_,
   {{0xfa7e207e,0xb6d2410e,0x8a17c13f,0xce73411f}},	//   _تشریح_, _morgannw, _psichiat, _तटस्थ_,
   {{0xe3f4719e,0x827e60d1,0x4217200d,0xc5d99049}},	//   _nostra_, _hmong_, _дрэнна_, _инверс_,
   {{0x125a918b,0x13ead112,0x4277e00d,0x7290c074}},	//   _kuala_, _trete_, _царквы_, _wadau_,
   {{0xc2955154,0x2c1ac13b,0x22aad063,0x62366185}},	//   _probleem, _खेलौना_, _مسألة_, _dvoje_,
   {{0x2fddd024,0xe3ea9170,0xc23be00c,0x62e970e2}},	//   _مشاغل_, _statt_, _aħjar_, _dirinya_,
   {{0x027ee059,0x569da135,0x6c70219f,0x7c51b078}},	//   _opinia_, _direktii, _डेक्कन_, _श्वेत_,
   {{0x4f8b4044,0xbf2820ba,0x1638e07b,0x8e41307e}},	//   _thời_, _expressa, _perintei, _هماهنگی_,
   {{0x0c7f901c,0xfa151108,0x4f5f5125,0x6da8701a}},	//   _mabuhay_, _redakcja_, _uppppppp, _kalinisa,
   {{0x7177200b,0x83ea7106,0x65be20b6,0x927e61a0}},	//   _место_, _punti_, _друго_, _imong_,
   {{0x63f431a1,0xf2fc9100,0xe2d8b15d,0x2f4481a2}},	//   _posté_, _beaga_, _ledere_, _constaba,
   {{0xc2b3406f,0xa5507034,0x03957189,0x0fac6063}},	//   _učenje_, _società_, _swasta_, _مغامرات_,
   {{0x78a3e036,0x5a2691a3,0xb7c61035,0x00000000}},	//   _メロディアス_, _descarga_, _हळूहळू_, --,
   {{0x8c7581a4,0x937370a9,0x6290c1a5,0xa236d1a6}},	//   _bearish_, _rongbay_, _nadam_, _projet_,
   {{0x42d92086,0x029150a7,0x0a21f13b,0x00000000}},	// [110] _valorar_, _legate_, _tudíž_, --,
   {{0x33f9a18b,0x33ac10dd,0x1347c133,0x00000000}},	//   _pupus_, _слободен_, _vendeur_, --,
   {{0xc26c41a7,0xde46106c,0xfc18f054,0xb6e6c0d1}},	//   _nemoj_, _עיפריל_, _verander, _yeebtsim_,
   {{0x4d5a81a8,0xff3ca0d0,0x4682d059,0x72904126}},	//   _प्रभाकर_, _perusaha, _सहवाग_, _tamat_,
   {{0xc249818a,0x7290a04e,0x5808c036,0xb2005185}},	//   _varma_, _babak_, _リンク切れ報告_, _oblik_,
   {{0xf8433025,0xb2020115,0xd39451a9,0xa6261025}},	//   _되었습니다_, _kusini_, _bolsa_, _미디어다음_,
   {{0xb8a7c005,0x24857035,0x4bb121aa,0xf45f5039}},	//   _ہوچکی_, _शिफारस_, _conjunto_, _keletkez,
   {{0x701d1020,0x82009106,0xf290c117,0x09f48041}},	//   _nacionāl, _fujian_, _gadam_, _चैलेंजर्,
   {{0x6070817d,0xd70d413e,0x03ea01ab,0x00000000}},	//   _একুশে_, _experiên, _aritu_, --,
   {{0x13ea7190,0x0290208f,0xd2ca7177,0x6dc20141}},	//   _muntu_, _pakar_, _mundu_, _meningka,
   {{0xb2c4106d,0xc37a01ac,0x8c73e07c,0xa2fd300c}},	//   _bildirdi_, _larawan_, _proseka_, _pilastri_,
   {{0x19bf0036,0xcc606057,0xb290e0f8,0x23e8613e}},	//   _に選ばれた回答_, _postres_, _tanaga_, _decoraçã,
   {{0xb9d501ad,0x63eb9006,0x929041ae,0xd29610e0}},	//   _विषयमा_, _testy_, _hamar_, _भएकोले_,
   {{0x3c6161af,0x954420e0,0x00000000,0x00000000}},	//   _bestuur_, _मिनेटमा_, --, --,
   {{0x91f9d073,0x625a6043,0xa354b054,0x0b7d708c}},	//   _министра, _fullt_, _terecht_, _सिनेभोजप,
   {{0x2c2cf0d8,0x3175a06c,0x02d8c195,0x8db000a9}},	//   _bruttó_, _מוקצה_, _menores_, _asiasoft_,
   {{0x9956a172,0xd7b6100c,0x0ccf8030,0xfea9d1b0}},	// [120] _millione, _trasferi, _如要投诉或提出意, _postavke_,
   {{0x63f4719e,0x529051b1,0x0bdd7076,0x42d470e5}},	//   _vostra_, _balat_, _दरिया_, _gerddi_,
   {{0x1ab6a030,0x8541817d,0x17aa816c,0xd2e8e1b2}},	//   _添加到搜藏_, _সাংস্কৃত, _kastosli, _diliman_,
   {{0x06826041,0xc667915e,0x82d8b12b,0x426c5081}},	//   _उड़ान_, _наверх_, _vedere_, _celom_,
   {{0x60b59067,0x42904073,0x0fea41b3,0xc84d11b4}},	//   _गुरुजी_, _ramas_, _gajdošov, _partidos_,
   {{0xc2904166,0x510010d4,0x00000000,0x00000000}},	//   _kamar_, _רמקולים_, --, --,
   {{0x6c4b1141,0x1394900a,0x3ae5412e,0x7b94f1b5}},	//   _tentang_, _flash_, _itsembab, _postižen,
   {{0xbbb7c1b6,0xa2905046,0x720041b7,0xb018f099}},	//   _petrović_, _halas_, _damir_, _teevntuj_,
   {{0xc200c19a,0xb200913c,0x0119200b,0x860821b8}},	//   _radim_, _majina_, _технике_, _biografí,
   {{0x1ee6e0b8,0x00000000,0x00000000,0x00000000}},	//   _hochimin, --, --, --,
   {{0xf23b70c7,0x82d59030,0x8200500d,0x82498059}},	//   _nollaig_, _凡本网注明_, _dalis_, _darmo_,
   {{0xf61f4086,0x99d221ab,0x27c94015,0x02fcc071}},	//   _exposici, _erregist, _longgggg, _dolgok_,
   {{0x0dd920b4,0x774ed073,0x00000000,0x00000000}},	//   _perkataa, _граве_, --, --,
   {{0x5200c0c2,0x52904067,0xc313f144,0x8d35c005}},	//   _kaliya_, _samas_, _dimitrij, _انٹیلی_,
   {{0x7e4de025,0x025a9037,0xbeb131b9,0x6591a1b9}},	//   _대학보고서_, _quali_, _porovnan, _bleskovk,
   {{0x8b745007,0xe2fe60ba,0x150151b1,0x5200d130}},	//   _регламен, _visites_, _materyal_, _koning_,
   {{0xd2cae03f,0xb93a2070,0xc291e189,0x51fdb157}},	// [130] _beiden_, _अमेरिकेच, _hitam_, _reklamác,
   {{0x739471ba,0x32b47157,0x735ca02b,0x4966a1bb}},	//   _konsa_, _konca_, _партнери_, _सोमनाथ_,
   {{0x143ec07b,0x9201e0e3,0x43ea01bc,0xe2d8d037}},	//   _равно_, _citim_, _maite_, _genere_,
   {{0x8662d007,0x75ea301d,0x729051bd,0xe2ee0182}},	//   _декабрис, _heiminum_, _falar_, _činili_,
   {{0x820050c1,0x294031be,0x729081bf,0x6200402d}},	//   _talis_, _سپريم_, _makala_, _samir_,
   {{0xe2ace144,0x4a93d0b5,0x1c764094,0x25510036}},	//   _procjeni_, _фонетик_, _बॉम्बे_, _サイトデザインが,
   {{0xa7c5209a,0xdc49d036,0xbbcfd070,0xf48d4064}},	//   _אנטיסעמי, _みんなへの一言_, _श्रीराम_, _astroloj,
   {{0xa212b0d2,0x82908074,0x2ae32195,0x73f98056}},	//   _yicha_, _nakala_, _populare, _darul_,
   {{0x925ac146,0x63eaf1a6,0x3394d080,0x00000000}},	//   _mellan_, _faites_, _minske_, --,
   {{0xe2027186,0x7635e153,0xa3957063,0x7c72a0d4}},	//   _bisita_, _ईतिहास_, _feasta_, _torrent_,
   {{0x41351108,0x04551151,0x742921c0,0xf2351020}},	//   _produkty_, _produkto_, _tempatan_, _produkti_,
   {{0xac32003a,0x3cb570e5,0x00000000,0x00000000}},	//   _kombinir, _targedau_, --, --,
   {{0xb291e041,0x82ca0019,0xf3b111c1,0x53eae1c2}},	//   _witam_, _faide_, _personál, _renten_,
   {{0x03ced163,0xd3f46045,0xa201e12d,0x22cae03f}},	//   _glover_, _sitter_, _titim_, _senden_,
   {{0x43a24150,0x63a5a13f,0x93eae112,0x1db941c3}},	//   _limpa_, _garantij, _kontni_, _interiér_,
   {{0x33eae0c5,0xc26c71c1,0xcf3581c4,0xc290f0bc}},	//   _seiten_, _jenom_, _meistara, _tagal_,
   {{0x32d6403a,0xe5ebf049,0xf68090cb,0xeae64037}},	// [140] _žalost_, _докторат, _विदाई_, _strument,
   {{0x2819207b,0x2db7d1c5,0xaa19d0dd,0xdc59d12b}},	//   _компания_, _activida, _намалува, _намалява,
   {{0x18b6b030,0xf2916074,0x67eee036,0x92fca1c6}},	//   _partager_, _magari_, _ブログトップ_, _medidas_,
   {{0x4b6f5020,0x52905051,0xefcdc063,0x7daa702d}},	//   _sistēmas_, _talar_, _الصعب_, _sistemlə,
   {{0x9c5b5135,0x5be5b008,0xc394d116,0xaabdc034}},	//   _albumid_, _kalendor, _prosim_, _кабинета_,
   {{0x2985117d,0x7771c0f7,0x727e90b0,0x00000000}},	//   _জেবতিক_, _व्याभिचा, _amand_, --,
   {{0x129270c9,0x02907020,0x62005159,0x72d9a09b}},	//   _strani_, _manas_, _salir_, _wapen_,
   {{0xf25d6129,0x8e177030,0x536f2099,0x729111c7}},	//   _divertim, _中华人民共和国商, _mongkut_, _mazat_,
   {{0xa387f14b,0x70f5a1c7,0x0a9011c8,0x1290c074}},	//   _ukuri_, _अप्रेल_, _मधुमेह_, _madai_,
   {{0xcd7d2055,0x168161c9,0x32926098,0xab6f50e9}},	//   _مجلات_, _ज्ञात_, _kirara_, _sistēmai_,
   {{0xbbe531ca,0x629031cb,0x983531c8,0x8fdc80a7}},	//   _aksesuar, _humano_, _अर्जित_, _апэраре_,
   {{0x926c7146,0x030e51cc,0xec019130,0x78b3015d}},	//   _genom_, _trebala_, _meester_, _bestefar_,
   {{0xf6645135,0x101380db,0x22fc710e,0x00000000}},	//   _miljardi, _landskro, _sengl_, --,
   {{0x139590bb,0xef72000d,0xbb0a0005,0x737b8052}},	//   _desse_, _dienoraš, _فریقین_, _semalam_,
   {{0x72907118,0x03eb904b,0x06c8a0c3,0x00000000}},	//   _danas_, _juste_, _반송비용은_, --,
   {{0xc30c2195,0x02ade0b6,0xebe40051,0x2560c0d4}},	//   _semanas_, _всъщност_, _underbar, _האנטומיה_,
   {{0x024981cd,0xff9a30f7,0x00000000,0x00000000}},	// [150] _varme_, _भक्तिमय_, --, --,
   {{0x2ef810d4,0x820120d2,0x124980c3,0x70f78089}},	//   _העיסוק_, _mayit_, _warme_, _मद्रास_,
   {{0xa28d10f4,0x7f5e91ce,0x62d84019,0x930970f2}},	//   _property_, _campeona, _rannóg_, _masarap_,
   {{0x2f82e135,0x7fa731cf,0x4212c056,0x42cc7108}},	//   _उनुकर_, _aumentar_, _ridha_, _bielsko_,
   {{0x729071d0,0xd7d93135,0xa85d91d1,0x1290c161}},	//   _sanat_, _रविकिशन_, _רשעים_, _dalana_,
   {{0xf201810d,0x72ac10d4,0x13f9b002,0xb7b6b062}},	//   _diris_, _להמתין_, _laquo_, _বিকেলে_,
   {{0x6d5a6184,0x0d0a400f,0xde17c0f6,0x83a2f0ce}},	//   _leathnú_, _paroisse_, _nimenoma, _angpa_,
   {{0xf38001d2,0x553ce126,0x82fcd099,0xc477a01b}},	//   _poprad_, _sekirany, _langid_, _проекта_,
   {{0x83ea0019,0xd06c8030,0x305ed0a1,0x929071d3}},	//   _frith_, _第二十四条_, _agentlik_, _ganar_,
   {{0x40a8304c,0xdc69705a,0xf373000b,0xa2ca6107}},	//   _контрола_, _zantray_, _članke_, _proda_,
   {{0x1b551054,0xf4ad6170,0x1a3750fc,0x00000000}},	//   _kinderen_, _vollstän, _कलेजे_, --,
   {{0x075f0059,0x9d6fe07e,0xf76620d4,0xdf6b2140}},	//   _जिन्हें_, _احضار_, _היחסים_, _karburan,
   {{0x52918026,0xc2907038,0x893e6199,0x7f1ba0d4}},	//   _mirar_, _janar_, _spomenut, _אליכם_,
   {{0x733b9135,0x423c9015,0x00000000,0x00000000}},	//   _नाशपाती_, _vammeej_, --, --,
   {{0x90bab1d4,0xe31671d5,0xdd8da0e0,0xee516008}},	//   _गठबंधन_, _pribadi_, _televize_, _patarima,
   {{0xbc65110f,0x01f97025,0xe5751193,0xae951086}},	//   _contact_, _스크랩하기_, _contacto_, _contacte_,
   {{0x3b0c2166,0xe3ea2145,0xd2d8b130,0x00000000}},	// [160] _تاپیک_, _fakte_, _gideon_, --,
   {{0xd25a90bc,0x863f31d6,0x825b612c,0xc4fdb1d7}},	//   _ugali_, _podijeli, _muflis_, _позволяв,
   {{0x8d198012,0x32fe6183,0x2387300a,0x12d9a061}},	//   _различны, _airgid_, _בינלאומי, _capel_,
   {{0xac61b1a5,0x62907100,0x8b1fc0c0,0xe64140dc}},	//   _udarite_, _sanas_, _bilangan_, _हड्डी_,
   {{0xf387f12e,0x3290702c,0xc7df1160,0x62cad037}},	//   _nkuru_, _panas_, _छुटकारा_, _credo_,
   {{0x12018112,0x837c71d8,0x2e3bc17a,0x2394d1d9}},	//   _viris_, _locatie_, _основног, _blesk_,
   {{0xe2018132,0xd22400a4,0xd7cae01b,0x76f3802f}},	//   _muziki_, _sliku_, _opiskeli, _tentokrá,
   {{0x6c67d0e4,0x92905009,0x6bb6e005,0x339421d0}},	//   _برسات_, _qalay_, _ڈبلیو_, _yoksa_,
   {{0xa26ce144,0x83ea00f7,0x92f3703a,0x47079017}},	//   _aviona_, _eriti_, _pomagati_, _памеры_,
   {{0x22ca91da,0xf2d99170,0xae5000d3,0xd9eff1db}},	//   _orada_, _essen_, _mahakama, _treninga_,
   {{0x8290c14c,0xa2ca91cc,0x127ff058,0x5c05a015}},	//   _malala_, _grada_, _neznam_, _kuasmuv_,
   {{0x4fa9303b,0x5346315d,0xfb0d00f2,0x5752d0d4}},	//   _インテリア_, _landets_, _propheta_, _קייטרינג_,
   {{0x83ea91dc,0x00000000,0x00000000,0x00000000}},	//   _arata_, --, --, --,
   {{0x1c01303e,0x6db1303e,0x22a631dd,0xead6a08c}},	//   _prostor_, _prostoru_, _timbul_, _protsent,
   {{0xd641c0b6,0x3200c196,0xeaa59067,0xc2d461bd}},	//   _втора_, _talina_, _सुन्दरता_, _jardim_,
   {{0xea5be01a,0x9f1e3025,0x00000000,0x00000000}},	//   _pangarap_, _handelin, --, --,
   {{0x73f9b009,0x9290b074,0x522671c4,0xbf3df1de}},	// [170] _raquo_, _badala_, _merkir_, _गोविन्द_,
   {{0xc68e100a,0xec127003,0x4290a186,0x57b330ba}},	//   _שוקולד_, _कृष्णपक्, _gabas_, _diputaci,
   {{0x6224806f,0xb7b5f03f,0xc4e3e17d,0x22ba70eb}},	//   _prikaz_, _startsei, _পোশাক_, _kendini_,
   {{0xf2919117,0x73ead1b9,0x1c78b012,0xd2da5114}},	//   _visas_, _preto_, _запомнит, _cateva_,
   {{0xe2918009,0x925af1df,0x996e71e0,0x23f901e1}},	//   _virar_, _dunlap_, _donnerst, _dibuka_,
   {{0xc2ca30e3,0xe2baf1e2,0x936bf045,0xc3449032}},	//   _hajde_, _tradisi_, _строку_, _vitesse_,
   {{0xe2d9e1d8,0x8c6831d7,0xb200e0f2,0x02ca704b}},	//   _laten_, _доставка_, _kanina_, _lundi_,
   {{0xa168b073,0x581b60c3,0x919b4051,0xc291a055}},	//   _програму, _포카고수가될려면_, _speciell, _sipat_,
   {{0x8cf2c019,0xa2cae16e,0xc635f0cb,0xe2e820db}},	//   _فاطمة_, _pindah_, _सराहना_, _sociala_,
   {{0x22d871ad,0x00000000,0x00000000,0x00000000}},	//   _oknem_, --, --, --,
   {{0xc386c1e3,0x4290a0b5,0x5d1c9088,0x5201816e}},	//   _storie_, _habar_, _naročito_, _mirip_,
   {{0x09a411e4,0xc37a7121,0xa741e0e8,0x6212b0d2}},	//   _април_, _katawan_, _основни_, _biche_,
   {{0x92fc7074,0xc8db710e,0x127f7109,0x0ee590fc}},	//   _mengi_, _cadeiryd, _spanja_, _दृष्टिपा,
   {{0xf2bb9099,0x62d9e03f,0xeff040a0,0x82fc7043}},	//   _sagesse_, _daten_, _lightfoo, _lengi_,
   {{0x3e2f01e5,0x3baf6035,0xb68321e6,0x1386d09c}},	//   _células_, _अवलंबून_, _फिराक_, _sverd_,
   {{0x42cad1e7,0xa47ac042,0x42e771e8,0xf386d037}},	//   _vtedy_, _промисло, _zasniva_, _avere_,
   {{0x32901002,0xf4d7709a,0x1e18501d,0xcc73e161}},	// [180] _mahay_, _אנציקלאפ, _kjósa_, _pensiya_,
   {{0x1e57d005,0xfc3960e8,0xc9c2a18e,0xc2908106}},	//   _کرپشن_, _кампания, _vozexpre, _iskala_,
   {{0x5c6e3030,0x98bed1e3,0xe2919146,0xa923d1e9}},	//   _我来说两句_, _ingestuu, _visar_, _हरिजन_,
   {{0x42d9e122,0x4278612e,0x26c6f055,0x7290a035}},	//   _baten_, _ubundi_, _kapanggi, _kabar_,
   {{0xe7b4800e,0x8b224073,0x00000000,0x00000000}},	//   _konsepsi, _compania_, --, --,
   {{0xc20250c2,0xbc774198,0x8248d044,0x3ed4517b}},	//   _teuing_, _महर्षि_, _baomoi_, _автоматс,
   {{0xb291a038,0xc249804d,0xc861b1ea,0x9dff5189}},	//   _sipas_, _farma_, _principu, _kandunga,
   {{0x8200c0b1,0x7ad0e005,0x229181eb,0xf566903a}},	//   _salida_, _کرفیو_, _garai_, _privatno_,
   {{0xa2901002,0x6b7d30fb,0x0d86f036,0x628d6061}},	//   _dahay_, _terutama_, _明日の日経平均を, _archebu_,
   {{0xf153901b,0xa30cc193,0xe354b125,0x00000000}},	//   _модель_, _canales_, _yêucahát_, --,
   {{0x5e5251ec,0xb3f401c1,0x6a604150,0x36201135}},	//   _sedangka, _postup_, _koolitus, _planeeri,
   {{0xedb97159,0xf580d059,0x9290b114,0xe290a07e}},	//   _califica, _matematy, _macar_, _babar_,
   {{0x243930c3,0xd35e201b,0x00000000,0x00000000}},	//   _인천광역시_, _никакого_, --, --,
   {{0x72926057,0xe317a10e,0xebd270dc,0xb2e681ed}},	//   _mirada_, _merched_, _पप्पू_, _bringen_,
   {{0x17d591a5,0x42d8d1ee,0xd217d02b,0xc9461087}},	//   _eksplozi, _teledu_, _прогноз_, _myelinat,
   {{0xe8311063,0x726c2070,0x52ab1052,0x722410e4}},	//   _الظروف_, _rekor_, _gendang_, _leginkáb,
   {{0xdc2dc020,0x92fdc03e,0x5378e025,0xb024106c}},	// [190] _ministru_, _ministr_, _geladen_, _צניעות_,
   {{0x226d8121,0x021c6100,0x5e711166,0xc52de01b}},	//   _meron_, _mather_, _بایگانی_, _позволяе,
   {{0xc2d9e1d0,0x729260ba,0x1200a00e,0xc3a2f002}},	//   _zaten_, _usuari_, _sabir_, _angpu_,
   {{0xa3ffa04c,0x026cd008,0xa29271ef,0x54b6a0f9}},	//   _останати_, _manome_, _naravi_, _naučite_,
   {{0xa25a506a,0x6836100a,0x3466b033,0x09dc90ed}},	//   _dalle_, _מסמכים_, _setembro_, _astelehe,
   {{0x163f01f0,0xc642c17d,0xb37a61f1,0xa1b22062}},	//   _komentár_, _বয়সে_, _lawatan_, _মাঝেই_,
   {{0xc3940019,0xc3bb20e7,0xa2026141,0xd25a502b}},	//   _poist_, _través_, _sering_, _falle_,
   {{0x6198c0bd,0x3c5c1130,0x8200c126,0x32dd8106}},	//   _हत्याकां, _bestaan_, _hadis_, _esposti_,
   {{0xf53b1030,0xf2fc6091,0xa38601f2,0x2035d133}},	//   _内容读取中_, _stoga_, _ndiri_, _推荐给好友_,
   {{0xcd4481f3,0x01b641df,0xd2ca502a,0xa200c0ee}},	//   _венесуэл, _permessi_, _halde_, _jadis_,
   {{0xe241d034,0x7201b17f,0xd7b6e009,0x51155133}},	//   _дестинац, _zavisi_, _chernobi, _抹上比萨汁_,
   {{0x7533c0dd,0x29df90ef,0x2709c0e8,0xadf05005}},	//   _поглед_, _gittigid, _религия_, _لیڈروں_,
   {{0xe044109a,0xd200c00e,0xc25a0127,0x22c5a1f4}},	//   _פרידמאן_, _nadir_, _mailo_, _bremner_,
   {{0xf291c020,0x538741a1,0xec7ea106,0x525af0a4}},	//   _divas_, _guerre_, _kunsill_, _javnosti_,
   {{0x6b9de04c,0x5225f177,0x2d053057,0x357da06d}},	//   _франција_, _eduki_, _restricc, _markalı_,
   {{0xd9d741cf,0xe348906f,0x63f141df,0x730e6036}},	//   _instalad, _recepti_, _importaz, _悩みを聞いて_,
   {{0x5cdae1d2,0x42cad117,0x12b40108,0x7586f1f5}},	// [1a0] _katalóg_, _valdes_, _ulicy_, _overrask,
   {{0x49e810d4,0xf3954146,0x83869074,0x0200a00e}},	//   _העירייה_, _flesta_, _idara_, _sabiq_,
   {{0xb26c4008,0xba97d05c,0x2a2bf062,0x00000000}},	//   _temos_, _приема_, _জয়িতা_, --,
   {{0xd668f1f6,0x99ecc030,0x526d8169,0x9f5bf0b7}},	//   _присуств, _魔兽野怪介绍_, _mazout_, _ponašanj,
   {{0x95f2e030,0xde1ac0c6,0xd9695176,0xb1b820ab}},	//   _获取免费代码_, _diberika, _similare, _मध्ययुगी,
   {{0xb3940003,0x62da71c3,0x00000000,0x00000000}},	//   _poiss_, _musela_, --, --,
   {{0x9290a005,0xe2ca9083,0xa2ca6105,0xe0879133}},	//   _abban_, _gradu_, _daode_, _并自负法律责任_,
   {{0x08abd069,0x1e9160d4,0x43ea6146,0x4b1c7075}},	//   _자기소개서_, _abstract_, _trots_, _označení_,
   {{0x94138114,0xe21140dc,0x0974206c,0x00000000}},	//   _cristian_, _कमीशन_, _האטליין_, --,
   {{0x6290a1f7,0xb26d818a,0x72e9705f,0xdcdae019}},	//   _sabay_, _veron_, _perioda_, _catalóg_,
   {{0xac4b102c,0x2b23806c,0x52e16022,0xd7a9e037}},	//   _penting_, _קאַמף_, _भावनात्म, _valutazi,
   {{0x8bd6a025,0x02927072,0x13ea906f,0x027f702a}},	//   _광고제휴문의_, _visada_, _vratu_, _spania_,
   {{0x92cbf16e,0xbd295015,0xa25a00c1,0x4d351059}},	//   _studi_, _antipope_, _naill_, _propozyc,
   {{0x0f3911ad,0x726d90cd,0x71ad3063,0xd9edc0b6}},	//   _milionů_, _beson_, _البطل_, _sinistra_,
   {{0x326190dc,0x5c915005,0x791b7125,0x729260bb}},	//   _रक्षक_, _ایندھن_, _quán_, _straff_,
   {{0x8201a079,0x437b9156,0x83cf517a,0x34efd0c3}},	//   _ispis_, _контрибу, _elever_, _관련사이트_,
   {{0x32ca70b0,0xb7d8c06f,0x93eb903f,0xefe8a070}},	// [1b0] _mande_, _današnji_, _erste_, _सुधारणा_,
   {{0xd290e052,0x0201e073,0x368e2133,0x00000000}},	//   _nafas_, _citit_, _查看该会员企业网, --,
   {{0x96824067,0x00000000,0x00000000,0x00000000}},	//   _भुलाई_, --, --, --,
   {{0x2c1db1eb,0x99482041,0x16118134,0x69c3000a}},	//   _ullamcor, _सांसदों_, _klientom_, _interpre,
   {{0x22dc103a,0x3290401a,0x03a9001a,0x37cf9012}},	//   _promocij, _kamay_, _magaling_, _varsinki,
   {{0x006141f8,0x5ef31067,0x01dcb1f9,0x67ccb025}},	//   _तुलसी_, _अधिका_, _картинки_, _노튼주니어_,
   {{0x3da900d0,0x0290c065,0x5251c144,0x0c030151}},	//   _fasilita, _sadar_, _svetitel, _sloping_,
   {{0x4200c058,0x5291e1fa,0x5292519a,0xf30e50f5}},	//   _palica_, _zitat_, _ostavi_, _paramos_,
   {{0xc12d3072,0xd38ba012,0xf2e620b6,0xf2eec035}},	//   _нафту_, _станет_, _tecnica_, _लंडनमध्य,
   {{0x03818023,0x528a7098,0xced16025,0xb2b471c1}},	//   _prezent_, _mutabani_, _상품가치가_, _konci_,
   {{0xe291d126,0xbc53e1fb,0xf843e1fb,0x5699c070}},	//   _diwar_, _último_, _últimos_, _नागरिकां,
   {{0x1b7be035,0xd1e2b15e,0x56b951fc,0x22245058}},	//   _pangeran_, _техничес, _críticas_, _kolko_,
   {{0x6b2800f1,0xfc4460cc,0xfa0171c4,0x0a93c0a7}},	//   _webadres, _serveis_, _allavega_, _доведи_,
   {{0x4847d1fd,0x9d85e14c,0xe2ca71e3,0x5b4711d7}},	//   _prilagod, _makerere_, _hande_, _кардам_,
   {{0x7d86312b,0x1efe6008,0x464e80a7,0x53ea708e}},	//   _напред_, _elektros_, _адучеря_, _kante_,
   {{0xd5a751fe,0xa3eb90e1,0xe291e00e,0x43ea71eb}},	//   _जयंती_, _vrste_, _sitat_, _puntu_,
   {{0xd291e117,0xc290e0ed,0xe290c02c,0x1c51e00e}},	// [1c0] _citas_, _nafar_, _qadar_, _ipoteka_,
   {{0x9561d01b,0x00000000,0x00000000,0x00000000}},	//   _mielestä, --, --, --,
   {{0xcb8650a4,0xad28c06b,0x985f61ff,0x72e3710f}},	//   _dovoljno_, _liknande_, _entradas_, _believe_,
   {{0x3ea18069,0xa2eca0b6,0x60593056,0xcf95f200}},	//   _부동산써브_, _notizie_, _persidan, _аушвитз_,
   {{0x73eb9163,0xc290f031,0xa3ea7163,0xcc8200d4}},	//   _gusto_, _magas_, _hunts_, _מקרקעין_,
   {{0xc25a012d,0xf3549201,0x7291c0a4,0x1200c00e}},	//   _gaile_, _sejenis_, _izvan_, _sadiq_,
   {{0x526c7195,0xc2f4c015,0x541d708e,0x7b2fa15f}},	//   _menos_, _hopital_, _verstaan_, _условите_,
   {{0x1c24206f,0xf3a42058,0x72f0d02c,0xce54200a}},	//   _financir, _financij, _istilah_, _financia,
   {{0xa344e0b6,0xeeb4e0cc,0x92db7180,0xcb64e0c3}},	//   _diverse_, _diverses_, _komunity_, _diversen_,
   {{0x7796000b,0xe2cfc03e,0xa290d202,0x54bff094}},	//   _predstav, _kancelář, _monate_, _वसुंधरा_,
   {{0x42d9f031,0xe57521c6,0x725ad203,0x383720f6}},	//   _isten_, _contrato_, _kallas_, _заранее_,
   {{0xf29031f1,0x7df8202e,0x529010d1,0x5978708c}},	//   _kilang_, _версии_, _nchai_, _valimist,
   {{0xd9f321fd,0xed3321fd,0x02ec2151,0x45a9003e}},	//   _agencija_, _agencije_, _werewolf_, _formulář_,
   {{0x32925185,0x02006015,0xd929d204,0x43eb91db}},	//   _ostati_, _nplij_, _северно_, _prste_,
   {{0x627e90f8,0xe2b22055,0xc2fd8130,0xf0ce2087}},	//   _umano_, _رهنما_, _berge_, _ribonucl,
   {{0x20f52022,0x438740be,0x3f51a18d,0x00000000}},	//   _अप्रिल_, _amerik_, _marsupia, --,
   {{0x147a81cc,0x324800b2,0x1d3d303e,0xfa000205}},	// [1d0] _postavlj, _njima_, _politice_, _dražba_,
   {{0x6609e0b7,0x23565008,0xfdee5052,0xc18e106c}},	//   _zaboravi, _adresas_, _mendakwa, _רוצחים_,
   {{0xf3b5b070,0xb594906c,0x8a012121,0x72a6600a}},	//   _ग्राहकां, _רעדוצירן_, _mahalaga_, _adobe_,
   {{0xfb7e6145,0x8131b206,0x14292052,0x33eaf0e9}},	//   _profilin_, _gledatel, _jemputan_, _saites_,
   {{0x22fcd154,0xa3a3a0c4,0xb2b42207,0xa290f18d}},	//   _keegi_, _lippe_, _आत्मनिर्, _lagar_,
   {{0x22dd300d,0x32b401a6,0x00000000,0x00000000}},	//   _крыху_, _voici_, --, --,
   {{0xc9c840da,0x5201a013,0xe522c204,0x32919002}},	//   _verdiene, _napit_, _свима_, _dasam_,
   {{0x6951f150,0xa3ea00e9,0x12366058,0xa0de515d}},	//   _kvalitee, _saite_, _svoja_, _israelsk_,
   {{0x5459c082,0x529180e9,0xc202605d,0x1ee4e0dc}},	//   _objetivo_, _varam_, _kiriya_, _सुर्खिया,
   {{0xd2908067,0xb62b500d,0x03dc1208,0x5c016209}},	//   _sakala_, _ўступлен, _nthwv_, _classes_,
   {{0xb26cd015,0x22d8d11c,0x72003186,0xb539111e}},	//   _proofs_, _nkees_, _ailing_, _bagilish,
   {{0x2290f02a,0x72919064,0xcb8ac114,0x5344520a}},	//   _dagar_, _yasal_, _сокот_, _license_,
   {{0x2291e0eb,0x5290f20b,0x8917f02e,0xfb00b20c}},	//   _kitap_, _vagas_, _другую_, _nepromje,
   {{0x2dcdc034,0x754d70db,0xd2d87022,0x526e713c}},	//   _коалиция, _verksamh, _synem_, _masoko_,
   {{0xbc68217d,0xc6b0a0c2,0x83a3a0b8,0x92ab9133}},	//   _febrero_, _المعارف_, _coppy_, _并不代表本站及其,
   {{0x2da36206,0x00000000,0x00000000,0x00000000}},	//   _naprijed_, --, --, --,
   {{0xc3806058,0xc3eae0f5,0x9387402b,0x9176719f}},	// [1e0] _blurst_, _mantas_, _sterke_, _ओबीसी_,
   {{0x04721201,0x874e20d2,0x8636006c,0x00000000}},	//   _disebabk, _undiscov, _ייִוואָ_, --,
   {{0x1003a00a,0x627f4037,0x2d8be0ac,0x00000000}},	//   _הנוער_, _eventi_, _европы_, --,
   {{0xad19a099,0x6200301c,0xe291916e,0x5012f205}},	//   _crosswor, _piling_, _pasal_, _predpiso,
   {{0x03ea9019,0xc27e9114,0x492c720d,0xe2cad122}},	//   _brath_, _umane_, _धनंजय_, _eredu_,
   {{0x170ba00a,0x00000000,0x00000000,0x00000000}},	//   _ההבדל_, --, --, --,
   {{0x4f0f206c,0xad641049,0x12018067,0x42d9012b}},	//   _טובֿים_, _инактиви, _parim_, _libero_,
   {{0x2dd2d0ac,0xdc1da03f,0x1201800e,0xf3931133}},	//   _стали_, _aktualis, _fiziki_, _分享知识和经验_,
   {{0xc26450bb,0x7290120e,0x32fc420f,0x00000000}},	//   _skulle_, _nphau_, _designu_, --,
   {{0x06bbb071,0x40b151c1,0x3157b134,0x0a14101e}},	//   _مفاہمت_, _maximáln, _pristupo, _dynastie,
   {{0xc2cad10e,0x5740512a,0xbfbe3065,0x92ea2189}},	//   _credu_, _accompag, _प्रकारचे_, _lapisan_,
   {{0xe200b054,0x04864210,0x2dcec211,0x928d6212}},	//   _kleine_, _सुधारक_, _müraciət, _ibukota_,
   {{0xdb9a2153,0xbd3a2059,0x939880dd,0xb2ea21fd}},	//   _napisano_, _napisane_, _христија, _napisan_,
   {{0x72918070,0x32267055,0x32eb1112,0xcc6f207e}},	//   _jarak_, _berkas_, _difisil_, _محیطی_,
   {{0x729160ea,0x327e614c,0x1f3fb213,0xb3dc910a}},	//   _magana_, _amoni_, _bangunan, _ntawe_,
   {{0xa874c00b,0x00000000,0x00000000,0x00000000}},	//   _гласова_, --, --, --,
   {{0x3e7a8036,0x2376e019,0x62fe6091,0x230d315d}},	// [1f0] _アイコンの説明_, _retracem, _drugom_, _kanaler_,
   {{0x97b19062,0x0fed90d4,0x00000000,0x00000000}},	//   _পেরেছি_, _בסעיף_, --, --,
   {{0x7e4f3100,0x3c49f15f,0x4650c0c3,0x8291a086}},	//   _cheangla, _средства, _전자상거래_, _espai_,
   {{0x4c8ff214,0x72909150,0xcb7bc215,0x00000000}},	//   _останува_, _ikkagi_, _متوکل_, --,
   {{0x00e1f059,0x00000000,0x00000000,0x00000000}},	//   _ewentual, --, --, --,
   {{0x73f8d1e1,0x9fd6802a,0x51e34018,0x92b4e101}},	//   _gunung_, _кваліфік, _अठारह_, _clicca_,
   {{0xe7b8912e,0x6290b01c,0xd2009015,0xe2916043}},	//   _repubuli, _nadama_, _npaim_, _dagana_,
   {{0x16ea2063,0xe2fcd072,0x00000000,0x00000000}},	//   _الجغرافي, _blogai_, --, --,
   {{0xd3949216,0xd91b809a,0x33cef002,0x3d9d0023}},	//   _vlast_, _בפֿרט_, _jihvad_, _raportea,
   {{0x2f63f0c3,0xefeeb00e,0x725a0072,0x00000000}},	//   _참고하시기_, _partlayı, _gaila_, --,
   {{0x4b2d3139,0xe96b5170,0xd39490d4,0x00000000}},	//   _sambutan_, _meinunge, _glass_, --,
   {{0x925a5170,0xc300702a,0xd29071c4,0xf2cb8161}},	//   _hallo_, _samband_, _sambandi_, _burda_,
   {{0x4291f159,0x1fafa18d,0xe2cac01f,0x82dab217}},	//   _estas_, _львові_, _madde_, _anuncie_,
   {{0x82498218,0x12927127,0x12026098,0x1f07204c}},	//   _firmy_, _misana_, _kirina_, _disponív,
   {{0x5317100c,0xf0bfc111,0x00000000,0x00000000}},	//   _shandong_, _مصارف_, --, --,
   {{0x22c3f00b,0xbc5e3219,0xf1c950f7,0x2ebc020a}},	//   _користи_, _castell_, _पद्मविभू, _opportun,
   {{0x55872005,0x8dd4d071,0xb6c921e8,0x42ca0115}},	// [200] _قارئین_, _technika, _ustašama_, _faida_,
   {{0x12916121,0x225b5007,0x4e91c125,0x0b7c1133}},	//   _gagana_, _spelar_, _chữa_, _如果您没能找到需,
   {{0xf3a9501a,0xe843f008,0x9291a1eb,0x4fb2e0d7}},	//   _madaling_, _baltijos_, _mapak_, _جداول_,
   {{0x1291121a,0xa5b78024,0xbb0d8151,0x33870108}},	//   _yazar_, _لینوکس_, _kissimme, _dobrej_,
   {{0xf3ac721b,0xbed8a0e7,0xb4b1515f,0x73032004}},	//   _grupos_, _revistas_, _descriçã, _vinasat_,
   {{0xf201e002,0x99fca127,0xb39670c2,0x3e3d004c}},	//   _dativ_, _palament, _persis_, _картички_,
   {{0x320190c0,0xf4a90177,0xe16c6012,0x7d3a2059}},	//   _tasik_, _pasahitz, _проценты_, _zapisane_,
   {{0xdc66400e,0xc291c21c,0x1344f107,0xfc1b721d}},	//   _tutulub_, _davat_, _izvedbe_, _damansar,
   {{0x230c421e,0x623661db,0x601fc024,0x00000000}},	//   _impamvu_, _tvoju_, _پژوهشی_, --,
   {{0x93ea721f,0x3b7e11c1,0xa51e106d,0xdc550220}},	//   _santa_, _ekologic, _ekologiy, _ailtire_,
   {{0xb3866043,0x429841e7,0x63ea7020,0x5ec2306f}},	//   _hvort_, _dňami_, _panta_, _stanovan,
   {{0x56186058,0xf3eb901b,0x8291121a,0x9236c135}},	//   _naslovni, _musta_, _pazar_, _hiljem_,
   {{0x5291e072,0x4517b221,0x03ea9072,0x11ba4041}},	//   _matau_, _समृद्ध_, _esate_, _napisać_,
   {{0x3f5e9038,0x5682207e,0x00000000,0x00000000}},	//   _kampiona, _همانطور_, --, --,
   {{0x5200c017,0x8f3da222,0x93eb910b,0x32ff4116}},	//   _galima_, _कालिदास_, _gusta_, _maribor_,
   {{0xdf4eb223,0xf291f173,0x00000000,0x00000000}},	//   _respekte_, _astar_, --, --,
   {{0xd16630bd,0x5291c02d,0xe3ff700b,0xb37a1224}},	// [210] _प्रतिबंध_, _davam_, _verzija_, _pasaran_,
   {{0x00a6109a,0xea672093,0x937fa052,0x92026112}},	//   _עסקנים_, _stellenb, _didakwa_, _merite_,
   {{0xe407e034,0xecc8d063,0x00000000,0x00000000}},	//   _градове_, _متألق_, --, --,
   {{0x7e9fb1a9,0x63ac71bc,0xf250c114,0x4318e17d}},	//   _módulos_, _turpis_, _легат_, _উদ্যোগে_,
   {{0x28d6d0ed,0x0291a0c0,0xfe132206,0x00000000}},	//   _estrateg, _tapak_, _strelica, --,
   {{0xb4293111,0xc2f0d225,0x00000000,0x00000000}},	//   _sampeyan_, _fatimah_, --, --,
   {{0x13eb90c2,0xe8b59025,0x17e35199,0xbe072134}},	//   _gusti_, _전체평가보기_, _oglašiva, _dospelýc,
   {{0xa2e0e1da,0xed937108,0xa26de087,0x723c90c3}},	//   _cənubi_, _listopad_, _teton_, _생성합니다_,
   {{0x329011a6,0xb83450d4,0xd2b7300d,0x00000000}},	//   _achat_, _מהתגובות_, _другім_, --,
   {{0xe9a5f226,0xfde5f1f0,0x82926038,0xf3eb7004}},	//   _diskusia_, _diskusie_, _tirana_, _beatvn_,
   {{0x574f40c2,0x1593a0a4,0xe2fd8189,0x7e45d1c3}},	//   _استدلال_, _prilikom_, _pergi_, _reklamač,
   {{0x12cb3220,0xa2574005,0x93947100,0x925a5227}},	//   _camorra_, _تاثرات_, _innse_, _calle_,
   {{0x42fd80a1,0xa200c166,0x92026196,0x8290c093}},	//   _vergi_, _nalika_, _sirina_, _boland_,
   {{0x94730056,0x32fc600f,0x33ebf14c,0x33304063}},	//   _pastikan_, _ngoga_, _butto_, _يشرفنا_,
   {{0x7bdfc108,0x82b40037,0x72250010,0x00000000}},	//   _klientów_, _unico_, _shakku_, --,
   {{0x42d9d228,0xe00350c3,0x1e622229,0xed49102b}},	//   _skynyrd_, _인기검색어_, _imobilia, _сергій_,
   {{0x13fa7002,0xf290c074,0x325a201c,0x76672049}},	// [220] _ursula_, _salama_, _bakla_, _василой_,
   {{0x9c33a09a,0x388050b5,0xe98050b5,0x7290c070}},	//   _מאפיא_, _articolu, _articole, _malaka_,
   {{0x0c57422a,0x63868052,0x831770d4,0x4e974038}},	//   _postime_, _ghazali_, _finally_, _postimet_,
   {{0x23967025,0xb9c7e22b,0x234a1213,0x63730093}},	//   _cursus_, _निश्चिंत_, _menentu_, _belange_,
   {{0x927e822c,0xb2ca518d,0x41691061,0x00000000}},	//   _sohnes_, _valde_, _pennaeth_, --,
   {{0x66264023,0x5615a06c,0x8034006c,0xc2fcf12a}},	//   _sistemul_, _צוגאב_, _קאמאנס_, _manger_,
   {{0xb25a508c,0x877f50c3,0xb2e830a0,0x225a60b6}},	//   _talle_, _서울대학교_, _fàilte_, _paolo_,
   {{0x33ac506f,0x3b6f107e,0x00000000,0x00000000}},	//   _župan_, _دسکتاپ_, --, --,
   {{0x6d30e132,0xe2a66190,0x3387809d,0x00000000}},	//   _hatimaye_, _bwoba_, _styrke_, --,
   {{0x32ca722d,0x82d9a17a,0x62925108,0x81b30062}},	//   _cando_, _adwords_, _latach_, _মুহুর্তে_,
   {{0x948bd04e,0x8ff28062,0x47fae036,0x5cf1614b}},	//   _kolonial_, _পৌঁছে_, _コメントありがと, _imiterer,
   {{0xc38af22e,0x87862024,0xd233d22f,0xd2da512e}},	//   _mòran_, _تاکنون_, _olivenol, _gatera_,
   {{0x4291e0d2,0x902d21b3,0x22aba151,0x13869022}},	//   _datam_, _zemplíns, _beading_, _tvaru_,
   {{0x32920088,0xb3ea7121,0x5201e01f,0x12925115}},	//   _napada_, _ganto_, _tatil_, _hatari_,
   {{0x08e3b00d,0xf5741144,0xaabf107e,0x214b5059}},	//   _кампаніі_, _partijsk, _اسکرین_, _stronach_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb42c8067,0x42317191,0x327e0230,0xa855d036}},	// [230] _बराबर_, _bermula_, _seinn_, _ああっ名無しさま,
   {{0xa25a51a6,0x3c64a1c3,0x1949209f,0xbb61a005}},	//   _salle_, _situace_, _प्रसन्न_, _سمیٹنا_,
   {{0x2249407b,0x5b6c7231,0x035b6063,0x54901041}},	//   _hieman_, _वासना_, _قريباً_, _चम्मच_,
   {{0x7273c0f9,0xf2cbd232,0x9a7680a7,0x00000000}},	//   _nepravil, _colonia_, _виитор_, --,
   {{0x7493f025,0xd7e27099,0x9f3dd022,0x827e21c4}},	//   _블로거뉴스_, _cinplaim_, _क्षितिज_, _tekna_,
   {{0xd236d0d8,0x4ecda0cd,0xea47504c,0x82cad1d0}},	//   _ideje_, _komision, _ситуациј, _kredi_,
   {{0x82da51ae,0x82249166,0x00000000,0x00000000}},	//   _batera_, _anake_, --, --,
   {{0xe305c019,0x325bf127,0xfe9ba233,0x03cf4223}},	//   _دورات_, _tuulo_, _seguinte_, _preval_,
   {{0xde6ca049,0x2e55c063,0x0675c133,0xdbd5b056}},	//   _облегчен, _هواتف_, _经典艺术片_, _bendahar,
   {{0x46d61034,0x137a7149,0xa2e20193,0x5c726040}},	//   _discussi, _catatan_, _calidad_, _encrypt_,
   {{0xdb168135,0x00000000,0x00000000,0x00000000}},	//   _rahandus, --, --, --,
   {{0x1db8e071,0xfae87094,0x9396703b,0x9be5b234}},	//   _valamint_, _अनुवादक_, _kurser_, _randamac,
   {{0xf264106c,0xb30cb235,0xdc6f71d9,0x42d0a062}},	//   _סנהדרין_, _poradit_, _heureka_, _নাটকের_,
   {{0x44769012,0xf31880ab,0xb38690d4,0xd3fa50e9}},	//   _процесс_, _दर्जनों_, _heard_, _satura_,
   {{0xc39600ad,0xd290c0d7,0xb292514b,0x9fbcc011}},	//   _lossis_, _salaka_, _batari_, _treniruo,
   {{0x8200c0ba,0x8c59d054,0xa7d91018,0x00000000}},	//   _obliga_, _vertrek_, _लालकिला_, --,
   {{0x0ebca0bd,0xa272a236,0x327e0237,0xa223712d}},	// [240] _publiczn, _tűnik_, _reino_, _chliceái,
   {{0x776e810f,0x925a4051,0xada8d086,0xc201e1cc}},	//   _universi, _gamla_, _activita, _zatim_,
   {{0x210c9150,0xc9c3307e,0x48be1238,0x7c6ea0d6}},	//   _महाशय_, _جالبه_, _producid, _styrkja_,
   {{0x82aa3004,0x9f02c02b,0x5cf7c01d,0xa773b07e}},	//   _vneconom, _школі_, _leitaror, _شهروندان_,
   {{0x075b4084,0xf021402b,0x00000000,0x00000000}},	//   _सतर्कता_, _квартири_, --, --,
   {{0x76e40115,0x92fdf132,0x76b22094,0x37b980d4}},	//   _kimataif, _ndugu_, _अख्तर_, _מיקרוסופ,
   {{0x4dc3a02f,0xf38690db,0x729060d1,0xfd2fe062}},	//   _podobné_, _svart_, _nplas_, _মোজাফফর_,
   {{0xb2d51003,0x6dbb8036,0x01e190fc,0x571ab0e4}},	//   _millest_, _アニメ感想_, _मदारी_, _koordiná,
   {{0x8c00b026,0x0b846045,0x314fb17d,0x725b70f9}},	//   _passant_, _рекламно, _posterio, _stalna_,
   {{0xdcec00d4,0x2202713c,0xcddc00d4,0xca5fc098}},	//   _להשקיע_, _hariri_, _להשפיע_, _entegeka_,
   {{0xa2ca7223,0x5429c18b,0x1c72e063,0xa34a00b8}},	//   _tande_, _simpanan_, _tuircis_, _gamethu_,
   {{0x99c29067,0x6290e11e,0x00000000,0x00000000}},	//   _kindlast, _kanaka_, --, --,
   {{0xb27e018c,0xa2927137,0xfbdff239,0x00000000}},	//   _teine_, _parati_, _aplikáci, --,
   {{0x82ca50fa,0x8291802c,0xfa2db012,0x12d7a23a}},	//   _halda_, _barat_, _посетите, _hjelmar_,
   {{0x7be4100a,0xfea2823b,0x13ac7020,0x686d207c}},	//   _האלבום_, _landsins_, _grupas_, _carigrad,
   {{0x227e923c,0xe2018051,0x42025037,0xed5b7063}},	//   _ilang_, _varit_, _ultimo_, _aistriú_,
   {{0x23ea5140,0xb278e10a,0x13f961b1,0xefd5d088}},	// [250] _malta_, _miliyoni_, _siguro_, _prezimen,
   {{0x169f2059,0x784070a7,0xe2018189,0xd847102b}},	//   _प्रसंस्क, _адициона, _garis_, _заявив_,
   {{0xd200c0c0,0xa09410d4,0x293a9017,0x9300e052}},	//   _talian_, _פרידמן_, _аватары_, _harakah_,
   {{0xd290e1bc,0xca67a18a,0xb968a124,0x72ca5197}},	//   _banaka_, _кризис_, _informie, _galda_,
   {{0x3dab5043,0x00000000,0x00000000,0x00000000}},	//   _menninga, --, --, --,
   {{0xd3ea707d,0x426df075,0xd2f21011,0xa291a0d1}},	//   _sante_, _मनीषा_, _якраз_, _ntxawm_,
   {{0xccd7e024,0x2423723d,0xfd6b4145,0x489b4036}},	//   _اعضای_, _ottimizz, _partisë_, _レストラン_,
   {{0xc18ac12d,0xa27e0202,0x52c300f9,0x52c271c1}},	//   _وكذلك_, _seine_, _poslana_, _kvalita_,
   {{0x625a512b,0x1147c23e,0xbc98023f,0xa26d807c}},	//   _dalla_, _назива_, _spurning_, _verom_,
   {{0xbb617240,0x8b9b2241,0xef271041,0x8974206c}},	//   _bystrica_, _diphther, _सैकड़ों_, _באגלייט_,
   {{0xf7c2e034,0x73ebf044,0x0ff5f036,0xe1dcc072}},	//   _messaggi, _btttt_, _ランキング一覧_, _хлеба_,
   {{0xf3fa7242,0x568201bb,0xa201901f,0x72fd40e6}},	//   _resumo_, _विराट_, _basit_, _adegan_,
   {{0x2291e0f8,0xb743a06c,0x7b301243,0xe30fd040}},	//   _tatak_, _טאונס_, _песок_, _bombero_,
   {{0x41bd80ac,0x0d0c5044,0x12918023,0xd972f0a7}},	//   _развития_, _starspor, _marar_, _ажутор_,
   {{0x03d7103b,0xe1b2b036,0x8201f057,0xa200d1f4}},	//   _参考になった_, _名無しさん_, _estiu_, _speis_,
   {{0x92366022,0x512c20d4,0x139420be,0x00000000}},	//   _svoji_, _הלוואי_, _fikse_, --,
   {{0xac15f070,0x9491e1c7,0x0841606d,0xaf965125}},	// [260] _साम्राज्, _कम्पनीले_, _səmərəli_, _trần_,
   {{0x1394d115,0x3201e1d0,0xc2da0112,0x48c26179}},	//   _agosti_, _fatih_, _repete_, _आउटसोर्स,
   {{0x12d821d5,0x32925244,0xf46820d4,0x63874121}},	//   _printed_, _estaba_, _התהליך_, _sheryn_,
   {{0x0291a245,0x11389055,0xf2918068,0x94aea036}},	//   _lapas_, _ابراهیم_, _karar_, _ショップで確認_,
   {{0x21a2209f,0x2a10711e,0xfc6af135,0xa2e80051}},	//   _भारतातील_, _kambanda_, _टिण्डा_, _hänger_,
   {{0x42011246,0x00000000,0x00000000,0x00000000}},	//   _nacija_, --, --, --,
   {{0x53b9b044,0xfeaa814b,0xd2cad247,0x426d81f0}},	//   _pdaviet_, _baturage_, _rhodri_, _perom_,
   {{0x927e0127,0xe3ebf11a,0x63ea9003,0x198020e4}},	//   _owino_, _kutta_, _saate_, _kivitele,
   {{0xc278b045,0xef83a05f,0xe2e80170,0xe3940130}},	//   _закарпат, _функције_, _länger_, _unisa_,
   {{0x03ebf012,0xf10cb067,0x59997025,0xf9d03204}},	//   _mutta_, _तमाशा_, _미디어로그_, _желим_,
   {{0x993411b6,0xe2918064,0x4d05d01e,0xaeda5080}},	//   _elemenat, _zarar_, _enkleste_, _виникнен,
   {{0xc8dc215f,0xe730e16f,0xc27e0127,0xf48760bd}},	//   _путин_, _novostav, _bwino_, _निकाले_,
   {{0x52918241,0x9c50106c,0xc47bd0c3,0xd27f4199}},	//   _paras_, _שמייכל_, _제휴사이트_, _krenem_,
   {{0xee92806f,0x32ea3034,0xac65f0b8,0x22cae10e}},	//   _priključ, _употреба_, _biethet_, _beidio_,
   {{0xb29191c0,0xf247a248,0x2819f0c3,0x00000000}},	//   _gasar_, _otelleri_, _크리스마스_, --,
   {{0x83ebf043,0xa9c0703e,0x3f212037,0xe743b06c}},	//   _stutt_, _účetnict, _acquista, _ראדני_,
   {{0xe993701e,0x84e1a017,0x83a290b0,0x7290b12b}},	// [270] _religiøs, _адлюстро, _chape_, _andare_,
   {{0xf291902c,0xa2ca70f8,0xf3876249,0x57a5b11b}},	//   _kasar_, _handa_, _regras_, _landslag,
   {{0x306c122b,0x83fa6011,0x3980317d,0x4dad30b4}},	//   _लालसा_, _forumo_, _পারতাম_, _kesilapa,
   {{0x02910196,0x569c207b,0x829191e1,0x2e77918c}},	//   _kabaka_, _достаточ, _dasar_, _कुच्छ_,
   {{0x8639402f,0x526c6166,0xc349e072,0x2ea4b15d}},	//   _materiál_, _kulon_, _pereiti_, _vestlige_,
   {{0x9d0a1109,0x07b61172,0x2657a12b,0x00000000}},	//   _segretar, _levering, _пролет_, --,
   {{0x6386d24a,0xd541713b,0x027e00d6,0xa55cc017}},	//   _hvert_, _लोकतान्त, _meina_, _prašome_,
   {{0x1d5ac17a,0x04aa6041,0x9c528012,0x00000000}},	//   _кожен_, _सॉफ़्टवे, _hintaan_, --,
   {{0x86f1f0dd,0x62dd8038,0x5f48b093,0x00000000}},	//   _portuguê, _raporti_, _kunstena, --,
   {{0xe348c106,0x72e8024b,0xbcc6f16f,0x5291a055}},	//   _offerti_, _händer_, _zaciatku_, _papat_,
   {{0x7346309b,0xf9bdf133,0x835420f5,0x22ee7074}},	//   _kinders_, _中国气象局_, _numeris_, _fainali_,
   {{0xc200c091,0x0d9c70b4,0x53eb8008,0x3200210a}},	//   _oblika_, _dielakka, _kurti_, _komine_,
   {{0x3e26000a,0x827e224c,0x5dfb90b5,0xd14c0072}},	//   _משפחתי_, _pekne_, _diferite_, _наколькі_,
   {{0x3965000b,0x00000000,0x00000000,0x00000000}},	//   _obnovlje, --, --, --,
   {{0xa27e322a,0x63b7908d,0xc3eae0ac,0xe59fb0f8}},	//   _bejne_, _privado_, _tuntia_, _pangunah,
   {{0xae8f3103,0xd5bf524d,0x00000000,0x00000000}},	//   _sommaren, _konfučij, --, --,
   {{0x437b224e,0x2a70f06d,0x927e0026,0x9147201b}},	// [280] _impacto_, _sayğac_, _feina_, _начиная_,
   {{0x42d981f0,0xffa54191,0x52b6524f,0x94b280b6}},	//   _okrem_, _disember_, _gradske_, _organizz,
   {{0x2dcb0005,0x71f8c019,0xb2ab8019,0x0dd620ed}},	//   _اعتدال_, _فقالت_, _cábla_, _deskriba,
   {{0x1ad99072,0x1a5ca13f,0x63eb9182,0xf8f99072}},	//   _многія_, _kolegija_, _vrsta_, _многіх_,
   {{0xa2e81051,0xa291c250,0x9a99420f,0xc30ca0d0}},	//   _gånger_, _banklar_, _titulní_, _derajat_,
   {{0x5386d23f,0xc6f64035,0xd00a812b,0x695910dd}},	//   _hvers_, _पुरवठा_, _списание_, _теренот_,
   {{0xa2b57223,0x63bff037,0x956ff037,0x3e540002}},	//   _chache_, _servizi_, _servizio_, _coupland_,
   {{0xa2d9802f,0x52fc00d8,0xac05f01b,0x00000000}},	//   _okres_, _origo_, _torstai_, --,
   {{0xcb7bd059,0x8097d15f,0x8f3e91f3,0x538691b7}},	//   _दर्शकों_, _промена_, _neprikla, _tvari_,
   {{0x93a23158,0x00000000,0x00000000,0x00000000}},	//   _pumpen_, --, --, --,
   {{0x040ae02a,0x0c754159,0xafbf71c1,0xf38660ce}},	//   _квітня_, _algunas_, _sponzoro, _elora_,
   {{0xeebb20f0,0x32cac01f,0x72f22059,0xfacde05c}},	//   _excommun, _cadde_, _कबीरा_, _посещени,
   {{0x63954144,0x5386d15a,0x44810006,0xa25ac08c}},	//   _umesto_, _tvorba_, _मिलाकर_, _kellel_,
   {{0xcb0f216a,0xa51fa005,0x6800204f,0x00000000}},	//   _corporat, _سوموار_, _trochoiv, --,
   {{0x52a63251,0x7ecdd12b,0x1b2f8252,0x9489f133}},	//   _membri_, _продажба_, _considér, _新用户注册_,
   {{0x27e650cb,0xa21390e3,0xefaa7043,0x2b977253}},	//   _शिवराज_, _bisha_, _nemendur_, _trenutno_,
   {{0x72ca91a9,0x76720005,0xc7ca400d,0x7f606240}},	// [290] _usado_, _بینکوں_, _druskini, _nespozna,
   {{0x853c8254,0x9024e17d,0xe3317133,0x42cae255}},	//   _बरोबर_, _কমপিউটার_, _国家粮食局_, _munden_,
   {{0x52d9d219,0xb9e3c187,0x3c6a8116,0x00000000}},	//   _hywel_, _покана_, _forumov_, --,
   {{0x8952c073,0x7c57423e,0x0077b15d,0x00000000}},	//   _реализат, _postaje_, _gruppein, --,
   {{0x52129098,0x22f07256,0xd3ead1ed,0xb6778045}},	//   _baahi_, _शत्रु_, _montag_, _канцеляр,
   {{0x12f1e108,0x225bf0ef,0xe201f115,0x00000000}},	//   _pomocą_, _mutlu_, _hazina_, --,
   {{0x65793036,0xbb845124,0x9fd45069,0x19c7d00b}},	//   _酢酸ビニル共重合, _beantwor, _beantwoo, _задатак_,
   {{0xadc5a0d4,0x4e96c005,0xd25ad0ac,0xdf240083}},	//   _christia, _قرضوں_, _tuolla_, _pošto_,
   {{0x3cdd117d,0x8b80d08d,0xdf33d05f,0x225a60ce}},	//   _হালকা_, _আমিতো_, _функција_, _choli_,
   {{0x5efee257,0xc24a71e7,0x04fd1063,0xb25a515d}},	//   _nóvember_, _desmod_, _بجودة_, _hylle_,
   {{0xcfb86036,0x4ed0e03e,0x4356b258,0x52eaa241}},	//   _産学連携組織_, _policejn, _caterer_, _manipal_,
   {{0xb2c3a1ab,0x2ca3e005,0x02fdc1c3,0x6b124148}},	//   _mailako_, _عارضی_, _podniky_, _تمرينات_,
   {{0x92cbf16a,0x3fe92067,0xd486a259,0x82caa25a}},	//   _study_, _स्वास्थ_, _नियामक_, _mabda_,
   {{0xd2018023,0x7a49e133,0x00000000,0x00000000}},	//   _scrie_, _个国家中排名第_, --, --,
   {{0xe2f09220,0x5c9d31bf,0x3c082040,0x32fd4031}},	//   _fabiani_, _marehemu_, _starburs, _idegen_,
   {{0xc395e009,0x929260d7,0x3559e0a7,0x0e532166}},	//   _motsa_, _paraga_, _проблеме, _rombonga,
   {{0x2ca9b13b,0x00000000,0x00000000,0x00000000}},	// [2a0] _konzumac, --, --, --,
   {{0xecd73055,0xed06e0ba,0xc913925b,0x79f9503e}},	//   _اعلام_, _carreter, _merangku, _firemní_,
   {{0xf46e81cd,0xc155d041,0x62d8c1cd,0x00000000}},	//   _frederik, _इसीलिए_, _lyder_, --,
   {{0xa291d121,0xc3ea91f4,0xcf5e025c,0x06c6c01e}},	//   _bawat_, _chath_, _vokasion, _dataregi,
   {{0xdc63d02b,0xebde225d,0x00000000,0x00000000}},	//   _репертуа, _kandidir, --, --,
   {{0x230e71ab,0x2c6921cc,0x2516a041,0x7744c005}},	//   _arabera_, _zapravo_, _शहीदों_, _تنہائی_,
   {{0x72ca925e,0x00000000,0x00000000,0x00000000}},	//   _skade_, --, --, --,
   {{0xca24c187,0x00000000,0x00000000,0x00000000}},	//   _стопанст, --, --, --,
   {{0x67cc61c2,0x4291825f,0x84ead030,0xa56ad030}},	//   _personli, _obras_, _第二十二条_, _第二十五条_,
   {{0xb24a6124,0xeae3c045,0x0da66062,0xe854c063}},	//   _firmen_, _рекламод, _প্লেয়ার_, _توجيه_,
   {{0x02a69098,0xe2fca0d0,0xc68e406d,0xdd3680b6}},	//   _alaba_, _serikat_, _teleradi, _opinione_,
   {{0x5977f15d,0xce394193,0xa2da00be,0xadda6044}},	//   _menneske, _deportes_, _lapolis_, _webketoa,
   {{0x1255a260,0x55c0d17d,0x59bf502f,0x22fa0009}},	//   _problémá, _বাইরের_, _naleznet, _liahona_,
   {{0xe2fc9202,0xcf25b12b,0x2f1160b6,0xf3f47261}},	//   _frage_, _selezion, _contatta, _hostia_,
   {{0x69049008,0x4824900d,0x8e0d0024,0xb2f01132}},	//   _сувязі_, _сувязь_, _فیلتر_, _bikindi_,
   {{0xefd711ad,0xcef110d1,0x5382d0d8,0x55706062}},	//   _protože_, _loojceeb_, _قابلِ_, _উর্দু_,
   {{0xdda4702f,0xb958d262,0x038751ed,0x3c5390e7}},	// [2b0] _reagovat_, _कहासुनी_, _zuerst_, _editado_,
   {{0xe3ce50f1,0xd25730b3,0x1485a156,0xd24a61b2}},	//   _selve_, _føler_, _букатэ_, _inuman_,
   {{0x8200c115,0xa212d099,0x8e1c1026,0xd395e0d6}},	//   _kuliko_, _ehehe_, _valencia, _altso_,
   {{0xa291c117,0x438600ac,0xbfe0017d,0xbc684024}},	//   _savas_, _koira_, _প্রমান_, _هوشمند_,
   {{0xa3065263,0x6b3c9036,0x09855246,0x00000000}},	//   _menarik_, _解決済みの質問_, _jezicima_, --,
   {{0xd291e186,0xeeda915f,0x00000000,0x00000000}},	//   _gatas_, _второто_, --, --,
   {{0x7887909a,0x837e01b3,0x5c64304b,0xc379a12e}},	//   _קעסטל_, _gajdoš_, _contenu_, _muhango_,
   {{0xaf2940f7,0x0201206f,0xf80a3264,0x06e5513b}},	//   _reporter_, _akciji_, _струга_, _द्विपक्ष,
   {{0x1936e008,0x00000000,0x00000000,0x00000000}},	//   _struktūr, --, --, --,
   {{0xb1f241ab,0x02d96067,0xb7301265,0x00000000}},	//   _planteam, _sageli_, _oposició, --,
   {{0xb43ec02e,0x5ee361c1,0x49d651ed,0x00000000}},	//   _давно_, _spokojen, _berechne, --,
   {{0xd26e6245,0xc681e035,0x57f7f18d,0x79c710b6}},	//   _autors_, _अपघात_, _грудня_, _карала_,
   {{0xd3ea9132,0x38ff00c3,0x00000000,0x00000000}},	//   _chati_, _프로그램의_, --, --,
   {{0x7863811c,0xf8999049,0xc2fc90a7,0x6c7d4031}},	//   _haistias_, _универс_, _trage_, _karrier_,
   {{0x65dd40c3,0x00000000,0x00000000,0x00000000}},	//   _처갓집양념통닭_, --, --, --,
   {{0x62aa312d,0x22fc71bf,0xbdc39225,0xbe9ed017}},	//   _وسهلا_, _bunge_, _peringka, _маглі_,
   {{0x8291e16e,0xd200c163,0x9c143005,0xa201e07d}},	// [2c0] _batas_, _dalian_, _سوچنے_, _batis_,
   {{0x5c5741ad,0x5257400b,0x82cac051,0xdf0a30d1}},	//   _postoje_, _postojal, _ladda_, _maivnyia,
   {{0x72018266,0x529181f4,0x1a05c059,0x00000000}},	//   _abrir_, _abrar_, _urzędu_, --,
   {{0xa305d023,0x00000000,0x00000000,0x00000000}},	//   _октомбри, --, --, --,
   {{0xcc1520fc,0xf70a2179,0x6aeed159,0x6290d106}},	//   _विक्रान्, _zdecydow, _tratamie, _vonage_,
   {{0xd37301a6,0x02cb8025,0x4257c267,0xdb5bf185}},	//   _domaine_, _harde_, _लागेका_, _pretraga_,
   {{0xc27e7071,0x2bde7028,0x00000000,0x00000000}},	//   _benne_, _छत्रपति_, --, --,
   {{0x2e8fd20c,0x83eb9135,0xb2d7107c,0xe3f43165}},	//   _premalen, _laste_, _verovao_, _kartı_,
   {{0x624a7268,0xcb840036,0xa26e1019,0x7394d0c3}},	//   _permet_, _ザ操作端末監視シ, _expono_, _moest_,
   {{0xa3c8716a,0x9291e149,0x92786202,0xdd7a9026}},	//   _server_, _datar_, _stunde_, _diumenge_,
   {{0xc2fe6076,0x826d1040,0x925a001d,0xf1fc208c}},	//   _drugie_, _macomb_, _skila_, _väiksema,
   {{0x2290b108,0x737ca1e8,0xd2d93036,0x7f0fd240}},	//   _dodaje_, _metalne_, _ignorer_, _opatrova,
   {{0x338ce0dd,0x4db17008,0x0632a1bc,0x22259122}},	//   _музеј_, _marijamp, _nabigazi, _noski_,
   {{0x46b2f045,0xa3fa71a6,0x68416063,0x124910d1}},	//   _редактор, _mesure_, _اللسان_, _tebmus_,
   {{0xf2d8c129,0x0f65c002,0xe069b241,0x00000000}},	//   _mument_, _seraphin, _oddparen, --,
   {{0x73aa101c,0x4c4e3063,0xc56cc01d,0x358a10dd}},	//   _maraming_, _بمعنى_, _framleið, _проблеми,
   {{0xad85c01b,0x364920c3,0xe26c60d1,0x92915269}},	// [2d0] _словам_, _촛불문화제_, _ntoos_, _engang_,
   {{0xe2896045,0x126d81ea,0x6de9d005,0x00000000}},	//   _bashkir_, _geros_, _یورینیم_, --,
   {{0x4eff80d1,0xebca115f,0xf37a5058,0x892c219f}},	//   _gaojmoob_, _продавни, _objavio_, _महाजन_,
   {{0xa429c12c,0x8c5c7062,0x6f33906c,0xe8e62101}},	//   _pimpinan_, _মুগ্ধ_, _פאלשע_, _вируси_,
   {{0xd3869175,0xfc2740cd,0xadf3912d,0x77b4918d}},	//   _umaru_, _serbisë_, _ionadaío, _armering,
   {{0x4250c243,0x8a4740c2,0xc3b3300b,0xd7ee40f8}},	//   _сепак_, _narendra_, _турци_, _katanung,
   {{0x216670d4,0xe26e6117,0x62e800c5,0xe2009099}},	//   _שיעורי_, _terora_, _männer_, _nqaim_,
   {{0x50f04263,0x1aae6112,0x79c4a26a,0x2b5bc045}},	//   _dilantik_, _eleksyon_, _rilevant, _сказав_,
   {{0x7f2170d4,0x9b47f070,0x00000000,0x00000000}},	//   _illustra, _निर्मिती, --, --,
   {{0x52ed61fe,0x72e9d044,0x62b40086,0x720170a0}},	//   _पोलीस_, _admicro_, _inici_, _plaide_,
   {{0x8c80f071,0xe292613c,0x3b47c101,0x9292714c}},	//   _سالگرہ_, _baraza_, _саддам_, _masaza_,
   {{0xb20090d1,0x562300c1,0xa2924074,0x8292612e}},	//   _nqaij_, _naturiol_, _hawana_, _maraya_,
   {{0xfa4ba0d4,0x66289251,0x904dc02b,0x726d9026}},	//   _פלילי_, _retouchi, _брати_, _mesos_,
   {{0xa317426b,0x8201816a,0xa2a051f0,0x829101e4}},	//   _zvezda_, _april_, _futbal_, _sabato_,
   {{0x32da518e,0x427390f1,0x00000000,0x00000000}},	//   _aptech_, _tekstfel, --, --,
   {{0xcf63c0bd,0xe3959034,0x97998034,0xa8be2054}},	//   _समस्याएं_, _possa_, _динамика, _handleid,
   {{0x0b6300c1,0x124970e6,0x83a3a0fa,0x52e6e069}},	// [2e0] _materion_, _dhamma_, _kippt_, _bronnen_,
   {{0x8e6c1005,0x1f1500db,0xa8e6100d,0xa3aa300b}},	//   _میچوں_, _fortfara, _заўтра_, _предсјед,
   {{0x9b6300e5,0x2ea3200a,0xd50c60b6,0xc3ec600c}},	//   _faterion_, _implemen, _espresso_, _espressi_,
   {{0x2885d017,0x7b09d036,0x0c5a0154,0x22da60c4}},	//   _быкава_, _サインイン_, _ühtegi_, _bereid_,
   {{0x5248d0a4,0x42f05098,0x3e0d21ed,0xe2d460c3}},	//   _njemu_, _kilindi_, _landscha, _gouden_,
   {{0xd0d3300b,0xcbda6017,0xb3012060,0xa27f013e}},	//   _власт_, _конкурсе_, _osobine_, _planos_,
   {{0x74a31025,0x6723d214,0xa305a0be,0xfc75e003}},	//   _대구광역시_, _компани_, _almanak_, _चुस्की_,
   {{0x82014119,0xc2245146,0xc1b3d024,0x2e7c0041}},	//   _pleiku_, _vilka_, _لاغری_, _दैट्स_,
   {{0x43b2626c,0xfd2d401e,0x915520cb,0xc39571fd}},	//   _porque_, _designet_, _गर्ल्स_, _glasba_,
   {{0x1249f0ea,0xe532402a,0xc06a301b,0x328be13b}},	//   _nyuma_, _централь, _дискусси, _údolí_,
   {{0xf236c16e,0xbf38806d,0x72fcf043,0x42bad26d}},	//   _produksi_, _resursla, _langar_, _gledali_,
   {{0x0f63c0bd,0xb26d8146,0x023fc0c3,0x7d80526e}},	//   _समस्याओं_, _beror_, _사용합니다_, _sommersp,
   {{0x22be6005,0xc2091218,0x95a220f5,0x00000000}},	//   _majdnem_, _porovnán, _рэпутацы, --,
   {{0xec4a710e,0x56e8a133,0xdc6f503a,0x00000000}},	//   _pentref_, _国家工商行政管理, _potresa_, --,
   {{0x82fc7111,0x60b0f081,0xc896b148,0x4388c017}},	//   _lunga_, _príležit, _مهاباد_, _tragedij,
   {{0x6f5d803e,0x2c18f172,0x3b619042,0xe2924163}},	//   _महंगा_, _arranger, _anklager, _nawala_,
   {{0x22e760b0,0xd27f4129,0x22cb7045,0xbb5700bd}},	// [2f0] _trennen_, _emenda_, _staden_, _पूर्णाहु,
   {{0xff58e030,0xc201e025,0x32918161,0x23462025}},	//   _notammen, _actie_, _haray_, _wilders_,
   {{0x4e405063,0x62918108,0xbc76c028,0x73ebf14c}},	//   _بجامعة_, _zaraz_, _माल्या_, _lutti_,
   {{0xb0148036,0xd89730a7,0x62e8026f,0x00000000}},	//   _このブログの更新, _аштерне_, _sønner_, --,
   {{0x327e70a2,0x5b0b5036,0xc2fe40d4,0xf27ed077}},	//   _menna_, _アプワイザ_, _various_, _fronts_,
   {{0xfc53000e,0x87b3906c,0xaa6d80e0,0x00000000}},	//   _dostuna_, _שאנסן_, _यसअघि_, --,
   {{0x23940012,0xe386012d,0xc22860e4,0x00000000}},	//   _liisa_, _boird_, _címmel_, --,
   {{0xb386d051,0x22918186,0xa7e140f7,0x45c7e01b}},	//   _flera_, _garay_, _परार्थ_, _крайней_,
   {{0xef516025,0xc73b2030,0x0af7c0b6,0x07c690c3}},	//   _클릭하시면_, _第二十九条_, _галерия_, _주상복합분양권_,
   {{0x8cfcf168,0x00000000,0x00000000,0x00000000}},	//   _балканот_, --, --, --,
   {{0x527ed270,0x56f6a035,0xbaf7a271,0xc2925012}},	//   _kroner_, _सुरवात_, _spisovat, _matala_,
   {{0x9386d185,0x9051c1f3,0x425af12d,0x7dddc036}},	//   _utorak_, _ўвесь_, _eagla_, _すべての質問_,
   {{0xa27e7051,0x9d37f17b,0xb2c1c003,0xb2eb30a4}},	//   _denna_, _личност_, _millega_, _napisao_,
   {{0x12d98045,0xaa6ab0dc,0x0395f02b,0xe25a90f4}},	//   _skrev_, _पाठशाला_, _pluss_, _shall_,
   {{0x827e010e,0x84178141,0x630d21e1,0xb2926111}},	//   _meini_, _presiden_, _belajar_, _karana_,
   {{0x33436243,0xb26d9051,0x926e61c3,0x4b186241}},	//   _governo_, _resor_, _motory_, _dagangan_,
   {{0x32e5c055,0xfab8207c,0x890b10c3,0xe0e9d036}},	// [300] _مبارز_, _privreda_, _감사드립니다_, _とりあえず_,
   {{0xe26e6144,0x425db1f3,0x7313a0d4,0x00000000}},	//   _istoku_, _sprendim, _בטיפו_, --,
   {{0xec66b170,0x00000000,0x00000000,0x00000000}},	//   _besteht_, --, --, --,
   {{0x153ab07e,0x87272095,0xe3e7c103,0x00000000}},	//   _خرمشهر_, _سرمست_, _båtar_, --,
   {{0xd692e0cc,0x229160bf,0x6f6c6268,0xcc7c521f}},	//   _navegaci, _proglaše, _vacances_, _guardar_,
   {{0xc01d003b,0xa2026151,0xa1bc80f6,0x2d02606f}},	//   _もっと見る_, _harina_, _конгресс, _pogledat_,
   {{0xf2027049,0x9743a0d4,0x62fcf16e,0x42915076}},	//   _masina_, _סאונד_, _sangir_, _badań_,
   {{0x32b66070,0xf2552135,0x834010ed,0x5c77400e}},	//   _कर्मचाऱ्, _लोकेशन_, _taberna_, _tutulur_,
   {{0xed24625d,0x00000000,0x00000000,0x00000000}},	//   _avanture_, --, --, --,
   {{0x83eb90f9,0xe3cff00b,0x335a500d,0x00000000}},	//   _prsti_, _razvio_, _полацкай_, --,
   {{0xd2cb823c,0xa85c80c6,0x00000000,0x00000000}},	//   _yarda_, _berlanju, --, --,
   {{0xe3eb9116,0xcd9d7003,0x7a0b0055,0x00000000}},	//   _vrsti_, _tunnista, _surakart, --,
   {{0x9201a272,0xbb35a0e7,0x5d19c059,0x00000000}},	//   _éxito_, _máquina_, _rekrutac, --,
   {{0xe2dc10b7,0xb977407b,0xc2915059,0x00000000}},	//   _dalmacij, _valitett, _zadań_, --,
   {{0x126cd134,0x53f471d7,0x9f4e5101,0x430dc06a}},	//   _ludom_, _nostro_, _продажби_, _михайлов_,
   {{0xcc53a0f7,0xb2f18074,0x00000000,0x00000000}},	//   _प्रेत_, _misingi_, --, --,
   {{0xf3415170,0x525b412b,0x8b8c313d,0xe291a0e7}},	// [310] _anderen_, _quella_, _राजमा_, _capaz_,
   {{0xa20c9064,0x5291612d,0x00000000,0x00000000}},	//   _herhangi_, _tagann_, --, --,
   {{0xb057c012,0xc035f16f,0x150d7235,0x2477f0dd}},	//   _милиция_, _svetovej_, _maloobch, _критериу,
   {{0xcb7d3273,0x93866023,0xa2e11041,0xb3730274}},	//   _finanční_, _flori_, _ज़मीन_, _jumanne_,
   {{0x123670be,0x5f3f9031,0x42cae239,0xe2e7118d}},	//   _sonje_, _kingitan, _londyn_, _brannen_,
   {{0x8eb1c1c6,0xa394e24b,0x500b9036,0x642e7028}},	//   _momentos_, _minsta_, _質問投稿日時_, _प्रतिभाग,
   {{0x493f006d,0x32240098,0xe2b391eb,0x17938013}},	//   _olimpiya_, _wiiki_, _handiko_, _twitteri,
   {{0xe2cae031,0xc24280f7,0x199e6045,0x0dcc306d}},	//   _minden_, _्यालय_, _повернен, _hissələr,
   {{0xc3cef02b,0x190a715f,0x5394f114,0xadb250c3}},	//   _driver_, _последен_, _cristi_, _탄핵소추의_,
   {{0xa3eb914a,0x01471060,0x22242127,0x27c71037}},	//   _casta_, _начина_, _mikka_, _начини_,
   {{0x327f41d8,0x53949074,0x59f3e020,0xe0c3e031}},	//   _dienst_, _siasa_, _francija_, _مدرسے_,
   {{0xd2c740b7,0x2341c0b1,0xf9aac073,0xba38e072}},	//   _poslije_, _komento_, _ловим_, _графічна,
   {{0x127b7275,0x056b5059,0x0639303b,0x0397c07a}},	//   _komentář, _napisał_, _ブログ内検索_, _medarbej,
   {{0x025a9045,0xb91831dc,0xbb0eb276,0x32926070}},	//   _skall_, _депута_, _klassike, _sarana_,
   {{0x6fefa075,0xe2908127,0x28713187,0xd386d081}},	//   _अपराह्न_, _kakano_, _останат_, _smeru_,
   {{0x12f77058,0x32ed4134,0x55da602b,0x32317125}},	//   _pilići_, _papiere_, _проблемн, _harmona_,
   {{0x66676277,0x02494223,0xf2bc604b,0x727ed11a}},	// [320] _साहसिक_, _chemen_, _médias_, _beene_,
   {{0x9ecd2114,0xf31de265,0x0f468211,0x00000000}},	//   _cotidian, _proceso_, _konfrans_, --,
   {{0x33eb8148,0x344ba07e,0x0380509b,0x00000000}},	//   _marto_, _اعتیاد_, _fourie_, --,
   {{0xe27e6044,0x7200d008,0x74fb3278,0x839d80f3}},	//   _sfone_, _toliau_, _खलनायक_, _proposam,
   {{0xc2cae01b,0xcd033063,0x9f3e507f,0xd3eae1e0}},	//   _niiden_, _أدناه_, _商品の説明_, _hinten_,
   {{0xc030c091,0x4c66d099,0x8aab1125,0xecf74122}},	//   _prethodn, _mentsis_, _cashfies, _sistemar,
   {{0x9e3e017d,0x68db3063,0x957c2064,0xc14ec019}},	//   _নামটা_, _الإمارات, _bankası_, _dealramh_,
   {{0x9b5c4091,0xb2d90051,0x7c74a0dc,0xa2a66121}},	//   _političk, _arbete_, _शुक्ला_, _booba_,
   {{0x13eb800d,0x62b47237,0x8ad03005,0xe2fc50c5}},	//   _karto_, _cinco_, _آرکیڈ_, _richtig_,
   {{0x53ebe202,0x520251cc,0x3c60f124,0xb26a2133}},	//   _hatte_, _istina_, _minuten_, _编辑个人资料_,
   {{0xedbce10a,0x597a6007,0x83ebe0c4,0x00000000}},	//   _athanase_, _продемон, _katte_, --,
   {{0x12494202,0xf739c193,0x726de06f,0x32927019}},	//   _themen_, _deportiv, _letos_, _sasana_,
   {{0x6e532126,0x87c35009,0x00000000,0x00000000}},	//   _sumbanga, _angghalv, --, --,
   {{0xa25b724f,0xf8988011,0xdc01c007,0xe93c3063}},	//   _kralja_, _пабудава, _danskar_, _deimhnit,
   {{0x5f25b082,0x4a6a2279,0x938071d3,0xefc12167}},	//   _selecion, _प्रशस्त_, _borrar_, _visvairā,
   {{0xcaaae006,0x55ea70dd,0x101fa04c,0x83ead034}},	//   _महिलाओं_, _проблемо, _endereço_, _mentre_,
   {{0xfc7ca186,0x537a7071,0xf26d81d9,0x00000000}},	// [330] _seksyon_, _katalin_, _kandidát, --,
   {{0xf014d1c1,0xe1ab7106,0x00000000,0x00000000}},	//   _skutečno, _kummenti_, --, --,
   {{0x82cae0e3,0x2212b074,0x53eac163,0xebe0f045}},	//   _vendet_, _machi_, _alltel_, _insekter,
   {{0xf386d23a,0xd26dc1ed,0x3290c0ce,0x00000000}},	//   _flere_, _bevor_, _atlatl_, --,
   {{0x624a622c,0x1b114186,0x42d8e0bc,0x69d88262}},	//   _airmen_, _kampanya_, _tenets_, _होमवर्क_,
   {{0x9a32e125,0x00000000,0x00000000,0x00000000}},	//   _sôcôla_, --, --, --,
   {{0x5c05a1c1,0xaa5a1073,0xc3ea6147,0x1c66a03b}},	//   _rubriky_, _гарантяз, _vyote_, _fortsat_,
   {{0xd097e12b,0x53ebf04b,0xa3878260,0xbd8d510a}},	//   _франция_, _haute_, _merre_, _demokara,
   {{0x02f7c07b,0x1b004063,0xcdd04099,0x2ef8e034}},	//   _никогда_, _الثيمات_, _motherna, _министър,
   {{0x34a8417d,0x485780e6,0xfc75427a,0xdb01c1b0}},	//   _রাক্ষসী_, _fakultas_, _algumas_, _prosinca_,
   {{0x4e2720c4,0x22d4c185,0xa22400a7,0xe8df2070}},	//   _villiers_, _priliku_, _антирусе, _विश्वचषक_,
   {{0x34691111,0x475d622f,0x5340a0b6,0x95075121}},	//   _مبارکه_, _sebilang, _diventa_, _basurero_,
   {{0xc22670f1,0x92fc0127,0xcc3af13b,0x24bdc00b}},	//   _virker_, _asiga_, _समायोजन_, _изглед_,
   {{0x656e302e,0x57130005,0xf4df0133,0x22fce27b}},	//   _компьюте, _جھگڑا_, _法定代表人_, _sengen_,
   {{0xf51901ba,0xfa03100b,0x4732712b,0x00000000}},	//   _eternulo_, _služio_, _авторски_, --,
   {{0x7c6f01eb,0x00000000,0x00000000,0x00000000}},	//   _korrika_, --, --, --,
   {{0xa6f80019,0x73ac602a,0x150bf1b6,0x362df1ed}},	// [340] _موضوعك_, _gruppa_, _postavio_, _frankrei,
   {{0xe5b191f0,0x8c0d70f6,0x1095100e,0x39868062}},	//   _technoló, _tampere_, _hadisələ, _মোসতফা_,
   {{0xc77f5030,0x127e00f2,0x7bfd5072,0x961bf1df}},	//   _请输入上图中的验, _ating_, _balandži, _resoundi,
   {{0xd3eb9087,0xd3eb8059,0xdac1c070,0x92cad1a1}},	//   _gasto_, _warto_, _दुर्लक्ष_, _rendre_,
   {{0x7305c055,0xc6c37184,0xd21c0050,0xe248e00a}},	//   _اوراق_, _tuismith, _dishey_, _animal_,
   {{0x03eb9058,0xabf510e0,0x2976812a,0x00000000}},	//   _zasto_, _produktů_, _changeme, --,
   {{0x246140f3,0x328c1132,0xe78fd062,0x00000000}},	//   _baldintz, _uhakika_, _অবিশ্বাস, --,
   {{0xf3eb81a6,0x827e023f,0xd2cad032,0x62a64115}},	//   _carte_, _beint_, _vendre_, _kombe_,
   {{0x0101300b,0x810c000a,0x38ab7030,0x6bfb7030}},	//   _свети_, _להרגיש_, _第二十一条_, _第二十三条_,
   {{0xaad7127c,0xe2eb10b6,0xa46511e1,0x994050cd}},	//   _litterat, _periodo_, _ditetapk, _siguruar_,
   {{0x828d4034,0xedd9c063,0x00000000,0x00000000}},	//   _appartam, _اتجاه_, --, --,
   {{0xd25ad16f,0x1386d033,0x1a0801e0,0x13947071}},	//   _biely_, _acordo_, _verbesse, _kérni_,
   {{0x39d0a150,0x538bc24a,0xe8104133,0xc386627d}},	//   _investee, _hæren_, _分类精彩知识问答_, _moord_,
   {{0xf25ad16f,0x82cb8164,0x7b6e7063,0x13ead059}},	//   _diely_, _aarde_, _postála_, _diety_,
   {{0x1ca66072,0x325b6075,0xab30c073,0xd27ef117}},	//   _журналіс, _anglii_, _непот_, _stings_,
   {{0x026d8108,0xd3866069,0xd27ed01b,0xaa74306c}},	//   _stron_, _noord_, _leena_, _ראַיאָן_,
   {{0x73b010d4,0x1b428200,0xa75ea022,0x9987b06c}},	// [350] _הממוצע_, _понтиф_, _अंग्रेज_, _דעגרי_,
   {{0xd2e7c012,0xe3eae071,0xa178c0be,0xe36f20e6}},	//   _олимпиад, _mintha_, _rechèch_, _dangdut_,
   {{0xc2cb821b,0x22da512e,0x03eb81eb,0xa38770e2}},	//   _tarde_, _intego_, _tarte_, _ajaran_,
   {{0xe26de08b,0xb2b47019,0xa4973006,0xfc672019}},	//   _tetor_, _rince_, _जन्मे_, _مروان_,
   {{0xd59ca087,0xf20261ca,0x00000000,0x00000000}},	//   _parenchy, _norite_, --, --,
   {{0x024c527e,0x52dab053,0x92b471be,0x227f124d}},	//   _शिमला_, _metoder_, _pince_, _subnor_,
   {{0x83a911ad,0x7224f035,0x81d5b243,0xa44911c7}},	//   _provede_, _angka_, _центарот_, _proveden_,
   {{0x03160185,0x52d5500b,0x8290c164,0x00000000}},	//   _blizu_, _oktobra_, _eiland_, --,
   {{0xa283f0b9,0x179b2243,0xb147c101,0xf3800133}},	//   _funkcia_, _авторот_, _намира_, _常州组织工作_,
   {{0x427ee051,0x3e3b21f3,0x0365612b,0x33eb90c4}},	//   _kvinna_, _remontas_, _съвремен, _gaste_,
   {{0x538691fb,0x2d5400d5,0x927f71ba,0xe2c1c043}},	//   _claro_, _गुणगान_, _chante_, _tillaga_,
   {{0x25eda06c,0xad59a234,0x2d70a1f4,0xa2bb2064}},	//   _טיקעט_, _sainmhín, _achmhasa, _genelde_,
   {{0x8532e03b,0xf27ed11b,0xb4a400d4,0x3b824191}},	//   _この回答へのお礼_, _kronor_, _באשדוד_, _dianggar,
   {{0xfa8a90e1,0xd2025242,0x45f0e184,0xccb270dd}},	//   _августа_, _artigo_, _mbreiseá, _странски_,
   {{0x53eac044,0xe291e27f,0x23eb9054,0x4b2ac0e8}},	//   _tamtay_, _batay_, _vaste_, _основнит,
   {{0x920030b2,0x2fe921f8,0x62d830a7,0x73f4627b}},	//   _uzmite_, _रोमांचक_, _numele_, _morten_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [360] --, --, --, --,
   {{0x9349e07b,0x6395f109,0xd2d8e280,0x2d865141}},	//   _hotelli_, _fluss_, _quiere_, _permaina,
   {{0x626de036,0x00000000,0x00000000,0x00000000}},	//   _netop_, --, --, --,
   {{0xb3a2318f,0x4c599281,0x16039007,0x8adfe061}},	//   _lampen_, _रामनवमी_, _поверх_, _gatehous,
   {{0x5f98006c,0xea542036,0xae006069,0x76a02005}},	//   _בעלזער_, _検索オプション_, _donderda, _صفحہِ_,
   {{0xbef1b1d0,0x0a614062,0xc758b09f,0x00000000}},	//   _merkezin, _বরাদ্দ_, _निर्दोष_, --,
   {{0x437800b1,0x02d46282,0xe347c145,0xae3b10e2}},	//   _subasta_, _jorden_, _menduar_, _peratura,
   {{0xdd055067,0x72f50119,0x4292602a,0x5ba531e0}},	//   _populaar, _vovinam_, _totalt_, _praktisc,
   {{0x12bbf04d,0xb2b51283,0xd75c006c,0x12926038}},	//   _studeni_, _vendeve_, _ספינקא_, _thuash_,
   {{0x101a2118,0xc39550a3,0xf63eb064,0xc004b148}},	//   _životinj, _viesis_, _hamileli, _تندرستی_,
   {{0x962a0202,0xac4d716a,0x6daa000a,0xbec54284}},	//   _registri, _privacy_, _registra, _streljač,
   {{0x0202714a,0x00000000,0x00000000,0x00000000}},	//   _scrios_, --, --, --,
   {{0x1548b062,0xe386c045,0x4249412a,0x00000000}},	//   _নবাবগঞ্জ_, _aldri_, _chemin_, --,
   {{0x42d201bf,0xb97e20bf,0x00000000,0x00000000}},	//   _marekani_, _групу_, --, --,
   {{0x72f1e285,0x9ba1e0bf,0x3ec611a3,0x9981704c}},	//   _koristi_, _koristio_, _negocios_, _equipame,
   {{0xc278603b,0x225ac22a,0x2aadd1b3,0x06fd1005}},	//   _grunde_, _fillon_, _štefánik_, _ٹیکسٹ_,
   {{0xd84381a6,0x4380d11c,0xff945045,0x00000000}},	// [370] _communau, _havzoov_, _величезн, --,
   {{0x9d9ee1d5,0x42c59067,0xd2fce1d0,0x94225063}},	//   _pernyata, _inglise_, _zengin_, _جماهير_,
   {{0xe7e3c034,0x3c924022,0x025a60a3,0x00000000}},	//   _полиция_, _najednou_, _skolu_, --,
   {{0xf27ec00b,0x8394e01b,0x743d0062,0xdf3ab106}},	//   _jednu_, _toisen_, _নাজিম_, _sfortuna,
   {{0xd35bf286,0x7e3d317d,0x037b0287,0xaf749041}},	//   _उद्देश्य_, _সাতটি_, _estadio_, _katarzyn,
   {{0xa4dac029,0x1ed64288,0x69fa10f2,0x0572923e}},	//   _война_, _mientras_, _marikina_, _britansk,
   {{0xb9f5713b,0x00000000,0x00000000,0x00000000}},	//   _देवेन्द्, --, --, --,
   {{0x9dafd025,0x53954157,0xf5d07020,0x0ad2f1ed}},	//   _가맹점가입안내_, _miesta_, _komentēt_, _gestalte,
   {{0x43fa6056,0x429270c0,0x0ac1c063,0x62011181}},	//   _burung_, _husain_, _فنادق_, _mobilu_,
   {{0x62cae289,0xa3eae141,0xe2494276,0xa9f7b22e}},	//   _pandai_, _pantai_, _bremse_, _baistead,
   {{0x3f38a0e0,0xdfa1715b,0x2202600c,0x32b49091}},	//   _स्थिरता_, _arreglar_, _ibrida_, _znaci_,
   {{0x53f47069,0x529180f8,0xb479f219,0xd3eae0ba}},	//   _kosten_, _hayaan_, _mireinio_, _sentit_,
   {{0xc25b4157,0x43a0b0e7,0xfef48028,0xb27e7260}},	//   _nielen_, _máximo_, _विक्टोरि, _menni_,
   {{0xd233c03b,0xb3ebf17c,0x23a2312d,0x0290c1a3}},	//   _ショッピング_, _cauta_, _sampla_, _enlace_,
   {{0xe224d072,0xdc1c00d4,0x2c62b28a,0x5897f28b}},	//   _nieko_, _מפתחים_, _forrige_, _salvador_,
   {{0x925b418a,0x0933c07e,0x89f200cc,0x30abe08c}},	//   _kielen_, _فاجعه_, _obligada_, _कुरुसी_,
   {{0xe1fd6019,0x52fab022,0xb291105c,0xfc124115}},	// [380] _ballstái, _učinit_, _locale_, _kampeni_,
   {{0x52f0d0b0,0x83ea928c,0xba6e4157,0x00000000}},	//   _viginti_, _nyata_, _profesia_, --,
   {{0xc2910069,0x2003a0d4,0x39bec28d,0x496560a3}},	//   _plaats_, _ונוער_, _videojue, _fotokame,
   {{0xe27f7005,0x6d782035,0x03b03208,0x0c1580a9}},	//   _tegnap_, _टँकरवरून_, _tomqab_, _xemphim_,
   {{0x5960f210,0x8063d00b,0x23a37105,0xaaf5008b}},	//   _रक्षाबंध, _поводом_, _suapan_, _europian_,
   {{0xe25e20e9,0xf3949019,0xb9b8a101,0xa081f02b}},	//   _ventspil, _miasa_, _ситуация, _інноваці,
   {{0xc3d12205,0x7b1fc047,0xa3fb6146,0x12918121}},	//   _história_, _kematian_, _människo, _dayaan_,
   {{0x03eb90de,0xe2a07072,0x6cca2247,0x00000000}},	//   _hasta_, _klubas_, _archifau_, --,
   {{0x0eccd1ee,0x0290e01c,0x2bfc21b7,0x43dc40d3}},	//   _annibynn, _manalo_, _doslovno_, _kamwe_,
   {{0xae8bd09f,0x12cac051,0xb30a1146,0x3ffab05f}},	//   _महात्मा_, _bilden_, _fotboll_, _развијен,
   {{0x1416a030,0x397f001f,0x02b4717c,0x12fd8065}},	//   _依法追究刑事责任_, _makinele, _cinci_, _surga_,
   {{0x4394902c,0x42d9a02a,0x0316d112,0x33eb90c1}},	//   _biasa_, _typer_, _plezi_, _wastraff_,
   {{0x32b3828e,0x73c70019,0x1a4350c3,0x732aa041}},	//   _mendigo_, _corparái, _찾아오시는길_, _साइप्रस_,
   {{0x06d35167,0x7b03507b,0x00000000,0x00000000}},	//   _procenti, _prosentt, --, --,
   {{0x9c530027,0xc200e25f,0xc3454059,0x7c7c80d9}},	//   _gustina_, _único_, _strefie_, _asistan_,
   {{0xc2bb80f1,0x32d98248,0xbecbc002,0x00000000}},	//   _ledende_, _üyeye_, _tlhingan, --,
   {{0xd26c510e,0x1bd910c3,0x00000000,0x00000000}},	// [390] _talog_, _지식전문가_, --, --,
   {{0xb27e8022,0x4ae6b035,0xb64c2005,0x00000000}},	//   _denně_, _parlemen_, _اللّہ_, --,
   {{0x22e8506f,0x85d9d073,0xeb6df28f,0x62a77196}},	//   _naslednj, _анализэ_, _यातना_, _gyabwe_,
   {{0x62d3d122,0x12eb90a4,0x226d8013,0x00000000}},	//   _kirolak_, _velikom_, _euron_, --,
   {{0x9809f15f,0x00f1112d,0xf41730c5,0x8af6610e}},	//   _предупре, _الطعام_, _menschen_, _oedolion_,
   {{0x82025015,0x1cfdc00b,0xaaf5623a,0x0ae2e18d}},	//   _fatima_, _прича_, _tilsvare, _portrett,
   {{0xfa65903e,0xb290f1f4,0x0ce4f03e,0xf36490b1}},	//   _dříve_, _triall_, _podobně_, _friggin_,
   {{0xbb711290,0xd3f9628b,0x3649f041,0xfd810038}},	//   _सिंगापुर_, _miguel_, _स्कैंडल_, _realizua,
   {{0xa2e9e1a0,0xc7601025,0x5665d1c8,0x8248005d}},	//   _peligro_, _크리에이티브_, _ट्रस्ट_, _ndimi_,
   {{0x28c35007,0xcceec00b,0xb1cb7133,0x00000000}},	//   _генераль, _америке_, _本网未注明_, --,
   {{0xf2cb40f1,0xebf3d061,0xc57640dd,0x00000000}},	//   _reddet_, _ymhellac, _realizaç, --,
   {{0xd1841228,0x8a636027,0xa106e0a0,0xd202601a}},	//   _sheasamh_, _интереса, _mechthil, _narito_,
   {{0x027f7130,0xa201f213,0x00000000,0x00000000}},	//   _maande_, _muzium_, --, --,
   {{0x6379014b,0x00000000,0x00000000,0x00000000}},	//   _basanga_, --, --, --,
   {{0x7c5c11a6,0xe25c20c9,0x6eac1034,0x0b191070}},	//   _gestion_, _poslovni_, _gestione_, _lapangan_,
   {{0x7200b220,0xf053d060,0xa316003e,0x33e2e045}},	//   _ridire_, _помиње_, _knize_, _medlemsk,
   {{0x3fcfd216,0x3395406a,0x02efd196,0x4a3b2168}},	// [3a0] _ministar_, _questi_, _minista_, _студии_,
   {{0x61978187,0x637fd043,0x437e6129,0x6386d043}},	//   _групата_, _einasta_, _professj, _hvorki_,
   {{0xf2080261,0x8c055179,0x39cd3028,0xbdd93055}},	//   _informác, _choroby_, _ढांचा_, _اتمام_,
   {{0xdb7a80dc,0xbbda80dc,0x1db64291,0x00000000}},	//   _मलेशिया_, _मलेरिया_, _felicida, --,
   {{0x08fdd17d,0x826c1145,0xf7beb030,0x52b40227}},	//   _ফলাফল_, _jahon_, _违者本网将依法追, _chica_,
   {{0xec527169,0x825a923f,0xa3ea9051,0x5c5c4071}},	//   _amatora_, _skalt_, _skatt_, _ezután_,
   {{0xe27f70ea,0x14f8c133,0x3578c133,0x62300195}},	//   _mwanya_, _第四十二条_, _第四十五条_, _chamada_,
   {{0x4ae2f292,0x4fdd3063,0xd2a65293,0xcf0b01aa}},	//   _pholainn_, _الأبد_, _volba_, _promover_,
   {{0xc26c2093,0xfa0f001f,0x3c537091,0xf542c0a7}},	//   _eskom_, _makalele, _nastupa_, _бэрбэтес,
   {{0x5f6280bd,0x526df067,0x4a038005,0xd2365236}},	//   _संस्थाओं_, _autod_, _فاؤنڈیشن_, _tolja_,
   {{0xb77b8184,0x668d60fc,0xc1cbd00d,0x366f4008}},	//   _tromchúi, _बनवास_, _біяграфі, _bendravi,
   {{0xb201817c,0x9db35250,0x88cc321c,0x00000000}},	//   _scris_, _siviliza, _najdisku, --,
   {{0xd2fc903b,0x5e529025,0xd9d630a7,0xa5ead06c}},	//   _fragt_, _써브를시작페이지, _натурал_, _יונייטעד_,
   {{0x8a7151cc,0x6b190189,0xa794123d,0xaa4ab07f}},	//   _članova_, _pasangan_, _mistoqsi, _フィギュア_,
   {{0x93947080,0x174c3063,0xefc00030,0x5015e1db}},	//   _minst_, _العفو_, _提问者对于答案的, _simpatič,
   {{0x72cae054,0x2c4cb0e0,0xe2b740c3,0x87cf1005}},	//   _vinden_, _partneři_, _권리침해신고_, _بستیوں_,
   {{0x426e60a3,0x32fc709c,0x32cff030,0x9beff206}},	// [3b0] _parole_, _mange_, _只显示最新_, _redovito_,
   {{0x62dab144,0x9d86712b,0x014ec0c3,0x5304021d}},	//   _oktobar_, _dicembre_, _저작자표시_, _didalam_,
   {{0x62bb116f,0xed0251d0,0x8609118e,0xf20260c2}},	//   _balenie_, _eğlence_, _halongvi, _narima_,
   {{0xc37a7054,0x727ef012,0x1beec017,0x26ce6059}},	//   _betalen_, _kunnes_, _малой_, _zapaleni,
   {{0x2956a012,0x00000000,0x00000000,0x00000000}},	//   _sellaine, --, --, --,
   {{0x42ee6045,0x76826187,0xab0ae06c,0x443730a5}},	//   _stoff_, _експерти_, _צוואנציג_, _concepto_,
   {{0xe2a6d078,0x72458181,0x6387f133,0x0d1db036}},	//   _osobom_, _rámci_, _heure_, _ブログに書く_,
   {{0x17a200f3,0x59d2016a,0x044a8005,0xcc58800d}},	//   _interesg, _interest, _معائنہ_, _індэкс_,
   {{0xa27f906f,0x286d7227,0xf09aa00d,0x2ebd7038}},	//   _desno_, _personas_, _стаіць_, _personat_,
   {{0x72c37071,0xebf5100d,0x00000000,0x00000000}},	//   _súlyos_, _produktų_, --, --,
   {{0xd26c2294,0xb9d7a174,0x3ec0002f,0x3c14c005}},	//   _nakon_, _प्रयास_, _zabezpeč, _سوانح_,
   {{0x6464d011,0x327e0183,0x23f461ba,0x42fc714c}},	//   _дзень_, _duine_, _mouton_, _nange_,
   {{0x2280b112,0x82ee9100,0x22292036,0x00000000}},	//   _diskite_, _stafa_, _løkke_, --,
   {{0x02cbf177,0x7defd0c3,0x1be5a0cc,0xb3eb7067}},	//   _gaude_, _하이파이브_, _sindicac, _teated_,
   {{0x4a1ec114,0xc9b14218,0xbe7141b9,0x12fc714c}},	//   _физик_, _ostatní_, _ostatné_, _kange_,
   {{0xcc93c019,0x12b60077,0xb486c065,0xe5e7d1d7}},	//   _ساعات_, _riscos_, _दिवाळी_, _санкция_,
   {{0x22a6600c,0xc250e12a,0xe2da601f,0xe8d0e12a}},	// [3c0] _globu_, _directem, _derece_, _directeu,
   {{0xf84c2025,0x1c1fd13b,0xf2d9e15d,0xafcbc045}},	//   _있었습니다_, _ट्रेडमार, _myter_, _свободи_,
   {{0x37b61150,0x23d0006c,0x85620019,0x3a79218e}},	//   _unustasi, _הצניעות_, _mballstá, _halonggs,
   {{0xd2fc905d,0x0791f034,0x7f7a410e,0x00000000}},	//   _isaga_, _costitui, _perchenn, --,
   {{0x60f1f07c,0x5b1c00c3,0xd9bf40d6,0xd2dde19a}},	//   _saradnik_, _적극적으로_, _fundarge, _oprosti_,
   {{0xd19b51aa,0xc61a7030,0xf34d620d,0x82258053}},	//   _mercadol, _评论内容只代表网, _पुरूष_, _kirke_,
   {{0x5290b135,0x0493e02a,0xae0c4036,0xedbcb131}},	//   _endale_, _стратегі, _バでブログを書こ, _paraiste_,
   {{0xb4e8009a,0x1dafb0bf,0x00000000,0x00000000}},	//   _טערמין_, _primećen_, --, --,
   {{0xeb1b0126,0x00000000,0x00000000,0x00000000}},	//   _batalion_, --, --, --,
   {{0xa23de02a,0x5581f23d,0xd341006f,0x794e407f}},	//   _співробі, _sostituz, _veselja_, _質問した人からの,
   {{0xfbf1f0fc,0x3ae2215d,0x13bc1005,0xe8d2215d}},	//   _postitus, _museumss, _بلڈنگ_, _museumsd,
   {{0xa1ff7008,0xffa15057,0x7342212b,0x6c3811b9}},	//   _papildom, _intentar_, _roberto_, _generáci,
   {{0xf2915133,0xbcd32025,0x926c21fd,0x52fc905d}},	//   _enfant_, _부담하셔야_, _zakon_, _asaga_,
   {{0x33959295,0xbb89d062,0x13dc9098,0xf2926072}},	//   _disse_, _noviembr, _naawe_, _parama_,
   {{0xeed5b0a0,0x1301f061,0x2e4e41f4,0x42c1c051}},	//   _bruidhin, _paratoi_, _afragana, _billiga_,
   {{0x7f060030,0xd00b3062,0xc2331296,0x5d192173}},	//   _采煤工作面_, _চাঁপাইনব, _formado_, _aguscear,
   {{0x23eae044,0x81521133,0xa939202b,0xb225917f}},	// [3d0] _kontum_, _已经本网协议授权, _присвяче, _niske_,
   {{0x326c2055,0x52da50db,0x7a0a21c3,0x631711df}},	//   _takon_, _hotell_, _trošku_, _bozza_,
   {{0x32c380a4,0x8bf7c073,0x23cf8154,0x7202601f}},	//   _ukoliko_, _билете_, _terve_, _harika_,
   {{0x6201e0a2,0x5bd8519d,0x72fc6059,0x427e6069}},	//   _actio_, _traditor, _drogi_, _stond_,
   {{0xe33cc12b,0xc279a005,0x00000000,0x00000000}},	//   _близо_, _felsorol, --, --,
   {{0x7225e181,0x88db110e,0x93eb11ee,0x00000000}},	//   _fotku_, _gwleidyd, _picton_, --,
   {{0x09b731a4,0x9bf6d039,0x127e907e,0x00000000}},	//   _polasaí_, _سراپا_, _etang_, --,
   {{0xd2da616a,0x5b68d0d8,0x00000000,0x00000000}},	//   _reports_, _argentin_, --, --,
   {{0x67a82023,0x0c70a0bd,0x6c800297,0xf07790d4}},	//   _februari, _मुर्गा_, _libertad_, _העכבר_,
   {{0x93fac0b6,0xaf83c094,0x637a7070,0xcc549054}},	//   _вторник_, _लश्कर_, _matakin_, _korting_,
   {{0x658ed02d,0x09679094,0x850f117d,0xa6a790d4}},	//   _akademiy, _सौजन्य_, _aprovech, _הגענו_,
   {{0x525a00f0,0xa292714c,0xd37bc1a3,0x83eb7086}},	//   _exile_, _masaka_, _espacio_, _teatre_,
   {{0x174c6059,0xa194208f,0x62928038,0x1d77f00d}},	//   _poniżej_, _membetul, _paralajm, _маўляў_,
   {{0x13ebe068,0x039470a1,0x5e473005,0x888fe298}},	//   _hatta_, _minsk_, _ہالینڈ_, _psixolog,
   {{0x43ebe08c,0xcc6ee036,0x1a6700c3,0xbef0800d}},	//   _katta_, _sporten_, _드리겠습니다_, _elektrin,
   {{0x02080299,0xa20260b4,0xac615038,0x521c60ad}},	//   _informát, _meriam_, _situata_, _nathis_,
   {{0x2ce65065,0x63da905f,0x052b604c,0x2046e106}},	// [3e0] _फोटोगॅलर, _утицај_, _conselho_, _nutrijen,
   {{0x126d81a3,0x32fc6005,0x00000000,0x00000000}},	//   _otros_, _progi_, --, --,
   {{0x0a95c22b,0xba34d036,0xe5dfa0d4,0xcb97a1b9}},	//   _आत्मिक_, _をご覧ください_, _המקבל_, _objednať_,
   {{0x03fc1106,0x39f4a070,0x2d03801d,0x03ebe190}},	//   _naturali_, _प्रशासना, _bolungar, _gatta_,
   {{0x738d6071,0xe27c2004,0xe210a024,0x00000000}},	//   _kulturál, _lênin_, _حداکثر_, --,
   {{0x9dbac002,0x00e1a0d4,0xaa3c719f,0xa3eae29a}},	//   _escargot_, _לדאוג_, _बहुजन_, _lyfta_,
   {{0x22da7203,0x1f5d11da,0xa3ebe010,0x4af7c013}},	//   _adress_, _kitabxan, _batta_, _валерий_,
   {{0x5faa5030,0xf13ba0d4,0x0a58418d,0x031d6156}},	//   _字母不区分大小写_, _ללחוץ_, _valentia_, _carcasa_,
   {{0x868c11f8,0x227e9035,0x126c824f,0x12ce218d}},	//   _नवजात_, _utang_, _sukoba_, _формальн,
   {{0x722a00bf,0xcb0fc121,0x32cbf0a3,0x00000000}},	//   _дошао_, _eraserhe, _nauda_, --,
   {{0x77fd0019,0xbd6d3017,0xb051d0f8,0x8349c284}},	//   _اتفاقية_, _канцы_, _panginoo, _izvesni_,
   {{0x64b9a156,0x630ed193,0x52fc9099,0xb26c508b}},	//   _деметра_, _tambien_, _iragi_, _kalon_,
   {{0x225bf0f6,0x9e710135,0x00000000,0x00000000}},	//   _kaula_, _बेट्ी_, --, --,
   {{0x32914113,0x3ca2606f,0x62d85031,0x6076112d}},	//   _endast_, _privlačn, _meleg_, _seapáini,
   {{0x23869051,0x62bbd130,0x250421a2,0xb3f461ed}},	//   _klart_, _bekende_, _ciallach, _fertig_,
   {{0x02fd7019,0x3631e177,0x4c75e094,0x846510c6}},	//   _leagan_, _aplikazi, _सिब्बल_, _diterapk,
   {{0x9386a0b1,0xd8c4706c,0x803730b6,0xc30eb051}},	// [3f0] _sobra_, _צװײטער_, _ristoran, _betalar_,
   {{0xd2916199,0xc2c76072,0x00000000,0x00000000}},	//   _lagano_, _засталіс, --, --,
   {{0xef34f062,0x09499077,0x00000000,0x00000000}},	//   _ছুঁয়ে_, _requerir_, --, --,
   {{0x6379505d,0x0793e091,0x00000000,0x00000000}},	//   _batanga_, _pretvori, --, --,
   {{0x62fd7100,0x4c03607e,0x00000000,0x00000000}},	//   _beagan_, _sumping_, --, --,
   {{0xd14591f8,0x427e912d,0xc407104c,0x71106191}},	//   _स्कूली_, _seans_, _comissão_, _beckwith_,
   {{0x0ff31078,0x11cc3145,0x7212d099,0x6f1fa085}},	//   _कलाकारों_, _policisë_, _neohom_, _vurderin,
   {{0x22926055,0x00000000,0x00000000,0x00000000}},	//   _kirang_, --, --, --,
   {{0x72c66145,0x115fc264,0xb0531156,0xe3207241}},	//   _publike_, _односи_, _мотиве_, _amnya_,
   {{0xcf33c0b6,0x43b9a29b,0xb957218a,0x90d7b17d}},	//   _presenta, _serveru_, _edelline, _অশ্রু_,
   {{0xc8f1c005,0xa29260f2,0x5a15210a,0x00000000}},	//   _مناظر_, _paraan_, _gitarama_, --,
   {{0xe394710a,0x5291f11c,0x84b3a07e,0x926c507b}},	//   _minsi_, _ncuas_, _تمرینات_, _haloo_,
   {{0x32ca723f,0x22026035,0x785e1036,0x2da11135}},	//   _myndi_, _varian_, _産学連携本部_, _fotograa,
   {{0x53f470a7,0xa9bec1df,0xf292717f,0x626c518a}},	//   _ajutor_, _headlamp_, _posade_, _valon_,
   {{0x526d815c,0x08dd903b,0xb201a0a4,0x9d3e404b}},	//   _euroa_, _ベストアンサ_, _novine_, _efficace_,
   {{0x4ed64276,0x54536129,0x9c6c70dc,0x7057d034}},	//   _familjun, _sovjetik, _बुन्देलख, _линкове_,

   {{0x53a1d07b,0xbd0370ba,0x00000000,0x00000000}},	// [400] _kaupunki_, _montserr, --, --,
   {{0xd4852067,0x2386629c,0xbc35617d,0x1f899045}},	//   _संपादक_, _soort_, _দলিলসমূহ_, _народног,
   {{0x1097e07b,0xac528112,0x2677203b,0x03eb9006}},	//   _времени_, _haitian_, _高等専門学校_, _listy_,
   {{0x8e420070,0x0830f25c,0x127e000a,0x4cdf0098}},	//   _शुक्रवार, _termaktu, _bring_, _yeekaalu_,
   {{0xddcb5022,0x05b8f133,0x00000000,0x00000000}},	//   _सर्वदलीय_, _元以下罚款_, --, --,
   {{0xa145226a,0xdf20613b,0xf9836150,0x37a8d00b}},	//   _materjal, _पराजित_, _konkreet, _особе_,
   {{0xc27e60b8,0x22240132,0xf378614c,0xd037c044}},	//   _huong_, _usiku_, _baganda_, _tintucon,
   {{0xf2d8212e,0xd2cb4069,0x5d00c062,0x6c4981ad}},	//   _kamere_, _bieden_, _পরাজিত_, _तुलनामा_,
   {{0x1a89716e,0xe63ca131,0x7a5d21e1,0x7248c1c7}},	//   _jaringan_, _heliconi, _diterima_, _filmem_,
   {{0x7c69f169,0x8386a06f,0x03c87150,0x3948f029}},	//   _burundi_, _dobro_, _tervis_, _комплект_,
   {{0x027e60b8,0xa2b58101,0x527f9284,0x02f420e4}},	//   _luong_, _circa_, _mesna_, _digicam_,
   {{0xa2fc70b1,0xd25ae01b,0x22b1f0c0,0x00000000}},	//   _xanga_, _meille_, _saidina_, --,
   {{0x6c5a5110,0xdf87409a,0xc3860051,0x4f8590d4}},	//   _menteri_, _ציוניסטי, _eniro_, _מורשה_,
   {{0x2efb302e,0x026ca031,0x00000000,0x00000000}},	//   _страция_, _újonc_, --, --,
   {{0x742a607b,0x6201416f,0x99e06284,0x62ea60b6}},	//   _правильн, _vidiet_, _vekovima_, _affitto_,
   {{0xc18970f8,0x50439072,0x0ef481de,0x82c1c0de}},	//   _barangay_, _каталогі_, _संस्कृति, _belleza_,
   {{0x82139186,0xd274d055,0x8226d063,0x72d82037}},	// [410] _kashi_, _حواله_, _مراكز_, _camere_,
   {{0x8c3a929d,0xb7fad009,0x6c4b1189,0xe394d0a3}},	//   _पटियाला_, _waibling, _bintang_, _viesu_,
   {{0xc2d85031,0xc3940074,0x00000000,0x00000000}},	//   _veled_, _raisi_, --, --,
   {{0x2c62129e,0x52eef0d7,0x62fdf00b,0xf26df07b}},	//   _forumun_, _atanapi_, _druge_, _auton_,
   {{0xae38f170,0xc26c51cc,0x8159c187,0x00000000}},	//   _veransta, _malom_, _насилств, --,
   {{0x13eb0012,0x32480132,0x00000000,0x00000000}},	//   _vaatii_, _mlima_, --, --,
   {{0x996431d0,0x841a2130,0xe2255036,0xd24880e6}},	//   _favorile, _moontlik, _でご注文いただく, _rahmat_,
   {{0x427ee1c4,0x00000000,0x00000000,0x00000000}},	//   _seinna_, --, --, --,
   {{0x73fe1133,0xc27e6044,0x44b530dd,0x00000000}},	//   _日一周时政要闻_, _xuong_, _мурињо_, --,
   {{0xa59c9030,0xde9b10b1,0xee50a090,0x927f012a}},	//   _修改删除记录_, _bindings_, _कृष्णप्र, _grands_,
   {{0x53e2c070,0x585c907b,0x427f903a,0x88561045}},	//   _गृहमंत्र, _maalisku, _desni_, _сковород,
   {{0x459ef03b,0xd2fb01f4,0x87aa70da,0xaae3e17b}},	//   _クレジットカ_, _tighinn_, _instelli, _интереси,
   {{0x09415172,0x531311a3,0xe27e9113,0xf22b421c}},	//   _billette, _cambiar_, _saknar_, _upraviť_,
   {{0x3855d29f,0xbcaba2a0,0x00000000,0x00000000}},	//   _गर्लफ्रे, _menyadar, --, --,
   {{0x24f850eb,0x727e6004,0x32ebb241,0xbc07d01b}},	//   _otomobil_, _suong_, _fizikal_, _tekstit_,
   {{0x93c450e1,0x5ac0508c,0x939572a1,0x7eb36076}},	//   _револуци, _pakkumis, _flasin_, _chronion,
   {{0x2607b135,0x98f6106c,0x00000000,0x00000000}},	// [420] _आनंदे_, _ריטשארד_, --, --,
   {{0x5b64300e,0x73f46255,0xc9c4b023,0xa0e78133}},	//   _fondunun_, _nettet_, _rezervat, _页面访问量_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x52fce0e2,0x827e60b8,0x62d83195,0x2c194045}},	//   _tinggi_, _tuong_, _valores_, _grupper_,
   {{0x32cb7172,0x41b3d034,0xbc677010,0x12fce0b8}},	//   _stadig_, _доволен_, _victors_, _kangta_,
   {{0xa27e920e,0x4057807c,0x7ab1915f,0xaa5cc0d9}},	//   _muang_, _inostran, _областа_, _kosmofys,
   {{0x5d2382a1,0xf0c4d09f,0x5ae53114,0x00000000}},	//   _mitrovic, _परिच्छेद, _sigurant, --,
   {{0xd341e0bd,0xd26e6025,0x5507f136,0x73ebe053}},	//   _allegro_, _jeroen_, _dihedral_, _nytte_,
   {{0x922411c1,0x57c24067,0xb68790f5,0x9200b067}},	//   _regionál, _महानुभाव_, _назваў_, _endine_,
   {{0xb3f98263,0x244240c3,0x96cc0017,0xf27e7175}},	//   _payung_, _사회복지과_, _кантроль_, _munne_,
   {{0xd2003020,0x21003108,0xfee030e9,0xa9803020}},	//   _konkursi_, _konkursy_, _konkurss_, _konkursa_,
   {{0x120011bc,0x443032a2,0x617db0d4,0x13203077}},	//   _behin_, _concurso_, _מיזוג_, _concurs_,
   {{0xcfb840e7,0xec68d146,0x9c361219,0xcad730f3}},	//   _países_, _augusti_, _grantiau_, _bistarat,
   {{0x3d882036,0x227e007f,0x00000000,0x00000000}},	//   _質問者のみ_, _trine_, --, --,
   {{0x927e911c,0x05807126,0xa57cc036,0x52d9b12a}},	//   _luang_, _televisy, _ジに対するお問い, _bernard_,
   {{0x927f4274,0x59b96101,0xfa89b042,0x1a67a02b}},	//   _kwenda_, _растител, _europeis, _begått_,
   {{0xc20020d7,0x9290c1ab,0x237b2196,0xd4cb80c3}},	// [430] _lekin_, _halako_, _musango_, _멀티미디어_,
   {{0x4cec104c,0xf201e031,0xf36480f2,0x25df6019}},	//   _компаниј, _akció_, _tingnan_, _innealtó,
   {{0x927ef045,0x2753f116,0x1f71c030,0xfc91e2a3}},	//   _hanner_, _tehnolog, _concours_, _अवरोध_,
   {{0x8d3c3090,0x269c81b6,0x00000000,0x00000000}},	//   _velikost_, _proglasi, --, --,
   {{0x77b55062,0x3394004a,0xe7e1f2a4,0x674de07f}},	//   _নিউইয়র্, _naist_, _अर्धांगि, _マンスナイプ_,
   {{0xd248d1d2,0xe72140dc,0x801db0b1,0x026c207d}},	//   _ideme_, _तेज़ी_, _tradisyo, _lemond_,
   {{0xbf66c0bf,0x56d2e084,0xae1ce299,0x259b30f3}},	//   _имали_, _रोहित_, _pergunta, _horrelak,
   {{0xd27e7045,0x6d22b006,0xab085036,0xacbb5005}},	//   _kunne_, _zagranic, _アルバイト_, _یہودیوں_,
   {{0x82adc12d,0x62787276,0x23f40091,0xd85960a1}},	//   _الذات_, _barnet_, _nastup_, _kitablar_,
   {{0x03ce0223,0xbae06276,0xbdf15135,0x93878150}},	//   _prive_, _samuelse, _moodusta, _korra_,
   {{0xbdc5e223,0x68e2f073,0xadfd107c,0x0672718a}},	//   _elektora, _депутаци, _usmerava, _windowsi,
   {{0x858451f0,0x4407e0dc,0xc9d85132,0x74860070}},	//   _fotogalé, _बलिदान_, _kutekele, _ड्रामा_,
   {{0x6303f0eb,0xf173616f,0x8471a06f,0x13ac00c3}},	//   _teknoloj, _pomníky_, _klasične_, _lippen_,
   {{0x1387e05c,0xd6727099,0x443ec15f,0xd3eb7088}},	//   _oltre_, _waldensi, _разно_, _odatle_,
   {{0xb2f45019,0x3d98e15c,0x00000000,0x00000000}},	//   _chuntas_, _начинающ, --, --,
   {{0xe343b12d,0x00000000,0x00000000,0x00000000}},	//   _بتوقيت_, --, --, --,
   {{0xabfa5004,0x67e63035,0x5e73c133,0xad47c05f}},	// [440] _vietcomb, _लोकरंग_, _构建社会主义和谐, _ekspedic,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x749cd072,0x4b0ce03a,0xfefa0261,0x3271b219}},	//   _алена_, _sposobna_, _prejedan, _mabinogi_,
   {{0xd2fc703b,0xe1511156,0x71d9d03f,0xfb67d1a2}},	//   _gange_, _лдовенеш, _willkomm, _centrica_,
   {{0xe27e90b8,0x43ce9199,0x1f6940dc,0x4061d04c}},	//   _quang_, _stavi_, _दीनदयाल_, _штета_,
   {{0x85f631d9,0x63178233,0x3c0b1069,0x72fc714c}},	//   _veteriná, _forza_, _stappen_, _aange_,
   {{0x82fc7098,0x89d93043,0xc8b96133,0x222421df}},	//   _bange_, _seinasta_, _第四十一条_, _makku_,
   {{0x8972715f,0xb3fa61e8,0x52b4d0bd,0xae56b12a}},	//   _редакциј, _veruje_, _niech_, _dimanche_,
   {{0x5f4e004b,0x1ae1c1f4,0xbe452052,0x0c739211}},	//   _personne_, _milligan_, _gelangga, _kadrlar_,
   {{0xd2fc714c,0xda115063,0x70b670d5,0xf27e90e2}},	//   _wange_, _الذاكرة_, _बाहुबल_, _ruang_,
   {{0xf3a3f059,0xc7e0a018,0x5c605109,0x6c29e26d}},	//   _grupy_, _नववर्ष_, _sigurta_, _proizvod_,
   {{0xec5b81c1,0xb27e6002,0xe2d8000c,0x4f5811f0}},	//   _dostali_, _ngong_, _glied_, _označeni,
   {{0x69fe6177,0x6e169034,0x3d838063,0x27273009}},	//   _ekonomia_, _значение_, _gaileara, _ahmeydaj_,
   {{0x9b73e0a7,0x74075084,0xe27e625c,0x02fc7098}},	//   _ротару_, _रामदेव_, _agong_, _zange_,
   {{0x2588d04b,0xedc5d063,0xd2925121,0x0f7610d4}},	//   _activité, _طبعاً_, _bataan_, _השלטון_,
   {{0x42131054,0xa477a01b,0x00000000,0x00000000}},	//   _lachen_, _проекты_, --, --,
   {{0xec55b0d4,0xb6ee5017,0x00000000,0x00000000}},	// [450] _instead_, _спаборні, --, --,
   {{0x13ead0a4,0xb2f52019,0x42002043,0xf2025037}},	//   _protiv_, _laistigh_, _tekin_, _ultime_,
   {{0xef24809a,0x447de108,0xa2c9410e,0xd201e023}},	//   _יעקבסאָן_, _यमुना_, _pellach_, _activ_,
   {{0xfc0a6276,0x6730706a,0x72b59033,0x4e4520fb}},	//   _berthels, _репортаж_, _risco_, _pelangga,
   {{0xc21370b4,0x3200207b,0xb5f630ff,0x407602a5}},	//   _arahan_, _sekin_, _veterinä, _aksesuār,
   {{0x5290914c,0x1c6642a6,0x3576412b,0xf17da062}},	//   _imaam_, _gratuit_, _gratuito_, _আঞ্চলিক_,
   {{0xe26ca163,0x5f4631ba,0x00000000,0x00000000}},	//   _sabon_, _aristide_, --, --,
   {{0x1394616a,0xd19cc063,0xc2fa0175,0x0367c17d}},	//   _those_, _ولذلك_, _swahaba_, _দুঃখিত_,
   {{0x794f702f,0x12a7f20b,0x50cf7185,0xa255e063}},	//   _samostat, _clube_, _samostal, _conclúid_,
   {{0x37803012,0x4db54141,0xeb2dc0f8,0xabe091d8}},	//   _управлен, _meningga, _simbahan_, _genetisc,
   {{0xf3ddc002,0x1145505b,0x968650c1,0x016c207e}},	//   _suvwi_, _espesyal, _academai, _مقايسه_,
   {{0xe177200b,0x8dbc20d4,0x0887a25d,0xf2cb4185}},	//   _често_, _ההחלטה_, _čokoladn, _gledam_,
   {{0xa3eb9090,0xd7c06133,0x00000000,0x00000000}},	//   _byste_, _抗震救灾特别专题_, --, --,
   {{0xd4bfb2a7,0x74001012,0xd2e1316e,0xbc7dc003}},	//   _संवेदना_, _песни_, _spanyol_, _पार्श्वग,
   {{0xd431e059,0xd29040d7,0x9e51e108,0xa301e153}},	//   _ostatnio_, _neman_, _ostatnie_, _ostatni_,
   {{0x8212b230,0x202ed02b,0xf5d2e2a1,0x124f8024}},	//   _eadhon_, _назву_, _studentë, _غذاهای_,
   {{0x9303001a,0xac76513f,0xaeec4030,0xe851215e}},	// [460] _salamat_, _forumas_, _编译或摘编自其它, _абхазия_,
   {{0xabf7d119,0x325ae130,0xf0e7b045,0x00000000}},	//   _geleximc, _stilte_, _претенду, --,
   {{0x52926186,0xad5ae2a8,0xcf47d08c,0x00000000}},	//   _karaan_, _महाभारत_, _saksamaa, --,
   {{0xe5731058,0x89b70166,0xbcbed0dd,0xf2d9017a}},	//   _amatersk, _سامسونگ_, _надеж_, _arbeid_,
   {{0x129020b2,0xafc2d005,0x62a7f18d,0xd2025038}},	//   _rekao_, _باجوڑ_, _klubb_, _botime_,
   {{0x99fa3117,0x2e389015,0xe3f47250,0xe200510e}},	//   _starptau, _irenaeus_, _dostun_, _melin_,
   {{0x9343c2a9,0x55707121,0xba1052aa,0x0e2c40bd}},	//   _положај_, _mandaluy, _estabele, _अपेक्षाक,
   {{0x043632ab,0xe2d96268,0xe76c517a,0xda19315b}},	//   _praktick, _argent_, _вітчизня, _disculpe,
   {{0xf87cc045,0x48fe1146,0xce5ab00b,0x3b72906c}},	//   _поставле, _nuvarand, _продуцен, _מיטהאלטן_,
   {{0xb349c106,0xc2ac402b,0x4c0fb131,0x868cc067}},	//   _livelli_, _контроль, _uaigneac, _नादान_,
   {{0xc698c15f,0x820050db,0x00000000,0x00000000}},	//   _предвиду, _telia_, --, --,
   {{0x2386a04d,0xbb34315c,0x5394b130,0x966d0063}},	//   _dobri_, _интересн, _meeste_, _اليسا_,
   {{0xe6e60063,0xbca43017,0x72d55087,0xff24702f}},	//   _هههههه_, _англійск, _istorya_, _brány_,
   {{0x1d032055,0x225a426d,0x677610d4,0x00000000}},	//   _خدمات_, _probuši_, _סבלנות_, --,
   {{0xb55dc18a,0x226df07b,0x00000000,0x00000000}},	//   _вполне_, _autoa_, --, --,
   {{0x427e90f8,0x39e4a03b,0x9adb8070,0xe2b180fe}},	//   _ngang_, _ありがとうござい, _अन्यथा_, _pridala_,
   {{0x484ed15f,0xfc124074,0xc290d277,0x82fd50a1}},	// [470] _publicid, _kampuni_, _ब्रोकर_, _ingilis_,
   {{0x12245108,0xa2fe70a6,0x2e2e0002,0x49dfa074}},	//   _walki_, _margar_, _polonyus_, _kugombea_,
   {{0x5e03006b,0xed73226b,0xb8c3001d,0xa70dc06a}},	//   _foreldra, _posmatra, _foreldru, _кадри_,
   {{0xf229c26e,0x7c143133,0x026ea17c,0xc26cc0be}},	//   _række_, _没有相关文章_, _majuscul, _padon_,
   {{0x18c40041,0xf2fc7159,0xc2d91071,0x48a14023}},	//   _ओलंपिक_, _manga_, _emberi_, _ымпутерн,
   {{0x40ea90af,0x3713b036,0x75e8d06d,0x00000000}},	//   _समीक्षक_, _アビシニアン_, _dekabrın_, --,
   {{0x117c306c,0xb394e059,0x935b816c,0xe1579067}},	//   _עמוירדזש, _blisko_, _zeemzeeg_, _मल्लाह_,
   {{0x92fc70fa,0x13075025,0xe9c9b091,0x7db542ac}},	//   _ganga_, _limburg_, _odgovara_, _peningga,
   {{0x820050ef,0x5e01a0a7,0x7bd3e18a,0x00000000}},	//   _gelin_, _асигурэ_, _огромное_, --,
   {{0x727e6130,0xe387c1c1,0xc2e37093,0x805ff062}},	//   _grond_, _stará_, _komitee_, _আইনজীবী_,
   {{0x1dabc141,0x6e97d00a,0x75acc0dc,0xb5d9c0c3}},	//   _kehidupa, _contract_, _धरातल_, _크라운제이_,
   {{0xdb313005,0x8c254172,0xbefd50c3,0xcb44401b}},	//   _جنگجو_, _kombiner, _확인하시기_, _интересо,
   {{0xff21e0da,0x127ed106,0x02d8910e,0x00000000}},	//   _rotterda, _ateni_, _gwaed_, --,
   {{0x52bb1085,0x347e500a,0x92495045,0xd96f72ad}},	//   _seneste_, _ישראליות_, _fremst_, _acontece,
   {{0xa2887030,0xc47c7067,0x62005061,0x137f301f}},	//   _fichier_, _प्रतिच्छ, _delio_, _almanya_,
   {{0xde43516a,0x2f435170,0x8290401f,0x0dbfa0a7}},	//   _password_, _passwort_, _kemal_, _адоптэм_,
   {{0xbb81b0a9,0xda56006c,0x42a75024,0xef6ba017}},	// [480] _mainboar, _זשערסי_, _nyebut_, _скончыў_,
   {{0x779d907a,0x9c5e304b,0x00000000,0x00000000}},	//   _トラックバック_, _portail_, --, --,
   {{0x7c54a10e,0x00000000,0x00000000,0x00000000}},	//   _gostwng_, --, --, --,
   {{0x727e6042,0x14d7700a,0xe36ab030,0x7b7b8047}},	//   _trong_, _אנציקלופ, _文化东路街道办事, _biasanya_,
   {{0x92efe211,0x923680ce,0x72c1c250,0xaa7b2090}},	//   _turniri_, _dahjaj_, _dollara_, _opište_,
   {{0x92d80130,0x125ad0cd,0x35a95157,0x00000000}},	//   _kliek_, _sjell_, _formulár_, --,
   {{0xec6a50d5,0x286860f7,0xa2a75136,0xdc32d114}},	//   _गुड्डू_, _ekspress_, _liebes_, _stabilir,
   {{0x3972c168,0x1c10d1c1,0x73966051,0xcda2d024}},	//   _интегрир, _displej_, _norska_, _واکنش_,
   {{0x77e7215f,0x367f6177,0xdd40f019,0x37879133}},	//   _архива_, _venenati, _tugaimid_, _型男大主厨_,
   {{0x8ae2613b,0xcbe0e064,0x00000000,0x00000000}},	//   _पर्यटक_, _istekler, --, --,
   {{0xfed951cb,0xa740c030,0x57be5008,0x00000000}},	//   _artistas_, _科学技术部_, _žurnalis, --,
   {{0x3e48e144,0x69f7b1c1,0x2a08e1e8,0x69ec807e}},	//   _omladine_, _dodavate, _omladina_, _فدراسیون_,
   {{0x017d909a,0x6947e15f,0xd2909130,0x22787062}},	//   _עירוב_, _предлог_, _smaak_, _সাময়িক_,
   {{0xe95141e3,0x66e2f1ad,0x4d9b406c,0xb4041041}},	//   _verseker_, _životníh, _עקזעקיוט, _खुशदीप_,
   {{0x9200719e,0x56865173,0x00000000,0x00000000}},	//   _tenia_, _acadamai, --, --,
   {{0xcf7c60bd,0x527de059,0xb2907048,0xe386a0a4}},	//   _शिक्षकों_, _pamięci_, _kenan_, _dobru_,
   {{0x1e5820f5,0xaf253064,0xc471a06f,0x86e62159}},	// [490] _насельні, _smileler_, _klasični_, _suscribi,
   {{0x1f2e32ae,0xfee50070,0xb020d051,0xd9fa90f8}},	//   _comunida, _राष्ट्रा, _andersso, _pelikula_,
   {{0xc3a912af,0xbde9116a,0x225ae103,0xff99116a}},	//   _provide_, _provided_, _skilja_, _provides_,
   {{0x72fcd135,0x3faae008,0xf22590bb,0x32fae059}},	//   _isegi_, _informuo, _fiska_, _informuj,
   {{0x7290312c,0x48eec063,0xfeeed063,0xdfcc7151}},	//   _semasa_, _تصنيف_, _الخنازير_, _pacifier_,
   {{0xa25ad24a,0x72ad9088,0x37cad130,0x4394714c}},	//   _heller_, _nekadašn, _gunsteli, _wansi_,
   {{0x9ccc1060,0xbc757100,0x00000000,0x00000000}},	//   _служи_, _adhradh_, --, --,
   {{0xc580213e,0xaf2201fb,0x03eab0da,0xf2d4b1c1}},	//   _informaç, _realizar_, _beetje_, _kvalitu_,
   {{0xe27ee0be,0x03f4703f,0xf84fd0e5,0x726cc1be}},	//   _mennen_, _ersten_, _ymholiad, _palota_,
   {{0xe2cab2b0,0x51cfd17c,0xd2d8c14c,0x00000000}},	//   _fredag_, _адаптат_, _tuleme_, --,
   {{0x12d84202,0x727f72b1,0xb27ee03f,0x0290e05f}},	//   _immer_, _uwanja_, _meinen_, _finalu_,
   {{0xcd4141da,0x9395923d,0x722580d6,0x72cae2a1}},	//   _edərkən_, _fissi_, _virki_, _mundet_,
   {{0xdbf9f24f,0x283240c3,0x6b01c0a9,0x23eae10e}},	//   _započeo_, _잊으셨나요_, _naiscorp_, _menter_,
   {{0xa7c0d17d,0x79c522b2,0xd27ef099,0x95b4d071}},	//   _আবারো_, _alternat, _bannor_, _techniká,
   {{0x83948121,0x9f4c303b,0x22bd400d,0x9d26a0bf}},	//   _hanggang_, _ガイドライン_, _насамрэч_, _селектор_,
   {{0x48c531aa,0xbe0220df,0xa3fa0190,0x826a106d}},	//   _reservad, _प्रकाशित, _yusufu_, _amerikal,
   {{0x6d30217d,0x53f45053,0x52293071,0x62572080}},	// [4a0] _বঙ্গবন্ধ, _gutten_, _jövedele, _sølvi_,
   {{0xad0fa00a,0xf50cd108,0x2394f00b,0x00000000}},	//   _עמותת_, _automaty, _spisak_, --,
   {{0x8ee7b1fd,0xb3fd6030,0xb987b0f9,0xab6e4075}},	//   _prikazan, _国家发展和改革委, _prikazat, _पालना_,
   {{0x7d1360cd,0x19805069,0x5d3f2024,0x73942186}},	//   _konsider, _artikele, _اسکریپت_, _laksi_,
   {{0x23eae0ac,0x9ecb9115,0x4300814a,0xd3273035}},	//   _tuntuu_, _kulingan, _tapaidh_, _unicast_,
   {{0x3290e257,0x02cae255,0x23031038,0x73401192}},	//   _annars_, _fundet_, _allahut_, _licenza_,
   {{0xc27ee170,0xaacfe1c3,0xb94890e0,0x75eb30c3}},	//   _kennen_, _medicína_, _हालसम्म_, _공정거래위원회_,
   {{0x4978610b,0x027e904f,0x224941ba,0x69d8703f}},	//   _administ, _trang_, _premye_, _lieferze,
   {{0x127e9065,0x927ee2b3,0xbeb041b7,0xa27e900a}},	//   _urang_, _keinen_, _vlastite_, _brand_,
   {{0xdc1c31d2,0x93959043,0xc8fe10a2,0xb045c025}},	//   _nitrians, _vissi_, _dadansod, _overigen,
   {{0xd9a3f1ea,0xaee531f3,0xc2cae014,0x32489115}},	//   _мерапрые, _этнограф, _kender_, _alama_,
   {{0x62007111,0x396d60e7,0xf3796131,0x1316d0cd}},	//   _tenin_, _habitant, _furasta_, _poezi_,
   {{0xe74ed029,0x42bf3148,0x09bed063,0x42af713b}},	//   _прави_, _امثال_, _تحضير_, _orlicí_,
   {{0x22fce0c0,0xb5a1f179,0xd9d07024,0x3394812c}},	//   _mangsa_, _बताती_, _gazettee, _laksda_,
   {{0x79765243,0x94d5911f,0x33b27163,0x846450dd}},	//   _atendime, _केमिकल_, _bisque_, _многумин,
   {{0xb658400d,0xa2caf1e0,0xe776900d,0x00000000}},	//   _натураль, _leider_, _казулін_, --,
   {{0x2e1591ab,0x3ecf7029,0x134041d9,0xf8d5a063}},	// [4b0] _hemengoa, _posizion, _modelka_, _لايوجد_,
   {{0x19add0d8,0x050680a7,0x00000000,0x00000000}},	//   _تجربہ_, _алфабету, --, --,
   {{0xe88060f3,0xa3f46093,0xc0f06145,0xfafa50ee}},	//   _artikulu, _vertel_, _artikull, _pengerus,
   {{0x86e60186,0x4175c005,0xf305225b,0x6395e00e}},	//   _kompaniy, _تذکرہ_, _ditanam_, _vitse_,
   {{0xae99212d,0x1d0f7091,0x322ac16b,0x00000000}},	//   _وبعدين_, _pomozite_, _мовах_, --,
   {{0x9b5b611b,0x92907111,0x8ef0d070,0x00000000}},	//   _samtliga_, _kenal_, _संकल्पना_, --,
   {{0xf7085081,0x00000000,0x00000000,0x00000000}},	//   _gastronó, --, --, --,
   {{0xd674323f,0x5302817f,0xdecee1b7,0x00000000}},	//   _fundinum_, _medalju_, _genijaln, --,
   {{0xd9f6c071,0x726d90f2,0x8772316e,0x7c6d8132}},	//   _توہین_, _nasod_, _स्वाध्या, _shirika_,
   {{0x32a7f072,0xca677236,0x92ff41c0,0xe33f2062}},	//   _klubo_, _elmúlt_, _scriver_, _মজুমদার_,
   {{0x18bbf024,0xd28eb0c6,0x72b38067,0x00000000}},	//   _رسیورهای_, _earhart_, _सुकुल_, --,
   {{0x72fce02c,0x0202712c,0x32e601b6,0x00000000}},	//   _bangsa_, _periuk_, _planina_, --,
   {{0x9face055,0xa46f40c2,0x93f9616a,0xc26c9292}},	//   _تجاوز_, _استعفا_, _august_, _chaoi_,
   {{0xf71b104c,0xb26d81ee,0x647852b4,0xe27e9130}},	//   _вкупно_, _barod_, _unutarnj, _trane_,
   {{0xf30dc18b,0xc9c391ab,0xd36360e2,0x137810f0}},	//   _membina_, _konektat, _langkah_, _zoonraug_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc26e7002,0x0bcf9210,0xa35061df,0x00000000}},	// [4c0] _moroni_, _संगीतमय_, _photolum, --,
   {{0xe310b015,0xc2249069,0xa759b229,0x8e33b008}},	//   _chuckle_, _maakt_, _карабине, _reklamos_,
   {{0xc2c9410e,0x226e6040,0x8a59b071,0x4379303a}},	//   _bellach_, _artois_, _velünk_, _masaža_,
   {{0x84806067,0x53051055,0x627e7067,0xb3f470c4}},	//   _प्रांत_, _فولاد_, _tunne_, _gestel_,
   {{0xb3959043,0xf3949025,0xb20260a7,0xc3f401c3}},	//   _misst_, _naast_, _turism_, _dostat_,
   {{0x4b28b072,0xf79ed0b5,0xa2003070,0xe200c1f4}},	//   _транспар, _дроби_, _komisi_, _choise_,
   {{0xa2d51031,0x4c7d71df,0x663d7140,0x63f47130}},	//   _mellett_, _persuna_, _persunal_, _bestel_,
   {{0xfd8c2202,0x00000000,0x00000000,0x00000000}},	//   _geregelt_, --, --, --,
   {{0x64eba02b,0xf2cbf119,0x8870004c,0x00f16260}},	//   _контракт, _chudu_, _músicas_, _المعظم_,
   {{0x83b3d199,0x2c18719d,0x67a7b17d,0x0292514c}},	//   _travanj_, _ripples_, _জানলে_, _matayo_,
   {{0xb532b2b5,0x52da605d,0x7e0061f3,0xe225900d}},	//   _एल्बम_, _turere_, _bendrada, _aisku_,
   {{0xaa0b92b4,0x93f000f9,0x71dd401b,0x52b4d125}},	//   _oblacima_, _preobraz, _наоборот_, _boocdo_,
   {{0xb394b10e,0x439390d4,0xe70421b9,0x034082b6}},	//   _tacsi_, _לנסוע_, _distribú, _benetan_,
   {{0x2dffe141,0xd2d8312e,0xd653f005,0xc2ea00be}},	//   _perempua, _comesa_, _گوانتانا, _afriken_,
   {{0x7c56b144,0xff321030,0x2984a25d,0xfa171133}},	//   _partije_, _国土资源部_, _služiti_, _徐州监察分局_,
   {{0xd460d133,0xfd0a50da,0x00000000,0x00000000}},	//   _香艳的寻宝之旅_, _europese_, --, --,
   {{0x8ae1f00a,0x5791f17b,0xb581f1bc,0x191b7125}},	// [4d0] _institut, _institui, _instituz, _phạm_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x72a641bf,0xf85cb130,0xed183088,0x025830a4}},	//   _simba_, _verander_, _engleske_, _engleski_,
   {{0x5dab501d,0x86834003,0x00000000,0x00000000}},	//   _minninga, _एतबार_, --, --,
   {{0x82d51260,0xe2e9a01b,0x14b21250,0x50dd2005}},	//   _kellett_, _arkisto_, _dolları_, _ریسرچ_,
   {{0x3200c241,0x3f1a5063,0xb290e121,0x0431b062}},	//   _sedia_, _بعضويتك_, _gonads_, _জামিন_,
   {{0x8cf2f073,0x417d90d4,0x55750146,0xe2da72b7}},	//   _partener, _פיקוח_, _bildspel_, _stredu_,
   {{0xa3c8917d,0xd3da212b,0xec6050a0,0x15ec10d4}},	//   _এলোমেলো_, _правилни, _bheurla_, _ללקוחות_,
   {{0x7101c072,0x7c928035,0x42c51059,0x00000000}},	//   _свету_, _दररोज_, _okolice_, --,
   {{0xb27e912a,0x526ca116,0xb8dfb061,0x4a53c081}},	//   _quand_, _izbor_, _ryngwlad, _pomáha_,
   {{0x6386c080,0x82d5204f,0x4e23e032,0x00000000}},	//   _gjorde_, _robocon_, _longtemp, --,
   {{0xa2926136,0x835ab14a,0xfe6c2039,0x3b8ac00b}},	//   _intant_, _aerfort_, _عیسوی_, _собом_,
   {{0x5290c0b2,0x2c54a0f2,0xe3b6207b,0xf3c8e0bd}},	//   _jedan_, _gustong_, _значения_, _प्रत्यर्,
   {{0x768e62b8,0x99083179,0x82902070,0x22b7301b}},	//   _profissi, _pieniądz, _dekat_, _другому_,
   {{0xd2bac0d8,0xdfd8106c,0xf2eed045,0x8f1eb24f}},	//   _eredeti_, _מעדיצין_, _treff_, _vladavin,
   {{0x427e905d,0x1b495070,0x4a8cf133,0xd1b59259}},	//   _itanu_, _संस्कृती, _胶南市民政局_, _सत्तारूढ_,
   {{0x3221b038,0xe27e0196,0x9290c0db,0xb2927128}},	// [4e0] _diskutim, _erina_, _nedan_, _upsala_,
   {{0x861d1069,0x438750ac,0x7aa0a025,0xaa7dd0bf}},	//   _개인정보보호정책_, _vieras_, _verkopen_, _конзерва,
   {{0xb20130ef,0xfa7e91a6,0xa29130ef,0xe9e2d005}},	//   _linkleri_, _connaiss, _linkler_, _جائيں_,
   {{0x62d461da,0xa290c13c,0x704a317e,0x00000000}},	//   _burdan_, _allaah_, _edificio, --,
   {{0xa386d0b1,0x6299b03b,0x697010d2,0x224a7024}},	//   _enero_, _アウトドア_, _launcest, _hurmat_,
   {{0x20e56041,0xc225e081,0x1eb8a059,0xc29030f7}},	//   _डीवीडी_, _bitka_, _lubuskie_, _temaga_,
   {{0x33947045,0x3200910e,0x40bfa0d4,0x1c62700e}},	//   _dansk_, _owain_, _הצבאי_, _dostluq_,
   {{0xc236501d,0x134d516e,0x1305a0bc,0x32e68211}},	//   _vilja_, _माणूस_, _bumalik_, _klinton_,
   {{0xff23812c,0xb2e690d2,0x45a5b226,0x630ca274}},	//   _cemerlan, _quintin_, _pokojnom_, _kilimanj,
   {{0x9843423e,0x0a755035,0x6d99c108,0x5c457098}},	//   _централн, _असूनही_, _bezpośre, _omuwala_,
   {{0x2394d0ea,0xa897300d,0xe37841d5,0xd8881075}},	//   _mbese_, _даўжыня_, _abdalla_, _स्वीकार्,
   {{0x927e7045,0x323fd130,0xb2fcd002,0x00000000}},	//   _kunna_, _vermaak_, _chegh_, --,
   {{0x249d215f,0x63f91055,0x00000000,0x00000000}},	//   _расправа_, _kaburu_, --, --,
   {{0xc2ba5189,0x1290c119,0x4867507a,0x652c11d3}},	//   _sendiri_, _vedan_, _mulighed, _términos_,
   {{0x61d6100a,0xe26c31a7,0x00000000,0x00000000}},	//   _ישראלית_, _kamoli_, --, --,
   {{0x3248d150,0xf27f5081,0x114512b9,0x33eae091}},	//   _olema_, _prenos_, _materyal, _centar_,
   {{0xab182184,0xe4410063,0xd2f74100,0x423600f9}},	// [4f0] _هههههههه, _التطوير_, _shliabh_, _uniji_,
   {{0x1ca66034,0x0200c067,0x19699020,0xbe85e024}},	//   _журналис, _valige_, _autortie, _perkawis_,
   {{0xab6240d5,0xa25a91bf,0xe384b005,0x620261d7}},	//   _नतिनी_, _ajali_, _منجانب_, _marino_,
   {{0x1b0b003b,0x53dc90d1,0x62912173,0x33b1a0d1}},	//   _アドバイス_, _nkawd_, _socair_, _rovqab_,
   {{0xb2f4c03e,0xbdae0099,0xc43380a4,0x6320710a}},	//   _emailem_, _kasnasda, _gospodin_, _menya_,
   {{0xad5790f6,0x6c777035,0x2421908c,0xf3949041}},	//   _муниципа, _पेक्षा_, _मतलबी_, _prasy_,
   {{0x6445709f,0x89f1e01d,0x00000000,0x00000000}},	//   _प्रयोगशा, _endilega_, --, --,
   {{0xc27e9186,0x2201f0ba,0x4cb72030,0xc1be1200}},	//   _ngano_, _equip_, _您当前的位置_, _бисмаркк_,
   {{0x25ea400d,0x03ce91c1,0x401b2029,0x573c70a7}},	//   _маскоўск, _stavu_, _активен_, _комунита,
   {{0xd290c11b,0xb2e2a135,0xb317318f,0x6711c063}},	//   _redan_, _loginud_, _functie_, _منازل_,
   {{0xb9d2e18c,0xd2c2e007,0xa9995012,0xe3862085}},	//   _tallinna_, _tallinn_, _професси, _sikre_,
   {{0x524840db,0x52882068,0xc02a5122,0xfac1a2ba}},	//   _komma_, _hastalığ, _mundutik_, _निष्पक्ष_,
   {{0xf2e7600b,0x7ebd100d,0xb2e652bb,0x00000000}},	//   _putnika_, _барацьбы_, _agencia_, --,
   {{0xa38e102f,0x4bfcf09b,0x6cd35062,0x82009177}},	//   _význam_, _vergader, _নাইকো_, _dakizu_,
   {{0x325bf043,0x49eab025,0x0a9060c1,0x19fd01c1}},	//   _skulu_, _알려드립니다_, _comisiwn_, _interiér,
   {{0x163f31f0,0xb2002071,0xdc030048,0x9290220c}},	//   _kalendár_, _nekik_, _hastanes, _nekak_,
   {{0x0840c28c,0x12484106,0x2290821d,0x92d8a08c}},	// [500] _مخصوص_, _gomma_, _pekara_, _umbes_,
   {{0xc68191d5,0x9e68e0bf,0xb294f26d,0x72009223}},	//   _ग्लास_, _koristeć, _znakovi_, _swain_,
   {{0x012a2062,0xf386e047,0xa3f47014,0x8c0362bc}},	//   _নামস্থান_, _aliran_, _bestil_, _kampong_,
   {{0x029452bd,0xa1f8c063,0x62fdf0a4,0x437cf051}},	//   _linkovi_, _متصفح_, _drugu_, _levande_,
   {{0xf26c2205,0xcc610074,0x32f3b08f,0x53eae124}},	//   _nemoze_, _masuala_, _harimau_, _dritte_,
   {{0x82d8a0d8,0x935190b5,0x13e89025,0xff68c0c2}},	//   _ember_, _conform_, _태터데스크_, _مغرور_,
   {{0x47fcb04b,0xdc1ce03b,0x83f40103,0x52d661fd}},	//   _只看该作者_, _サイトマップ_, _kostet_, _podobno_,
   {{0x2e6d8042,0x542d619f,0xd6c76033,0xcbcf2277}},	//   _компенса, _दबदबा_, _financei, _रणनीतिक_,
   {{0x03f4719e,0xe34150f1,0x247231c3,0x9b0cd005}},	//   _nostre_, _videoen_, _libereck, _شاہین_,
   {{0x1394e07a,0x5386d205,0x729030e3,0x00000000}},	//   _krisen_, _miere_, _osmane_, --,
   {{0x92cbf0b7,0xaec93087,0x93f2001a,0x014561ab}},	//   _ljude_, _shingles_, _parehong_, _espezial,
   {{0x9681a2be,0x72fd80e7,0xcf5d41be,0x12904003}},	//   _क्रास_, _carga_, _magasabb_, _temal_,
   {{0x886c71e1,0xb4a9512d,0x1394914c,0xfc0542bf}},	//   _noinclud, _فبراير_, _kaasi_, _chorvats,
   {{0x2e50202f,0x8b95a14c,0x32e3a003,0xcc5ca114}},	//   _informač, _katikkir, _parimad_, _centrul_,
   {{0x6a7c814c,0x55a122c0,0x62f640be,0xb39591da}},	//   _makanisa_, _सोचते_, _prensip_, _hissi_,
   {{0xb27e90e2,0x758a0226,0x3c76914d,0x57b9c012}},	//   _orang_, _registrá, _forslag_, _домашнюю_,
   {{0x0c76d2c1,0xc2858036,0x9b9cf132,0x00000000}},	// [510] _मुल्ला_, _回答は役に立ちま, _maandiko_, --,
   {{0xbec3b06c,0xc386d093,0x4ea8700d,0xb3dcd14b}},	//   _יאהרן_, _diere_, _прэмадэр, _jyewe_,
   {{0xa28730d8,0xa248d103,0xd3417170,0x725b91c3}},	//   _تہران_, _filmer_, _eigenen_, _mysli_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x820020a4,0x5e685036,0x022a1062,0xa25b70bc}},	//   _nekih_, _総合ランキング_, _দিনমজুর_, _ilalim_,
   {{0xd3eb413a,0x1394b24a,0x6c6871a3,0xd582f087}},	//   _vjetra_, _fleste_, _ingreso_, _kategory,
   {{0x9387d16f,0x92e79034,0x13f98170,0x584cb0c3}},	//   _dobrú_, _gennaio_, _beruf_, _보았습니다_,
   {{0xe26d8151,0x9da63187,0x1c90a289,0x0782c02e}},	//   _karon_, _стопанск, _sekurang_, _людьми_,
   {{0x8fde31c1,0x2706e081,0xc62ed133,0x1c73f0ff}},	//   _vytiskno, _štruktúr, _必须保留本网注明, _kristna_,
   {{0xe2f1e101,0xa2ff91a4,0x711c9167,0x688e1133}},	//   _diritti_, _radharc_, _trešdien, _面皮做好刺洞_,
   {{0x0fe030c7,0xe837101b,0x9ed6006f,0x99e3f005}},	//   _sadistic_, _начале_, _južni_, _نوٹیفکیش,
   {{0xbb01c08f,0x71c3d034,0x03867091,0x62d8c15f}},	//   _persekit, _говорим_, _blizini_, _homens_,
   {{0x05b760a9,0xe153c133,0xf9508140,0x00000000}},	//   _finalsty, _企业国有产权转让, _operatur_, --,
   {{0x327e0186,0xf2fe70e7,0x00000000,0x00000000}},	//   _laing_, _cargos_, --, --,
   {{0x5e4ff213,0x3d99f130,0x00000000,0x00000000}},	//   _penanama, _resensie_, --, --,
   {{0x523b10bd,0x52fce2c2,0x3290316e,0x52a651c1}},	//   _न्यायालय_, _dingen_, _romawi_, _volby_,
   {{0x072a6045,0xa5a71174,0x62007008,0xcb338009}},	// [520] _приватни, _घाइते_, _meniu_, _stickleb,
   {{0x0b499070,0xa280c15a,0x4ab30022,0x02b2803f}},	//   _राष्ट्री, _novinky_, _ज्योतिर्, _sondern_,
   {{0xd200d043,0xc0af4005,0x7967a06c,0xf200c1dc}},	//   _tveir_, _استحصال_, _מגילה_, _medic_,
   {{0x53874145,0x09bcc005,0xc2ca617f,0xc27ef100}},	//   _gjerat_, _اُمید_, _okolini_, _kannur_,
   {{0xf648a049,0xd2d990c4,0x12fcf2c3,0x8387423d}},	//   _никарагу, _besef_, _exigir_, _fxfred_,
   {{0x83f4719e,0x7f78308d,0x653c9036,0x00000000}},	//   _vostre_, _trabajos_, _希望小売価格_, --,
   {{0x2ee3e1d0,0x20e7e1ed,0xb0d360c3,0x526e61ad}},	//   _programı, _offiziel, _언더웨어l남녀속, _beroun_,
   {{0xd27e723f,0x2e8892c4,0xe1275039,0xb2e1c070}},	//   _kunnu_, _निष्कर्ष, _تدابیر_, _ग्रीस_,
   {{0x3db8e163,0xd2fd8064,0xc3d08116,0x938740a3}},	//   _filament_, _kargo_, _primorsk, _andris_,
   {{0xd3f5021c,0x9ddd2063,0xd14061ee,0x4e022070}},	//   _kristovi_, _لؤلؤة_, _illegibl, _सुरक्षित,
   {{0x423161e8,0x5ad1607c,0x6be1607c,0xcb12625d}},	//   _formira_, _formiran_, _formirao_, _pogledaš_,
   {{0x73eae00a,0x92c53093,0x7248d135,0x63ce900b}},	//   _center_, _heilige_, _oleme_, _pravo_,
   {{0x42d9f068,0x1612f00d,0xdff3e1b7,0x52d8b177}},	//   _gazete_, _рэканстр, _najdraža_, _aldera_,
   {{0xd7f2706c,0x02926137,0x66d3608c,0x8320c061}},	//   _אַרכיװ_, _sarado_, _होखित_, _ysmygu_,
   {{0x6c69e038,0x2d007062,0x9e562187,0xc39591f4}},	//   _titulli_, _মিউজিক_, _настан_, _ahssa_,
   {{0x52007070,0x89dba03e,0xbbfb917d,0x5b03912a}},	//   _menit_, _agentura_, _septiemb, _entretie,
   {{0xe3f47078,0x0290402c,0x5613e059,0xa7df2150}},	// [530] _jestem_, _demak_, _programó, _कलाकारन_,
   {{0xa200526d,0x92d881b9,0xb053b06c,0x00000000}},	//   _zelim_, _ihneď_, _מנובל_, --,
   {{0xd617900d,0x327f91da,0xb248916e,0x58e0b292}},	//   _eurovizi, _qaynar_, _alami_, _العباد_,
   {{0xe2907202,0x93eaf145,0xd26da223,0x92ba426d}},	//   _genau_, _pritet_, _kapon_, _prodati_,
   {{0xfd1360b6,0x82908137,0xb3eae1cd,0x62d9618f}},	//   _consider, _dekada_, _venter_, _regels_,
   {{0xd6263017,0xc047f05c,0xf7ac9116,0xc2a681c1}},	//   _варшаве_, _мислите_, _postelji, _provozní_,
   {{0xb200321d,0x03099247,0x52904055,0x0a6fa12d}},	//   _komiti_, _broblem_, _lemah_, _prionsab,
   {{0x42e3216f,0xa7da52c5,0x2dc3a070,0x126cd063}},	//   _peniaze_, _विलक्षण_, _disingka, _cheol_,
   {{0x026da0e4,0xb287f068,0xfa0fe035,0xa163c045}},	//   _napon_, _hastalık, _manajeme, _родина_,
   {{0x526df012,0xec574060,0x1843c0c3,0x8b0b82c6}},	//   _autot_, _nastaje_, _하였습니다_, _कारणले_,
   {{0x32f1e0f7,0x519c3055,0x1680e02d,0x2c31e150}},	//   _artikli_, _سلسله_, _federasi, _artiklid_,
   {{0x53f8f2c3,0xdd399008,0xe5822036,0x53eae069}},	//   _algun_, _папулярн, _アフィリエイト_, _duitse_,
   {{0x12d850a2,0x8290d0d4,0xa2cae0e4,0x1290e0e2}},	//   _coleg_, _ideas_, _mondom_, _menara_,
   {{0xe2d830b2,0x1c53f243,0x327e0150,0xdab99073}},	//   _kojem_, _contato_, _naine_, _политиче_,
   {{0x7435e01b,0x02a640b5,0x343040fd,0x77a72063}},	//   _функции_, _limba_, _kukkiriz, _لفترة_,
   {{0xf3f85136,0x0290c0c1,0x127ee03f,0xd27e0073}},	//   _illum_, _addas_, _seinen_, _haine_,
   {{0xd200c16a,0x25202131,0x1320c1d0,0x26dcf090}},	// [540] _media_, _beannach, _medya_, _बाहिर_,
   {{0x42cae2c7,0xeb1001f0,0x027f40f8,0x3060002d}},	//   _sender_, _prostrie, _kwento_, _prosesin,
   {{0xf28461f9,0x8f628117,0xc9f8f206,0x62e68002}},	//   _безопасн, _katalogs_, _milijuna_, _klingon_,
   {{0x0d2c302e,0x503c9054,0x00000000,0x00000000}},	//   _список_, _namelijk_, --, --,
   {{0xd29272c8,0x9b2600f4,0x5aee200d,0xc6ae206d}},	//   _pasado_, _companie, _abiturie, _abituriy,
   {{0xb38692c9,0x924990cd,0x55b9314a,0x00000000}},	//   _snart_, _mesme_, _fillteán_, --,
   {{0x41999108,0x2f79916a,0xedad8043,0xa82c00d4}},	//   _problemy_, _problems_, _bandarík, _להעתיק_,
   {{0x92484045,0xe29250c9,0x73cef235,0x03454076}},	//   _komme_, _ostalo_, _živin_, _okresie_,
   {{0x32d85124,0x963f110e,0xa2d8a1e3,0x00000000}},	//   _allem_, _bersonol_, _albei_, --,
   {{0xbb6c60ba,0x73dcd132,0xd2ec514e,0x3c52d0dc}},	//   _expressa_, _mkewe_, _mobiele_, _स्लेट_,
   {{0xf24800d3,0x8a8861c1,0x5290e1f4,0xd3a2d1b4}},	//   _elimu_, _moderáto, _chiall_, _propio_,
   {{0xa387810e,0x49e17005,0x00000000,0x00000000}},	//   _dorri_, _میگزین_, --, --,
   {{0x0290c2ca,0x47b7f077,0x489a8036,0x735fd0c3}},	//   _islame_, _infracci, _したがって_, _아이들에게_,
   {{0xa7c0e129,0x5290c111,0x02d8b00b,0xa5963056}},	//   _klassifi, _pedah_, _организу, _isteriny,
   {{0x320071d0,0x0bf2d031,0x7367307c,0x18c2d031}},	//   _benim_, _kattints, _partijam, _kattintv,
   {{0x22d980e9,0x00000000,0x00000000,0x00000000}},	//   _muzeju_, --, --, --,
   {{0xe43f3025,0xe394d061,0xe6c900d0,0x0f25d295}},	// [550] _대전광역시_, _asesu_, _wasallam_, _beklager_,
   {{0x170bc17b,0xb2118071,0x5631c01b,0x86b1e062}},	//   _образлож, _úgyhogy_, _erinomai, _ধানসিঁড়,
   {{0x93f400ff,0x72640075,0x0200b0e7,0x26823159}},	//   _postat_, _poslat_, _medida_, _accesori,
   {{0x25b7b037,0xf26df26d,0xa27ff196,0x1b73917a}},	//   _disposiz, _istog_, _afuna_, _товару_,
   {{0xcbee1045,0xabcd6135,0x626ca0cd,0x52b47077}},	//   _часом_, _privaats, _rajoni_, _bancs_,
   {{0x92a13025,0x79a02050,0xaa95b062,0x52fc7053}},	//   _불가합니다_, _feijoada_, _অহেতুক_, _synge_,
   {{0x26dc50ab,0x00000000,0x00000000,0x00000000}},	//   _बेनिन_, --, --, --,
   {{0xbef2c204,0x3f25d1e3,0x9d8c025d,0xb68c10f7}},	//   _хвала_, _makliker_, _ovčar_, _दिवार_,
   {{0x763f10c1,0xea14c03b,0xec6d800b,0x729050f8}},	//   _personol_, _forbruge, _pokriva_, _melai_,
   {{0xd963e04d,0x6c03616e,0x83416150,0x00000000}},	//   _prosinac_, _gampang_, _जूनून_, --,
   {{0xd3ea01ba,0xb9f9b013,0xcc19b012,0xc806f062}},	//   _edite_, _профессо, _процессо, _রোববার_,
   {{0x0291a1e1,0x1aa83041,0xfe7252cb,0x00000000}},	//   _empat_, _जानलेवा_, _आरम्भ_, --,
   {{0xd57dc025,0x5d06c072,0x23659106,0xc4b0513b}},	//   _엔터테인먼트_, _retriver, _qingdao_, _एलईडी_,
   {{0xa387810e,0x5cd2108d,0x9200c048,0x3347d28b}},	//   _torri_, _বৈঠকে_, _haline_, _iglesia_,
   {{0x5f24018f,0x34d4d018,0xc3945087,0x75c54289}},	//   _nederlan, _रोहिणी_, _palsy_, _memboleh,
   {{0xa2fdf00b,0x4682c1c8,0xa131506c,0x221310d1}},	//   _drugi_, _अवतार_, _רעזולטאט, _tobhau_,
   {{0xc66402cc,0x5c7f616a,0x0200c27b,0xefe7b17b}},	// [560] _ग्रसित_, _january_, _politi_, _правата_,
   {{0xf2d850e0,0x44302243,0xaa76e24f,0x5c772005}},	//   _kolem_, _processo_, _šezdeset, _فریضہ_,
   {{0xb3f8522e,0x127e0189,0x00000000,0x00000000}},	//   _colum_, _asing_, --, --,
   {{0x6316d0ed,0x73eae18b,0xaaf851a6,0x00000000}},	//   _pieza_, _gentar_, _actuelle, --,
   {{0xdc93c166,0x6a22c062,0xe2cb4058,0x3bcfe04c}},	//   _باحال_, _সাময়িকী_, _gledaj_, _seminári,
   {{0x2985c1e8,0x877341c7,0xa30c2117,0x72a7f117}},	//   _visinama_, _परमात्मा, _atlants_, _klubs_,
   {{0x32007022,0x72e750cd,0x00000000,0x00000000}},	//   _denik_, _gjenden_, --, --,
   {{0xc177306b,0xc14752cd,0x5232703a,0x129020e9}},	//   _центр_, _desenvol, _premalo_, _nekas_,
   {{0xe5d7916b,0x3f19400d,0x0290c114,0x00000000}},	//   _замест_, _грунваль, _dolari_, --,
   {{0x47314216,0x99d4d17d,0x43f8b125,0xf2909043}},	//   _uspostav, _বিভ্রান্, _mocua_, _takast_,
   {{0x2394e184,0x00000000,0x00000000,0x00000000}},	//   _coiste_, --, --, --,
   {{0x6a7211c1,0xa355b224,0xcbd6f133,0xfa8900c0}},	//   _značka_, _digelar_, _市场参考价_, _perisian_,
   {{0xb2cad1e3,0x1200c023,0xcfe7b12b,0x029020f0}},	//   _vandag_, _mediu_, _правото_, _mekas_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc2d850c0,0x2c0b6145,0x53f14129,0x1165c12b}},	//   _kolej_, _perpara_, _esportaz, _клипче_,
   {{0x423651c4,0x5f3fa065,0x00000000,0x00000000}},	//   _vilji_, _tangeran, --, --,
   {{0x62ec216f,0xd86321c4,0x227ef186,0x6cd560c3}},	// [570] _rastliny_, _spennand, _hugna_, _페이지까지_,
   {{0x2b56100a,0x06d61005,0xd1314073,0xa4abd035}},	//   _בשיתוף_, _ناظمین_, _produsel, _कधीतरी_,
   {{0x99b14054,0xc01141a3,0x5baee17d,0xd290725d}},	//   _producte, _producto, _অলিম্পিক_, _cenah_,
   {{0xa3eaf1c4,0xac03602c,0x00000000,0x00000000}},	//   _leitar_, _samping_, --, --,
   {{0x23f9b230,0xa9a4c02a,0xf2d820cd,0x00000000}},	//   _ldquo_, _вплив_, _koken_, --,
   {{0x1231800b,0xf290c140,0x72910186,0x6386d230}},	//   _септембр, _solari_, _babaye_, _dhoras_,
   {{0x76830286,0x12903175,0xb94e7133,0xcab57041}},	//   _पोशाक_, _tamale_, _广州市白云山农产, _आंकड़े_,
   {{0x329010f3,0x3105217d,0x2c7760f4,0xeebdd069}},	//   _behar_, _মোটামুটি_, _popular_, _evenemen,
   {{0x1b09219d,0xbc9e10d4,0xa4721185,0x00000000}},	//   _simplete, _שומרון_, _direktno_, --,
   {{0x925a3002,0x12fd90d1,0x07b7917d,0x215f212d}},	//   _hamlet_, _ehehehe_, _ডোমেইন_, _coinnigh_,
   {{0x56bc62be,0xc229917d,0xe963d036,0xfdb4b0cb}},	//   _वक्ता_, _মুহম্মদ_, _あなたにおすすめ, _सूचीबद्ध_,
   {{0xedd040f0,0x6cc670d4,0x0ef21035,0x1b400063}},	//   _fatherna, _אינסטלטו, _पाऊलखुणा_, _الظلام_,
   {{0x62d8202a,0x92d85166,0x40fca133,0x8290710e}},	//   _boken_, _golek_, _胶南市交通局_, _menai_,
   {{0x83ce90a4,0x7877a017,0xf2d8c177,0x92ddc00d}},	//   _prava_, _правах_, _kodea_, _трохі_,
   {{0x220030f0,0x524a7228,0x324860c4,0x00000000}},	//   _mejis_, _seumas_, _klomp_, --,
   {{0x2377c005,0x7594a060,0x00000000,0x00000000}},	//   _فرائض_, _студенат, --, --,
   {{0xc0d5d036,0x668a6133,0xee634063,0x00000000}},	// [580] _このサイトを評価, _中小企业服务月专, _محاضرة_, --,
   {{0x2c5d612b,0x924832ce,0x9125901b,0x2295a035}},	//   _компания, _pojma_, _mielestä_, _सामोरे_,
   {{0xa9d18099,0x438061b7,0xb96730d2,0x825ad0a6}},	//   _muitimed, _jutros_, _believet, _fellur_,
   {{0xfc036070,0x18748271,0xb27e0010,0x00000000}},	//   _lampung_, _časopisy_, _zaina_, --,
   {{0x0386b09e,0x3290b050,0x08cc3284,0xc37880b0}},	//   _podria_, _dadabe_, _regrutov, _jonatan_,
   {{0xd9bf31ab,0x7849e02a,0x57e0e2cf,0xd35ae133}},	//   _hemerote, _призначе, _यूआरएल_, _从这里开始_,
   {{0xb0b202d0,0xb387f1a1,0xbed8d0b6,0x7512006c}},	//   _מחלוקת_, _jours_, _всеки_, _מחלוקה_,
   {{0xc387e049,0xaeb77235,0xc3200169,0xfc61208f}},	//   _intre_, _populace_, _agiye_, _tebusan_,
   {{0x226af034,0x2adf3145,0x522540a6,0x33ea014b}},	//   _операция_, _komunite, _drekka_, _bwite_,
   {{0xac325039,0x44b8b157,0x32c53125,0x00000000}},	//   _szeptemb, _podpisuj, _smileee_, --,
   {{0x37e47044,0xe342a0dc,0x00000000,0x00000000}},	//   _nước_, _स्टंट_, --, --,
   {{0xa2018213,0x627e9183,0x1c87706c,0xf2d9e005}},	//   _ceria_, _crann_, _נאָװעמבע, _beteg_,
   {{0x6ae4316a,0xc2c26091,0x330cb235,0x0200c064}},	//   _septembe, _izgleda_, _upravit_, _dedim_,
   {{0x6fc670f5,0x8a8672d1,0x00000000,0x00000000}},	//   _istorijo, _istorijs, --, --,
   {{0x6e7cd179,0x93ce015c,0x135f327c,0x9c6302d2}},	//   _मिस्र_, _vaiva_, _pengene_, _situado_,
   {{0x52da712b,0x2c758067,0xd1e29076,0x23ead239}},	//   _essere_, _तपस्या_, _पुनर्_, _svete_,
   {{0xb2dac03f,0xec0361dd,0x4387e1ba,0x4527d0bf}},	// [590] _können_, _kampung_, _antre_, _прикажи_,
   {{0xc3f4503f,0x0b63b036,0x624da26d,0x1ef6305f}},	//   _hatten_, _アクセス解析_, _zaboravi_, _настала_,
   {{0xc230120c,0x0124f067,0x8ea2a036,0x939210d4}},	//   _miamija_, _प्रतिरूप_, _最新記事一覧_, _מקבוצת_,
   {{0x92904078,0xe281c06a,0x79932005,0xb29040c0}},	//   _temat_, _possibil, _دھوکہ_, _gemas_,
   {{0x122b30b5,0xed27105f,0x5e1b317d,0xa3430132}},	//   _animale_, _сасвим_, _animales_, _kitendo_,
   {{0xfee0c02a,0xe38690cc,0x9b65f114,0xb2d85059}},	//   _землі_, _diari_, _тырзиу_, _kolei_,
   {{0x1dfc00da,0x62ca0063,0xa5269017,0x23dda0f2}},	//   _verdient_, _وعليكم_, _канцэрт_, _kapwa_,
   {{0x5c756022,0x58e3c034,0x9c1872d3,0x7caf502e}},	//   _हिन्दु_, _редакция, _despois_, _jyväskyl,
   {{0x02d84241,0x4c5042d4,0x4c6f1100,0x4981e15d}},	//   _komen_, _कैसेट_, _fearann_, _deaktive,
   {{0xebd45187,0x02258248,0x820181d0,0x13ce51d8}},	//   _генералн, _sarki_, _derin_, _halve_,
   {{0x639540e8,0x69292045,0xf3958123,0xeb67f012}},	//   _questo_, _вересня_, _parsi_, _annetaan_,
   {{0xf9f92037,0x426dc026,0x040d70f3,0xb386e07b}},	//   _alessand, _sanitari_, _gainditz, _koiran_,
   {{0x9273008c,0x385f6241,0xc2fe5074,0x00000000}},	//   _politsei_, _petronas_, _karatasi_, --,
   {{0x5f4e0037,0x6291b117,0x5b88f085,0x00000000}},	//   _versione_, _novads_, _fysioter, --,
   {{0x30e3c02e,0xab05a015,0x838060a0,0x325ad051}},	//   _рекоменд, _grignion_, _beurla_, _skolan_,
   {{0x5e7d4067,0xc3eae166,0x32d8108b,0xf2495237}},	//   _मदर्स_, _gentur_, _kohes_, _poemas_,
   {{0xc3cf9044,0x431870d1,0x227e9185,0x00000000}},	// [5a0] _musvn_, _hwjchim_, _hranu_, --,
   {{0xa479f263,0xc3f84073,0x02d6206c,0x3a25f1de}},	//   _meletakk, _comun_, _זשואיש_, _ओमप्रकाश_,
   {{0xe27f7161,0xfafa525b,0x6c394159,0x82da019e}},	//   _fransa_, _pengurus, _descripc, _museus_,
   {{0xefb1e0c3,0xdae4214b,0xac873005,0xd31771ab}},	//   _주절거리기_, _ingengab, _اُنہوں_, _plazan_,
   {{0xef6fc2d5,0xb305c0c2,0x9395423b,0xa37fc2d5}},	//   _palabras_, _توسان_, _flestu_, _palabra_,
   {{0x528c709a,0xb27f2044,0xf20190ef,0x2c5bc0ad}},	//   _בליץבריו, _quynh_, _kesin_, _vajtswv_,
   {{0x93ce8002,0x53430074,0x0ec7e0d4,0xcbfd717c}},	//   _tahvis_, _vitendo_, _efficien, _revendic,
   {{0x4b81006f,0x9f21f1c6,0x92004064,0x00000000}},	//   _govorimo_, _utilizar_, _demir_, --,
   {{0x925a00a6,0xf29052d6,0x12005017,0x92cae26e}},	//   _deild_, _kelas_, _kelis_, _hendes_,
   {{0xaa144074,0xe29050e2,0xa2018048,0xd290c091}},	//   _mahakama_, _jelas_, _verin_, _sedam_,
   {{0x128c312d,0x82fd5103,0xe34b8284,0x42d8c067}},	//   _الصمت_, _liggja_, _izvesnu_, _moded_,
   {{0xfb904005,0x0c76c2d7,0x00000000,0x00000000}},	//   _ادویات_, _निर्बल_, --, --,
   {{0x668122d4,0x92d850e5,0x3d449005,0x12bcf03e}},	//   _ख्याल_, _dolen_, _انچارج_, _महसुल_,
   {{0xf27e90bc,0x5394b0b7,0xe25a001d,0x37b57185}},	//   _laang_, _često_, _heild_, _prostori,
   {{0x22fd00bc,0x3f3d90dc,0xe3f461ed,0xa290c116}},	//   _mabilis_, _कोहिनूर_, _karten_, _sedaj_,
   {{0xf3f470ac,0x324a720b,0x2291816e,0x59c1f164}},	//   _lasten_, _termos_, _peran_, _verduide,
   {{0x527e7130,0x671da232,0x080a9045,0x22ee91e0}},	// [5b0] _manne_, _situació, _стоять_, _kraft_,
   {{0xb2249185,0xd27e9069,0x720050ac,0x425a0067}},	//   _opaki_, _maand_, _pelit_, _meile_,
   {{0xe8152020,0xd201511a,0x00000000,0x00000000}},	//   _sacensīb, _kefira_, --, --,
   {{0xa2b0b0ce,0x82da015d,0x0976c027,0x0e70f06c}},	//   _spacetim, _museer_, _podignut, _לאָנדאָן_,
   {{0x87e53059,0xa29050d0,0x0ffb01bb,0xec537217}},	//   _आसाराम_, _gelar_, _सोसाइटी_, _certeza_,
   {{0x9c7740bd,0x0a15e14d,0xe1ac4161,0xd16c3063}},	//   _पूर्वक_, _forbinde, _adlandır, _الركن_,
   {{0xff471026,0xcb1b300d,0x529180ba,0x93eae04f}},	//   _comprova, _хвілін_, _seran_, _otitle_,
   {{0x44919067,0xd3ced16f,0xaddf3042,0x1e5e80a0}},	//   _धर्मे_, _dreva_, _оптималь, _dunblane_,
   {{0x4edc610b,0x6713d00d,0x8855c1f6,0x8e511129}},	//   _sociales_, _рэкаменд, _слобода_, _finanzja,
   {{0xab613041,0x7290502a,0xc3ce90a4,0x07833012}},	//   _तुमने_, _delar_, _pravu_, _harvinai,
   {{0x72918243,0x9ad86067,0xf2df103f,0xcb6aa01b}},	//   _geral_, _गुजराती_, _meinung_, _статья_,
   {{0x0b3430a6,0xfc7c52d8,0xe3ea0130,0xd6d430a6}},	//   _sambands, _centrā_, _feite_, _sambandi,
   {{0x33788036,0x8f5ac276,0x525a0150,0xa2e120be}},	//   _ひとりごと_, _kampagne_, _neile_, _pozitif_,
   {{0x924a709e,0x8ea2e01e,0x12d850cc,0xd2d820a7}},	//   _termes_, _filtrene_, _illes_, _tokes_,
   {{0x73eab257,0x8d7c9025,0x3736d1cd,0xc3ced07c}},	//   _þetta_, _블로그에서_, _stilling, _creva_,
   {{0x6507d18f,0xfb13207a,0x4928f2a5,0x92a01073}},	//   _allemaal_, _hinanden_, _institūc, _верзь_,
   {{0xf20140a6,0xcc6f015a,0x3cf1f059,0x4290515f}},	// [5c0] _fleiri_, _doprava_, _instytuc, _pelas_,
   {{0xb9b7d12d,0x8c596041,0x0ae0e18a,0x00000000}},	//   _ionadaí_, _मर्सिडीज_, _varustet, --,
   {{0xd2d8502a,0xc3eae18e,0x54eac030,0x756ac030}},	//   _elles_, _toitim_, _第三十二条_, _第三十五条_,
   {{0x090eb036,0x429190be,0x67e670c2,0xa27a8064}},	//   _はじめまして_, _resan_, _پهلوان_, _kaliteli_,
   {{0x54b7729f,0xd2d8b111,0x9a23b020,0x6a94906c}},	//   _वस्त्र_, _medeni_, _darbinie, _טערמינען_,
   {{0xf8c8600b,0x0ea2f12b,0x1e41e125,0x435650e9}},	//   _финансиј, _contiene_, _ngừơi_, _adreses_,
   {{0x3eaa703b,0xf422a025,0xe231810b,0x22907072}},	//   _この回答内容が不, _개인정보를_, _primero_, _menas_,
   {{0xfb18b007,0xb2c5b07f,0xdbfca0d4,0x00000000}},	//   _компютер_, _rusland_, _במוזיאון_, --,
   {{0x420160ed,0x42d8e0cc,0x0c5190a6,0x19d91041}},	//   _begira_, _diners_, _nýtast_, _लातविया_,
   {{0xc27ed1ab,0xdc6bb169,0x1ea1d17d,0x00000000}},	//   _trena_, _burundu_, _honduras_, --,
   {{0xe132a03e,0x3f2fb1e1,0x535f3074,0x148672d9}},	//   _reklamní_, _pertania, _pengine_, _तरकारी_,
   {{0x7387f07d,0x03949073,0xb5816177,0x5a107125}},	//   _pouri_, _acasa_, _pentsatz, _megacame,
   {{0x7f5c62da,0x63c87077,0x739ae133,0xa475106d}},	//   _सिंगर_, _servei_, _个人空间管理_, _interfak,
   {{0x02d44101,0x07dd90d4,0xc2d8517f,0xedb510e8}},	//   _madonna_, _הירדן_, _voleo_, _stagione_,
   {{0x70137067,0x2682c0e9,0x82a63024,0xc2267129}},	//   _नरेन्द्र_, _novembri, _tambah_, _avukat_,
   {{0x881fd19b,0x227f712e,0xe2d8b064,0x22932071}},	//   _देशव्याप, _utanga_, _nedeni_, _kísérlet,
   {{0x9036100a,0xe21a11d9,0xc29fb2db,0xf394d034}},	// [5d0] _נסיעות_, _centráln, _एतिहासिक_, _spese_,
   {{0xde964070,0x9bed715f,0xd386014b,0x25e8b0bd}},	//   _राष्ट्रव, _fevereir, _nzira_, _पर्यटकों_,
   {{0x6743302a,0xe3ebf0a7,0x12d840dd,0x00000000}},	//   _курси_, _ajuta_, _gomes_, --,
   {{0x0c703067,0x92da00ba,0x07bb2145,0x39a6816c}},	//   _दिग्गज_, _essent_, _gjermani, _toojpost,
   {{0x22cad27b,0x22d840d4,0xcc0090e7,0xe3f9808b}},	//   _mandag_, _homes_, _básica_, _jezusi_,
   {{0x82907167,0xe2d871bc,0xa38b52b3,0x3dfca166}},	//   _cenas_, _honen_, _würde_, _متفاوت_,
   {{0x9d44503b,0xc69c20b6,0xab51c14e,0x727e0024}},	//   _最近の記事_, _достатъч, _olympisc, _raine_,
   {{0xe2d84020,0xb0e8e1e3,0xc27ed0be,0xa2d852dc}},	//   _domes_, _christel, _grenn_, _toleo_,
   {{0x5413205f,0xb25db038,0x5f1e402a,0x93790196}},	//   _почетак_, _perendim, _проектів_, _musajja_,
   {{0xc2d8509c,0x026e5077,0x127ff0e2,0x974910c2}},	//   _eller_, _antoni_, _agung_, _عبداله_,
   {{0x2ae21071,0x7366a141,0xd386000a,0xa3f8511c}},	//   _تھریڈ_, _tinggal_, _third_, _lolus_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xc1e0a179,0x941e414b,0x94c7c168,0xc2da01a2}},	//   _हंगरी_, _kiganiro_, _багдад_, _maseru_,
   {{0x634381b9,0x23218186,0x0e351071,0x42d8d015}},	//   _členom_, _serye_, _kellemes_, _plees_,
   {{0x226de013,0x3dcef025,0xd27f7043,0x048e9116}},	//   _katoa_, _베스트셀러_, _standa_, _popravlj,
   {{0x2386d145,0x5ee0f09f,0xcc33a06c,0x8c5e3124}},	//   _fieri_, _शास्त्रा, _פאביע_, _erstmal_,
   {{0x426de0c0,0xd35bd046,0xf34301a3,0x00000000}},	// [5e0] _matoa_, _pulgada_, _directo_, --,
   {{0x76eb507a,0xedc410b5,0x1ba4106a,0x02041037}},	//   _ランキング_, _articole_, _articolo_, _articoli_,
   {{0x50810063,0x4d12516a,0x67a9f0d8,0x9ba4c067}},	//   _التثبيت_, _construc, _harmadik_, _संयुक्ता,
   {{0xf25a906f,0x2a57d049,0x62907047,0x433f80d4}},	//   _hvala_, _каменка_, _benar_, _במרחק_,
   {{0x9f2d60e7,0xd49c008d,0x8cd3902e,0x38b8124d}},	//   _advertin, _চিহ্নিত_, _голову_, _podtipov,
   {{0xae9bf271,0x72ee6139,0x9c5fd0d9,0x00000000}},	//   _nastavit_, _trofi_, _septanm_, --,
   {{0xefd72072,0x640402a8,0xe1dbd25b,0x3f993044}},	//   _svetainė, _अकादमी_, _pengarah_, _xuất_,
   {{0x4007507a,0x03b5e157,0xf8c5c036,0x6a7e201b}},	//   _甲信越地区_, _života_, _の検索結果_, _tuollais,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2e59204b,0xb27e90ba,0xc4d6b09f,0x02d8c04c}},	//   _推荐给朋友_, _quant_, _प्रिया_, _podem_,
   {{0x0c614124,0x8f1f5008,0x52eca12a,0x13967017}},	//   _partner_, _reitinga, _afrique_, _kursai_,
   {{0x0394b0b9,0x28be1101,0xeaf262dd,0x92fce04e}},	//   _klesne_, _condivid, _consecue, _dingin_,
   {{0x8fba9069,0xa2fce0fa,0xe15f600d,0x00000000}},	//   _augustus_, _eingin_, _energijo, --,
   {{0xd4f4b15f,0x92ca9171,0xc2d842de,0x00000000}},	//   _acompanh, _idade_, _comer_, --,
   {{0x3c44508a,0x06d23160,0x135d901a,0x00000000}},	//   _klavier_, _शासित_, _anggang_, --,
   {{0x8291d12c,0xe2d851ee,0x39bf70f5,0x62d46078}},	//   _dewan_, _solet_, _нягледзя, _trudno_,
   {{0xd2d842df,0xf27c9157,0x00000000,0x00000000}},	// [5f0] _tomer_, _rezervác, --, --,
   {{0xd3eb70cc,0x7ee11067,0x303140e5,0x0b05a05d}},	//   _quatre_, _वार्ताला, _culturen, _ugasanga_,
   {{0x1485a078,0xf341f101,0x56b98170,0x1cefa089}},	//   _विरासत_, _palermo_, _benachri, _स्लमडॉग_,
   {{0x72b580d4,0x927e01bf,0x9b0151ed,0xc2d84130}},	//   _march_, _haina_, _sonstige, _somer_,
   {{0xc27e000d,0xece800c3,0x00000000,0x00000000}},	//   _kaina_, _은평뉴타운_, --, --,
   {{0x2d91e21f,0xb717d067,0x027ed2e0,0x37a5c21c}},	//   _cantidad_, _इन्दु_, _trenu_, _databáza_,
   {{0x12ef7114,0xe27e02a5,0x7d1fa24b,0x2387e034}},	//   _trafic_, _maina_, _beroende_, _entro_,
   {{0x227ed01b,0x084a3114,0xe3eaf1c4,0x73eae1c5}},	//   _vuonna_, _актуале_, _heitir_, _ventas_,
   {{0xfc6f600c,0x52da6007,0xc2fcf24b,0x00000000}},	//   _vetrina_, _barend_, _bygga_, --,
   {{0xe6a5c07e,0x3316f0ed,0xa26d8100,0x5386d081}},	//   _مباحث_, _baizik_, _throm_, _mieru_,
   {{0x53fa2077,0x14b0706c,0xe3eba2c9,0x00000000}},	//   _paquet_, _התבודדות_, _texter_, --,
   {{0xd305a17f,0x82ca60cd,0x926d312d,0x5200f1dc}},	//   _članak_, _ndodh_, _macosx_, _legii_,
   {{0xf7a8000e,0x027ef031,0x35b9f023,0x7a90412e}},	//   _korrupsi, _akinek_, _ынчепут_, _indirimb,
   {{0x6291c009,0xb2d9a27d,0x92fce0bc,0xf201100b}},	//   _revan_, _amper_, _tingin_, _jezik_,
   {{0x13f851f4,0xf291405d,0x527e0017,0x002800d4}},	//   _solus_, _madamu_, _daina_, _תערוכה_,
   {{0x1b88f295,0xaad1e1f8,0x22366105,0xa57d604c}},	//   _eksister, _कल्चर_, _khoja_, _reputaçã,
   {{0xfa1070a1,0x629050a7,0x00000000,0x00000000}},	// [600] _assamble, _aflat_, --, --,
   {{0x216c916a,0x5fc23063,0x00000000,0x00000000}},	//   _activity_, _قاموس_, --, --,
   {{0x58b53005,0xcc01a1c4,0x00000000,0x00000000}},	//   _گوجرانوا, _flestir_, --, --,
   {{0xa31061d2,0xdc55b1d8,0x3b228029,0x00000000}},	//   _verzia_, _gesteld_, _комфорт_, --,
   {{0x7ed401e3,0x5200b0b5,0x623d4002,0xfbaa601b}},	//   _inligtin, _decis_, _chovnatl, _прикольн,
   {{0xa27ff276,0x54b7b003,0x924a712f,0xd291a061}},	//   _grund_, _तन्त्र_, _permis_, _cwpan_,
   {{0x53430188,0x9eb302e1,0xf6cb11cf,0xd1c93114}},	//   _direito_, _direitos_, _agradeci, _поате_,
   {{0x4291813f,0x2a4f3169,0x9fee6133,0x8be76202}},	//   _gerai_, _nijeriya_, _国家体育总局_, _warenkor,
   {{0xc34921df,0xb6fca17d,0x76c5c005,0x2316000e}},	//   _diversi_, _ইশতিয়াক_, _نوٹسز_, _faizi_,
   {{0xdc5741c1,0x227e9045,0x00000000,0x00000000}},	//   _dostane_, _trani_, --, --,
   {{0xfaf4c026,0x00000000,0x00000000,0x00000000}},	//   _estrange, --, --, --,
   {{0x32fdf002,0x42ca5276,0xf6b4006c,0xdf53a076}},	//   _chugh_, _melde_, _אָלמערט_, _प्रगट_,
   {{0xe2d9800b,0x55c8316b,0x2d43d02a,0xf6a60004}},	//   _pored_, _значна_, _автомобі, _viethiph,
   {{0xce173243,0x25be2182,0x9ee4d070,0x7c213034}},	//   _значи_, _друге_, _संस्कारा, _академия_,
   {{0x27e7c01b,0x8ec62017,0xd201820c,0x00000000}},	//   _филиалы_, _мастак_, _voziti_, --,
   {{0xa27ff004,0xa2647064,0xfcfb000a,0xb0a2b07f}},	//   _trung_, _teslim_, _released_, _コメント日時_,
   {{0x22eba1c4,0x1a748234,0xb27ed0c4,0x1472e108}},	// [610] _stendur_, _ranganna_, _prent_, _podzięko,
   {{0x45fdb2c8,0x4dc41073,0xa248d1bd,0x448420ab}},	//   _direcció, _ultimele_, _filmes_, _अस्थमा_,
   {{0x2ffa3012,0xf200c00d,0x873b1133,0xe984d1c3}},	//   _работник, _medis_, _第三十九条_, _kapitola_,
   {{0x6f24e072,0xbfb2c12d,0xf4e2f062,0x07be00c3}},	//   _цяжка_, _ندعوك_, _আলবাব_, _토지문학공원_,
   {{0xe2d8c1c0,0x52df1043,0xbd1fc068,0x426db10a}},	//   _moden_, _menning_, _beslenme_, _segiteri_,
   {{0x1aedf13e,0xa5aac26d,0xa25b712a,0xf25a502b}},	//   _кондолиз, _poznajem_, _italie_, _felle_,
   {{0x32df118d,0xf2fd4045,0xab6d50e7,0x52fe6070}},	//   _meining_, _siegen_, _carreira_, _dirilis_,
   {{0xc7aa70e5,0x00000000,0x00000000,0x00000000}},	//   _awstrali, --, --, --,
   {{0x8e8ac071,0x3d89603f,0x172881c1,0xad988177}},	//   _چودھری_, _homepage_, _publikov, _publikoa,
   {{0x425a5150,0xcc1d504c,0x220180bd,0x7201e186}},	//   _kelle_, _проектот_, _serii_, _retin_,
   {{0xf386a034,0xa394e072,0x52ca0020,0x00000000}},	//   _messaggi_, _maisto_, _alida_, --,
   {{0xc2cae02a,0x15537063,0x0c54b087,0x5ad741ab}},	//   _landet_, _إمكانية_, _flatbed_, _partekat,
   {{0xa853512f,0x46876041,0x00000000,0x00000000}},	//   _dossiers_, _चुदाई_, --, --,
   {{0x3608607b,0x12cae0cd,0x1446106c,0x7a8ac04d}},	//   _normaali, _vendos_, _איילענד_, _švicarsk,
   {{0x129060f2,0xb27ff009,0x4254e062,0x00000000}},	//   _tulad_, _grune_, _আরণ্যক_, --,
   {{0x4e663221,0x94a860d4,0xfd02e0a3,0xf9d0f131}},	//   _आरोग्य_, _official_, _lattelec, _queensbe,
   {{0x652901ba,0xfcbda07b,0x71abd133,0x34c8106c}},	// [620] _definisy, _наверное_, _位读者读过此文_, _רעזערוו_,
   {{0xe29010f8,0xcdc040b0,0x29c0e025,0x8487d027}},	//   _agham_, _medikama, _gerelate, _лидера_,
   {{0xbdb4a0bb,0xf56e10d4,0x52574062,0x92904117}},	//   _необхідн, _טוקבקים_, _আশঙ্কা_, _nemaz_,
   {{0x543ed034,0x2abac255,0x1f6960e4,0x124122a4}},	//   _гадна_, _gravidit, _hatalmas_, _सुनले_,
   {{0x7386a037,0x3c542015,0x833200ba,0x00000000}},	//   _libri_, _lintawd_, _deixo_, --,
   {{0xd200f069,0xde1ad01b,0xe3869230,0x2053d023}},	//   _manier_, _люблю_, _mhara_, _reprezin,
   {{0x5ce5d055,0x7386a0c3,0xea9430a7,0x00000000}},	//   _نظرات_, _bedrag_, _блицеле_, --,
   {{0x7290b0c2,0x429201a1,0x0e10f13d,0xd3871035}},	//   _kecap_, _espace_, _रामरक्षा_, _pabrik_,
   {{0x650f21b2,0x626e510a,0x8d6cb041,0xe641c156}},	//   _bautismo_, _matora_, _फ्लैश_, _атурэ_,
   {{0xd2ca9074,0x5c5a7140,0xd059901b,0x82d9e03f}},	//   _idadi_, _sintomi_, _неделю_, _alten_,
   {{0xa25ae019,0x7d9bd1c3,0x5bee9062,0x8a14a177}},	//   _buille_, _autoseda, _আইজউদ্দি, _gorabehe,
   {{0x1531306c,0x42da602c,0xe200c002,0xf23b9090}},	//   _מעדיציני, _kereta_, _nediq_, _zájmu_,
   {{0x805331c7,0x525ad067,0xdbc4302e,0xaa44106c}},	//   _sportovn, _selles_, _слишком_, _קריזיס_,
   {{0x3b725036,0x4c7831e3,0x02a60115,0xa7c3d18a}},	//   _地域共同研究セン, _verskil_, _naibu_, _любого_,
   {{0xc15bf030,0xd54c2101,0x01dcc0b1,0x00000000}},	//   _月参加工作_, _клипчето_, _superfly_, --,
   {{0x52ca7177,0xa3874193,0x747ec02b,0xca7d51d9}},	//   _mende_, _tierra_, _ринок_, _kapacita_,
   {{0xe2926274,0xb2007130,0xaa1dc17b,0x6b6ae072}},	// [630] _kitabu_, _junie_, _измени_, _любоў_,
   {{0x37eab036,0x7434306c,0x52920060,0x00000000}},	//   _クラシック_, _אָנזאָג_, _napade_, --,
   {{0xc2d8c16a,0x725a914c,0x72bf1055,0xa3312152}},	//   _model_, _adali_, _حملات_, _सहभागिता_,
   {{0xc27e30ce,0x72cae086,0xa3f46124,0xb3eae032}},	//   _jajna_, _vendes_, _garten_, _ventes_,
   {{0x827d002f,0x235f3074,0x43869019,0x62e6024d}},	//   _materiál, _mengine_, _chara_, _fransoa_,
   {{0xa2007073,0x00000000,0x00000000,0x00000000}},	//   _iunie_, --, --, --,
   {{0x2b7c90c3,0x22ca70f3,0x2290c241,0x00000000}},	//   _필요하다고_, _jende_, _sedar_, --,
   {{0x0320701f,0xc2ca7192,0x4652d06d,0xba67406d}},	//   _kunye_, _dende_, _braziliy, _mütləq_,
   {{0x93f460ac,0xf1cbf0ed,0x73f4015d,0x6c75f1f4}},	//   _varten_, _besterik_, _mistet_, _acarach_,
   {{0x127e42b1,0xc3f04070,0xdb5e5284,0xa3f46124}},	//   _namna_, _prasasti_, _džekson_, _warten_,
   {{0x128e0024,0x3ea5b0ed,0x727e0074,0x1d89e051}},	//   _مقایسه_, _bestalde_, _akina_, _satellit_,
   {{0xd2025209,0x320051cf,0xa88a10c3,0x5224b0d7}},	//   _action_, _feliz_, _민주노동당_, _elekke_,
   {{0x02ca725e,0xe27e4275,0x1836a2e2,0x00000000}},	//   _hende_, _kamna_, _इस्लामपु, --,
   {{0x4dd400d4,0x1982f00b,0xf27e0169,0xc793624a}},	//   _לאשכול_, _постер_, _nyine_, _filtreri,
   {{0xbfeda06c,0x6349d2e3,0x42498228,0x53967135}},	//   _כסליו_, _potensi_, _gorma_, _varsti_,
   {{0x92891019,0x82d960f0,0x80479156,0x1200c1aa}},	//   _إقلاع_, _ligers_, _виолет_, _pedir_,
   {{0xacd7c005,0xd7cda0d4,0xa2d8c072,0x00000000}},	// [640] _پٹھان_, _דיסני_, _kodel_, --,
   {{0x19fce0b4,0x67da1231,0xa3f47025,0x7344b12e}},	//   _rekabent, _रिएक्टर_, _gasten_, _mirenge_,
   {{0xbf173189,0xadd10077,0x677410d4,0x92926274}},	//   _perdagan, _projecte_, _ברצלונה_, _vitabu_,
   {{0xe3ead239,0x85f5e11f,0x8efcd0e6,0x0cbc70dd}},	//   _sveta_, _बलात्कार, _भयंकर_, _јунајтед_,
   {{0x0200f10e,0xbb19e27f,0x43ea9175,0x3c614151}},	//   _megis_, _relasyon_, _kwata_, _gautier_,
   {{0x83f8c043,0x42d8c15d,0x414ec12d,0x31dec063}},	//   _aldur_, _alder_, _agallamh_, _agallaim,
   {{0xc76dc063,0x4150e1d0,0xa27e7196,0x2575b258}},	//   _الرأس_, _hareketl, _banne_, _ventilaz,
   {{0xddbd5206,0x6291808e,0x7c0dd02a,0xc499900b}},	//   _ispalite_, _veral_, _взагалі_, _приближа,
   {{0x0308b030,0x02fcc235,0x92901189,0x938780d4}},	//   _股权登记日_, _belgie_, _tuhan_, _sorry_,
   {{0x44b7811d,0xbfc6c15a,0xf27e7074,0x1d5bd036}},	//   _बत्तीस_, _autoškol, _wanne_, _クリスマス_,
   {{0x62d8b226,0xc3f40061,0x303d910f,0x5896b14c}},	//   _pocet_, _costau_, _extensio, _tashahhu,
   {{0x6f83a07b,0xa26c60d1,0xb290f1f3,0x72908274}},	//   _помощью_, _xyoos_, _jegas_, _kukata_,
   {{0x37b0c0a4,0xcc1e9036,0x29ed9051,0x00000000}},	//   _prvenstv, _リストマニア_, _redigera_, --,
   {{0x53860173,0x93957055,0x635d1055,0x4c72a159}},	//   _gairm_, _krasan_, _bingung_, _viernes_,
   {{0xc2a64245,0xf27e9010,0x13455145,0xe201801f}},	//   _dambi_, _taano_, _sigurisë_, _kerim_,
   {{0xa1f1c030,0xaf950282,0x44008044,0x82ee106c}},	//   _订阅该问题_, _soldater_, _nguời_, _לוקסוס_,
   {{0xf34ef1be,0x02a66002,0xb3f16130,0xd2008199}},	// [650] _emberek_, _ghobe_, _saterdag_, _nekima_,
   {{0x8602907b,0xb6259085,0x1c5f2036,0x1e06d01d}},	//   _интернет, _radioavi, _ゲストさん_, _myndirna,
   {{0xf3a410d4,0x517731e6,0xaf1b2072,0x7a8410d4}},	//   _לניהול_, _अस्सी_, _украіна_, _לאיבוד_,
   {{0xe6a7c2e4,0x89dca00c,0x2651b1a3,0x129ec01b}},	//   _महायुद्ध_, _infermie, _educació, _никак_,
   {{0x42d8f014,0x72a1321c,0x1394b0f1,0xd073803e}},	//   _bogen_, _pravidlá_, _eneste_, _moravsko,
   {{0x92902126,0xeaea71d0,0xfc549130,0xaf4dd011}},	//   _sukan_, _sistemle, _gauteng_, _конкурса,
   {{0x9a3e2143,0xd2cbf083,0x13f3d055,0xdb7b40d4}},	//   _مستقیم_, _ljudi_, _اطراف_, _demonstr,
   {{0xd27f40cd,0x5a3760e7,0x0c6740a7,0x00000000}},	//   _brenda_, _técnica_, _версиуне_, --,
   {{0x72fd00cc,0x00000000,0x00000000,0x00000000}},	//   _socials_, --, --, --,
   {{0xd719704c,0xd290b058,0x330ef239,0xec46e111}},	//   _conferên, _dodaci_, _upozorni_, _گرامر_,
   {{0xf2e90145,0x4413105f,0x929211b6,0x430e6197}},	//   _berisha_, _почела_, _zapadu_, _vasaras_,
   {{0x162690b6,0xe33290d1,0x8f4bf04b,0x00000000}},	//   _алтернат, _kojxwb_, _consomma, --,
   {{0x7249f073,0x4861b228,0x63ced1c3,0x89cc000a}},	//   _glume_, _donnchad, _zrovna_, _celebrit,
   {{0xd294e092,0x1e9b1036,0x00000000,0x00000000}},	//   _ज्यादातर_, _プレスリリ_, --, --,
   {{0xf2103204,0xa84f81b9,0x3eba105f,0x946570f6}},	//   _острво_, _mimoriad, _посла_, _страхова,
   {{0x311da114,0x42002110,0x5b6031d7,0x00000000}},	//   _проблеме_, _mukim_, _обичам_, --,
   {{0x1354a170,0x2565e06a,0x63f8c0e5,0x00000000}},	// [660] _anderes_, _служат_, _modur_, --,
   {{0x32909130,0x9ad510bb,0xf24a0182,0x28cfc063}},	//   _staan_, _postadre, _kosmos_, _وصحبه_,
   {{0x08ab6030,0x2bfb6030,0x19db6030,0x32b5f007}},	//   _第三十一条_, _第三十三条_, _第三十七条_, _hauch_,
   {{0x284cd025,0xcc5d10f5,0x33f47227,0xe395e0ac}},	//   _않았습니다_, _portalo_, _castro_, _natsi_,
   {{0x72b1e0be,0x520190e3,0x8200b170,0x7c85a06c}},	//   _kandida_, _besim_, _medien_, _רואיג_,
   {{0x92f54088,0x262241d2,0xd28e006c,0xb965207a}},	//   _nazivom_, _narodeni, _יוניאן_, _alligeve,
   {{0xe2d1d055,0x12440022,0xd2b970c1,0xf659018a}},	//   _tooltip_, _उत्तीर्ण_, _gwledig_, _настольк,
   {{0x3828307b,0x5ea83187,0x00000000,0x00000000}},	//   _центра_, _центри_, --, --,
   {{0xd27e70a9,0xa24a6059,0x3af33111,0x927ee074}},	//   _gunny_, _firmie_, _عبدالمال, _iringa_,
   {{0xbcc41136,0x4def7031,0xfcd39168,0x51c4006c}},	//   _artikolu_, _اجتماعات_, _подолу_, _סאכדעס_,
   {{0x84273115,0x07b36012,0xdb5bf1cd,0xfd1de002}},	//   _matatizo_, _konserti, _pedersen_, _coquelic,
   {{0x1eb162e5,0x6290f045,0x03f8e199,0xa39590c5}},	//   _externas_, _vegar_, _ponuda_, _passt_,
   {{0x93692043,0xae57d024,0x57bbe12b,0xd0513012}},	//   _bloggar_, _ورزشي_, _останали, _историю_,
   {{0x82786114,0x53d520b6,0x0292622e,0x63866063}},	//   _atunci_, _contatti_, _caraid_, _mbord_,
   {{0x92d870ac,0xf387e035,0x427f7052,0xd200c0be}},	//   _monet_, _citra_, _duanya_, _oblije_,
   {{0x4cc220d4,0x3046e2d7,0x2895d2e6,0x127ff0c9}},	//   _תחביבים_, _मंगलमय_, _pulvinar_, _neznan_,
   {{0xc92b0024,0xba5810dc,0x1f48d0a2,0xa3f8f135}},	// [670] _دفترچه_, _लखीसराय_, _pensiyna, _algus_,
   {{0xc557a17d,0x02ff5057,0xf27e61df,0x02f4006c}},	//   _ইন্সটল_, _dirigir_, _skond_, _באלפֿי_,
   {{0x520190eb,0x95d3c17d,0xf7261005,0x7f3ac0f9}},	//   _resim_, _বিনিময়ে_, _دوپہر_, _pregledn,
   {{0xd2d461a6,0x93eb016a,0x6b16c0d4,0x00000000}},	//   _jardin_, _status_, _displaye, --,
   {{0x237d400f,0xd1d20125,0x00000000,0x00000000}},	//   _rusange_, _đôrêmon_, --, --,
   {{0x61dc1017,0x82d8e099,0x22908175,0x0beec15f}},	//   _альбо_, _linens_, _alhaji_, _таков_,
   {{0x5705d0e6,0xb635b1be,0xb264604f,0x3c729072}},	//   _प्रदक्षि, _garanciá, _farlin_, _andrius_,
   {{0xaef1b13f,0x3278602d,0xb212f0b7,0x1eb7b133}},	//   _paskutin, _olunan_, _njihov_, _中华人民共和国行,
   {{0x2dbd40a0,0x4579a024,0x949b0076,0x00000000}},	//   _legalese_, _گوشیهای_, _ostatecz, --,
   {{0xe2d961e3,0xe3eb7005,0xe09d4063,0x2f2022b2}},	//   _engels_, _fiatal_, _مقارنة_, _excellen,
   {{0x085c1005,0x92ff4086,0x72cbc0bc,0x00000000}},	//   _اینٹی_, _arribar_, _salonga_, --,
   {{0x1b9732e7,0x00000000,0x00000000,0x00000000}},	//   _relación_, --, --, --,
   {{0x92906189,0xba828030,0x6380601b,0xe9d5d041}},	//   _bulan_, _市政府主要部门_, _verran_, _जाईयें_,
   {{0x7b27107e,0x426c900b,0xf1b4100b,0xafe970cb}},	//   _المپیک_, _škola_, _израз_, _नवरात्र_,
   {{0x96823193,0xf590129c,0x4afc2157,0x00000000}},	//   _necesari, _grafisch, _priezvis, --,
   {{0x831cb1a9,0x23ead06f,0x6df820d4,0x4255606d}},	//   _sábado_, _svetu_, _שעדיין_, _oğlan_,
   {{0x0d853224,0x5ecac100,0xd500f247,0x00000000}},	// [680] _permulaa, _leantain, _carmarth, --,
   {{0xb543f00e,0xf201a12b,0xd387826a,0x92eb5022}},	//   _komissiy, _страници_, _birra_, _majitel_,
   {{0x425b00f0,0x369bc062,0x9fea2028,0x65411005}},	//   _kablig_, _গোধূলি_, _व्याकरण_, _اکٹھے_,
   {{0xec61206f,0x132071ec,0x52367095,0x9c5bf04d}},	//   _dvorane_, _punya_, _janji_, _pustiti_,
   {{0x4394e1a6,0xe93fe1d8,0x83eb018d,0xadfc5108}},	//   _maison_, _verminde, _stater_, _skierowa,
   {{0x4645f025,0x868330fc,0xb7645067,0x6c664090}},	//   _소프트웨어_, _स्वान_, _निर्गुण_, _prstenu_,
   {{0xa27e91bf,0xe589b117,0x6a2bd17d,0xd4f9f105}},	//   _maana_, _pasaulē_, _চাহিদা_, _wormtail_,
   {{0x40d3305c,0x7f28817b,0x1caa706c,0x00000000}},	//   _гласа_, _самоубис, _זכּרון_, --,
   {{0xd3445022,0x329070f8,0xa150703a,0x22006184}},	//   _recenze_, _kunan_, _veleposl, _troid_,
   {{0xb61c210e,0xf256d012,0x00000000,0x00000000}},	//   _statudol_, _menetelm, --, --,
   {{0xe20030ba,0xb320010a,0x00000000,0x00000000}},	//   _domini_, _ariyo_, --, --,
   {{0xd4e30062,0xe281e023,0xbf91d03e,0x00000000}},	//   _বৈশাখ_, _четэцяну, _objektů_, --,
   {{0xf27e61f7,0xff61f29e,0xb2ff51da,0xaefcd1f3}},	//   _iyong_, _çünki_, _biridir_, _кубка_,
   {{0xa927b2e8,0x6290311e,0xf60f5063,0xecab607f}},	//   _wikipédi, _kumara_, _مسرحية_, _クチコミ数_,
   {{0x82d88167,0x6200d185,0xbaefc255,0x6291d047}},	//   _hokeja_, _obliku_, _jakobsen_, _lewat_,
   {{0x22e76119,0x0401f2b2,0x0158b22c,0x00000000}},	//   _diendan_, _solution_, _aqrosmey_, --,
   {{0x7291c0eb,0x7421f2e9,0x3e750005,0x4a500062}},	// [690] _devam_, _politikk, _انڈونیشی, _অধীনে_,
   {{0x31b33063,0xc3a8d0bc,0xea8f01a7,0x5f277133}},	//   _نادرة_, _dumating_, _priznaje, _经营许可证编号_,
   {{0x04b7c0fc,0x03eae119,0xc27ee04e,0xb2367166}},	//   _हस्तेन_, _bantot_, _isinya_, _panji_,
   {{0x4f1fb101,0x82dab0db,0xd29242ea,0x3201c293}},	//   _partecip, _datorer_, _dewasa_, _nevim_,
   {{0xe58b4129,0x2760a06d,0x090e800b,0x5f57d041}},	//   _approvaz, _məşhur_, _смислу_, _जाओगे_,
   {{0x02cde10e,0x1fea3041,0xf20ec045,0x89e96248}},	//   _nadolig_, _पोषाहार_, _запам_, _tesekkür_,
   {{0x62fd00e9,0xb30e4126,0x52f7e11b,0xc3423243}},	//   _akcijas_, _peratus_, _juridik_, _sucesso_,
   {{0x7294607c,0xf386d1c1,0x72ca60f9,0x120170a0}},	//   _slikari_, _tvorbu_, _ploda_, _acaire_,
   {{0xb8dc423f,0x67e9a03b,0x53ac70cd,0x7e1b7203}},	//   _spurning, _ダイエット_, _grupet_, _vetenska,
   {{0x8e1b708e,0x00000000,0x00000000,0x00000000}},	//   _wetenska, --, --, --,
   {{0x52007227,0x8c6a200e,0x5fe41100,0x63f95159}},	//   _junio_, _sonuncu_, _mackinto, _alguna_,
   {{0xa7a9004b,0x62fe42a6,0x9ea9b024,0x6fef1063}},	//   _entrepri, _petites_, _سرنوشت_, _بصيغة_,
   {{0xd11a105f,0x5a91808f,0x857120c3,0x72007061}},	//   _борбе_, _kesinamb, _결과입니다_, _lunio_,
   {{0x72fcb1d5,0x53a9c198,0x00000000,0x00000000}},	//   _berikut_, _हजारीबाग_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb3cf71b9,0xcce47186,0x3dc0e020,0x6fe0e008}},	//   _pravda_, _traveloc, _policija, _policijo,
   {{0xb24890a4,0xcdebb0bd,0x88e5b01b,0x32004076}},	// [6a0] _znamo_, _najbliżs, _суббота_, _sumie_,
   {{0x36b0c0ac,0xa394e12a,0xeb1900ee,0x0201e1e8}},	//   _страницу_, _saison_, _agrarian_, _nagovešt,
   {{0x63b0e0b8,0xd9bec063,0x61900141,0x427f014c}},	//   _vuiqua_, _تحذير_, _membunuh_, _amangu_,
   {{0x222b217c,0xba88501b,0x427e60cd,0x0e500130}},	//   _trimite_, _kokonais, _thoni_, _vakansie_,
   {{0xdc74a146,0x698382eb,0x7b7a6041,0x52909123}},	//   _forumet_, _creidmhe, _दर्शाता_, _duaan_,
   {{0xed28c17d,0x831740b6,0xf200312b,0x00000000}},	//   _existenc, _prezzi_, _uomini_, --,
   {{0x321c60d1,0xdc7c81cd,0x00000000,0x00000000}},	//   _asthiv_, _fristen_, --, --,
   {{0x6af960e7,0x32d4520c,0x0fcbc045,0x138782ec}},	//   _actualme, _čudno_, _свободу_, _mazrui_,
   {{0x429252ed,0x02fcd0b7,0x0340501e,0xcd23d2ed}},	//   _metara_, _njega_, _verdens_, _kosovske_,
   {{0x2202016e,0x6c00b177,0x92da51c3,0xf834900b}},	//   _posisi_, _egestas_, _letech_, _културе_,
   {{0xf14522c3,0x20bc8125,0x325a90f8,0x00000000}},	//   _forestal, _ledmobil, _alala_, --,
   {{0xff725163,0x537d4023,0x837ff012,0x9e952238}},	//   _crackers_, _departe_, _tahansa_, _cantante_,
   {{0xe8f13019,0x148620ab,0x00000000,0x00000000}},	//   _انتظر_, _हमलावर_, --, --,
   {{0x841f1067,0x00000000,0x00000000,0x00000000}},	//   _versioon_, --, --, --,
   {{0x79865041,0xa9862062,0x1e808204,0x7219e15f}},	//   _शादमान_, _শয়তান_, _острву_, _распоред,
   {{0xd27e90f8,0x75056037,0x767cf01b,0xa0adc1d7}},	//   _nyang_, _acquisto_, _проблему_, _спонсор_,
   {{0x9b89b062,0x42ca0040,0x35c1a0ac,0x83ea007b}},	// [6b0] _দিয়েছেন_, _noida_, _vähintää, _noita_,
   {{0x178ba110,0xe9288243,0x66d3e02a,0x1396701d}},	//   _termasuk_, _центар_, _студенті, _fyrsti_,
   {{0xa2d92223,0xe2d8903e,0xa2d99031,0x429b2019}},	//   _dicens_, _citovat_, _sosem_, _وكمان_,
   {{0x6576515f,0x00000000,0x00000000,0x00000000}},	//   _publicaç, --, --, --,
   {{0x33f40146,0xd2b490b8,0x00000000,0x00000000}},	//   _kostar_, _spacy_, --, --,
   {{0x1224c031,0x2b11b12d,0xc2e30030,0xd20260c6}},	//   _halkan_, _أمريكا_, _famille_, _cerita_,
   {{0x831641e1,0xee140025,0xbb891008,0xe290f0bd}},	//   _kembali_, _inderdaa, _finansų_, _dniach_,
   {{0x79b88007,0x09948144,0x1386d010,0xc933c00b}},	//   _центру_, _slikarst, _ezera_, _можемо_,
   {{0xa09ca17d,0x329e1234,0x0c607019,0xdc66c00f}},	//   _বিপুল_, _عموما_, _costais_, _protais_,
   {{0x4200c091,0x00000000,0x00000000,0x00000000}},	//   _velika_, --, --, --,
   {{0xa847d049,0xcf746035,0x767c00d4,0x00000000}},	//   _бавария_, _प्रकाशचि, _ההשקעות_, --,
   {{0xa6a8212d,0x346e21e1,0xdfbdf298,0xa486e19b}},	//   _وبحمده_, _pendidik, _fotoalbo, _लाभांश_,
   {{0x92a6208d,0x2d22206e,0xd4ff32ee,0x00000000}},	//   _nombre_, _pozitive_, _solución_, --,
   {{0xbcbf2070,0x326e1103,0xd202608b,0xa28a1002}},	//   _क्षेत्रा, _napoli_, _derisa_, _serafini_,
   {{0xdd8102ec,0xa7bd6025,0x6465d034,0xb3f3c063}},	//   _josephat_, _bevestig, _следния_, _أطباق_,
   {{0xc201e145,0x1eb06044,0x4f5c2241,0xb3f7f036}},	//   _ketij_, _sacomban, _dagangan, _質問した人_,
   {{0x8792000a,0x94150024,0xd2f032ac,0x8c757117}},	// [6c0] _statisti, _سخنرانی_, _radiasi_, _tabulas_,
   {{0xe3869069,0xf959e1fd,0xec0980e9,0x227e901a}},	//   _maart_, _zaposlit, _neatbils, _syang_,
   {{0xb2e0d094,0x0c0b71fd,0x9885124a,0xbda2c063}},	//   _कोचीन_, _skupina_, _fagkonsu, _ساخنة_,
   {{0x75a91049,0xb3ead0d9,0x00000000,0x00000000}},	//   _терито_, _rantre_, --, --,
   {{0x129031ec,0x3bae7067,0x7f46606c,0xc0abb07b}},	//   _pemain_, _जनतंत्र_, _גראַמאַט, _tykkää_,
   {{0x70743245,0xdbcaa2ef,0x92da41ad,0xdd90f22e}},	//   _komentār, _स्वीकृत_, _plantae_, _seallada,
   {{0x12d8e022,0x00000000,0x00000000,0x00000000}},	//   _bonega_, --, --, --,
   {{0x3301e020,0x8f9a30c3,0x00000000,0x00000000}},	//   _parasti_, _지식포인트_, --, --,
   {{0x3d0510cc,0x83860100,0xbace1012,0x9ad5100a}},	//   _instrucc, _cairt_, _поведени, _instruct,
   {{0x2dbca01e,0x02019161,0xcee4c1e4,0x9850e0e3}},	//   _antallet_, _etsin_, _курсове_, _rekomand,
   {{0x8c29306d,0x0225f10a,0xf689c06d,0x327e9147}},	//   _versiyas, _ibuka_, _bildirmi, _akana_,
   {{0x60b6d1e7,0xb478d0b8,0xb9fe11f3,0x63ead058}},	//   _bešeňová_, _bongdaso_, _redaguot, _sveti_,
   {{0x027e61a0,0x62cb50f1,0xc2d82122,0xe3220036}},	//   _akong_, _steder_, _mikel_, _ブログジャンル_,
   {{0x5d95916a,0xd9d99020,0x2e399020,0x00000000}},	//   _פורטל_, _dienesta_, _dienests_, --,
   {{0x08dc5166,0x127ee0ac,0x2264627f,0x49d3f06c}},	//   _ازدواج_, _kuinka_, _loulou_, _סטאנציעס_,
   {{0x8f1fb10b,0xc38692f0,0x8bd58007,0x68c3809c}},	//   _particip, _kaart_, _soldatar, _landjord,
   {{0x0962202b,0x76165219,0xf37a92f1,0x00000000}},	// [6d0] _коштів_, _poblogai, _koeficij, --,
   {{0xf251f00b,0xe2918008,0x17cf2036,0x58133063}},	//   _странице_, _geras_, _サイト内検索_, _وطبعا_,
   {{0x6201e035,0x22c6d030,0x12cb31ad,0x1166d030}},	//   _detik_, _第三十六条_, _mladá_, _第三十八条_,
   {{0x7200c1ba,0x5320021e,0x626c3121,0xe2d84112}},	//   _aplike_, _iriya_, _balong_, _limen_,
   {{0xc3b6100a,0x42c280a6,0xa378d0e2,0x42018111}},	//   _אימייל_, _heilsan_, _semakin_, _keris_,
   {{0x6248d020,0xb1b75062,0xbda9d00e,0x757ef170}},	//   _filmas_, _কাছেই_, _stansiya, _grundstü,
   {{0x75230025,0xb291811b,0x73f98293,0xbbefe112}},	//   _선택하세요_, _deras_, _korun_, _waterbur,
   {{0x620100e9,0xe449400d,0x72006132,0x752341d5}},	//   _nebija_, _пасяджэн, _kulia_, _pernikah,
   {{0x0fed900a,0xb2c5600e,0xec6d202a,0x00000000}},	//   _לסייע_, _nədir_, _московсь, --,
   {{0xd2fce08f,0x2e63f136,0xe8dcc073,0x00000000}},	//   _tengku_, _teknoloġ, _букий_, --,
   {{0xa387e1d2,0x43ce9087,0x134b0071,0x2380d17a}},	//   _nitra_, _chavo_, _baleset_, _brødrene,
   {{0x3366a0e6,0x8962002f,0x5ec201f0,0xd2f1e062}},	//   _tanggal_, _podnikat, _podnikan, _কিশোর_,
   {{0x163f30e0,0xb2918055,0xbdd10133,0x4291e055}},	//   _komentář_, _serat_, _山东省人民政府门, _tetak_,
   {{0xc3169022,0xa2018136,0x00000000,0x00000000}},	//   _krazy_, _perit_, --, --,
   {{0xefae1008,0xc07271e8,0xa9d3d0f6,0xb3f8c071}},	//   _ласка_, _bugarsko, _телевиде, _indul_,
   {{0x729250b7,0xee1a7059,0xa24a71ca,0x00000000}},	//   _ostaje_, _potencja, _formos_, --,
   {{0xc3eb2219,0x23a240b6,0x00000000,0x00000000}},	// [6e0] _fwyta_, _tempi_, --, --,
   {{0x1f6fa09a,0xc248921e,0x0d1ee025,0x2e63f117}},	//   _המדרש_, _inama_, _애니메이션_, _tehnoloģ,
   {{0xe2d98170,0xd7433103,0x83f40015,0x6201e166}},	//   _foren_, _курсу_, _lostus_, _getih_,
   {{0x63ea5029,0xa127e073,0xf3ea6145,0x81d001ab}},	//   _volte_, _британич, _plote_, _laburrak_,
   {{0x0200d22f,0x4288206c,0xf056206c,0xc888706c}},	//   _kudin_, _התאחדות_, _צימבלען_, _שײַכות_,
   {{0x680d001b,0xa2eff10a,0xbbd34076,0xa315d009}},	//   _ситуации_, _ngufu_, _जरिया_, _angbogh_,
   {{0x7290d0ed,0x20d3318d,0xc2e94061,0x00000000}},	//   _dudan_, _класу_, _glanhau_, --,
   {{0xfc00b056,0x6283f1bf,0x88881094,0x2290a08c}},	//   _spesies_, _nishati_, _हेलीकॉप्, _lubab_,
   {{0x0291e199,0x39e4e150,0x3f34e1b6,0xfdbc800d}},	//   _petak_, _dokumend, _dokumena, _фактычна_,
   {{0xb2d46121,0xc290d099,0x56c7b041,0x826e61b9}},	//   _hardin_, _oblats_, _प्रशंसको, _siroka_,
   {{0xb26e706f,0x1320012e,0x630cb1df,0x09c8d21f}},	//   _visoka_, _uriya_, _creases_, _alemania_,
   {{0x7394b157,0x920251ec,0xb316625c,0xede99023}},	//   _mieste_, _ketiga_, _laozi_, _ынкисэ_,
   {{0xd2cc02f2,0x72ee0196,0x33671002,0x00000000}},	//   _møller_, _ekifo_, _angghal_, --,
   {{0x72d85012,0x8fd2306a,0xafd2f271,0xc320007e}},	//   _eilen_, _покупка_, _dostateč, _priya_,
   {{0xaaabb025,0x72025024,0xde34f040,0x00000000}},	//   _비밀번호를_, _batine_, _badlands_, --,
   {{0x627e0045,0x3054100d,0x2303b06c,0xfa43b00b}},	//   _skinn_, _дзьве_, _הנהגה_, _интелиге,
   {{0x757f7063,0xbc6cb0ef,0xb200d22e,0x00000000}},	// [6f0] _اكتشاف_, _erzurum_, _breid_, --,
   {{0xa2d8718a,0x3facc14a,0xaf9b2093,0xc6513133}},	//   _ennen_, _مجنون_, _priester_, _无标题文档_,
   {{0x22d9a025,0xefa4b045,0x82ebc0e5,0x0e1ba235}},	//   _kopen_, _insekter_, _prinder_, _skupině_,
   {{0x226c8153,0x52d85283,0xf14e412d,0xe2d940e5}},	//   _ponoć_, _cilen_, _gaillimh_, _fideos_,
   {{0x0e0b8174,0xe2d8702a,0x67a2616f,0x12c3f00b}},	//   _प्रणाली_, _innen_, _spotrebi, _користе_,
   {{0xe2018161,0xe29090f2,0x0200d170,0x00000000}},	//   _verir_, _itaas_, _freie_, --,
   {{0x32d851ad,0xd2fce051,0x232141a1,0x98a5d2f3}},	//   _inlet_, _pengar_, _inscrit_, _इच्छुक_,
   {{0x06bec12d,0x7e45401a,0x034430c4,0x427ff103}},	//   _مصرّح_, _pinangga, _landbou_, _grunn_,
   {{0x0c70b037,0x4950b02a,0x2abca034,0xfa899284}},	//   _persone_, _personer_, _министър_, _džinovsk,
   {{0x5d78117d,0xdeb7c07e,0x03a292dc,0xa2ca905f}},	//   _নাজিরুল_, _مراتب_, _iwapo_, _vlade_,
   {{0x4340e09f,0x7470e040,0xe2caf003,0x00000000}},	//   _telepon_, _telepono_, _leidis_, --,
   {{0xb3207056,0xeaea70a8,0xf6d44034,0x4f98c125}},	//   _bunyi_, _cystadle, _lombardi, _khẩu_,
   {{0x8236726b,0x4602f0af,0xc3ea01bd,0x9225906d}},	//   _manji_, _स्वागताध, _noite_, _boykot_,
   {{0x12909129,0x2e8791c3,0x02cae08c,0x22574125}},	//   _lokali_, _kalkulač, _saidil_, _chuẩn_,
   {{0x4376301b,0xd2d9a151,0x00000000,0x00000000}},	//   _авторски, _fopen_, --, --,
   {{0x72eef0c9,0x1a52a05f,0x2d92a0b6,0x04d64041}},	//   _šifra_, _generala_, _generale_, _सुमिरन_,
   {{0x3adfb03e,0x73f40270,0x6490e067,0x2c532089}},	// [700] _postavit, _koster_, _कर्मठ_, _फुटेज_,
   {{0x7c5b80a4,0x9db4c073,0xbecad02b,0x2fd2404f}},	//   _postoji_, _аустрия_, _granskin, _quangcao,
   {{0x9879e036,0x5290d131,0x9b45e0c3,0x802b0223}},	//   _ジャンル別_, _rudan_, _행정정보공개_, _seleksyo,
   {{0xf25a6150,0x5342a07d,0x72d2a074,0x00000000}},	//   _poole_, _jeneral_, _jenerali_, --,
   {{0x2df48073,0x796df11e,0x7daf5020,0x1b6f5020}},	//   _економис, _jeannett, _sistēmu_, _sistēma_,
   {{0x31508133,0x3cfa1061,0x2386f1f3,0x00000000}},	//   _东营市蓝天塑胶有, _gwledydd_, _skirti_, --,
   {{0xe17da06c,0xeae3006e,0xb368d131,0xa320a0d4}},	//   _שידוך_, _musliman_, _aonghas_, _percent_,
   {{0xda083005,0xb248500d,0x00000000,0x00000000}},	//   _تصحیح_, _filmo_, --, --,
   {{0xd30b2204,0x43f87012,0x3c67b0f2,0xb2ba8132}},	//   _октобар_, _minun_, _sobrang_, _maadili_,
   {{0x82d9e0c9,0xbb0cc03b,0x62919232,0x6f10b024}},	//   _potem_, _でお届けします_, _pesar_, _نیستند_,
   {{0x837af173,0x237ca184,0x0b60f1cb,0x00000000}},	//   _tamaill_, _gruaige_, _permanec, --,
   {{0xc2d9e1ad,0xf2ad0111,0x6212b0d9,0x6f91c0e6}},	//   _fotek_, _شلوار_, _seche_, _feldspar_,
   {{0x35be21d7,0x3212b27f,0x00000000,0x00000000}},	//   _други_, _peche_, --, --,
   {{0x1c2a615c,0x525a5051,0xb25b70f7,0xf2d6d284}},	//   _приложен, _kolla_, _avalda_, _promenlj,
   {{0xfaf2c019,0xd43ef0c9,0x7dd2212b,0x338690f2}},	//   _beartait, _globalno_, _достъп_, _maari_,
   {{0x93ea50cc,0x32da0138,0x00000000,0x00000000}},	//   _molta_, _leseni_, --, --,
   {{0xe913f015,0x6827a02f,0x0de7a02f,0xeda9f1db}},	// [710] _anacletu, _rodinný_, _rodinné_, _definira,
   {{0x9201c117,0x038c5187,0xbeab81a0,0x03879274}},	//   _nevis_, _формирањ, _makonten, _misri_,
   {{0x67ed4041,0xb8ccd243,0xc3ead2b2,0x5c5c20e7}},	//   _महफ़िल_, _necessid, _filter_, _tratado_,
   {{0x08f00005,0x42f2b025,0x725ad135,0x12d83010}},	//   _کلومیٹر_, _archief_, _koolis_, _kimera_,
   {{0x86cef172,0x02ca70c4,0xff45b17d,0x6a0ef172}},	//   _behandli, _sonde_, _ইদানিং_, _behandle,
   {{0x82fda0b3,0xd27f802c,0xa2ee0014,0xc291c054}},	//   _forhold_, _warna_, _skift_, _bevat_,
   {{0x8c5ed0c9,0x5536412b,0x00000000,0x00000000}},	//   _kratkim_, _страхотн, --, --,
   {{0x426db0c4,0x5fa4a1c6,0x1048b036,0x73797056}},	//   _geword_, _entender_, _grafikko, _ingatan_,
   {{0xec36a226,0xee56c0a4,0x52490070,0xf27ee18f}},	//   _kategóri, _zdravlje_, _ciamis_, _linnen_,
   {{0x4b0c51cd,0x00000000,0x00000000,0x00000000}},	//   _presseme, --, --, --,
   {{0x2224e005,0x00000000,0x00000000,0x00000000}},	//   _minket_, --, --, --,
   {{0xa2d87177,0x1224e071,0x12fcf051,0xfcce615f}},	//   _ginen_, _linket_, _kriget_, _предлози_,
   {{0x02cae054,0x24806022,0x39e601e1,0xa8d28034}},	//   _minder_, _विभाजन_, _dianggap_, _operativ,
   {{0x12a66179,0xf5a0d2f4,0xc8f63168,0x72130145}},	//   _osoby_, _størrels, _странски, _mbahet_,
   {{0x52d8f031,0x661790bd,0x915fc002,0xf201c030}},	//   _engem_, _प्रत्याश, _rehoboth_, _devis_,
   {{0x330832b9,0xb9c5312b,0x42d9c159,0x92e9201d}},	//   _trabaho_, _riservat, _joven_, _minnast_,
   {{0x6291c117,0x8333f180,0xe4cea2e7,0xf201802c}},	// [720] _nevar_, _diskutuj, _concello_, _murid_,
   {{0xdaa0a071,0x573140ac,0xddb42063,0x629180a4}},	//   _ریٹائرڈ_, _страницы_, _شوفوا_, _strah_,
   {{0xa20060c2,0xbc51e146,0x23f40071,0xd8515069}},	//   _kulit_, _hantera_, _kettő_, _willekeu,
   {{0xc2741125,0x7369b157,0x3a8ad2b2,0x4c60e065}},	//   _lượng_, _likvidác, _decision_, _lulusan_,
   {{0xa29261dd,0x9d9e30b9,0x8638c00b,0xab611234}},	//   _berada_, _nainštal, _направље, _teoranta_,
   {{0x32d98036,0x825af0e0,0xa1c55133,0xd351e12b}},	//   _vores_, _mailem_, _中华人民共和国国, _инсталац,
   {{0x1200e0f3,0xbdab5035,0x12c4b265,0xab6241c3}},	//   _benito_, _तातडीने_, _premios_, _starosta_,
   {{0xa2ca614c,0xa00d2160,0x2224f2d1,0x00000000}},	//   _booda_, _सर्टिफिक, _slikar_, --,
   {{0x22d8c18f,0x52240072,0x95662022,0xf27f8035}},	//   _alleen_, _amiko_, _पद्धति_, _karno_,
   {{0xf3eae170,0x53869100,0xb041111e,0x0c34422e}},	//   _hinter_, _opara_, _impungen, _achanaic,
   {{0xf7a281ba,0x3486e059,0xe2cae170,0xb3c46027}},	//   _kontribi, _हिरासत_, _kinder_, _резолуци,
   {{0xc290b2c2,0x43877063,0x93ead0f7,0x502b00b1}},	//   _gedaan_, _tiarna_, _olete_, _koleksyo,
   {{0x5f4952f5,0xfede206c,0x126e710a,0x00000000}},	//   _existuje_, _אומזיסט_, _karoli_, --,
   {{0x9f6b4075,0xf200215d,0xa3f87012,0x52ca9091}},	//   _प्रदूषण_, _arkiv_, _sinun_, _mladi_,
   {{0xb975a2f6,0x5f1e902a,0x720510a3,0x0f02c073}},	//   _koristit, _основних_, _notikumi_, _аколо_,
   {{0x96fd707b,0x02483170,0x0e693063,0x0a68e072}},	//   _проблемы_, _kommen_, _سيدتي_, _начальст,
   {{0xe68e3133,0xe66c00d4,0xda07510a,0x38c0a062}},	// [730] _国家税务总局_, _בהשוואה_, _malariya_, _মনোযোগ_,
   {{0x7f7dc156,0xd291602c,0x5cf4d0f7,0xda6a809f}},	//   _измаил_, _segala_, _कलंकित_, _प्रशासक_,
   {{0x93050292,0xd3ea9150,0xfa10a052,0xdc6b00e6}},	//   _béarla_, _alati_, _bercinta_, _कार्या_,
   {{0xe290100c,0x8dfe12f7,0x73f471d0,0xc959c191}},	//   _mahad_, _जन्मदिन_, _destek_, _hipokrit,
   {{0xd71fb2f8,0x6060d14a,0x00000000,0x00000000}},	//   _उद्देश्य, _substain, --, --,
   {{0x30e8e080,0x2eb14025,0xb3eae015,0x72cbc0ce}},	//   _artikkel, _단독다가구_, _mentsi_, _jatlhwi_,
   {{0x82d8a0be,0xe2009099,0x5e724006,0x4316d1df}},	//   _kiben_, _nraim_, _अनन्य_, _prezz_,
   {{0x52d82099,0x52bac106,0xf1943020,0x7a6c01a7}},	//   _likev_, _unheard_, _komentēt, _usporedb,
   {{0x13f9a0a4,0x627ff00d,0xa611a063,0x12d8a10e}},	//   _poput_, _kaune_, _afracáin, _diben_,
   {{0xf486c012,0x726d82b4,0xac286063,0xa2d8709b}},	//   _имени_, _skroz_, _خخخخخخخخ, _anner_,
   {{0x2d32a014,0x32926091,0xa39dc18a,0xf2016260}},	//   _positivt_, _ostanu_, _касается_, _safier_,
   {{0x9bedf144,0xc291d1f4,0x2a28b08b,0xa84dd0c3}},	//   _ograniče, _dewar_, _emocione, _주셨습니다_,
   {{0x9386911b,0x52003023,0xe320006d,0xd2cad0c9}},	//   _spara_, _lumina_, _asiya_, _glede_,
   {{0x6ec6c00d,0x00000000,0x00000000,0x00000000}},	//   _кантакт_, --, --, --,
   {{0x92b390ed,0xc546502b,0x3d11c019,0xb2fce2f9}},	//   _munduko_, _страхово, _اختار_, _bungsu_,
   {{0x33954099,0xe201816b,0xe2cb80c4,0x63eb2146}},	//   _fresno_, _kurie_, _derde_, _flyta_,
   {{0x92d8c276,0x400c61e8,0xa24eb1b6,0x9f642036}},	// [740] _inden_, _privredn, _gradovim, _最新コメント_,
   {{0x4291e144,0x9292506f,0x6201e166,0xb875718d}},	//   _metar_, _ostale_, _metir_, _студента,
   {{0xe39d2049,0x02904073,0xfc72b1aa,0xb2d9e095}},	//   _критерий_, _numai_, _ofertas_, _boten_,
   {{0x93ac601e,0x9010c019,0x4d88006c,0xb290300e}},	//   _gruppe_, _انتقل_, _פעלקער_, _dumana_,
   {{0x2c6a12fa,0xc3e9304c,0x00000000,0x00000000}},	//   _कृष्णा_, _resoluçã, --, --,
   {{0xd12bb159,0xb3eb91f0,0xbb4a5070,0xc78bb073}},	//   _servicio, _meste_, _दक्षिणा_, _servicii,
   {{0xa4667180,0xa3eb925f,0x00000000,0x00000000}},	//   _hyperinz, _leste_, --, --,
   {{0x42d990cc,0xd3eb91e5,0x00000000,0x00000000}},	//   _josep_, _oeste_, --, --,
   {{0xb290d058,0xc2d9912a,0x00000000,0x00000000}},	//   _sudac_, _poser_, --, --,
   {{0x12d8c014,0x426e71c1,0x53f9504c,0x14b64133}},	//   _anden_, _oproti_, _alguma_, _谁有刘松仁版陆小,
   {{0xae9a402d,0xdd57122b,0x5540c062,0x08c10031}},	//   _bildirib_, _पिंगला_, _সমসাময়ি, _viselked,
   {{0x6166106c,0xd386b24d,0x2361603b,0x8320b1c5}},	//   _ליקוטי_, _podred_, _flemming_, _efectos_,
   {{0x7c3bd11d,0xb2903095,0xb320112e,0xa2d83117}},	//   _प्रयोजन_, _asmara_, _nshya_, _izmeta_,
   {{0x23eb9033,0x3c071045,0xb402401b,0x227e614c}},	//   _deste_, _prosent_, _сексуаль, _kkono_,
   {{0x2ef5707e,0xc27f80ed,0xdef1213e,0xb871212b}},	//   _panjenen, _barne_, _остави_, _остава_,
   {{0xc291803e,0xba8f8002,0xd556e1c7,0x3b08c0e3}},	//   _stran_, _tlhingan_, _कम्पनीको_, _emisione,
   {{0x719811cc,0x13559170,0x00000000,0x00000000}},	// [750] _specijal, _anderer_, --, --,
   {{0xeb6c40cc,0xfeac4030,0x5f247218,0x021c70ee}},	//   _terrassa_, _terrasse_, _pište_, _arshad_,
   {{0x82c28071,0xc3451053,0x399c10d4,0xb25af019}},	//   _mailben_, _vinduet_, _ההפעלה_, _seilbh_,
   {{0x39cd903b,0x220180be,0xb291b002,0xf03ba133}},	//   _コメントを書く_, _afrik_, _luqad_, _中国新闻网_,
   {{0x620690a7,0x5a5d00ca,0x82dd0284,0xa51e8062}},	//   _интернац_, _singlova_, _singlovi_, _তথাকথিত_,
   {{0x867a10cb,0xa9de115f,0x3a75d112,0x2105a0ce}},	//   _डेनमार्क_, _protegid, _deklamas, _arghmohl,
   {{0x038bb11c,0x7bee10ac,0xf9f671f6,0x12d210d4}},	//   _menyuam_, _часов_, _atrás_, _הקבצים_,
   {{0xa3eae031,0x1c50100a,0x89399036,0x332c600d}},	//   _fontos_, _למטייל_, _タイからの投稿_, _privatum,
   {{0x42ca5053,0x9255c135,0xb9ecb024,0xb98b4034}},	//   _holde_, _समुंदर_, _عملکرد_, _richiest,
   {{0xcb69f01b,0x73413148,0x925a90c1,0x1d70e02b}},	//   _paremmin_, _جنجال_, _llall_, _premissa,
   {{0x7a70d1e1,0x1e3410b8,0xca825005,0xbc2692a5}},	//   _berlangs, _yollards_, _legnépsz, _bakalaur,
   {{0x1b0400b4,0xa1f220dd,0x8e272027,0x92da0060}},	//   _persekut, _гевгелиј, _интереса_, _meseci_,
   {{0xe2cad2c2,0x61db60b5,0x025a42ce,0xb04c2261}},	//   _goede_, _спортзал_, _znanosti_, _modrykon,
   {{0x675f2012,0x00000000,0x00000000,0x00000000}},	//   _употребл, --, --, --,
   {{0x668210d5,0xd2d9e077,0xbe258062,0x9554c133}},	//   _रिवाज_, _altes_, _টাইপের_, _小时内解决_,
   {{0x70c3017d,0x4bd3b078,0x3f2430a7,0xc94f1070}},	//   _সংগীত_, _एरिया_, _югосла_, _उन्हाळ्य,
   {{0xb28cf1e7,0xe36c7055,0xc2b6605f,0xdeb9d0c4}},	// [760] _archív_, _ningali_, _северној_, _situasie_,
   {{0xf2906141,0x3f4602fb,0x1dd60047,0x59660275}},	//   _mulai_, _persemba, _perkemba, _अभिन्न_,
   {{0x56678070,0x7386910a,0xfa70d014,0x32a6901c}},	//   _नुकसान_, _ibara_, _berlings, _ibaba_,
   {{0xb3860190,0x32d9c00e,0x7912e044,0x59805177}},	//   _abiri_, _sovet_, _dântrí_, _ostirale,
   {{0x4e54e073,0xf37ff036,0x62d8c124,0x44d69089}},	//   _економич, _この質問に対する, _allein_, _मैथिली_,
   {{0x206d9067,0xf27f714c,0x147b8038,0x625b4061}},	//   _गोरखपुर_, _amanye_, _sistemin_, _apelio_,
   {{0x6c9f712d,0x1c4b80a2,0x626c60d1,0xd2f620a4}},	//   _الإمارات_, _cartref_, _txoos_, _nadimak_,
   {{0xc3f8b0f3,0x6f8a2036,0xc366a193,0x4f18a18d}},	//   _moduan_, _アメブロランキン, _escribió_, _правопор,
   {{0x727fe175,0xf290307b,0x397761df,0xe3807012}},	//   _bukhaari_, _jumala_, _manifatt, _marras_,
   {{0xcae5b17d,0x5c753146,0x72915112,0xaa7d1189}},	//   _আর্থিক_, _minuter_, _defann_, _sumatera_,
   {{0xb2a08025,0xe1e12108,0xde520020,0x327f400b}},	//   _생각합니다_, _oprogram, _bibliotē, _imenom_,
   {{0xe0513034,0xeb7d61ed,0x24609172,0xc2254166}},	//   _история_, _abonnier, _kinesisk, _krekel_,
   {{0x6d30c1c5,0x8f5c0059,0xd9e6206c,0x42d8c03b}},	//   _clasific, _सिंगल_, _עסטרייך_, _viden_,
   {{0x727f014c,0xf2d8a040,0x03419115,0x00000000}},	//   _maanyi_, _tobey_, _tanesco_, --,
   {{0x028d61c0,0xa63a9035,0x638f10d8,0x5cc2c204}},	//   _perkara_, _प्रश्नां, _rengeteg_, _подршку_,
   {{0xa2ca71a1,0x98c0203b,0x1903206c,0xe3462077}},	//   _monde_, _続きを読む_, _גראמאטיק_, _soldats_,
   {{0x12d9f0f1,0x938662fc,0x312b7125,0x00000000}},	// [770] _fluer_, _oboru_, _newvisio, --,
   {{0x0290d0c1,0x569a012b,0x9201416c,0x5c69e1ad}},	//   _ardal_, _нормално_, _isdias_, _situaci_,
   {{0xa2d8f172,0x82d7d17d,0xf20ec0e8,0xb25ad2fd}},	//   _ingen_, _দিনকাল_, _таван_, _millor_,
   {{0xa2d9d00a,0x73f8707b,0x9c39b05f,0xc2da1129}},	//   _lower_, _minua_, _приказив, _appell_,
   {{0x634171c7,0xf2b54114,0x22d87034,0x52d04062}},	//   _प्रयोजनम, _precum_, _linea_, _সাইকেল_,
   {{0x43f9024d,0x72c62103,0x7386f0d7,0x0daee0f0}},	//   _pobuna_, _експерти, _nagri_, _tiffanie_,
   {{0x22d8c0f1,0x731b92fe,0x42a63145,0x528f0010}},	//   _tiden_, _názor_, _kombit_, _merkato_,
   {{0x52d8c061,0x22918240,0x12ca7193,0x274e3046}},	//   _fideo_, _teraz_, _donde_, _anticonv,
   {{0x4290c14c,0xec1f50cd,0xa3869023,0x63eb02e0}},	//   _tulaga_, _perandor, _apare_, _pratim_,
   {{0x4c6a82d7,0x227f41d8,0x73ea71bd,0xc0e7319c}},	//   _चित्ते_, _dienen_, _fonte_, _almindel,
   {{0x5527a008,0x03191063,0x3cebb041,0x8268106c}},	//   _правоў_, _هيفاء_, _बकलमखुद_, _יעלצין_,
   {{0x22d8f10e,0xb947500a,0xf349f035,0xd29020f8}},	//   _angen_, _applicat, _lisensi_, _bukas_,
   {{0x938062a0,0x4248d100,0xe202410b,0x435fb1a2}},	//   _aturan_, _chomas_, _javier_, _airgeid_,
   {{0x52d8c10f,0xc3ea7223,0x8673b0c3,0x53eb01ad}},	//   _video_, _konte_, _북구문화예술회관_, _statek_,
   {{0x9d70115f,0xa2ab9215,0x82d9208b,0xb05f1095}},	//   _интер_, _gábor_, _kronike_, _اميري_,
   {{0x5f33a034,0x52da123f,0xf3b51267,0x12cac0eb}},	//   _следните_, _ásett_, _स्वस्थ्य_, _modda_,
   {{0x5632917a,0xa214b00b,0xb3f8c07e,0xe200e14b}},	// [780] _можуть_, _регистро, _kidul_, _kuniga_,
   {{0x915cd072,0xf9b050cd,0x6e718006,0x43249226}},	//   _туман_, _menjëher, _वॉन्ट_, _vracali_,
   {{0x57e54045,0xd2b4012b,0xd741e0e8,0x32d87002}},	//   _актуальн, _amici_, _основно_, _vineh_,
   {{0x63f1e16e,0x22d91075,0x1a086130,0x2316e07d}},	//   _करिअर_, _docela_, _belangst, _prizon_,
   {{0xa27f81f4,0x3c35b07c,0x52b1c122,0x691470bb}},	//   _darna_, _saradnic, _galdera_, _телекомп,
   {{0x52d8c08a,0xb31f12ff,0xda063005,0xe2ece1c1}},	//   _ander_, _mercado_, _رکھيے_, _motorky_,
   {{0x020092e6,0x9200d173,0x62d8c006,0x627e91ba}},	//   _orain_, _greim_, _wideo_, _chans_,
   {{0x82d9e128,0xd5d9c02b,0x22a78177,0x97078081}},	//   _intee_, _правовог, _garbi_, _životom_,
   {{0xb163403b,0x2cb8f072,0x00000000,0x00000000}},	//   _ペタを残す_, _запомніц, --, --,
   {{0xb6499080,0x1386d061,0xf68a8135,0x00000000}},	//   _медаль_, _storio_, _akadeemi, --,
   {{0x72918087,0x7ab14036,0x22018052,0xffb5b0f7}},	//   _muran_, _お気に入りブログ_, _suria_, _postitus_,
   {{0x54721300,0x0d8541e1,0x1b51f070,0x720ec008}},	//   _अनुनय_, _permukaa, _tindakan_, _палац_,
   {{0x3476f044,0xf2a78167,0x03811055,0x320051e3}},	//   _textilen_, _darbi_, _menyang_, _malie_,
   {{0x72ab903e,0x253f1292,0xd2912029,0xf3eb5163}},	//   _tábor_, _استايل_, _locali_, _lifter_,
   {{0x151d31bf,0x79978133,0xe2fd7255,0x8b658051}},	//   _kuboresh, _突发公共卫生事件, _skagen_, _billigar,
   {{0x42d8f045,0x225af1f0,0x429261c3,0x00000000}},	//   _eigen_, _mailom_, _dotazy_, --,
   {{0x11d0e03e,0x6efc90a3,0x827f9128,0x32925051}},	// [790] _telefony_, _samazinā, _basna_, _betala_,
   {{0x351dd0dd,0xd2902289,0xd63be062,0xf96961cb}},	//   _прогноза_, _sukar_, _করণীয়_, _militare,
   {{0xa24971b2,0x00000000,0x00000000,0x00000000}},	//   _alaman_, --, --, --,
   {{0x5200d1be,0xc94a5063,0x11e5900b,0xa6643018}},	//   _judit_, _مرئيات_, _будућнос, _गुमसुम_,
   {{0xf2d9e18d,0xdab65018,0x00000000,0x00000000}},	//   _roter_, _लोमड़ी_, --, --,
   {{0x63ea9146,0x527f01d2,0xb0bda036,0xd2e301b9}},	//   _plats_, _vranov_, _コメント投稿_, _komisie_,
   {{0xf36f22ea,0xa00d50e0,0x858740ed,0xa33d5090}},	//   _tingkat_, _proveden, _bestelak, _provedem,
   {{0x13ea50b6,0x425b7199,0xcbb5601f,0x1b40d07e}},	//   _molti_, _uzalud_, _projeler, _تعویض_,
   {{0x02d8f11b,0xe2da6120,0x82d602a0,0xe9786193}},	//   _inget_, _koreya_, _obrolan_, _suminist,
   {{0x3ee9d124,0xb8d9c072,0x12cf607d,0x1f79d20a}},	//   _funktion, _размаўля, _remonte_, _function,
   {{0x027ff13f,0x62025129,0x41633005,0x00000000}},	//   _kauno_, _attiva_, _گامزن_, --,
   {{0xf27ff020,0xca466035,0xc40e5034,0x02914108}},	//   _jauno_, _थोडक्यात_, _residenz, _dodany_,
   {{0xb3ebe1f5,0x44877028,0x454e100b,0x7db68100}},	//   _lette_, _निराला_, _битно_, _acarsaid_,
   {{0x72d850c0,0x12027008,0xfd840085,0xd2907247}},	//   _filem_, _kurios_, _ilulissa, _arnat_,
   {{0x72901149,0x33eaf114,0x2819202a,0x1ee30061}},	//   _lahan_, _spital_, _компанія_, _comisiyn,
   {{0xa9520130,0x8290d173,0x3fbbe051,0xf35be203}},	//   _publisee, _breac_, _fungerar_, _fungera_,
   {{0x62366185,0xf2904019,0xd297c10a,0xd0e6c108}},	// [7a0] _spoji_, _cumas_, _matariki_, _पानीपत_,
   {{0xd248d16f,0xe3966045,0x83ea90ad,0x82018017}},	//   _vieme_, _larsen_, _fajtim_, _kurio_,
   {{0xc3a240ba,0xbc60300b,0x00000000,0x00000000}},	//   _temps_, _недалеко_, --, --,
   {{0x33ebe09c,0x52e65080,0x094db025,0x4f1ed045}},	//   _dette_, _svenska_, _formulie, _прайс_,
   {{0x21862073,0xdaa3d17c,0xf4537005,0x8201600a}},	//   _економик, _индепенд, _مینڈیٹ_, _region_,
   {{0x9295f0eb,0xc126907c,0x00000000,0x00000000}},	//   _merkezi_, _stepeniš, --, --,
   {{0xd27e908f,0xc94810d4,0xc200628c,0xaf2b80f5}},	//   _ujang_, _הגילאים_, _nulis_, _ekstrema,
   {{0x03ea60fd,0x12006030,0xe25a6150,0x12e9201d}},	//   _kooti_, _trois_, _kooli_, _minnist_,
   {{0x0807a17d,0xd75aa301,0x3fc0513b,0x9303022f}},	//   _বুধবার_, _संस्कृत_, _पहिचान_, _gelagat_,
   {{0x1d7ba09a,0xdab0b025,0x5ccc2005,0x2cf76008}},	//   _תלמיד_, _알려주세요_, _بیجنگ_, _генералы_,
   {{0xac47d204,0x82fe41ad,0x8290e15b,0xbadda0ed}},	//   _правом_, _registr_, _canals_, _sustatze,
   {{0xb9d9a06c,0x738690d8,0xf2001087,0x30ed1186}},	//   _אינדרויס, _ipari_, _bahin_, _katingal,
   {{0xce49f0c0,0xe291800e,0x72ecb030,0xb4709022}},	//   _antaraba, _turan_, _mariage_, _लग्ने_,
   {{0xc62a1243,0x6fe7a06c,0x9f78a125,0xa3eb0122}},	//   _организи, _נאכפאלגע, _thặng_, _etatik_,
   {{0x631d6026,0x0c73614a,0x1c616010,0x00000000}},	//   _tercera_, _beartas_, _katumba_, --,
   {{0x94ba917a,0xad107036,0xb200202c,0x3283f302}},	//   _статті_, _商品レビュ_, _makin_, _slikica_,
   {{0xb2d98002,0xa200200e,0x7b621051,0xaefdb030}},	// [7b0] _horey_, _lakin_, _publicer, _上的问答吗_,
   {{0x425af1cc,0x1201116f,0xf7d0c072,0xc4d74235}},	//   _mogla_, _drzim_, _многа_, _मिथिला_,
   {{0x406d7109,0x4212b074,0xf3ac6075,0x2da68058}},	//   _temporan, _mechi_, _skupin_, _narodnja,
   {{0x9e9ec204,0xe14c000d,0xfae8918d,0x00000000}},	//   _дакле_, _паколькі_, _betongen_, --,
   {{0x52002012,0xe9aac073,0xca35b08d,0xf27c32e1}},	//   _takia_, _добит_, _ডিভিডি_, _necessár,
   {{0x52260064,0xa6ad9073,0x02004043,0xff0e806c}},	//   _merkez_, _autentif, _sumir_, _אומאָפּה,
   {{0x42b54062,0xdc7c801b,0xac2981c1,0x55f6d0f1}},	//   _precio_, _naisten_, _literárn, _molekylæ,
   {{0xe80a30b6,0xb25a6067,0x00000000,0x00000000}},	//   _струва_, _poola_, --, --,
   {{0x34844025,0x49c5100c,0xb2007130,0x4590c038}},	//   _주변정보는_, _intestat, _danie_, _pikerish,
   {{0x2e716303,0x2d9a41cb,0xd924300d,0xac07311e}},	//   _प्रक्रिय, _velocida, _быццам_, _tharciss,
   {{0x52d7d01b,0x13d550a7,0x0200a274,0x00000000}},	//   _машину_, _statului_, _injili_, --,
   {{0xc2009030,0xd2027149,0x42d8e087,0xa2d8f202}},	//   _frais_, _karier_, _minera_, _enger_,
   {{0xb9c71083,0x4301a093,0xd3967255,0x627ee11b}},	//   _карата_, _verband_, _kassen_, _sinnen_,
   {{0x2ee9e036,0x32910161,0xe290201f,0x52d920d4}},	//   _ありがとう_, _kubada_, _bakan_, _except_,
   {{0x5b3a20c2,0x125a224a,0x8476b2c3,0xc2f0f12d}},	//   _برخلاف_, _enkle_, _certamen_, _lárnach_,
   {{0xa2bc6087,0x12e31093,0x8e403024,0x00000000}},	//   _kredito_, _polisie_, _مانیتور_, --,
   {{0x4db4e234,0xcbd21036,0x57e5907b,0x8d9db06c}},	// [7c0] _saineola, _シャルブックマ_, _kaupunki, _אַדמיניס,
   {{0xd8f5f17b,0xa169215f,0x00000000,0x00000000}},	//   _студенти, _методиј_, --, --,
   {{0xac29002a,0xf3ea7016,0x73eae055,0xe2901013}},	//   _пропозиц, _conta_, _pinter_, _sahan_,
   {{0xf236d1b9,0xe9870304,0x1046f136,0x00000000}},	//   _svojim_, _देशमुख_, _corrigen, --,
   {{0x626e70e9,0xe3f87043,0x529260c2,0xb2c940bd}},	//   _paroli_, _hinum_, _mataku_, _europie_,
   {{0x9c67f02c,0x475bc041,0xbdfce01b,0x8316702b}},	//   _manusia_, _भूस्खलन_, _ситуация_, _експертн,
   {{0x43ea602b,0x529261c1,0xd274c019,0xb3071189}},	//   _flott_, _strava_, _سوالف_, _majalah_,
   {{0x6745d119,0x83eb011c,0x00000000,0x00000000}},	//   _hagiangv, _tabtom_, --, --,
   {{0x0290d250,0xd29060f3,0x00000000,0x00000000}},	//   _ordan_, _bular_, --, --,
   {{0xce819069,0xb290c12a,0xecf1624a,0x3d0cb01b}},	//   _서울특별시_, _jamais_, _kritiser, _комплект,
   {{0xe25ad0d8,0x3386d117,0x0386c150,0xba5372c9}},	//   _amely_, _sporta_, _noored_, _federala_,
   {{0xa785d0fc,0xa2009219,0xc2cb1185,0x038691e2}},	//   _सर्वदा_, _trais_, _mozda_, _acara_,
   {{0xa290307e,0x5c5b8076,0x7ad7b168,0x72a4015c}},	//   _najan_, _postaci_, _требаше_, _аннотаци,
   {{0x8c75911d,0xf290e0a6,0xb63ed151,0x13747151}},	//   _मुर्दा_, _einari_, _salicyli, _yugoslav_,
   {{0xf2255099,0x45751059,0xdaba502b,0x00000000}},	//   _amekas_, _dostarcz, _компаній_, --,
   {{0x6758e0bd,0x82019141,0x84bb72fa,0x625ad0db}},	//   _सदस्यता_, _musim_, _स्केचअप_, _gillar_,
   {{0xe7956016,0xea8c414c,0x89cb1064,0x720190d2}},	// [7d0] _históric, _chairmen_, _belediye, _lusim_,
   {{0xb2480274,0x00000000,0x00000000,0x00000000}},	//   _nzima_, --, --, --,
   {{0xe3ea70ce,0xd3f8f159,0x5200d093,0x4387704c}},	//   _qonta_, _sigue_, _brein_, _quarto_,
   {{0x2291c0b2,0x802301e3,0x97b35046,0xa290404b}},	//   _stvar_, _katestro, _geospati, _maman_,
   {{0x120020f8,0x92904213,0x852ef132,0x9c0b6059}},	//   _sakin_, _laman_, _mwendesh, _prosimy_,
   {{0x5b1fc213,0x34206062,0xb00360a3,0x00000000}},	//   _kelantan_, _মুখপাত্র_, _konsultā, --,
   {{0x26953305,0x627f0127,0x9471e25c,0x00000000}},	//   _fhreagai, _mwangu_, _hantaran_, --,
   {{0xa200d01d,0x1ce0503b,0xc8fb81a3,0xb37fb087}},	//   _grein_, _削除用パスワ_, _demasiad, _vedanta_,
   {{0x8200f1ab,0xed3b0133,0x52002012,0x0641c00b}},	//   _argia_, _国家知识产权局_, _vakio_, _старе_,
   {{0x42ca7034,0xfb036046,0x6a1640d7,0x7d6b308c}},	//   _mondo_, _sunscree, _minangka_, _inimeste_,
   {{0x729040c2,0x0291c002,0xc4fec101,0x8321908f}},	//   _jaman_, _duvan_, _временно_, _rusyd_,
   {{0xaea7a17b,0x93171063,0xd2862173,0x64e39062}},	//   _интереси_, _راجعون_, _dunkeld_, _আস্থা_,
   {{0xe29270b0,0xe4b471eb,0x9ab4c041,0x2cb7b05f}},	//   _pasaje_, _didaktik, _टुकड़े_, _границе_,
   {{0xa29181a7,0x32fe5091,0xd2916097,0x0290a024}},	//   _kurac_, _drugog_, _gegaan_, _babad_,
   {{0xb290401a,0xc6838092,0xb213818a,0xdc7820c4}},	//   _naman_, _नाराज_, _perhe_, _herstel_,
   {{0xd2b1e035,0x412d3073,0x22ca7111,0x4a44206c}},	//   _bandara_, _танти_, _kondo_, _טראפיק_,
   {{0x2291e112,0x3db91063,0x54821108,0x00000000}},	// [7e0] _detay_, _zhongsha, _regulacj, --,
   {{0x64a7e086,0xa0d340b4,0x56ec9045,0x00000000}},	//   _organitz, _ditonjol, _достатнь, --,
   {{0x93bfe0c3,0xa38662fd,0x0a8fd056,0x5248d0bd}},	//   _맨마지막글_, _acord_, _penipuan_, _ziemi_,
   {{0x826ae198,0x120d2150,0xf2f230b7,0x8200c0bd}},	//   _कम्प्यूट, _väike_, _putovanj, _paliwa_,
   {{0x0d4010d4,0xaedfc12d,0xf201f091,0xa27f014c}},	//   _ממשיכים_, _fhágáil_, _jezika_, _bwangu_,
   {{0x20d7a09a,0x02eb6306,0xd9308044,0xe290318a}},	//   _הגאון_, _plantas_, _xãluận_, _rajan_,
   {{0x4d417141,0x02e95112,0x0290518a,0x00000000}},	//   _membantu_, _andidan_, _palaa_, --,
   {{0xf132c063,0xc288e074,0x530471c4,0xcc64d005}},	//   _cailíní_, _wilayani_, _endanum_, _اکیڈمی_,
   {{0x66d3a307,0xf7f3c017,0x62373091,0x00000000}},	//   _साहिब_, _гiсторыi_, _filmova_, --,
   {{0xa2ca90bf,0x1fe89308,0x00000000,0x00000000}},	//   _vladu_, _विवाहित_, --, --,
   {{0x4394e070,0x00000000,0x00000000,0x00000000}},	//   _konser_, --, --, --,
   {{0x0037202e,0xbc7c40b1,0x0d05e00a,0x8290501f}},	//   _группа_, _carrots_, _introduc, _kalan_,
   {{0x72905105,0xd3f9b099,0x337fd04e,0xf2fcd1bc}},	//   _jalan_, _nique_, _belanda_, _blogak_,
   {{0xb334106c,0x32005038,0x4301e0fd,0x12905055}},	//   _סאציאלע_, _dalin_, _setaani_, _dalan_,
   {{0xb27f500a,0xb2c4316e,0x43869175,0x226bd12b}},	//   _events_, _televisi_, _mbari_, _събота_,
   {{0xa2011126,0x82a77044,0xe9eb7122,0xd200c196}},	//   _muzik_, _muaban_, _langilee, _tulina_,
   {{0x8cd4816f,0x8fee219b,0x5e48817d,0xb387708f}},	// [7f0] _uskutočn, _औपचारिक_, _বেয়াপা_, _luaran_,
   {{0x3290b1b7,0x91ae800d,0x00000000,0x00000000}},	//   _budala_, _savaičių_, --, --,
   {{0x72fce0bc,0x23c8709c,0x00000000,0x00000000}},	//   _singil_, _larvik_, --, --,
   {{0x53ef3274,0x738691f2,0x8c5240d5,0xe0e8d1cd}},	//   _matumizi_, _abari_, _जगदेव_, _betingel,
   {{0xaf1200f9,0x16e6000e,0x8d6fe067,0x1ed41020}},	//   _simbolič, _kampaniy, _विश्वविध, _palielin,
   {{0x59f3610b,0x127ff167,0xc200b298,0xe2d8125d}},	//   _constitu, _jauna_, _indiki_, _ziher_,
   {{0xe998e072,0xe291d0bc,0x12f39132,0x90674111}},	//   _каментар, _buwan_, _magazeti_, _sombrero,
   {{0xe2eb008e,0x5ea641df,0xf3ac016f,0xe9fc60db}},	//   _christo_, _interess_, _naspat_, _tekniska_,
   {{0x56bd600b,0x1e1a503b,0xdc1d20a1,0x829d0034}},	//   _операциј, _videnska, _kitablar, _системно_,
   {{0x3f2e217d,0x8a04c129,0x67525094,0xcfff7309}},	//   _editoria, _dibattit, _सेलिब्रि, _ज्यादती_,
   {{0x83e07071,0x36d470b6,0x47a1e1e1,0x2457c0d7}},	//   _héten_, _concessi, _pertandi, _معتدل_,
   {{0x6872205c,0x6290500e,0x22dda0c9,0x9a574062}},	//   _форуми_, _yalan_, _ribolov_, _কলোনী_,
   {{0x7cd7c019,0x22904045,0x2ac8900d,0xd40f20a7}},	//   _إعداد_, _gamal_, _андрэя_, _адулций_,
   {{0xeb350059,0x5c717277,0xc8835063,0x520050fa}},	//   _गरीबों_, _बोस्टन_, _محاضرات_, _valin_,
   {{0xdfa4f16a,0xb351d030,0xe03cd034,0x368d40ab}},	//   _november_, _其版权属于商务部, _recensio, _मिसाल_,
   {{0x57863179,0x0c66b014,0xfe96b01e,0x53a0c06a}},	//   _मुसलमानो, _bestemt_, _bestemte_, _удостове,

   {{0x4ae00047,0x4ffad035,0x62da71ab,0x23568040}},	// [800] _kabupate, _परवानगी_, _joseba_, _griffon_,
   {{0x62647181,0xa290d0ba,0x2069801b,0x00000000}},	//   _zaslal_, _creat_, _напомина, --,
   {{0xe25a60f7,0xd3f820cd,0x6ccdc114,0x6e9c00b7}},	//   _poolt_, _dikur_, _preveder, _dalmatin,
   {{0xbc44607a,0x00000000,0x00000000,0x00000000}},	//   _プライバシ_, --, --, --,
   {{0x43797022,0x4b40b025,0x220050ed,0xecc64024}},	//   _poradna_, _남겨주세요_, _balio_, _فاضلاب_,
   {{0xd25b60b1,0xbb6fd074,0xde3fd130,0x63f831bf}},	//   _ingles_, _sekondar, _sekondes_, _kamusi_,
   {{0xd248006d,0xe7272005,0xa2e9f0cd,0x5317f1df}},	//   _daimi_, _سروسز_, _gjendet_, _verbali_,
   {{0x96b1122a,0x3200523f,0x125ad067,0x0200c10b}},	//   _sigurish, _talin_, _milles_, _nadie_,
   {{0x59da826d,0xa3bbb14b,0xb2d47128,0xe2904250}},	//   _spremlje, _indwara_, _sordes_, _camal_,
   {{0xf345406f,0xf21d11a5,0x42907074,0xc3f47030}},	//   _veselje_, _stakleni_, _sanaa_, _portes_,
   {{0x22d8c128,0x4f23909a,0x686da23e,0xecdd2062}},	//   _videl_, _דעפארטמע, _proizvod, _মিসকল_,
   {{0xc201916f,0x227f41d3,0xc035c130,0x7fd3b0d4}},	//   _musia_, _tienen_, _buitelan, _בנזין_,
   {{0x642250b6,0x00000000,0x00000000,0x00000000}},	//   _indirizz, --, --, --,
   {{0xb177223e,0xe68a700b,0x53eb815d,0x4f6ba114}},	//   _месту_, _организо, _borte_, _атиншь_,
   {{0x21cc904b,0xf2c860b5,0xbc878062,0xdff2c30a}},	//   _activité_, _nicolae_, _তালুকদার_, _presvedč,
   {{0xdc75f067,0xde91312d,0xa200d063,0x92907189}},	//   _बुद्धि_, _ينبغي_, _breis_, _kanan_,
   {{0x42b400a3,0x887010f8,0x1b705062,0x4497b0fd}},	// [810] _teica_, _pakiramd, _বহুদিন_, _olwatuuk,
   {{0xa25ad12a,0x00000000,0x00000000,0x00000000}},	//   _filles_, --, --, --,
   {{0xe6bdb11d,0x720050b4,0xcea58136,0x49fe40e8}},	//   _पपीता_, _jalil_, _tolleran, _verament,
   {{0x22927305,0x92d8c20a,0xa290d100,0x91e7a02e}},	//   _turais_, _under_, _treas_, _настроит,
   {{0xf4d691c8,0x360ff0aa,0x446950dd,0x4290d131}},	//   _नोकिया_, _सामान्यत, _пристигн, _ludas_,
   {{0x42903131,0x183b603b,0x29839168,0x39e34008}},	//   _camara_, _こんにちは_, _кликнете_, _рэгіянал,
   {{0x62c94108,0xc49fd062,0xfd35c0dd,0x83f0d149}},	//   _stronie_, _মৃন্ময়_, _главен_, _sumedang_,
   {{0x027f4190,0x52da01c7,0x929181f3,0x72919166}},	//   _mwenge_, _popela_, _turai_, _susah_,
   {{0x92d980f3,0xefe3a008,0xb9c44114,0xb2ec616a}},	//   _diren_, _розныя_, _libertat, _february_,
   {{0xe9e0e060,0x00000000,0x00000000,0x00000000}},	//   _izborima_, --, --, --,
   {{0xb27ff125,0x2eb46009,0x224970f2,0x00000000}},	//   _byung_, _nacelles_, _alamin_, --,
   {{0xb2018167,0x53eb903a,0x00000000,0x00000000}},	//   _agris_, _boste_, --, --,
   {{0xc4019096,0x1aefb10e,0xf9955203,0x00000000}},	//   _energien_, _hystyrie, _biljette, --,
   {{0x1a87b30b,0xd290f031,0x23f40124,0xf200f175}},	//   _राजकुमार_, _magad_, _erster_, _magid_,
   {{0x4c025008,0x9c35a0ab,0xf946505a,0x82ca030c}},	//   _verslas_, _ostatnic, _biblegat, _unido_,
   {{0xb909d00d,0xe3f92208,0xdbcd80c3,0xff1e901b}},	//   _лідэр_, _hnyuv_, _영업소재지_, _основных_,
   {{0x2ba4f146,0xf291f00e,0x5ef1305f,0xa420e0c3}},	// [820] _diskuter, _tutan_, _осталих_, _개인정보의_,
   {{0xb2d8508b,0x5200d052,0xa9d6e062,0x4c7691cc}},	//   _cilet_, _kudis_, _ডার্কলর্, _zabrani_,
   {{0x8595106c,0x6a6ec0a0,0x929200c0,0x00000000}},	//   _נארישקיי, _ghallaib, _ampang_, --,
   {{0xb1701032,0xc290d193,0xf3ea72c3,0x1f229062}},	//   _sensatio, _dudas_, _ponts_, _কাঁচা_,
   {{0xf34af02f,0x82e56195,0x5b5cb1c3,0x173c9036}},	//   _majetku_, _mínimo_, _jedinečn, _ド用リンク_,
   {{0xd290702c,0x92cae07a,0x00000000,0x00000000}},	//   _nanao_, _findes_, --, --,
   {{0x525a510e,0x23227073,0xa00520dd,0x81ee10e2}},	//   _colli_, _inscris_, _огромна_, _pengaruh_,
   {{0xa2d992f0,0xfacaf260,0xd24900c0,0x3b0c3034}},	//   _eisen_, _látogató, _khamis_, _rapprese,
   {{0x2ee9d2ca,0x18e630b6,0x73207186,0x42b281ae}},	//   _funksion, _минути_, _banyo_, _munduan_,
   {{0xdfc9c204,0xd4e4a075,0x3479f224,0x7f2170c3}},	//   _новембра_, _प्रभावका, _diletakk, _홈페이지를_,
   {{0x82026255,0x4290d1bd,0x00000000,0x00000000}},	//   _ferien_, _mudar_, --, --,
   {{0x22907186,0xae9f0074,0x125b923e,0xfa963160}},	//   _tanan_, _utamadun, _posle_, _नर्मदा_,
   {{0x92e7709e,0xcd28c008,0xa2bb116f,0x495d007c}},	//   _jornada_, _андрэй_, _delenie_, _nagovest,
   {{0x27c1307b,0xb9ef4184,0x1200f1eb,0xfc11311b}},	//   _helsingi, _استعادة_, _nahita_, _helsingb,
   {{0x8c61a015,0x0ae4f17d,0x339b103b,0x2c9792be}},	//   _ferrand_, _একসাথে_, _こんばんは_, _व्यस्तता_,
   {{0x5249910b,0x3cf4c221,0x52fc7170,0x320ec1f3}},	//   _mismo_, _कामकाज_, _menge_, _раман_,
   {{0xa2d841c2,0xd29180eb,0x3c493026,0x0ee3b30d}},	// [830] _timer_, _murat_, _discapac, _महत्वाका,
   {{0x85be7182,0x9e385063,0x5e51313e,0x9129f0cc}},	//   _формиран, _تواقيع_, _оставка_, _formació_,
   {{0xc2d8502a,0x8c62706c,0xf29050e4,0x00000000}},	//   _filer_, _אַצינד_, _malac_, --,
   {{0xf6a90131,0x52905129,0xf2927284,0x0c885067}},	//   _litreach, _talab_, _opsade_, _galeriid_,
   {{0x32489074,0xb2d87202,0x12fcd274,0x6a76f072}},	//   _chama_, _ihnen_, _ndege_, _частку_,
   {{0xf630b063,0x0838b103,0x289421d2,0x09583063}},	//   _الأبيض_, _конкурсу_, _zaevidov, _أيضًا_,
   {{0x1200a074,0x0a37c15f,0x6386d14c,0x4f700072}},	//   _tabia_, _никаква_, _mberi_, _sekantis_,
   {{0xe2d3d206,0xe43aa036,0x92b502a2,0x98b1f15b}},	//   _kokoši_, _相棒探しから_, _placas_, _centenar_,
   {{0xbb623235,0xa2907167,0xbd86c034,0x62266051}},	//   _कामना_, _manam_, _награди_, _varken_,
   {{0xc25af00b,0xb4c7b30e,0x4dd9c063,0xaf7ec133}},	//   _mogli_, _buscando_, _اتخاذ_, _中国经济网_,
   {{0x839fc019,0x22f45186,0x923b4133,0x72d6a057}},	//   _اصدار_, _chanter_, _控制面板首页_, _parlant_,
   {{0xb2902124,0x72018008,0x1539d1dc,0x10cc815b}},	//   _jemand_, _turiu_, _неглиже_, _renovabl,
   {{0xc2d820d2,0xf24942f0,0x00000000,0x00000000}},	//   _takei_, _noemen_, --, --,
   {{0xe2907121,0x94c7a06c,0xa24990b7,0x7ea5d0c3}},	//   _banal_, _דעילי_, _bismo_, _권리침해신고센터_,
   {{0x82d85096,0xcffe606c,0xc3f85166,0x6ad07101}},	//   _biler_, _סוקסעספו, _bilur_, _инфекции_,
   {{0x5a3451de,0x3e129045,0xf2411005,0x46a5b059}},	//   _आइसक्रीम_, _поняття_, _منقطع_, _energety,
   {{0x22905009,0x24e1e0c6,0x344f306c,0xcc9ec030}},	// [840] _qalab_, _करीयर_, _אומשולדי, _新农村建设_,
   {{0x3ed7812b,0x724790fc,0x068320cb,0xb2d821d0}},	//   _другата_, _अकाले_, _अस्थि_, _asker_,
   {{0xb2f30023,0xf2f090e2,0x525ae100,0x54913089}},	//   _proiect_, _dipilih_, _chille_, _जेठमलानी_,
   {{0xb2fcd0b2,0xc4de205f,0x575f6267,0x00000000}},	//   _svega_, _временом_, _उपत्यका_, --,
   {{0x63164034,0x02b28063,0xab89b293,0x72d990c0}},	//   _bambini_, _londain_, _porodnic, _disel_,
   {{0x31ed1157,0x33f47026,0x53eb8026,0x42d900e5}},	//   _formulár, _sortir_, _forta_, _ambell_,
   {{0x46cc20be,0x2c2c20f7,0xa4d5a041,0xfece800a}},	//   _ekspresy, _ekspress, _हंसिये_, _encyclop,
   {{0xc38dd055,0x7cd1b17d,0x3e43000e,0x480a00d4}},	//   _اشعار_, _দেশকে_, _almaniya, _הכרטיס_,
   {{0xc29180a0,0xc2e5a16a,0x92d8b0d4,0xec75907b}},	//   _curam_, _industry_, _modern_, _inducer_,
   {{0xfcbd80d4,0x8cc8d2a9,0x295f6169,0xd637e17c}},	//   _איריס_, _новембар_, _bwongere, _altitudi,
   {{0x83200002,0x03947036,0xfb8d102b,0x3f1fd0cc}},	//   _chiyo_, _件を表示していま, _artistar, _segureta,
   {{0x7b2ca1e8,0x1f612187,0xb6293019,0x4f0c10d4}},	//   _omladins, _остане_, _traidisi, _להקליד_,
   {{0x83e250d8,0x3c5cf094,0x00000000,0x00000000}},	//   _természe, _मिशेल_, --, --,
   {{0x4264e041,0x37a300f0,0xed1501e3,0x00000000}},	//   _नेविगेशन_, _cerulari, _verseker, --,
   {{0xe2124100,0x024c80df,0x00000000,0x00000000}},	//   _cumha_, _होखला_, --, --,
   {{0xd29060f8,0x03eb9129,0x6847c1f6,0xc2d99203}},	//   _kulay_, _bosta_, _напади_, _anser_,
   {{0x93eb902e,0xe7c5f240,0x50b810d4,0x00000000}},	// [850] _josta_, _preskoci, _לתצוגה_, --,
   {{0x23eb9091,0x668281e9,0x09808049,0x1b2dc126}},	//   _dosta_, _लोगान_, _capitale, _timbalan_,
   {{0x7d8610d4,0xbc74206c,0xbe9172af,0x9fd99042}},	//   _לסיקור_, _באדייטן_, _district_, _принципа,
   {{0x9acc1063,0x53eb9229,0x72905117,0x19e65165}},	//   _متصفحك_, _fosta_, _galaa_, _forumund,
   {{0x23967069,0x1200a12b,0x00000000,0x00000000}},	//   _passen_, _fabio_, --, --,
   {{0x029180fe,0x52011110,0x5c6020a7,0x6290c07d}},	//   _juraj_, _yazid_, _secunda_, _madan_,
   {{0x5290c223,0x805e6130,0xa51090f3,0xd27e9030}},	//   _ladan_, _moontlik_, _hurrengo_, _ayant_,
   {{0x225af1cc,0x6b11900d,0x72b40063,0xffe810ab}},	//   _moglo_, _дырэктар_, _seice_, _संसाधित_,
   {{0xf290b07e,0x62005017,0xa386e1b9,0xf2d8b0d2}},	//   _wacan_, _dalia_, _akordy_, _andeen_,
   {{0x22d0330f,0x62efc1ec,0xb2552037,0x23f40093}},	//   _narodil_, _kalinya_, _direttam, _suster_,
   {{0x12817062,0x00000000,0x00000000,0x00000000}},	//   _সন্ন্যাস, --, --, --,
   {{0x5fe7e08d,0x6200c2a0,0x09aac00b,0x0b078062}},	//   _সাইমুম_, _kadin_, _новим_, _হেয়েছ_,
   {{0x1ed11310,0xd2e11021,0xe29251df,0x3eccc205}},	//   _anuncios_, _anuncio_, _totali_, _referáty_,
   {{0x5c620070,0x227f714c,0x63942017,0xb4aba0a9}},	//   _jurusan_, _bwange_, _sekso_, _teengirl_,
   {{0x1394e219,0xe29140a0,0x82839135,0x00000000}},	//   _lansio_, _sgeama_, _pakkuda_, --,
   {{0xc290b11c,0xf7c71073,0x3dcaa00d,0x372a7005}},	//   _cacao_, _машиний_, _палажэнн, _سرِورق_,
   {{0x4da01051,0x7291b052,0x22cc7130,0x1200d11c}},	// [860] _avancera, _arqam_, _paulsen_, _nplias_,
   {{0x058fa00a,0x93ec300b,0x2085e1c1,0xa27e914b}},	//   _אמצעי_, _gradskog_, _komplexn, _ijana_,
   {{0x52ba20a4,0x420261f6,0x727f7196,0xb49ec036}},	//   _ponekad_, _equipe_, _gwange_, _アカウントサ_,
   {{0xb290c25c,0x6ee4108e,0x3a941146,0xdfba6057}},	//   _badan_, _artikels_, _artikeln_, _innovado,
   {{0x3b0c3071,0x7a10501e,0x92266012,0xc1bd20e8}},	//   _مابین_, _datafile, _markan_, _чисти_,
   {{0x2c0240ce,0x3247606d,0x5200c05e,0x00000000}},	//   _jetsons_, _dəmir_, _milioi_, --,
   {{0x77b1f1d8,0x1966204b,0x00000000,0x00000000}},	//   _vertrouw, _monsieur_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x029080a4,0xe1540199,0xd7b401b7,0xa2d9a111}},	//   _nekako_, _vlastito, _vlastiti, _piped_,
   {{0x75448011,0xe4974041,0xb37c9087,0x6386f161}},	//   _статысты, _जख्मी_, _estante_, _şirin_,
   {{0xadc471f3,0x327ed0a0,0x6fada05c,0x729080a4}},	//   _konkursa, _rennie_, _formazio, _rukama_,
   {{0xa344917c,0xe2d9c0f4,0xc2ff409c,0xc39500e9}},	//   _citeste_, _given_, _striper_, _klases_,
   {{0xa7b361ba,0x92d8a132,0xec5d9133,0x43950193}},	//   _konstiti, _bajeti_, _功成名就闯大都_, _clases_,
   {{0x9487729d,0xc3ea71eb,0x7e71a0dc,0x4d07e012}},	//   _निकाला_, _kontu_, _टैग्स_, _органов_,
   {{0xc75410e8,0x8376c15f,0xe2255005,0x4290b2e3}},	//   _независи, _простор_, _ezeket_, _macam_,
   {{0x5201f1e3,0x532070d7,0xb2ddf0b5,0x82ad3063}},	//   _stuit_, _nanya_, _europei_, _إلغاء_,
   {{0x07a82106,0x00000000,0x00000000,0x00000000}},	// [870] _approssi, --, --, --,
   {{0xf3207047,0x22b08311,0x3e3860e0,0x792fc005}},	//   _hanya_, _कानुन_, _पोर्टफोल, _کشمکش_,
   {{0x4e4ff121,0x127390e4,0xcba42151,0xecc42177}},	//   _pinakama, _jános_, _artikulo_, _artikulu_,
   {{0xf2fce312,0xf6b95054,0x53a2d04b,0xa39670d8}},	//   _sangat_, _belangri, _propos_, _lassan_,
   {{0x32d9e07b,0xf3eba0d1,0x43207127,0x31e1c067}},	//   _miten_, _sixtus_, _manya_, _भीतरी_,
   {{0x22d9e02a,0x96f9c0f0,0xbab57041,0xb5c5e140}},	//   _liten_, _saibnkaw, _आँकड़े_, _simpatik,
   {{0x0c6f71bc,0x7201f141,0xf2245012,0x2d96800d}},	//   _horrela_, _putih_, _melko_, _мабыць_,
   {{0x03eb80e7,0xe2240043,0x8291f00d,0xc387f135}},	//   _morte_, _leika_, _butai_, _lauri_,
   {{0x1290b122,0xaa1ec00b,0x4ae1f2f0,0x1f5d022b}},	//   _bidali_, _видим_, _bestande, _पिंगल_,
   {{0xf6d8b070,0xa046f1bd,0xb290c228,0x4f3fe1b9}},	//   _mahasisw, _ferramen, _radan_, _nakoniec_,
   {{0xac528313,0xe2d83014,0x56f73067,0x629080e9}},	//   _denthan_, _alment_, _सौभाग्यश, _vakara_,
   {{0x82004064,0xa4ec917d,0xe347c146,0xea3260dc}},	//   _izmir_, _ফরহাদ_, _handlar_, _जर्जर_,
   {{0x8d38e114,0x16176005,0x534d9133,0xa2d9e0cd}},	//   _milioane_, _جارحیت_, _中央电视台_, _diten_,
   {{0x026d0088,0x12fee06d,0x00000000,0x00000000}},	//   _odbora_, _nəinki_, --, --,
   {{0x3ebd106f,0xfd1dd057,0xe2ed5170,0x00000000}},	//   _vožnja_, _adquisic, _dennoch_, --,
   {{0x425bf27f,0xb20182a1,0xe9fc8055,0xa3f8a002}},	//   _boule_, _arrin_, _pamarent, _tibus_,
   {{0x32fd50b4,0xdb9b5124,0xcc00d1c0,0x00000000}},	// [880] _muggle_, _technisc, _krismas_, --,
   {{0xc9f34226,0x93a2c025,0x0ea6c00b,0x42e8312b}},	//   _prostred, _helpen_, _заправо_, _sicilia_,
   {{0xf290a055,0x13eb8195,0xdbd29036,0x51510024}},	//   _sabab_, _norte_, _コレクション_, _اشتغال_,
   {{0xd68d6070,0xe97ac0d8,0x4e96e111,0xa051e23e}},	//   _निकाल_, _تقلید_, _براون_, _освојио_,
   {{0xc1b3c156,0x32903076,0xc396601b,0x00000000}},	//   _полонез_, _tematu_, _varsin_, --,
   {{0x52900073,0xf6c6f191,0xa3f47026,0x341f00bd}},	//   _chiar_, _dipanggi, _partit_, _उपलब्धिय,
   {{0x72d9e255,0xdc6ee15d,0x3dc9f230,0x1f9b201f}},	//   _intet_, _teorien_, _holyrood_, _animasyo,
   {{0x6248d202,0x06d3c1dc,0x28bbe036,0x22b6527f}},	//   _thema_, _фолиант_, _キャラクタ_, _mouche_,
   {{0xc625d059,0x7200c186,0x62900019,0xf39670ee}},	//   _pomorski, _balita_, _thiar_, _yassin_,
   {{0x72499021,0xd2f742bc,0x92919065,0x7519a045}},	//   _misma_, _kalimah_, _rusak_, _семестр_,
   {{0x3200c127,0x72d76185,0xd3f472a0,0xb200c07b}},	//   _kulima_, _navodno_, _sistim_, _valita_,
   {{0x825a5003,0x234310b5,0xf2b310e2,0x439d92d8}},	//   _mille_, _сорока_, _keadaan_, _televīzi,
   {{0x725a503b,0x0c36f036,0x6c62f01e,0xe25ad114}},	//   _lille_, _この質問の閲覧数_, _øvrige_, _unele_,
   {{0x3e56c13f,0x72920143,0x5201b2a0,0x22d9c0cd}},	//   _проста_, _supaya_, _divisi_, _enver_,
   {{0x225ac16f,0xc058100a,0x922471f3,0x00000000}},	//   _okolie_, _תערוכות_, _tenka_, --,
   {{0xe290f0b1,0x6220018c,0x4bc7e07b,0xd0a5a073}},	//   _dagan_, _viljandi_, _продаже_, _бликате_,
   {{0x946ee02e,0xdaf51060,0xe9222018,0xf396502b}},	// [890] _время_, _службе_, _गांजा_, _авторськ,
   {{0x13ebf03e,0xfeabf0bb,0x0c5bf145,0x3df1b235}},	//   _historii_, _historie_, _histori_, _sledovat_,
   {{0xc57e4219,0x7dc2b16e,0x420f3313,0xa200f186}},	//   _benderfy, _kebijaka, _ladykill, _nagin_,
   {{0x5b1f40c3,0x00000000,0x00000000,0x00000000}},	//   _효과적으로_, --, --, --,
   {{0x425ba0a9,0x3987329d,0x9d56c07c,0x6296c07c}},	//   _amply_, _भ्रमित_, _saradnju_, _saradnji_,
   {{0x017d909a,0x99f6c005,0x607c2063,0x23f400b6}},	//   _עיבור_, _توفیق_, _الفقه_, _nostri_,
   {{0x1ccc1055,0x3a12e1a1,0x537f812e,0x22d7606f}},	//   _ایرنا_, _inscrive, _muhanga_, _prvotno_,
   {{0x8200c0f2,0xfebce144,0x55bbf236,0x8c75b01e}},	//   _salita_, _verovatn, _önkormán, _figurer_,
   {{0xe0650067,0x97b7403e,0xb2f3725b,0x12ca502b}},	//   _सम्मानित_, _poplatek_, _peminat_, _hilde_,
   {{0xf067e2be,0x92d9e012,0x9c13e2a8,0xba11f1be}},	//   _उदासी_, _siten_, _इंस्पेक्, _garancia_,
   {{0x045a2116,0x337b91ad,0x629e7183,0x1505906c}},	//   _slovenij, _skladem_, _céard_, _תועבה_,
   {{0x793cf073,0x8212201c,0x40f2f023,0x3560c062}},	//   _популари, _mukha_, _четэцени, _মোরশেদ_,
   {{0x52d8b0e5,0x12d85111,0x2156107e,0xb2003109}},	//   _ticer_, _dalem_, _ژانویه_, _kimika_,
   {{0x42cad0a3,0x93eaf01b,0x1200f114,0xe749e005}},	//   _bildes_, _kiitos_, _schimb_, _بریلوی_,
   {{0xe2d9e2e5,0x8ff82025,0xa388f0bf,0xcaac80cb}},	//   _antes_, _클린중개업소_, _unutrašn, _मच्छर_,
   {{0x8200d124,0x635f91d9,0x1f0d1070,0x9b30d1a0}},	//   _preis_, _recepty_, _संस्कृती_, _glycogen_,
   {{0xa290e136,0x615a9034,0xc346d1f3,0xcb61f069}},	// [8a0] _finali_, _difficil, _vandens_, _telefoon_,
   {{0xf2d7112e,0xffa38044,0x226cf1f2,0x561c50bd}},	//   _mirongo_, _giấy_, _yehova_, _podlaski,
   {{0xa57e410e,0xd297102c,0x03410035,0x3c744219}},	//   _penderfy, _panjang_, _जाणून_, _mesurau_,
   {{0x43f85228,0x37f6812b,0x00000000,0x00000000}},	//   _calum_, _текстове_, --, --,
   {{0xe291f031,0xd68d60cb,0xd8d230dc,0x0314706c}},	//   _mutat_, _बकवास_, _कांटा_, _קאַווע_,
   {{0x22909130,0xda87d179,0x32d8c04b,0x53657072}},	//   _schatz_, _शिवकुमार_, _aider_, _dauguma_,
   {{0xab197070,0x9386a146,0x5b6d1063,0xd3f820ab}},	//   _serangan_, _bidrag_, _ويعطيك_, _zakup_,
   {{0x32918031,0x5200b1d3,0x80e5211d,0x158721ab}},	//   _marad_, _hacia_, _बहुमुल्य_, _sortutak,
   {{0x1591d069,0x021941e8,0x9291a186,0x227ed0b2}},	//   _안녕하세요_, _funkciji_, _supak_, _njena_,
   {{0xebf5a0d4,0xac612085,0x8aad625b,0x12bb9130}},	//   _עולמי_, _består_, _berkesan_, _engelse_,
   {{0xe818e045,0x62e831d2,0xbc523234,0x22d97122}},	//   _договору_, _milión_, _giotán_, _izaera_,
   {{0xbc5d00df,0x92d8c022,0xc29180c0,0x317d906c}},	//   _परदेश_, _kamery_, _taraf_, _קירוב_,
   {{0xbc8bc00d,0x622910ac,0xd290f0fa,0xd2d84041}},	//   _дзеці_, _показать_, _sagan_, _samej_,
   {{0x02fc60ff,0xc3a0103b,0xdf2d6171,0xd0f9e2f4}},	//   _blogg_, _ログインして投票, _através_, _forhandl,
   {{0xd27ef06b,0x2b82418f,0x33bef314,0x7394f017}},	//   _meiner_, _standaar, _staviti_, _keisti_,
   {{0x327f4037,0x07e431c7,0xd07820bd,0xd200e1e1}},	//   _utente_, _आधारमा_, _कारखाने_, _wanita_,
   {{0x22fce09f,0x7d1e2133,0x6424101b,0xf290f02c}},	// [8b0] _banget_, _明星大哉问_, _politiik, _gagal_,
   {{0x62cae0c2,0x2e997223,0x626e5101,0x439401ed}},	//   _sindur_, _kontinye_, _autore_, _meist_,
   {{0x77a370ba,0x4a4bb00f,0x52d8d27d,0xe93761e8}},	//   _protecci, _perezida_, _galery_, _posmatra_,
   {{0x1ef1e0f7,0x5b91e041,0x7290c1ab,0xd26cc037}},	//   _विश्वामि, _zamieszc, _delako_, _valore_,
   {{0x53940135,0x46dcf174,0xf2efd0e7,0xb2ff401d}},	//   _neist_, _मंसिर_, _galicia_, _skrifar_,
   {{0x017d909a,0x28b930f6,0x9f5da117,0xce48e12d}},	//   _חילוק_, _конкурсы_, _atrašanā, _polainne_,
   {{0x6290f0e4,0xac76430c,0x930071d5,0xf5ac51bb}},	//   _magam_, _estudos_, _dinamai_, _वीरता_,
   {{0xd291121a,0xed8df1cc,0x27c96059,0x385f2099}},	//   _yazan_, _odgovara, _postanow, _missnoob_,
   {{0xae96b195,0xf2ca7097,0x9287c019,0xd6d05003}},	//   _bastante_, _einde_, _أفراد_, _ट्रिक_,
   {{0x02ca7276,0x42e5c025,0xa91b7125,0x00000000}},	//   _finde_, _통신판매업_, _hoàn_, --,
   {{0xbd96a18c,0x1bdf8194,0xa3564159,0x22918228}},	//   _tallinna, _ruhenger, _hoteles_, _urras_,
   {{0x0e59807b,0xfaee112a,0xef2e1034,0x904d7034}},	//   _kombinaa, _quotidie, _quotidia, _approfon,
   {{0x139420c0,0xdc282193,0xe052813b,0xa2926138}},	//   _teksi_, _sociedad_, _poznámka_, _kurasa_,
   {{0x37832070,0x841dd024,0xadd102cb,0xa26451dc}},	//   _प्राप्ति, _سالگی_, _एकाएक_, _sucursal,
   {{0xd7a4604c,0x5ed60022,0x4213401f,0xe3cf02ce}},	//   _независн, _mužem_, _şehir_, _stavit_,
   {{0x0217d00b,0xa58611d5,0x00000000,0x00000000}},	//   _сигнала_, _diproduk, --, --,
   {{0xb202612b,0x92d8310a,0x00000000,0x00000000}},	// [8c0] _aprile_, _kamena_, --, --,
   {{0xe431f17d,0x62d98132,0x8201a031,0x27a5c114}},	//   _জড়িত_, _gazeti_, _napig_, _exerciti,
   {{0x98372073,0xe290c074,0x4c5360d0,0xc9d9a122}},	//   _паралел_, _silaha_, _सोरेन_, _esperime,
   {{0x1e18e0a3,0xb200c0c9,0xf206e07f,0x00000000}},	//   _galerija, _veliko_, _クリックで拡大_, --,
   {{0x5289c095,0x240731c8,0x8492a1ad,0x527e90b0}},	//   _سقراط_, _सोमदेव_, _जम्मा_, _ajans_,
   {{0x08c89036,0x03f20115,0x1291801f,0x00000000}},	//   _と投票しています_, _burudani_, _hayata_, --,
   {{0x3291a088,0x92b4701f,0x126c207b,0xb2d8e23d}},	//   _napad_, _bence_, _alkoi_, _wifes_,
   {{0x86274114,0xde7c90bd,0x5c5a8228,0x52d85055}},	//   _aplicati, _मोक्ष_, _dreuchd_, _maleh_,
   {{0xb705417d,0x7e5420b6,0x45a60063,0xc2903127}},	//   _অস্বীকার_, _finanzia, _ياقلبي_, _kamani_,
   {{0xa2d980e0,0x8d3cd030,0xac60e035,0xa3a2908b}},	//   _firem_, _发表评论于_, _julukan_, _prape_,
   {{0x92915179,0xc9919061,0x9bb22062,0x00000000}},	//   _pokaż_, _technole, _বেঁধে_, --,
   {{0x8b02f011,0xe712f17a,0x2851422e,0x326c8185}},	//   _форуму_, _форумі_, _chrochad, _nikome_,
   {{0xe98ae0b2,0x00000000,0x00000000,0x00000000}},	//   _priče_, --, --, --,
   {{0xa2918117,0xc20181ea,0x84192005,0xd2d870f4}},	//   _kuras_, _kuris_, _عزوجل_, _panel_,
   {{0x8e06100a,0xb2018315,0x00000000,0x00000000}},	//   _איטליה_, _juris_, --, --,
   {{0x02905009,0x32918002,0x0e73d0bd,0x12e310e0}},	//   _dilay_, _duras_, _सैन्य_, _policie_,
   {{0x0361a0e1,0x5f71a02a,0x99d59005,0x2aa840c3}},	// [8d0] _основу_, _основі_, _منشیات_, _지속적으로_,
   {{0x37a6b059,0x127f710a,0xf9e8507b,0x0a08d0d7}},	//   _spotkani, _nyanza_, _kustannu, _ramayana_,
   {{0x02919108,0x3b09012d,0x92d8e0a2,0xeb0b3036}},	//   _zasad_, _تذكرني_, _baneri_, _一部例外あり_,
   {{0xf2d8f186,0x47a6b0dd,0x4f46903e,0xa046b259}},	//   _liger_, _текстови_, _समाजशास्, _संकलित_,
   {{0x7628b16a,0x5201a076,0xc9546133,0x2200c091}},	//   _navigati, _mapie_, _试用期一年_, _volimo_,
   {{0x32918189,0x736ce14a,0x2b61601b,0x8507215d}},	//   _surat_, _margadh_, _ostetaan_, _romertal_,
   {{0xf248f1df,0xb394712a,0x693f90d4,0xd51b90d4}},	//   _favoriti_, _pense_, _לצערי_, _ההצעה_,
   {{0xcc70416a,0x684641fb,0xe3f98014,0xa2a6c16c}},	//   _website_, _realizad, _virum_, _coobme_,
   {{0x13eb9159,0x92914019,0x417d32a1,0x18095062}},	//   _costa_, _theach_, _parandal, _যথারীতি_,
   {{0x329181a2,0x3291f199,0x925521c5,0x77f03035}},	//   _turas_, _kutak_, _intercam, _शोधयंत्र_,
   {{0xe2920079,0x241582d7,0x9e923045,0x6925a034}},	//   _pisati_, _अन्तर्मु, _потреби_, _главата_,
   {{0xa2010115,0x4e38f12d,0x12799036,0xab88d1fd}},	//   _kabisa_, _carachta, _コミュニケ_, _hobotnic,
   {{0x13343065,0xb0f620d4,0x1d6a4045,0x7c5d21bc}},	//   _दिवसभरात_, _הבחירות_, _показати_, _kostako_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xd947f00d,0xe224521a,0x51c6b16a,0x02c6b061}},	//   _другая_, _belki_, _category_, _categori_,
   {{0xb29031bf,0x73fe50d8,0x9f5db25b,0xd25b90a4}},	//   _zamani_, _amerikai_, _pelancon, _posla_,
   {{0x3ec21099,0xb6310005,0x25078275,0x7f39d135}},	// [8e0] _vientian, _غلطیوں_, _doležal_, _तिलिस्म_,
   {{0xc201f2b0,0x43eb503c,0x038dc024,0x78a420d4}},	//   _butik_, _vietas_, _اشکال_, _אנגליה_,
   {{0x827ec157,0xf8e36008,0xb62ad00b,0x9b7ee0fa}},	//   _fronte_, _prisireg, _користио_, _barnaver,
   {{0x628131e8,0x057771b9,0xfa0c207c,0xcb14d06c}},	//   _proslavl, _autobazá, _maršal_, _אָרטאָדא,
   {{0x89f2a06d,0x00000000,0x00000000,0x00000000}},	//   _regionda_, --, --, --,
   {{0x111b0025,0x485641da,0xebe0d191,0x82d8e037}},	//   _개인정보취급방침_, _əslində_, _ketenter, _chiesa_,
   {{0x2aa7a1d0,0x92f3a06c,0x4c70526f,0xe7b48062}},	//   _programı_, _הרבני_, _webside_, _নিষেধাজ্,
   {{0xa3f8f200,0x791b7044,0x29ab507b,0x32d2800b}},	//   _sigur_, _toán_, _остальны, _делатнос,
   {{0xbd9dc091,0x02d8c002,0x2a0af03a,0x973890b1}},	//   _jednosta, _nadev_, _pomagala_, _unforgiv,
   {{0xa9176030,0xb25a50cd,0x13ebf1ba,0xf947d034}},	//   _地方商务之窗_, _tilla_, _moute_, _средно_,
   {{0x5e952144,0x52d5207c,0x60b5207c,0x4290c0be}},	//   _formiran, _formiraj, _formiral, _maladi_,
   {{0x126c5055,0x366ef133,0x6200518e,0x00000000}},	//   _alloh_, _中国经典经济现代, _kylin_, --,
   {{0xf2b66041,0x2201901a,0xc20111db,0x00000000}},	//   _marcin_, _pusit_, _lucija_, --,
   {{0xb2e852ed,0xc2f05074,0x0c7360a0,0x995851b9}},	//   _poslednj, _milioni_, _agartas_, _posledne,
   {{0x07c3c17d,0xc2003138,0x3200b157,0xcdb43111}},	//   _স্মরণ_, _kamili_, _akcia_, _فوروم_,
   {{0xfc0a6225,0x02fc914d,0x925ad15d,0x00000000}},	//   _singapur, _klage_, _skoler_, --,
   {{0x63ea000c,0xd3687042,0xd72a20cb,0xd290f0a0}},	// [8f0] _uniti_, _наприкла, _चिदम्बरम_, _fhiach_,
   {{0x3951207b,0x5290c0c1,0x32a780f2,0xce31a070}},	//   _automaat, _gydag_, _harby_, _प्रक्षेप,
   {{0xa25b708f,0x62e8e236,0x82e0b0c7,0xb873c316}},	//   _amalan_, _sándor_, _mhargadh_, _procurar_,
   {{0x32d94093,0xf2cae005,0x02249074,0x826e40bc}},	//   _tydens_, _mondja_, _kwako_, _patong_,
   {{0x226e706f,0xcc935160,0xf65a8005,0x434b90d4}},	//   _visoko_, _सुबोध_, _اہلسنت_, _בהנחה_,
   {{0x12e77312,0x36b91150,0x52647116,0x3d28915c}},	//   _bernama_, _tagasisi, _mislim_, _начинает,
   {{0xc3f8a1c0,0x33a92137,0x43a2c055,0x28ba715b}},	//   _qabul_, _maaaring_, _campur_, _contenir_,
   {{0xa404b0dd,0xe201c16a,0xab017265,0x531390d4}},	//   _авганист, _david_, _posición_, _סטיפס_,
   {{0x97ce5062,0xaa8fe065,0xe2d8b0b5,0x8321f14c}},	//   _নোংরা_, _kuningan_, _facem_, _luuyi_,
   {{0xc34b6071,0x35bb316b,0xd49700fc,0xcf69c17b}},	//   _médiaajá, _ступені_, _autokool_, _онлајн_,
   {{0x726ca0e7,0x525ac01a,0x53891002,0x4c75e1ad}},	//   _ambos_, _godly_, _ghaytan_, _बोल्दै_,
   {{0x52da41b6,0x12f05074,0x0f75428b,0x72738063}},	//   _planine_, _bilioni_, _interés_, _dánta_,
   {{0xc2fce1e1,0xb426206c,0x21638036,0xa2c9c186}},	//   _tengah_, _ציוניזם_, _円以上ご注文頂き, _hotlink_,
   {{0xc26c4205,0xb27ef124,0x2290e056,0x00000000}},	//   _pomoc_, _bringt_, _hanafi_, --,
   {{0xc4d6917b,0x8c7cb07b,0x03eb90b6,0x62d822af}},	//   _евентуал, _tekstin_, _costo_, _takes_,
   {{0x92d9c0f1,0xf7ef5018,0x0061c148,0xf4b86041}},	//   _livet_, _चहलकदमी_, _منظره_, _proponuj,
   {{0x420270e7,0x8290c1cc,0x9b32e036,0xc0c1d01b}},	// [900] _varias_, _polako_, _ジの先頭へ_, _основе_,
   {{0x9637f059,0xb2e5e18e,0xd21261b9,0x00000000}},	//   _reklamow, _shinhwa_, _grohl_, --,
   {{0x2290e199,0xf2247274,0x8c6421e8,0x9e96c148}},	//   _ionako_, _benki_, _sintezu_, _مرسوم_,
   {{0x62e252cf,0x14850207,0xfc08e00a,0xb8524133}},	//   _जगदीश_, _स्नातक_, _involved_, _中文科技期刊数据,
   {{0xd3f950c1,0xee91604b,0x272e1059,0x82b31131}},	//   _ligula_, _histoire_, _zapamięt, _meadhan_,
   {{0x8319c019,0x584d2008,0xb2d8a0ba,0x00000000}},	//   _إيران_, _sistemos_, _sabem_, --,
   {{0x12f0c132,0x02cb8002,0xaf90c024,0x127f4317}},	//   _hadithi_, _qordu_, _صنايع_, _siendo_,
   {{0x503a022b,0x63009105,0xf2911055,0x23eb5017}},	//   _आत्माराम_, _separuh_, _sacara_, _vietos_,
   {{0x8334c166,0xd3ea7166,0x60afe18d,0x627f71f2}},	//   _آذربایجا, _sinta_, _контракт_, _afande_,
   {{0x56aee036,0x5c17a0d4,0x62ca7074,0xb2d6b099}},	//   _ジのトップへ_, _בגליל_, _pinda_, _poglaus_,
   {{0x6ad73003,0x6307b0a6,0xb2ca4067,0xfaf57186}},	//   _postitat, _komandi_, _kellegi_, _moroccan_,
   {{0x42492040,0x4992c1cd,0xe8768008,0x53f84072}},	//   _thyme_, _weekende, _янукевіч_, _namus_,
   {{0x63eb81bc,0xf968a135,0x4c549124,0x00000000}},	//   _sortu_, _reformie, _vertrag_, --,
   {{0xe3eb80ba,0x0b1e81d8,0xf808b004,0xe847a063}},	//   _morts_, _campagne, _cuocsong, _اللواء_,
   {{0x122b810b,0x487d80b5,0x4e10f041,0x0fb69031}},	//   _siempre_, _комемора, _राऊरकेला_, _kattints_,
   {{0xdbad6024,0x3faa4062,0x6f3810e0,0x00000000}},	//   _فتوشاپ_, _পড়াশোনা_, _संबिधान_, --,
   {{0x962f72a9,0x427ef2fa,0xe2e09154,0x42d82146}},	// [910] _demograf, _opinii_, _profiili_, _saker_,
   {{0x02247260,0x820180f3,0x426c3235,0xbf0b90bf}},	//   _senki_, _saria_, _domova_, _premijer_,
   {{0xfe725067,0xc273a318,0x0fbc70a4,0xdf0d7297}},	//   _लास्ट_, _peribadi_, _englesko, _mascotas_,
   {{0x063682e8,0x06c73025,0xa2d4106c,0x00000000}},	//   _vikipedi, _고객님께서_, _אנטקעגן_, --,
   {{0x163682e8,0x87e62022,0x65368223,0xf53b4024}},	//   _wikipedi, _अवार्ड_, _wikipedy, _گردشگری_,
   {{0x4f3a5276,0x5052c04f,0x120090ad,0x83a29112}},	//   _brancher_, _smartfin, _phais_, _drapo_,
   {{0x47a7312a,0x1e5361a1,0x23f84055,0x225be002}},	//   _partenai, _inscrire_, _kamus_, _motlh_,
   {{0x13f840d0,0x222ac0f5,0xd2d842af,0xb3dc1208}},	//   _jamus_, _гонар_, _james_, _plhws_,
   {{0xe2fca051,0x746e11e2,0xa2918166,0xd9aac045}},	//   _skrivet_, _mendirik, _jaran_, _годин_,
   {{0x42918124,0x4e314063,0x325a21c4,0x62018170}},	//   _daran_, _العتيبي_, _mikla_, _darin_,
   {{0xc84c11a1,0x99e852f1,0x8d2cb170,0x00000000}},	//   _certains_, _dostignu, _berichte_, --,
   {{0xc201f088,0xf38060f7,0x4e76608d,0x72a05073}},	//   _naziva_, _korral_, _ময়মনসিং, _fotbal_,
   {{0xbf65e0b6,0x1b84001b,0xb7315135,0x97b4c25b}},	//   _автомоби, _телеради, _kelleleg, _menerang,
   {{0x93ea917c,0x320e10a7,0x2fb6a07b,0x00000000}},	//   _viata_, _натал_, _hallinno, --,
   {{0x225a50a0,0x925be002,0x0ae52162,0x00000000}},	//   _gille_, _dotlh_, _सत्यता_, --,
   {{0x32ca912c,0x6c34f073,0xa575106c,0xe25ba058}},	//   _tiada_, _descoper, _רעזולטאט_, _toplo_,
   {{0xcae6808d,0x32918131,0x73870051,0xb2d89061}},	// [920] _ভয়াবহ_, _caran_, _klarar_, _sbaen_,
   {{0x92b650b0,0x6ece9133,0xa2ca506b,0x00000000}},	//   _touche_, _上海联放贸易有限, _bilde_, --,
   {{0xac5bf01f,0xf615a06c,0xee29b036,0x43f9e122}},	//   _listesi_, _מוצאי_, _ジャンルランキン, _ditut_,
   {{0x82018257,0xa2d8502b,0x435e719e,0x740e70a5}},	//   _farin_, _valet_, _edifici_, _edificio_,
   {{0xd321918b,0xb2019316,0x72918177,0x59d0a130}},	//   _tasya_, _assim_, _garan_, _advertee,
   {{0x22926120,0xf25a50cd,0xb9d22156,0x9146f041}},	//   _burada_, _tille_, _inregist, _मामूली_,
   {{0x220270e7,0x5290e319,0x4291c0ef,0x50627090}},	//   _varios_, _dinama_, _duvar_, _परासी_,
   {{0xf27f40a9,0x7b2d208f,0x8d86b026,0x23a92081}},	//   _cienco_, _jambatan_, _entendre_, _živote_,
   {{0x4e7370bd,0x2b6a8060,0xbde8e0c3,0x1d3d90b6}},	//   _रहस्य_, _заробљен, _커뮤니케이션_, _tecniche_,
   {{0x8242e0cb,0x73bc20bf,0xac1b9213,0x62918203}},	//   _चावला_, _слободно_, _dilancar, _varan_,
   {{0x7291818b,0x0f540133,0xcbe210c4,0xe29190f8}},	//   _waran_, _建设项目环境影响, _omsendbr, _nasan_,
   {{0xc291f01b,0x12ba70e4,0x1984d008,0xc6e21036}},	//   _ostaa_, _mondani_, _papildyt, _この回答への補足_,
   {{0x830672d7,0xc3f9e1d9,0xf3f8821c,0xa3f8814c}},	//   _द्वितीया_, _titul_, _pokuse_, _yakuna_,
   {{0x63833069,0xa200e27d,0x8c85b06c,0xa2da01c3}},	//   _자유게시판_, _geniet_, _מוזיי_, _museli_,
   {{0xd201a0f6,0xb291a241,0x00000000,0x00000000}},	//   _lapin_, _lapan_, --, --,
   {{0x02918223,0x22018121,0x5340e170,0x02da01bd}},	//   _paran_, _parin_, _gelesen_, _áreas_,
   {{0xe25a51f9,0xaf5c6063,0x6cb37132,0x79fe4081}},	// [930] _sille_, _هههههههه_, _jumatatu_, _atrament,
   {{0x4b257122,0x72e5900c,0x2346c087,0xe21c6129}},	//   _uniberts, _teknika_, _gliders_, _wither_,
   {{0x1268b1d7,0xa52bb10a,0xc45501c5,0x02a741cc}},	//   _контакти_, _munyakaz, _producto_, _trebao_,
   {{0x824d8076,0x0f5c3213,0x3332d131,0xa291a065}},	//   _मसाला_, _bagaiman, _etext_, _kapan_,
   {{0x7bdfc18d,0x927ee25e,0x1a0080e2,0x4c67d00e}},	//   _modeller, _venner_, _misalnya_, _yolunda_,
   {{0xc2916055,0x426c5071,0x620df0b5,0x82fc6017}},	//   _nagara_, _dolog_, _апринса_, _blogo_,
   {{0x32918024,0x8394f178,0x0378a189,0x277bc114}},	//   _saran_, _priser_, _makanan_, _ачест_,
   {{0xb83ec0bb,0x8320910a,0xd2eff0a4,0x7b6c717b}},	//   _ринку_, _nyayo_, _nedostaj, _imprensa_,
   {{0x326d00ce,0xeea21186,0x03f8502c,0x327ed0cd}},	//   _kaboul_, _assurant_, _jalur_, _gjeni_,
   {{0x616e731a,0xf4297133,0x43ebe15c,0x6c4ee1c3}},	//   _presseko, _国家烟草专卖局_, _totta_, _servery_,
   {{0x9248907e,0x637f6012,0x00000000,0x00000000}},	//   _upama_, _избранно, --, --,
   {{0x1d5d907b,0xac620035,0x131741b9,0x5bf1000c}},	//   _популярн, _turunan_, _brezno_, _boathous,
   {{0x9c0c80c3,0x7386e00b,0x09ca3133,0x9200c0b2}},	//   _무이자할부_, _zbirka_, _国家环境保护总局_, _molimo_,
   {{0x40f3a06c,0x00000000,0x00000000,0x00000000}},	//   _דאטום_, --, --, --,
   {{0xf2b4d022,0x92d8c03e,0x13183175,0x87410133}},	//   _trochu_, _radek_, _paschal_, _政治交接学习教育,
   {{0xf386e184,0x7d113072,0x00000000,0x00000000}},	//   _foirne_, _устаноў_, --, --,
   {{0xe201901f,0x00000000,0x00000000,0x00000000}},	// [940] _nasil_, --, --, --,
   {{0x3c5b800b,0x2616900d,0xeda8d16e,0xe8490144}},	//   _sastoji_, _кажуць_, _aktivita, _primenju,
   {{0x9d0b21e8,0xf394900a,0x2378d064,0x9af41211}},	//   _patrijar, _least_, _ramazan_, _kafedras,
   {{0x62d850f1,0x5200900e,0xa20180e5,0x46de10c3}},	//   _taler_, _sakini_, _wario_, _워디안이나_,
   {{0x89ea816e,0xa3900055,0x9290d0db,0x152e00d4}},	//   _सोमवारी_, _المالکي_, _senare_, _לונדון_,
   {{0x13a2414c,0x42fa30bd,0x220180f8,0x13423034}},	//   _kumpi_, _kuchnia_, _baril_, _accesso_,
   {{0x6717f00b,0x18cf1095,0x3278609e,0xd386031b}},	//   _факултет, _مصيبت_, _apunta_, _amire_,
   {{0x5ddc2071,0x620190be,0x7daa21d5,0x02ca7036}},	//   _حلقوں_, _fasil_, _pariwisa, _vinde_,
   {{0xa3940230,0x262eb034,0x035590f1,0x034671c3}},	//   _ceist_, _операция, _videoer_, _liberec_,
   {{0x5fed2030,0xc3f85129,0x2291f072,0x22d831a6}},	//   _百度知道投诉吧_, _valur_, _butas_, _objet_,
   {{0xa3eb5117,0xe31390a7,0xd2cb80ba,0xba207195}},	//   _lietas_, _компет_, _jordi_, _públicas_,
   {{0xb5960025,0x4c1d205d,0x42c1c054,0x29de0170}},	//   _클릭하세요_, _intambar, _collega_, _vergesse,
   {{0x2f2241aa,0x23a260d0,0x7f65331c,0x026e11ba}},	//   _acelerar_, _eropa_, _रामचन्द्, _repons_,
   {{0x6713417b,0x3316914b,0xa378e055,0x871f6012}},	//   _сексуалн, _imaze_, _kalayan_, _спрашива,
   {{0x53f980a9,0xed1c8087,0x82d87116,0xf2df1040}},	//   _virut_, _follicle_, _danes_, _whining_,
   {{0xe25a9100,0xb723a261,0x790170f2,0x00000000}},	//   _ciall_, _faktorom_, _nararamd, --,
   {{0x9097c00a,0x0201b05a,0xa344b1e4,0xf20180b6}},	// [950] _האלקטרונ, _divini_, _firenze_, _varie_,
   {{0xb1ed031d,0xbb88e1ed,0x4200b31e,0x33a2d035}},	//   _धरहरा_, _aktivier, _ledige_, _tropis_,
   {{0x578c10d4,0x4c736031,0x96b03035,0x73ebf1c4}},	//   _להצביע_, _andrás_, _वस्तू_, _flutt_,
   {{0x02eb100a,0x327ef03f,0xa2d430b8,0x23bab002}},	//   _digital_, _seiner_, _tailieu_, _blevins_,
   {{0x12919026,0x52019065,0x6201f163,0x00000000}},	//   _casal_, _rasio_, _astig_, --,
   {{0x829180e4,0x927f5054,0xbd80d067,0xa968d00a}},	//   _darab_, _brengt_, _स्पष्टता_, _estimate,
   {{0x0124109a,0x420191e2,0x5d02f31f,0x2294106c}},	//   _הרבנים_, _nasib_, _pertenec, _הרבנית_,
   {{0x5ca78034,0x44399034,0xd2fc10f4,0x2c6f01c1}},	//   _редакция_, _програма, _actually_, _úprava_,
   {{0x6291a038,0xee015112,0xf611c0d8,0xabfcd024}},	//   _aspak_, _komemora, _probléma_, _بدهید_,
   {{0xe16920e5,0x77c8c21c,0x63cbb0bd,0x0c606072}},	//   _presenno, _poisteni, _पश्चात्_, _kartais_,
   {{0x436140d7,0x7201c02b,0x1386922e,0xf30c42fc}},	//   _lingvoj_, _pavia_, _scarp_, _strachu_,
   {{0xca168022,0xbdbcc157,0x277e2151,0x1224f1ba}},	//   _osobnost, _investíc, _drawstri, _efikas_,
   {{0x4290d1f4,0xb26c1119,0xc909123e,0x39cd2093}},	//   _sheas_, _sohoa_, _песама_, _minderhe,
   {{0x125a5129,0xcdee5087,0x18d2c1c6,0x327ee051}},	//   _billi_, _bridgewa, _sobreviv, _kunnat_,
   {{0x327f41aa,0xb75b820d,0x5fe6a0e1,0x435bc041}},	//   _frente_, _मार्केट_, _приступ_, _कुरैशी_,
   {{0xf0ddf206,0x727eb030,0x00000000,0x00000000}},	//   _branitel, _agence_, --, --,
   {{0x0477a12b,0xa27ff136,0xd3550159,0xa3eb90b6}},	// [960] _проекти_, _jkunu_, _recetas_, _costi_,
   {{0xcaaa407b,0x326c21f1,0x92fe616f,0xe8fb8122}},	//   _компании_, _pokok_, _mtbiker_, _hamarkad,
   {{0xb2006173,0x8290b186,0x00000000,0x00000000}},	//   _chois_, _madali_, --, --,
   {{0xf26c10ac,0x33f88136,0xa29260cc,0x34a8a025}},	//   _johon_, _iskuna_, _agrada_, _maximaal_,
   {{0x43874021,0x00000000,0x00000000,0x00000000}},	//   _acerca_, --, --, --,
   {{0xb3ead16b,0xd047c15f,0x227ed1f4,0x8be74135}},	//   _vieta_, _законот_, _tional_, _kategoor,
   {{0x884150f0,0x98c55035,0x944bd051,0xd25ae0ac}},	//   _callixtu, _जवळपास_, _undersök, _joilla_,
   {{0x9b65b023,0x4845b1bd,0xf977b109,0xb02c91a4}},	//   _utilizar, _utilizad, _indirett, _wiaderko,
   {{0x6e8bf0bd,0xe35850b8,0xb2ae91b7,0x272511ed}},	//   _प्रत्यय_, _webgame_, _kazališt, _trotzdem_,
   {{0x95dbc025,0x0c38b239,0x1c6060b0,0x00000000}},	//   _마지막으로_, _podpreds, _distans_, --,
   {{0xfee6e087,0x582f5041,0x3a2d5167,0x1a68a06d}},	//   _machinin, _skomentu, _jaunākās_, _şüşəqald,
   {{0x1310724d,0x410901d7,0xfe9e200d,0x585dd150}},	//   _kurziv_, _норвегия_, _паўла_, _teenistu,
   {{0x43ea501b,0xc7f7f0f5,0x00000000,0x00000000}},	//   _silti_, _каталёг_, --, --,
   {{0x53950109,0xd2ca508c,0xc2da518b,0x5aedd034}},	//   _klassi_, _pildi_, _isteri_, _requisit,
   {{0x02f71271,0x1ecda1d0,0x12f100e4,0x252d0192}},	//   _novinek_, _gerektiğ, _fizikai_, _composto_,
   {{0x1d7a727b,0x32ca51c4,0xe3a2c1ce,0x42d801ed}},	//   _kommende_, _vildi_, _campos_, _spiel_,
   {{0x23ea70ac,0x9345b0e9,0x6278701e,0x0b11a063}},	// [970] _hinta_, _studiju_, _kornet_, _cásanna_,
   {{0x05e600b6,0xdaba501b,0x00000000,0x00000000}},	//   _търговск, _компаний_, --, --,
   {{0x95e0d1f0,0x1feee005,0x00000000,0x00000000}},	//   _literatú, _بسلسلہ_, --, --,
   {{0x43f990a3,0x33cf5058,0xe2d990c3,0x33871235}},	//   _visus_, _krevet_, _eiser_, _dobrou_,
   {{0x9eb6c01b,0xc224f11b,0xd61e3114,0x2e3980d1}},	//   _профиля_, _funkar_, _imposibi, _vivncaus_,
   {{0x23f461a6,0xaa18e059,0x23ebf1d9,0x0201e032}},	//   _partie_, _प्रोफ़ाइ, _touto_, _matin_,
   {{0xc278600e,0x52ff5145,0x722e01c1,0x9dcc4036}},	//   _chunki_, _arritur_, _pravidel, _この記事へのコメ,
   {{0x326c81e8,0x13f9a08f,0xf07ec12b,0xbafd9125}},	//   _tokova_, _siput_, _правилно_, _nghếch_,
   {{0x62ca7016,0x13fc603b,0xd68e70e5,0x6248c205}},	//   _ainda_, _リクエスチョン_, _proffesi, _filmov_,
   {{0xb51e317a,0x4201f1cc,0x520160d8,0xe3f1506a}},	//   _формуван, _istim_, _megint_, _associaz,
   {{0x52d8a1d0,0x53eb0112,0x2c9e00e5,0xc34310dc}},	//   _haber_, _pratik_, _ngogledd_, _भ्रूण_,
   {{0xd14a703f,0xa29b002d,0x32b660c1,0x13f9a0cc}},	//   _kostenlo, _ekspertl, _parcio_, _tipus_,
   {{0x8c7160dc,0xf3ead0a3,0x8b1e8276,0x356010c3}},	//   _डिप्टी_, _lieto_, _kampagne, _사람입니다_,
   {{0xb291d111,0xdefdd012,0xa2fb101b,0x28c91200}},	//   _yawan_, _политиче, _автора_, _ретард_,
   {{0x7ae2f09b,0x63fa800b,0x75a3d0e6,0x4e72129f}},	//   _portugee, _самостал, _सनातन_, _वॉर्न_,
   {{0xda326160,0x22e341db,0x7290c132,0x00000000}},	//   _फर्जी_, _printaj_, _halali_, --,
   {{0xce14a1d2,0x1201e0bc,0x842c502f,0xd41c5108}},	// [980] _zamestna, _natin_, _technick, _technicz,
   {{0x1ec29005,0x02ca710a,0x92ebd0c7,0x0c04406d}},	//   _تمہارا_, _bindi_, _muintir_, _prosesi_,
   {{0x3e46c008,0x8dfbe0b8,0x425ad320,0x4130a133}},	//   _kataloga, _nukeviet_, _cielo_, _基本比萨汁_,
   {{0x9766a0c3,0x5201e111,0xf89aa039,0x79e82022}},	//   _마찬가지로_, _batin_, _سرفراز_, _dobrodru,
   {{0xda722034,0xf26c711b,0x00000000,0x00000000}},	//   _акция_, _honom_, --, --,
   {{0xc2246058,0xd25a90bd,0x00000000,0x00000000}},	//   _otoka_, _miala_, --, --,
   {{0x018dd250,0xbefc20b6,0xd2d9a04b,0x427f7115}},	//   _probleml, _руски_, _favoris_, _chanzo_,
   {{0xb25a8004,0x94561199,0x9201e22a,0xa2016025}},	//   _daklak_, _pravilan_, _fatin_, _begint_,
   {{0xec051005,0x40db913b,0x020190bd,0x82ca7194}},	//   _گناہوں_, _एलसीडी_, _kasia_, _zindi_,
   {{0x1582f03f,0x2394d29c,0x673030c3,0xe3583075}},	//   _datensch, _meest_, _연구회단독_, _dopravní_,
   {{0xa962d030,0x5650b030,0x42e8e203,0xe26ce0f9}},	//   _商务部网站版权与, _胶南市教育体育局_, _polisen_, _ponosa_,
   {{0xcc6a31e7,0xf3f471f3,0x8761d0ca,0xa2d830cd}},	//   _odvtedy_, _turtas_, _bežanijs, _koment_,
   {{0x920250fd,0x0764c070,0x83eae0b6,0xcf2121eb}},	//   _mutima_, _पोस्टेड_, _contro_, _espedien,
   {{0xc3959128,0xc9e2f27d,0x83031100,0x57546036}},	//   _moyses_, _portefeu, _malairt_, _最新から表示_,
   {{0x0d8680cc,0xa2d630f7,0x446681bd,0x0e0b2026}},	//   _novembre_, _selleks_, _novembro_, _aliments_,
   {{0x0d2e917d,0x02ca7128,0x020061a6,0x58a73005}},	//   _সারাদিন_, _rindi_, _choix_, _ہوچکا_,
   {{0x7611c1c1,0x9394e053,0x46cdb06c,0x0bd2e0bd}},	// [990] _problémy_, _avisen_, _ויואל_, _घटिया_,
   {{0xb2ca5177,0x23a24002,0x1849e19c,0xe22570c4}},	//   _bildu_, _pumpu_, _postboks_, _skakel_,
   {{0xfa45c077,0xf386d2ec,0xb25af050,0xeab89182}},	//   _finestra_, _emere_, _anglu_, _црногорс,
   {{0xfe68405f,0x737301a6,0x5bf3007c,0xbf63004b}},	//   _дискусиј, _semaine_, _saglasno_, _semaines_,
   {{0xecdf3030,0x627f701f,0x62fc9014,0x195c802b}},	//   _欢迎批评指正_, _ajanda_, _slags_, _списку_,
   {{0x09f22070,0x5c5510b0,0x99cd1014,0x22eb50eb}},	//   _आयुर्वेद, _kantite_, _myndighe, _dijital_,
   {{0xf8b63292,0x8291615d,0xb29271bf,0xe9132189}},	//   _درويش_, _ligaen_, _miradi_, _membangu,
   {{0xbc7f4133,0x437f814b,0x00000000,0x00000000}},	//   _返回黑龙江主站_, _muhanda_, --, --,
   {{0x91c33321,0x925ad261,0x8dc8b131,0x00000000}},	//   _autorské_, _ciele_, _cathcart_, --,
   {{0xf3eae223,0xa3f460f1,0xc4138052,0x698c214b}},	//   _kontan_, _datter_, _taksiran_, _imihanda_,
   {{0xf2fc017a,0x02026193,0x3da3c008,0xe1e7e003}},	//   _enige_, _arriba_, _nemokama, _उधारी_,
   {{0xb2fd602a,0x726530fd,0xd379e04c,0x128ce02e}},	//   _ligger_, _yerusaal, _tamanho_, _melkein_,
   {{0x03eae05a,0xb25a911c,0xc2d8c097,0xe9a2d156}},	//   _lontan_, _ciali_, _nader_, _инфлуенц,
   {{0xd3a8217c,0x30d6200a,0x8529d034,0xed153202}},	//   _privind_, _מבזקים_, _реакция_, _klassisc,
   {{0x9c08805f,0x42d9915f,0x6ab0a01b,0x3d04c07e}},	//   _традициј, _esses_, _merkitys, _توجهی_,
   {{0xee4c200a,0x825ad16f,0xf6b361f3,0xe1bc817d}},	//   _מלאכים_, _biele_, _pristaty, _মেঘের_,
   {{0xab9281d0,0xeaf53045,0x6b95106c,0x28bfe021}},	// [9a0] _ingilizc, _referans, _פאשקעווי, _enfermed,
   {{0xb27e016a,0xf3ead1b9,0x8154601b,0x325aa0cd}},	//   _being_, _viete_, _prosesso, _bibla_,
   {{0x83f45186,0x9c56a15d,0x03f4716b,0xa2d8c036}},	//   _rattle_, _kortere_, _kartus_, _lader_,
   {{0xabd92005,0xfa58302b,0x00000000,0x00000000}},	//   _دکانیں_, _rodentia_, --, --,
   {{0x3f6b2083,0x4efb200b,0x93ea01ba,0xd291e186}},	//   _стране_, _страни_, _chita_, _matam_,
   {{0x027f70be,0x14bc3231,0xebdc70c3,0x3ddee036}},	//   _franse_, _तांडव_, _한국과학기술연구, _昭和つっても幅広,
   {{0x0249925b,0xd68c2094,0xf4f6b060,0x4693315b}},	//   _rasmi_, _नाबाद_, _скениран, _superaci,
   {{0x3058006c,0x1e25d21f,0x36aa90b5,0xd355d243}},	//   _דערביי_, _confirma, _стация_, _confira_,
   {{0xeda81177,0xaef7f05c,0x67f82019,0x15fce133}},	//   _donostia, _фирмата_, _لبرنامج_, _中央人民广播电台_,
   {{0x02ca70ed,0x648670d0,0x64a5f0d4,0x927860e2}},	//   _findu_, _प्राणा_, _clinical_, _ibunya_,
   {{0x0f90d12d,0x430f61eb,0xf27e90eb,0x8a343024}},	//   _يناير_, _berbera_, _adana_, _هستیم_,
   {{0x1069212b,0xb295c129,0xe2a6d1b0,0x0202601f}},	//   _competen, _dipartim, _osobno_, _harita_,
   {{0xcd31412d,0x3c76c153,0x225ad206,0x9278606d}},	//   _وووووووو, _मरम्मत_, _stolni_, _olundu_,
   {{0x12d451f0,0xeff1111b,0x8c662043,0x33a2d166}},	//   _ľudia_, _miljoner_, _samtals_, _krepa_,
   {{0x52aef0f9,0x7292515f,0xe678a18d,0xe0ca4272}},	//   _stratešk, _estava_, _водночас_, _múltiple,
   {{0x9fc0d020,0xffdd3063,0xa157f151,0x4ea15045}},	//   _literatū, _العبد_, _sourcebo, _sitemaps_,
   {{0xc68221e6,0xddcb3111,0x00000000,0x00000000}},	// [9b0] _अखबार_, _اثبات_, --, --,
   {{0x427e00c5,0xc6b2c071,0xdd87a022,0x31acb01f}},	//   _meine_, _تمہاری_, _objednat_, _bakanlığ,
   {{0x12fcf24b,0x45d6f019,0xd2908055,0x22d9e283}},	//   _logga_, _forbarth, _tukang_, _vitet_,
   {{0x49e3c168,0x0bf0d03e,0x9f4510c5,0x00000000}},	//   _допаѓа_, _mistrovs, _sonstige_, --,
   {{0x026ca10e,0x020161e1,0x463c918d,0xcda3906c}},	//   _pobol_, _begitu_, _feminini, _קנעפל_,
   {{0x9255c0f7,0x03ea711a,0x6b99e23a,0x1201203e}},	//   _विशेषः_, _bintu_, _forhindr, _kabiny_,
   {{0x82e18322,0x12f2f06d,0x36513035,0x922500fa}},	//   _जागीर_, _radiosu_, _गोंधळ_, _þakka_,
   {{0x42d98070,0x72fcf1c4,0x7c457169,0xcec21203}},	//   _maret_, _bogga_, _guswera_, _eveneman,
   {{0x8ed9f017,0x00000000,0x00000000,0x00000000}},	//   _aplinkos_, --, --, --,
   {{0x42d8c097,0x8c454158,0x012d3072,0x00000000}},	//   _vader_, _servrar_, _нафты_, --,
   {{0xd395812b,0x72014038,0x8ba141ad,0x00000000}},	//   _verso_, _mediat_, _भारतको_, --,
   {{0xd7928029,0xa3d4d048,0x52ca3025,0xacffe0fc}},	//   _интересу, _kararı_, _geldig_, _reguleer,
   {{0xcaeeb146,0x821ba1c1,0x43451030,0x113a9041}},	//   _fastighe, _virtuáln, _américai, _पोंटिंग_,
   {{0xce0cc03b,0x7f508005,0x3c5281e2,0x4287a076}},	//   _ドを入力してくだ, _فیڈریشن_, _bantuan_, _पर्यवेक्,
   {{0x0d5a1034,0xf1b5e204,0xcaf240f9,0x1493a067}},	//   _корея_, _стандард, _pokrovit, _एम्मा_,
   {{0x227e01ed,0xea140144,0xe2d8c137,0xb2d9800c}},	//   _keine_, _podacima_, _pader_, _daret_,
   {{0xd3c721f0,0x23f9e020,0x43866122,0xa7d9518f}},	// [9c0] _hospodár, _citus_, _umore_, _klassenf,
   {{0x2290a140,0xf201c077,0x2758e041,0xc2ea40b9}},	//   _akbar_, _havia_, _मुद्दों_, _marián_,
   {{0x137a80c1,0x12489143,0x81a5c005,0x43f9e055}},	//   _allanol_, _upami_, _سنجیدہ_, _fitur_,
   {{0x74695007,0x93ced051,0xfb8231df,0xf0472013}},	//   _християн, _provat_, _umanitar, _часовой_,
   {{0x426ca0b7,0x42352136,0x8682003e,0x00000000}},	//   _sobom_, _evidenti_, _एकसाथ_, --,
   {{0x13f9e065,0x8ae13062,0xceae90c3,0xf300d23e}},	//   _ritus_, _বইপাগল_, _쿠폰적용가_, _ostalih_,
   {{0xad854022,0x92b08135,0xc340e18f,0x00000000}},	//   _एकीकरण_, _हमहुँ_, _gelezen_, --,
   {{0xf291f0ba,0x1c18e022,0xe20871b7,0x00000000}},	//   _estan_, _दृष्टान्, _očito_, --,
   {{0x7c7e0276,0x23f9e0cd,0xc2fc714c,0x42d9808a}},	//   _carsten_, _ditur_, _songa_, _darem_,
   {{0xe291117a,0xc34520b1,0xe24af114,0x00000000}},	//   _debatt_, _handout_, _асигурар, --,
   {{0x52c74049,0xce35d0bd,0x56965064,0x8052e0c3}},	//   _masline_, _opracowa, _adresini, _생각됩니다_,
   {{0x874c0101,0x94987261,0x4316d091,0x3e73b0bf}},	//   _растения_, _holandsk, _trebali_, _nadležno,
   {{0xa386d008,0x42d8f014,0x280ac0dd,0x3a966067}},	//   _sporto_, _dages_, _струја_, _उम्मेद_,
   {{0xba83b069,0x3c76d070,0xdfde4063,0xf2d8611c}},	//   _beginnen_, _मिश्रण_, _بسهولة_, _nplej_,
   {{0xf3958121,0x23f9e16e,0xe3f4616c,0xec61708c}},	//   _berse_, _situs_, _marthe_, _virumaa_,
   {{0x945e10d4,0x5bc27025,0x2201f284,0x3201912e}},	//   _נוסעים_, _크게보기를_, _fuzija_, _ebyiri_,
   {{0xe3eb917c,0x0c2a62ab,0xb25b00f9,0x72b85122}},	// [9d0] _niste_, _vlastnos, _stalni_, _handiak_,
   {{0x2225808e,0x42f1c18c,0x28392034,0x58c54300}},	//   _werke_, _सबेरे_, _последна_, _जातपात_,
   {{0x77185012,0x63f8f166,0xf2b8106c,0x42bca112}},	//   _контакты_, _bagus_, _רעדנער_, _mondyal_,
   {{0xe3f02037,0x5c7060df,0xe837c0b5,0x425ad1b9}},	//   _informaz, _लिट्टी_, _баладе_, _biela_,
   {{0xe20270b6,0x8172b066,0x29416077,0x7b89c002}},	//   _musica_, _उत्सव_, _estudiar_, _reynaldo_,
   {{0x4291f1e8,0xc3ea50d9,0x4c843034,0x7c95d005}},	//   _lazara_, _kilti_, _турски_, _دستبردار_,
   {{0xb3169169,0x9e9220dd,0x22d98091,0xc3dc1002}},	//   _amaze_, _форумот_, _barem_, _johwi_,
   {{0x12d9f1b9,0xad9ac05c,0x2f2fb015,0xe37bd0d5}},	//   _kvality_, _статии_, _nestoria, _गोविन्दा_,
   {{0x62d98150,0x00000000,0x00000000,0x00000000}},	//   _varem_, --, --, --,
   {{0x926c40c6,0xb3f98124,0xa5d090f2,0xa291f0b7}},	//   _nomor_, _warum_, _kapamily, _ostao_,
   {{0x4cb30055,0x50ab8059,0x6ee1c067,0xd92b802b}},	//   _انشاالله_, _elementy_, _विद्यादा, _elementa_,
   {{0x8920d154,0xaeb25163,0x826cc185,0x00000000}},	//   _रामजी_, _seashore_, _vodom_, --,
   {{0x9637408c,0x1274323e,0x10c40005,0x5dd2d0a6}},	//   _politsei, _пермалин, _انسپکٹر_, _merkinga,
   {{0x53f98157,0x123c2025,0xe2c650b5,0x69e8e01a}},	//   _daruj_, _normaal_, _incluse_, _muntinlu,
   {{0x67a39057,0x7f252032,0x92b58031,0xb28f5136}},	//   _puntuaci, _utiliser_, _perce_, _pappagal,
   {{0xadfdc04c,0xd6a30063,0x208da0d4,0xf3f46073}},	//   _галерија_, _aistrith, _השקעה_, _martie_,
   {{0xc3940115,0xa144b220,0x00000000,0x00000000}},	// [9e0] _ofisi_, _mealladh_, --, --,
   {{0x12909137,0xa3948166,0x026d21b3,0x136b10a7}},	//   _sakali_, _langkung_, _otcovi_, _апэрэрий_,
   {{0x32fc7237,0x9b0570e5,0x3cd48235,0x56839159}},	//   _longo_, _ddosbart, _uskutečn, _tendenci,
   {{0x6d5ac214,0x4aeb901b,0x00000000,0x00000000}},	//   _совет_, _kokonaan_, --, --,
   {{0x9049017d,0xa31920f2,0xa4b870ab,0x5d1b3130}},	//   _ফারজানা_, _kabilang_, _एवरेस्ट_, _avonture_,
   {{0x33eae148,0x1303c170,0xbfe071dc,0x62efd274}},	//   _konten_, _bekannt_, _periculo, _kulinda_,
   {{0xe212b0be,0x02d98150,0xb91e11f0,0x31f240f0}},	//   _mache_, _parem_, _trenčín_, _luangnam,
   {{0xc84d2022,0x71c48133,0x00000000,0x00000000}},	//   _naposled, _人在草木中_, --, --,
   {{0x2acfa12d,0x7e186140,0x4d35d017,0x8200d189}},	//   _نوفمبر_, _irregola, _славян_, _kuning_,
   {{0xeb72d034,0x520c81a4,0xf26b10a7,0x1378f124}},	//   _стана_, _dóigh_, _асигурат, _monaten_,
   {{0xc9f9f11a,0xd3a24046,0x22b49100,0x43053075}},	//   _alfajore, _kampo_, _teacs_, _obrazem_,
   {{0xd7a8212a,0x09e82170,0x25982031,0xc102816e}},	//   _impressi, _impressu, _impressz, _प्रश्_,
   {{0xf26c428e,0x00000000,0x00000000,0x00000000}},	//   _somos_, --, --, --,
   {{0xa4ba0025,0x427ee096,0x4979f0db,0x220180c4}},	//   _중국국제전화카드_, _bringe_, _gymnasie, _skrif_,
   {{0x8365b059,0xe9abd00b,0x3c1192df,0xd950e1f4}},	//   _मुरैना_, _стално_, _angqang_, _aislinge,
   {{0x59977323,0x702e20b6,0x128f909c,0x6387f1c4}},	//   _प्रशिक्ष, _condizio, _punktum_, _spurt_,
   {{0x8416a17d,0x31ab7034,0x12927093,0x4bcb7034}},	// [9f0] _বোধহয়_, _commenti_, _marais_, _commento_,
   {{0xb229b135,0xd9d6613b,0x02da208c,0x00000000}},	//   _रामचेला_, _अभियोग_, _tänava_, --,
   {{0x2291801f,0x8c537052,0x526d52d1,0x72927148}},	//   _biraz_, _mustapa_, _logora_, _اشتیاق_,
   {{0x475a304b,0xe9673015,0xc29180be,0x025ac186}},	//   _非煤矿生产许可证_, _immitate, _miray_, _bellow_,
   {{0x930120b6,0x3c4b1124,0xefc3b01e,0xb2e3b0b6}},	//   _страната_, _eintrag_, _regioner_, _regione_,
   {{0x39e32175,0x5a26d005,0x3610610e,0x00000000}},	//   _minisita_, _شاہراہ_, _seiliedi, --,
   {{0x626c5186,0xc31061d2,0xf52ba137,0x461ae1b1}},	//   _kolor_, _verzie_, _munisipy, _brandywi,
   {{0xe17d900a,0xff6bc012,0xd5a3c1eb,0xdf818108}},	//   _בישול_, _историче, _prestatz, _हरुको_,
   {{0xb2249186,0x463a3012,0xbc6be135,0x4291f0cd}},	//   _atake_, _промышле, _खिस्सा_, _thuaj_,
   {{0x8b9e716f,0x92ca711e,0x8ae61131,0x00000000}},	//   _zaciatoc, _kindi_, _acetonae, --,
   {{0x6a04b22f,0x53ead117,0x43958166,0xe69da013}},	//   _megabait, _lietu_, _kersa_, _satellii,
   {{0x149de324,0x634c7134,0xd212b0bd,0x8200c060}},	//   _बर्मा_, _povedal_, _ruchu_, _oblici_,
   {{0xa5a3e202,0x6a10317c,0x11299080,0x52d9f237}},	//   _versandk, _consiliu, _норматив_, _estes_,
   {{0xa2fc60b2,0xae97201e,0x49f561d9,0x784d80c3}},	//   _mnoge_, _filtrere_, _orgán_, _들었습니다_,
   {{0x01f7c055,0x226c710e,0xe2b4012e,0x72fc712a}},	//   _معارف_, _annog_, _igice_, _longs_,
   {{0x22fc602f,0xa481300d,0xa966f135,0x32b4610e}},	//   _blogy_, _амэрыкан, _अइसनका_, _atoch_,
   {{0x63f8100e,0x8d37c055,0x95dfa0d4,0xd4851307}},	// [a00] _uchun_, _معاصر_, _במדבר_, _विनायक_,
   {{0xd394d061,0x49a9602a,0x8528402b,0xbead20f9}},	//   _broses_, _професій, _футбольн, _zaposlen,
   {{0x2c0eb21c,0x73a3a01e,0x56976202,0x8408721c}},	//   _skupine_, _suppe_, _eigentli, _taliansk,
   {{0xa9c53070,0x03ad4024,0xb2a740be,0x00000000}},	//   _kesempat, _مایکروسا, _siebot_, --,
   {{0x837b0206,0xb529e112,0xc23d50c3,0x4f83806c}},	//   _totalno_, _navigasy, _필요합니다_, _צװײטן_,
   {{0x85035022,0xc224e075,0xe25a8294,0x522591eb}},	//   _naprosto_, _linkuj_, _poklon_, _neska_,
   {{0x3ad61091,0x82d9f1d0,0x9f4eb0cc,0x2354a1d0}},	//   _pretplat, _ister_, _respecte_, _hareket_,
   {{0xe98b5019,0xff5cf045,0x13f4706b,0x07b651d5}},	//   _modhanna_, _компютер, _partar_, _diseleng,
   {{0x3d9a427d,0xb2caf0d4,0x9dc4e15c,0x00000000}},	//   _heeltema, _sunday_, _matkusta, --,
   {{0xc9e0a025,0xe3425038,0xeab6f0c3,0x45014031}},	//   _청소년보호정책_, _nivelin_, _올려주세요_, _billenty,
   {{0xec5220f7,0x526c70d8,0x02e5c15b,0x00000000}},	//   _स्टेज_, _honos_, _vulnera_, --,
   {{0xf7cc72e8,0x02b72182,0xec67202e,0xc2139002}},	//   _microsof, _другом_, _другое_, _musha_,
   {{0xde3d900a,0x02fcc0d6,0x92127012,0xc8d72040}},	//   _משפחת_, _blogga_, _vanha_, _cavernou,
   {{0xb37f810a,0xdd116025,0x00000000,0x00000000}},	//   _mahanga_, _아파트분양권_, --, --,
   {{0xf2543041,0xf387f114,0x00000000,0x00000000}},	//   _चैलेंज_, _scurt_, --, --,
   {{0x80744020,0xe3ddf010,0x036da185,0x6ba50325}},	//   _kalendār, _oluwa_, _potencij, _औचित्य_,
   {{0xfc85b00a,0x9710d0c3,0xb34ff062,0x93420119}},	// [a10] _שווים_, _고객센터의_, _উপলব্ধি_, _doremon_,
   {{0x0e725067,0x0d9901d0,0x43030019,0xf3ead03c}},	//   _लिस्ट_, _reklamla, _raidió_, _vietu_,
   {{0xfbc4e02e,0xf316910a,0x13f45005,0xb225903e}},	//   _очень_, _amazi_, _ketten_, _deska_,
   {{0xa2ca00f7,0x9d18c0dd,0xc61c80d4,0x03ff6145}},	//   _saidi_, _дискутир, _football_, _gjermani_,
   {{0x08b4c0c3,0xb87b9006,0xd9c382ee,0x437d423e}},	//   _사진갤러리_, _पन्द्रह_, _inmediat, _stranke_,
   {{0x6f1e101f,0x2c1d202d,0xb70600f5,0x27d80006}},	//   _kendisin, _tatarlar, _украінск, _अदाकारा_,
   {{0x4f6d4117,0x4a4ec00b,0x18b6307e,0x037d4020}},	//   _pasaules_, _директно_, _سرويس_, _pasaule_,
   {{0x74fa5013,0x627e00fd,0x2aa2a125,0x00000000}},	//   _программ, _olina_, _techcomb, --,
   {{0x8354c13f,0xf8350018,0xea8980e7,0xfe15a030}},	//   _paneles_, _इज्ज़त_, _matemáti, _premiers_,
   {{0x998e1037,0x9c07a00d,0x00000000,0x00000000}},	//   _начин_, _навошта_, --, --,
   {{0x727e0098,0xf0b07018,0xee32a062,0x9a35012a}},	//   _alina_, _तेलुगु_, _কাজটি_, _caractér,
   {{0xe3ebe04a,0x13da607e,0x6290c071,0x5213e18d}},	//   _mitte_, _فعالیت_, _valami_, _людмила_,
   {{0x57ac8140,0xeb91621f,0x522580a6,0x00000000}},	//   _difensiv, _duración_, _verki_, --,
   {{0xe5a26041,0x72da6122,0x2bd8006c,0x2f72c007}},	//   _बताते_, _direla_, _קעפלעך_, _доброго_,
   {{0xf3eb9146,0xd224e236,0x79212062,0x2cb4b024}},	//   _sista_, _linkek_, _চট্রগ্রা, _سپتامبر_,
   {{0x229fe04c,0x5355c057,0x5e8fe243,0x46932037}},	//   _projeto_, _generar_, _projetos_, _словакия_,
   {{0x281fa0c3,0xf79100c3,0x83226295,0x00000000}},	// [a20] _광화문연가_, _테마감상평_, _juryen_, --,
   {{0x227e604b,0x92d91059,0x23eb920a,0x99877036}},	//   _avons_, _reklamy_, _vista_, _厚生労働省_,
   {{0x2f633046,0x49ebd014,0x38756095,0x2394020b}},	//   _binaries_, _undersøg, _اضطراري_, _crise_,
   {{0x8fe0017d,0x02c5e181,0x4c75e293,0x4fb68034}},	//   _প্রমাণ_, _formát_, _formátu_, _олимпийс,
   {{0xa2370144,0xeae52326,0x2f20e00c,0xe26c7002}},	//   _krajem_, _अध्याय_, _attenden, _qonos_,
   {{0x435f2050,0x062a521d,0x8f49405f,0x00000000}},	//   _langage_, _saintifi, _brisanje_, --,
   {{0xd3eba126,0x9a1f1133,0xc2933081,0xec67a0f2}},	//   _cipta_, _热门关键字_, _neskôr_, _maaring_,
   {{0x2972a302,0x3aa27017,0x5ae0d0c9,0x750a6045}},	//   _ispitajt, _priklaus, _satelits, _програмн,
   {{0x9291901c,0xc2fce003,0xe8d2f002,0x00000000}},	//   _bayani_, _hinges_, _antumirv, --,
   {{0x22d9b0bf,0x7378b191,0x73f9e111,0xfc2040e7}},	//   _saveza_, _jajahan_, _katut_, _capítulo_,
   {{0xc20420d3,0x119721c1,0x2efd70af,0x7200b16f}},	//   _serikali_, _koncerty_, _धडाका_, _akciu_,
   {{0x09f5910a,0x6ed5d315,0x37b5c049,0x5ee27067}},	//   _kaminuza_, _papildin, _адеся_, _रिक्शावा,
   {{0x23ea222a,0x3c21201e,0x32cf10be,0x82f710e6}},	//   _fakti_, _ragnhild_, _denonse_, _ंत्री_,
   {{0xf2b40131,0x610d509b,0x12ca00a3,0x00000000}},	//   _trice_, _silverto, _naidu_, --,
   {{0x8e72f070,0xd386d0b9,0x7323706c,0x00000000}},	//   _शुक्र_, _smere_, _הייעוועי_, --,
   {{0xc75de10a,0xa2ca9166,0xaa1fa01b,0xeaeeb172}},	//   _bizimung, _uzado_, _основные_, _hastighe,
   {{0x627e7005,0xef51b0fc,0x9dfa8036,0xe46f4055}},	// [a30] _lenne_, _टाइगर_, _このレビュ_, _استعمار_,
   {{0xaf346040,0x9342f03e,0x12c421c4,0x07a5820b}},	//   _adironda, _kulturní_, _sendandi_, _culturai,
   {{0xfc5371fd,0x535e81fd,0x6639e306,0xbd01f268}},	//   _dostava_, _pregled_, _audienci, _philippe_,
   {{0x6379a28c,0xd25a5051,0xe386d0de,0xa2026054}},	//   _layanan_, _tills_, _flores_, _opties_,
   {{0xd2919048,0xe200c0e0,0x168fc17d,0x325a9173}},	//   _aysan_, _velice_, _অনুগ্রহ_, _chala_,
   {{0x52fd7159,0xfc6240e7,0x9c62702d,0xa8892139}},	//   _imagen_, _aparece_, _tutulan_, _perkampu,
   {{0xc27e904b,0x622551c4,0x8d9bd1cb,0x8e3cc0a7}},	//   _avant_, _frekar_, _autorida, _ачеста_,
   {{0xe27e723a,0xfef2d0cf,0x9611f18f,0xcde58036}},	//   _denne_, _छिलका_, _kwalitei, _指定しない_,
   {{0x7c67c031,0x32fe6008,0xf394e22f,0xcb03e124}},	//   _دربار_, _visiems_, _episod_, _versende,
   {{0x72d99133,0x65b15036,0x23a24024,0x795fe196}},	//   _assez_, _に関する質問_, _nampa_, _atendere,
   {{0x7daf6112,0x23ea21c4,0xbfcc5071,0x00000000}},	//   _ansiklop, _vakti_, _klíma_, --,
   {{0x02926111,0xe2e200f8,0xf10a00d4,0x00000000}},	//   _karasa_, _paligid_, _הכתיבה_, --,
   {{0x200a804b,0x62fe7035,0x9394d01e,0xb4875070}},	//   _回复此发言_, _target_, _ganske_, _निवारण_,
   {{0xaa73d1c1,0x285200e7,0x21f3d1c3,0xfc00c0db}},	//   _lokalita_, _segundos_, _lokality_, _hösten_,
   {{0xce383213,0xd3f3c063,0x00000000,0x00000000}},	//   _pengajia, _اطباق_, --, --,
   {{0xd394d11b,0x3ae0117d,0xc985a059,0x6af091c1}},	//   _kanske_, _ডিজাইন_, _polityka_, _minulost,
   {{0x03ea00e2,0xf032f1c1,0xd27e00f2,0x5f239114}},	// [a40] _yaitu_, _postaven, _aling_, _telefoan,
   {{0x13dd822e,0x6394d19c,0x4290c005,0x2d15d242}},	//   _borwa_, _danske_, _valaki_, _estrutur,
   {{0x7f01d036,0x63210242,0xf25b424d,0x00000000}},	//   _スピリチュアル_, _década_, _čelsi_, --,
   {{0x8e1c912e,0xaeba60e7,0x00000000,0x00000000}},	//   _interaha, _petróleo_, --, --,
   {{0x17e43174,0x225a0274,0x954b7031,0x0ade9150}},	//   _अवसरमा_, _asili_, _könnyű_, _rakendus,
   {{0x16359327,0x8ccc2005,0xe2d8e0f7,0xb27e0031}},	//   _económic, _جیتنے_, _panema_, _amint_,
   {{0x527e914c,0xf2ca718f,0xfc7ea086,0x1290c0d7}},	//   _mwana_, _vindt_, _mensual_, _salaki_,
   {{0x22d8d130,0x3ffc60bd,0xd3eae158,0xa3ded0b5}},	//   _speel_, _अधिकारों_, _konton_, _ардей_,
   {{0x2e72513b,0x847b91ac,0x7a28c17d,0x3d6fd07e}},	//   _लिफ्ट_, _gustuhin_, _funcione, _احزاب_,
   {{0x93427099,0x225a40fa,0xba9e10d0,0x42da700a}},	//   _lateran_, _gamli_, _lightsab, _itself_,
   {{0x43a230e2,0xb9c0d328,0xa2cae00a,0x903ef12d}},	//   _tempat_, _राँची_, _london_, _eastóini,
   {{0x1ef1205f,0x6a64817d,0x0f612083,0x3d112204}},	//   _остали_, _কোনদিন_, _остале_, _остало_,
   {{0xa27e91f2,0x43ff1329,0xdc1e7034,0x27e610d4}},	//   _bwana_, _francusk, _развитие_, _הסיסמה_,
   {{0x78657034,0x72979181,0xc349e07b,0xe2cb8064}},	//   _академия, _originál, _parempi_, _birde_,
   {{0x9049909a,0x59d22218,0x26835092,0x126cc055}},	//   _אַלײן_, _zaregist, _रहमान_, _endog_,
   {{0x43f8c0a9,0xad2f0036,0xf355b072,0xf2498051}},	//   _xaluan_, _回答順に表示_, _moterys_, _varmt_,
   {{0x7205b169,0xbe1a7091,0x4e7c02e2,0xd8fc11f4}},	// [a50] _politiki_, _materija, _सहर्ष_, _treabhad,
   {{0xae181030,0x48b9a034,0xf2e90059,0x5c51f010}},	//   _凡本站及其子站注, _последни_, _posiada_, _alituma_,
   {{0xb68e106c,0x680900e0,0x7386d194,0x00000000}},	//   _פופציג_, _आम्दानी_, _amera_, --,
   {{0x23f98047,0x134a22d8,0x85ce6005,0x326471a6}},	//   _harus_, _klientu_, _لیفٹیننٹ_, _parler_,
   {{0x0530e06c,0x22a64074,0x00000000,0x00000000}},	//   _ערציאונג_, _pemba_, --, --,
   {{0x825ad153,0x63914063,0xb0475125,0x1f8610d4}},	//   _mieli_, _للغاية_, _forumbon, _לשדרוג_,
   {{0x995f100a,0xa909c00d,0x9e5211ec,0x920c10d4}},	//   _resource, _ніжэй_, _dinamaka, _להבטיח_,
   {{0x73eb9078,0x627b712d,0x21dac06c,0xed272148}},	//   _posty_, _ginearál, _לופטפעלד_, _مداخله_,
   {{0x12d9e177,0xc2ccc0b1,0x6379124d,0x3e47906c}},	//   _batek_, _publiko_, _zapadna_, _טעיפס_,
   {{0xc2d8d0d1,0xde18006c,0xfb7a232a,0x388410c3}},	//   _covneeg_, _געװוּסט_, _presenza_, _회원님들께서는_,
   {{0x03eb9100,0xf3f9e025,0xa212902c,0x1316d169}},	//   _aiste_, _플래닛으로_, _usaha_, _amezi_,
   {{0x23eb9091,0xd12d207b,0xdb1fc02c,0x33525133}},	//   _biste_, _часто_, _kalangan_, _知识堂首页_,
   {{0x620271bc,0xc96681b6,0xcb83d0f3,0xcd9f70fc}},	//   _musika_, _zaroblje, _europako_, _demokraa,
   {{0x0e36c1b9,0x00000000,0x00000000,0x00000000}},	//   _spracova, --, --, --,
   {{0x6945a04b,0x365e115f,0x2c6e6091,0x501ec0c3}},	//   _utilisat, _писма_, _nagrada_, _플레이리스트_,
   {{0x6b8652ed,0x0f31f191,0xac6a2067,0x62872063}},	//   _istočnoj_, _seterusn, _कुर्ता_, _مفتاح_,
   {{0xbffa21e6,0xd695a00b,0x126d432b,0x1d03f036}},	// [a60] _त्रासदी_, _младост_, _definisi_, _リスト作成者_,
   {{0x5c46c063,0xfc67c130,0x65b222b0,0x24fa90fc}},	//   _وربما_, _kantoor_, _bornholm_, _ग्लानि_,
   {{0x53f99070,0xb2ca718f,0xbeaf902c,0x125a50a6}},	//   _kasus_, _sinds_, _gelomban, _falli_,
   {{0xa1f8c019,0xd0ec20f6,0xb715a0d4,0x4201a2e0}},	//   _وقالت_, _digitaal, _אומנם_, _iskorišt,
   {{0x4d883006,0xd1936062,0x8848c00d,0x3e3400d4}},	//   _zalogowa, _কর্পোরেশ, _патлумач, _שאמרתי_,
   {{0x1b0930b1,0x723651c4,0xd719e32c,0xfc7c81b4}},	//   _kompyute, _selja_, _komuniká, _existen_,
   {{0xbce040b6,0x7c67f062,0x980a0041,0x00000000}},	//   _телефони_, _বেসরকারি_, _डिज़ाइन_, --,
   {{0x73154045,0xc37b00a4,0xfb654036,0x00000000}},	//   _включенн, _ostavio_, _espersen_, --,
   {{0xd2eb10bc,0xa2365116,0xffc792ed,0x9395815d}},	//   _soriano_, _velja_, _kosovsko, _fersk_,
   {{0x204fd04c,0x226ce11b,0x02e00170,0x9f589185}},	//   _односно_, _annons_, _stunden_, _najproda,
   {{0x62d8d03e,0x5c29608b,0xd755d067,0x8236523f}},	//   _bolest_, _kombetar, _positiiv, _telja_,
   {{0x2724100a,0xb29091e7,0x82da7164,0x92d9900a}},	//   _סטודנט_, _nejake_, _spreek_, _cases_,
   {{0x136ce072,0x29c911d4,0xf9dce1b9,0xce173035}},	//   _licencij, _हाईकोर्ट_, _licencie, _जगभरच्या_,
   {{0x73ea01a4,0x627c71e3,0x27798204,0x09c61051}},	//   _maith_, _verskill, _саобраћа, _leverant,
   {{0xc2b1d034,0xaa812006,0x4369c045,0xadc4b03a}},	//   _vendita_, _natomias, _manglar_, _oblikuje_,
   {{0xe3cef031,0xa23b7031,0x13f9a0c1,0x00000000}},	//   _privit_, _komment_, _hapus_, --,
   {{0xb40d103b,0x75eaf005,0x12b6b0bf,0xf2ca50fa}},	// [a70] _最近のトラックバ, _اٹارنی_, _studije_, _valdi_,
   {{0xd312104b,0x13526108,0x6a971005,0xcd4aa0c0}},	//   _membres_, _पहेली_, _چوتھے_, _kinabalu_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x92b5810e,0x9ecb80b8,0x13e780d8,0x629190be}},	//   _merch_, _thoitran, _látom_, _aksan_,
   {{0xec616010,0x798bf182,0x53a3c0ce,0x00000000}},	//   _kutunga_, _страну_, _nuvpu_, --,
   {{0x72a7c072,0xdd84a03b,0xb2d9831e,0x7bd9c029}},	//   _такога_, _oprettet_, _varer_, _книжка_,
   {{0x9b8652ed,0x425ae054,0x13948154,0x2a328072}},	//   _istočnom_, _veilig_, _maksab_, _добрыя_,
   {{0xf15630bd,0xd7b6306f,0xb378417f,0x92920112}},	//   _aktualno, _aktualni, _medalja_, _repare_,
   {{0xb43f2025,0x62b52054,0xa2920223,0x9eb6c037}},	//   _부산광역시_, _succes_, _separe_, _профила_,
   {{0x3be74106,0x620ec027,0x13ebe146,0x6074a101}},	//   _direttor, _талас_, _titta_, _англичан,
   {{0xe49b2006,0x06139086,0x72927055,0x00000000}},	//   _ogranicz, _afiliaci, _pusaka_, --,
   {{0x1061c024,0x815d105f,0xf26c523c,0xa25a6071}},	//   _کنسرت_, _априла_, _bilog_, _zsolt_,
   {{0xd20180d4,0x1321f00d,0xefc8e2fc,0x00000000}},	//   _chris_, _індывіду, _varianto, --,
   {{0x9c99c00d,0x52fce002,0x2c46c039,0x00000000}},	//   _interviu_, _nungwi_, _کرسمس_, --,
   {{0x0d62c260,0x28dda23a,0x97b5d062,0x83eb508b}},	//   _ردعمل_, _naturlig, _আলাইহি_, _vjeter_,
   {{0x45287087,0xab0f4033,0x951620d4,0x00000000}},	//   _aplikasy, _resposta_, _ביאליק_, --,
   {{0xa3860033,0xcd8a0045,0x32f450cd,0x5212b07d}},	// [a80] _feira_, _allerede_, _pranuar_, _tache_,
   {{0xa386b049,0x626c900b,0xd3eb801d,0xd27f7138}},	//   _pierde_, _škole_, _birta_, _asante_,
   {{0x427f0019,0xd2fd80f1,0xf27ec1cc,0xa37a7238}},	//   _leanas_, _norge_, _jedne_, _estaban_,
   {{0xc7a270c0,0x927e612b,0x8200b06f,0xb2b47241}},	//   _pentadbi, _olona_, _medije_, _punca_,
   {{0xa2b5812a,0xe3f820b6,0xa941f038,0xc884e128}},	//   _merci_, _comune_, _realitet, _inuktitu,
   {{0xc27e01e3,0xff5c0098,0x0144b22e,0xa201901e}},	//   _klink_, _endagaan, _sealladh_, _eksil_,
   {{0xb46ed1e4,0x26aeb030,0xd27e0063,0x72cb801f}},	//   _време_, _民族自治地方的自, _aoine_, _girdi_,
   {{0xa3f9a061,0x00000000,0x00000000,0x00000000}},	//   _bapur_, --, --, --,
   {{0x29e06067,0x0cf792a8,0xdafc0031,0xe26c900b}},	//   _उल्टे_, _बिलकुल_, _élelmisz, _školu_,
   {{0xd2e5b24f,0x5386914b,0x93eb902a,0xf26d8129}},	//   _vojnika_, _imari_, _mista_, _forom_,
   {{0xfe1f8036,0x3212b112,0xa2c1621c,0x675a9045}},	//   _してください_, _rache_, _kombinác, _скачати_,
   {{0xb2fd623b,0xd2ca7070,0x82130250,0x90c03063}},	//   _liggur_, _candi_, _shahri_, _يشاهدوا_,
   {{0xecc9b16c,0x1c2790bd,0x8698f036,0x00000000}},	//   _hauvcaug_, _प्रगतिशी, _メルちゃん_, --,
   {{0x22b550a3,0x63955020,0x426d8005,0x00000000}},	//   _preces_, _preses_, _korom_, --,
   {{0x37f610d4,0x2ba82072,0x32020073,0x303f7121}},	//   _מיידית_, _начальні, _masini_, _annulmen,
   {{0x68e7f00b,0x091ae125,0x13871145,0x00000000}},	//   _затвора_, _nhìn_, _librit_, --,
   {{0xd2ce307b,0x9f4371c7,0x63eb9109,0xc255f135}},	// [a90] _нормальн, _प्रकृतिस, _jista_, _होखेला_,
   {{0xb0476017,0x0cf2d005,0x4167c06c,0x3741a035}},	//   _musulmon, _ٹائمز_, _סטעיטמענ, _वाहिन्या,
   {{0x031600e9,0x00000000,0x00000000,0x00000000}},	//   _reizi_, --, --, --,
   {{0x7e14a161,0xb467d087,0xbc02010b,0xe21290ce}},	//   _telekana, _handbook, _realidad_, _yejhad_,
   {{0x977270e6,0x02ca723b,0x00000000,0x00000000}},	//   _सामान्या, _vandi_, --, --,
   {{0x1eb6c187,0xdc7540d5,0xc3ac023a,0xad1b3005}},	//   _профил_, _तृप्ति_, _toppen_, _گروہوں_,
   {{0x596b903b,0x23ea7037,0x80a4006c,0xa7cd2019}},	//   _関連法人等_, _tanti_, _לאַגערן_, _leasainm_,
   {{0x149bb0c6,0xe3dcd114,0x00000000,0x00000000}},	//   _diharapk, _ачестор_, --, --,
   {{0xf394e054,0x00000000,0x00000000,0x00000000}},	//   _mensen_, --, --, --,
   {{0xf9a591c8,0x55642107,0x00000000,0x00000000}},	//   _बेल्जियम_, _previsok, --, --,
   {{0x325ad03b,0x53ead025,0x0200c008,0x27c490f1}},	//   _niels_, _niets_, _dydis_, _brødrene_,
   {{0x5eac20f1,0x2f9200f2,0x72a63037,0x33869073}},	//   _eksterne_, _headgear_, _sembra_, _seara_,
   {{0x82e3e32d,0xf5a83177,0x8559c042,0x00000000}},	//   _सुधीर_, _klaserak, _знаком_, --,
   {{0x3af7d073,0x86aa8025,0xa9c51186,0xd3f4529c}},	//   _ражения_, _최근검색매물_, _vallarta_, _wetten_,
   {{0x8a1631e8,0x9e563144,0xb29631e8,0x1f239100}},	//   _bugarska_, _bugarske_, _bugarski_, _achterca,
   {{0x857c507d,0xe9ec80c3,0x8343e277,0x00000000}},	//   _izrayèl_, _blogpost, _सुदूर_, --,
   {{0x340c209a,0xa26cf070,0x5bd9c045,0x1239e109}},	// [aa0] _מלחמות_, _bogor_, _реклами_, _formati_,
   {{0x42130015,0x9ce3b133,0x5e6fd2a5,0x5ab7e1a0}},	//   _ahahah_, _国家海洋局_, _turklāt_, _euphemis,
   {{0xf2d9c0ba,0xe25a9127,0x525ad117,0xd3cf7088}},	//   _haver_, _mbale_, _skolas_, _pravde_,
   {{0x9b348030,0xe5f7b07e,0x72feb24b,0xa3ea9048}},	//   _评价已经被关闭_, _ارمنستان_, _butiker_, _saati_,
   {{0x0586a229,0x29333133,0xe9f6d07e,0xc2d9c00b}},	//   _супериор, _如其他媒体_, _توهین_, _savet_,
   {{0xdcee2101,0xf962c0c3,0xeeba5158,0x4714b15f}},	//   _сряда_, _같은지역출신_, _prisjakt_, _manutenç,
   {{0x829270a0,0x1366b064,0xfe98d133,0xfbe4304c}},	//   _obrach_, _ilköğret, _中华人民共和国城, _engenhar,
   {{0x9679f008,0x3c610112,0x4729916b,0xaa6ba13b}},	//   _правасла, _otorite_, _снежня_, _उन्नति_,
   {{0x83f450f1,0x19f87022,0xcbed5080,0x52d98026}},	//   _retten_, _recenzí_, _хореогра, _obres_,
   {{0xd045e0e2,0x2451403e,0x220260b0,0xb42e90f5}},	//   _kelompok_, _skutečně_, _verite_, _смерці_,
   {{0x3a7c900d,0xa2d891a9,0x12d8d0f0,0xb5168116}},	//   _казуліна_, _objeto_, _tineeg_, _frizersk,
   {{0xf7a5f157,0x73f9e167,0xba07e09c,0x00000000}},	//   _objektov, _latus_, _spegepøl, --,
   {{0x07584174,0x3c00d019,0x027e62b2,0xb25a0043}},	//   _सशस्त्र_, _تختلف_, _along_, _spila_,
   {{0x227e6095,0xbdc7d00b,0x95f9713b,0xe708106c}},	//   _blong_, _превод_, _भौगोलिक_, _דעטאלן_,
   {{0xbd05a019,0x3e3a10f8,0x00000000,0x00000000}},	//   _suntasac, _karanasa, --, --,
   {{0xa6d60055,0x93ced239,0xc2d4605e,0xa3ce9274}},	//   _عالمان_, _nejaký_, _zeuden_, _flava_,
   {{0xd36aa00d,0xd2cb720c,0x109b4036,0x3d9b2099}},	// [ab0] _канкрэтн, _hladno_, _オリジナル_, _phonsava,
   {{0x33ebe1ed,0x691a0034,0x349190cb,0x1c7f20dd}},	//   _bitte_, _последно_, _मम्मी_, _passado_,
   {{0xbda621e8,0x5b662144,0x6ea621e8,0x83e621e8}},	//   _upotrebu_, _upotreba_, _upotrebe_, _upotrebi_,
   {{0x42927116,0xf2b9015f,0x97baf185,0x1175e0bc}},	//   _zaradi_, _простори, _nekretni, _mainstay_,
   {{0x693d312d,0xaa05d070,0x83ebe0c3,0x4863c0dd}},	//   _الآخر_, _वार्ताहर_, _witte_, _докази_,
   {{0xbddc3063,0x00000000,0x00000000,0x00000000}},	//   _الذوق_, --, --, --,
   {{0xc3ea70fd,0x4295c099,0x5264607d,0x12f452a5}},	//   _bantu_, _majkauv_, _berlen_, _stundas_,
   {{0xc0b661f8,0xe2fc709b,0x9c7f0025,0x8356c063}},	//   _शुरुआत_, _dinge_, _meestal_, _أرسلت_,
   {{0x72d4627c,0x32b00062,0x134920a4,0xf3eae00a}},	//   _verden_, _হমপগ্র_, _dovesti_, _gifts_,
   {{0x5163e0eb,0x018b3030,0x88f3e023,0xfc74b0cd}},	//   _programl, _日时政要闻_, _programu, _forumit_,
   {{0xf3f9e0e9,0xa2ca70d0,0x00000000,0x00000000}},	//   _datus_, _tandu_, --, --,
   {{0xc201a114,0x8c52b20d,0x323a9185,0x3dae30a8}},	//   _devine_, _एकमेव_, _vremenu_, _cystadlu_,
   {{0x8879e0bb,0x6200c00b,0xd11a10a7,0x00000000}},	//   _ахметов_, _velike_, _ворбе_, --,
   {{0x12021186,0x327f4098,0xf2921088,0x00000000}},	//   _napili_, _esente_, _napali_, --,
   {{0xf2a64010,0x62f45070,0x5c3450f4,0x23f9e043}},	//   _memba_, _standar_, _standard_, _hatur_,
   {{0x327e3205,0x2d32713b,0xf3a3415a,0x22d9809c}},	//   _vojne_, _pronájem_, _nadpis_, _flyene_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ac0] --, --, --, --,
   {{0x73940061,0x73f9e055,0x42e6021c,0x675ca0e6}},	//   _prism_, _matur_, _stanica_, _siliwang,
   {{0xb3a23141,0x2400f044,0x22d9e00a,0x43408023}},	//   _sampai_, _nguội_, _later_, _prieten_,
   {{0x026cc0be,0x734392b4,0x59ebb20c,0x6d2bb2ce}},	//   _vodou_, _zelenom_, _frendica_, _frendice_,
   {{0x237a1055,0x73f47170,0xc60320d5,0xb651523f}},	//   _masalan_, _besten_, _आबिदा_, _skrifað_,
   {{0x263fe0e0,0x436350d2,0xb8d72012,0x00000000}},	//   _kalendář_, _alngegh_, _питание_, --,
   {{0xbaea718f,0x02920179,0xd7aa718f,0xe0e76036}},	//   _bestelle, _sprawy_, _bestelli, _この回答にお礼を,
   {{0xd201f038,0x00000000,0x00000000,0x00000000}},	//   _vizito_, --, --, --,
   {{0xed9891b9,0x99a0f07c,0x92025184,0xa03e0036}},	//   _recenzie_, _nebojša_, _intinn_, _ブロとも申請フォ_,
   {{0x1b8f51d2,0x02d8b073,0xdcda9049,0x2d23017c}},	//   _striebor, _acces_, _prevenir, _calitate_,
   {{0xb37f3115,0xd3f97030,0xb27ed10a,0xf8080154}},	//   _kamanda_, _claude_, _mwene_, _गद्दारी_,
   {{0xb3003072,0xe200d091,0xd213f173,0xcccd90d4}},	//   _kadangi_, _veliku_, _ortha_, _הבסיס_,
   {{0xf3eae313,0x9c1e203d,0xcc5d218c,0x00000000}},	//   _dantri_, _compras_, _परदेस_, --,
   {{0xa035a144,0x61c92060,0x746950f6,0x0e821133}},	//   _emitovan, _кости_, _христиан, _图等稿件均为转载,
   {{0x7262d055,0xd236d1ef,0x4eab8006,0x825a914e}},	//   _سابقه_, _svojih_, _zostanie_, _haalt_,
   {{0xc3f9e0c2,0x626cb14c,0x57929219,0x0f9d90d4}},	//   _batur_, _sodoma_, _manteisi, _פסנתר_,
   {{0x927e9151,0x45195062,0xc82060c3,0x617ed063}},	// [ad0] _alang_, _সংরক্ষণ_, _고맙습니다_, _أماكن_,
   {{0x3b725274,0x86532300,0x89f3b057,0x5b636115}},	//   _biashara_, _धडाधड_, _dirigida_, _ufaransa_,
   {{0xd2c510d8,0x02fe600b,0x829031c0,0xf3b170e7}},	//   _kellene_, _drugim_, _halang_, _ataque_,
   {{0x93cf70db,0xe236d20c,0xeb311005,0xc231419d}},	//   _gravid_, _tvojih_, _منیجر_, _aghvetlh_,
   {{0x726de067,0xe3d9200d,0x4a932041,0x12e68025}},	//   _fotod_, _панядзел, _इजाफा_, _drinken_,
   {{0x12ca51c4,0xbc01b010,0x4290201a,0x93eaf07b}},	//   _haldi_, _tafsiir_, _tamang_, _paitsi_,
   {{0x52da513f,0xba9d216c,0x10538235,0xc875a237}},	//   _europos_, _polycarp_, _potravin, _curiosid,
   {{0x9292606f,0x64a5f13b,0x9a9ba23b,0xbc5b81fd}},	//   _moralo_, _दिशानिर्, _peningas, _postani_,
   {{0x92003137,0xaf8370cb,0x825a51f9,0x439480b1}},	//   _galing_, _हकीकत_, _malli_, _teksto_,
   {{0xe365f23c,0x1475809f,0x196d728c,0x43d09024}},	//   _abogado_, _brethren_, _okcident, _علیرضا_,
   {{0x8e0e50a0,0x128be2db,0x23a2907d,0x9cfe3030}},	//   _bhòrd_, _अनहोनी_, _chapo_, _contrair,
   {{0xf2fce0a9,0xe7eba1d9,0x227e00d4,0x6bf710b6}},	//   _bongda_, _kombinov, _doing_, _пишете_,
   {{0x53ebe203,0xcbee1073,0x53874067,0x038060a6}},	//   _hitta_, _парох_, _andrus_, _metrar_,
   {{0x72d9802d,0xb103a0d4,0x0c6990c3,0x937a5069}},	//   _aprel_, _לטיול_, _게시판으로_, _volledig_,
   {{0x0246616c,0x72d8116c,0xf394d129,0x12e681ed}},	//   _nîmes_, _nqhes_, _stess_, _trinken_,
   {{0xa3f9e038,0x5fbf2295,0x135f2295,0x1250b041}},	//   _patur_, _fungerer_, _fungere_, _मनरेगा_,
   {{0x7e4bb0a9,0x725be0a6,0x735641f3,0x3202607c}},	// [ae0] _vinagame_, _litla_, _moteris_, _ciriha_,
   {{0xa37f300e,0xb26d50bd,0xd859706b,0xdc7590e0}},	//   _zamanda_, _pogoda_, _straumar_, _हाम्रा_,
   {{0x42bca0b5,0xe291f004,0x89053047,0x026d832e}},	//   _mondial_, _thuat_, _membentu, _foron_,
   {{0x220032a0,0xf355d04b,0x126d8061,0x3386e063}},	//   _paling_, _acheter_, _goron_, _gairid_,
   {{0x2202606b,0xdeab9284,0x22925127,0x00000000}},	//   _skriva_, _opkoljen, _matani_, --,
   {{0xe3ebe010,0x327ee130,0x88dad1f3,0xc3c3201b}},	//   _bitta_, _kennis_, _skirting, _kävin_,
   {{0x727e911b,0x2d84f2ce,0xe27601f0,0xfc5a7140}},	//   _bland_, _dovedite_, _starostl, _mentali_,
   {{0x9aeda2fd,0x03ebe26a,0x49eda1a3,0x4f29d128}},	//   _actualit, _ditta_, _actualid, _multnoma,
   {{0x92b470e7,0x1225f045,0xa49d7062,0x00000000}},	//   _nunca_, _становле, _জিল্লুর_, --,
   {{0xe94e1054,0x826d910e,0x7c17a0d4,0xc2fd40ed}},	//   _sollicit, _noson_, _הגליל_, _alegia_,
   {{0x32fc91ca,0x3b8181de,0x0b8bc059,0xc15b3228}},	//   _anaga_, _क्रमश_, _kwiecień_, _sionnach_,
   {{0x5d4bb138,0x8a11816a,0x4f8dd11d,0x22a6422f}},	//   _binadamu_, _departme, _बड्का_, _lembu_,
   {{0xe9091108,0x7b2d9073,0x00000000,0x00000000}},	//   _इंग्लैंड_, _филипине_, --, --,
   {{0xa2247260,0x82b47114,0x72b40058,0x4c75f0cb}},	//   _munka_, _munca_, _prica_, _रिक्शा_,
   {{0x72c37088,0x9c53720c,0x00000000,0x00000000}},	//   _poslova_, _postova_, --, --,
   {{0x322b01cd,0x3213f031,0x6f0b0096,0x727a8137}},	//   _kommune_, _kuthi_, _kommuner_, _kilikili_,
   {{0x8754425f,0xb3ce91d3,0xe5ba4062,0x6e510185}},	// [af0] _político_, _clave_, _মাঝখানে_, _ponavlja,
   {{0x6cfd309a,0xd291f14a,0x13cfe08f,0x6394f16e}},	//   _פּובליצי, _thuas_, _termasuk, _kaisar_,
   {{0xe9ddc045,0xf04c22df,0x7ef18275,0x64876262}},	//   _оплата_, _crouchin, _बाँकी_, _निराली_,
   {{0x43169175,0x3eab10ba,0x93f400ad,0xd2da5177}},	//   _kwazo_, _galeries_, _hastas_, _esteka_,
   {{0x15b01206,0x027f01dd,0xab0ce07e,0xc03e413f}},	//   _granatom_, _tuanku_, _شاهین_, _viktorin,
   {{0x34aca18d,0x62da617a,0x9378e228,0x00000000}},	//   _artikkel_, _roboter_, _salainn_, --,
   {{0xed1e41f9,0xd26471c1,0xc97ae170,0x39942036}},	//   _поздравл, _myslim_, _verhalte, _公式サイト_,
   {{0xcc5370f9,0xf6397193,0xbff681b3,0x43f471c6}},	//   _kartica_, _aplicaci, _dvojnaso, _cartas_,
   {{0x8b26c187,0xa2014053,0x164df036,0x1059d073}},	//   _однос_, _medier_, _この商品について, _капитале,
   {{0x22ca7177,0xb2e68051,0x9201a1b9,0x00000000}},	//   _handi_, _kvinnan_, _levice_, --,
   {{0x52ca7169,0x93ea7055,0x9291e09f,0x7c1860da}},	//   _kandi_, _kanti_, _oktar_, _toppers_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb3ea70b0,0x4f77c1f0,0x13ea90fd,0xffda10ce}},	//   _manti_, _priceman, _esatu_, _assinabo,
   {{0x2201809d,0x62ca701d,0x2369c168,0xc386d098}},	//   _skriv_, _landi_, _романија_, _leero_,
   {{0x294e11cc,0x2224d22a,0x5578529b,0xad8082a1}},	//   _prolazit, _greke_, _poslední, _deklarua,
   {{0xc81c6165,0xf8d9207e,0xf2cac0a7,0x9f40701b}},	//   _yanlış_, _تمرکز_, _acelasi_, _amerikka,
   {{0xbf2ca315,0x42b2724f,0x1c0ca1b6,0x871cf15f}},	// [b00] _austrija, _gradova_, _austrijs, _констати,
   {{0x20513073,0x7b21112d,0x2de52125,0xed996135}},	//   _историк_, _البطولة_, _hoặc_, _लोमडिया_,
   {{0x17aa701e,0x5292518b,0xcb874106,0x99f2c183}},	//   _bestilli, _patani_, _camiller, _mhargaid,
   {{0xb525502b,0xa2d5000c,0x00000000,0x00000000}},	//   _зверненн, _apposta_, --, --,
   {{0xca1571fd,0x63f47197,0xf29570f9,0x07e1f18d}},	//   _lokacija_, _tautas_, _lokaciji_, _тенденці,
   {{0xb291e23d,0x6c379025,0x127e712a,0x2993524a}},	//   _aktar_, _연구회참여_, _bonne_, _tilknytt,
   {{0x3c10b0e7,0x826c5002,0x777f7267,0x6b6f3033}},	//   _rápido_, _tilon_, _क्रान्ति, _natureza_,
   {{0x82fc70ff,0xa394c108,0x72fce32f,0x3e38e02a}},	//   _ringa_, _polski_, _lingua_, _тимчасов,
   {{0x656260d8,0xed6f9049,0xffbec038,0x00000000}},	//   _عموماً_, _адмисэ_, _koalicio, --,
   {{0x4dfa3067,0xa26de226,0x626e613b,0xabb7c284}},	//   _सम्मेलन_, _potom_, _metody_, _mitrović_,
   {{0xe13e006d,0x4200c132,0x502801b9,0x4c7d7298}},	//   _bildiril, _kilimo_, _konverzn, _versiya_,
   {{0x6e8d006c,0x2c31a200,0x00000000,0x00000000}},	//   _עפֿנטלעכ, _аспирь_, --, --,
   {{0x88731030,0x12926170,0xe2ca911a,0x23ea9098}},	//   _您想在自己的网站, _gerade_, _kaadi_, _kaati_,
   {{0xf291421c,0xb122206f,0x0f1da0c3,0x9b7870a4}},	//   _nedaju_, _prijavil, _무엇보다도_, _potrebna_,
   {{0x2063906c,0x0af3c1fd,0xb3a3f091,0x651f302a}},	//   _מארגן_, _popravit, _grupu_, _співпрац,
   {{0x526d828d,0xc348406f,0x32e00014,0xe8fd7125}},	//   _foros_, _temelji_, _grunden_, _phêrô_,
   {{0xb248d005,0x00000000,0x00000000,0x00000000}},	// [b10] _filmet_, --, --, --,
   {{0x56e8b072,0x827f7189,0x1c62712b,0x83eae0d0}},	//   _характар, _adanya_, _seguito_, _britto_,
   {{0x8386c2b0,0xa512f049,0x660bc00d,0x1ba59005}},	//   _bedre_, _универсу, _учора_, _انبیاء_,
   {{0xda632150,0x1319615f,0x82b8106c,0xe7e3d1f6}},	//   _फेस्टिवल_, _просторо, _רעכענען_, _универза,
   {{0x1006c06c,0x1c536223,0xd883918d,0x227e70c5}},	//   _עסטרײַך_, _tretman_, _конверт_, _sonne_,
   {{0xa212910a,0x827e9130,0xc2b490a9,0x00000000}},	//   _cyaha_, _klank_, _quach_, --,
   {{0x7c37d211,0x007010e8,0x6b66c029,0x2dffe0cd}},	//   _istifadə, _ценности_, _грешки_, _arrestua,
   {{0x23e00236,0x720a80bd,0x6245d043,0xf05a5330}},	//   _péter_, _प्रजाति_, _dæmis_, _navibank_,
   {{0x43f8e05e,0xe8a7c005,0x52925196,0x526c60d1}},	//   _minutu_, _ہوچکے_, _batali_, _hnoos_,
   {{0x326cf0d8,0x24339062,0x00000000,0x00000000}},	//   _angol_, _ডিলিট_, --, --,
   {{0xad292006,0xff20d014,0x00000000,0x00000000}},	//   _komputer, _vesterga, --, --,
   {{0x52d9e1cb,0x00000000,0x00000000,0x00000000}},	//   _obter_, --, --, --,
   {{0x7e01c076,0xa115d1c8,0xc2feb295,0xcbcd3005}},	//   _rejestra, _अनुप्रयो, _aktiver_, _اتھارٹی_,
   {{0xa2a6c1e1,0xeaca1063,0x53940061,0xd37a0112}},	//   _sumber_, _ومنتديات_, _grist_, _farawon_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xfc18e01e,0x020270be,0x09d5a0d4,0x8f1d31a1}},	//   _detaljer, _deside_, _מוצלח_, _allemagn,
   {{0x426d1119,0x0db750a0,0x19775150,0x4c618097}},	// [b20] _socola_, _ministea, _ministee, _sterkte_,
   {{0x12ca1109,0xc88d91de,0x82fc7072,0x6e51718a}},	//   _reklami_, _मनोविज्ञ, _dingo_, _viranoma,
   {{0x6a589197,0x637b3008,0x11c9f00b,0x7d989025}},	//   _licentia_, _vasario_, _narednih_, _licentie_,
   {{0xc5ec2034,0xa386e1a4,0xe04560f6,0x12014140}},	//   _британия_, _cairde_, _авториза, _mediku_,
   {{0x027f7054,0x55038073,0x57bd30c9,0x27cd515e}},	//   _oranje_, _претекст_, _najrazli, _родствен,
   {{0xf2fdf045,0x00000000,0x00000000,0x00000000}},	//   _lough_, --, --, --,
   {{0x138011e7,0x93f47061,0x6202500e,0xb27ee103}},	//   _patrí_, _destun_, _katibi_, _finner_,
   {{0x9870f0e6,0xbc769239,0x00000000,0x00000000}},	//   _राजेंद्र_, _vybrali_, --, --,
   {{0x927eb0a9,0x9380602c,0x93ac6099,0xa9113091}},	//   _lienhe_, _ukuran_, _soupha_, _pojavlju,
   {{0x4c90c331,0x12ca9284,0x139400e5,0xe7473168}},	//   _क्रोध_, _opada_, _crist_, _милион_,
   {{0xdf69d00d,0x00000000,0x00000000,0x00000000}},	//   _komandos_, --, --, --,
   {{0x33940260,0x9644908e,0x00000000,0x00000000}},	//   _friss_, _robotgmw, --, --,
   {{0xb4d10070,0x00000000,0x00000000,0x00000000}},	//   _मालिका_, --, --, --,
   {{0x826c712a,0x00000000,0x00000000,0x00000000}},	//   _sinon_, --, --, --,
   {{0xe72d107c,0xb2cae0ff,0x00000000,0x00000000}},	//   _partijom_, _guiden_, --, --,
   {{0x12ff518d,0x0292701c,0x22d9a235,0xd542c0b6}},	//   _musiker_, _marami_, _povede_, _невероят,
   {{0x06d5d030,0x1fee0082,0xb2a070cc,0x0c45031f}},	// [b30] _与本站立场无关_, _amazonas_, _herbes_, _desconec,
   {{0x20c4200a,0x748da072,0xac71b103,0xf2c4706c}},	//   _אנונימי_, _situacij, _startet_, _כאַפּט_,
   {{0xe26c7013,0x03807133,0x5345212a,0x439590ce}},	//   _annos_, _heures_, _pendant_, _qaysar_,
   {{0xc2b60125,0x83f4704b,0xb6b550b6,0x1396003b}},	//   _discuz_, _cartes_, _съответн, _masser_,
   {{0x42008070,0x79e791e8,0xf681e304,0x429180ee}},	//   _saking_, _delovima_, _देसाई_, _ajram_,
   {{0xb2ca706a,0xde75a116,0x8b03f18a,0x00000000}},	//   _разочаро, _turistič, _haastatt, --,
   {{0xf7a731c1,0x917d90d4,0x803cc062,0xb26e526d}},	//   _integrov, _דיבור_, _বেসরকারী_, _gotova_,
   {{0xc9c641bd,0x9487309f,0xe2d9a186,0xa7bef030}},	//   _apresent, _स्वाइन_, _signage_, _安徽企业网络服务,
   {{0x938dc143,0x93f47061,0x093bd0b9,0x3054f124}},	//   _اشخاص_, _testun_, _funkcií_, _personen,
   {{0xd27e711a,0x42e1009c,0x00000000,0x00000000}},	//   _bonna_, _brensel_, --, --,
   {{0x1ebd6114,0x302e112b,0x67997012,0xbc2440bd}},	//   _abonamen, _produzio, _противоп, _माहेश्वर,
   {{0x5c66d008,0x7290a02c,0xc224804f,0x6316d14c}},	//   _centras_, _kadang_, _unikey_, _kwezo_,
   {{0xc197c07b,0xf2a7420c,0x6affd183,0x00000000}},	//   _работе_, _trebam_, _cróitis_, --,
   {{0xc3f8a036,0xa69551f4,0x4394004a,0x1224e020}},	//   _motorcyk, _capercai, _naise_, _punkta_,
   {{0x927ed23a,0x1394e332,0x8b0f4059,0x927f40f2}},	//   _alene_, _reisen_, _eksploat, _kwenta_,
   {{0x03958145,0x00000000,0x00000000,0x00000000}},	//   _kurse_, --, --, --,
   {{0xc3a300ce,0x11b4b0f6,0xe2240010,0x00000000}},	// [b40] _teapot_, _varmasti_, _esika_, --,
   {{0xe20150f9,0xc6cca184,0xb1f6006c,0xacf74048}},	//   _regije_, _ollainni, _פינאנץ_, _hastalar,
   {{0x22d9c088,0x52f460c2,0x31a6524f,0x43eb5091}},	//   _savez_, _dikirim_, _popović_, _vjetar_,
   {{0x6fa90005,0xc2eca1c3,0xf7b30057,0x00000000}},	//   _szoftver_, _kontroly_, _titulaci, --,
   {{0x3ac88073,0x138691a4,0xfefb3047,0x1396817a}},	//   _ресурсе_, _neart_, _perjalan, _автотран,
   {{0x75ce60b4,0x1ffc301b,0x25d65023,0x12926175}},	//   _umpamany, _способ_, _probabil_, _pirato_,
   {{0x24463030,0xb27e6004,0x2f274282,0xdff8f0f6}},	//   _信息产业部_, _joong_, _muslimer_, _французс,
   {{0x0c69e00d,0x9e295137,0x9386014a,0x00000000}},	//   _надзвыча, _nanganga, _beirt_, --,
   {{0xb3ac6129,0x6c14f071,0x431d7062,0x46ef7271}},	//   _gruppi_, _verseny_, _মতিউর_, _अभिनन्दन_,
   {{0x434e3053,0xe2fc60b2,0x3d9e30f1,0x4df710f6}},	//   _engelsk_, _mnogi_, _engelske_, _интервью_,
   {{0x53f471cb,0xa394723b,0x0037c119,0x985250a0}},	//   _partes_, _hérna_, _thitruon, _hebrides_,
   {{0x93869228,0x3a1050e6,0xee68c04b,0xa7191089}},	//   _feart_, _irlandia_, _concerna, _द्रौपदी_,
   {{0x92b400b0,0xdeaca04c,0xef3f0211,0x00000000}},	//   _krich_, _controle_, _kilometr_, --,
   {{0xfb97f236,0x279ed1dc,0x9792f025,0x0ecd61c1}},	//   _regisztr, _араба_, _instanti, _investič,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x02c271d9,0xcad2e170,0x883860c3,0x00000000}},	//   _chalupa_, _vertrete, _쇼핑몰에서_, --,
   {{0x995f8006,0xc144a1d0,0xf26dc1bd,0x99d63135}},	// [b50] _zaintere, _telefonl, _novos_, _ettepane,
   {{0xbbfc9206,0x616d200a,0xf2469063,0x6cfeb059}},	//   _postrojb, _military_, _gailísis_, _historyc,
   {{0xeb1420d4,0xf2baf151,0xf3a261c3,0x00000000}},	//   _באימייל_, _sleeved_, _shopu_, --,
   {{0xbf5b82a0,0x49bb20d5,0x8e73e0dc,0x00000000}},	//   _ramadhan, _मूर्धन्य_, _फील्ड_, --,
   {{0x78517333,0xe7c93012,0x3bc2f231,0xa3eb90d4}},	//   _recomend, _varsinai, _ट्यूटोरि, _lists_,
   {{0x62d8d06b,0x0c8590d4,0x00000000,0x00000000}},	//   _ellers_, _רוסיה_, --, --,
   {{0x020ec045,0xd6edb108,0xbc5cf062,0x00000000}},	//   _назар_, _finansow, _মুখ্য_, --,
   {{0x4cd7a099,0x335e10a7,0x3c0f20c3,0x79da92e0}},	//   _catholiq, _паузе_, _오피스텔분양권_, _desetlje,
   {{0xd2129121,0xe2b651c7,0x0dad017b,0x00000000}},	//   _byahe_, _patche_, _quantida, --,
   {{0x1b3d900a,0x3aad91ed,0xb7e67067,0x53f94071}},	//   _function_, _funktion_, _महारथी_, _indult_,
   {{0x63a29103,0x52ebc085,0xf3a3f027,0xe200d0e3}},	//   _skapa_, _kvinder_, _grupi_, _etnike_,
   {{0x42cae02d,0x00000000,0x00000000,0x00000000}},	//   _bundan_, --, --, --,
   {{0x83c400d4,0x1894307c,0x5eab2334,0xa34040e7}},	//   _ברצונך_, _stevanov, _clientes_, _defensa_,
   {{0xa22b205f,0x05eee03e,0xcc52a01a,0xa9e31045}},	//   _promene_, _příští_, _kaitlyn_, _посада_,
   {{0xb2d9b163,0x6794306c,0xb015d11c,0x3c5c6089}},	//   _covert_, _דאָלאַר_, _pajdabpo, _हिमेश_,
   {{0xc9ec20d4,0x4dc8c18d,0x5d2670c9,0x00000000}},	//   _להאמין_, _центром_, _gotovine_, --,
   {{0xd65d417c,0xdff420d4,0xf280a064,0xdd9e40bd}},	// [b60] _контамин, _הנחיות_, _herkese_, _कार्यस्थ,
   {{0xa27ec055,0xf6dd01c8,0x1394d117,0x00000000}},	//   _podne_, _मालिश_, _salsas_, --,
   {{0x44b3f06c,0xe37fc157,0xc09ba06c,0x4a8d50c3}},	//   _באָבע_, _galanta_, _אפפאל_, _전문가들은_,
   {{0x47e9013d,0x32cb4058,0x3707404c,0x00000000}},	//   _अदाकारी_, _gledat_, _instalaç, --,
   {{0x54d03090,0x222400e7,0xd3ebe043,0x00000000}},	//   _दैनिकी_, _ariki_, _hitti_, --,
   {{0x24274011,0xc2d470a3,0x677de02b,0x1ebac0c9}},	//   _напiсаў_, _naudas_, _справі_, _strokovn,
   {{0xc20bf30d,0x92018285,0x14d790f5,0x3e0f22c8}},	//   _प्रज्ञा_, _jeziku_, _забавы_, _necesida,
   {{0x026de01c,0x57ddc1d9,0x72d8b154,0x62f3c1b7}},	//   _totoo_, _financov, _videod_, _iskazati_,
   {{0x94f3112b,0x594ed2e6,0x1c5d20f3,0x00000000}},	//   _местопол, _publizit, _hasteko_, --,
   {{0x63f9024d,0x03a4017f,0x82c2900d,0x22fce055}},	//   _pobune_, _galaksij, _ахвярава, _bungah_,
   {{0x7198a0b5,0x00b07018,0xc6e5301b,0x43414284}},	//   _провизор, _तेलुगू_, _уважаемы, _izvesna_,
   {{0xd1414055,0x730870a4,0x71c7f071,0xec71a07e}},	//   _مشارکت_, _trebalo_, _létezik_, _تحولات_,
   {{0xcf6621f6,0x9d006151,0x627e9125,0x3386c061}},	//   _партии_, _groundbr, _loang_, _medru_,
   {{0x225ae01c,0x01613101,0x50f6e062,0x00000000}},	//   _drilon_, _указания_, _ত্বোহা_, --,
   {{0x639400ba,0x7ebf725d,0x00000000,0x00000000}},	//   _crisi_, _nagradne_, --, --,
   {{0xd3ead0be,0x0ecf2085,0x00000000,0x00000000}},	//   _montre_, _pavillon, --, --,
   {{0x829261ec,0x1d056008,0x1213f20e,0xaeaca223}},	// [b70] _kurang_, _populiar, _nsthe_, _kontwole_,
   {{0x3b00707c,0xb37fc14c,0x51b9b0d4,0x0ef1b0c3}},	//   _mitralje, _talanta_, _אחזקה_, _verklein,
   {{0x47154243,0xe2cae0f8,0x2ae68275,0x8d26200b}},	//   _seguranç, _sundin_, _मध्यमा_, _napomene_,
   {{0x5224d00b,0x033740d4,0xe2b4728c,0x32b4d261}},	//   _preko_, _סטטיסטיק, _kunci_, _preco_,
   {{0xf22491b0,0x5c630193,0x98530021,0x7316d0a4}},	//   _zraka_, _estudio_, _estudios_, _prozor_,
   {{0x1b09300d,0x4688e08e,0xb2f300e2,0xd2d21150}},	//   _kompiute, _wonderli, _dilihat_, _paremini_,
   {{0xdc5ce259,0x4c75f1b9,0xbe8f3041,0x00000000}},	//   _नोबेल_, _napriek_, _कविताओं_, --,
   {{0xccd1d15f,0x9310b22f,0x4db43119,0x637fd055}},	//   _особено_, _knuckle_, _dienthoa, _walanda_,
   {{0xe7ee324a,0x4e54a125,0x16b2f186,0x53948119}},	//   _betaling, _yeuamnha, _weightli, _ringring_,
   {{0xf18d2034,0xd20261c4,0x1a15210a,0x5cef31ed}},	//   _малайзия_, _netinu_, _mutarama_, _hintergr,
   {{0xaf16c12d,0x51434063,0x0e70120d,0x7f136061}},	//   _leideann, _ممارسة_, _जॉर्ज_, _ffotogra,
   {{0x140441ad,0x00000000,0x00000000,0x00000000}},	//   _semináře_, --, --, --,
   {{0x2986a08d,0x8e984019,0xcaf72049,0xdd8ba023}},	//   _মুজতবা_, _موجودة_, _наречия_, _majorita,
   {{0x32b49108,0x739490a3,0x7c01c097,0xde19e189}},	//   _praca_, _prasa_, _luister_, _dilengka,
   {{0x33ead1a1,0x227ed10e,0x2c762150,0x72fc014c}},	//   _contre_, _eleni_, _सिक्सर_, _liigi_,
   {{0xc25ac1c2,0x72ef80c1,0x73097108,0x9380727d}},	//   _mellem_, _rhyfel_, _aplikacj, _verras_,
   {{0x1c53720c,0x1c630061,0xc2cb8274,0x21e24070}},	// [b80] _sustava_, _astudio_, _maslahi_, _नागरी_,
   {{0x2dc52031,0xc2d1203e,0xf38060e7,0x6b07d00b}},	//   _طبقات_, _autorem_, _metros_, _видети_,
   {{0x6e53a055,0x22c65129,0x00000000,0x00000000}},	//   _masaraka, _stampar_, --, --,
   {{0x2e6de2f7,0x72ea010a,0x72eef16c,0x076081b9}},	//   _अधिकारिय, _ingingo_, _sniffs_, _michalov,
   {{0x925ad045,0x79cda1e1,0xb780f06c,0x7b21c156}},	//   _spela_, _diterbit, _פאררעכטן_, _атенуаря_,
   {{0xd56ff159,0xc3cff073,0x2883d0c3,0x5af7d15f}},	//   _servicio_, _servicii_, _인근지하철_, _заменик_,
   {{0x4b142067,0x83877150,0x200af00b,0xc62d6045}},	//   _क्षणिक_, _paarid_, _raspoređ, _trondhei,
   {{0x40ad517d,0xdceed073,0x6dacc042,0xa6d32070}},	//   _ধ্বংস_, _креде_, _діагност, _दूषित_,
   {{0x5d1e210a,0x9eda1058,0xc092517d,0x0c3690a9}},	//   _genocide_, _pasijans_, _মাতুং_, _muarẻ_,
   {{0x626de159,0xdf10c2a9,0x08c0c1b9,0xfd56d07c}},	//   _votos_, _predsedn, _predsedu, _obrazuju_,
   {{0xd20090d1,0xaea8c16b,0xc3df2036,0xf6eea036}},	//   _txais_, _анатоль_, _この質問内容が不, _よくある質問_,
   {{0xc2d8c02b,0x9739c0a7,0x7d46a062,0x00000000}},	//   _bilete_, _impotriv, _সফ্টওয়্, --,
   {{0x837371a6,0xbc51e041,0xc394d2a6,0x9212910a}},	//   _demande_, _यादें_, _ouest_, _byaha_,
   {{0xbf263025,0x888611a3,0x00000000,0x00000000}},	//   _홈페이지에_, _prohibid, --, --,
   {{0x526cf0c1,0x2a75e0dd,0xe6833094,0x0906c072}},	//   _digon_, _клубот_, _रतलाम_, _альтэрна,
   {{0x02fc7067,0x00000000,0x00000000,0x00000000}},	//   _ringi_, --, --, --,
   {{0x5c64909e,0x134c7077,0x84cd4044,0xcef560a7}},	// [b90] _octubre_, _juvenil_, _điều_, _активита,
   {{0x226ce12f,0xf86f00bf,0xaf4c4036,0xee8b307e}},	//   _infos_, _očigledn, _ウェブライタ_, _نسبتا_,
   {{0x927ff070,0x14641055,0xfb84510f,0xa7c91024}},	//   _jeung_, _ائتلاف_, _transpor, _گذاشته_,
   {{0x086450e1,0xc61d9026,0x640d2063,0xf2cb80a2}},	//   _универзи, _innovaci, _النحو_, _cardi_,
   {{0x52fc7143,0xf39570a9,0xd9f6c18a,0xc386d2a0}},	//   _wingi_, _trasua_, _причем_, _geert_,
   {{0x72da40b8,0x4394d00a,0x82ac2125,0xb089c12b}},	//   _fullbox_, _guest_, _phaolô_, _певица_,
   {{0xbd9e0040,0x00000000,0x00000000,0x00000000}},	//   _scrollba, --, --, --,
   {{0x3c1bd166,0x5f13715d,0xe200d031,0x00000000}},	//   _mahabhar, _jetmotor_, _ideig_, --,
   {{0xf39540e8,0x2386611b,0x33a3a0b6,0x77647335}},	//   _questa_, _stora_, _mappa_, _अस्तित्व,
   {{0xb09f2036,0xad0aa2be,0x62a6119d,0xa6a8d0bf}},	//   _イベント会場_, _मृत्युंज, _aghbe_, _приступа,
   {{0x05e19030,0x1be36047,0x74074260,0x1e47e17c}},	//   _网站或个人转载使, _sementar, _feliratk, _требуе_,
   {{0xe290f08f,0x0aefc109,0x52cae113,0x334fe185}},	//   _pahang_, _postijie, _handla_, _desetak_,
   {{0x52b57099,0x35add034,0x668c30fc,0x9292729c}},	//   _deacon_, _работата_, _पुरान_, _straat_,
   {{0x568ee0a2,0xed50e2fa,0x037ec0a7,0xb39600db}},	//   _ceredigi, _वेस्टइंड, _абордязэ_, _massor_,
   {{0x73f4601b,0xf87d2017,0x127f7019,0x4a250035}},	//   _kautta_, _кампанія_, _amanna_, _अजिबात_,
   {{0x73ce801f,0x3585a0c0,0x105dd024,0xa3ea3015}},	//   _takvim_, _bandaray, _آشپزی_, _namtha_,
   {{0x89f29034,0x3c67d01b,0xe291002c,0x42e7d112}},	// [ba0] _великобр, _minusta_, _cabang_, _minustah_,
   {{0xbf492109,0x6c53a0d0,0xa3958186,0x58bc20d4}},	//   _kompleta, _मतभेद_, _kurso_, _מפגשים_,
   {{0x22bb8064,0x5c4b1111,0x64f91234,0x00000000}},	//   _nedenle_, _sunting_, _موبايلي_, --,
   {{0xa2d8b01e,0xb2ab1069,0x59f7a0a7,0x9f2391e1}},	//   _videre_, _vandaag_, _episcopu, _menentan,
   {{0xae71c0cb,0x5679d034,0x18cb6133,0x9b9ab151}},	//   _गेट्स_, _региона_, _北京新发地_, _castañed,
   {{0x103fc02d,0x92c510f7,0xbc6161ab,0xaa1f20c3}},	//   _sistemin, _selline_, _dituela_, _쪽지보내기_,
   {{0x23eb9072,0x34c1f141,0xbc5af26d,0xd532817b}},	//   _rasti_, _memberik, _platiti_, _телефонс,
   {{0x027e5005,0x330fe1b7,0x00000000,0x00000000}},	//   _volna_, _osobito_, --, --,
   {{0xd0270005,0x6afa60c3,0x00000000,0x00000000}},	//   _باغیوں_, _이르기까지_, --, --,
   {{0xb22490bd,0x0e500025,0xe3fa514c,0x4e595012}},	//   _braku_, _vakantie_, _yatuma_, _минималь,
   {{0x239582ff,0xe32170f8,0xdc97f065,0x52df1124}},	//   _curso_, _prayed_, _प्रकारच्, _sonntag_,
   {{0x27cad12b,0xb224b03e,0x1380717d,0x00000000}},	//   _consigli, _řekla_, _perros_, --,
   {{0xd74ed0bf,0x225b9015,0xe22490db,0x00000000}},	//   _праве_, _tasli_, _frakt_, --,
   {{0x8ae9300d,0xc29c416c,0x323fe0c3,0x019c3063}},	//   _розьн_, _txujlub_, _모집합니다_, _الظلم_,
   {{0xc33d3024,0x557851b9,0x875c1133,0x9784e12b}},	//   _ایشان_, _posledný, _政府信息公开_, _актуализ,
   {{0x427e6336,0x6394218c,0xe35f3122,0x5f584063}},	//   _yoona_, _saksa_, _langile_, _comporda,
   {{0x422471ba,0xfd90c04c,0xf2557094,0x00000000}},	// [bb0] _manke_, _менде_, _सेरेना_, --,
   {{0xc2da505d,0x0fc2c019,0xd2cb9002,0x3386021e}},	//   _mateka_, _كانون_, _qasdi_, _ngira_,
   {{0xaf3ca1dc,0x5bf9318d,0xe386014b,0xffe80070}},	//   _колорату, _googlegr, _igira_, _अर्थातच_,
   {{0x8838f12b,0xb62e3005,0x00000000,0x00000000}},	//   _проектир, _اثاثوں_, --, --,
   {{0x73860023,0x52d8b10a,0xf083b0c1,0xb27ee18d}},	//   _stiri_, _indege_, _derbynio, _vinner_,
   {{0xe04b1082,0x950a6023,0x7387702f,0x00000000}},	//   _entregan, _momentul_, _modrá_, --,
   {{0xeddca072,0x944ee02f,0x72494192,0xff043062}},	//   _каментар_, _souvisej, _premio_, _খেরোখাতা_,
   {{0xbd02f1aa,0x15319059,0xa2489337,0x3572f033}},	//   _fortalec, _चम्बल_, _imamo_, _fortalez,
   {{0xeffa5070,0x6fcbc045,0xb2247124,0xd2ff402a}},	//   _सरकारने_, _свобода_, _danke_, _skriver_,
   {{0x52da5074,0xc9f61005,0xc58631ab,0x6087f234}},	//   _wateja_, _روپیہ_, _esaterak, _podchrao,
   {{0xd3869141,0x126dc090,0x137f31e7,0xefc30172}},	//   _utara_, _novou_, _šmajda_, _familier_,
   {{0x82927043,0xf9d8a0ef,0x6386012e,0xab10808e}},	//   _gerast_, _inceleme, _agira_, _spesifie,
   {{0x152b7005,0xce3521e7,0xd5fda1c1,0x49916262}},	//   _لڑکیوں_, _relaxova, _potenciá, _तिरछी_,
   {{0xb3807026,0xd248e0a7,0x12258121,0xc1c39136}},	//   _terres_, _асигурэм_, _turko_, _affinità_,
   {{0x63877019,0x00000000,0x00000000,0x00000000}},	//   _bearta_, --, --, --,
   {{0x317e015e,0x40c7c0a7,0x7387712d,0xa3a2313e}},	//   _положени, _физиче_, _cearta_, _secretár,
   {{0x0b04f013,0xc44a107c,0x00000000,0x00000000}},	// [bc0] _viestist, _sledećoj_, --, --,
   {{0xb24201bf,0x83410115,0xfb914238,0xa26c7005}},	//   _nyumbani_, _desemba_, _estación_, _finom_,
   {{0x03eb8135,0x7b916059,0x00000000,0x00000000}},	//   _tartu_, _materiał_, --, --,
   {{0xdcb73017,0x3a35e0dd,0x00000000,0x00000000}},	//   _немцы_, _parceria_, --, --,
   {{0x2248c0bb,0x00000000,0x00000000,0x00000000}},	//   _kommer_, --, --, --,
   {{0x03947261,0xbe32c10e,0x1dc4f20c,0x2dc00140}},	//   _séria_, _dolgella, _prekrasa, _kummerċ_,
   {{0xe804f187,0x6312110f,0x3783d075,0x4863a09a}},	//   _австрали, _members_, _प्राविधि, _קרוין_,
   {{0xac65007a,0x22902117,0x8c9ac18d,0xb9f60039}},	//   _最近のコメント_, _nekad_, _квартир_, _japán_,
   {{0x628cd063,0x00000000,0x00000000,0x00000000}},	//   _كلامك_, --, --, --,
   {{0x62b55146,0xad094223,0x00000000,0x00000000}},	//   _precis_, _lapointe_, --, --,
   {{0xa2018002,0x99689085,0x129140c1,0xd7c8c012}},	//   _bezier_, _danielse, _bedair_, _konserni,
   {{0x42fc713b,0x36277059,0xe7a1f01e,0xb6e60063}},	//   _singl_, _autorski, _reguleri, _ههههههه_,
   {{0xb96e5046,0xe202025d,0xb39601ed,0xf65bf005}},	//   _aksident, _kupite_, _wasser_, _تنخواہ_,
   {{0x4ec430b8,0xc1c4009a,0x284a200b,0x00000000}},	//   _tienphon, _מאנהעטן_, _паралелн, --,
   {{0x1071806d,0xf4d6a154,0xa2b66338,0x13eb7339}},	//   _ibrahimo, _नगरिया_, _marche_, _glatte_,
   {{0x328f41f4,0x4c0a521c,0xa26de199,0x00000000}},	//   _wishart_, _kúpele_, _gotov_, --,
   {{0xcf1160fc,0x04114051,0xe3874080,0x00000000}},	// [bd0] _suitseta, _passagen_, _sperre_, --,
   {{0xaf93828e,0xd2240121,0xa5ed906c,0xc297101a}},	//   _vendedor_, _tsika_, _פינעף_, _walkout_,
   {{0x13878032,0x5f90c07e,0x59f120c2,0xa78ea06c}},	//   _terre_, _انگيز_, _sahingga_, _אומשטענד,
   {{0x2394012d,0xf9061025,0x7bec8088,0x00000000}},	//   _naisc_, _부탁드립니다_, _mehaničk, --,
   {{0x52b461b9,0x71a720d8,0x93426034,0x33950081}},	//   _troch_, _ہڑتال_, _modello_, _vlasov_,
   {{0x9b97410a,0xa837e025,0x82a6c055,0x134c21c3}},	//   _komisiyo_, _하겠습니다_, _tumbas_, _dostupný_,
   {{0x03fad045,0x61e3e0dc,0x32eed100,0x00000000}},	//   _старший_, _सायरन_, _diofar_, --,
   {{0x826ce118,0xb260207c,0xd3416136,0xe473c0ed}},	//   _ponovo_, _verovali_, _stretta_, _lehendak,
   {{0x638692eb,0x6cf40154,0xd76e30dd,0x29937036}},	//   _ceart_, _गीतकार_, _подготве, _ソフトウェア_,
   {{0x4396002b,0x63a3f129,0x5bba80cb,0x03869043}},	//   _passer_, _grupp_, _मल्लिका_, _starf_,
   {{0x2d7fa062,0xd2da621f,0xf29140c1,0xa71dc2be}},	//   _বিনিময়_, _pareja_, _pedair_, _भद्दा_,
   {{0xa9d600e0,0xeae0503b,0x52b66030,0x8d331046}},	//   _गरेपछि_, _sundheds, _gauche_, _townhome_,
   {{0x0380633a,0xc918206c,0x00000000,0x00000000}},	//   _letras_, _רעזשים_, --, --,
   {{0x8e4042e4,0xa3177101,0x1e7ee035,0xc2a78145}},	//   _प्रशस्ति_, _grazie_, _अधिकाऱ्य, _serbe_,
   {{0xcc6ab0cb,0xfda2c12b,0xf224218a,0x1090b005}},	//   _चुप्पी_, _контрол_, _pakko_, _پیرزادہ_,
   {{0x89dfb031,0x02ea71e2,0x425ad156,0xaf1e314a}},	//   _hangulat, _latihan_, _acele_, _sealbhói,
   {{0xe1654046,0xe1539011,0x44a991c3,0x00000000}},	// [be0] _motorway_, _гомель_, _dynamick, --,
   {{0xcc4960e7,0x06e8b0b6,0xf26c20d4,0xffb960e7}},	//   _título_, _гарантир, _remove_, _títulos_,
   {{0x0a39115f,0x00c3a0d4,0x1198300b,0x03ada0d4}},	//   _решение_, _הטקסט_, _потребна_, _לסגור_,
   {{0x79e4824d,0x034201d0,0x92d4824f,0x00000000}},	//   _osnovana_, _gereken_, _osnovan_, --,
   {{0x03ce91a7,0x4b6230bd,0x6386616a,0xac12b074}},	//   _glavu_, _नलिने_, _store_, _utaratib,
   {{0x85a0c17d,0x7a1631b0,0x888951e4,0x00000000}},	//   _পাবলিক_, _rotacija_, _застрахо, --,
   {{0xf224e03c,0x626c2117,0x4876e059,0x07b330e7}},	//   _bankas_, _nikos_, _gimnazju, _próximos_,
   {{0x7200300b,0x330c00d4,0xfe8eb0d8,0x938ad06d}},	//   _armije_, _והשכלה_, _látogató_, _təxirə_,
   {{0x8f81c108,0x1ecc5061,0x50d6900b,0x02bb71df}},	//   _हल्के_, _ambiwlan, _енергије_, _komunità_,
   {{0x73869234,0x8200d2e6,0x12f3b23e,0x07c4106c}},	//   _fearr_, _ideia_, _periodu_, _סטאנציע_,
   {{0x5c51d0d0,0x92f4c122,0xc917d0dd,0x5bee3012}},	//   _tentara_, _espiral_, _камерон_, _таком_,
   {{0x3c7c400b,0x13869114,0x0b74c064,0x5225917f}},	//   _потенциј, _afara_, _devamını_, _ruske_,
   {{0x127e6121,0x33a3f01d,0x2e608023,0xa5ce31e2}},	//   _anong_, _kaupa_, _астэзь_, _antarany,
   {{0xc1b1c17d,0xfc267030,0xe25be002,0xa27ee100}},	//   _আপডেট_, _加入收藏夹_, _patlh_, _ainnir_,
   {{0x225a9115,0xf25be002,0x127e918f,0xd6e14133}},	//   _mbali_, _qatlh_, _klant_, _大家的成本多少啊_,
   {{0x2e483234,0x425be002,0x6e9c02c9,0x3201502c}},	//   _فيروز_, _vatlh_, _kommunin, _daging_,
   {{0x0b7651c5,0x425a905f,0x32c65073,0xcb6c0209}},	// [bf0] _publicac, _obali_, _publice_, _communic,
   {{0x3d2ec17d,0x956db2e7,0x23873181,0xe387023b}},	//   _তাছাড়া_, _formació, _staré_, _þarna_,
   {{0xceace00b,0x52da017a,0xd3bc2024,0xe2fcf146}},	//   _користит, _årets_, _تلفنی_, _ligga_,
   {{0x1358e1d9,0x373241c1,0xe12021e7,0x720fd078}},	//   _letenky_, _informov, _podpolož, _प्रश्नों_,
   {{0xbfd821be,0x23796175,0xa386d1ae,0x46d610dd}},	//   _تقويم_, _kitanda_, _atera_, _стратешк,
   {{0xa394f053,0x96bcd133,0x9f22e0a9,0x00000000}},	//   _spiser_, _见习魔法师_, _vietinba, --,
   {{0x827e902a,0x427e61b1,0x534140ff,0x00000000}},	//   _blant_, _goons_, _studier_, --,
   {{0x6420b0c2,0x12fc9199,0xfdbc91b7,0x5ec82133}},	//   _صلاحيت_, _ostaviti_, _ostavite_, _小影酷电影报道_,
   {{0xf2d9402e,0xc2fcf0d2,0xe04d40d4,0x336ce06a}},	//   _videot_, _jigga_, _הפלסטיני, _виктория_,
   {{0xf2fe102d,0x83ebf00d,0xe2da6177,0xafe410e9}},	//   _birgə_, _gauti_, _sarean_, _neatkarī,
   {{0xfa6b42b5,0xd097e083,0x223781e1,0xb7aa31b9}},	//   _प्रशंसक_, _времена_, _kerja_, _anatómia,
   {{0xb2fc7067,0x489dd030,0x73790115,0xf39620d4}},	//   _mingi_, _中国人民银行_, _misaada_, _בסביבות_,
   {{0xa2fc7127,0x2c072019,0xe386423a,0x45d0a0e9}},	//   _lingi_, _malartú_, _lumre_, _augustā_,
   {{0xbc6ac32d,0xac28e244,0xbefbc030,0x00000000}},	//   _चिठ्ठी_, _establec, _provence_, --,
   {{0xd20050eb,0x34f64133,0x0cb91062,0xf2e7d041}},	//   _telif_, _一年赚一生工资_, _দেবদারু_, _बलबिन्दर_,
   {{0x516fd309,0x9c6210b7,0x92d9e086,0x2faa9157}},	//   _रासायनिक_, _sigurno_, _actes_, _novootvo,

   {{0xe200c008,0x154a4060,0x606650a3,0x00000000}},	// [c00] _galite_, _половини_, _kandidāt, --,
   {{0x83eb80b5,0x7f12f244,0xb132f244,0x1c5200e0}},	//   _harti_, _distinta, _distinto, _हुनेछ_,
   {{0x21cc9037,0xd6dfa034,0xeb61a0bd,0x00000000}},	//   _attività_, _descrizi, _मिलनी_, --,
   {{0x2200c223,0x1c37902a,0x58c7902b,0x00000000}},	//   _kalite_, _району_, _районі_, --,
   {{0x672ba030,0x92cb8268,0x22ad1019,0x00000000}},	//   _经销假冒伪劣商品, _mardi_, _ألوان_, --,
   {{0xda0aa1c0,0x3bca917f,0xe0db9089,0x92645050}},	//   _manakala_, _preminuo_, _एसटीडी_, _astlya_,
   {{0x03406190,0x72769132,0x401d3101,0xad43a06c}},	//   _bagenda_, _mbinguni_, _ирландия_, _שטויב_,
   {{0x3c6fc022,0x2ae7a00b,0xf13f201b,0xaec430a9}},	//   _titulek_, _медицине_, _ihmettel, _vienthon,
   {{0x425d20c3,0xa27ec002,0xb2fc0100,0x8f43202a}},	//   _자연스럽게_, _lodni_, _uaigh_, _досвід_,
   {{0x234aa071,0x603b90f0,0xd387c022,0x025ac150}},	//   _خریدار_, _hautxawj_, _dobrá_, _koolid_,
   {{0x480d5012,0x0771012b,0x4e8a5035,0x00000000}},	//   _понедель, _търговия_, _वाढत्या_, --,
   {{0x43ebf132,0x940ef14a,0xf6a8b06a,0x13ac10bf}},	//   _sauti_, _teorainn_, _миграция, _слободан_,
   {{0xa7caa11f,0x9f2bd166,0x4e92032c,0x9dd0f224}},	//   _असामान्य_, _kabudaya, _poškoden, _archduke_,
   {{0x75e8c040,0xe2bf8036,0x00000000,0x00000000}},	//   _psychoph, _ザ操作端末_, --, --,
   {{0x3caad067,0x527f60ce,0x00000000,0x00000000}},	//   _पूर्वांच, _angnes_, --, --,
   {{0x41ce5045,0xbdffc2b2,0x6248c158,0x6035b0c5}},	//   _положенн, _understa, _sommar_, _seitenan,
   {{0x23954013,0x88095025,0x03f4020c,0x3982706f}},	// [c10] _viesti_, _삼성패밀리세이브_, _sustav_, _možnosti_,
   {{0xeaaa3024,0x5651523f,0x8f6fb0d4,0x6b993041}},	//   _تغذیه_, _skrifaði_, _במזרח_, _मृतुलोक_,
   {{0x67b5008e,0x7ac49039,0x00000000,0x00000000}},	//   _rassisti, _ارتکاب_, --, --,
   {{0x39b9600b,0xf2e81241,0xc2b40002,0x7e70c022}},	//   _материја, _dicipta_, _chich_, _चुस्त_,
   {{0x5e4380d0,0x52c590b8,0x740b7129,0x1d30d124}},	//   _madaniya, _beeline_, _immigraz, _freizeit_,
   {{0x05049030,0x6bc130c3,0x31d3e0d4,0x5c57f036}},	//   _除权除息日_, _세금계산서_, _recently_, _強い味方が必要_,
   {{0xa9022025,0x92f6115f,0x95a9a070,0x14fda0c3}},	//   _저작권침해_, _словениј, _प्रवाशां, _상품입니다_,
   {{0xc1880020,0x00000000,0x00000000,0x00000000}},	//   _restorān, --, --, --,
   {{0x6c9ac07e,0xb2fc013f,0x8c34e0c3,0xe3eae166}},	//   _خودکشی_, _taigi_, _민주주의법학연구, _manten_,
   {{0x792f708c,0x0395f15d,0x92cae054,0xc72950bf}},	//   _inimeste, _kruse_, _landen_, _приступи,
   {{0xcc5381fb,0x039420e9,0x42b5f049,0x0c28c0c2}},	//   _sentido_, _maksa_, _cruce_, _خيانت_,
   {{0x3248f0a7,0xf22490fc,0x22d8f219,0x39ca4074}},	//   _primul_, _saaka_, _amgen_, _bagosora_,
   {{0x931780e0,0xdc7e20c4,0x7292511e,0x72eb70a9}},	//   _verzi_, _verskyn_, _gitabo_, _vitinfo_,
   {{0xe724b16f,0xeea381aa,0x0b61f041,0xf64c9005}},	//   _strednej_, _vendidos_, _बिकनी_, _متشابہہ_,
   {{0x0676b0e4,0x2622832c,0xf27c6124,0xe967c070}},	//   _دانشور_, _organizá, _herstell, _तुलनेत_,
   {{0xf166804c,0xa401907d,0x4d978108,0x8682d035}},	//   _партија_, _ameriken_, _motoryza, _अहवाल_,
   {{0xf2266025,0xa38660c1,0xb2909052,0xd0c7d024}},	// [c20] _merken_, _stori_, _rakaat_, _زیرنویس_,
   {{0xc66f6108,0x9d6f3063,0xa6816277,0xd34c21c1}},	//   _pozdrawi, _أحكام_, _गोदाम_, _dostupné_,
   {{0x32b1d02c,0x42cb516c,0xf415d12b,0x15a9f133}},	//   _bendera_, _dogdig_, _гледай_, _大兴少年宫_,
   {{0xfb8a117b,0xf2c77072,0x5ad9c07f,0x00000000}},	//   _сорос_, _засталос, _トラックバックの_, --,
   {{0x939420e9,0xe3945130,0x604d1063,0x9c747035}},	//   _faksa_, _valse_, _للمرة_, _अवघ्या_,
   {{0x72cbf0a3,0x32ca5023,0x52cae054,0x323b201d}},	//   _naudu_, _conditii_, _handen_, _heimilt_,
   {{0x9c51d21d,0xd2b400b8,0xbde6f1d5,0x00000000}},	//   _tentera_, _thich_, _prajurit_, --,
   {{0x938662cd,0x922591e8,0x07c5f077,0xb0239157}},	//   _agora_, _ruski_, _prestaci, _pondelok_,
   {{0xf200612a,0x3aebc0b4,0xa6728004,0x42cbf135}},	//   _avoir_, _golongan_, _chodansi, _kaudu_,
   {{0xcfea4041,0xbba481e0,0x4fe0617d,0x00000000}},	//   _पुरालेख_, _lediglic, _articulo, --,
   {{0x11703025,0x4435e12b,0xf3797170,0x6bf1e191}},	//   _책임한계와_, _функция_, _angaben_, _berterus,
   {{0x07aad02e,0x3236018f,0x50b7e18a,0x00000000}},	//   _любви_, _vrije_, _парень_, --,
   {{0x93949098,0x9a60f06c,0x73ce500c,0xd2f46228}},	//   _maaso_, _אָננעמען_, _solvi_, _airneis_,
   {{0x123601fd,0x13413063,0x0b73e17a,0x7fa51133}},	//   _trije_, _أنحاء_, _посаду_, _网络文化经营许可,
   {{0x003fb002,0xa25bb002,0x622540f9,0xa1e0e038}},	//   _earthlin, _maqli_, _stekla_, _periudhë_,
   {{0x78738112,0x00000000,0x00000000,0x00000000}},	//   _disponib_, --, --, --,
   {{0x26de72e2,0xaed7a041,0x84874089,0x00000000}},	// [c30] _प्रहेलिक, _साइटों_, _पटनायक_, --,
   {{0xc358f0ce,0x0046f17a,0x5da9d059,0x1cac9133}},	//   _fluency_, _profesjo, _zapomnia, _商务部网站_,
   {{0x322430bd,0xa16c915f,0x02b531d0,0x92da5023}},	//   _bajka_, _предност_, _kendine_, _altele_,
   {{0xb2a7c0e8,0xec7c8124,0x4ff9819f,0xc197c0f6}},	//   _района_, _meisten_, _सोसायटी_, _районе_,
   {{0x038690ea,0xd581515f,0xf6b1c089,0x00000000}},	//   _atari_, _associaç, _कबूतर_, --,
   {{0x1e73e003,0xea36b067,0x828f10fd,0xb580c1f9}},	//   _पेस्ट_, _सर्वेश्व, _omukono_, _аниме_,
   {{0x02a601ae,0x82a6d098,0x83967170,0x0957306c}},	//   _uribe_, _ntebe_, _dessen_, _אינדיווי,
   {{0x1daf412a,0x03167098,0xe26cf22e,0x135741c6}},	//   _christop, _kunze_, _gigot_, _parecer_,
   {{0x5c55b18f,0xc2bc033b,0x2c05f038,0x6358e275}},	//   _bestand_, _फागुन_, _personi_, _letecky_,
   {{0xd236020c,0x6158a02a,0x932ac1e2,0x42480017}},	//   _prije_, _оголошен, _provinsi_, _seimo_,
   {{0x0413f173,0x5b88e2e9,0x72c4e33c,0x426cc0bd}},	//   _ceistean_, _artikler, _animais_, _widok_,
   {{0x72258013,0x0093317d,0xa25ad009,0xa9e6d17d}},	//   _turku_, _ফারুক_, _cholli_, _estructu,
   {{0x026d8122,0x5278733d,0x4d11315f,0xe226601d}},	//   _kirol_, _alunos_, _уставот_, _merkja_,
   {{0x59b73106,0x0af1f18d,0x117921f0,0x456890dd}},	//   _bandiera_, _webserve, _španiels, _придонес,
   {{0x722571fd,0xa2bb1112,0x402ec12b,0xb41d7024}},	//   _praksa_, _konekte_, _tradizio, _prussian_,
   {{0xa5cd901b,0xf45392a3,0xf3b7a0d4,0xd2fc01ab}},	//   _пожалова, _अनौपचारि, _כעבור_, _zaigu_,
   {{0x9358b199,0x526d00a4,0x00000000,0x00000000}},	// [c40] _drugome_, _izbora_, --, --,
   {{0x71fc9073,0x65a9b036,0x23439035,0xe26e717f}},	//   _порядков, _よろしくお願いし, _येथून_, _heroji_,
   {{0x4387f09e,0xa3869185,0x72da024a,0xafbd1133}},	//   _veure_, _igara_, _insekt_, _年中国经济现代化,
   {{0x2cf7a33e,0x93869004,0x149ab024,0x24f53194}},	//   _प्रकार_, _muare_, _متاسفانه_, _itumanah,
   {{0x4378e055,0x18dcd156,0x3386923e,0x00000000}},	//   _lalakon_, _аузит_, _stari_, --,
   {{0x31fc3055,0x736a1005,0x525a900c,0x920091a6}},	//   _malagasy_, _جوڈیشل_, _najlon_, _avais_,
   {{0x41f0b00a,0xf5c1e173,0x78e5719d,0x00000000}},	//   _פרויקטים_, _artaigil_, _aqrosdaq_, --,
   {{0xf01fb124,0x6477a02a,0x0230a22d,0x18bfb109}},	//   _moderato, _проекту_, _alemán_, _moderatu,
   {{0x1c5b90f2,0x401fd073,0xc1cc60e9,0x00000000}},	//   _katulad_, _referito, _finansēj, --,
   {{0xfc761067,0x8200d00d,0x7290c15f,0x00000000}},	//   _पुष्पा_, _kelias_, _demais_, --,
   {{0x779e60d5,0x03eae150,0x32b4033f,0x738771f3}},	//   _दुराचारी_, _kontot_, _chico_, _tvarka_,
   {{0x626ce06f,0x3ae71062,0x6e74d2f1,0x00000000}},	//   _osnovi_, _ফেরারী_, _nacistič, --,
   {{0xd2d8e01a,0x1b6be18d,0x1fc28045,0xc0dae041}},	//   _maneho_, _reformer, _польщі_, _कैसीनो_,
   {{0xd2b4d245,0x17a751f0,0xa779401d,0x7ca8e1e3}},	//   _preci_, _opatreni, _fiskidag, _skryfwer,
   {{0x73eb8014,0x927e101d,0x827ed223,0x00000000}},	//   _marts_, _einstakl, _plent_, --,
   {{0x1ab940b4,0x722a618a,0x306df0fc,0x0aa830c3}},	//   _perkakas, _саакашви, _मदरसा_, _전체적으로_,
   {{0x1cf7a038,0x4cc520a7,0xf85410d4,0x32a6d197}},	// [c50] _kulturor, _активитэ, _הרביעי_, _gulbis_,
   {{0x32d82130,0x158fb0bb,0x66823059,0x49b38008}},	//   _teken_, _historik, _akcesori, _рэвалюцы,
   {{0xf75a100a,0x92add031,0xc7848017,0x32494067}},	//   _לכיוון_, _الشان_, _скульпту, _asemel_,
   {{0x53874077,0x57a43133,0xe56fa098,0x02b2f0d8}},	//   _ordres_, _胶南市乡镇及街道, _omuwendo_, _rendben_,
   {{0x225a6340,0x9d8d40f0,0x0a6540bd,0x980d9063}},	//   _spolu_, _lemongra, _कार्यकाल_, _التّسجيل_,
   {{0x425a6023,0xe9aac101,0x83790134,0x00000000}},	//   _acolo_, _нокиа_, _zdravia_, --,
   {{0x825be002,0x939470be,0x6e24f080,0x013391c4}},	//   _jatlh_, _panse_, _альянс_, _skilaboð_,
   {{0xe1e5b145,0xab87c062,0xdc188168,0xc77f8086}},	//   _politikë_, _ঘুরতে_, _раководс, _convicci,
   {{0xa25be002,0x2c6fc1eb,0x62e0c0b6,0x589a20c3}},	//   _latlh_, _loturak_, _tecnico_, _포토갤러리_,
   {{0x21257025,0xd2a6a002,0xe3a5b03a,0xa127102a}},	//   _사업자등록번호_, _dubbe_, _garancij, _заходи_,
   {{0xa248c133,0x667c402b,0xc200200e,0x6db30045}},	//   _sommes_, _комуналь, _ilkin_, _belastet_,
   {{0x7cff1019,0x13401140,0x8387e024,0x03030005}},	//   _خصوصا_, _tabella_, _netra_, _valamit_,
   {{0xc3eb903c,0x73fa711e,0x8c05d14e,0x00000000}},	//   _pastu_, _rusumo_, _energieb, --,
   {{0xdd47b0e0,0x498b00b2,0x3b17b023,0x025be002}},	//   _dispozic, _znači_, _dispozit, _batlh_,
   {{0xe2d8418f,0x5e08e052,0x9943604b,0x91fe2157}},	//   _nemen_, _hendakla, _imprimer_, _diskusné_,
   {{0x62fcd12e,0xb96d32e3,0xdeb9d025,0x00000000}},	//   _nzego_, _peringat, _situatie_, --,
   {{0x82d842e6,0x22cae0f3,0xcf25b069,0x4a70d16f}},	// [c60] _hemen_, _handia_, _telefoon, _vášne_,
   {{0xb1e1a1d2,0xeec3a00a,0x42014193,0x29e1a0d4}},	//   _niektoré_, _ארוחת_, _medios_, _אכילה_,
   {{0xc3f46234,0xc3427130,0x670fb234,0x3db9e01a}},	//   _curtha_, _beteken_, _institiú, _maghinta,
   {{0xed7171a5,0xeaf85124,0x3c0600d4,0x94984062}},	//   _promatra, _aktuelle, _ישעיהו_, _পদত্যাগ_,
   {{0x33fa6008,0x247c3064,0xe5bae13b,0x00000000}},	//   _forume_, _genellik, _přičemž_, --,
   {{0xd134006c,0xb3fa60f2,0x4303a1a0,0x5676f062}},	//   _יאנואר_, _laruan_, _magamit_, _অদৃশ্য_,
   {{0x49cc11be,0xbe0022c8,0xc387e043,0x5be7517b}},	//   _rendelke, _necesita, _betra_, _assessor,
   {{0xc3f4716e,0x0386d0b1,0x9c246208,0x63f46131}},	//   _sastra_, _peoria_, _nujqiam_, _riutha_,
   {{0xab56d08f,0xf2bcd041,0xbac71185,0x420271d8}},	//   _sentiasa_, _माथुर_, _prilično_, _risico_,
   {{0xbc630132,0xfc6bd034,0xf748106c,0xd2b1d16e}},	//   _matukio_, _означава_, _גענאַדי_, _pandawa_,
   {{0x79fa71b2,0x22cae0ef,0x3b629136,0x00000000}},	//   _maghanap_, _yandan_, _ġurnata_, --,
   {{0xcfb1c13b,0x2dc4100a,0x5386d108,0xd2495150}},	//   _कांग्रेस, _באפריל_, _ofert_, _olemas_,
   {{0xa3eb800a,0x8d7a1062,0xe2927166,0xb84c60c3}},	//   _parts_, _মেডিকেল_, _ibrani_, _없었습니다_,
   {{0x4d6b8070,0x42d8502a,0x525c6037,0x95a39027}},	//   _प्रभावी_, _delen_, _località_, _победу_,
   {{0x6387715a,0x4387e043,0x5c7d3230,0x00000000}},	//   _zdarma_, _betri_, _ficsean_, --,
   {{0x5b5a7038,0x044a10d4,0xd349f16f,0x44acd02a}},	//   _mendimin_, _בדצמבר_, _stretli_, _підтверд,
   {{0xe3f84144,0x020a2017,0x434370c3,0xa3fa70ed}},	// [c70] _zemun_, _народзін, _머니투데이_, _kasuan_,
   {{0x240ef030,0x234f403a,0x53f340eb,0x00000000}},	//   _比上年增长_, _zelenih_, _dersleri_, --,
   {{0x6000d245,0x92cae22f,0x86b05341,0xa23e600b}},	//   _informāc, _pandan_, _शक्ती_, _користил,
   {{0x63018058,0xb248023f,0xc29431f0,0xbed9c12b}},	//   _trebate_, _heima_, _zaradili_, _преподав,
   {{0xc068028e,0xa25bf132,0x026c2051,0xcfe7a07b}},	//   _reparado, _kauli_, _bakom_, _привет_,
   {{0xe6cca1a4,0x42d84166,0xf9a68236,0xa2424078}},	//   _polainni, _temen_, _tökélete, _बंगले_,
   {{0xa2d1a1b9,0xc9f5b071,0x193cc027,0x7843300d}},	//   _človek_, _kevés_, _znamenit, _дэлегацы,
   {{0x22d840d7,0x7c683342,0x023bf129,0x05801156}},	//   _remen_, _escrito_, _dueling_, _ануме_,
   {{0x72d8501f,0xd3ab324d,0x9aedf004,0xe7db3343}},	//   _gelen_, _zapadnog_, _deltavie, _zapadnoj_,
   {{0x0228100d,0x69aac073,0x189fa1d2,0xc6e6c15f}},	//   _наступны, _комис_, _rebríčky_, _публикат,
   {{0xc24860bf,0x73947121,0xcbea0033,0x8e96f275}},	//   _veoma_, _bansa_, _encontro_, _मार्क्सव,
   {{0x6200c071,0x5309a261,0xe8672103,0x9c4c3204}},	//   _pedig_, _osobnom_, _михайло_, _наставља_,
   {{0x23657008,0x00000000,0x00000000,0x00000000}},	//   _mergina_, --, --, --,
   {{0xf26ca344,0x984652c3,0xe2e8e1d0,0x0bea00e8}},	//   _libor_, _factures_, _bilinen_, _incontro_,
   {{0x62d84130,0x30abe0dc,0x9ae11187,0x00000000}},	//   _hemel_, _झामुमो_, _arquitet, --,
   {{0xb926c17b,0x12fc7043,0x598701ed,0x9f3a41cf}},	//   _причини_, _gangi_, _markiere, _tecnológ,
   {{0x8ec18019,0xa2fcb002,0x438ff074,0x8263c074}},	// [c80] _bronntan, _chahvad_, _wanyama_, _katoliki_,
   {{0x945e72b7,0xd47261ad,0x04c9c031,0x27e1a01b}},	//   _prievidz, _बढ्ने_, _beruházá, _työpaikk,
   {{0xc2fc714c,0xb2cb11b9,0xa26db302,0xf2a6a0ca}},	//   _bangi_, _kazdy_, _zivota_, _sajber_,
   {{0x53f45051,0x7c9ca0a3,0x7ad3b133,0x42dca06f}},	//   _mitten_, _galeriju_, _正在载入用户签名, _galeriji_,
   {{0x0915e1e0,0xe2fcb002,0xefd0a211,0x27ae4063}},	//   _verbindu, _ghahvad_, _vacibdir_, _مكافحة_,
   {{0x2241908c,0x62926030,0xeeb45016,0x00000000}},	//   _पहुँचल_, _autant_, _recentes_, --,
   {{0x92249127,0x00000000,0x00000000,0x00000000}},	//   _maaka_, --, --, --,
   {{0x9536009a,0x8978605c,0x02c4112a,0x32904048}},	//   _מברסלב_, _amminist, _vendredi_, _alman_,
   {{0x82a632cd,0x5957315d,0x52d8c005,0xafa2f0c3}},	//   _membro_, _episoder_, _keleti_, _상습누범에_,
   {{0x0335a065,0x0b0940cc,0x5a474074,0xbad0307e}},	//   _पंतप्रधा, _comparte, _karemera_, _پردیس_,
   {{0x03eb800a,0x72055074,0x3b84507d,0x00000000}},	//   _party_, _mahitaji_, _transwor, --,
   {{0x42e06181,0x7fd5406c,0x3201126d,0x00000000}},	//   _jednoho_, _ענדגילטי, _bicikl_, --,
   {{0xa300e25b,0xa2f4c03a,0x00000000,0x00000000}},	//   _pegawai_, _napisal_, --, --,
   {{0x13c870a9,0x00cc6062,0x4b083246,0x831750bd}},	//   _visvim_, _সুনীল_, _geografs, _prezes_,
   {{0x726ca005,0x37a3f03b,0x2d021049,0x47c79108}},	//   _tibor_, _チェックリスト_, _declarat_, _समूहों_,
   {{0x8aa691bf,0xb3eaf12c,0xfc51e15f,0x00000000}},	//   _magharib, _qahtan_, _leitura_, --,
   {{0xc2fc7115,0x33204186,0x6b7ff0b1,0x00000000}},	// [c90] _rangi_, _emmys_, _endotrac, --,
   {{0x52d87170,0x6a3c7279,0xed311111,0x0dc4c0b6}},	//   _denen_, _लज्जा_, _الرحیم_, _capitale_,
   {{0x3628006d,0x4aea703f,0xd2d8a024,0xa213b0d1}},	//   _kabineti, _erstelle, _ambek_, _povhwm_,
   {{0xdb69202a,0x4386d12e,0xdd893008,0x00000000}},	//   _profilen_, _agera_, _харчаван, --,
   {{0xbdcaf066,0x235660db,0x126cc0d2,0x00000000}},	//   _मर्यादा_, _arbetar_, _arloqh_, --,
   {{0xb2c1d258,0x6262015f,0x84eb31ba,0x4386d145}},	//   _pillola_, _vestibul, _kriminel_, _fuere_,
   {{0xe2fc7024,0x0facb082,0x627e60d1,0xd94cb16a}},	//   _tangi_, _favorito, _xiong_, _favorite,
   {{0x6f55d00d,0x58278073,0xb3877052,0x87e1a07b}},	//   _дырэктар, _културал, _edaran_, _työpaika,
   {{0x593b9023,0x0396610e,0x00000000,0x00000000}},	//   _asemenea_, _berson_, --, --,
   {{0x329051ee,0x4f4e9052,0xd26cc0f8,0xa346c036}},	//   _allan_, _diasaska, _ondoy_, _randers_,
   {{0x02b49004,0x027f712e,0x93ea818d,0x62d8310a}},	//   _khach_, _nyange_, _viktig_, _remera_,
   {{0xe8e3e005,0x2fe4815d,0x22489023,0x248582b5}},	//   _کاشغر_, _defintio, _seama_, _पारम्परि,
   {{0x000e800b,0xb38691e1,0x727e9163,0x00000000}},	//   _razvijen, _suara_, _enano_, --,
   {{0xc30d2141,0xac47b1a2,0x6abe826a,0x6201825d}},	//   _membawa_, _hunchbac, _provvist, _nazivu_,
   {{0xea1580e7,0xa256507b,0x99fe5345,0x52d8e129}},	//   _automáti, _депутаты_, _curitiba_, _anness_,
   {{0x440f20a0,0xb394d16a,0x66b2f07e,0x00000000}},	//   _fearainn_, _press_, _کمپانی_, --,
   {{0xd0d0912d,0x32fc714c,0x2290d098,0x509b7005}},	// [ca0] _للنساء_, _mangu_, _manase_, _جھڑپیں_,
   {{0xfbed30f9,0xa236908b,0xc2da7019,0x22fc7132}},	//   _rezervir, _tuaja_, _nasedo_, _langu_,
   {{0xaffd9073,0x27f4d025,0xc2ab12ac,0x5f3880dc}},	//   _военкома, _사업계획서_, _pandang_, _दरकिनार_,
   {{0x525ae1d6,0xb270b051,0x02f4a0a4,0x00000000}},	//   _zbilja_, _områden_, _velikoj_, --,
   {{0x17927101,0x00000000,0x00000000,0x00000000}},	//   _автобуси_, --, --, --,
   {{0xe30ed0e9,0xbc7f212b,0x02366064,0x64e3a062}},	//   _paziņoju, _massimo_, _proje_, _মেজাজ_,
   {{0xb70141cb,0x696b4025,0xaf3aa346,0xa94cc069}},	//   _américa_, _groninge, _coordena, _favoriet,
   {{0x226c4347,0xc2b49002,0xf2b5a253,0x00000000}},	//   _samom_, _ghach_, _kupci_, --,
   {{0xe39660f4,0xdc6de100,0xf3e72067,0x7a15e1e0}},	//   _person_, _llorona_, _jätta_, _verbunde,
   {{0x9304f11a,0x5eb1406f,0xe921420f,0x72ab0119}},	//   _whooping_, _držite_, _aktivní_, _laodong_,
   {{0x5200b034,0x5280e00a,0xd356b17d,0x00000000}},	//   _ordine_, _variety_, _obtener_, --,
   {{0x2b0cf1a7,0xf7ac0232,0xe27ed10e,0x9c87d17b}},	//   _proslije, _colectiv, _poeni_, _правни_,
   {{0x7639008e,0x82026008,0xf18521f6,0x8a2d3063}},	//   _besighei, _turite_, _огромен_, _الثدي_,
   {{0x99f66071,0xc58e8063,0x00000000,0x00000000}},	//   _virág_, _ionfhabh, --, --,
   {{0x13ea6019,0x716c3063,0x00000000,0x00000000}},	//   _scoth_, _العكس_, --, --,
   {{0x5d76d07e,0x14335062,0xaa87e067,0x00000000}},	//   _قرآنی_, _লিখিত_, _karistus, --,
   {{0x12fc701e,0x58d39099,0x0c85b0d4,0xa4926062}},	// [cb0] _langt_, _attrativ, _תווים_, _বস্তু_,
   {{0xbaf8622e,0x20bc106f,0xc2ebc206,0x3b8d40e0}},	//   _ierusale, _pošteno_, _mobitel_, _देशमा_,
   {{0x62d871d0,0x100ff005,0x42e88315,0x97b651c2}},	//   _genel_, _ٹوئنٹی_, _treneru_, _forening,
   {{0x22bbf00a,0x5439c272,0x77eb106c,0xcbec6046}},	//   _powered_, _traballo_, _פֿעיִקיי, _underwir,
   {{0x8bb9e025,0x527f405c,0x9a093005,0x66371135}},	//   _스팸블로그로_, _utenti_, _درجنوں_, _होइहें_,
   {{0x0394e118,0x726cc051,0x00000000,0x00000000}},	//   _zaista_, _sidor_, --, --,
   {{0xe27e9119,0xe9de3227,0xd2a69087,0x795d22c2}},	//   _giang_, _contenid, _grabe_, _veilighe,
   {{0x116dc1d9,0xd36c7074,0x1057816e,0x8e19f0a7}},	//   _monitory_, _bungeni_, _tiongkok_, _анумите_,
   {{0x8395408f,0x83958128,0x726c1099,0xd4a59022}},	//   _stesen_, _marse_, _ibhom_, _स्थानान्,
   {{0x29933071,0xf2d8a1a3,0x227e70bb,0xc851401c}},	//   _سپیکر_, _deben_, _finne_, _suportad,
   {{0x1f5f1285,0xa2fc71bf,0x32925074,0xe3f470cd}},	//   _najpozna, _tangu_, _butare_, _vertet_,
   {{0xa38690a3,0xd2bb6038,0x1dfb6038,0x2af5b0c3}},	//   _starp_, _komente_, _komentet_, _플래시게임_,
   {{0x427e708c,0x8f5842c8,0xa37cb348,0x3d61c06c}},	//   _hinne_, _propieda, _strasne_, _מוסולמענ,
   {{0x0a303133,0xd23690a4,0x406940c4,0xa432a062}},	//   _的所有文字_, _traje_, _kampioen, _এডমিন_,
   {{0x02a6c25b,0x8bd8a200,0xbc358062,0x526d9002}},	//   _gambar_, _транснис, _টাইটেল_, _visov_,
   {{0x4356b075,0x0e5f4036,0xb6e0f133,0x3343315f}},	//   _घरेलु_, _この記事へのトラ, _多种方式看新闻_, _откривањ,
   {{0x426c71db,0xa7b7d0dd,0x00000000,0x00000000}},	// [cc0] _danom_, _мажите_, --, --,
   {{0xc271006d,0xadcb4179,0x00000000,0x00000000}},	//   _deputatl, _मुरलीधरन_, --, --,
   {{0x52f9100b,0x0354a0e7,0x13eac1bc,0x03a3f091}},	//   _потребно_, _podemos_, _faltan_, _skupa_,
   {{0xf0edd119,0x884370f5,0xb2e3908e,0x00000000}},	//   _vinarack_, _portalas_, _argiewe_, --,
   {{0x53cec1a7,0xc16a600b,0x98d72012,0x52bb6349}},	//   _olovka_, _дигиталн, _питания_, _comente_,
   {{0x812600d4,0xa2041036,0x00000000,0x00000000}},	//   _ניצחון_, _住所又は居所_, --, --,
   {{0xc6d1118f,0x230320ce,0x43966070,0xfc73226f}},	//   _probleem_, _nunavut_, _persen_, _teorier_,
   {{0x968d80cb,0x6944b1f5,0x00000000,0x00000000}},	//   _परवाह_, _herunder_, --, --,
   {{0x63f470bf,0x00000000,0x00000000,0x00000000}},	//   _postao_, --, --, --,
   {{0xd31691c1,0xd386f00b,0x7202702b,0x4debd25d}},	//   _praze_, _širom_, _serier_, _trajanje_,
   {{0x6b2b706d,0x12da50bd,0x417b706d,0xc3eb003a}},	//   _komandas, _hotele_, _komandal, _platnu_,
   {{0x25ee10d4,0x0395f0a0,0xc2f25089,0xf1f2504c}},	//   _אופציה_, _ortsa_, _ओपेरा_, _planejam,
   {{0xa4864067,0x95d4216e,0x0dfae12b,0x00000000}},	//   _सुधारे_, _membutuh, _осъществ, --,
   {{0x047c01a4,0xa3954177,0xc2a7808f,0xe24af0a7}},	//   _cartlann_, _tresna_, _serbu_, _асигурэр,
   {{0xfe530165,0x137b10b6,0x36470025,0x7496c0c3}},	//   _toplantı, _saranno_, _verklari, _학교정보를_,
   {{0x02927184,0xcaeb815d,0x5ef8306c,0xb7a2e0c3}},	//   _spraoi_, _bestemme, _דערבײַ_, _테마스토리_,
   {{0x2c700070,0x79ed024a,0xfd9d2055,0x876c3059}},	// [cd0] _राष्ट्_, _forespør, _sitename_, _wyjątkow,
   {{0x6313d019,0x1f15f1d9,0x58265292,0x00000000}},	//   _saibhir_, _sledovan, _دارفور_, --,
   {{0xafaec012,0x6ef1a00a,0x15ea900d,0xc2dfe177}},	//   _балки_, _marketin, _абсталяв, _bereziki_,
   {{0xa56a90f9,0x126e207c,0x826d810e,0xbfeb4022}},	//   _prevelik, _varoš_, _sirol_, _विभाजित_,
   {{0x02904064,0xd20271bf,0x4d4710c3,0x4ee4a022}},	//   _almak_, _aprili_, _전문가서비스_, _शिष्टाचा,
   {{0xbceb900a,0x5e7cb067,0x92d46057,0x2ebe103f}},	//   _להניח_, _बाक्स_, _perdre_, _branchen,
   {{0x82d8c03e,0x901a1030,0x1e4c401c,0x58436332}},	//   _leden_, _服务已开通_, _waaaaaaa, _matthias_,
   {{0x64b9315f,0xd2e71056,0x02dbd004,0xab41d0a4}},	//   _просветл, _kuantan_, _sannhac_, _katoličk,
   {{0xf680034a,0x3640714d,0xe2d931c7,0x00000000}},	//   _ऊंचाई_, _skriftli, _klinice_, --,
   {{0xe280b0e0,0xa772c05f,0xb15b70da,0x02ddf099}},	//   _diskuse_, _свега_, _originel, _wowowow_,
   {{0xccdb7067,0xcb8ac0bf,0x52bb6016,0x9c2a50b6}},	//   _उदारीकरण_, _богом_, _somente_, _compless,
   {{0x02484005,0x4fa99062,0x3fb0603e,0x00000000}},	//   _semmi_, _কমিউনিটি_, _prodlouž, --,
   {{0xa3eae32b,0xce2091c4,0x529aa34b,0xc2c51135}},	//   _mantan_, _heimsins_, _loojhej_, _kellele_,
   {{0x8292402c,0x5ee86030,0x1f6ca021,0xd92ba0d4}},	//   _datang_, _城乡规划法_, _detalles_, _לפיכך_,
   {{0xb26c70f8,0x925bf0a3,0x525ae122,0x00000000}},	//   _manok_, _pauls_, _mailan_, --,
   {{0x8e325099,0xf2cae08b,0xf200534c,0x00000000}},	//   _amelikas_, _mendim_, _solid_, --,
   {{0xa2d8c0eb,0x217da06c,0x563ce099,0x89e24061}},	// [ce0] _neden_, _פיגור_, _arianism_, _trafodae,
   {{0x327f51ea,0x85ee323b,0x8867e072,0x1d85b2be}},	//   _vienas_, _landslið, _органаў_, _बायोग्रा,
   {{0x12e56005,0xe2d8713b,0xaea640da,0xc34891e8}},	//   _اعتکاف_, _idnes_, _italiaan, _spreči_,
   {{0xa37de0bf,0x4fdb60c3,0x66e8e049,0xe2d8c064}},	//   _ustaše_, _소비자보호에_, _боабелор_, _beden_,
   {{0x5200922e,0xc3ce52ff,0x454e2204,0x2e0bc035}},	//   _amais_, _silva_, _лична_, _खरोखरच_,
   {{0xe290a10e,0x6032f235,0x3621d067,0xc5a95012}},	//   _alban_, _nastaven, _गांधीगिर, _заработа,
   {{0x9386e16c,0x62009061,0x929270a3,0x8ad2c2da}},	//   _leiria_, _blaid_, _atrast_, _चच्चा_,
   {{0x23f8512a,0xdc24d2ec,0x00000000,0x00000000}},	//   _celui_, _aaaafiir, --, --,
   {{0x3715806c,0xf956a193,0xb31720d4,0x0262d063}},	//   _שושנת_, _escribir_, _planning_, _لائقة_,
   {{0x9e1bc193,0xa9dbc0ba,0x00000000,0x00000000}},	//   _pregunta, _pregunte, --, --,
   {{0x6c7230d4,0xa98470f6,0x12d77119,0x00000000}},	//   _stories_, _mediatie, _autopro_, --,
   {{0x12ee10f9,0xf2f50020,0x7200a046,0x82507071}},	//   _izolacij, _pavisam_, _ambit_, _lélek_,
   {{0xb291c0e4,0x696ca1a4,0x1c7c117e,0x00000000}},	//   _avval_, _eilimint, _poesía_, --,
   {{0xa96c517c,0x700a9024,0x22d8c012,0xb2da6199}},	//   _societat, _خودکار_, _veden_, _sprema_,
   {{0x51cfb0c0,0x5c6160d3,0x84263022,0xb9e0923e}},	//   _semenyih_, _matunda_, _खराबी_, _memorija_,
   {{0x3e72816d,0xec77b302,0x0dd95024,0x5395f01f}},	//   _मूर्ख_, _spasite_, _وبسایت_, _kutsi_,
   {{0xf27f70be,0x5759f34d,0x426da1b1,0x6841f07f}},	// [cf0] _chanje_, _भिक्षुक_, _pipol_, _realkred,
   {{0x96823157,0xf7b5b216,0xd342a019,0x027892c3}},	//   _decembri, _najstari, _inneall_, _suggerim,
   {{0xb3eb8006,0x906cf030,0xcd209063,0xe7709063}},	//   _karty_, _第三十四条_, _الفضاء_, _الفساد_,
   {{0x92d5924d,0xbc433129,0xf6c3a0a1,0x7a03a040}},	//   _osnovao_, _netwerk_, _portalı_, _paralyze,
   {{0x73eb7122,0x8a27e15f,0x9d15117f,0x53f870ed}},	//   _esaten_, _средби_, _nepoznat_, _menua_,
   {{0x5f946055,0xa2250245,0xbd8150d8,0x00000000}},	//   _مخالفان_, _shakti_, _hallotta, --,
   {{0x66db012d,0x42009219,0x3efe717c,0x726c20bd}},	//   _اااااااا, _plaid_, _convenit_, _domowe_,
   {{0xf27f5008,0x0bd3b0ba,0x09263148,0x00000000}},	//   _dienos_, _perjudic, _تعويض_, --,
   {{0xdf690277,0xcb752067,0x83052070,0xd29262ea}},	//   _लाभदायक_, _कार्तिके, _mataram_, _jarang_,
   {{0xe2d8c18f,0x62fce0c0,0x22fc701f,0x185d917c}},	//   _reden_, _mangga_, _hangi_, _минерале_,
   {{0x5fc3916a,0x6dd6e012,0xb4d5d070,0xd26cc0e9}},	//   _register_, _perjanta, _द्विधा_, _valoda_,
   {{0x3248001d,0xe2fce0cd,0x00000000,0x00000000}},	//   _heimi_, _mungon_, --, --,
   {{0x72fc714c,0x43fec140,0xe29050c1,0xd86c61bd}},	//   _mangi_, _kwalifik, _allai_, _sociedad,
   {{0x62fc714c,0x22fce159,0xd6816030,0x82ce9071}},	//   _langi_, _origen_, _calendri, _eltérő_,
   {{0x06ab823e,0x1f128020,0x83be8197,0xd2026121}},	//   _položaj_, _organizā, _slaveni_, _haring_,
   {{0x52926055,0x220271e2,0x7c5371b6,0x00000000}},	//   _barang_, _masing_, _sastava_, --,
   {{0x93f8f08b,0x1202701c,0x00000000,0x00000000}},	// [d00] _punuar_, _lasing_, --, --,
   {{0xc3f470d0,0xfd2c9223,0x126c91c0,0x616c91c1}},	//   _partai_, _aktivite_, _aktiviti_, _aktivity_,
   {{0xd2cf91b9,0x42c4a0d4,0x127ed0d1,0x00000000}},	//   _kancelár, _england_, _xieng_, --,
   {{0xf34aa07e,0x6246d020,0x7225f0bd,0x5fb3d17c}},	//   _طرفدار_, _tēmas_, _druku_, _антилеӂи,
   {{0xb2907076,0xe3966161,0x92fe61ed,0xad6bb34e}},	//   _ponad_, _versin_, _sorgen_, _प्रभुजी_,
   {{0x127e0010,0x22a64055,0x020270bc,0x4314206c}},	//   _diini_, _tumbu_, _kasing_, _באזוכער_,
   {{0x963e513f,0x00000000,0x00000000,0x00000000}},	//   _juridini, --, --, --,
   {{0xe386916a,0xac74d34f,0x227351d0,0x626a71b9}},	//   _start_, _minutos_, _künye_, _detailné_,
   {{0xb200d08e,0xb27e7067,0xa291e11b,0xc201f0d9}},	//   _klein_, _sinna_, _avtal_, _egzije_,
   {{0xe2fce27c,0x3329402a,0xf3f470c1,0xc542616b}},	//   _krigen_, _запропон, _ofsted_, _здавальн,
   {{0xc202601c,0xe2c50093,0xa7da9094,0x72ab104e}},	//   _waring_, _kollege_, _महाकुंभ_, _kandang_,
   {{0xc354a306,0xdef63060,0x22d84068,0x32cae061}},	//   _modelos_, _загреб_, _temel_, _ganddo_,
   {{0x32a7827d,0x0b7aa120,0xe29151dc,0xfe2610d4}},	//   _verby_, _uğrunda_, _legata_, _משפחתית_,
   {{0xd27ed0b8,0x026c300a,0x29af90d4,0x83f47135}},	//   _tieng_, _major_, _ממשלה_, _testid_,
   {{0x8e5641af,0x775ad070,0x23869047,0x72ec7035}},	//   _balbesit_, _transmig, _juara_, _नितीन_,
   {{0x34fba070,0x329260f8,0x25a0208d,0x43eb71a7}},	//   _ग्राहक_, _parang_, _সাফল্য_, _slatke_,
   {{0xaf7ab03e,0xa2d77032,0x8b8871ed,0x00000000}},	// [d10] _upozorně, _publics_, _politisc, --,
   {{0x9386d175,0x6ee4c070,0x972c2346,0x943ec072}},	//   _ngeri_, _विज्ञाना, _responsá, _ганна_,
   {{0xc25b406a,0x52db9049,0x129270f9,0x1eb080d9}},	//   _quello_, _контакту, _strahu_, _konesans_,
   {{0x72925131,0x326de0d9,0xa9fc60ed,0x00000000}},	//   _ostaig_, _ditou_, _oarsoald, --,
   {{0xd39581d0,0x9386d1bd,0x510a8012,0x2d185086}},	//   _varsa_, _quero_, _означает_, _fúnebres_,
   {{0x93f47293,0xd8f880d0,0xf2fe40e7,0xcf57410a}},	//   _postel_, _gregoriu, _motivos_, _damascen,
   {{0x5f1161f3,0x8c1790d4,0x22a60167,0x00000000}},	//   _kontakta, _מגניב_, _gribu_, --,
   {{0xc3a8a312,0x4c55b025,0x00000000,0x00000000}},	//   _sekarang_, _afstand_, --, --,
   {{0x753a900e,0x3eb04055,0xfd0270ba,0xa290e170}},	//   _agentliy, _البلاغه_, _qualitat_, _hinaus_,
   {{0xe2f04336,0x5290c0ab,0xd349e136,0xe23672ec}},	//   _poliisi_, _tematy_, _diretti_, _munju_,
   {{0x831691eb,0xc25a1184,0x00000000,0x00000000}},	//   _arazo_, _umhla_, --, --,
   {{0x707bc22b,0xf83e5063,0xbf71f0e2,0xa26a7022}},	//   _सट्टेबाज, _القحطاني_, _perancis_, _detailní_,
   {{0xee706028,0x22fc311c,0xadf7c00b,0x4de63063}},	//   _पुनर्वास_, _ualicas_, _филмова_, _أعلنت_,
   {{0x23ead184,0x32927055,0xeb31907e,0xb2da700a}},	//   _contae_, _pasang_, _سمینار_, _myself_,
   {{0x3ed12160,0x00000000,0x00000000,0x00000000}},	//   _निकटका_, --, --, --,
   {{0x527f5062,0x74774025,0x1c559119,0x8e9742c7}},	//   _tienes_, _systemen_, _wattpad_, _systemet_,
   {{0x4b0cc03b,0xe7d0c070,0x281dc00d,0xe27e607d}},	// [d20] _友達に紹介_, _lingkung, _дакладна_, _anons_,
   {{0x90b8506f,0xceee00dd,0x4f90c095,0x00000000}},	//   _filmskih_, _компании, _رنگين_, --,
   {{0x226c5009,0xf770300b,0x23958186,0x00000000}},	//   _malos_, _prikaziv, _marso_, --,
   {{0xe2e3d220,0x5aef7339,0x22d85059,0x14606059}},	//   _lehrbuch_, _simonsen_, _celem_, _teledysk,
   {{0xa2cae170,0x27937135,0x5e643086,0x72b592c3}},	//   _findet_, _kultuuri, _públicam, _tasca_,
   {{0x1290409b,0xdb027061,0x37e550d6,0x423d7012}},	//   _almal_, _lawrlwyt, _samstarf, _продукты_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x90c7603b,0xd26c50f8,0xbb0f3315,0x4ff74089}},	//   _一覧を見る_, _halos_, _ekspluat, _महिंद्रा_,
   {{0xb3f450ac,0x99e22215,0xb26c41a9,0x5c7e1042}},	//   _sitten_, _جاويد_, _vamos_, _marsvin_,
   {{0x5ce3a067,0xeed74059,0x00000000,0x00000000}},	//   _प्रोफेसर, _delikatn, --, --,
   {{0x53f850e2,0xd394e305,0x627ef163,0x9aec0122}},	//   _belum_, _ceiste_, _grinch_, _kolektib,
   {{0xc2fe61aa,0x7379617e,0x73169033,0x069d30c3}},	//   _visitas_, _batalla_, _prazo_, _해피선데이_,
   {{0xfda740c0,0x52d85071,0x6ae7f0d2,0x00000000}},	//   _kelihata, _velem_, _aperfect, --,
   {{0x5323410e,0x02fcb0db,0x00000000,0x00000000}},	//   _mercher_, _skrivit_, --, --,
   {{0xd6e7b072,0xd2cb40bf,0x00000000,0x00000000}},	//   _вытворча, _predao_, --, --,
   {{0xffdfb00a,0x04d9a005,0x9da74136,0x00000000}},	//   _מצאתי_, _سرینگر_, _illimita, --,
   {{0xec09b181,0x0a15508f,0x12d84064,0x538af0a0}},	// [d30] _podpora_, _maharaja_, _demek_, _fòram_,
   {{0xf2926081,0x3942b17d,0x93207064,0xff45a062}},	//   _strane_, _ঘোষনা_, _konya_, _জনগনের_,
   {{0xe387e0a7,0x6fd1606c,0x00000000,0x00000000}},	//   _petru_, _זארקאווי_, --, --,
   {{0x86b122a3,0x211b507e,0x7200707b,0xcaea701f}},	//   _डकैती_, _سرپرست_, _monia_, _destekle,
   {{0x7394621e,0xf2e3e144,0x3c33e0ca,0xbb5930b2}},	//   _byose_, _šangaj_, _šangaju_, _iskustva_,
   {{0xfc756124,0x396cd01b,0x52d4601f,0x5ea351a6}},	//   _samstag_, _начинает_, _birden_, _bretagne_,
   {{0x52904199,0x90003005,0x9ecdd0cd,0x00000000}},	//   _komad_, _سراہا_, _municion, --,
   {{0x9150a2fa,0xcfcdc063,0x77b0a2fa,0x4395f124}},	//   _podstawo, _الرعب_, _podstawi, _hause_,
   {{0xf2d8516f,0x52fd7345,0x226e523e,0xef6ea125}},	//   _celej_, _imagem_, _gotovo_, _niềng_,
   {{0x8387f2a6,0xce74106c,0xe1e7e0a7,0x22ef70cd}},	//   _leurs_, _חנוכּה_, _елементе, _biznesi_,
   {{0x2e4c416c,0x030c21fb,0xbc70d350,0xa386021a}},	//   _haaaaaaa, _humanos_, _हेक्टर_, _daire_,
   {{0x2ae470dd,0x83f471d2,0x1378e126,0xd3a8d16e}},	//   _акционер, _dostal_, _gelaran_, _semarang_,
   {{0xc3860032,0x437b10a4,0xf2d84031,0x7c74a133}},	//   _faire_, _naravno_, _remek_, _查看评论信息_,
   {{0xb2e7c01b,0x00000000,0x00000000,0x00000000}},	//   _разное_, --, --, --,
   {{0x5dd9c292,0x00000000,0x00000000,0x00000000}},	//   _اتباع_, --, --, --,
   {{0xa248d063,0x03878038,0x42559035,0xf386d196}},	//   _seomra_, _kurre_, _संमेलन_, _ngero_,
   {{0x7f6ea044,0x3b196052,0x8c068181,0xc90390c5}},	// [d40] _giềng_, _letakkan_, _dopravy_, _herauszu,
   {{0x2476d0bb,0xe90ea035,0x0d60b0d4,0x9c1d00c9}},	//   _идент_, _hemagglu, _האלבומים_, _pristojb,
   {{0x05fcc049,0x62f201b9,0x03eb8186,0xdc7e011e}},	//   _контакте, _nasleduj, _payton_, _faustin_,
   {{0x77a61004,0x137c60e7,0xdb84118a,0xeb22609c}},	//   _vietgiai, _alcalde_, _опрос_, _gruppele,
   {{0x71773072,0xbee2e070,0x6e07522e,0x1394e24b}},	//   _белта_, _निर्देशा, _meadhana, _minska_,
   {{0x02f7616e,0x4485c041,0xc26c8175,0x5291a10a}},	//   _menikah_, _सुहानी_, _makoma_, _nepad_,
   {{0xb2d410b8,0x326c70de,0x7743d012,0x00000000}},	//   _decolua_, _manos_, _новинки_, --,
   {{0x227e718d,0x00000000,0x00000000,0x00000000}},	//   _vinne_, --, --, --,
   {{0xd21ac15f,0x129800d4,0x227e912b,0x385dd060}},	//   _вториот_, _הגירסה_, _siano_, _издање_,
   {{0xd171e03a,0x52fc418b,0x2994106c,0xf248d132}},	//   _aktivnih_, _kuching_, _אריזאנע_, _neema_,
   {{0xd30ca0f2,0xe33c4025,0x9df000d4,0xf386908b}},	//   _madalas_, _사람들에게_, _הצלחתי_, _duart_,
   {{0x3f4b5040,0x82d8d01e,0x5038e083,0xdf162133}},	//   _computra, _ideer_, _centraln, _买卖通档案_,
   {{0x42ee6219,0x44d570e6,0x6c96b133,0x2fde600a}},	//   _economi_, _स्थिती_, _重要思想为指导_, _economic_,
   {{0x13ea9116,0xffd95261,0xad76307e,0x675a911e}},	//   _imate_, _dostatoč, _هرچند_, _igenamig,
   {{0x5e62d1a3,0x7dd2d1ab,0x32259186,0x00000000}},	//   _descarga, _deskarga, _pasko_, --,
   {{0xd75aa1f9,0x35fa7030,0x92e711ed,0xeb693005}},	//   _правител, _劳动和社会保障部_, _spanien_, _سرگودھا_,
   {{0x3af360cc,0x42f62173,0x82da70d4,0x0942a005}},	// [d50] _consulte, _briseadh_, _direct_, _بحیثیت_,
   {{0x027f52a5,0xb3a4100a,0xa2b4e09b,0xf28410d4}},	//   _dienas_, _הניהול_, _mincha_, _הניקוד_,
   {{0x7cc17063,0x69a69030,0x72005030,0x62ad3049}},	//   _اليدوية_, _尊重网上道德_, _jolie_, _сигур_,
   {{0xbf69b144,0xe27e70c7,0xb3f8f306,0xe41a70a7}},	//   _nezavisn, _rinne_, _segue_, _брумэрел,
   {{0x2d84a00a,0x02f45167,0xedf7d17a,0xd8f34063}},	//   _internet_, _jaunais_, _назвали_, _بمحافظة_,
   {{0x5a07410a,0xa200502d,0x52485191,0xea5d212d}},	//   _somaliya_, _illik_, _helmi_, _tapúla_,
   {{0x82bbd130,0x320ec00d,0x2c6e112d,0x00000000}},	//   _geheime_, _хапае_, _buartha_, --,
   {{0xc85c100a,0xe91b0044,0x66d390d4,0xd2901002}},	//   _ההזמנה_, _loại_, _אטיאס_, _tlhaw_,
   {{0x27fea030,0xb2c4a270,0x4c18e211,0xc348e14b}},	//   _的所有作品_, _normalt_, _xarakter, _ingenzi_,
   {{0xcbb471b9,0xaf589103,0x21b3115e,0xcccc6040}},	//   _reagovať_, _проголос, _похоже_, _trivandr,
   {{0x71fa303b,0x5f640054,0x62678008,0x43f96038}},	//   _詳細はこちら_, _belastin, _nemokami_, _sigurt_,
   {{0xe2e881c1,0x4e6690e0,0x2c6102ea,0x00000000}},	//   _podniku_, _यसैगरी_, _berusia_, --,
   {{0x23a3406b,0xd366a02c,0xe382407e,0x9876b01c}},	//   _drepte_, _tunggal_, _شیعیان_, _indibidu,
   {{0x7b3010dd,0xdb9be0e0,0xaec93304,0x129ec063}},	//   _петок_, _मुलुकमा_, _फाउंडेशन_, _ومحمد_,
   {{0x6fb84087,0x72b581a6,0xbb2dc1e1,0xc378e2ac}},	//   _eclectic_, _parce_, _tambahan_, _delapan_,
   {{0x26a15119,0x0eb450a3,0xdd087070,0xe0345031}},	//   _tintheth, _receptes_, _शास्त्रज, _receptek_,
   {{0x0386b073,0xd290b1fd,0x2af4c2c2,0xe0f9902b}},	// [d60] _andrei_, _izdaje_, _hieronde, _земель_,
   {{0x52f7417d,0xa354a00a,0xe38691ab,0x6d82007e}},	//   _কখনোই_, _effects_, _ugari_, _realesta,
   {{0xc39462eb,0x726da22c,0x02a83055,0xef18a061}},	//   _phost_, _lipos_, _متوقف_, _cyfwelia,
   {{0x334fd0bf,0xc5a20041,0xf290321c,0x00000000}},	//   _poredak_, _पालतू_, _nemali_, --,
   {{0xcac0300b,0x43227186,0xd84a3156,0xf3f45106}},	//   _обично_, _aksyon_, _актуалэ_, _sittin_,
   {{0xf236921c,0xdf6ea044,0x8c0b106b,0x504a5241}},	//   _kraja_, _kiểng_, _knappen_, _subraman,
   {{0x92fc90fd,0xb2cae184,0x127f0043,0x00000000}},	//   _mbaga_, _maidin_, _standi_, --,
   {{0x82ef0083,0x65ba3166,0xc2f9e0b7,0x0aaf30c3}},	//   _grafik_, _معامله_, _njihova_, _정상적으로_,
   {{0xb074707a,0xe2fc6190,0x74b26066,0xc27860a3}},	//   _redaktio, _mbogo_, _नायडू_, _jaunie_,
   {{0x527e910a,0x3f277041,0x00000000,0x00000000}},	//   _inani_, _सरबजीत_, --, --,
   {{0xb2259067,0xd395927d,0x5b759072,0x126cc034}},	//   _raske_, _rasse_, _членаў_, _colore_,
   {{0xb20050a4,0x1840d019,0x929050b8,0x440040dc}},	//   _volim_, _بخصوص_, _volam_, _मापदंड_,
   {{0x13b0a055,0x92259223,0x32a6901f,0xf95f1005}},	//   _القاعده_, _paske_, _araba_, _پیشکش_,
   {{0x666720dd,0x62bf0031,0x32805059,0x00000000}},	//   _начинот_, _اموات_, _brakuje_, --,
   {{0x39e511e3,0x02c942e1,0x4e394243,0xa5ee20e7}},	//   _gedurend, _esporte_, _esportes_, _condició,
   {{0xc7e7e231,0x7249423a,0x120020d6,0xc912e080}},	//   _सिगरेट_, _gudmor_, _lokin_, _етапі_,
   {{0xf047215f,0x1307628c,0x00000000,0x00000000}},	// [d70] _народот_, _tembang_, --, --,
   {{0xc3954157,0x42fcc150,0x5d0ea051,0x00000000}},	//   _miesto_, _blogid_, _otroligt_, --,
   {{0x686450e8,0x4f1c109a,0xf3f47146,0xe8d96025}},	//   _универси, _שפיטאל_, _listan_, _해외부동산_,
   {{0x226d91ca,0x727ee02e,0xc2d8f229,0x9316d0e7}},	//   _visos_, _toinen_, _legea_, _prezo_,
   {{0x427e7067,0xad051077,0xe9f4f20b,0xa2b1f01d}},	//   _linna_, _destrucc, _goiás_, _myndina_,
   {{0xdeab911b,0x7198800a,0x7f3210d4,0xe5187029}},	//   _rekommen, _probably_, _בחולון_, _картинка,
   {{0x0201c16c,0xacbec029,0xe528e13b,0xf249518d}},	//   _devid_, _важен_, _कोषाध्यक, _kremer_,
   {{0x4dbe1004,0x8e32716e,0x00000000,0x00000000}},	//   _hdvietna, _kualitas_, --, --,
   {{0xd3a2a16f,0xb27e00b1,0x629160bd,0x0200934c}},	//   _najprv_, _niini_, _म्यांमार_, _claim_,
   {{0x51ef801e,0x43b3d1c8,0x32a600be,0x9426c350}},	//   _egyptisk_, _अनियंत्र, _tribi_, _गरिबी_,
   {{0x2332f0ba,0xf42ef073,0xb2c5506d,0xd791507f}},	//   _deixar_, _епископи, _qədim_, _produktg,
   {{0xf26da1cb,0x969561bd,0xe62d8019,0x934560a5}},	//   _tipos_, _especiai, _sainchei, _especie_,
   {{0x927ee0b0,0x4a59800d,0x731110a7,0x6343218a}},	//   _sonnen_, _nereikia_, _абсолв_, _хорошая_,
   {{0x43f47022,0x00000000,0x00000000,0x00000000}},	//   _kostel_, --, --, --,
   {{0x0bed3012,0x1322706c,0x00fda300,0x9e41e136}},	//   _министры_, _רעזולטאַ, _पेटवा_, _garantit_,
   {{0x14310055,0x92efc23d,0xe2005022,0xeaed7133}},	//   _العاده_, _familja_, _kolik_, _sexualit,
   {{0xdb94200a,0x4254d0f7,0x970d80c3,0x72b47163}},	// [d80] _סטודיו_, _ट्रेंड_, _이용자에게_, _synch_,
   {{0x92cae1af,0x53ab0144,0x026c8129,0x92369081}},	//   _sonder_, _ustavnog_, _iskola_, _traja_,
   {{0xd48651e9,0xa3b26030,0xc2fcd012,0xd31770e2}},	//   _सोनाली_, _marque_, _blogit_, _penyanyi_,
   {{0xcc01c04b,0x7102d060,0x00000000,0x00000000}},	//   _laisser_, _књизи_, --, --,
   {{0x320270f0,0x83ac1031,0x930751ed,0x81e1407e}},	//   _assise_, _éppen_, _hamburg_, _مجازات_,
   {{0x3696712a,0xf5628025,0x13792055,0x00000000}},	//   _accessoi, _때문입니다_, _lebaran_, --,
   {{0xf06a0002,0xd25581b9,0x63ea00fd,0x00000000}},	//   _phrasebo, _problémo, _emiti_, --,
   {{0xa386d0b6,0x66fc7041,0xc21cd017,0x7e6cc0dd}},	//   _storia_, _अतिथियों_, _выезд_, _приштина_,
   {{0xcc5c517d,0xf75e50fc,0xceb0a1cb,0x93ee0034}},	//   _তীব্র_, _काश्मीर_, _diversas_, _dettagli_,
   {{0xf2def16f,0x52d82093,0x00000000,0x00000000}},	//   _motorov_, _beker_, --, --,
   {{0xbfa171d0,0x7c1410f3,0xb3436284,0xb3f36284}},	//   _aksesuar_, _segurtas, _izvesno_, _izvesnog_,
   {{0xc20ce071,0x52d8c1ed,0xa7167036,0x727ed072}},	//   _زیراہتما, _jedem_, _固定リンク_, _vieno_,
   {{0x23ead019,0x2248d069,0x5e7fe0e9,0x00000000}},	//   _moltar_, _neemt_, _psiholoģ, --,
   {{0x9a063030,0xad85332d,0xf39592df,0xee4721cb}},	//   _下一篇文章_, _इन्कार_, _fussy_, _localida,
   {{0x57fd1234,0x6a70317c,0xc95032a1,0x7c5bf071}},	//   _اتحادي_, _negociab, _negociat, _tartani_,
   {{0x63f4000b,0x298ec0a7,0x5d12c17a,0xaa0d6117}},	//   _sastav_, _паник_, _зовсім_, _labadaba_,
   {{0x62d8209b,0x327e71c4,0x00000000,0x00000000}},	// [d90] _seker_, _sinni_, --, --,
   {{0x127ed072,0xf9aa108f,0x3a343036,0xbe4c7277}},	//   _pieno_, _mendakwa_, _ミッション_, _गैरकानून,
   {{0x024900c1,0x129040d9,0x3a2a0036,0x721e0115}},	//   _dramor_, _moman_, _イタリアン_, _shukrani_,
   {{0x34652129,0xff3a21d0,0xab03f025,0xc2fce0ba}},	//   _referenz, _profilin, _일반적으로_, _mengem_,
   {{0xd290a234,0x9863c029,0x79e3c0dd,0x1045210b}},	//   _albam_, _покажи_, _покажа_, _estudian,
   {{0x9c343071,0x12909130,0x45f2000a,0x2f927051}},	//   _آرڈیننس_, _plaas_, _permissi, _ungdomar_,
   {{0x426db01f,0xd386022e,0x4c5fc0da,0x4f73517e}},	//   _favori_, _nairn_, _systeem_, _proceden,
   {{0xa49a115d,0x1f8180e0,0x6ef7e060,0xe3874288}},	//   _israelsk, _सबैको_, _презиме_, _puerta_,
   {{0x12004043,0xebf41173,0x12843227,0x5ef43227}},	//   _komin_, _weathers, _archivo_, _archivos_,
   {{0x1e70f022,0x72d98170,0x1055c020,0xf6c41036}},	//   _चित्त_, _deren_, _sagatavo, _おすすめ度_,
   {{0x5e563243,0xe26d821d,0x5b27d155,0xb195c0f5}},	//   _настани_, _paroi_, _nawbbbbb, _членам_,
   {{0x284b003b,0x00000000,0x00000000,0x00000000}},	//   _sommerhu, --, --, --,
   {{0x32497169,0xe490a024,0x6e59a1f6,0xd58771c1}},	//   _ijambo_, _دیکشنری_, _седница_, _autorský,
   {{0x82d8407d,0x29898034,0xb57ed31f,0xbd174009}},	//   _remet_, _коалиция_, _població, _anglahbe_,
   {{0x4589e223,0x3d3c3300,0x2c5c3153,0xff39e03e}},	//   _televizy, _फ्रॉम_, _फ्रेम_, _televizn,
   {{0x52d98022,0xf30c2130,0xe13152de,0xe26ce017}},	//   _beren_, _onlangs_, _contacto, _manoma_,
   {{0xf2d990ee,0x824991e8,0xbebcf1a4,0x46e7d00b}},	// [da0] _lesen_, _pesma_, _chosaint_, _разлога_,
   {{0xd27ed034,0x920040f6,0x82e30112,0xa2d84145}},	//   _viene_, _comin_, _delivre_, _femer_,
   {{0x27c370d4,0xf3c5e005,0x92d840cc,0xb2d84226}},	//   _בינלאומי_, _مایوسی_, _temes_, _gemer_,
   {{0xb27ed17d,0xcc00b099,0xa5f12063,0xf27ed009}},	//   _tiene_, _ameskas_, _الشؤون_, _amonmo_,
   {{0x9babc041,0x236c006c,0xb394f31e,0x00000000}},	//   _हसाँउने_, _כּאילו_, _aviser_, --,
   {{0x33f84043,0xf2d840e9,0xe04b5223,0xe8fce151}},	//   _kemur_, _zemes_, _reprezan, _makamand,
   {{0x917fe024,0x026e71b6,0xe0e8f014,0x71415062}},	//   _روشهای_, _parovi_, _oprindel, _দিয়েছে_,
   {{0xbfe96277,0x80f40302,0x2b957120,0x00000000}},	//   _चापागाई_, _pomislil, _sevindir, --,
   {{0x9200c054,0xb290d228,0x4c64a099,0x72574135}},	//   _nodig_, _solais_, _vasthiv_, _austraal,
   {{0x8c18e0b6,0xe2d8c239,0xb2fd1057,0x68d7534a}},	//   _caratter, _sedem_, _caminar_, _समुचित_,
   {{0x12027073,0x92d8525f,0x83f8c261,0x00000000}},	//   _serios_, _deles_, _palube_, --,
   {{0x298a8211,0x4ec2e156,0xac671149,0xb29042b2}},	//   _müraciət_, _антистат, _seiring_, _woman_,
   {{0x7c17d080,0xb3402083,0xd68b2122,0x22d85064}},	//   _правил_, _licenca_, _lizentzi, _neler_,
   {{0x72d981a6,0xee351021,0x0c5360dc,0xbb2dc0a2}},	//   _prendre_, _millones_, _मैसेज_, _cambrian_,
   {{0x9687e008,0x03498129,0xbecf0044,0xd290201f}},	//   _заявіў_, _esperti_, _cuộc_, _tokat_,
   {{0x62cad24a,0x9a8fc047,0x626c30d4,0x921990a6}},	//   _mindre_, _demikian_, _almost_, _vinnumál,
   {{0x423670be,0x99e93015,0x52cae02b,0x936b60f1}},	// [db0] _manje_, _mainidea_, _bindet_, _kortnumm,
   {{0x98e2c00b,0x0c53b2ef,0x95369018,0x97310005}},	//   _могуће_, _सामेल_, _चर्बी_, _کھوسہ_,
   {{0x4f91909c,0xb2a6d0ed,0x00000000,0x00000000}},	//   _klimapro, _greba_, --, --,
   {{0xadb71111,0x4bd8e024,0x7af3c1a5,0x5273c185}},	//   _بهرحال_, _تحلیل_, _napravit, _napravil,
   {{0xcafc61c2,0xdddc3063,0x926e711e,0x00000000}},	//   _undervis, _الضوء_, _karoti_, --,
   {{0xf166712b,0x4a88101b,0xe15130a7,0x479270c3}},	//   _футболис, _основном_, _стяуа_, _개인예약대기_,
   {{0x6c09c0fd,0xb2eb51ce,0x53dcb006,0x650550dd}},	//   _kampala_, _enviado_, _kosmetyk, _enquanto_,
   {{0x13ead023,0x826de017,0xfb2f8073,0x42fd80a6}},	//   _dintre_, _kitos_, _историче_, _margt_,
   {{0x92a67002,0xe0611150,0x507da103,0xb23670be}},	//   _danbe_, _ऑफिसर_, _спектр_, _danje_,
   {{0x5a93c15f,0x72a69095,0x683b7062,0x714400b1}},	//   _можеби_, _prabu_, _মৈথুনানন, _letterbo,
   {{0xb248925c,0x3d86719b,0xd344b14b,0x89668036}},	//   _utama_, _तस्करी_, _murenge_, _注文した商品はど,
   {{0xd26c3148,0x00000000,0x00000000,0x00000000}},	//   _samoan_, --, --, --,
   {{0x4292606f,0x8c77a03f,0x5bdd917d,0x140f8133}},	//   _zdrava_, _versand_, _ব্যথা_, _转贴或以其他方式,
   {{0x62a63151,0xe0db10e0,0x22d8d1d3,0xf2d8b01f}},	//   _cumbia_, _केसीले_, _idiomas_, _recep_,
   {{0x6349807d,0xae41602a,0x00000000,0x00000000}},	//   _prefere_, _relativt_, --, --,
   {{0x027ec15c,0x16e8b00b,0x92905258,0x153950dd}},	//   _midna_, _карактер, _allat_, _estadual_,
   {{0x43eb706f,0x84d7709a,0x011091c1,0x9da1e024}},	// [dc0] _kratko_, _ענציקלאפ, _techniky_, _شیمیایی_,
   {{0x42d870e9,0xcb822037,0x031d70c0,0x62ee90c0}},	//   _nenes_, _късно_, _percuma_, _chaff_,
   {{0x0da2b087,0xc290528d,0x5c57b062,0x927ef14a}},	//   _terraced_, _ellas_, _কুঙ্গ_, _aigne_,
   {{0x56f04067,0xc3f85043,0x00000000,0x00000000}},	//   _प्रवीण_, _telur_, --, --,
   {{0x4a2b1039,0xa249825f,0xc9fb6031,0xd241c063}},	//   _ورکشاپ_, _termo_, _ellentét, _أنشطة_,
   {{0xe973a16e,0x12b2e0e5,0xd386019e,0x00000000}},	//   _arsitekt, _atodlen_, _gaire_, --,
   {{0xf3a202dc,0x5615e177,0x00000000,0x00000000}},	//   _ndipo_, _balorazi, --, --,
   {{0x946e2030,0xf122d0b7,0xe26ce006,0xd1fe4157}},	//   _国家税务总局关于, _privatno, _wynosi_, _publikác,
   {{0xccfff1d8,0x023f7071,0x8200508b,0x09c6b345}},	//   _regulier, _kalkulát, _rolin_, _paulista_,
   {{0x227e918e,0xe2f3c0ee,0x4d525024,0xe3f851c4}},	//   _khang_, _falsafah_, _همانند_, _velur_,
   {{0x62d9f0c4,0x7c4811c8,0x7ebdf1d9,0x8af9f054}},	//   _dienste_, _अधिनियम_, _stanoven, _diensten_,
   {{0xb200b1cc,0x3c60015f,0x4c9162d6,0xd29790d4}},	//   _jedini_, _известув, _didukung_, _התקנת_,
   {{0x72fcc0c3,0x2f026075,0x31e9b054,0xeb3c61df}},	//   _hoogte_, _गोरखा_, _assortim, _arabinos,
   {{0xa118f030,0xd20051b7,0x6c89b014,0x5e721070}},	//   _您的汇款已收到_, _volio_, _samtidig_, _वृद्ध_,
   {{0x1642f03b,0xe0944030,0xef8f61c6,0x029070d6}},	//   _最近の記事一覧_, _互联网上网服务营, _alimento, _konan_,
   {{0xc386d00a,0xf2974024,0x42d9602c,0x20b59108}},	//   _sports_, _یادداشت_, _segera_, _मारुति_,
   {{0xe6eb0055,0x10e0c02e,0xcd692038,0xfb77a01b}},	// [dd0] _اعلاميه_, _снова_, _kulturë_, _органы_,
   {{0x631d906c,0x2fc2c005,0xa394e19e,0xed8c7240}},	//   _פינחס_, _لاشوں_, _consum_, _mačka_,
   {{0x377c500d,0x99d070ed,0xd2f04098,0xc58070f8}},	//   _кантакты_, _telebist, _malinzi_, _telebisy,
   {{0x220050b7,0xdcd930d1,0xa7bbe0dd,0xfcf1b035}},	//   _molim_, _haivneeg_, _останати, _प्रकटन_,
   {{0x346521df,0x02a64010,0x09c5216a,0x83076055}},	//   _internaz, _pamba_, _internat, _kembang_,
   {{0x727ed245,0x7290501d,0x92005043,0x127b4226}},	//   _diena_, _allar_, _allir_, _komentár,
   {{0x728701a7,0x41fe110f,0x8e92300b,0x3ece1030}},	//   _blokove_, _environm, _потребе_, _environn,
   {{0xd2786132,0x70be107b,0xeef040d1,0xe2bb026d}},	//   _mbunge_, _программ_, _khuxabna, _pametne_,
   {{0xc2d87086,0x4a1470fd,0x703b50a0,0x9378a141}},	//   _gener_, _okwagala_, _congleto, _tekanan_,
   {{0x1331b1f3,0x8478700d,0xee2c81d5,0xbfcc3005}},	//   _diskusij, _наступна, _pengemba, _کلنٹن_,
   {{0x72eaa228,0xf2fcd132,0xc51ff0ce,0x00000000}},	//   _daniell_, _mbegu_, _angnisch, --,
   {{0xd394e0f2,0xd3ff205f,0xd9623034,0x00000000}},	//   _minsan_, _planinsk, _постове_, --,
   {{0xb7501070,0x7add8042,0xfbf38252,0x49c3800a}},	//   _भ्रष्ट_, _допустим, _celebrac, _celebrat,
   {{0xb2599309,0xf20041ed,0x7329e064,0xb74da062}},	//   _वाशिंगटन_, _somit_, _psikoloj, _থাইল্যান,
   {{0x927b413e,0xf2926177,0xae8c1036,0xd2d85109}},	//   _comentár, _estatu_, _ウェブ検索_, _celex_,
   {{0xd2caf351,0xfd55706d,0x36951321,0x92d8814c}},	//   _pridal_, _şəhid_, _oddeleni, _makeke_,
   {{0x8759d0bf,0xf320610a,0xbd15302b,0x3d912332}},	// [de0] _капаците, _aloys_, _футболу_, _fotoappa,
   {{0xd2a66091,0x2d093012,0x4f350072,0x00000000}},	//   _osobe_, _конце_, _становіц, --,
   {{0xfae300f7,0xd897112d,0xb4882108,0x7c026130}},	//   _postimee, _قريبا_, _gwarancj, _aussies_,
   {{0x0055c0da,0x5ce840bf,0x72d870d7,0xef65b093}},	//   _verantwo, _prosječn, _bener_, _geraldin,
   {{0x0344a045,0x00000000,0x00000000,0x00000000}},	//   _attende_, --, --, --,
   {{0x79e6f012,0x1f26f012,0xe8a10063,0x1c00305d}},	//   _harrastu, _harrasta, _الدستور_, _uhagarar,
   {{0xc2cae24b,0x00000000,0x00000000,0x00000000}},	//   _fonder_, --, --, --,
   {{0x92d870de,0xed56a300,0xedb6e100,0x6716c352}},	//   _tener_, _बांगला_, _barrachd_, _गर्दी_,
   {{0xd67b5247,0xe9ec5122,0x940e9070,0x4b553211}},	//   _bibendum_, _donostia_, _अध्यक्षप, _normalar,
   {{0x496ca32b,0x525b00f7,0x23f8a008,0xd27ed10e}},	//   _kalimant, _avalik_, _nebus_, _rieni_,
   {{0xc26da260,0x893fd186,0x5378a126,0x3c689095}},	//   _kapom_, _alemanya_, _bekalan_, _sapuluh_,
   {{0x143c900b,0xb27ed012,0xaa0ff030,0xa2e9f061}},	//   _домаћинс, _pieni_, _没收违法所得_, _monitro_,
   {{0xc24991e8,0xdaab5035,0x89854062,0x00000000}},	//   _pesme_, _परवलीचा_, _চড়তাম_, --,
   {{0xb3f99209,0xe2483129,0x127ed072,0xd9ca7006}},	//   _בקרוב_, _nemmen_, _vieni_, _miesiąc_,
   {{0x7739c09e,0x00000000,0x00000000,0x00000000}},	//   _esportiv, --, --, --,
   {{0xd2905126,0xf27ed129,0x615e00a6,0x4395f067}},	//   _solat_, _tieni_, _morgunbl, _lausa_,
   {{0x3c69403e,0x8641e08f,0xc29041c6,0xf2009061}},	// [df0] _kultury_, _perkahwi, _tomar_, _llais_,
   {{0xa2ba7052,0xc337e018,0xe3869101,0x9706b03e}},	//   _mendaki_, _मोनालिसा_, _orari_, _kulturní,
   {{0xd2927243,0x0218c15f,0x53410177,0xa73351c1}},	//   _gerais_, _облак_, _berezia_, _absolvov,
   {{0x5384206c,0x00000000,0x00000000,0x00000000}},	//   _מאטריאל_, --, --, --,
   {{0x17b3b067,0x9248d196,0xe48ed1d9,0xe31640e2}},	//   _प्रधानम्_, _atema_, _nefunguj, _membeli_,
   {{0x7a7f0025,0xd79b2045,0xf887f1bb,0x5ceb82be}},	//   _입주가능일_, _автором_, _लाठीचार्, _अधिकता_,
   {{0x42d8a2d5,0xb291a002,0x8143f0bb,0x35f9417b}},	//   _debes_, _ampas_, _greenwal, _загрижен,
   {{0xc5a7917d,0xabdd32e4,0x52da7097,0x7e72a022}},	//   _ভৌগলিক_, _बढ़िया_, _bereik_, _सुस्त_,
   {{0x5f5870a0,0x1c18708e,0x8c07b020,0x13c58182}},	//   _happiest_, _happies_, _personu_, _турнира_,
   {{0xa3ea014b,0xd27b41c1,0x5978e18a,0x00000000}},	//   _imiti_, _momentál, _periaatt, --,
   {{0x739fc019,0x9c764141,0x7201401a,0xa1c53076}},	//   _إصدار_, _ditulis_, _undies_, _sklepach_,
   {{0xd27e70a6,0xf2ba70f8,0x0ceba0d4,0x2a77a353}},	//   _minni_, _sandali_, _שהגיע_, _मूलभूत_,
   {{0x726df159,0xb20090d1,0x2fc4206c,0x5e00125b}},	//   _estos_, _hlais_, _מנהיגים_, _diperbua,
   {{0x98fe40c3,0xd2d8c031,0xc201a166,0x3c71d231}},	//   _프로그램을_, _elleni_, _ampir_, _माल्टा_,
   {{0xc2905184,0xac868030,0xa248c130,0x025ac1f4}},	//   _solas_, _中签号公布_, _jammer_, _callum_,
   {{0xc1c470d4,0x0a7e40a7,0xb37fc1c4,0x929050e7}},	//   _האנציקלו, _legatura_, _almanna_, _polas_,
   {{0x13f860f0,0x5fe510a1,0x9e90106f,0x854f2314}},	// [e00] _lulug_, _dostları, _osamljen, _slavonsk,
   {{0xb27ed245,0x32907292,0x5f552072,0x4b8b70a1}},	//   _dienu_, _ionas_, _становіш, _komissar,
   {{0x226c10c5,0x46d740c9,0xaa9ca206,0x75b1a0d4}},	//   _schon_, _sporočil, _talijans, _בדואר_,
   {{0x19e53195,0xd318d052,0x69eed08f,0xce0ed126}},	//   _resultad, _gemilang_, _terunggu, _terengga,
   {{0xc257211d,0xc249821d,0x994e801b,0xb2da5048}},	//   _परदेसी_, _derma_, _mielipit, _sitene_,
   {{0x42497132,0x9eac22b2,0x527f0010,0x4ad8601b}},	//   _kwamba_, _recommen, _erangi_, _основной_,
   {{0x6e2fa008,0xd02e00e5,0xf6ae00e5,0x00000000}},	//   _autorius_, _arbenigo, _arbenigw, --,
   {{0xde5061b9,0xb200f240,0xb440c0a7,0x00000000}},	//   _financie_, _meniny_, _асочиау_, --,
   {{0x0312b01f,0x6760d031,0x428c8054,0x42d80129}},	//   _serbest_, _منافق_, _klikken_, _grieg_,
   {{0xe0393055,0x6200a0b2,0xe34360e8,0x02a7b0ce}},	//   _زيارت_, _dobio_, _livello_, _puqbe_,
   {{0x9f1161cf,0xfae160b6,0x00000000,0x00000000}},	//   _contrata, _contratt, --, --,
   {{0x972e40ff,0xe31071d2,0xeacb701e,0xf329c0c3}},	//   _exklusiv, _verzii_, _sommeren_, _개인정보관리책임,
   {{0x8f2da16a,0x899130a9,0xb290929c,0x62d0f067}},	//   _determin, _volkwage, _klaar_, _प्रतिपदा_,
   {{0xa2d9e22a,0x05f07039,0x5bec60f9,0x15d2f005}},	//   _veten_, _ویتنام_, _dinamičn, _újdonság,
   {{0x826d119e,0xb2d9e025,0xc16600d4,0x3ace2041}},	//   _escola_, _weten_, _נישואין_, _चेयरमैन_,
   {{0xa84490cb,0x00000000,0x00000000,0x00000000}},	//   _इंडस्ट्र, --, --, --,
   {{0xa27ed0da,0x341971c1,0x73f4024b,0xcd9e32f1}},	// [e10] _dient_, _politick, _testar_, _materije_,
   {{0xd27ed03c,0x2c7d6034,0x8d0210c3,0x7c530049}},	//   _vienu_, _последна, _알고싶어요_, _castiga_,
   {{0x026d90f2,0x12fca074,0xb354e0e4,0x8236d002}},	//   _pasok_, _harakati_, _levelet_, _ghojwi_,
   {{0xb2907100,0xe355a019,0xc568510c,0x0c1d21ca}},	//   _annad_, _referer_, _europäis, _paraspar,
   {{0x62d8b1c5,0x6b9cf00f,0xd2007013,0x1290a166}},	//   _veces_, _nyandiko_, _ponit_, _roban_,
   {{0x13052185,0x00000000,0x00000000,0x00000000}},	//   _ostalim_, --, --, --,
   {{0xd586c1ef,0xf3f8814c,0xa387f078,0x00000000}},	//   _podravsk, _kukuwa_, _jutro_, --,
   {{0x127ef150,0x4e908116,0x8f26d15b,0x259e806c}},	//   _prindi_, _električ, _estricta, _לופטפעלד,
   {{0xfb1c200b,0x03f8710e,0xae96a00a,0x4273202e}},	//   _rasprost, _munud_, _students_, _tänne_,
   {{0x3734003b,0x827f1008,0xa292722e,0xb2d8c0c5}},	//   _お役立ち度_, _bizni_, _parant_, _jedes_,
   {{0x02d8b0ba,0xd200c01b,0x42907354,0x3cd1a133}},	//   _peces_, _kodin_, _zonas_, _国家中医药管理局_,
   {{0xa0e8600d,0xf86d2019,0x00000000,0x00000000}},	//   _прыгажос, _scriosad, --, --,
   {{0xd2907086,0xdf5711f3,0xe2d800d4,0xbaee80b3}},	//   _donar_, _merginos_, _tried_, _rettighe,
   {{0x5248611e,0x9290b0d4,0x6b0740fe,0xba0740fe}},	//   _ngoma_, _local_, _priprave, _pripravu,
   {{0x489fa02a,0x9c6d81b6,0x1d9e306f,0xa253a2a1}},	//   _компанії_, _pokreta_, _baterije_, _deklaroi_,
   {{0x6cfa6182,0x441d21ab,0x96cec068,0xcfaf7133}},	//   _придружи, _horietak, _bulabili, _请及时与我们联系_,
   {{0xf6d930a8,0x4d4e5074,0xc7bde117,0x95d8e07f}},	// [e20] _humphrey, _taratibu_, _patiesīb, _ウォッチリストに,
   {{0xa200c13b,0xf26e130c,0x82d77062,0x89adc0d8}},	//   _hodin_, _época_, _টপিকটি_, _dalszöve,
   {{0x4497a1db,0x975be153,0x5057a182,0xd29071a4}},	//   _lansiraj, _मुस्कान_, _lansiran, _sonas_,
   {{0x126e6122,0xf54a9034,0xa8db9061,0x00000000}},	//   _kirola_, _обстанов, _ymgeisyd, --,
   {{0xb3ead016,0xb3bbc005,0xd382c039,0xea380133}},	//   _voltar_, _اسٹاک_, _چارلس_, _国家邮政局_,
   {{0xb2ca01f3,0x52fce10e,0x425b0115,0xa2014008}},	//   _leido_, _hangen_, _maalum_, _sveiki_,
   {{0x224991d5,0x02cf8157,0xc3c08005,0x52cbb030}},	//   _resmi_, _podobne_, _رینجرز_, _对最佳答案的评论_,
   {{0x8a06d030,0xceb330a7,0x9378d1d0,0x9d88907c}},	//   _上一篇文章_, _autohton, _tamamen_, _sprečiti_,
   {{0x23966011,0xa2d8c1ed,0x32eb2059,0x0bd20005}},	//   _verslo_, _jeder_, _dopiero_, _کمیونٹی_,
   {{0x0eae1191,0x0c03f216,0x92907150,0x00000000}},	//   _syarikat_, _pristup_, _annab_, --,
   {{0x39d9303a,0x3292610a,0xbc54a00a,0xe844a00a}},	//   _polovica_, _batatu_, _listing_, _listings_,
   {{0x72d80355,0x66e97036,0xf2d4706c,0x72c75013}},	//   _quien_, _プレゼント_, _אָרעמע_, _анатолий_,
   {{0x80fa1059,0x0eee7036,0x200a00b6,0x5307f0a6}},	//   _amerykań, _すべて表示_, _уикипеди, _manneskj,
   {{0x60385356,0xf08ae1ea,0x12a661b7,0xd508907c}},	//   _vestmann, _psicholo, _osobi_, _sprečilo_,
   {{0x52eca24f,0x1b7bf105,0x625a21b0,0x2691921f}},	//   _koriste_, _bangunan_, _rekla_, _benefici,
   {{0xb5ef3012,0xe93f3012,0xcf8f3012,0x93ea2138}},	//   _kommenti, _kommentt, _kommento, _sekta_,
   {{0x93974014,0xc9f74051,0x43cee031,0x835bc058}},	// [e30] _samarbej, _samarbet, _amivel_, _blogera_,
   {{0x146f4055,0x127e0219,0xc24a603b,0x3267b063}},	//   _استعداد_, _maint_, _siumut_, _الثلاث_,
   {{0x334c50a4,0xb9f2b11b,0x2ac930cb,0x7067f152}},	//   _raketom_, _startsid, _सुपरहिट_, _वर्षको_,
   {{0x7c911063,0x847da012,0x00000000,0x00000000}},	//   _للرجال_, _животные_, --, --,
   {{0x2adf5124,0x5287f1ad,0x007170f0,0x525a0173}},	//   _eintrage, _regiony_, _norapamo, _geill_,
   {{0x6627612e,0x4967612e,0x52911199,0x3e53a1f7}},	//   _minisiti, _minisite, _mozak_, _kasangka,
   {{0x8a9bb29e,0x328f6199,0x0a0f60a4,0x1e4f60a4}},	//   _jurnalis, _stranici_, _stranica_, _stranice_,
   {{0x420120b1,0xec56b1fd,0xa066c00d,0x72d8e075}},	//   _orbitz_, _kartice_, _напэўна_, _panelu_,
   {{0x427ef037,0x3ed4e008,0x425b42f0,0xd20190be}},	//   _quindi_, _socialin, _spelen_, _posib_,
   {{0xa9dcc108,0x12eb0101,0xe2a64132,0xddbed0ca}},	//   _zabezpie, _diritto_, _namba_, _proizila,
   {{0x22d7c0f1,0xb18e50cd,0xdf2101d5,0x6a878108}},	//   _spiller_, _parasysh_, _kesulita, _zmieniać_,
   {{0xd8cc000a,0x9f369045,0x00000000,0x00000000}},	//   _להצטרף_, _просить_, --, --,
   {{0x156dd02a,0x125a815a,0xb6987119,0xd9dc81d8}},	//   _норматив, _okolí_, _careerli, _infectie,
   {{0xe27e60a9,0x8afd8145,0x1e3400d4,0x636d8020}},	//   _phong_, _intervis, _האשראי_, _intervij,
   {{0xe2e652c8,0x31815003,0xde71112b,0x92fce070}},	//   _ciencia_, _गौरवशाली_, _обувки_, _langka_,
   {{0x02d8f10e,0xf201e07f,0x125ac177,0xc2a1d153}},	//   _neges_, _altid_, _nullam_, _बिलासपुर_,
   {{0xa7b87078,0x8af870b5,0x62b5b060,0xdc0d02e9}},	// [e40] _regulami, _regulame, _gradove_, _kampene_,
   {{0x72a6414c,0xb7dab12d,0x76bc2063,0xaef1a03e}},	//   _gamba_, _وعندما_, _لتحميل_, _efektivn,
   {{0x8a78e1c1,0x5c03d035,0x00000000,0x00000000}},	//   _značek_, _bioskop_, --, --,
   {{0xe6c8b20c,0xe5828038,0x526c301b,0x0ebd010e}},	//   _varaždin, _kundersh, _samoin_, _llandudn,
   {{0x7290a118,0x52247059,0x62ed917a,0x740d002f}},	//   _dobar_, _rynku_, _впливу_, _francouz,
   {{0xe25a02c2,0x0f264150,0x4c7560a9,0x1365a0d4}},	//   _geile_, _perekonn, _jxquest_, _דווחו_,
   {{0x42b0e1e6,0x630d4129,0xa3ea9010,0xe2cb52f0}},	//   _ग्रुप_, _apparat_, _amatu_, _moeder_,
   {{0x429022f6,0x78d7d073,0xc862c130,0x1e0c7292}},	//   _nikad_, _низация_, _dringend, _انفلونزا_,
   {{0x62ca0054,0x139cc03b,0x920270e9,0x55b6802a}},	//   _beide_, _回答した人_, _visiem_, _партії_,
   {{0x98bb10f1,0xbf21412d,0x7290c06d,0x8ef3f035}},	//   _minutter_, _ailtirea, _eldar_, _perkebun,
   {{0x511111d2,0xd9911020,0x7200b1c1,0x3ef110e9}},	//   _projekty_, _projekta_, _pocit_, _projekts_,
   {{0x12489189,0x8f8be236,0x7ec23101,0x49f94022}},	//   _agama_, _alábbi_, _костюми_, _externí_,
   {{0xb25a00fc,0x611700a3,0xe14610d4,0x3b76414a}},	//   _teile_, _publicēt, _הבחירה_, _sealadac,
   {{0x7290d173,0x33f45002,0xa2d98248,0x031ab133}},	//   _sleat_, _nettie_, _yerel_, _按作者搜索_,
   {{0x7290a1f4,0xfacbd1f9,0xcc165254,0x7a89917b}},	//   _tobar_, _евгений_, _सेन्सेक्, _продажба,
   {{0x32fe623f,0x116af038,0x729151ee,0x00000000}},	//   _morgun_, _respekto, _enfawr_, --,
   {{0xd147d00b,0x3fda00c4,0xf23650d2,0x03f06041}},	// [e50] _написао_, _springbo, _malja_, _गोलीबारी_,
   {{0xbe29c15f,0x732912e0,0x00000000,0x00000000}},	//   _немало_, _provesti_, --, --,
   {{0x442b2024,0xe290c02d,0xe261a12c,0x4eb32195}},	//   _مسنجر_, _allaha_, _grimmjow_, _aspectos_,
   {{0xaa883100,0x00000000,0x00000000,0x00000000}},	//   _schottis, --, --, --,
   {{0x7207900a,0x51434063,0xe20101d7,0x0a47300b}},	//   _רעננה_, _لمعرفة_, _ambito_, _оружја_,
   {{0x4a34d06c,0xe477a01b,0x1b82c062,0x3f356063}},	//   _לעיקוואד_, _проекте_, _ফালতু_, _أنفسهم_,
   {{0x54318008,0x6f718008,0xd224f064,0x834830ce}},	//   _pasaulio_, _pasaulis_, _etiket_, _ajvetlh_,
   {{0xc3ea01ed,0x0290c008,0x027e6145,0x0da010c6}},	//   _seite_, _kodas_, _thone_, _diantara,
   {{0x3248d18b,0x725a012d,0xabf3b1f4,0xc693b1f4}},	//   _isomer_, _peile_, _aineolac, _aineolai,
   {{0xc3fc5031,0x2d43a15f,0xa9ff0239,0xa4f8f045}},	//   _aktuális_, _можност_, _poznania_, _наступни,
   {{0x53f40007,0xd559a00d,0x1e92e24e,0x14d59357}},	//   _hustru_, _павышэнн, _líderes_, _कर्त्तव्,
   {{0x4200c10e,0xdda11024,0x904da132,0x00000000}},	//   _nodir_, _پايگاه_, _matumain, --,
   {{0x3f12e03b,0x1778600d,0x00000000,0x00000000}},	//   _studeren, _супадзен, --, --,
   {{0x8c39c019,0x324891d2,0x5c76c189,0xc5c6b15f}},	//   _بغداد_, _takmer_, _operasi_, _чувствув,
   {{0xe5c7008d,0x12cae056,0x926df20b,0x12903129}},	//   _সুতরাং_, _hendak_, _estou_, _armati_,
   {{0x6b6d2087,0x8ae87133,0x7df8305c,0x7aeb60a4}},	//   _hypother, _représen, _женски_, _neprijat,
   {{0xceb860c4,0xe2eee25c,0x00000000,0x00000000}},	// [e60] _januarie_, _soifon_, --, --,
   {{0xa5c070a0,0xf2fd6014,0x435e2151,0x00000000}},	//   _ionadail_, _logget_, _lungsod_, --,
   {{0xc31c20d4,0x253e5070,0x9342c252,0x008da06c}},	//   _להוכיח_, _subhanah, _facendo_, _אביוז_,
   {{0x9290c15f,0xac76409f,0x4292600d,0x6cf0f1de}},	//   _todas_, _नास्ति_, _metais_, _प्रकोप_,
   {{0x0f5c6103,0xc290f1f4,0x73f4009f,0x00000000}},	//   _slåss_, _mogal_, _justru_, --,
   {{0x7290c0e9,0xbea15129,0x92d92073,0x5c0930f3}},	//   _rodas_, _fallimen, _printre_, _campusa_,
   {{0x50bbd041,0x00000000,0x00000000,0x00000000}},	//   _जालंधर_, --, --, --,
   {{0x234301d4,0xd290f093,0x2202506d,0xcb9c212d}},	//   _तुरंत_, _nogal_, _imtina_, _digiteac,
   {{0x5f430044,0xf3ac50be,0xd2d81004,0x42d8f051}},	//   _chiplove_, _souple_, _nghen_, _seger_,
   {{0xc25a510e,0xc21810a3,0x00000000,0x00000000}},	//   _wella_, _priekšme, --, --,
   {{0xd3eae077,0xe2d8f0c5,0x1cac900a,0x6321406d}},	//   _contes_, _spielt_, _existing_, _yeganə_,
   {{0x8eb6c07b,0x5d33b15d,0xa27e905d,0x517ab027}},	//   _профиль_, _menneske_, _azana_, _прописан,
   {{0x52bf1024,0x6ef6408d,0x90edb012,0x826d8017}},	//   _املاک_, _আিরফুর_, _monipuol, _paros_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdec220b5,0x824a719e,0xe288e131,0x8290703f}},	//   _постам_, _normes_, _peckham_, _monat_,
   {{0xa2787019,0xb79512b3,0x00000000,0x00000000}},	//   _karnar_, _testberi, --, --,
   {{0x9741e060,0x7837c072,0x93ce920b,0x620150d9}},	// [e70] _основне_, _канале_, _chave_, _defini_,
   {{0xcbc7d045,0x9c5d204c,0x73f46043,0x00000000}},	//   _продажу_, _postado_, _settar_, --,
   {{0x23eb0150,0x131660fd,0x596811a3,0x5587b17b}},	//   _alates_, _akoze_, _reciente, _причинит,
   {{0xcd015315,0xc3ea023f,0xa25a0043,0x33eb40a7}},	//   _celtniec, _heita_, _heila_, _pretul_,
   {{0x4c0811a1,0x4316710a,0x00000000,0x00000000}},	//   _fourniss, _manza_, --, --,
   {{0x727e91a2,0xd26d8146,0x00000000,0x00000000}},	//   _shand_, _varor_, --, --,
   {{0xd2fce263,0xc8f45007,0xe86180e2,0x9e35e0f8}},	//   _tangan_, _телефонн, _terakhir_, _karaniwa,
   {{0x13ea023f,0xd2ca00fc,0x5691e026,0x66b5002d}},	//   _leita_, _leida_, _moderaci, _reportaj_,
   {{0xa43ec187,0x14860005,0x183ce036,0xdf176055}},	//   _казна_, _طاقتوں_, _産学官連携リンク, _pamarént,
   {{0x6637a136,0x3367a16a,0xa1f7a108,0x2b07c00b}},	//   _programm_, _program_, _programy_, _видели_,
   {{0x234a10c1,0x4c7eb063,0xc27ee07a,0xd3bbc019}},	//   _telerau_, _taistil_, _kvinde_, _فستان_,
   {{0x727f81db,0x3103d231,0xaae51133,0xb60c90dc}},	//   _mirna_, _कॉमनवेल्, _由工商行政管理部, _संपदा_,
   {{0xc3a2312c,0xe25a50f6,0xb26da1b1,0x00000000}},	//   _tempoh_, _kello_, _tapos_, --,
   {{0x13f471ad,0x727c10dd,0x12e3d0be,0x037c8098}},	//   _hostem_, _играч_, _avantaj_, _kitaawe_,
   {{0x86bc60d5,0x4387f18a,0x42c9422e,0x93166129}},	//   _सत्तर_, _juuri_, _tulloch_, _globali_,
   {{0x9387400e,0x36704179,0xda4a215b,0xcda9500d}},	//   _enerji_, _परिचर्चा_, _generada_, _seminara,
   {{0xd15c7031,0x7307e15d,0xa9674177,0x92cae27d}},	// [e80] _speciáli, _japansk_, _kalitate, _sondes_,
   {{0x32a6204b,0x215c71c7,0x92d8c0d3,0xb27f410b}},	//   _membre_, _speciáln, _kuleta_, _tienda_,
   {{0xe24840d2,0xab6020cb,0xa2d830ff,0xb310d204}},	//   _summo_, _रोशनी_, _numera_, _кнеза_,
   {{0x12026002,0x5e9e3202,0x83f84196,0x5200a02d}},	//   _scribo_, _gestellt_, _mumum_, _rejimi_,
   {{0x847261c7,0xbf2a710e,0x525a5037,0xe3ea0043}},	//   _बस्ने_, _dystiola, _bello_, _beiti_,
   {{0xa290501f,0x22c9f02f,0x3316021e,0x36b9a0ed}},	//   _kolay_, _nakonec_, _cyiza_, _nekazari,
   {{0x826c90a4,0x0a279101,0x09d970d4,0x00000000}},	//   _školi_, _диабет_, _assessme, --,
   {{0xb236d1fd,0x6c7c8030,0x4248627d,0x00000000}},	//   _svojem_, _贴子相关图片_, _drome_, --,
   {{0x82d8e030,0x03872219,0x2fb4003e,0x1d8660f7}},	//   _effet_, _eryri_, _říjen_, _प्रोटोका,
   {{0x21c79200,0x72ca7043,0x72d70034,0xc291804c}},	//   _фидель_, _senda_, _antonio_, _foram_,
   {{0xc27e5019,0x8248005d,0x7d47e0dd,0x0f11501c}},	//   _مستقلة_, _arimo_, _партијат, _protekta,
   {{0xf2b500d2,0x7386c2a6,0x00000000,0x00000000}},	//   _cracow_, _cadre_, --, --,
   {{0xa2ca70ba,0xe3ea7227,0xb7b8618f,0x12d80219}},	//   _venda_, _venta_, _natuurli, _oriel_,
   {{0x6e382023,0x39eed122,0x0d95307b,0x00000000}},	//   _localita, _dirulagu, _удачи_, --,
   {{0x03eaf157,0x6a6e002d,0x82d80044,0x6c296284}},	//   _pritom_, _fotosess, _trien_, _carigrad_,
   {{0xe26cb128,0x52c510f7,0x625740dc,0x015b1253}},	//   _epcot_, _milline_, _पामेला_, _podrobno,
   {{0x38662024,0xb2a6326a,0xc2d860c0,0x1428d132}},	// [e90] _اکنون_, _membru_, _tulen_, _jumatano_,
   {{0x3e29d00d,0x030d4041,0x0ecd4041,0x42537051}},	//   _запаміна, _posiadaj, _posiadan, _gemensam,
   {{0xe9b84129,0xdf06c0dd,0x0d46c027,0x00000000}},	//   _tendenza_, _притоа_, _притом_, --,
   {{0xef80c049,0x627ee103,0x927e6064,0x148db25d}},	//   _психик_, _meinte_, _abone_, _kirurgij,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x026ca15a,0xa2916129,0x5875b085,0x00000000}},	//   _školy_, _legali_, _musikvid, --,
   {{0xf2ca0167,0x9b8ac02a,0x6782f0bd,0x4970e321}},	//   _veidi_, _зобов_, _फ्रान्सि, _policajt,
   {{0x80f7a1bb,0x00000000,0x00000000,0x00000000}},	//   _सपोर्ट_, --, --, --,
   {{0x837d5358,0x127ed030,0x9f03b070,0x0286b08f}},	//   _zapadne_, _liens_, _निर्मिती_, _muakkad_,
   {{0xee994157,0xb3b5e06f,0x6873c359,0x130041fd}},	//   _uvítací_, _plovila_, _anonymou, _članki_,
   {{0xf5da912d,0xdd183163,0x53f86067,0x3dac6250}},	//   _شروحات_, _glasswar, _kulul_, _minnetda,
   {{0x7248006a,0xd2257010,0xb25a51a6,0x99b16170}},	//   _primo_, _shakka_, _celle_, _mindeste,
   {{0x62d9c1ba,0xe200101b,0x126d008f,0xaef7e1bb}},	//   _sevel_, _mihin_, _nibong_, _इराकी_,
   {{0x1b584109,0x973e1069,0xc3ea80d9,0x8e9ec083}},	//   _sentenza_, _volledig, _viktim_, _павла_,
   {{0x23ea012e,0x1809b133,0x00000000,0x00000000}},	//   _ifite_, _查看该公司所有供, --, --,
   {{0xf39e100b,0x13957115,0x495be1fd,0x1200e1df}},	//   _osvajanj, _ghasia_, _znanstve, _muniti_,
   {{0x80b09031,0x4965213b,0x6ab90036,0x7f3641ec}},	// [ea0] _digitáli, _समानता_, _陽気なギャングが, _keturuna,
   {{0x7c76b235,0x7a9d6099,0x32362103,0xa8c85234}},	//   _मार्शल_, _albigens, _ikkje_, _portaing,
   {{0xa25a5032,0x924970b6,0xcae5d0bd,0xc27ed34b}},	//   _belle_, _stampa_, _उद्यान_, _giens_,
   {{0xecd73055,0x249d1072,0x910ff036,0x03874025}},	//   _اعمال_, _зарплата_, _個人情報保護方針_, _overal_,
   {{0x318232da,0xc26e622e,0xa460700b,0x51ced0ca}},	//   _कठुवा_, _baroda_, _апсолутн, _novoform,
   {{0xbcc0b108,0x1ee32300,0xbc7f20e8,0x7fc652a3}},	//   _श्रेणिया, _निष्प्रा, _possono_, _पीएचडी_,
   {{0x4d9d6012,0xb386614b,0x1f481055,0x500ee1c1}},	//   _sunnunta, _akora_, _pangasin, _neuveden,
   {{0x927ed093,0x47853304,0x1c6160b5,0xd4b601a7}},	//   _diens_, _आस्वाद_, _actuala_, _propovij,
   {{0x5d5b4059,0xf984517d,0xe776f094,0x249df036}},	//   _फर्नीचर_, _কদমতলী_, _पर्सनल_, _ルディングス_,
   {{0xd0b09181,0x08dcd07e,0x92003241,0xbd865231}},	//   _digitáln, _تشخيص_, _enjin_, _आर्केड_,
   {{0xe201106f,0x3264219d,0x568a5122,0x63448284}},	//   _akcije_, _saqlaw_, _federazi, _izvesne_,
   {{0xb2e31068,0x32cae27d,0xf29180a4,0x2d76d148}},	//   _halinde_, _wandel_, _korak_, _قرآني_,
   {{0x3c96b06c,0x9f48616a,0x7d89301b,0x1c6b42fa}},	//   _מייקראסא, _response_, _valokuva, _खात्मा_,
   {{0x851e20c3,0x84e170bd,0x00000000,0x00000000}},	//   _수령일로부터_, _प्रतिपिण, --, --,
   {{0x7f3d9101,0xf43b2036,0x8ea730c9,0xae4a4123}},	//   _традиция_, _ルマガジン_, _poslovan, _prabhupa,
   {{0xe2569062,0x00000000,0x00000000,0x00000000}},	//   _মেট্রো_, --, --, --,
   {{0x3395f10a,0x00000000,0x00000000,0x00000000}},	// [eb0] _nkusi_, --, --, --,
   {{0xc25a50fc,0xd98ba03b,0xf3f461ed,0x4ea8424a}},	//   _selle_, _ルアドレス_, _wetter_, _britiske_,
   {{0x914b312a,0x0c05f106,0x72d8a022,0xa386921e}},	//   _correspo, _tessuti_, _duben_, _ahari_,
   {{0xae72f0f7,0xfef13204,0x5213401f,0x00000000}},	//   _शूद्र_, _осталим_, _şehit_, --,
   {{0xf26de0e3,0x72918052,0x63ea0043,0x548580bd}},	//   _fatos_, _corak_, _neitt_, _घटनाएँ_,
   {{0xe3ea0169,0x3e704309,0xeff0b112,0x82d8a10e}},	//   _ufite_, _गोल्ड_, _diskisyo, _arbed_,
   {{0x225e2177,0xe25a2185,0xab6db275,0x00000000}},	//   _kontseil, _rekli_, _kosmetic, --,
   {{0xb27ed020,0x52ca7195,0xacc7300d,0x82026223}},	//   _viens_, _sendo_, _сэрца_, _dirije_,
   {{0x8387822a,0x4f3820cb,0xd3786010,0x2180801b}},	//   _marre_, _सेमिनार_, _bagamba_, _удовольс,
   {{0xde9a0025,0x49de117d,0x3aac5189,0x217d906c}},	//   _브라우저로_, _তারুণ্য_, _angkatan_, _קיעוו_,
   {{0x3c6b3067,0x113c11b9,0xc2dec128,0xe3790127}},	//   _किल्ली_, _posledné_, _adhomdu_, _masamba_,
   {{0xc93c2036,0xc27b608f,0xd3f40026,0x4b6820d4}},	//   _sommerfe, _persekol, _festes_, _התושבים_,
   {{0x92d9e2a1,0xa3ea70fe,0x92d472f0,0xc394f02a}},	//   _vetem_, _tento_, _verder_, _keiser_,
   {{0x4c7660ba,0x7640701b,0xb3f4618d,0x02b6b1bd}},	//   _mesures_, _sosiaali, _setter_, _verdade_,
   {{0x513c1218,0xe25a0080,0xfd9771c1,0xc9da806a}},	//   _poslední_, _heilt_, _autobaza, _preferit,
   {{0xaacb7103,0xc5301005,0x723b30d1,0xd9d720fa}},	//   _sommaren_, _مظفرآباد_, _tijlaug_, _bretland,
   {{0xf3161020,0xd386c019,0x34a5b21e,0xbc1e1057}},	// [ec0] _nedaudz_, _madra_, _kurangiz, _compres_,
   {{0x6394e17c,0xe25a910e,0x8200c027,0x1b68400b}},	//   _exista_, _deall_, _veliki_, _pritiska_,
   {{0xd2b4e193,0x5001e117,0x8cee21f9,0xabfc6059}},	//   _inicio_, _fotogrāf, _труда_, _tajemnic,
   {{0x33ea7082,0x65d99072,0xb27ed145,0x2ebdd023}},	//   _gente_, _распаўсю, _thene_, _evenimen,
   {{0x3356403f,0xcd3ea0e0,0x689420b9,0x89463023}},	//   _bereits_, _navigace_, _prevodov, _realitat,
   {{0xdc6f10a0,0x4813a00a,0xf2a782df,0xfb7c100d}},	//   _clarion_, _קראתי_, _harbe_, _дасяжныя_,
   {{0x92ca7068,0x27c8a024,0xd3ea7045,0xfa08d19a}},	//   _bende_, _نويسنده_, _bente_, _komadina_,
   {{0x42d98024,0x92a650f2,0xdfb8a07e,0x00000000}},	//   _leres_, _milby_, _خونریزی_, --,
   {{0x23ea71a6,0x8e38300d,0xa8cda204,0x52267038}},	//   _vente_, _renginia, _asteroid, _perket_,
   {{0x3903f06c,0xc26de146,0x73425049,0x6a52504d}},	//   _פאָלק_, _dator_, _severin_, _severina_,
   {{0xed9032cf,0x32d47195,0x52b281e0,0x52cb3075}},	//   _इंडोनेशि, _perder_, _kindern_, _mladé_,
   {{0x6d2d9054,0xf0e7e041,0x9fd850e0,0xabe2e036}},	//   _kleinere_, _सीसीएल_, _odstraně, _が参考になった_,
   {{0x49d2218f,0xdb0c106c,0x1ff7900a,0xd20020a6}},	//   _geregist, _אלימלך_, _לעתיד_, _mikil_,
   {{0x97de812f,0x02b1e1fd,0xb25a914c,0x00000000}},	//   _compagni, _prodaja_, _kwali_, --,
   {{0x4749817a,0xc63690e0,0xd02fe017,0x025a50fc}},	//   _михайлов, _भैरहवा_, _спадзява, _kella_,
   {{0x09cc006f,0x3837c0a7,0x53a8e141,0xd25a92ec}},	//   _temeljit, _банане_, _belakang_, _mwali_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ed0] --, --, --, --,
   {{0xf2f76235,0x0e7ab03b,0x5e92323e,0xd2d98058}},	//   _जरुरी_, _チェックリストに, _постала_, _teret_,
   {{0x52903131,0x94b35148,0x913c11b9,0x4ceb90d4}},	//   _almain_, _احاديث_, _posledná_, _להסיר_,
   {{0x33f860be,0x4781006c,0xb245a0d8,0xb84640e7}},	//   _atout_, _סאקפאפעט_, _címre_, _realidad,
   {{0x32d98005,0x987752db,0x00000000,0x00000000}},	//   _keres_, _जीतेंद्र_, --, --,
   {{0x9fab30e0,0xb2ca72c7,0x22d9803b,0xa3ead0a0}},	//   _nemovito, _sende_, _jeres_, _cultar_,
   {{0xc2d9823a,0x62d02215,0xac61004f,0x1c6e02d5}},	//   _deres_, _فضيلت_, _ciputra_, _podría_,
   {{0x4290c23f,0x2f8cb1de,0x2248d009,0xe3ead0df}},	//   _undan_, _हल्का_, _holmey_, _ometi_,
   {{0xf02e105d,0x420261cd,0x1e2cc15f,0xc2027042}},	//   _fondatio, _skrive_, _следи_, _skrift_,
   {{0x36b2c301,0xebb4e0e0,0xe3034175,0x00000000}},	//   _कर्ता_, _मुलुकको_, _babantu_, --,
   {{0x135bd10a,0x834320f2,0x82ca50c0,0x020270ef}},	//   _kongera_, _aspekto_, _felda_, _serisi_,
   {{0x22ca51d0,0x23dce241,0x2197a0d4,0xaf72301b}},	//   _geldi_, _haiwan_, _לתואר_, _вокруг_,
   {{0xb25a90fd,0x52d99266,0xa2d9807e,0x01826041}},	//   _swala_, _meses_, _beres_, _इलेवन_,
   {{0x427a10d3,0x9b6c00f7,0x72df315d,0xe201a235}},	//   _karibuni_, _रंजना_, _behovet_, _kopii_,
   {{0xf25a5068,0x7225f169,0xf9c260bd,0x029031db}},	//   _belli_, _nkuko_, _खींचा_, _pijan_,
   {{0xf85ca01e,0xe71bd156,0x6b6e21d8,0xf1e6e003}},	//   _detaljer_, _волунтар, _chronisc, _चुनरी_,
   {{0x03f98126,0xe249816a,0x358b915f,0xc394e0c4}},	// [ee0] _terus_, _terms_, _достигну, _meisie_,
   {{0x0dff7038,0xda2a3135,0x00000000,0x00000000}},	//   _rezervua, _बन्हाइल_, --, --,
   {{0x4ec8206c,0x026e5031,0x00000000,0x00000000}},	//   _טעותים_, _katona_, --, --,
   {{0x12902070,0xf2d960ce,0x00000000,0x00000000}},	//   _cikal_, _angegh_, --, --,
   {{0x2252f036,0xf27e9031,0xe386e13b,0x00eec061}},	//   _bestyrel, _arany_, _mafra_, _amlinell,
   {{0x3f15f1fd,0x627e018b,0xd5b20036,0x03eae306}},	//   _predavan, _sains_, _詳しくはこちら_, _fontes_,
   {{0x2290e011,0xbd9c60f0,0x497e4062,0x8e737022}},	//   _šiame_, _ameliska, _কনফুসিয়, _हेल्प_,
   {{0xfc00b072,0xe2019024,0x31bd3073,0x4dfd3049}},	//   _miestas_, _eosin_, _виата_, _виаца_,
   {{0x63034175,0xac17a313,0x862ac103,0xd0d1f094}},	//   _zabantu_, _ecopark_, _navigeri, _मल्टीमीड,
   {{0x42b7a012,0x4f563035,0x938aa0a6,0xc7a69272}},	//   _министр_, _खासगी_, _aðrir_, _británic,
   {{0x4f4da09a,0x0c56a08b,0x39f3115f,0xd972c159}},	//   _היברו_, _vertete_, _инвестит, _opinione,
   {{0x83f9910e,0x234150dc,0xbc41f133,0xb2d98296}},	//   _mesur_, _कैमूर_, _县级以上人民政府, _seres_,
   {{0x32d99007,0x23f8202c,0x47d960d7,0xe61c2062}},	//   _leser_, _hukum_, _kulawarg, _এলাহি_,
   {{0x0de65135,0x93ea0019,0xc2a65135,0x5200f013}},	//   _miljonit_, _meith_, _miljoni_, _logit_,
   {{0x83ea0019,0x5291e0ce,0x7c51e226,0x64d52108}},	//   _leith_, _notam_, _smotana_, _साहित्_,
   {{0x6984b276,0xd4751303,0x00000000,0x00000000}},	//   _mikkelse, _अपरिहार्, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	// [ef0] --, --, --, --,
   {{0xe43c517d,0xc2ca7043,0x604b9135,0xd38660ce}},	//   _প্লিজ_, _henda_, _महागुरु_, _chorr_,
   {{0x0b57f205,0x8a585317,0x6cb9f017,0x125a5135}},	//   _kultúra_, _valencia_, _калектыв, _telli_,
   {{0xc9f61071,0x8d46c0dd,0x2ba4b1c3,0x00000000}},	//   _توسیع_, _интервју_, _hygienic, --,
   {{0xd290706b,0x42d9a038,0x965e100b,0xa291e0d2}},	//   _innan_, _neper_, _фирме_, _altaq_,
   {{0x5d163002,0x853170c3,0xcb79d017,0xf74e70c3}},	//   _pollhost_, _불가능합니다_, _легенды_, _국가보안법_,
   {{0xfc3940ba,0xd316021e,0x9ae070b6,0x4a14c18f}},	//   _inscripc, _myiza_, _contenut, _verborge,
   {{0x429040d9,0xa8d0300b,0x000c107f,0x00000000}},	//   _siman_, _издавачк, _お問い合せ_, --,
   {{0x527e71f4,0xaabf2235,0xf290c186,0x00000000}},	//   _ianni_, _slavnost, _andam_, --,
   {{0xcc5b924d,0xb665e277,0x347d935a,0x596fa0c9}},	//   _preuzme_, _आवासीय_, _प्रभा_, _poznanst,
   {{0x9c645074,0x93ea70f8,0x4279e0ab,0x22d9a0ee}},	//   _wabunge_, _benta_, _डिफ़ॉल्ट_, _leper_,
   {{0x6837e0c3,0x739930d1,0xe2d9b116,0x860d1030}},	//   _되겠습니다_, _samxusa_, _seveda_, _expositi,
   {{0x5ed96266,0x13f911ba,0x03f89170,0x72ca70ed}},	//   _noticias_, _jezuz_, _drauf_, _denda_,
   {{0x76e3d1de,0x5d23c0f9,0x49e3c027,0xc290c0cd}},	//   _शक्तिशाल, _datoteke_, _datoteka_, _andaj_,
   {{0x068c90af,0x1307d126,0x7f4110c2,0x79e6f0f6}},	//   _फ्राय_, _sarawak_, _سپنتا_, _verrattu,
   {{0x23ead130,0x93ea0067,0xe3b7a0d4,0x329181fd}},	//   _groter_, _leiti_, _יעבור_, _moram_,
   {{0x397d1005,0xd2a1a214,0x0d98c041,0x2c14c07e}},	// [f00] _ایگزیکٹو_, _менталит, _राइडर्स_, _موانع_,
   {{0x62da41d9,0x82cad073,0xbdbe4186,0xd3a9705d}},	//   _stanice_, _produs_, _catalase_, _yumvise_,
   {{0x93b9f04f,0x327e0132,0x00000000,0x00000000}},	//   _cadviet_, _mbinu_, --, --,
   {{0xfc65b0bd,0x1248d083,0xf27f80c9,0x72d8d0ac}},	//   _portalu_, _vreme_, _mirni_, _suden_,
   {{0xf075d117,0xd25a5002,0xe2d9906b,0x87a8d18a}},	//   _materiāl, _dellu_, _weser_, _особо_,
   {{0xdf2490b3,0xe63b5133,0xca8240c2,0x8643a06c}},	//   _støtte_, _小仓优子性感泳装, _changeab, _סאדאם_,
   {{0xc665a141,0xd322f12b,0x520112ce,0xc291b1c4}},	//   _peristiw, _класация_, _poziv_, _óvart_,
   {{0xd3c7503e,0x2303506f,0x23ea807e,0xb3866234}},	//   _hospodář, _hranjenj, _toktok_, _chorp_,
   {{0xdfaba035,0xa200b1d9,0x00000000,0x00000000}},	//   _direktur_, _hodina_, --, --,
   {{0x0fa232eb,0xc3940176,0xf2027194,0x42d8d133}},	//   _تهذيب_, _aviso_, _posita_, _valeur_,
   {{0x6290529e,0x23cef01b,0x03f82064,0x39b7317d}},	//   _onlar_, _olivat_, _hukuk_, _সাবধান_,
   {{0xc4c07195,0x62007019,0xa2d9a038,0x03f8d2a0}},	//   _público_, _inniu_, _teper_, _judul_,
   {{0x32497173,0x92c2a063,0x417211c3,0xaa14c18f}},	//   _agamsa_, _كمقروءة_, _miliardy_, _verberge,
   {{0x53d97012,0xe96b7049,0x00000000,0x00000000}},	//   _посетить_, _dimineat, --, --,
   {{0x82a7f0ef,0x9237e0bd,0x6bf54087,0x00000000}},	//   _grubu_, _chomika_, _perfluor, --,
   {{0x02b3e20b,0x2291814a,0xa2f1f00e,0x0291e0e2}},	//   _produto_, _foras_, _tarixli_, _kotak_,
   {{0x5ee9b09a,0xf6dca070,0xd27e901a,0xf68ca13b}},	// [f10] _בחדרי_, _प्रिय_, _ibang_, _प्राय_,
   {{0x8237818a,0xaa261160,0xdd0590ca,0x00000000}},	//   _sarja_, _फेरबदल_, _protivpr, --,
   {{0x4291833f,0x53a2d150,0x2394e12d,0x6dd9d039}},	//   _horas_, _hoopis_, _briste_, _متضاد_,
   {{0xd2b21116,0xe343c35b,0xcae74067,0x00000000}},	//   _gradnja_, _imperio_, _सन्यास_, --,
   {{0x22ca722a,0x6e5390bb,0x538690c7,0xc60a50f6}},	//   _vendi_, _внутрішн, _bharr_, _duodecim_,
   {{0xd25ad132,0x029180a0,0xf6ae300e,0xb394d108}},	//   _kweli_, _doras_, _britaniy, _prostu_,
   {{0xb3f8f048,0xb2ca5009,0x925b806f,0x2613807a}},	//   _bugun_, _teldu_, _umrli_, _atomkraf,
   {{0x7b7fc1b6,0xc38f1157,0xfadfc1fd,0x130db15b}},	//   _poslanic, _obstaráv, _postanit, _votants_,
   {{0x4c76b0c0,0x40d1800d,0x00000000,0x00000000}},	//   _ditukar_, _пецярбур, --, --,
   {{0x0aaeb06c,0x62eed119,0xa2d821d0,0xdc1600f1}},	//   _דובראַוו, _otofun_, _erken_, _søster_,
   {{0xd301e023,0x12b40023,0x07588022,0xab7d321c}},	//   _detalii_, _adica_, _पूर्णता_, _finančné_,
   {{0xd200c16a,0x22d9c0d8,0xc69b1219,0x1c6d926d}},	//   _india_, _heves_, _daleithi, _iskrena_,
   {{0x03950058,0xa16e5031,0xdb6c217f,0x4c72b35c}},	//   _glasaj_, _استفادہ_, _spomenic, _alertas_,
   {{0xf2030020,0xf2d8019e,0x62d9e020,0x00000000}},	//   _automašī, _trieu_, _sezonas_, --,
   {{0xb4843041,0x72914144,0x00000000,0x00000000}},	//   _इजरायल_, _okeanu_, --, --,
   {{0x4200b1d9,0xda2480dc,0x5e5b700b,0x1c66c0e7}},	//   _rodina_, _छानबीन_, _najbolje_, _mentres_,
   {{0x80d0d062,0x7a0ff119,0x4cc4801d,0x02e9614b}},	// [f20] _শত্রু_, _vinagame, _hamingju_, _matimba_,
   {{0x5fa4616a,0x42007100,0xe8c6c094,0x52575071}},	//   _december_, _innis_, _राजपाल_, _táplálko,
   {{0x69df5086,0x83957038,0x01462100,0x7dcf3211}},	//   _contingu, _flasim_, _gallaibh_, _sanksiya,
   {{0xbc76516a,0xb29070ff,0x938071f4,0x120100bf}},	//   _results_, _annat_, _thuras_, _dobija_,
   {{0xe2fcf35d,0x5ba62160,0x6200c0f6,0xcc1c335e}},	//   _amigos_, _आदित्य_, _tulisi_, _organlar,
   {{0xbae96093,0x6c77d108,0x89ed90d8,0x00000000}},	//   _gasteboe, _potrafi_, _rendelés, --,
   {{0x18c6817d,0xfaaae041,0xfdbc4157,0x4280e067}},	//   _উদ্যোগ_, _थाईलैंड_, _označte_, _प्रधानता_,
   {{0x02d9f0f6,0x00000000,0x00000000,0x00000000}},	//   _etten_, --, --, --,
   {{0x82ad301b,0x42fc035d,0x58304063,0x95ffd041}},	//   _минут_, _amigo_, _الزهراء_, _अवशोषित_,
   {{0x6cc100a7,0x4153635f,0xa2eb0005,0x00000000}},	//   _акчедеря_, _kunststo, _ٹریبونل_, --,
   {{0xf8a1703b,0xdc78e2f5,0xfc26e054,0xeca8a07f}},	//   _お気に入り_, _titulky_, _verbeter, _お支払い方法_,
   {{0xa3f8e1ab,0xf2d9614c,0x0355b10e,0x00000000}},	//   _genuen_, _engeri_, _howells_, --,
   {{0x5202727d,0xac093087,0xd25a00a3,0x00000000}},	//   _musiek_, _lampara_, _stila_, --,
   {{0x98c7c036,0x5932107e,0xd5eab0eb,0xa2d92119}},	//   _知恵袋に投稿され, _جنسیت_, _amacıyla_, _luyen_,
   {{0x835d10f8,0x32ca70ed,0x52cad067,0x5d28c133}},	//   _tanging_, _kendu_, _reede_, _puissanc,
   {{0x6b4f402b,0x2ee991b3,0xc8e8a036,0x4e8f419c}},	//   _kommuner, _štefánik, _選択してください_, _kommunen,
   {{0x8394e070,0xaea38012,0xd86a904b,0x3224d35f}},	// [f30] _sensus_, _значител, _politiqu, _punkte_,
   {{0x34047025,0x6f40f025,0x8c5e6133,0x3386d14b}},	//   _전체매물정보_, _인도네시아_, _查看同主题问题_, _nzeri_,
   {{0xa3f9e008,0xfc29825b,0xf197c0ac,0xf207706f}},	//   _metus_, _membenar, _наконец_, _uživali_,
   {{0x72cb01f5,0x6c59e0ed,0x227ed14c,0xf378e0f8}},	//   _grader_, _besteak_, _nsonga_, _melason_,
   {{0xd25ae01d,0x0291a002,0x92d9024b,0x22d92119}},	//   _heilsa_, _alpay_, _arbeta_, _duyen_,
   {{0xd9daa2d6,0x2623a015,0x4307c0a4,0x00000000}},	//   _ternyata_, _daimntaw, _ostatak_, --,
   {{0x0860c04c,0x426e6026,0x2c70a006,0xd683e003}},	//   _инаку_, _aprova_, _मुर्गी_, _महराज_,
   {{0x95e2f1c5,0x0a7e000f,0x02007114,0xf292722e}},	//   _categorí, _byandits, _minim_, _dorais_,
   {{0xc2cb40fe,0xf9ffa03e,0xa31cf125,0x00000000}},	//   _predam_, _moderní_, _yoochun_, --,
   {{0x929070d6,0xabb3f25c,0x29f6729a,0x47262005}},	//   _annar_, _perkubur, _borås_, _شواہد_,
   {{0x9ad2910b,0x1755d0e7,0x00000000,0x00000000}},	//   _contrase, _estética_, --, --,
   {{0x87b5325c,0x926db107,0x1200402c,0x00000000}},	//   _subspesi, _novost_, _kimia_, --,
   {{0x7e4300af,0x92e8e166,0x6eb960c4,0xf71580d4}},	//   _सेक्रेटर, _tulisan_, _navorsin, _נותנת_,
   {{0x32480185,0xb200c0fb,0x4233c18a,0x0291a065}},	//   _naime_, _kuliah_, _hyppää_, _unpad_,
   {{0x8053c035,0xe290c02d,0x02d9e103,0x5bad80d4}},	//   _presiden, _ondan_, _heter_, _איתמר_,
   {{0x1c65b104,0x5d3d30e0,0xb301c2a8,0x8ee921fd}},	//   _sastavu_, _aplikace_, _ज़िम्मेद, _parkiran,
   {{0x72fcd058,0x804a1274,0x0d828045,0xf08d8101}},	// [f40] _bloger_, _ujeruman, _illegalt_, _половина,
   {{0x23e8d0dd,0x9639e15b,0xf27e60d7,0xff3a000d}},	//   _аскер_, _dedicaci, _opone_, _profesin,
   {{0xe2fcc2e8,0xf1d6100a,0x227e61f2,0x038601f2}},	//   _google_, _ישראלים_, _mbona_, _akiri_,
   {{0x355c9045,0xf5a9702a,0xf2d9812d,0x157cb061}},	//   _постанов, _радянськ, _dtreo_, _ymgeiswy,
   {{0x937a10b4,0xc3265133,0xa27e70a2,0xcfe7b062}},	//   _pesanan_, _图片和音视频稿件_, _rannu_, _ভাসমান_,
   {{0x5cce40c3,0xaf22718f,0x0972a251,0x5e17d0a7}},	//   _이메일주소_, _wintersp, _kopirajt, _telecoma,
   {{0x7662507c,0xb7e6006c,0x00000000,0x00000000}},	//   _krajnjem_, _ליצנות_, --, --,
   {{0x527e612e,0x52019314,0x00000000,0x00000000}},	//   _abona_, _josip_, --, --,
   {{0x93467148,0xb29190cc,0xbef2e051,0xf57d9122}},	//   _زنجیره_, _posar_, _beskrivn, _instrukz,
   {{0x16034073,0xaa4481b9,0x127ee127,0x00000000}},	//   _тестамен, _predseda_, _asinga_, --,
   {{0x14fb30d5,0x229071be,0xf2d9e145,0xb255506d}},	//   _ज्ञानी_, _annak_, _vetes_, _həlak_,
   {{0xf2d920a9,0x182c10d4,0x3aed4106,0x73c4e13b}},	//   _quyen_, _להישאר_, _introdot, _लोकतन्त्,
   {{0x32eab1a9,0x841c10d4,0x8ab6b262,0xc4463005}},	//   _eventos_, _להפעיל_, _दुखड़ा_, _شائقین_,
   {{0x62fe4265,0x40f5d174,0xe248d023,0x02f1812b}},	//   _artigos_, _अनुरूप_, _promis_, _инсталир,
   {{0xc2257261,0xf290412c,0x020160f9,0xef0c8062}},	//   _vlakom_, _timah_, _regiji_, _মহাজন_,
   {{0xa2d9e069,0x62da610a,0x73d51129,0x13473043}},	//   _beter_, _gereza_, _protetti_, _nemenda_,
   {{0x6c1db00a,0xf23782c9,0x4ff82025,0x43b791b3}},	// [f50] _כשהוא_, _varje_, _담당중개업소_, _kenvelo_,
   {{0x97113005,0x1c575005,0x3fd68074,0x52acf072}},	//   _جنازہ_, _سنبھال_, _changamo, _характар_,
   {{0x825af223,0x00000000,0x00000000,0x00000000}},	//   _regle_, --, --, --,
   {{0xc2ed0067,0xe51e10d4,0xcf3971c3,0x027ee01b}},	//   _निरीह_, _אופציות_, _finanční, _kunnan_,
   {{0x025a9115,0x2c069108,0x3a405063,0xc3f4005e}},	//   _awali_, _imprezy_, _وشروحات_, _postaz_,
   {{0x12fd20d0,0x62007184,0xb502b034,0xa37fd074}},	//   _militer_, _minic_, _ingresso_, _malaika_,
   {{0xc08a402a,0xf3f9e01d,0x825a5140,0x00000000}},	//   _кримінал, _setur_, _kelli_, --,
   {{0x82da60e7,0xd3193063,0x82a780d2,0x0a146122}},	//   _parece_, _شيئاً_, _qarbe_, _pribatut,
   {{0x72b5203d,0xa229a0ad,0x5af71025,0xc200c16c}},	//   _índice_, _kuamuag_, _versture, _npliaj_,
   {{0x127f0036,0x7097e05f,0xa55df064,0x00000000}},	//   _blandt_, _времену_, _orijinal_, --,
   {{0x52d8c09b,0xa166206c,0xae0590c0,0x00000000}},	//   _namens_, _שידוכים_, _kenderaa, --,
   {{0xcf0ba0f4,0xca0d61cf,0xe290500e,0x32781125}},	//   _אלירן_, _computad, _silah_, _starworl,
   {{0x524d313d,0x6ef8611d,0x971140bd,0xbb1810f8}},	//   _बंगला_, _आर्गनाइज, _गर्दन_, _kabataan_,
   {{0x22d96054,0x00000000,0x00000000,0x00000000}},	//   _ergens_, --, --, --,
   {{0x2ece50bd,0xa3966185,0x12a6c1b1,0x00000000}},	//   _कार्यवाह, _spusti_, _tambay_, --,
   {{0x32d9e10f,0x730e103a,0xe2915185,0x00000000}},	//   _often_, _navijanj, _nogama_, --,
   {{0x3b6ac1e3,0xddef8022,0x92ca0167,0x3b8b9091}},	// [f60] _pretoria_, _पृष्ठभूम, _veids_, _ministar,
   {{0x0b02c211,0x3c61502d,0x935d4070,0x92fce186}},	//   _konfrans, _postlar_, _सल्ला_, _hangin_,
   {{0xc3866173,0x048950c0,0x00000000,0x00000000}},	//   _phort_, _pengangk, --, --,
   {{0xc25a3031,0x9845b35d,0x00000000,0x00000000}},	//   _állam_, _utilidad, --, --,
   {{0x325a9115,0xd295e175,0x51f7918d,0xd9f7a0ea}},	//   _swali_, _omukazi_, _структур_, _bibiliya_,
   {{0xc532700b,0x7ee8425c,0x2f1d6337,0xc2cae1e2}},	//   _септемба, _adakalan, _nakupova, _pondok_,
   {{0x1315b110,0xf56690a7,0x92d8615d,0xf4c3a034}},	//   _memberi_, _пречис_, _broen_, _подарък_,
   {{0x83869052,0x0c64325c,0x77b87145,0xd2caf203}},	//   _bharu_, _bintulu_, _sigurimi, _hundar_,
   {{0xc27871ca,0x679d815f,0x86ad4022,0x1c586014}},	//   _kaunas_, _сообраќа, _उत्तरदाय, _faktisk_,
   {{0xedb2d04e,0x206371ba,0x01df80bd,0x00000000}},	//   _keingina, _redaksyo, _poinform, --,
   {{0xe8e2a2cf,0xfc691034,0x52d9e1c2,0xd227f073}},	//   _सोहराबुद, _terreno_, _aften_, _вариатэ_,
   {{0xc38c200b,0x631781d9,0x12cb50ba,0x56eab045}},	//   _путем_, _kurzy_, _quedar_, _приміщен,
   {{0xb291e0e7,0x1f20c2ef,0x6e68c299,0x3cd0f039}},	//   _notas_, _स्वीकृति_, _adiciona, _العظمی_,
   {{0x7f638032,0xd248d169,0x637f916e,0xc9f6e094}},	//   _affaires_, _ugomba_, _rahasia_, _प्लेलिस्,
   {{0x1230712e,0x9ae89122,0x513c11b9,0xd3731025}},	//   _nyamara_, _datorren_, _posledný_, _relatie_,
   {{0xe34fd0f3,0xa30dc1e2,0x5290f0fa,0x02d8d0dd}},	//   _direnak_, _membuka_, _engan_, _ordem_,
   {{0x9db43055,0xcc1d301f,0x83a3401d,0x530d008d}},	// [f70] _موضوع_, _kurallar, _sleppa_, _locales_,
   {{0x7290c122,0x20f44036,0x7212b100,0xb713a09c}},	//   _zidan_, _そういえば_, _docha_, _primstav,
   {{0xb200f02c,0x67bca03f,0xf2f650bd,0x4291e1dc}},	//   _ingin_, _angezeig, _घटनास्थल_, _votat_,
   {{0x035fa230,0xeeb130e1,0x77a1f0c4,0x4d69a06c}},	//   _airgead_, _prostire_, _omstandi, _מיטאַרבע,
   {{0x3c528177,0x0481b0cb,0x7bd020c3,0x32007114}},	//   _kontuan_, _पिताजी_, _등기수수료_, _linia_,
   {{0x5147c034,0xf248f156,0x72a7c034,0x3273b1c4}},	//   _такива_, _trimis_, _такова_, _mínir_,
   {{0x22903115,0x325a00b6,0x2b61e04f,0x5e01a0a7}},	//   _kamati_, _utile_, _viglacer, _асигура_,
   {{0x894382f0,0x53ead067,0xd27e0166,0xa41a20a6}},	//   _mailadre, _rootsi_, _ucing_, _sannleik,
   {{0x632dd0bf,0xae37b0f3,0x0499310b,0x38d93038}},	//   _пољоприв, _bidalita, _personaj, _personav,
   {{0x0290c080,0x90c7a1f6,0xd5e2e00b,0x42ca70d6}},	//   _sidan_, _рамките_, _железнич, _hendi_,
   {{0x72ca7048,0x938692eb,0x527ef1df,0xd37380e0}},	//   _kendi_, _thart_, _magni_, _redakce_,
   {{0xf2920239,0x801e2008,0x3200f02c,0x5290d13b}},	//   _straty_, _komentuo, _angin_, _uvnitř_,
   {{0xe200c048,0xab7bf121,0x7af7c0e1,0xa340d012}},	//   _indir_, _pangalan_, _табели_, _someron_,
   {{0x6200c058,0x82ca7112,0x53ea9019,0x3201000b}},	//   _vidio_, _lendi_, _meath_, _dobila_,
   {{0x43ea9019,0xc352707a,0x7200c0f7,0x32018103}},	//   _leath_, _tilføj_, _andis_, _dorit_,
   {{0x427bc1d9,0x93f401bd,0x00000000,0x00000000}},	//   _objednáv, _festas_, --, --,
   {{0x33f8f055,0xab61d221,0x7dab2129,0x00000000}},	// [f80] _puguh_, _साधने_, _assigura, --,
   {{0xf3ead22e,0xa89ea0d8,0xb44a10a7,0x24f050d4}},	//   _cultur_, _katalógu, _ажюнс_, _chemical_,
   {{0x7fd52108,0x5af680e9,0xa078d12b,0x72907074}},	//   _materiał, _sportist, _правилат, _jinai_,
   {{0xe5b790f5,0x4b0bb024,0x6bed4005,0x07a6c360}},	//   _магатэ_, _ارزیابی_, _szoftver, _handling,
   {{0x72a78117,0x93eb016a,0xbeb32159,0x9290c01a}},	//   _darba_, _states_, _derechos_, _undas_,
   {{0x02d83133,0x41e73073,0xf37cb239,0x00000000}},	//   _sujet_, _уните_, _moravce_, --,
   {{0x3dd9325b,0xc7e3d034,0x97739133,0x2bf3606b}},	//   _berkenaa, _позиция_, _并不意味着赞同其, _avellino_,
   {{0x838d2111,0x50ccf274,0xa2feb276,0xf357420b}},	//   _دشوار_, _hirondel, _motiver_, _diretor_,
   {{0x92aa00d4,0xd369c043,0x95c15062,0x118070de}},	//   _מכרזים_, _tenglar_, _ফাহমিদুল_, _maravill,
   {{0xe2903131,0x8290c0a6,0xd5d2f00b,0xa26401c3}},	//   _comann_, _endar_, _железниц, _zaslat_,
   {{0x529271d9,0xf2d82196,0x027f823f,0x0032f246}},	//   _strach_, _emmere_, _barni_, _postepen,
   {{0x1d56100a,0x632090c6,0xb25a9035,0x2311d061}},	//   _זיכרון_, _biaya_, _nuklir_, _clybiau_,
   {{0x530ca024,0x626e509c,0xcaf7a146,0x00000000}},	//   _parabot_, _datoen_, _kunskape, --,
   {{0x3a033036,0x082610d4,0xf6232089,0x93f83143}},	//   _このブログの読者_, _משותפת_, _अरुणा_, _jujur_,
   {{0x8a3760e7,0x00000000,0x00000000,0x00000000}},	//   _técnicas_, --, --, --,
   {{0x9b133295,0x235d107e,0x72901114,0xc41f11b1}},	//   _johansen_, _nanging_, _mihai_, _sorsogon_,
   {{0x1d150051,0x0713e1e8,0x6ccc102b,0xb290302f}},	// [f90] _passager, _zajmodav, _служб_, _nijak_,
   {{0xd3eb8105,0x6898a108,0xfe00f234,0x4b3cd062}},	//   _serta_, _न्यूजीलै, _fhreasta, _কিবোর্ড_,
   {{0x62cb8035,0x440d2063,0x72d85219,0xfbae106c}},	//   _perda_, _النحل_, _caled_, _צוגאנג_,
   {{0x1f599099,0x7b40d148,0x329070f0,0x4387a0e4}},	//   _bliajyob_, _تعقیب_, _vinai_, _napra_,
   {{0xc2cb80bb,0xae71d0fc,0x03eb818d,0x13f8307e}},	//   _verda_, _रिस्क_, _verta_, _bujur_,
   {{0x02d19028,0xdcf5d035,0x5a773151,0x00000000}},	//   _पवित्रता_, _उघडकीस_, _flagella_, --,
   {{0xaf5d6141,0x223bf06c,0xbe83d012,0x00000000}},	//   _sepanjan, _כּנסת_, _подарок_, --,
   {{0xf3790044,0x02552136,0x95b9214a,0x00000000}},	//   _megavnn_, _strettam, _ballstát_, --,
   {{0xd291b117,0x32d8610e,0x13f9801f,0x00000000}},	//   _novada_, _groes_, _burun_, --,
   {{0x53787074,0x00000000,0x00000000,0x00000000}},	//   _angalia_, --, --, --,
   {{0xb2d9f0ac,0x8841c082,0x12ca903e,0x617f81db}},	//   _ettei_, _últimas_, _akademii_, _španjols,
   {{0xa2d84108,0x13954037,0xa2b4103b,0xd26cc030}},	//   _numer_, _queste_, _sundhed_, _pilote_,
   {{0x59877160,0xd847d17c,0x00000000,0x00000000}},	//   _विनम्र_, _интенция_, --, --,
   {{0x3a31811d,0xfb038042,0xa5ba3030,0xfc652136}},	//   _इज्जत_, _телекана, _月加入中国共产党_, _kuntatt_,
   {{0x4c172014,0x3fa511db,0xf30b9024,0x25a0b0dc}},	//   _milliard_, _navečer_, _یکدیگر_, _सोचती_,
   {{0xd7b3906c,0x53f84070,0xb200c020,0x00000000}},	//   _מאַסן_, _sumut_, _paliek_, --,
   {{0xb578f072,0x62b66026,0x22cb5041,0x83f8d0d4}},	// [fa0] _забеспяч, _cercle_, _kredyt_, _values_,
   {{0x5ad6804c,0x03f82047,0x42903151,0x42bb506d}},	//   _листата_, _cukup_, _himaya_, _həcmi_,
   {{0xf68d6262,0xa6174012,0xa248000d,0x7c0140d0}},	//   _पतवार_, _englanni, _kaimo_, _photores,
   {{0xe8b1d1cc,0x27cb902b,0x4bf53159,0x00000000}},	//   _predsjed, _складі_, _sugerenc, --,
   {{0x51778054,0xca342024,0xbb6441ed,0xe2da7048}},	//   _behandel, _هستید_, _arbeiten_, _mesela_,
   {{0x22d7c0cc,0x33f88098,0x00bb4035,0x33f8409f}},	//   _laboral_, _yakuwa_, _चोखंदळ_, _rumus_,
   {{0x92d9e16a,0xf486d003,0x82b4f14f,0xb20060ed}},	//   _after_, _त्राहि_, _आत्मविश्, _inoiz_,
   {{0x1f65e13e,0x12da1061,0xc967b1a1,0x8061725e}},	//   _автономи, _popeth_, _ordinate, _praktisk_,
   {{0xf2d9c1be,0xc290322c,0x5b1ed030,0x3b8de106}},	//   _nevez_, _bijah_, _点击此处查看原文_, _fornitur,
   {{0x420050eb,0xa3ea6115,0x99a7d0f6,0x00000000}},	//   _bilim_, _mtoto_, _инфляция_, --,
   {{0x73538006,0xe68c30cb,0x3f89c264,0x5be9a063}},	//   _produkcj, _प्लान_, _беназир_, _جرينتش_,
   {{0x44ff3005,0x42d8d122,0xa2d860d7,0x00000000}},	//   _اجاگر_, _ordea_, _mules_, --,
   {{0x3dd7a189,0x00000000,0x00000000,0x00000000}},	//   _perhatia, --, --, --,
   {{0x2e3871d0,0x81ad3063,0x7e91e03e,0x68ab107e}},	//   _galatasa, _البطن_, _editovat_, _برجسته_,
   {{0x720070c0,0xa0160198,0x00000000,0x00000000}},	//   _minit_, _गणेशजी_, --, --,
   {{0x37d0c00b,0x00000000,0x00000000,0x00000000}},	//   _многи_, --, --, --,
   {{0x53eb91f0,0xe2909074,0x7e6ac18d,0x6212b1c5}},	// [fb0] _mesto_, _askari_, _фонди_, _noche_,
   {{0xd2351251,0x2b5bf361,0xf4551037,0xb3eb8034}},	//   _prodotti_, _andersen_, _prodotto_, _certo_,
   {{0x217cc069,0xa27eb108,0x83806173,0x7f607184}},	//   _해피캠퍼스_, _jednym_, _corran_, _logainmn,
   {{0x62918041,0x59678071,0x937fc0c2,0xfedc610b}},	//   _coraz_, _tekintet, _samaria_, _opciones_,
   {{0xf96e4104,0x42b4012e,0x1386c0d2,0x0faec01b}},	//   _varijant, _kwica_, _ghorba_, _майкл_,
   {{0x9e8f3041,0x0fbbd119,0xe4b5a010,0x994e70d6}},	//   _कविताएं_, _zingstar_, _kutandik, _snarsvar_,
   {{0x6682e022,0x97798030,0xa2919146,0x37a78062}},	//   _उपचार_, _青岛市公安局_, _ensam_, _জ্বলে_,
   {{0x9f25b2ff,0x41dc106b,0x33421091,0x00000000}},	//   _qualquer_, _клуби_, _poseban_, --,
   {{0xf3eb7100,0x4b6d60cb,0x0703a02b,0xed9d80bd}},	//   _leatsa_, _ध्वनि_, _товарів_, _recenzje_,
   {{0xe7b7c17c,0xd2005189,0x53a290fa,0x00000000}},	//   _манифе_, _milik_, _slapp_, --,
   {{0x78bae0c3,0xe633f22e,0xfdb9617d,0xac65b1eb}},	//   _동영상갤러리_, _caisteal_, _dominica, _sustatu_,
   {{0x63eb9058,0xcf842062,0x9290f1c4,0x62d861d8}},	//   _nesto_, _সংরক্ষিত_, _engar_, _broek_,
   {{0x226e6023,0xb3ea9037,0x227f7206,0xc57140c3}},	//   _parola_, _stata_, _sranja_, _공간입니다_,
   {{0x373e01f9,0x830f3206,0x32cc3159,0xdec450a9}},	//   _подготов, _voditelj, _incluso_, _nganluon,
   {{0x62d991d9,0x9a42f051,0x6b8220ea,0x00000000}},	//   _musel_, _bilderna_, _ludoviko_, --,
   {{0x9c93e322,0x3ab280e9,0xb486608c,0x00000000}},	//   _स्टोर_, _katalogā_, _गंगाजी_, --,
   {{0x8e8f3041,0x126e7175,0x22012009,0x725a0133}},	// [fc0] _कविताएँ_, _nasoma_, _yiyin_, _huile_,
   {{0xa3d6b00c,0xcf444134,0x50ce2031,0x3b67a15d}},	//   _distinti_, _sociológ, _بزرگوں_, _skolepor,
   {{0x43f860c2,0xb8f8b0ed,0xf37a0169,0x3290b098}},	//   _dulur_, _askatasu, _magambo_, _endala_,
   {{0x99857094,0xa290e1b6,0x7c615161,0x57e40271}},	//   _लालकृष्ण_, _dinara_, _dostlar_, _नाटककार_,
   {{0xe07a404c,0x62272025,0xaeb1408b,0xb3737112}},	//   _временск, _전원주택펜션_, _europian, _komanse_,
   {{0x7248d17f,0xd3a24095,0xe07f6133,0xb2ca71c4}},	//   _prema_, _tompo_, _个人简介及主要业, _sendu_,
   {{0xa2005148,0xf0f1c13b,0xc03fb130,0xa4162005}},	//   _milih_, _हाइवे_, _vertalin, _تابخاکِ_,
   {{0x8baf1067,0xab2e4235,0xe2026150,0xf22460be}},	//   _षडयंत्र_, _poradens, _aprill_, _avoka_,
   {{0x186f116f,0x02a4f035,0xa2fde00d,0xbd2f1271}},	//   _filmový_, _राजपुत्र, _muzikos_, _filmové_,
   {{0x430f3091,0x6b6a021d,0x52d81186,0xb5175041}},	//   _roditelj, _bakteria_, _kahel_, _तपेदिक_,
   {{0x0d314063,0xed035036,0xea39200b,0x00000000}},	//   _رووووووو, _最終更新日_, _вечери_, --,
   {{0x71266049,0xddb410f7,0xa83790d4,0x5db71195}},	//   _евенимен, _munitsip, _התנתק_, _habilida,
   {{0xb68131f8,0x3ef4d012,0xf2005055,0x42d8a017}},	//   _जुबान_, _становит, _bilih_, _vadovas_,
   {{0x527ff0a9,0xe38730e3,0x42d83114,0x67ed4157}},	//   _thung_, _milionë_, _nimeni_, _futbalov,
   {{0x0300906c,0xe8c35017,0xc2cb8186,0x62bb0140}},	//   _ראטעווען_, _нелегаль, _berde_, _valette_,
   {{0xe38ce00d,0xe80cc042,0x43ac71e3,0xf2d83146}},	//   _музея_, _блоки_, _respek_, _bajen_,
   {{0xa741d02a,0x00000000,0x00000000,0x00000000}},	// [fd0] _основні_, --, --, --,
   {{0xd27e9044,0x9c69f1b3,0x12d822b2,0x00000000}},	//   _ebank_, _kratasy_, _taken_, --,
   {{0x327f705c,0xe316912e,0xa2905189,0x930051bf}},	//   _quanto_, _akazi_, _nilai_, _halaiki_,
   {{0xa4ee117a,0xcdf1508f,0x236a80e0,0x70f3a19f}},	//   _підготов, _mendafta, _सम्झौता_, _भागवत_,
   {{0xe3f84111,0x7fb7524d,0xc54a703b,0x02d82051}},	//   _lamun_, _udaljeno, _アクセサリ_, _saken_,
   {{0x06d31092,0xdfe921bb,0x6f059302,0x969730c3}},	//   _नासिक_, _दूतावास_, _pitomača_, _mededeli,
   {{0x238a92a9,0x164bc214,0xe3fa621c,0x4fa8f06c}},	//   _француск, _скокни_, _zaruke_, _בלומבערג_,
   {{0x824830d2,0x729001f4,0x7b9ea041,0x00000000}},	//   _hajmo_, _chiad_, _अंकुरित_, --,
   {{0xf5ac1049,0x239540ca,0x42b441be,0x33a450d4}},	//   _глума_, _dvesta_, _vendég_, _ההצטרפות_,
   {{0x03b6218d,0x830e0186,0xd27f705d,0x9a09c105}},	//   _значення_, _sapatos_, _asanga_, _takbirat,
   {{0x424bb0d5,0x1290a1dd,0x424830d2,0xd20272df}},	//   _श्वेता_, _sedang_, _dajmo_, _perish_,
   {{0xdf2d500a,0x5c75a151,0x00000000,0x00000000}},	//   _conferen, _phasing_, --, --,
   {{0x12d8e114,0xd2009019,0x00000000,0x00000000}},	//   _vineri_, _riail_, --, --,
   {{0x52fd5128,0x5f3ff2c6,0x22fce0f4,0x00000000}},	//   _boggle_, _विविधता_, _longer_, --,
   {{0xc3ead1f6,0xc2d84202,0x42ea80b1,0xf27ee140}},	//   _cuotas_, _namen_, _helical_, _spinta_,
   {{0x22d861e8,0xd344823d,0x6a0111b7,0x303d60d4}},	//   _usled_, _kreditu_, _dražen_, _inventio,
   {{0x027eb022,0x8c3aa034,0x00000000,0x00000000}},	// [fe0] _jednom_, _историят, --, --,
   {{0x62d8024b,0x42486226,0x856d6180,0x2c7582be}},	//   _asien_, _promi_, _samosprá, _सदस्यो_,
   {{0x1a5b7044,0x7841d020,0x5db3122e,0x4652d05f}},	//   _nghành_, _baltijas_, _colaiste_, _стога_,
   {{0xa248e0fa,0xad43d012,0x00000000,0x00000000}},	//   _heimin_, _великоле, --, --,
   {{0x615ba030,0x7df1600e,0xb3f0b0be,0x1290201c}},	//   _添加到收藏夹_, _hindista, _maketing_, _likas_,
   {{0x1c84b00a,0xcc5742fc,0xe3f4702c,0x368e1114}},	//   _observed_, _postele_, _kertas_, _conditii,
   {{0x992071c1,0xd7c72114,0x8de0721c,0x525a9067}},	//   _mobilní_, _ынтре_, _mobilné_, _sealt_,
   {{0x6105b17a,0xfce8d24d,0x00000000,0x00000000}},	//   _авторефе, _leđnoj_, --, --,
   {{0xff55f130,0x0297e138,0xaae8a1ba,0xc3e440f9}},	//   _verskeie_, _marafiki_, _retounen_, _diplomsk,
   {{0x41958117,0x0a144025,0xc49820d4,0xe2fce130}},	//   _rezultāt, _vakantie, _מתמטיקה_, _honger_,
   {{0x5c1d6114,0x03eb904b,0x42132009,0xe387e27f}},	//   _complet_, _reste_, _vicher_, _fatra_,
   {{0x0f78300b,0x1795a040,0x8378e055,0x92d862b0}},	//   _текста_, _centerpi, _kalawan_, _gulex_,
   {{0xe3eb917c,0x5c1fc203,0xcb7d5062,0x6290b02c}},	//   _peste_, _slipper_, _প্রণব_, _dicat_,
   {{0x428751c7,0x80771188,0x628e00b8,0x00000000}},	//   _miliony_, _parceiro, _parkson_, --,
   {{0xd23cd025,0x9d9df012,0xa5a4a038,0xbc5ac114}},	//   _환영합니다_, _maananta, _periudhë, _preturi_,
   {{0xd2901050,0x825a010f,0xae3fc067,0x227f7194}},	//   _jihar_, _still_, _विशेषांक_, _usanga_,
   {{0x42787012,0xd37a01ec,0xdc67b0f2,0x50e3b0d4}},	// [ff0] _kaunis_, _gerakan_, _libreng_, _הרחבה_,
   {{0x97db52cb,0xba33d279,0x5a8ca170,0x08511133}},	//   _प्रकृति_, _उर्जा_, _optionen_, _衣锦荣归回乡路_,
   {{0xf3f821d9,0x7489f17b,0x739430cd,0x00000000}},	//   _jakub_, _опасност_, _nejse_, --,
   {{0xd2926205,0x32fcd072,0x0712525f,0x8b114186}},	//   _porada_, _blogas_, _construí, _kompanya_,
   {{0xc9f61024,0x12647065,0xc1dea058,0x00000000}},	//   _توزیع_, _geulis_, _povratak_, --,
   {{0x4bd740bd,0x22d84287,0xec5be00c,0x79dc702b}},	//   _ऑडियो_, _tamen_, _partiti_, _кіровогр,
   {{0x529011ab,0xa39662c2,0x10f24362,0xd402624b}},	//   _bihar_, _versie_, _जनावर_, _rubriken_,
   {{0x5828e044,0x730c41e7,0x92a7a030,0x00000000}},	//   _liệu_, _pobreží_, _mercredi_, --,
   {{0x6fba61cf,0x53f84055,0x9d1c20af,0x12d8418f}},	//   _ignorado, _samun_, _निर्लज्ज, _samen_,
   {{0x63ea906d,0xf5d15108,0x976e80fb,0x7aae8295}},	//   _teatr_, _produktó, _provinsi, _provinse,
   {{0x5fcca24a,0x12901071,0x12640099,0x7adfb1c3}},	//   _artikler_, _alkalomm, _heslis_, _zastupit,
   {{0x82d96051,0x42fce055,0x6814c00a,0xf36ab064}},	//   _dagens_, _minggu_, _specific_, _özgür_,
   {{0xc200200e,0xc182e304,0xf732f1c7,0x829030d2}},	//   _fikir_, _अव्वल_, _अन्तरराष, _bijat_,
   {{0x9b77e284,0xf26630a7,0x814f5041,0x00000000}},	//   _demontir, _ансамблу_, _गुड़गांव_, --,
   {{0x191f312d,0x52480115,0xcb6f90a7,0xc3433284}},	//   _aistriúc, _daima_, _импакт_, _odselio_,
   {{0xf379614b,0x907b91c7,0x00000000,0x00000000}},	//   _faransa_, _कम्पनीका_, --, --,

  };
  // table_hash = 7bfb-a422, unused_entries = 1550 (9.46%)

static const uint32 kDeltaOctaChrome0614SizeOne = 867;    // Bucket count one-lang
static const uint32 kDeltaOctaChrome0614Ind[867] = {
  // [0000]
  0x00000000, 0x00000000, 0x0000fe42, 0x0000132d,   // -- --  tlh.un.un_C00 bh.un.un_A00
  0x00002b37, 0x0000120f, 0x00000924, 0x00000837,   // vi.un.un_B00 ur.un.un_600  pl.un.un_900 no.un.un_B00
  0x0000101c, 0x0000fe37, 0x00000115, 0x00001742,   // be.un.un_800 tlh.un.un_B00  iw.un.un_700 sr.un.un_C00
  0x00002a2d, 0x00001015, 0x00003142, 0x0000552d,   // mt.un.un_A00 be.un.un_700  az.un.un_C00 rw.un.un_A00
  // [0010]
  0x0000642d, 0x00001001, 0x00000442, 0x0000042d,   // lg.un.un_A00 lt.un.un_200  fi.un.un_C00 fi.un.un_A00
  0x00000242, 0x00006e2d, 0x19000a2c, 0x0000100f,   // da.un.un_C00 blu.un.un_A00  pt.gl.un_990 be.un.un_600
  0x0900130d, 0x00001842, 0x00001a24, 0x00000415,   // bh.hi.un_540 ar.un.un_C00  tl.un.un_900 ru.un.un_700
  0x00001a0f, 0x00000e1c, 0x0200081b, 0x00001b42,   // tl.un.un_600 is.un.un_800  no.da.un_770 tr.un.un_C00
  // [0020]
  0x00000f1c, 0x19000b1b, 0x00000d42, 0x0000111c,   // lv.un.un_800 es.gl.un_770  ne.un.un_C00 ro.un.un_800
  0x00002115, 0x00000315, 0x00002315, 0x0000172d,   // fa.un.un_700 ko.un.un_700  ca.un.un_700 sr.un.un_A00
  0x13000936, 0x00000703, 0x0000081c, 0x00000815,   // hi.bh.un_AA0 bg.un.un_300  uk.un.un_800 no.un.un_700
  0x1e001c36, 0x0000311c, 0x00000401, 0x2d000d23,   // id.ms.un_AA0 az.un.un_800  ru.un.un_200 cs.sk.un_880
  // [0030]
  0x00000515, 0x00001242, 0x00000537, 0x19000a36,   // zh.un.un_700 ur.un.un_C00  fr.un.un_B00 pt.gl.un_AA0
  0x00000742, 0x00001c15, 0x00000215, 0x00000724,   // it.un.un_C00 id.un.un_700  ja.un.un_700 it.un.un_900
  0x00002015, 0x0000120a, 0x0000292d, 0x0000021c,   // sq.un.un_700 ur.un.un_500  sl.un.un_A00 ja.un.un_800
  0x00000f03, 0x0b000a05, 0x00000d15, 0x00000624,   // lv.un.un_300 pt.es.un_330  cs.un.un_700 de.un.un_900
  // [0040]
  0x00006b0a, 0x0000090f, 0x0000082d, 0x00000e42,   // ceb.un.un_500 hi.un.un_600  uk.un.un_A00 is.un.un_C00
  0x00002b0a, 0x00000842, 0x00006b15, 0x1e001c09,   // vi.un.un_500 uk.un.un_C00  ceb.un.un_700 id.ms.un_440
  0x00001b2d, 0x0000112d, 0x00001306, 0x0000051c,   // tr.un.un_A00 ro.un.un_A00  et.un.un_400 fr.un.un_800
  0x00000a1c, 0x00001624, 0x1e001c35, 0x00002b1c,   // pt.un.un_800 hr.un.un_900  id.ms.un_A90 vi.un.un_800
  // [0050]
  0x0000fe15, 0x00000c42, 0x1c001e14, 0x02000805,   // tlh.un.un_700 sv.un.un_C00  ms.id.un_660 no.da.un_330
  0x00000342, 0x00002142, 0x1c001e35, 0x0000230f,   // nl.un.un_C00 fa.un.un_C00  ms.id.un_A90 ca.un.un_600
  0x00001642, 0x00000915, 0x0000530a, 0x00006b03,   // hr.un.un_C00 pl.un.un_700  ht.un.un_500 ceb.un.un_300
  0x00000701, 0x0000550f, 0x00002501, 0x00001715,   // bg.un.un_200 rw.un.un_600  eu.un.un_200 sr.un.un_700
  // [0060]
  0x00001737, 0x00001f15, 0x00000b0f, 0x0000180f,   // sr.un.un_B00 cy.un.un_700  bn.un.un_600 ar.un.un_600
  0x00001b15, 0x00001c0f, 0x09001c14, 0x00001342,   // tr.un.un_700 mr.un.un_600  mr.hi.un_660 bh.un.un_C00
  0x00001b37, 0x0000031c, 0x0000072d, 0x00000806,   // tr.un.un_B00 ko.un.un_800  it.un.un_A00 no.un.un_400
  0x0000240f, 0x00003115, 0x00002003, 0x00002942,   // yi.un.un_600 az.un.un_700  sq.un.un_300 sl.un.un_C00
  // [0070]
  0x00001c42, 0x00001215, 0x00001042, 0x00001142,   // id.un.un_C00 ur.un.un_700  be.un.un_C00 ro.un.un_C00
  0x00002842, 0x00000d03, 0x00000937, 0x0000232d,   // sw.un.un_C00 ne.un.un_300  pl.un.un_B00 ca.un.un_A00
  0x0000092d, 0x00001606, 0x00000224, 0x0000041c,   // pl.un.un_A00 hr.un.un_400  da.un.un_900 fi.un.un_800
  0x16001714, 0x0000532d, 0x0000210f, 0x0000020f,   // sr.hr.un_660 ht.un.un_A00  jw.un.un_600 da.un.un_600
  // [0080]
  0x0000080a, 0x00002d0f, 0x0b000a23, 0x00001724,   // uk.un.un_500 sk.un.un_600  pt.es.un_880 sr.un.un_900
  0x0d000902, 0x0000020a, 0x00002324, 0x00006b24,   // hi.ne.un_220 da.un.un_500  ca.un.un_900 ceb.un.un_900
  0x16001735, 0x1c000909, 0x00003f0a, 0x0000200f,   // sr.hr.un_A90 hi.mr.un_440  af.un.un_500 sq.un.un_600
  0x0000130f, 0x00000b01, 0x00003f24, 0x1c001e1b,   // et.un.un_600 bn.un.un_200  af.un.un_900 ms.id.un_770
  // [0090]
  0x00000d06, 0x17001623, 0x1300091b, 0x00003f37,   // cs.un.un_400 hr.sr.un_880  hi.bh.un_770 af.un.un_B00
  0x1c00090e, 0x00002106, 0x0200081a, 0x00003f03,   // hi.mr.un_550 fa.un.un_400  no.da.un_760 af.un.un_300
  0x0000641c, 0x00006e42, 0x00002415, 0x00003f2d,   // lg.un.un_800 blu.un.un_C00  yi.un.un_700 af.un.un_A00
  0x0200080e, 0x08000205, 0x00002301, 0x00001c37,   // no.da.un_550 da.no.un_330  ca.un.un_200 id.un.un_B00
  // [00a0]
  0x0000271c, 0x00003137, 0x00001f2d, 0x00000f42,   // gd.un.un_800 az.un.un_B00  cy.un.un_A00 lv.un.un_C00
  0x17001636, 0x0b001922, 0x00000e0f, 0x0000110f,   // hr.sr.un_AA0 gl.es.un_870  is.un.un_600 ro.un.un_600
  0x00001f06, 0x00002b2d, 0x1c000d1b, 0x0000090a,   // cy.un.un_400 vi.un.un_A00  ne.mr.un_770 hi.un.un_500
  0x00000424, 0x00006e24, 0x19000a04, 0x1c001336,   // ru.un.un_900 blu.un.un_900  pt.gl.un_320 bh.mr.un_AA0
  // [00b0]
  0x00005337, 0x00006b1c, 0x17001602, 0x00000201,   // ht.un.un_B00 ceb.un.un_800  hr.sr.un_220 da.un.un_200
  0x1c001e23, 0x00001137, 0x0000071c, 0x17001605,   // ms.id.un_880 ro.un.un_B00  it.un.un_800 hr.sr.un_330
  0x00002b42, 0x0d002d0e, 0x00002342, 0x00000824,   // vi.un.un_C00 sk.cs.un_550  ca.un.un_C00 no.un.un_900
  0x00001a15, 0x00000942, 0x00005342, 0x00001701,   // tl.un.un_700 hi.un.un_C00  ht.un.un_C00 sr.un.un_200
  // [00c0]
  0x00001e42, 0x00001f1c, 0x0000212d, 0x0000030f,   // ms.un.un_C00 cy.un.un_800  jw.un.un_A00 ko.un.un_600
  0x00003f15, 0x0000060f, 0x00001c01, 0x00001803,   // af.un.un_700 de.un.un_600  mr.un.un_200 ga.un.un_300
  0x13001c13, 0x00002924, 0x16001709, 0x13000914,   // mr.bh.un_650 sl.un.un_900  sr.hr.un_440 hi.bh.un_660
  0x0000231c, 0x00002042, 0x0000fe24, 0x0900132c,   // ca.un.un_800 sq.un.un_C00  tlh.un.un_900 bh.hi.un_990
  // [00d0]
  0x00001c24, 0x00006e01, 0x0000fe2d, 0x0000282d,   // mr.un.un_900 blu.un.un_200  tlh.un.un_A00 sw.un.un_A00
  0x0000010f, 0x0900130e, 0x00000e37, 0x00002124,   // iw.un.un_600 bh.hi.un_550  is.un.un_B00 jw.un.un_900
  0x0000121c, 0x0000530f, 0x00000337, 0x00000c15,   // ur.un.un_800 ht.un.un_600  nl.un.un_B00 sv.un.un_700
  0x1300090e, 0x00000a15, 0x00000b2d, 0x0000130a,   // hi.bh.un_550 mk.un.un_700  es.un.un_A00 bh.un.un_500
  // [00e0]
  0x00000d1c, 0x00001706, 0x1e001c02, 0x00002037,   // ne.un.un_800 sr.un.un_400  id.ms.un_220 sq.un.un_B00
  0x00001237, 0x00001f0f, 0x00001c2d, 0x00001942,   // hu.un.un_B00 cy.un.un_600  mr.un.un_A00 gl.un.un_C00
  0x00000737, 0x00000f15, 0x00005506, 0x00001b24,   // it.un.un_B00 lv.un.un_700  rw.un.un_400 tr.un.un_900
  0x00000e06, 0x00002542, 0x00001e0a, 0x00001b0f,   // is.un.un_400 eu.un.un_C00  ms.un.un_500 tr.un.un_600
  // [00f0]
  0x00006e37, 0x02000802, 0x00001a1c, 0x00002524,   // blu.un.un_B00 no.da.un_220  tl.un.un_800 eu.un.un_900
  0x00000142, 0x00001037, 0x00000437, 0x00001324,   // en.un.un_C00 be.un.un_B00  fi.un.un_B00 et.un.un_900
  0x00001a42, 0x0000290f, 0x00000e2d, 0x00001c0a,   // tl.un.un_C00 sl.un.un_600  is.un.un_A00 id.un.un_500
  0x00001337, 0x00006415, 0x0d002d23, 0x00000c2d,   // et.un.un_B00 lg.un.un_700  sk.cs.un_880 sv.un.un_A00
  // [0100]
  0x00002742, 0x0000070f, 0x1c000935, 0x00000803,   // gd.un.un_C00 bg.un.un_600  hi.mr.un_A90 uk.un.un_300
  0x16001721, 0x1c001e09, 0x00002a37, 0x0000290a,   // sr.hr.un_860 ms.id.un_440  mt.un.un_B00 sl.un.un_500
  0x0000091c, 0x00002a15, 0x00005542, 0x00000b1c,   // pl.un.un_800 mt.un.un_700  rw.un.un_C00 bn.un.un_800
  0x00000601, 0x00005306, 0x00001f42, 0x00000124,   // de.un.un_200 ht.un.un_400  cy.un.un_C00 en.un.un_900
  // [0110]
  0x1c001e2c, 0x00002137, 0x00005315, 0x00000c03,   // ms.id.un_990 jw.un.un_B00  ht.un.un_700 sv.un.un_300
  0x00001115, 0x0000281c, 0x0000291c, 0x00000f24,   // ro.un.un_700 sw.un.un_800  sl.un.un_800 lv.un.un_900
  0x17001609, 0x00002b24, 0x0000640a, 0x00000c24,   // hr.sr.un_440 vi.un.un_900  lg.un.un_500 sv.un.un_900
  0x00006e15, 0x09001314, 0x00005537, 0x1c000d13,   // blu.un.un_700 bh.hi.un_660  rw.un.un_B00 ne.mr.un_650
  // [0120]
  0x00003103, 0x00001a2d, 0x00002515, 0x00001e37,   // az.un.un_300 tl.un.un_A00  eu.un.un_700 ms.un.un_B00
  0x0000061c, 0x00002b06, 0x00001e1c, 0x00006437,   // de.un.un_800 vi.un.un_400  ms.un.un_800 lg.un.un_B00
  0x0000fe1c, 0x00002a42, 0x00000542, 0x00000715,   // tlh.un.un_800 mt.un.un_C00  fr.un.un_C00 it.un.un_700
  0x1c001e02, 0x00001815, 0x0000551c, 0x00000503,   // ms.id.un_220 ga.un.un_700  rw.un.un_800 fr.un.un_300
  // [0130]
  0x00003f42, 0x00002715, 0x00002815, 0x0000050f,   // af.un.un_C00 gd.un.un_700  sw.un.un_700 zh.un.un_600
  0x00002d0a, 0x00001315, 0x00002a24, 0x00001a37,   // sk.un.un_500 et.un.un_700  mt.un.un_900 tl.un.un_B00
  0x00002837, 0x1c001e1a, 0x00002001, 0x00000d01,   // sw.un.un_B00 ms.id.un_760  sq.un.un_200 cs.un.un_200
  0x00002803, 0x1c001314, 0x00000a2d, 0x0000102d,   // sw.un.un_300 bh.mr.un_660  mk.un.un_A00 lt.un.un_A00
  // [0140]
  0x00002a0f, 0x1e001c2c, 0x0b000a0e, 0x00002103,   // mt.un.un_600 id.ms.un_990  pt.es.un_550 fa.un.un_300
  0x16001723, 0x0000201c, 0x00000c1c, 0x00002801,   // sr.hr.un_880 sq.un.un_800  sv.un.un_800 sw.un.un_200
  0x0000210a, 0x1e001c34, 0x00001837, 0x00005515,   // fa.un.un_500 id.ms.un_A80  ga.un.un_B00 rw.un.un_700
  0x00006442, 0x08000202, 0x0000030a, 0x09001c08,   // lg.un.un_C00 da.no.un_220  nl.un.un_500 mr.hi.un_430
  // [0150]
  0x0000131c, 0x00006b2d, 0x09000d2c, 0x00000903,   // et.un.un_800 ceb.un.un_A00  ne.hi.un_990 pl.un.un_300
  0x00001301, 0x00006e06, 0x0000110a, 0x00002d15,   // bh.un.un_200 blu.un.un_400  ro.un.un_500 sk.un.un_700
  0x00000c0a, 0x00000b42, 0x2d000d05, 0x0000230a,   // sv.un.un_500 es.un.un_C00  cs.sk.un_330 ca.un.un_500
  0x0000040a, 0x02000814, 0x00000406, 0x00000a42,   // ru.un.un_500 no.da.un_660  ru.un.un_400 mk.un.un_C00
  // [0160]
  0x0d00090e, 0x0000312d, 0x09000d35, 0x00006b37,   // hi.ne.un_550 az.un.un_A00  ne.hi.un_A90 ceb.un.un_B00
  0x00003f01, 0x00001b01, 0x0000211c, 0x00000f0f,   // af.un.un_200 tr.un.un_200  jw.un.un_800 lv.un.un_600
  0x00000a0f, 0x00005524, 0x0000011c, 0x00001003,   // mk.un.un_600 rw.un.un_900  en.un.un_800 lt.un.un_300
  0x00006e0f, 0x09001305, 0x00001c1c, 0x0d002d14,   // blu.un.un_600 bh.hi.un_330  id.un.un_800 sk.cs.un_660
  // [0170]
  0x00000642, 0x19000a02, 0x08000236, 0x00002737,   // de.un.un_C00 pt.gl.un_220  da.no.un_AA0 gd.un.un_B00
  0x09000d02, 0x00006424, 0x0a000b35, 0x0000251c,   // ne.hi.un_220 lg.un.un_900  es.pt.un_A90 eu.un.un_800
  0x02000822, 0x00000901, 0x00000801, 0x00000a37,   // no.da.un_870 pl.un.un_200  uk.un.un_200 mk.un.un_B00
  0x00001124, 0x00000b15, 0x0b001921, 0x16001734,   // ro.un.un_900 bn.un.un_700  gl.es.un_860 sr.hr.un_A80
  // [0180]
  0x0d002d1a, 0x2d000d02, 0x00001703, 0x00001801,   // sk.cs.un_760 cs.sk.un_220  sr.un.un_300 ga.un.un_200
  0x0000181c, 0x1700161b, 0x00006b42, 0x00000a03,   // ga.un.un_800 hr.sr.un_770  ceb.un.un_C00 mk.un.un_300
  0x19000a2b, 0x1e001c23, 0x0000040f, 0x1c001e34,   // pt.gl.un_980 id.ms.un_880  ru.un.un_600 ms.id.un_A80
  0x00001303, 0x0000080f, 0x00002b15, 0x00000324,   // et.un.un_300 uk.un.un_600  vi.un.un_700 nl.un.un_900
  // [0190]
  0x00006401, 0x00001e06, 0x00001924, 0x19000b23,   // lg.un.un_200 ms.un.un_400  gl.un.un_900 es.gl.un_880
  0x0000550a, 0x0a001936, 0x0000640f, 0x00000f06,   // rw.un.un_500 gl.pt.un_AA0  lg.un.un_600 lv.un.un_400
  0x1300092c, 0x17001635, 0x1700161a, 0x09000d04,   // hi.bh.un_990 hr.sr.un_A90  hr.sr.un_760 ne.hi.un_320
  0x08000214, 0x0000fe06, 0x00002303, 0x09001c13,   // da.no.un_660 tlh.un.un_400  ca.un.un_300 mr.hi.un_650
  // [01a0]
  0x00006b01, 0x0000052d, 0x00002706, 0x19000b36,   // ceb.un.un_200 fr.un.un_A00  gd.un.un_400 es.gl.un_AA0
  0x00001824, 0x17001622, 0x00000524, 0x00001603,   // ga.un.un_900 hr.sr.un_870  fr.un.un_900 hr.un.un_300
  0x1c001302, 0x0b000a02, 0x0b000a36, 0x0000250f,   // bh.mr.un_220 pt.es.un_220  pt.es.un_AA0 eu.un.un_600
  0x00001a03, 0x00000d0f, 0x00002503, 0x00003f06,   // tl.un.un_300 ne.un.un_600  eu.un.un_300 af.un.un_400
  // [01b0]
  0x0000161c, 0x00001a06, 0x00001a0a, 0x0d002d09,   // hr.un.un_800 tl.un.un_400  tl.un.un_500 sk.cs.un_440
  0x0b00192a, 0x2d000d12, 0x1600171a, 0x17001634,   // gl.es.un_970 cs.sk.un_640  sr.hr.un_760 hr.sr.un_A80
  0x0b00191a, 0x00002d42, 0x00005324, 0x09000d0e,   // gl.es.un_760 sk.un.un_C00  ht.un.un_900 ne.hi.un_550
  0x0000252d, 0x19000a23, 0x0000122d, 0x00002824,   // eu.un.un_A00 pt.gl.un_880  ur.un.un_A00 sw.un.un_900
  // [01c0]
  0x00001e24, 0x2d000d1b, 0x0800022c, 0x2d000d14,   // ms.un.un_900 cs.sk.un_770  da.no.un_990 cs.sk.un_660
  0x00000e15, 0x19000b2c, 0x0a00191b, 0x00000d0a,   // is.un.un_700 es.gl.un_990  gl.pt.un_770 cs.un.un_500
  0x1c000914, 0x0d000913, 0x00001006, 0x0a001922,   // hi.mr.un_660 hi.ne.un_650  lt.un.un_400 gl.pt.un_870
  0x1700162c, 0x08000223, 0x0b000a08, 0x0b000a1b,   // hr.sr.un_990 da.no.un_880  pt.es.un_430 pt.es.un_770
  // [01d0]
  0x00001b1c, 0x0000240a, 0x0d002d1b, 0x19000b14,   // tr.un.un_800 yi.un.un_500  sk.cs.un_770 es.gl.un_660
  0x13000919, 0x00001c03, 0x17001604, 0x0000070a,   // hi.bh.un_750 id.un.un_300  hr.sr.un_320 bg.un.un_500
  0x0000032d, 0x2d000d36, 0x00003101, 0x0000160f,   // nl.un.un_A00 cs.sk.un_AA0  az.un.un_200 hr.un.un_600
  0x00001103, 0x1c001e05, 0x09000d14, 0x00002a1c,   // ro.un.un_300 ms.id.un_330  ne.hi.un_660 mt.un.un_800
  // [01e0]
  0x00000637, 0x1e001c05, 0x1e001c1b, 0x00003f1c,   // de.un.un_B00 id.ms.un_330  id.ms.un_770 af.un.un_800
  0x00000706, 0x0a00190c, 0x13000923, 0x0d002d02,   // bg.un.un_400 gl.pt.un_530  hi.bh.un_880 sk.cs.un_220
  0x1600171b, 0x1c00130e, 0x0000100a, 0x00002537,   // sr.hr.un_770 bh.mr.un_550  lt.un.un_500 eu.un.un_B00
  0x1e001c08, 0x00000615, 0x00001f24, 0x00002903,   // id.ms.un_430 de.un.un_700  cy.un.un_900 sl.un.un_300
  // [01f0]
  0x00002d1c, 0x1c001e36, 0x00005503, 0x00001024,   // sk.un.un_800 ms.id.un_AA0  rw.un.un_300 be.un.un_900
  0x0000272d, 0x0800021b, 0x00000a01, 0x00001a01,   // gd.un.un_A00 da.no.un_770  mk.un.un_200 tl.un.un_200
  0x13000902, 0x00000403, 0x1000062c, 0x0a001923,   // hi.bh.un_220 ru.un.un_300  de.lt.un_990 gl.pt.un_880
  0x00001937, 0x00002915, 0x09001c1a, 0x0a000b34,   // gl.un.un_B00 sl.un.un_700  mr.hi.un_760 es.pt.un_A80
  // [0200]
  0x00001106, 0x1c001e08, 0x0000062d, 0x00000c37,   // ro.un.un_400 ms.id.un_430  de.un.un_A00 sv.un.un_B00
  0x0000170f, 0x00002d01, 0x00001615, 0x09000d08,   // sr.un.un_600 sk.un.un_200  hr.un.un_700 ne.hi.un_430
  0x00006e03, 0x00000101, 0x00000106, 0x19000a1b,   // blu.un.un_300 en.un.un_200  en.un.un_400 pt.gl.un_770
  0x00001637, 0x09001c02, 0x00006e1c, 0x2d000d13,   // hr.un.un_B00 mr.hi.un_220  blu.un.un_800 cs.sk.un_650
  // [0210]
  0x1c001323, 0x0000310f, 0x1e001c0e, 0x00001e01,   // bh.mr.un_880 az.un.un_600  id.ms.un_550 ms.un.un_200
  0x00000a0a, 0x00001206, 0x16001722, 0x0b000a34,   // mk.un.un_500 ur.un.un_400  sr.hr.un_870 pt.es.un_A80
  0x2d000d2c, 0x00001f37, 0x00001b03, 0x0a00192b,   // cs.sk.un_990 cy.un.un_B00  tr.un.un_300 gl.pt.un_980
  0x00002d37, 0x00001e2d, 0x00005501, 0x00000b37,   // sk.un.un_B00 ms.un.un_A00  rw.un.un_200 es.un.un_B00
  // [0220]
  0x0000270a, 0x09001c1b, 0x1c00131b, 0x0000531c,   // gd.un.un_500 mr.hi.un_770  bh.mr.un_770 ht.un.un_800
  0x1c001e22, 0x1c001e2b, 0x00002d24, 0x00000b24,   // ms.id.un_870 ms.id.un_980  sk.un.un_900 es.un.un_900
  0x0000270f, 0x00001101, 0x00002024, 0x09001309,   // gd.un.un_600 ro.un.un_200  sq.un.un_900 bh.hi.un_440
  0x0000fe0a, 0x0b00191b, 0x00002724, 0x00001e0f,   // tlh.un.un_500 gl.es.un_770  gd.un.un_900 ms.un.un_600
  // [0230]
  0x00002701, 0x1c000912, 0x0b001935, 0x00001903,   // gd.un.un_200 hi.mr.un_640  gl.es.un_A90 gl.un.un_300
  0x0000182d, 0x00000d37, 0x00001201, 0x0a001934,   // ga.un.un_A00 cs.un.un_B00  hu.un.un_200 gl.pt.un_A80
  0x0b00192c, 0x00002d03, 0x02000809, 0x00000e0a,   // gl.es.un_990 sk.un.un_300  no.da.un_440 is.un.un_500
  0x00006b0f, 0x00002a01, 0x0000171c, 0x00000e24,   // ceb.un.un_600 mt.un.un_200  sr.un.un_800 is.un.un_900
  // [0240]
  0x00002d06, 0x00001e15, 0x0a001908, 0x00000a24,   // sk.un.un_400 ms.un.un_700  gl.pt.un_430 mk.un.un_900
  0x0b001936, 0x00000f2d, 0x16001719, 0x00001f0a,   // gl.es.un_AA0 lv.un.un_A00  sr.hr.un_750 cy.un.un_500
  0x00001b0a, 0x19000a0e, 0x02000823, 0x00000c0f,   // tr.un.un_500 pt.gl.un_550  no.da.un_880 sv.un.un_600
  0x0d002d34, 0x16001702, 0x0a00191a, 0x16001704,   // sk.cs.un_A80 sr.hr.un_220  gl.pt.un_760 sr.hr.un_320
  // [0250]
  0x00003124, 0x00002a06, 0x0000191c, 0x00002901,   // az.un.un_900 mt.un.un_400  gl.un.un_800 sl.un.un_200
  0x13001c14, 0x00000237, 0x09000d2b, 0x00000e01,   // mr.bh.un_660 da.un.un_B00  ne.hi.un_980 is.un.un_200
  0x00002a0a, 0x1c000d14, 0x1e001c2b, 0x00001e03,   // mt.un.un_500 ne.mr.un_660  id.ms.un_980 ms.un.un_300
  0x1c001e0e, 0x00002937, 0x08000208, 0x0a00192a,   // ms.id.un_550 sl.un.un_B00  da.no.un_430 gl.pt.un_970
  // [0260]
  0x00001224, 0x00002d2d, 0x09001312, 0x1c001e04,   // hu.un.un_900 sk.un.un_A00  bh.hi.un_640 ms.id.un_320
  0x00000a06, 0x00001901, 0x0a000b36, 0x09000d1b,   // mk.un.un_400 gl.un.un_200  es.pt.un_AA0 ne.hi.un_770
  0x00000506, 0x0800021a, 0x00002a03, 0x1600172c,   // fr.un.un_400 da.no.un_760  mt.un.un_300 sr.hr.un_990
  0x0a000b05, 0x00001601, 0x00000206, 0x02000804,   // es.pt.un_330 hr.un.un_200  da.un.un_400 no.da.un_320
  // [0270]
  0x08000222, 0x00000d2d, 0x0b001923, 0x2d000d1a,   // da.no.un_870 cs.un.un_A00  gl.es.un_880 cs.sk.un_760
  0x0000280f, 0x00000d24, 0x0000022d, 0x09000d13,   // sw.un.un_600 cs.un.un_900  da.un.un_A00 ne.hi.un_650
  0x1c001313, 0x1c000d0e, 0x19000a19, 0x08000235,   // bh.mr.un_650 ne.mr.un_550  pt.gl.un_750 da.no.un_A90
  0x02000836, 0x00003f0f, 0x09001304, 0x00005303,   // no.da.un_AA0 af.un.un_600  bh.hi.un_320 ht.un.un_300
  // [0280]
  0x19000b2b, 0x1c00130d, 0x02000835, 0x0000200a,   // es.gl.un_980 bh.mr.un_540  no.da.un_A90 sq.un.un_500
  0x1600170e, 0x16001708, 0x09000d05, 0x0b001914,   // sr.hr.un_550 sr.hr.un_430  ne.hi.un_330 gl.es.un_660
  0x19000b0e, 0x1c001e21, 0x08000209, 0x00000b03,   // es.gl.un_550 ms.id.un_860  da.no.un_440 es.un.un_300
  0x00002101, 0x00000b06, 0x0b000a09, 0x1c000d35,   // jw.un.un_200 es.un.un_400  pt.es.un_440 ne.mr.un_A90
  // [0290]
  0x13000907, 0x0a000b1a, 0x0000180a, 0x2d000d34,   // hi.bh.un_420 es.pt.un_760  ga.un.un_500 cs.sk.un_A80
  0x1700160e, 0x0200082c, 0x0a001921, 0x19000b19,   // hr.sr.un_550 no.da.un_990  gl.pt.un_860 es.gl.un_750
  0x0000310a, 0x0b000a22, 0x00000c01, 0x2d000d21,   // az.un.un_500 pt.es.un_870  sv.un.un_200 cs.sk.un_860
  0x00000301, 0x1c000923, 0x00003106, 0x1c00091b,   // nl.un.un_200 hi.mr.un_880  az.un.un_400 hi.mr.un_770
  // [02a0]
  0x00001c06, 0x0000202d, 0x0b000a35, 0x09000d19,   // id.un.un_400 sq.un.un_A00  pt.es.un_A90 ne.hi.un_750
  0x0900132a, 0x00000f37, 0x00000501, 0x09001319,   // bh.hi.un_970 lv.un.un_B00  fr.un.un_200 bh.hi.un_750
  0x13000913, 0x0000170a, 0x19000a35, 0x2d000d09,   // hi.bh.un_650 sr.un.un_500  pt.gl.un_A90 cs.sk.un_440
  0x1e001c1a, 0x19000a09, 0x0a000b2b, 0x0000010a,   // id.ms.un_760 pt.gl.un_440  es.pt.un_980 en.un.un_500
  // [02b0]
  0x00000203, 0x00002806, 0x00000103, 0x0000060a,   // da.un.un_300 sw.un.un_400  en.un.un_300 de.un.un_500
  0x17001619, 0x13000905, 0x0000250a, 0x0d002d22,   // hr.sr.un_750 hi.bh.un_330  eu.un.un_500 sk.cs.un_870
  0x19000a21, 0x00006b06, 0x0d000904, 0x0a000b19,   // pt.gl.un_860 ceb.un.un_400  hi.ne.un_320 es.pt.un_750
  0x1c001e13, 0x17001621, 0x09001335, 0x2d000d19,   // ms.id.un_650 hr.sr.un_860  bh.hi.un_A90 cs.sk.un_750
  // [02c0]
  0x1300091a, 0x09001336, 0x00000303, 0x00002337,   // hi.bh.un_760 bh.hi.un_AA0  nl.un.un_300 ca.un.un_B00
  0x1c000d07, 0x09001c04, 0x09000d23, 0x0200082a,   // ne.mr.un_420 mr.hi.un_320  ne.hi.un_880 no.da.un_970
  0x19000b09, 0x00000c06, 0x00002006, 0x0d00091a,   // es.gl.un_440 sv.un.un_400  sq.un.un_400 hi.ne.un_760
  0x0d001314, 0x19000a05, 0x0000162d, 0x1c000913,   // bh.ne.un_660 pt.gl.un_330  hr.un.un_A00 hi.mr.un_650
  // [02d0]
  0x00002401, 0x1600172b, 0x0a001907, 0x0000190f,   // yi.un.un_200 sr.hr.un_980  gl.pt.un_420 gl.un.un_600
  0x09001302, 0x19000b02, 0x1e001c07, 0x1c001334,   // bh.hi.un_220 es.gl.un_220  id.ms.un_420 bh.mr.un_A80
  0x00000f01, 0x13000d1b, 0x0900131b, 0x0900130c,   // lv.un.un_200 ne.bh.un_770  bh.hi.un_770 bh.hi.un_530
  0x0000280a, 0x0b001908, 0x0a000b1b, 0x0000fe0f,   // sw.un.un_500 gl.es.un_430  es.pt.un_770 tlh.un.un_600
  // [02e0]
  0x17001613, 0x19000a2a, 0x1c001335, 0x1e001c22,   // hr.sr.un_650 pt.gl.un_970  bh.mr.un_A90 id.ms.un_870
  0x09001323, 0x0a00192c, 0x00002506, 0x0b00192b,   // bh.hi.un_880 gl.pt.un_990  eu.un.un_400 gl.es.un_980
  0x00001515, 0x02000819, 0x1e001c04, 0x00001806,   // un.un.un_700 no.da.un_750  id.ms.un_320 ga.un.un_400
  0x00006406, 0x16001736, 0x19000b05, 0x09000d1a,   // lg.un.un_400 sr.hr.un_AA0  es.gl.un_330 ne.hi.un_760
  // [02f0]
  0x00000306, 0x16001713, 0x08000219, 0x0d001c0e,   // nl.un.un_400 sr.hr.un_650  da.no.un_750 mr.ne.un_550
  0x0800020d, 0x2d000d04, 0x17001608, 0x13000934,   // da.no.un_540 cs.sk.un_320  hr.sr.un_430 hi.bh.un_A80
  0x09000d07, 0x1e001c12, 0x00000906, 0x1c001e07,   // ne.hi.un_420 id.ms.un_640  hi.un.un_400 ms.id.un_420
  0x2d000d0e, 0x00002306, 0x2d000d08, 0x0b000a2c,   // cs.sk.un_550 ca.un.un_400  cs.sk.un_430 pt.es.un_990
  // [0300]
  0x1c001309, 0x09001c36, 0x0000160a, 0x1c000d05,   // bh.mr.un_440 mr.hi.un_AA0  hr.un.un_500 ne.mr.un_330
  0x09001c19, 0x00002703, 0x0a001935, 0x09001c0e,   // mr.hi.un_750 gd.un.un_300  gl.pt.un_A90 mr.hi.un_550
  0x1c000d36, 0x0d000914, 0x0d002d13, 0x0d000923,   // ne.mr.un_AA0 hi.ne.un_660  sk.cs.un_650 hi.ne.un_880
  0x0a001904, 0x09000d36, 0x0a000b04, 0x0d002d35,   // gl.pt.un_320 ne.hi.un_AA0  es.pt.un_320 sk.cs.un_A90
  // [0310]
  0x0a000b21, 0x13000d21, 0x1e001c0d, 0x00002b0f,   // es.pt.un_860 ne.bh.un_860  id.ms.un_540 vi.un.un_600
  0x17001614, 0x00000f0a, 0x19000a34, 0x19000b22,   // hr.sr.un_660 lv.un.un_500  pt.gl.un_A80 es.gl.un_870
  0x1c001e19, 0x17001612, 0x08000213, 0x00001203,   // ms.id.un_750 hr.sr.un_640  da.no.un_650 hu.un.un_300
  0x13000d07, 0x0d001323, 0x08000204, 0x19000b34,   // ne.bh.un_420 bh.ne.un_880  da.no.un_320 es.gl.un_A80
  // [0320]
  0x0b00272b, 0x0d002d19, 0x0d000905, 0x1c000d23,   // gd.es.un_980 sk.cs.un_750  hi.ne.un_330 ne.mr.un_880
  0x0d00091b, 0x09000d12, 0x13000935, 0x0b00190d,   // hi.ne.un_770 ne.hi.un_640  hi.bh.un_A90 gl.es.un_540
  0x09001313, 0x1600170d, 0x00001906, 0x1e001c21,   // bh.hi.un_650 sr.hr.un_540  gl.un.un_400 id.ms.un_860
  0x0d002d21, 0x1c001305, 0x0000192d, 0x00001915,   // sk.cs.un_860 bh.mr.un_330  gl.un.un_A00 gl.un.un_700
  // [0330]
  0x00002b01, 0x09001307, 0x00000606, 0x0a000b09,   // vi.un.un_200 bh.hi.un_420  de.un.un_400 es.pt.un_440
  0x0a000b14, 0x0d001c1a, 0x00006403, 0x00002906,   // es.pt.un_660 mr.ne.un_760  lg.un.un_300 sl.un.un_400
  0x0000050a, 0x0800020e, 0x0a001905, 0x13000d02,   // fr.un.un_500 da.no.un_550  gl.pt.un_330 ne.bh.un_220
  0x19000a08, 0x19000a1a, 0x1c000905, 0x0a000b2c,   // pt.gl.un_430 pt.gl.un_760  hi.mr.un_330 es.pt.un_990
  // [0340]
  0x0d002d36, 0x13001c1b, 0x0a000b22, 0x16001707,   // sk.cs.un_AA0 mr.bh.un_770  es.pt.un_870 sr.hr.un_420
  0x2d000d35, 0x19000a14, 0x19000a22, 0x1600170c,   // cs.sk.un_A90 pt.gl.un_660  pt.gl.un_870 sr.hr.un_530
  0x0d002d12, 0x0b000a19, 0x13000904, 0x00006e0a,   // sk.cs.un_640 pt.es.un_750  hi.bh.un_320 blu.un.un_500
  0x00000137, 0x1c00132c, 0x1c001312, 0x0a000b23,   // en.un.un_B00 bh.mr.un_990  bh.mr.un_640 es.pt.un_880
  // [0350]
  0x1c000d1a, 0x0d002d2c, 0x13001c34, 0x0d001c13,   // ne.mr.un_760 sk.cs.un_990  mr.bh.un_A80 mr.ne.un_650
  0x0b190ed4, 0x19000b35, 0x00000e03, 0x13000909,   // is.gl.es_B42 es.gl.un_A90  is.un.un_300 hi.bh.un_440
  0x16001705, 0x0000012d, 0x0d001c14, 0x0b001934,   // sr.hr.un_330 en.un.un_A00  mr.ne.un_660 gl.es.un_A80
  0x0b000a14, 0x0a000b02, 0x00001b06, 0x00000603,   // pt.es.un_660 es.pt.un_220  tr.un.un_400 de.un.un_300
  // [0360] --- double_langprob_start=0363 ---
  0x02000808, 0x08000234, 0x0d000935,               // no.da.un_430 da.no.un_A80  hi.ne.un_A90
                                                    //
  };

//  COMPILE_ASSERT(867 < (1 << 12), k_indirectbits_too_small);

extern const CLD2TableSummary kDeltaOcta_obj = {
  kDeltaOctaChrome0614,
  kDeltaOctaChrome0614Ind,
  kDeltaOctaChrome0614SizeOne,
  kDeltaOctaChrome0614Size,
  kDeltaOctaChrome0614KeyMask,
  kDeltaOctaChrome0614BuildDate,
  kDeltaOctaChrome0614RecognizedLangScripts,
};

}       // End namespace CLD2

// End of generated tables
